addContent("US", "en", {
  "DEMemberGuest": {
    "bankTitle": "Pay with direct debit",
    "cardTitle": "Pay with credit card",
    "sepaTitle": "Direct debit agreement",
    "payWith": "Pay with",
    "shipTo": "Ship to my billing address",
    "billingAddress": "Billing address",
    "propHead": "Serious about security",
    "payWithDesc": "Processed by PayPal on behalf of the merchant.",
    "propVal": "Your financial details are encrypted to protect you from fraud, so you can shop with confidence.",
    "ddAgreementHead": "Direct debit agreement",
    "ddAgreementPara1": "European guidelines require that you accept SEPA Mandate in order to process your payment. This way banks are enabled to process your payment faster and more efficient.",
    "ddAgreementPara2": "By clicking \"Accept and continue\" you agree to the <input type=\"submit\" id=\"viewSEPAAgreement\" class=\"button-as-link sepaLink\" value=\"SEPA direct debit mandate\"/> and authorize PayPal to send instructions to your bank account. You also authorize your bank to debit your account in accordance with the instructios from PayPal. A refund must be claimed within 8 weeks starting from the date on which your account was debited.",
    "ddAgreementPara2WithoutLink": "By clicking \"Accept and continue\" you agree to the SEPA direct debit mandate and authorize PayPal to send instructions to your bank account. You also authorize your bank to debit your account in accordance with the instructios from PayPal. A refund must be claimed within 8 weeks starting from the date on which your account was debited.",
    "accountCarrier": "Account carrier",
    "IBAN": "IBAN",
    "bankName": "Bank Name",
    "bic": "BIC",
    "creditor": "Creditor",
    "creditorId": "Creditor ID",
    "id": "ID",
    "countryDE": "Germany",
    "payAndCreate": "Pay and create account",
    "guestAccountCreationHeader": "Thousands of online shops - one password!",
    "signupOptIn": "Yes! I’d like to create a PayPal account.",
    "guestAccountCreationPara1": "From now on pay with your email address and password - no need to provide your payment details every time.",
    "guestAccountCreationPara2": "Yes, I agree with the terms of use and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>terms and conditions</a> of PayPal's <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/marketingweb?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>information security</a> and accept an <a class=popup xo-popup target=_blank href=\"https://www.paypal.com/de/cgi-bin/merchantpaymentweb?cmd=xpt/Marketing/popup/UnconfirmedELV-outside\" target=\"_blank\">identity check</a>.",
    "acAgreePara1": "Congratulations! Your PayPal account will be created. From now on shop with confidence, knowing your financial information is secure.",
    "acAgreePara2": "You'll receive an email containing further information about our service.",
    "acAgreePara3": "I am of legal age, I have read, consent and agree to PayPal's <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a> and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/marketingweb?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a> (including processing and disclosing my personal data) and a <a class=popup xo-popup target=_blank href=https://www.paypal.com/de/identitycheck>credit check</a>. I understand that I can change my communication preferences any time.",
    "acAgreePara3CC": "I am of legal age, I have read, consent and agree to PayPal's <a class=popuphref=https://cms.paypal.com/de/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_DE>User Agreement</a> and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/marketingweb?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_DE>Privacy Statement</a> (including processing and disclosing my personal data). I understand that I can change my communication preferences any time.",
    "finalizePaymentHeader": "Finalize Payment",
    "finalizePaymentPara": "By clicking Pay now you agree with PayPal's <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a> and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a> and accept a <a class=popup xo-popup target=_blank href=https://www.paypal.com/de/identitycheck>credit check</a>.",
    "payNow": "Pay now",
    "agreementDateFormat": "{agreeDate}, {agreeCity}, {agreeCountry}",
    "agreeBtn": "Accept and continue",
    "accntTermsHd": "Finalize payment",
    "guestTermsPara": "By clicking Pay now you agree with the terms of use and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>terms and conditions</a> of PayPal’s information security and accept an <a class=popup xo-popup target=_blank href=\"https://www.paypal.com/de/cgi-bin/merchantpaymentweb?cmd=xpt/Marketing/popup/UnconfirmedELV-outside\" target=\"_blank\">identity check</a>.",
    "guestTermsParaCC": "By clicking Pay now you agree with the terms of use and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/de/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>terms and conditions</a> of PayPal’s information security.",
    "payNowBtn": "Pay now",
    "account": "Account number",
    "accountPlaceholder": "Account number (1-10 digits)",
    "dob": "Date of birth",
    "dobPlaceholder": "DD.MM.YYYY",
    "sort": "Sort code",
    "sortPlaceholder": "Sort code (8 digits)",
    "password": "Password",
    "cpassword": "Confirm password",
    "continue": "Continue",
    "cardsTitle": "Credit cards",
    "addCC": "Add credit card",
    "addBank": "Add bank",
    "cancelBtn": "Cancel",
    "useMeftInstead": "You can also use mEFT to complete your payment. You will need to go to your bank to complete the purchase and it could take 1-2 days.",
    "useMeftBtn": "Use mEFT",
    "meftAddCardHeaderMsg": "Add a card to complete your payment",
    "meftAddCardpropMsg": "It will just take a minute, and we'll send the payment without sharing your financial information with the merchant and store it securely in your account.",
    "meftDeclinePageErrorMsg": "Sorry, we couldn't complete your payment. Pay now with a credit card or complete a manual bank transfer.",
    "ELVRejectedWithCCAlt": "Unfortunately we can not process this payment via ELV. Please use your Credit Card instead."
  },
  "accountCreationGuest": {
    "heading": "Create a PayPal account!",
    "vprop": "When you pay using your PayPal account, the merchant doesn't see your financial information.",
    "vprop1": "Join the millions of people who rely on our security and convenience, online and in stores.",
    "password": "Create password",
    "cpassword": "Confirm password",
    "createPassword": "Create password",
    "optionalHeading": "Create an account and check out faster",
    "optionalProp": "One convenient, secure place to keep all your ways to pay. PayPal doesn't share your financial information with merchants",
    "signupProp": "One convenient, secure place to keep all your ways to pay. PayPal doesn't share your financial information with merchants",
    "signupOptIn": "Yes! I’d like to create a PayPal account.",
    "yourLoginId": "(your login ID)",
    "payLabel": "Pay Now",
    "continueLabel": "Continue"
  },
  "Captcha": {
    "lblSecurityCode": "Enter the code",
    "showNewCode": "Show a new code",
    "listenCode": "Listen to the code",
    "altTextCaptchaImg": "CAPTCHA code",
    "title": "Security check"
  },
  "twofa": {
    "getCodeTitle": "Get a security code",
    "enterCodeTitle": "Enter a security code",
    "phoneLabel": "Mobile phone:",
    "continueLabel": "Continue",
    "sixDigitCode": "6-digit security code",
    "noSecurityKey": "Don't have your Security Key with you?",
    "getHelp": "Get help",
    "didntGetMessage": "Didn't get the text message?",
    "sentAgain": "Send it again",
    "invalidCode": "Please check the code and re-enter"
  },
  "addBank": {
    "link": "Add a bank instead",
    "transition": "We'll open a new tab so you can add your bank details. When you're done return to this screen complete your payment.",
    "addCardLink": "I'll add a card instead",
    "continue": "Continue"
  },
  "addBillingAddress": {
    "title": "Add a billing address"
  },
  "OpinionLab": {
    "SiteFeedback": "Feedback",
    "CheckoutFeedback": "Checkout Feedback"
  },
  "addCard": {
    "updateCard": "Update or add a card",
    "addACard": "Add a card",
    "useCard": "Use card",
    "addPaymentMethod": "Add a payment method",
    "addNewBillingAddress": "Add new billing address",
    "primary": "Make Primary",
    "updatePropHead": "Looks like your card expired",
    "updatePropVal": "It will only take a minute to update your card, and then you can complete your purchase. Remember, we don't share your financial information with the merchant.",
    "disallowedPropHead": "Add flexibility to your wallet",
    "disallowedPropVal": "Looks like the merchant doesn't accept the card you have in your PayPal wallet. Why not add another debit or credit card to make sure you’re covered for this and future payments? It will just take a minute, and then we’ll send the payment without sharing your financial information with the merchant.",
    "declinePropHead": "Add a debit or credit card to complete your payment",
    "declinePropVal": "We weren't able to use the card you have in your PayPal wallet. Please add another card to complete your payment. It will just take a minute, and we’ll send the payment without sharing your financial information with the merchant.",
    "addCardPropHead": "Hello!",
    "addCardPropVal": "Looks like you might be new to PayPal. To complete your payment, you'll need to add a debit or credit card. We’ll send the payment without sharing your financial information with the merchant.",
    "micaAddCard": "Pay with a debit or credit card",
    "plccAddCard": "{merchant} Debit or Credit Card",
    "plccPreferMethod": "My preferred payment method for {merchant}",
    "plccLegal": "When you use this card we'll let {merchant} know so they can determine any rewards or discounts.",
    "plccSelectIncentive": "Add your card now to begin earning rewards.",
    "addTopupDebitCard": "Add a debit card for automatic top up. (We'll only top up your PayPal Cash or Cash Plus balance when you're shopping with Google Pay.)",
    "commonAddTopupDebitCard": "Add a debit card for automatic top up. (We'll only top up your PayPal Cash or Cash Plus balance when you're shopping with {type}.)",
    "makeFiPreferred": "Make this preferred when paying online",
    "makeFiPreferredLegal": "We'll use this when you shop or send money for goods and services.",
    "learnMore": "<a class=popup xo-popup target=_blank href=/myaccount/money/choice/learn-more>Learn more</a>",
    "assistHeader": "Add a debit or credit card to complete your purchase",
    "assistBody": "We'll save it to your account so you'll have it handy when you shop at any of the millions of merchants where PayPal is available.",
    "billingAddress": "Billing Address",
    "switchCard": "Use a different debit or credit card",
    "assistHeaderHasDisallowedFi": "Please add a card to complete your payment.",
    "assistBodySingleDisallowedFi": "The payment method in your PayPal account can’t be used for this purchase.",
    "assistBodyMultiDisallowedFi": "The payment methods in your PayPal account can’t be used for this purchase.",
    "addBank": "Add a bank instead",
    "linkBank": "Link a bank instead",
    "nmjHeaderMsgNoFiShowAddBank": "Hi, {userName}. Add a card or bank to complete your payment.",
    "nmjHeaderMsgHasDisallowedShowBankLink": "Hi, {userName}. The payment method you have in your PayPal account can’t be used for this purchase. Add a card or bank to complete your payment.",
    "nmjHeaderMsgHasDisallowedHideBankLink": "Hi, {userName}. The payment method you have in your PayPal account can’t be used for this purchase. Add a debit or credit card to complete your payment.",
    "nmjHeaderMsgHasMultiDisallowedShowBankLink": "Hi, {userName}. The payment methods you have in your PayPal account can’t be used for this purchase. Add a card or bank to complete your payment.",
    "nmjHeaderMsgHasMultiDisallowedHideBankLink": "Hi, {userName}. The payment methods you have in your PayPal account can’t be used for this purchase. Add a debit or credit card to complete your payment.",
    "nmjHeaderMsgExpiredCard": "Hi, {userName}. Your card has expired. Please update it or add a debit or credit card to complete your payment.",
    "titleCPAfailure": "Add a debit, credit, or prepaid card",
    "updateCardCPA": "Update your card",
    "updateCardCPASuccess": "Your card is ready to use.",
    "addBankDebitCard": "Add a bank debit card",
    "creditCardNotAllowed": "Add a bank debit card to pay. Credit cards can't be used for this transaction."
  },
  "addcard": {
    "nmjHeaderMsgNoFiHideAddBank": "Hi, {userName}. Add a debit or credit card to complete your payment."
  },
  "addCardFIErrors": {
    "AUTHORIZATION_FAILED": "Sorry, something went wrong. Try again later or choose another way to pay.",
    "CARD_BRAND_NOT_SUPPORTED_MEMBER": "This card type can’t be used for your payment or added to your PayPal account. Try a different card.",
    "CARD_BRAND_NOT_SUPPORTED_GUEST": "Sorry, this card isn’t supported. Try a different card.",
    "CARD_NOT_ALLOWED_MEMBER": "This card can’t be used for your payment or added to your PayPal account. Try a different card.",
    "CARD_NOT_ALLOWED_GUEST": "This card type can’t be used for your payment. Try a different card.",
    "CARD_NUMBER_WITH_BAD_BIN_MEMBER": "This card can’t be used for your payment or added to your PayPal account. Try a different card.",
    "CARD_NUMBER_WITH_BAD_BIN_GUEST": "This card can’t be used for your payment. Try a different card.",
    "CUP_CARD_MEMBER": "Sorry, this card can’t be used for your payment or added to your PayPal account. Try a different card.",
    "CUP_CARD_GUEST": "Sorry, this card can’t be used for your payment. Try a different card.",
    "COUNTRY_NOT_SUPPORTED": "Sorry, this card isn’t supported. Try a different card.",
    "DEBIT_CARD_NOT_ACCEPTED": "This debit card can’t be added to your account. Try a different card.",
    "EXPIRED_CARD": "Check the expiration date and try again, or contact your card issuer with questions.",
    "INSTRUMENT_ALREADY_EXISTS": "You already added this card to your account. Try a different card.",
    "INSTRUMENT_BLOCKED": "This card can’t be used for your payment or added to your account. Try a different card.",
    "INSTRUMENT_COUNT_LIMIT_EXCEEDED": "You already have the maximum number of cards in your PayPal account. Remove a card and try again.",
    "INSTRUMENT_COUNT_LIMIT_EXCEEDED_VERIFIED": "Sorry, there’s a limit to how many cards you can add to your account. To add this card, remove another card first.",
    "INSTRUMENT_MULTIPLE_REGISTERED": "This card is linked to other PayPal accounts. Please remove the card from one account or try a different payment method.",
    "INSTRUMENT_NOT_FOUND": "Sorry, we weren’t able to add this card. Return to the merchant and try again.",
    "INSTRUMENT_SHARING_LIMIT_EXCEEDED": "This card has already been added to another PayPal account. Remove the card from the other account first, or try a different card.",
    "ISSUER_DECLINE": "Your card was declined by the issuing bank. Try a different card or contact your card issuer with questions.",
    "INTERNAL_ERROR": "Sorry, something went wrong. Please try again.",
    "MIGRATION_NOT_SUPPORTED": "We weren’t able to add your card. Try a different card.",
    "REJECT_DUAL_CARD": "Sorry, this card can’t be used for this payment or added to your account. Try a different card.",
    "REJECT_EXTERNAL_CARD_PAYPAL_BALANCE": "Sorry, we weren’t able to add this card. Try a different card.",
    "REJECT_PAYPAL_CARD": "Sorry, we weren’t able to add this card. Try a different card.",
    "RISK_DENIED": "Your card was declined. Try a different card.",
    "RISK_DENIED_DUE_TO_INSTRUMENT_COUNT_LIMIT_EXCEEDED": "You already have the maximum number of cards in your PayPal account. Remove a card and try again.",
    "UNAUTHORIZED": "This card can’t be used for your payment or added to your PayPal account. Try a different card.",
    "USER_ACCOUNT_CLOSED": "This account is closed. You can try to add this card to a different account, or open a new PayPal account.",
    "USER_ACCOUNT_LIMITED": "There’s a problem with your account. Please go to the Resolution Center so we can help you resolve this quickly.",
    "VALIDATION_ERROR_ACTOR": "Sorry, you can’t use this card. Choose another way to pay.",
    "VALIDATION_ERROR_BILLING_ADDRESS": "Check the billing address for your card and try again.",
    "VALIDATION_ERROR_BIN": "Sorry, this card is invalid. Try a different card.",
    "VALIDATION_ERROR_CARD": "Invalid card number. Please check the number and try again.",
    "VALIDATION_ERROR_CUP_CARD": "This card is not supported.  Please try a different payment method.",
    "VALIDATION_ERROR_CVV": "Check the security code and try again.",
    "VALIDATION_ERROR_DOB": "Check the date of birth and try again.",
    "VALIDATION_ERROR_EXPIRY": "Check the expiration date and try again or contact your card issuer.",
    "VALIDATION_ERROR_GENERIC": "Some of your information is invalid. Check and try again or try a different card.",
    "R_ERROR": "Your card was declined. Try a different card.",
    "R_I_ERROR": "You already have the maximum number of cards in your PayPal account. Remove a card and try again.",
    "U_ERROR": "This card can’t be used for your payment or added to your PayPal account. Try a different card."
  },
  "addFiError": {
    "cardGenericError": "Some of your information is invalid. Check and try again or try a different card.",
    "cardGenericValidationError": "Check your card details and try again.",
    "cardIssuerDecline": "Your card was declined by the issuing bank. Try a different card or contact your card issuer with questions.",
    "cardNumberInvalidFrontend": "Check the card number and try again.",
    "cardBinInvalid": "Sorry, this card is invalid. Try a different card.",
    "cardBillingAddressInvalid": "Check the billing address for your card and try again.",
    "cardCvvMissingEmpty": "Enter your card’s security code and try again.",
    "cardCvvInvalid": "Check the security code and try again.",
    "cardExpiryInvalid": "Check the expiration date and try again or contact your card issuer.",
    "cardExpiryYearInvalid": "Check the expiration date and try again.",
    "cardNumberInvalidWalletAuth": "Check your card number and try again.",
    "cardActorInvalidWalletAuth": "Sorry, you can’t use this card. Choose another way to pay.",
    "cardOnlyCupUpopAllowed": "Sorry, this card can’t be used with your PayPal account. Try a different card.",
    "cardBillingAddressMissingEmpty": "Enter the billing address for your card and try again.",
    "cardNumberInvalidBackend": "Enter a valid card number or try a different card.",
    "instrumentSharingLimitExceeded": "This card has already been added to another PayPal account. Remove the card from the other account first, or try a different card.",
    "riskDenied": "Your card was declined. Try a different card.",
    "riskDeniedInstrumentCountLimitExceeded": "You already have the maximum number of cards in your PayPal account. Remove a card and try again.",
    "instrumentBlocked": "This card can’t be used for your payment or added to your account. Try a different card.",
    "instrumentCountLimitExceeded": "You already have the maximum number of cards in your PayPal account. Remove a card and try again.",
    "expiredCard": "Check the expiration date and try again, or contact your card issuer with questions.",
    "countryNotSupported": "Sorry, this card isn’t supported. Try a different card.",
    "userAccountLimited": "There’s a problem with your account. Please go to the <a href={linkToResolutionCenter} target=_blank>Resolution Center</a> so we can help you resolve this quickly.",
    "internalError": "Sorry, something went wrong. Please try again.",
    "rejectDualCard": "Sorry, this card can’t be used for this payment or added to your account. Try a different card.",
    "rejectPaypalCard": "Sorry, we weren’t able to add this card. Try a different card.",
    "instrumentCountLimitExceededVerified": "Sorry, there’s a limit to how many cards you can add to your account. To add this card, remove another card first.",
    "unauthorized": "This card can’t be used for your payment or added to your PayPal account. Try a different card.",
    "debitCardNotAccepted": "This debit card can’t be added to your account. Try a different card.",
    "authorizationFailed": "Sorry, something went wrong. Try again later or choose another way to pay.",
    "rejectExternalCardPaypalBalance": "Sorry, we weren’t able to add this card. Try a different card.",
    "instrumentAlreadyExists": "You already added this card to your account. Try a different card.",
    "instrumentNotFound": "Sorry, we weren’t able to add this card. Return to the merchant and try again.",
    "userAccountClosed": "This account is closed. You can try to add this card to a different account, or open a new PayPal account.",
    "userAccountLocked": "This account is locked. Try to add this card to a different account or contact customer service for more information.",
    "migrationNotSupported": "We weren’t able to add your card. Try a different card.",
    "memberCardBrandNotSupported": "This card type can’t be used for your payment or added to your PayPal account. Try a different card.",
    "guestCardBrandNotSupported": "This card type can’t be used for your payment. Try a different card.",
    "memberCupCardInvalid": "Sorry, this card can’t be used for your payment or added to your PayPal account. Try a different card.",
    "guestCupCardInvalid": "Sorry, this card can’t be used for your payment. Try a different card.",
    "memberCardNotAllowed": "This card can’t be used for your payment or added to your PayPal account. Try a different card.",
    "guestCardNotAllowed": "This card can’t be used for your payment. Try a different card.",
    "memberCardNumberWithBadBin": "This card can’t be used for your payment or added to your PayPal account. Try a different card.",
    "guestCardNumberWithBadBin": "This card can’t be used for your payment. Try a different card.",
    "dobInvalid": "Check the date of birth and try again.",
    "dobMissingEmpty": "Enter your date of birth and try again.",
    "declinedNoRetry": "Sorry, your card was declined. Please add a different debit or credit card to complete your purchase.",
    "declinedNoRetryWithCardDetails": "Sorry, your <b>{cardType}-{last4}</b> was declined. Please add a different debit or credit card to complete your purchase.",
    "declinedRetry": "Sorry, your card was declined. Please try again or add a different debit or credit card to complete your purchase.",
    "declinedRetryWithCardDetails": "Sorry, your <b>{cardType}-{last4}</b> was declined. Please try again or add a different debit or credit card to complete your purchase.",
    "declinedWithBilling": "There was a problem with your <b>{cardType}-{last4}</b>. Please re-enter your card details and billing address and try again."
  },
  "addTaxId": {
    "addTaxId": "Provide Your CPF",
    "note": "For payment processing, you need to provide your CPF to update the information in your Paypal account.",
    "cpf": "CPF",
    "save": "Save",
    "labelTxt": "11 digits",
    "addTaxIdCNPJ": "Provide Your CNPJ",
    "noteCNPJ": "For payment processing, you need to provide your CNPJ to update the information in your Paypal account.",
    "cnpj": "CNPJ",
    "labelTxtCNPJ": "14 digits"
  },
  "addPhone": {
    "addPhoneNumber": "Add phone number",
    "addPhoneNumberConsent": "The merchant requires a phone number to complete your purchase.",
    "phoneDisclosure": "We may contact you with automated account related calls and texts per our <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a> and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a>. You agree you are authorized to add this number to this account.",
    "phoneConsent": "If you provide your mobile number, you give us permission to contact you about your PayPal branded accounts using automated calls or texts to: service your accounts, investigate fraud, or collect a debt, but not for telemarketing. If you don’t want to receive automated calls or texts, you can change your preferences in your account settings at any time.",
    "agreeContinue": "Agree & Continue",
    "contactInformation": "Contact Information"
  },
  "addShipping": {
    "prefferedAddress": "Use as preferred shipping address",
    "changeCountry": "Ship to another country/region",
    "addAddress": "Add address",
    "assistHeader": "Check your shipping details",
    "assistBody": "Make sure your order arrives! Is this the correct address?",
    "switchAddress": "Ship to a different address",
    "next": "Next"
  },
  "addressBook": {
    "billingAddress": "Billing address",
    "addNewBillingAddress": "Add new billing address",
    "add": "Add"
  },
  "applyForBmlUK": {
    "bmlApplyHeadline": "Apply for PayPal Credit",
    "bmlApplyHeadlineShort": "You're applying for a credit limit you can use for this and future purchases. Please read the <a class=\"submit\" href=\"{url}&_eventId_outlineOfCredit\">Outline of Credit</a> before you proceed",
    "paymentPlan": "Payment Plan",
    "personalInformation": "Your personal information",
    "dob": "Date of Birth",
    "yourCurrentAddress": "Your Current Address",
    "yourFinancialInformation": "Your financial information",
    "eligibilityCheck": "We use this information to check your eligibility for PayPal Credit",
    "monthlyRent": "Monthly rent/mortgage(GBP)",
    "apply": "Apply",
    "oneYearAddress": "I have lived at this address for less than one year"
  },
  "asideLogin": {
    "reviewTitle": "Pay and create an account"
  },
  "asideHeader": {
    "fundingInstruments": "Wallet",
    "editCard": "Edit card",
    "addCard": "Add debit or credit card",
    "addDebitCard": "Add debit card",
    "updateDebitCard": "Update or add debit card",
    "selectCard": "Add card",
    "addBank": "Add bank",
    "add": "Add",
    "addShipping": "Add shipping address",
    "selectShipping": "Addresses",
    "addBillingAddress": "Add billing address",
    "asideLogin": "Log in to update",
    "editPhone": "Edit phone number",
    "currencyOptions": "Currency options",
    "currencyConversion": "Currency conversion",
    "currencyConversionOptions": "Currency conversion options",
    "title": "Select payment",
    "loginTitle": "Log in",
    "fundingInstrumentsSubHead": "Pay with",
    "selectShippingSubHead": "Ship to",
    "installmentsPanel": "Select installment",
    "update": "Update",
    "wallet": "Wallet",
    "manageWallet": "Manage Wallet",
    "updateCard": "Update {type} x-{number}",
    "manage": "Manage",
    "delete": "Delete",
    "deleteShipping": "Delete Addresses",
    "topupAmount": "Top up amount",
    "topupFunding": "Top up from",
    "inStorePin": "In-store PIN"
  },
  "authenticate": {
    "enterPassword": "Enter password to make changes"
  },
  "authUserLearnMore": {
    "authUserTitle": "Why is my payment being processed later?",
    "authUserContentPara1": "For this transaction, your merchant has requested an authorization for the amount of your payment. With your consent, the merchant may change your final payment amount if the total amount changes, due to taxes, shipping charges, item availability, or other conditions that you agree upon with your merchant.",
    "authUserContentPara2": "A payment that you authorize to a merchant is valid for a variable period. In some cases, you may receive a hold on your balance that is not immediately transferred to the merchant upon completing your authorization. Your money won’t be transferred to the merchant until the merchant processes your payment.",
    "ok": "OK"
  },
  "addressNormalization": {
    "title": "We found a match for your address",
    "intro": "Does it look right? We recommend using the updated address for more reliable shipping.",
    "addressmatch": "Select an address",
    "addressenter": "Use the address you entered",
    "titleUpdatedShippingAddress": "We updated your shipping address - take a look before you save it",
    "titleUpdateYourAddress": "Update your address so your purchase can arrive successfully",
    "updateAddress": "Update address",
    "updatedAddress": "Updated address",
    "updateThisAddress": "Update this address",
    "undeliverableAddress": "Undeliverable address",
    "newAddress": "New address",
    "originalAddress": "Original address",
    "keepOriginalAddress": "Keep original address"
  },
  "bank": {
    "account": "Account number",
    "routing": "Bank Routing number",
    "accountPlaceholder": "Account number 1-10 digits",
    "sort": "Sort code",
    "sortPlaceholder": "Sort code 8 digits",
    "dob": "Date of birth",
    "dobPlaceholder": "Date of birth DD/MM/YYYY",
    "bobHelp": "You have to be at least 18 years old to use PayPal.",
    "enterBBAN": "Bank details",
    "insteadBBAN": "Use bank?",
    "enterIBAN": "IBAN details",
    "insteadIBAN": "Use IBAN?",
    "IBANPlaceholder": "DE12 2222 3333 4444 5555 66",
    "iban": "IBAN number",
    "bank": "Bank",
    "card": "Credit Card",
    "ibanHelp": "IBAN is the international bank account number. IBAN consists of the double-digit country code and the bank account number.",
    "addBankDisclaimer": "By clicking <b>Continue</b>, you agree to accept a <a class=popup xo-popup target=_blank href=https://www.paypal.com/de/identitycheck>credit check</a>.",
    "addBankandContinueDisclaimer": "By clicking <b>Add Bank & Continue</b>, you agree to accept a <a class=popup xo-popup target=_blank href=https://www.paypal.com/de/identitycheck>credit check</a>.",
    "invalidPINumber": "Invalid account number",
    "invalidRoutingNumber": "Invalid routing number",
    "invalidDOB": "Invalid date of birth",
    "invalidDOBFormat": "Invalid date of birth format. Please enter date in mm/dd/yyyy format.",
    "errorInvalidFirstName": "Invalid first name",
    "errorInvalidLastName": "Invalid last name",
    "errorInstrumentRefused": "Your bank account is declined. Please try another one.",
    "errorInstrumentCountExceeded": "You can't add any more bank accounts to your account.",
    "errorInstrumentUnavailable": "Another PayPal member is already using this bank account. Please add a different bank.",
    "errorInstrumentAlreadyExists": "The bank account you want to add is already in your account.",
    "errorInstrumentUpdateNoChange": "Information you want to change is the same as before.",
    "errorInstrumentBillingAddressNotMatch": "Please enter the address where you receive billing statement for this bank account below.",
    "errorInstrumentBillingAddressNotAccepted": "We’re sorry, the billing address is not accepted.",
    "errorInternalError": "We’re sorry, but we weren’t able to add this bank account. Please try again later, or add a different bank account.",
    "errorGeneral": "We’re sorry, but we weren’t able to add this bank account. Please try a different bank account.",
    "linkedBankError": "The bank you entered was already added to another PayPal account. Use a different bank to complete your purchase, or pay with a credit card.",
    "disallowedAddCard": "Your bank can’t be used for this payment. To complete your purchase, add a debit or credit card.",
    "disallowedAddDebitCard": "Your bank can’t be used for this payment. If you have a debit card with that bank, you can try it now, or add a different debit or credit card."
  },
  "base": {
    "payPal": "PayPal Checkout",
    "contentAreaAccessAid": "Content area",
    "payWithPayPalLogo": "Pay with PayPal",
    "totalLabel": "Total",
    "taxLabel": "Tax",
    "shippingLabel": "Shipping",
    "policies": "PayPal policies",
    "privacy": "Privacy",
    "closeWindowLabel": "Close Window",
    "closePayPalCheckoutLabel": "Close PayPal checkout",
    "processing": "Processing...",
    "loggingIn": "Securely logging you in...",
    "planning": "Retrieving your info...",
    "beRightWithYou": "We'll be right with you...",
    "shoppingCart": "Shopping cart",
    "yourCart": "Your Cart",
    "cancelUrl": "Cancel and return to {merchantName}",
    "closeWindow": "Close Window",
    "policiesLink": "<a href=https://www.paypal.com/us/cgi-bin/webscr?cmd=xpt/cps/popup/FundingMixEducation-outside class=popup target=_new>PayPal policies</a>",
    "termsLink": "<a href=https://www.paypal.com/us/webapps/mpp/ua/legalhub-full class=popup target=_new>Terms</a>",
    "privacyLink": "<a href=https://cms.paypal.com/us/cgi-bin/marketingweb?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US class=popup target=_new>Privacy</a>",
    "securePage": "Secure page",
    "copyright": "Copyright © 1999 - 2015",
    "noJavaScript": "We're sorry, but to check out using PayPal, you need to turn on JavaScript and enable cookies in your web browser's settings.",
    "logIn": "Log in",
    "bmlLender": "The lender for PayPal Credit accounts is Comenity Capital Bank"
  },
  "billing": {
    "billingTitle": "Billing address",
    "shipToAddress": "Ship to this address",
    "member": "Have an account?",
    "loginBtn": "Log in Now!",
    "signupTitle": "Create a PayPal account",
    "billingAddressAlreadyExist": "Billing address already exists",
    "blockNonDomesticPayer": "The merchant requires a {countryCode} billing address for all purchases made using PayPal."
  },
  "bmlDeclined": {
    "bmlAcctLinkedHeader": "Looks like you already have PayPal Credit...",
    "bmlAcctLinkedMsg": "You already have a PayPal Credit account, and it's linked to a different PayPal account.  Please use another payment method to complete your purchase.",
    "bmlAcctLinkedMsgEscape": "You already have a PayPal Credit account, and it's linked to a different PayPal account. Please return to {merchantName} and choose another way to pay.",
    "bmlAcctLinkedMsgEscapeDefaultMerchant": "You already have a PayPal Credit account, and it's linked to a different PayPal account. Please return to merchant and choose another way to pay.",
    "creditEligibilityDeniedHeader": "Sorry, but PayPal Credit isn't available for this purchase",
    "creditEligibilityDeniedMsg": "But you do have options. To pay in full now, use the payment method selected, or choose another way to pay.",
    "creditEligibilityDeniedMsgEscape": "Please return to {merchantName} and choose another way to pay.",
    "creditEligibilityDeniedMsgEscapeDefaultMerchant": "Please return to Merchant and choose another way to pay.",
    "creditNotAllowedHeader": "Sorry, but your PayPal Credit line doesn't cover this purchase",
    "creditNotAllowedMsg": "But you do have options. To pay in full now, use the payment method selected, or choose another way to pay.",
    "creditNotAllowedMsgLine1": "You’ll receive an email with information about why we weren’t able to increase your credit line.",
    "creditNotAllowedMsgEscape": "Please return to {merchantName} and choose another way to pay.",
    "creditNotAllowedMsgEscapeDefaultMerchant": "Please return to Merchant and choose another way to pay.",
    "hardDeclineHeader": "Sorry, your application wasn't approved",
    "hardDeclineMsg": "We’ll email information about why your application was unsuccessful. Although you weren’t approved for credit, you can still use PayPal to securely pay with your debit or credit card.",
    "hardDeclineMsgEscape": "You’ll receive an email with information about why your application was unsuccessful. Please return to {merchantName} and choose another way to pay.",
    "hardDeclineMsgEscapeDefaultMerchant": "You’ll receive an email with information about why your application was unsuccessful. Please return to merchant and choose another way to pay.",
    "systemErrorHeader": "Sorry, but your application couldn’t be processed at this time",
    "systemErrorMsg": "You’ll be able to apply for PayPal Credit again later. To pay in full now, use the payment method selected, or choose another way to pay. ",
    "systemErrorMsgEscape": "You’ll be able to apply for PayPal Credit at another time. Please return to {merchantName} and choose another way to pay.  ",
    "systemErrorMsgEscapeDefaultMerchant": "You’ll be able to apply for PayPal Credit at another time. Please return to merchant and choose another way to pay.  ",
    "declineOtherCreditInstrumentExistsHeader": "We're unable to process your application at this time",
    "declineOtherCreditInstrumentExistsLine1": "Sorry, but these PayPal Credit offers are not currently available with your existing credit account. We're working to make these offers available to you in the future.",
    "declineOtherCreditInstrumentExistsLine2": "Please return to {merchantName} and choose another way to pay.",
    "twoFADeclinedHeader": "Sorry, but PayPal Credit isn’t available at this time",
    "twoFADeclinedMsgLine1": "Because you have a Security Key on your account, PayPal Credit isn’t currently available. We’re working to remove this limitation so you’ll be able to apply for PayPal Credit soon.",
    "twoFADeclinedMsgLine2": "Please return to {merchantName} and choose another way to pay.",
    "twoFADeclinedMsgLine2Default": "Please return to the merchant and choose another way to pay."
  },
  "carrierAssistedOnboarding": {
    "autofillValueProp": "Autofill your info using your <b>Verizon, AT&T, T-Mobile, or Sprint</b> mobile account.",
    "headerEnrichedAutofillProp": "Autofill your billing info using your <b>{carrierName}</b> mobile account.",
    "carrierAssistedOnboardingTriggerButton": "Autofill My Info",
    "valuePropHeader": "Create your account and pay the easy way",
    "valuePropText": "Autofill your info using your <b>Verizon, AT&T, T-Mobile, or Sprint</b> mobile account. Just enter your mobile number and billing ZIP code. We'll send a one-time confirmation code.",
    "headerEnrichedValuePropText": "Now you can autofill your info. Just enter the billing ZIP code on your <b>{carrierName}</b> account.",
    "mobileNumberPlaceholder": "Mobile number",
    "billingZipCodePlaceholder": "Billing ZIP code",
    "termsAndConditions": "I confirm that I'm authorized to use this number and that I consent to receiving an automated text. Standard message and data rates may apply.",
    "sendCodeButton": "Send Code",
    "nextButton": "Next",
    "skipButton": "Skip",
    "mobileNumberError": "We weren't able to send a text message to this mobile number. Check this number and try again.",
    "enterConfirmationCodeHeader": "Enter the 4-digit code we sent to your mobile phone.",
    "enterConfirmationCodeText": "This will let your mobile carrier know you want to share your account details with PayPal.",
    "confirmationCodePlaceholder": "Confirmation code",
    "confirmButton": "Confirm",
    "sendCodeAgain": "Send a new code",
    "invalidCode": "Please enter a valid confirmation code.",
    "confirmationCodeError": "Check your confirmation code and try again or request a new code.",
    "confirmationCodeSent": "Confirmation code sent.",
    "billingZipCodeHeader": "Enter the billing ZIP code",
    "billingZipCodeError": "Check your ZIP code and try again.",
    "autofillComplete": "We entered some of your billing info. Be sure to review and complete before you continue.",
    "pageLevelError": "We weren't able to use your mobile account details. Please enter your billing information."
  },
  "changeShipping": {
    "billingInfo": "Billing info",
    "shipToBillingAddress": "Ship to billing address"
  },
  "cardTypes": {
    "AMEX": "American Express",
    "VISA": "Visa",
    "MASTERCARD": "MasterCard",
    "DISCOVER": "Discover",
    "MAESTRO": "Maestro",
    "CBNATIONALE": "Carte Bancaire",
    "COFINOGA": "Cofinoga ou Privilège",
    "CETELEM": "Carte Aurore",
    "COFIDIS": "4 étoiles",
    "ELO": "Elo",
    "HIPER": "Hiper",
    "HIPERCARD": "HiperCard",
    "JCB": "JCB",
    "CUP": "UnionPay",
    "CHINA_UNION_PAY": "UnionPay",
    "MASTER_CARD": "MasterCard"
  },
  "buttons": {
    "save": "Save",
    "cancel": "Cancel",
    "agree": "Agree",
    "agreeContinue": "Agree & Continue"
  },
  "checkoutIncentive": {
    "header": "Get {incentiveAmount} off this purchase!",
    "body": "Add a debit or credit card and make this your first purchase. Welcome to PayPal!",
    "pageTitle": "Add Card",
    "termsHeader": "Terms & Conditions",
    "termsH1": "Eligible Participant",
    "termsP1": "Open only to residents of any one of the fifty United States or the District of Columbia who: (1) are eighteen years of age or older; and (2) are shown the offer during their checkout for an Eligible Purchase.",
    "termsH2": "Eligible Purchase(s)",
    "termsP2": "Only purchases of $15 or more made in USD, using your PayPal account, within the Offer Period. Eligible Purchases do not include: (1) send/receive money transactions (including those marked as a “Goods and Services” payments), (2) charitable donations, (3) purchases made using PayPal.me; (4) PayPal Cash Mastercard®, PayPal Cashback Mastercard®, PayPal Prepaid Mastercard, PayPal Extras Mastercard®, and PayPal Business Debit Mastercard purchases made using the card directly and not through your PayPal account, and (4) PayPal transaction fees.",
    "termsH3": "Offer Period",
    "termsP3": "<b>The Offer Period only lasts during the same purchase where the PayPal Reward for “this purchase” is shown during checkout.</b> If you do not complete the same purchase during which the Reward was offered, you will not receive the Reward. Examples of how the “same purchase” can end include, but are not limited to: closing the PayPal checkout window, logging out or being logged out of PayPal, or changing or refreshing your purchase on the merchant page. If your purchase is declined, including declined by PayPal, the Offer Period ends. In no event does the Offer Period last more than 24 hours from when the Reward offer was first presented to you.",
    "termsH4": "How to Qualify",
    "termsP4": "Eligible participants must add a new debit or credit card to their PayPal account and complete their purchase during the Offer Period. A new debit or credit card is one that you have not previously added to your PayPal account. If addition of your debit or credit card to your PayPal account fails, for any reason, you will not qualify for this Reward.",
    "termsH5": "How to Redeem",
    "termsP5": "If you have qualified for the Reward, it will be applied automatically to the same purchase for which it was offered. If the Reward is not shown with your payment total in the PayPal checkout window, the Reward is not available, whether or not it appeared on a previous page. The Reward must be redeemed during the Offer Period and may only be redeemed as described in these terms & conditions. Use of the Reward will be reflected on the Eligible Participant’s PayPal receipt and/or in the transaction details of his/her PayPal account. There is a limit of one (1) Reward per Valid Account.",
    "termsH6": "Miscellaneous",
    "termsP6": "Redemptions are final, will not be returned, and are subject to review and verification. The Reward has no cash value and cannot be redeemed for cash or withdrawn from the Eligible Participant’s PayPal account, except in PayPal’s sole discretion. If item(s) purchased using a Reward are returned, PayPal will first refund the cash spent in the form of a credit to Eligible Participant’s PayPal balance and purchase amount in excess of the cash spent (i.e., the value of the Reward) will not be refunded. PayPal may provide an alternate reward of equal value if it is unable for any reason to fulfill the Reward. PayPal reserves the right to cancel, suspend or modify this offer in part or in its entirety at any time without notice, for any reason in its sole discretion. Similar offers may run at the same time; qualification for this offer does not constitute qualification for any other offer. PayPal is not responsible and/or liable for any lost, stolen, late, incomplete, illegible, interrupted, delayed, or misdirected e-mail, Reward, or offer-related materials or correspondence or if any participant’s e-mail address, Valid Account, or other contact information does not work, is deleted, or is changed without participant giving prior written notice to PayPal. Offer is void where prohibited, if Eligible Purchases are not completed through legitimate channels, or if any offer-related materials are counterfeit, altered, defective, tampered with or irregular in any way. Certain offers may not be transferable. Any questions relating to the offer will be resolved in PayPal’s sole discretion and its decisions related to the offer will be final and binding."
  },
  "complete": {
    "youAreDone": "You're almost done",
    "readyForUse": "Your new PayPal account is ready for use at thousands of merchants!",
    "accountCreated": "Your account's been created. Please continue to finish checking out.",
    "returnToMerchant": "Next you'll return to <strong>{merchantName}</strong> to complete your purchase.",
    "confirmation": "We'll email confirmation to <br/><strong>{email}</strong>.",
    "confirmationEmail": "We'll email confirmation to <br/><strong>{email}</strong>."
  },
  "compliance": {
    "interstitialmessage": "Your account is limited. Please check your <a href=\"/myaccount/home\">Account Overview</a> page for messages about resolving this problem."
  },
  "consumerCreditInfo": {
    "applicationApprovedMessage": "Your application is approved",
    "creditLimitInfo": "You are eligible for a credit limit of £{amount}.",
    "paymentPlan": "Payment plan",
    "APRDisclaimer": "<sup>*</sup> The APR, which helps you compare other credit offers, is the total cost expressed as an annual percentage of the total amount of credit.",
    "reviewSecciMessage": "Please take a moment to review and agree to the Standard European Consumer Credit Information (SECCI) and the PayPal Credit contract.",
    "secciReadConfirmationMessage": "By checking this box you confirm that you have read the pre-contract information. It tells you about the conditions and features of this credit product. <a class=\"popup\" target=\"_blank\" href=\"https://www.paypalobjects.com/webstatic/checkout/hermes/html/consumerCreditInfo.html\">Read the full document</a>",
    "readFullDocument": "Read the full document.",
    "momentToReview": "Take a moment to review your payment plan and agree to the contracts before completing your purchase.",
    "creditInfoLine1": "PayPal Credit — {term} payments of £{amount}",
    "creditInfoLine2": "Today's purchase is {totalPayment} with a promotional APR of {apr}% for {term} months",
    "preContractInfo": "Pre-contractual information",
    "pdfSubText": "(PDF, 835k)",
    "agreementError": "Please confirm that you have read the pre-contractual (SECCI) information."
  },
  "country": {
    "US": "United States",
    "AL": "Albania",
    "DZ": "Algeria",
    "AD": "Andorra",
    "AO": "Angola",
    "AI": "Anguilla",
    "AG": "Antigua and Barbuda",
    "AR": "Argentina",
    "AM": "Armenia",
    "AW": "Aruba",
    "AU": "Australia",
    "AT": "Austria",
    "AZ": "Azerbaijan Republic",
    "BS": "Bahamas",
    "BH": "Bahrain",
    "BB": "Barbados",
    "BE": "Belgium",
    "BZ": "Belize",
    "BJ": "Benin",
    "BM": "Bermuda",
    "BT": "Bhutan",
    "BO": "Bolivia",
    "BA": "Bosnia and Herzegovina",
    "BW": "Botswana",
    "BY": "Belarus",
    "BR": "Brazil",
    "BN": "Brunei",
    "BG": "Bulgaria",
    "BF": "Burkina Faso",
    "BI": "Burundi",
    "KH": "Cambodia",
    "CA": "Canada",
    "CV": "Cape Verde",
    "KY": "Cayman Islands",
    "TD": "Chad",
    "CL": "Chile",
    "CM": "Cameroon",
    "C2": "China",
    "CN": "China",
    "CO": "Colombia",
    "KM": "Comoros",
    "CK": "Cook Islands",
    "CR": "Costa Rica",
    "HR": "Croatia",
    "CY": "Cyprus",
    "CZ": "Czech Republic",
    "CD": "Democratic Republic of the Congo",
    "DK": "Denmark",
    "DJ": "Djibouti",
    "DM": "Dominica",
    "DO": "Dominican Republic",
    "EC": "Ecuador",
    "EG": "Egypt",
    "SV": "El Salvador",
    "ER": "Eritrea",
    "EE": "Estonia",
    "ET": "Ethiopia",
    "FK": "Falkland Islands",
    "FO": "Faroe Islands",
    "FJ": "Fiji",
    "FI": "Finland",
    "FR": "France",
    "GF": "French Guiana",
    "PF": "French Polynesia",
    "GA": "Gabon Republic",
    "GM": "Gambia",
    "GE": "Georgia",
    "DE": "Germany",
    "GI": "Gibraltar",
    "GR": "Greece",
    "GL": "Greenland",
    "GD": "Grenada",
    "GP": "Guadeloupe",
    "GT": "Guatemala",
    "GN": "Guinea",
    "GW": "Guinea Bissau",
    "GY": "Guyana",
    "HN": "Honduras",
    "HK": "Hong Kong",
    "HU": "Hungary",
    "IS": "Iceland",
    "IN": "India",
    "ID": "Indonesia",
    "IE": "Ireland",
    "IM": "Isle of Man",
    "IL": "Israel",
    "IT": "Italy",
    "JM": "Jamaica",
    "JP": "Japan",
    "JE": "Jersey",
    "JO": "Jordan",
    "KZ": "Kazakhstan",
    "KE": "Kenya",
    "KI": "Kiribati",
    "KW": "Kuwait",
    "KG": "Kyrgyzstan",
    "LA": "Laos",
    "LV": "Latvia",
    "LS": "Lesotho",
    "LI": "Liechtenstein",
    "LT": "Lithuania",
    "LU": "Luxembourg",
    "MG": "Madagascar",
    "MW": "Malawi",
    "MY": "Malaysia",
    "MV": "Maldives",
    "ML": "Mali",
    "MT": "Malta",
    "MH": "Marshall Islands",
    "MQ": "Martinique",
    "MR": "Mauritania",
    "MU": "Mauritius",
    "YT": "Mayotte",
    "MX": "Mexico",
    "FM": "Micronesia",
    "MC": "Monaco",
    "MD": "Moldova",
    "ME": "Montenegro",
    "MK": "Macedonia",
    "MN": "Mongolia",
    "MS": "Montserrat",
    "MA": "Morocco",
    "MZ": "Mozambique",
    "NA": "Namibia",
    "NR": "Nauru",
    "NP": "Nepal",
    "NL": "Netherlands",
    "AN": "Netherlands Antilles",
    "NC": "New Caledonia",
    "NZ": "New Zealand",
    "NI": "Nicaragua",
    "NE": "Niger",
    "NU": "Niue",
    "NF": "Norfolk Island",
    "NG": "Nigeria",
    "NO": "Norway",
    "OM": "Oman",
    "PW": "Palau",
    "PA": "Panama",
    "PG": "Papua New Guinea",
    "PY": "Paraguay",
    "PE": "Peru",
    "PH": "Philippines",
    "PN": "Pitcairn Islands",
    "PL": "Poland",
    "PT": "Portugal",
    "QA": "Qatar",
    "CG": "Republic of the Congo",
    "RE": "Reunion",
    "RO": "Romania",
    "RU": "Russia",
    "RW": "Rwanda",
    "KN": "Saint Kitts and Nevis Anguilla",
    "PM": "Saint Pierre and Miquelon",
    "VC": "Saint Vincent and Grenadines",
    "WS": "Samoa",
    "SM": "San Marino",
    "ST": "São Tomé and Príncipe",
    "SA": "Saudi Arabia",
    "SN": "Senegal",
    "RS": "Serbia",
    "SC": "Seychelles",
    "SL": "Sierra Leone",
    "SG": "Singapore",
    "SK": "Slovakia",
    "SI": "Slovenia",
    "SB": "Solomon Islands",
    "SO": "Somalia",
    "ZA": "South Africa",
    "KR": "South Korea",
    "ES": "Spain",
    "LK": "Sri Lanka",
    "SH": "St. Helena",
    "LC": "St. Lucia",
    "SR": "Suriname",
    "SJ": "Svalbard and Jan Mayen Islands",
    "SZ": "Swaziland",
    "SE": "Sweden",
    "CH": "Switzerland",
    "CI": "Côte d’Ivoire",
    "TW": "Taiwan",
    "TJ": "Tajikistan",
    "TZ": "Tanzania",
    "TH": "Thailand",
    "TG": "Togo",
    "TO": "Tonga",
    "TT": "Trinidad and Tobago",
    "TN": "Tunisia",
    "TR": "Turkey",
    "TM": "Turkmenistan",
    "TC": "Turks and Caicos Islands",
    "TV": "Tuvalu",
    "UG": "Uganda",
    "UA": "Ukraine",
    "AE": "United Arab Emirates",
    "GB": "United Kingdom",
    "UY": "Uruguay",
    "UZ": "Uzbekistan",
    "VU": "Vanuatu",
    "VA": "Vatican City State",
    "VE": "Venezuela",
    "VN": "Vietnam",
    "VG": "Virgin Islands (British)",
    "WF": "Wallis and Futuna Islands",
    "YE": "Yemen",
    "ZM": "Zambia",
    "ZW": "Zimbabwe",
    "others": "Other countries",
    "change": "Change country/region",
    "country": "Country/Region",
    "countryOfResidence": "Country/Region of residence",
    "nationality": "Nationality Information"
  },
  "creditDecline": {
    "title": "Your application can't be processed.",
    "message": "We're sorry but you won't be able to use PayPal Credit for this purchase. Please choose another payment method.",
    "buttonText": "Continue"
  },
  "countryList": {
    "US": "United States",
    "AX": "Åland Islands",
    "AL": "Albania",
    "DZ": "Algeria",
    "AD": "Andorra",
    "AO": "Angola",
    "AI": "Anguilla",
    "AG": "Antigua and Barbuda",
    "AR": "Argentina",
    "AM": "Armenia",
    "AW": "Aruba",
    "AU": "Australia",
    "AT": "Austria",
    "AZ": "Azerbaijan Republic",
    "BS": "Bahamas",
    "BH": "Bahrain",
    "BB": "Barbados",
    "BE": "Belgium",
    "BZ": "Belize",
    "BJ": "Benin",
    "BM": "Bermuda",
    "BT": "Bhutan",
    "BO": "Bolivia",
    "BA": "Bosnia and Herzegovina",
    "BW": "Botswana",
    "BR": "Brazil",
    "BN": "Brunei",
    "BG": "Bulgaria",
    "BF": "Burkina Faso",
    "BI": "Burundi",
    "BY": "Belarus",
    "KH": "Cambodia",
    "CA": "Canada",
    "CI": "Côte d’Ivoire",
    "CM": "Cameroon",
    "C2": "China",
    "CV": "Cape Verde",
    "KY": "Cayman Islands",
    "TD": "Chad",
    "CL": "Chile",
    "CN": "China",
    "CO": "Colombia",
    "KM": "Comoros",
    "CK": "Cook Islands",
    "CR": "Costa Rica",
    "HR": "Croatia",
    "CY": "Cyprus",
    "CZ": "Czech Republic",
    "CD": "Democratic Republic of the Congo",
    "DK": "Denmark",
    "DJ": "Djibouti",
    "DM": "Dominica",
    "DO": "Dominican Republic",
    "EC": "Ecuador",
    "EG": "Egypt",
    "SV": "El Salvador",
    "ER": "Eritrea",
    "EE": "Estonia",
    "ET": "Ethiopia",
    "FK": "Falkland Islands",
    "FO": "Faroe Islands",
    "FJ": "Fiji",
    "FI": "Finland",
    "FR": "France",
    "GF": "French Guiana",
    "PF": "French Polynesia",
    "GA": "Gabon Republic",
    "GM": "Gambia",
    "GE": "Georgia",
    "DE": "Germany",
    "GH": "Ghana",
    "GI": "Gibraltar",
    "GR": "Greece",
    "GL": "Greenland",
    "GD": "Grenada",
    "GP": "Guadeloupe",
    "GT": "Guatemala",
    "GG": "Guernsey",
    "GN": "Guinea",
    "GW": "Guinea Bissau",
    "GY": "Guyana",
    "HN": "Honduras",
    "HK": "Hong Kong",
    "HU": "Hungary",
    "IS": "Iceland",
    "IN": "India",
    "ID": "Indonesia",
    "IE": "Ireland",
    "IM": "Isle of Man",
    "IL": "Israel",
    "IT": "Italy",
    "JM": "Jamaica",
    "JP": "Japan",
    "JE": "Jersey",
    "JO": "Jordan",
    "KZ": "Kazakhstan",
    "KE": "Kenya",
    "KI": "Kiribati",
    "KW": "Kuwait",
    "KG": "Kyrgyzstan",
    "LA": "Laos",
    "LV": "Latvia",
    "LS": "Lesotho",
    "LI": "Liechtenstein",
    "LT": "Lithuania",
    "LU": "Luxembourg",
    "MG": "Madagascar",
    "MW": "Malawi",
    "MY": "Malaysia",
    "MV": "Maldives",
    "ML": "Mali",
    "MT": "Malta",
    "MH": "Marshall Islands",
    "MQ": "Martinique",
    "MR": "Mauritania",
    "MU": "Mauritius",
    "YT": "Mayotte",
    "MX": "Mexico",
    "FM": "Micronesia",
    "MN": "Mongolia",
    "MS": "Montserrat",
    "MA": "Morocco",
    "MZ": "Mozambique",
    "MC": "Monaco",
    "MD": "Moldova",
    "ME": "Montenegro",
    "MK": "Macedonia",
    "NA": "Namibia",
    "NR": "Nauru",
    "NP": "Nepal",
    "NL": "Netherlands",
    "AN": "Netherlands Antilles",
    "NC": "New Caledonia",
    "NZ": "New Zealand",
    "NI": "Nicaragua",
    "NE": "Niger",
    "NU": "Niue",
    "NF": "Norfolk Island",
    "NO": "Norway",
    "NG": "Nigeria",
    "OM": "Oman",
    "PW": "Palau",
    "PA": "Panama",
    "PG": "Papua New Guinea",
    "PY": "Paraguay",
    "PE": "Peru",
    "PH": "Philippines",
    "PN": "Pitcairn Islands",
    "PL": "Poland",
    "PT": "Portugal",
    "QA": "Qatar",
    "CG": "Republic of the Congo",
    "RE": "Reunion",
    "RO": "Romania",
    "RU": "Russia",
    "RW": "Rwanda",
    "KN": "Saint Kitts and Nevis Anguilla",
    "PM": "Saint Pierre and Miquelon",
    "VC": "Saint Vincent and Grenadines",
    "WS": "Samoa",
    "SM": "San Marino",
    "ST": "São Tomé and Príncipe",
    "SA": "Saudi Arabia",
    "SN": "Senegal",
    "RS": "Serbia",
    "SC": "Seychelles",
    "SL": "Sierra Leone",
    "SG": "Singapore",
    "SK": "Slovakia",
    "SI": "Slovenia",
    "SB": "Solomon Islands",
    "SO": "Somalia",
    "ZA": "South Africa",
    "KR": "South Korea",
    "ES": "Spain",
    "LK": "Sri Lanka",
    "SH": "St. Helena",
    "LC": "St. Lucia",
    "SR": "Suriname",
    "SJ": "Svalbard and Jan Mayen Islands",
    "SZ": "Swaziland",
    "SE": "Sweden",
    "CH": "Switzerland",
    "TW": "Taiwan",
    "TJ": "Tajikistan",
    "TZ": "Tanzania",
    "TH": "Thailand",
    "TG": "Togo",
    "TO": "Tonga",
    "TT": "Trinidad and Tobago",
    "TN": "Tunisia",
    "TR": "Turkey",
    "TM": "Turkmenistan",
    "TC": "Turks and Caicos Islands",
    "TV": "Tuvalu",
    "UG": "Uganda",
    "UA": "Ukraine",
    "UZ": "Uzbekistan",
    "AE": "United Arab Emirates",
    "GB": "United Kingdom",
    "UY": "Uruguay",
    "VU": "Vanuatu",
    "VA": "Vatican City State",
    "VE": "Venezuela",
    "VN": "Vietnam",
    "VG": "Virgin Islands (British)",
    "WF": "Wallis and Futuna Islands",
    "YE": "Yemen",
    "ZM": "Zambia",
    "ZW": "Zimbabwe",
    "others": "Other countries",
    "change": "Change country/region"
  },
  "deleteShipping": {
    "primaryOrBillingAddress": "This address is associated with your PayPal account. To delete it, log in to PayPal.com.",
    "selectedAddress": "Before you delete this address, you need to select or add a different shipping address.",
    "genericError": "Sorry, we weren’t able to delete this address. Please try again later.",
    "delete": "Delete",
    "confirm": "Confirm"
  },
  "currencyOptions": {
    "subHead": "PayPal offers 2 easy ways to convert currency:",
    "ppRateDesc": "PayPal currency conversion rate",
    "conversionRate": "{currencyFrom} = {currencyTo}",
    "ppUpSell1": "My card issuer may have a currency conversion process and I have chosen not to use them.",
    "ppUpSell2": "I will have no recourse against my card issuer with respect to any matter related to this conversion.",
    "cardIssuerRate": "Your card issuer’s rate:",
    "cardIssuerRate1": "My card issuer determines the rate and any fees.",
    "cardIssuerRate2": "The rate and fees will appear on my card statement.",
    "merchPrice": "<b>Merchant price:</b> {transactionTotal}",
    "orderTotal": "<b>Order Total:</b> {transactionTotal}",
    "dccPPRateExcludeSpread": "Paypal makes money when we convert your currency, through the exchange rate shown above.",
    "dccSellerDesc": "Pay in the seller's currency",
    "dccVendorTotalAmount": "<b>Total amount you'll pay:</b> Final amount will be determined by your card issuer.",
    "noneSelected": "Please select a currency conversion option.",
    "paypalRate": "PayPal rate:",
    "paypalConversionRate": "PayPal conversion rate:",
    "cardIssuerRateTitle": "Your card issuer is performing this conversion.",
    "conversionDate": "Converted as of {date}",
    "changeConversionLink": "<a id=\"dccInterstitial\" ui-sref=\"{srefLink}\">View conversion options</a>",
    "viewConversion": "View conversion options",
    "merchantPrice": "Merchant price:",
    "convertPayPal": "Convert with PayPal",
    "convertPayPalHeader": "Pay in {buyerCurrency} using PayPal's conversion rate",
    "exchangeRate": "Exchange rate:",
    "convertPayPalText": "This rate includes a currency conversion spread.",
    "amount": "Amount you’ll pay:",
    "totalAmount": "Total you’ll pay:",
    "convertIssuer": "Convert with card issuer",
    "convertIssuerHeader": "Pay in {sellerCurrency} using your card issuer's rate",
    "convertIssuerText": "Your card issuer will determine the currency conversion rate and what fees they may charge.",
    "issuerFinalAmount": "Final amount determined by your card issuer.",
    "issuerFeesDisclaimer": "Any card issuer fees are not included.",
    "detailedIssuerFeesDisclaimer": "Price shown doesn’t include any fees your card issuer may charge.",
    "stickyPayPalRate": "Always use PayPal’s rate when I pay with {name} {number}",
    "stickyIssuerRate": "Always use my card issuer rate when I pay with {name} {number}",
    "dccPPRate3PL": "The rate above includes a currency conversion fee of {rate}%",
    "dccPPRateNonVisa": "PayPal makes money when we convert your currency, through the exchange rate shown above.",
    "cardIssuerRateAvailable": "Your card issuer can perform the currency conversion instead.",
    "dccPPRateNonVisaTitle": "PayPal is performing this currency conversion at a rate of:",
    "invoicingRegEMsg": "You are transferring and {merchantName} will receive {amountInInvoiceCurrency}.",
    "convertIssuerSplitBal": "Convert full transaction amount with card issuer",
    "issuerFinalAmountSplitBal": "You can't use your balance with this option. Your card issuer will convert the full amount of {amt}, and will determine the exchange rate and the final amount you're charged.",
    "dccTitle": "Select a currency conversion option",
    "dccTitleTreatment1": "Currency conversion options",
    "dccTitleTreatment2": "Review the currency conversion before you continue",
    "dccPPDesc": "Pay in your currency using PayPal conversion rate",
    "dccPPDescTreatment1": "Pay in {buyerCurrency} using PayPal’s conversion rate",
    "dccPPRate": "PayPal makes money when we convert your currency and the rate above includes a currency conversion spread of {rate}%.",
    "dccPPRateTreatment1": "This rate includes a currency conversion spread of {rate}%.",
    "dccPPTotal": "<b>Amount you'll pay: {total}</b>",
    "dccPPTotalTreatment1": "<b>Total amount you’ll pay: {total}</b>",
    "dccVendorDesc": "Pay in the merchant's currency",
    "dccVendorDescTreatment1": "Pay in {sellerCurrency} using your card issuer’s rate",
    "dccVendorExchange": "<b>Exchange rate:</b> Your card issuer will determine the foreign exchange rate you pay. To find out the exchange rate, contact your card issuer.",
    "dccVendorExchangeTreatment1": "Your card issuer will determine the currency conversion rate and what fees they may charge.",
    "dccVendorTotal": "<b>Amount you'll pay:</b> Final amount determined by your card issuer, including any applicable fees.",
    "dccVendorTotalTreatment1": "<b>Total amount you’ll pay:</b> Final amount will be determined by your card issuer.",
    "dccPPExchange": "<b>Exchange rate:</b> {currencyFrom} = {currencyTo}",
    "dccPPExchangeTreatment1": "<b>{currencyFrom} {buyerCurrency} = {currencyTo} {sellerCurrency}</b>",
    "ppConversionRate": "PayPal's rate:",
    "merchantCurrencyRate": "The merchant will let you know the final amount in {currency}.",
    "estimatedTotal": "<b>Estimated amount you'll pay:</b>",
    "textConversionDate": "Converted as of",
    "bfxConversionHeaderRateInline": "Rate for this currency conversion",
    "bfxConversionHeaderRateInterstitial": "Rate for currency conversion",
    "bfxConversionHeaderCurrency": "Currency for this purchase",
    "bfxConversionPayPalLabelRate": "PayPal rate",
    "bfxConversionIssuerLabelRate": "Card issuer rate",
    "bfxConversionPayPalRate": "PayPal's conversion rate:",
    "bfxConversionPayPalRateWithAmount": "PayPal's conversion rate: {fromAmount} = {toAmount}",
    "bfxConversionPayPalSpreadDisclosureGuest": "This rate includes a currency conversion spread of {spread} %.",
    "bfxConversionPayPalSpreadDisclosureMember": "This rate includes a currency conversion spread.",
    "bfxConversionIssuerDisclosure": "Your card issuer will determine the currency conversion rate and what fees they may charge. Check your statement for the final amount.",
    "bfxConversionPayPalTotal": "Total you'll pay:",
    "bfxConversionIssuerTotal": "You'll pay:",
    "bfxSeeCurrencyOptions": "See currency options",
    "bfxConversionIssuerDisclosureSplitFI": "You can't use your balance with this option. Your card issuer will convert the full amount of {amt} and determine the currency conversion rate and what fees they may charge. Check your statement for the final amount.",
    "conversionRateLockTitle": "Why 72 hours?",
    "conversionRateLockDisclosure": "This rate includes our currency conversion fee of {rate}%. We’ll protect you from changing rates and prices. Continue now to lock in this rate and price for 72 hours.",
    "conversionRateLockSeventyTwoHoursDetails": "Most merchants process payments right away, but delays do happen. If the merchant takes longer than 72 hours to complete your purchase, we’ll use the PayPal rate that applies at that time. This could change the total amount you’ll pay.",
    "foreignExchangeRate": "We’ll protect you from changing rates and prices. Continue now to lock in this rate and price for 72 hours.",
    "why72hours": "Why 72 hours?",
    "reason72hours": "Most merchants process payments right away, but delays do happen. If the merchant takes longer than 72 hours to complete your purchase, we'll use the PayPal rate that applies at that time. This could change the total amount you'll pay."
  },
  "done": {
    "payment": "You paid <b>{amt}</b>",
    "paymentGuest": "You created a PayPal account and paid <b>{amt}</b>",
    "payment_target": "to {merchantName}",
    "paidWith": "Paid with",
    "transactionInformation": "This transaction will appear on your statement as {merchantName}",
    "shippedTo": "Shipped to",
    "purchaseDetails": "Purchase details",
    "merchantDetails": "Merchant details",
    "receiptNumber": "Receipt number:",
    "confirmation": "We'll send confirmation to:",
    "temporarily_pending": "Your payment is temporarily pending while we review it. Regulations require us to take a closer look at some transactions. We'll contact you about this again in 24-72 hours.",
    "paymentCompleted": "Payment completed!",
    "paymentCompletedStatement": "You just completed your payment.",
    "autoReturnStatement": "If you're not redirected to {merchantName} in 10 seconds, <a href={autoReturnUrl}>tap here</a>.",
    "autoReturnStatementWeb": "If you're not redirected to {merchantName} in 10 seconds, <a href={autoReturnUrl}>click here</a>.",
    "accountUpgradeFailed": "We weren’t able to create your PayPal account. To try again, please go to PayPal.com."
  },
  "directDebitAgreement": {
    "sepaTitle": "Before you pay, we need your one-time approval",
    "ddAgreementPara1": "This is required by new regulations in the European Union and helps banks process your payments faster and more efficiently.",
    "ddAgreementPara2": "I agree with the <input type=\"submit\" id=\"viewSEPAAgreement\" class=\"button-as-link sepaLink\" value=\"SEPA direct debit mandate\" /> for <strong>{bankName} {bankNumber}</strong> and authorize PayPal to send instructions to my bank account. I also authorize my bank to debit my account in accordance with the instructions from PayPal. A refund must be claimed within 8 weeks starting from the date on which my account was debited.",
    "payAnotherWay": "Pay another way",
    "ddAgreementPara2AcceptPay": "By clicking \"Accept and pay\" you agree to the SEPA direct debit mandate and authorize PayPal to send instructions to your bank account. You also authorize your bank to debit your account in accordance with the instructions from PayPal. A refund must be claimed within 8 weeks starting from the date on which your account was debited.",
    "ddAgreementPara2AcceptContinue": "By clicking \"Accept and continue\" you agree to the SEPA direct debit mandate and authorize PayPal to send instructions to your bank account. You also authorize your bank to debit your account in accordance with the instructions from PayPal. A refund must be claimed within 8 weeks starting from the date on which your account was debited.",
    "ddFullAgreementTitle": "Direct debit authorization",
    "acceptAndContinue": "Accept and continue",
    "acceptAndPay": "Accept and pay"
  },
  "disclaimer": {
    "reviewOrderBeforePurchaseWithMerchantName": "You’ll be able to review this payment before you complete it at {merchantName}.",
    "oneDollarAuthRequired": "On your way back to {merchantName}, we’ll temporarily authorize {amt} on your card to help ensure your payment’s success. Temporary authorizations usually drop off your card within one business day.",
    "fullAuthInformation": "On your way back to {merchantName}, we’ll temporarily authorize {amt} on your card to help ensure your payment’s success. {moreInfoLink}",
    "fullAuthMoreInfoLine1": "When you complete your purchase at {merchantName}, this pending amount will be updated with your final purchase amount.",
    "fullAuthMoreInfoLine2": "If you choose not to complete your purchase at {merchantName}, we’ll void the pending payment and it’ll usually drop off within one business day.",
    "oneDollarAuthRequiredPayNow": "To help make sure this payment is successful, we'll first try {amt} on your card – this will usually drop off your card within one business day.",
    "moreInfo": "More Info"
  },
  "donate": {
    "label": "Donate {amount} to support {charityName}",
    "ecFlowConsentLine1": "Thanks for your kind donation. Please note:",
    "ecFlowConsentLine2": "This donation is an individual transaction you can view in your PayPal activity.",
    "ecFlowConsentLine3": "Donations are made to PayPal Giving Fund, a 501(c)(3) charity. Charities receive their funds typically within 15-45 days of the original donation. PayPal covers all fees. This doesn't happen often, but we may not be able to deliver the donation to the charity you recommend. If so, we'll ask you to recommend a different charity. If we don't receive a recommendation, we'll deliver your donation to a similar charity. This charity won't receive your personal information.",
    "wpsFlowConsentLine1": "This donation is a separate transaction that will only appear in your PayPal account.",
    "wpsFlowConsentLine2": "This donation is a separate transaction you can see in your PayPal activity. All donations are made to PayPal Giving Fund, a 501(c)(3) charity. PayPal kindly covers all fees. Charities usually receive funds within 15-45 days of the original donation date. This rarely happens, but sometimes we're unable to deliver donations to the charity you recommend. If so, we'll ask you to recommend a different charity.",
    "unacceptedFi": "Your current payment method can't be used to donate."
  },
  "editPhone": {
    "phoneType": "Phone Type",
    "mobile": "Mobile",
    "home": "Home",
    "work": "Work"
  },
  "editCard": {
    "newAddressAdded": "New billing address added.",
    "addNewBillingAddress": "Add new billing address",
    "editCard": "Edit card"
  },
  "eConsent": {
    "title": "Electronic Communications Delivery Policy",
    "consent": "Please take a moment to review and consent to the PayPal Electronic Communications Delivery Policy. This will allow us to send your account information electronically, including payment confirmation for this purchase.",
    "agreement": "I have read and agree to the <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/{country}/webapps/mpp/ua/esign-full?locale.x={lang}_{country}>Electronic Communications Delivery Policy</a>. I understand that PayPal will provide me with information about my account electronically.",
    "eConsentError": "Please confirm that you have read and agree to the PayPal Electronic Communications Delivery Policy."
  },
  "email": {
    "empty": "Enter an email address",
    "invalid": "Enter a valid email address",
    "emailPlaceholder": "Email address",
    "didYouMean": "Did you mean <a class=emailLink></a>?",
    "whyTooltip": "Why we need your email address"
  },
  "england": {
    "Avon": "Avon",
    "Bedfordshire": "BedfordShire",
    "Berkshire": "Berkshire",
    "Bristol": "Bristol",
    "Buckinghamshire": "Buckinghamshire",
    "Cambridgeshire": "Cambridgeshire",
    "Cheshire": "Cheshire",
    "Cleveland": "Cleveland",
    "Cornwall": "Cornwall",
    "Cumbria": "Cumbria",
    "Derbyshire": "Derbyshire",
    "Devon": "Devon",
    "Dorset": "Dorset",
    "Durham": "Durham",
    "EastRidingofYorkshire": "East Riding of Yorkshire",
    "EastSussex": "East Sussex",
    "Essex": "Essex",
    "Gloucestershire": "Gloucestershire",
    "GreaterManchester": "Greater Manchester",
    "Hampshire": "Hampshire",
    "Herefordshire": "Herefordshire",
    "Hertfordshire": "Hertfordshire",
    "Humberside": "Humberside",
    "IsleofWight": "Isle of Wight",
    "IslesofScilly": "Isles of Scilly",
    "Kent": "Kent",
    "Lancashire": "Lancashire",
    "Leicestershire": "Leicestershire",
    "Lincolnshire": "Lincolnshire",
    "London": "London",
    "Merseyside": "Merseyside",
    "Middlesex": "Middlesex",
    "Norfolk": "Norfolk",
    "NorthYorkshire": "North Yorkshire",
    "NorthEastLincolnshire": "North East Lincolnshire",
    "Northamptonshire": "Northamptonshire",
    "Northumberland": "Northumberland",
    "Nottinghamshire": "Nottinghamshire",
    "Oxfordshire": "Oxfordshire",
    "Rutland": "Rutland",
    "Shropshire": "Shropshire",
    "Somerset": "Somerset",
    "SouthYorkshire": "South Yorkshire",
    "Staffordshire": "Staffordshire",
    "Suffolk": "Suffolk",
    "Surrey": "Surrey",
    "TyneandWear": "Tyne and Wear",
    "Warwickshire": "Warwickshire",
    "WestMidlands": "West Midlands",
    "WestSussex": "West Sussex",
    "WestYorkshire": "West Yorkshire",
    "Wiltshire": "Wiltshire",
    "Worcestershire": "Worcestershire"
  },
  "footer": {
    "policies": "<a href=https://www.paypal.com/{country}/cgi-bin/webscr?cmd=xpt/cps/popup/FundingMixEducation-outside&locale.x={lang}_{country} xo-popup class=popup target=_blank>Policies</a>",
    "policiesCA": "<a href=https://www.paypal.com/{country}/cgi-bin/webscr?cmd=xpt/cps/popup/FundingMixEducation-outside&locale.x={lang}_{country} xo-popup class=popup target=_blank>Policies</a>",
    "terms": "<a href=https://www.paypal.com/webapps/mpp/ua/legalhub-full?country.x={country}&locale.x={lang}_{country} xo-popup class=popup target=_blank>Terms</a>",
    "termsCA": "<a href=https://www.paypal.com/webapps/mpp/ua/legalhub-full?country.x={country}&locale.x={lang}_{country} xo-popup class=popup target=_blank>Terms</a>",
    "privacy": "<a href=https://www.paypal.com/webapps/mpp/ua/privacy-full?country.x={country}&locale.x={lang}_{country} xo-popup class=popup target=_blank>Privacy</a>",
    "privacyCA": "<a href=https://www.paypal.com/webapps/mpp/ua/privacy-full?country.x={country}&locale.x={lang}_{country} xo-popup class=popup target=_blank>Privacy</a>",
    "secure": "Secure page",
    "copyright": "© 1999 - {year}",
    "escHatch": "View full page",
    "DEImprint": "<a href=https://www.paypal.com/de/cgi-bin/webscr?cmd=xpt/Marketing/general/Imprint-outside xo-popup class=popup target=_blank>Imprint</a>",
    "DELegal": "<a href=https://cms.paypal.com/de/cgi-bin/?cmd=_render-content&content_ID=ua/Legal_Hub_popup xo-popup class=popup target=_blank>Legal</a>",
    "DEPrivacy": "<a href= https://cms.paypal.com/de/cgi-bin/marketingweb?cmd=_render-content&content_ID=ua/Privacy_popup&locale.x=de_DE xo-popup class=popup target=_blank>Privacy</a>",
    "DEKeyPaymentDesc": "<a href=https://cms.paypal.com/de/cgi-bin/marketingweb?cmd=_render-content&content_ID=ua/ServiceDescription_popup&locale.x=de_DE xo-popup class=popup target=_blank>Key payment and service description</a>",
    "FRLegal": "<a href=https://www.paypal.com/fr/webapps/mpp/ua/legalhub-full?locale.x=fr_FR xo-popup class=popup target=_blank>Legal</a>",
    "FRPrivacy": "<a href=https://www.paypal.com/fr/webapps/mpp/ua/privacy-full xo-popup class=popup target=_blank>Privacy</a>",
    "FRUserAgreement": "<a href=https://www.paypal.com/fr/webapps/mpp/ua/useragreement-full xo-popup class=popup target=_blank>User Agreement</a>",
    "SiteFeedback": "Feedback",
    "CheckoutFeedback": "Checkout Feedback",
    "okBtn": "OK",
    "openLinks": "To view this page, paste the link into a new browser window.",
    "policyInformation": "Consumer advisory - PayPal Pte. Ltd. the holder of PayPal's stored value facility, does not require the approval of the Monetary Authority of Singapore. Users are advised to read the <a target=_new xo-popup href=https://www.paypal.com/{country}/webapps/mpp/ua/legalhub-full>terms and conditions</a> carefully.",
    "venmo_policies": "<a href=https://venmo.com/legal/us-privacy-policy xo-popup class=popup target=_blank>Venmo Policies</a>",
    "venmo_terms": "<a href=https://venmo.com/legal/us-user-agreement xo-popup class=popup target=_blank>Venmo Terms</a>",
    "venmo_privacy": "<a href=https://venmo.com/legal/us-privacy-policy xo-popup class=popup target=_blank>Venmo Privacy</a>"
  },
  "fsMappings": {
    "CHECKING": "BANK",
    "SAVINGS": "BANK",
    "HOLDING": "Balance",
    "BALANCE": "Balance",
    "MASTERCARD": "MasterCard",
    "DISCOVER": "Discover",
    "AMEX": "American Express",
    "VISA": "Visa",
    "SWITCH": "Maestro",
    "PAYPAL_EXTRAS_MASTERCARD": "PayPal MasterCard",
    "PAYPAL_SMART_CONNECT": "PayPal Smart Connect",
    "EBAY_MASTERCARD": "eBay MasterCard",
    "PINLESSDEBIT": "ATM/Debit card",
    "INCENTIVE": "Exclusive Offer",
    "REWARDS": "Rewards",
    "CREDIT": "PayPal Credit",
    "BILL_ME_LATER": "PayPal Credit"
  },
  "fundingInstruments": {
    "eCheck": "eCheck",
    "accounts": "Accounts",
    "cards": "Debit and credit cards",
    "addNewCard": "Add a debit or credit card",
    "addDebitCard": "Add a debit card",
    "getMoreOutOfPaypal": "Get more out of PayPal",
    "expired": "Expired",
    "cardDisabled": "The merchant doesn't accept this card.",
    "disabled": "The merchant does not accept this card.",
    "pad": "Pay After Delivery using",
    "iach": "Direct debit",
    "meft": "Bank transfer",
    "instantTransfer": "Direct debit",
    "paymentOptions": "See all monthly payment options",
    "billingPreferredFi": "{merchantName} payment method saved on PayPal.com",
    "bmlDisabled": "PayPal Credit isn't <br/>available for this purchase",
    "bml": "PayPal Credit",
    "bmlDetailsNI": "No interest if paid in full in 6 months. <a class=\"popup\" xo-popup href=\"http://www.paypal.com/ppclander\" target=\"_new\">See Terms</a>",
    "bmlDetails": "Get 6 months to pay on purchases of $99 or more. <a class=\"popup\" xo-popup href=\"https://www.billmelater.com/cm/paypal/landers/14ppbmlREUSEST.html\" target=\"_new\">See Terms</a>",
    "bmlDetailsWallet": "Get 6 months to pay on purchases of $99 or more.<br/><span class=\"bmlDetailsWalletTerms popup button-as-link\" xo-popup  data-href=\"https://www.billmelater.com/cm/paypal/landers/14ppbmlREUSEST.html\">See Terms</span>",
    "NIWithInstallment": "Get 6 months to pay on purchases of $99 or more."
  },
  "genericMessage": {
    "paymentSuccessTitle": "Thanks for using PayPal!",
    "paymentSuccessMessage": "You can close this tab at any time.",
    "successMessage": "If you’re not sent back to the merchant in a few seconds, just click Return to Merchant. You can close this tab at any time.",
    "returnButton": "Return to Merchant"
  },
  "gceCommon": {
    "poweredBy": "Powered by",
    "payPal": "PayPal"
  },
  "header": {
    "payWithPayPal": "Pay with PayPal",
    "checkout": "Checkout",
    "subTotal": "Subtotal",
    "total": "Total",
    "closeWindow": "Close Window",
    "tax": "Tax",
    "shipping": "Shipping",
    "insurance": "Insurance",
    "handling": "Handling",
    "shippingDiscount": "Shipping discount",
    "close": "Close",
    "interestExclude": "(excluding est. interest charges)",
    "noteFromMerchant": "Note from {merchant}",
    "more": "More",
    "less": "Less",
    "quantity": "Quantity:",
    "itemTotal": "Item total",
    "itemNumber": "Item #:",
    "price": "Item price:",
    "description": "Item description:",
    "srMore": "Show more",
    "srLess": "Show less",
    "discount": "Discount"
  },
  "guestVerify": {
    "welcome": "Welcome back, {userName}!",
    "desc": "We need to confirm some info to complete your purchase. Don’t worry – you only need to do this once!",
    "expiresLabel": "Expires",
    "cardNumberLabel": "Confirm card number",
    "lastThree": "Last 3 digits",
    "cvv": "CSC",
    "cvvThree": "3 digits",
    "cvvFour": "4 digits",
    "propHead": "PayPal is the safer, easier way to pay",
    "propVal": "No matter where you shop, we keep your financial information secure.",
    "cvvHelp3Digits": "It’s the last 3 digits in the signature area on the back of your card.",
    "cvvHelp4Digits": "It’s the last 4 digits printed on the front of your card."
  },
  "index": {
    "BreadCrumbOne": 1,
    "BreadCrumbTwo": 2,
    "BreadCrumbThree": 3,
    "BreadCrumbFour": 4,
    "BreadCrumbGetStarted": "Get Started",
    "BreadCrumbShippingBilling": "Shipping",
    "BreadCrumbReview": "Review",
    "BreadCrumbDone": "Done",
    "TitleAutomatic": "Enter your info automatically",
    "FacebookConnect": "Facebook connect",
    "FacebookHelpText1": "Use my Facebook profile to get PayPal automatically.",
    "FacebookHelpText2": "We'll never post on your wall.",
    "FacebookHelpText3": "We don't share your info.",
    "Or": "or",
    "TitleManual": "Enter your info manually",
    "EmailLabel": "Email",
    "PhoneLabel": "Mobile",
    "PrefillEmail": "Email",
    "PrefilPhone": "Phone number",
    "LoginLink": "Already have an account? Log in.",
    "Continue": "Continue"
  },
  "guestUpgrade": {
    "title": "Confirm your PayPal account",
    "emailFlowTitle": "Just review your information and create a password.",
    "titleTerms": "Terms and conditions",
    "agreements": "PayPal's <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a>, <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a>, and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/AcceptableUse_full&locale.x=en_US>Acceptable Use Policy</a>.",
    "understand": "The <a class=popup xo-popup target=_blank target=_new href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/esign_full&locale.x=en_US>Electronic Communications Delivery Policy</a>. I understand PayPal will provide me with information about my account electronically.",
    "readAndAgree": "I have read & agree to these Terms",
    "propHead": "Discover the world's favorite way to pay",
    "propVal1": "Enter your financial information once",
    "propVal2": "Securely check out with just your email and password",
    "propVal3": "Shop at thousands of merchants",
    "propVal4": "Faster, safer, easier. It's everything checkout should be.",
    "agrementError": "Please confirm that you have read and agree to the PayPal Terms and Conditions.",
    "contactInfo": "Contact info",
    "billingAddress": "Billing address",
    "confirmCard": "Confirm your",
    "fullSignupLink": "If you want to use different info, <a class=popup xo-popup target=_blank href='https://www.paypal.com/us/signup/account'>sign up using new details.</a>",
    "existingMemberInterstitialTitle": "Check out faster without entering your card info or password",
    "existingMemberInterstitialSubTitle": "That's right! Just confirm who you are once – we'll text you a one-time code. Then PayPal will log you in automatically on this device and browser. Not recommended on shared devices."
  },
  "inlineCard": {
    "valueInvalid": "Value is invalid",
    "email": "Email",
    "payNow": "Pay Now",
    "required": "Required",
    "validZipCode": "Enter a valid ZIP code",
    "validPhone": "Enter a valid phone number",
    "validEmail": "Enter a valid email address",
    "validCreditCard": "Enter a valid card number",
    "validDebitCard": "Enter a valid debit card number",
    "validExpirationDate": "Enter a valid expiration date",
    "validCSC": "Enter a valid CSC",
    "invalidEmail": "Enter a valid email address",
    "continuetext": "Continue",
    "firstName": "First name",
    "lastName": "Last name",
    "cardNumber": "Card number",
    "expiresLabel": "Expires",
    "expiresPlaceholder": "MM/YY",
    "cscPlaceholder": "CSC",
    "cscLabel": "CSC",
    "postalCode": "Postal code",
    "phoneLabel": "Mobile",
    "otherOptions": "Payment options",
    "poweredBy": "Powered by",
    "collectBillingAddressForAMEX": "American Express needs your billing to confirm your purchase",
    "merchantRequiresBillingAddress": "This merchant requires your billing address to complete this purchase",
    "guestTerms": "I confirm that I am of legal age and agree to the PayPal <a href=https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full xo-popup class=popup target=_blank>Privacy Statement</a>., inlineCard.currencyConversionLabel=Currency conversion inlineCard.paypalRate=PayPal's rate: {origin} = {converted} inlineCard.bankRate=Bank rate: {origin} = {converted}",
    "seeConversionOptions": "See conversion options",
    "currencyConversionSubLabel": "PayPal processes payments for this merchant",
    "convertWithPayPalOptionLabel": "Convert with PayPal",
    "convertWithCardIssuerOptionLabel": "Convert with card issuer",
    "convertedTimeLabel": "Converted as of {time}",
    "amountYouWillPay": "Amount you'll pay:",
    "finalAmountByYourCardIssuer": "Final amount detemined by your card issuer.",
    "agree": "Agree",
    "rateForThisCurrencyConversion": "Rate for this currency conversion.",
    "PayPalRate": "PayPal rate",
    "cardIssuerRate": "Card issuer rate",
    "totalPayDCC": "Total you'll pay:",
    "youWillPay": "You'll pay:",
    "PayPalConversionRate": "PayPay's conversion rate: {rate}",
    "PayPalConversionSpread": "This rate includes a currency conversion fee of {spread}",
    "conversionIssuerDisclosure": "Your card issuer will determine the currency conversion rate and what fees they may charge. Check your statement for the final amount.",
    "goToXoonLabel": "Click here to continue"
  },
  "interstitialRememberMe": {
    "emailNotYou": "Not you?",
    "nameNotYouAction": "(Not you?)",
    "nameNotYou": "Hi, {firstName}!",
    "header": "Remember me for faster checkout on eBay",
    "subtext1": "No need to log in to PayPal every time you pay.",
    "subtext2": "Works on all your devices.",
    "subtext3": "Active until you cancel – just go to your PayPal profile or My eBay.",
    "security": "Protect your eBay and PayPal accounts: When you’re done shopping, always log out of eBay when using a public or shared device.",
    "rememberMe": "Remember Me",
    "mayBeLater": "Maybe Later",
    "dontAskAgain": "Don’t ask again"
  },
  "inlineGuest": {
    "valueInvalid": "Value is invalid",
    "email": "Email",
    "payNow": "Pay Now",
    "required": "Required",
    "validZipCode": "Enter a valid ZIP code",
    "validPhone": "Enter a valid phone number",
    "validEmail": "Enter a valid email address",
    "validCreditCard": "Enter a valid card number",
    "validDebitCard": "Enter a valid debit card number",
    "validExpirationDate": "Enter a valid expiration date",
    "validCSC": "Enter a valid CSC",
    "invalidEmail": "Enter a valid email address",
    "invalidPhone": "Check the phone number and try again.",
    "invalidFirstName": "Check your information and try again.",
    "invalidLastName": "Check your information and try again.",
    "invalidCardNumber": "Check the card number and try again.",
    "invalidCvv": "Check the CVV and try again.",
    "invalidExpiry": "Check the expiry and try again.",
    "continuetext": "Continue",
    "firstName": "First name",
    "lastName": "Last name",
    "cardNumber": "Card number",
    "expiresLabel": "Expires",
    "expiresPlaceholder": "MM/YY",
    "cscPlaceholder": "CSC",
    "cscLabel": "CSC",
    "postalCode": "Postal code",
    "phoneLabel": "Mobile",
    "otherOptions": "Payment options",
    "poweredBy": "Powered by",
    "collectBillingAddressForAMEX": "American Express needs your billing to confirm your purchase",
    "merchantRequiresBillingAddress": "This merchant requires your billing address to complete this purchase",
    "guestTerms": "I confirm that I am of legal age and agree to the PayPal <a href='https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full' xo-popup class=popup target=_blank>Privacy Statement</a>.",
    "currencyConversionLabel": "Currency conversion",
    "paypalRate": "PayPal's rate: {origin} = {converted}",
    "bankRate": "Bank rate: {origin} = {converted}",
    "seeConversionOptions": "See conversion options",
    "currencyConversionSubLabel": "PayPal processes payments for this merchant",
    "convertWithPayPalOptionLabel": "Convert with PayPal",
    "convertWithCardIssuerOptionLabel": "Convert with card issuer",
    "convertedTimeLabel": "Converted as of {time}",
    "amountYouWillPay": "Amount you'll pay:",
    "finalAmountByYourCardIssuer": "Final amount detemined by your card issuer.",
    "agree": "Agree",
    "rateForThisCurrencyConversion": "Rate for this currency conversion.",
    "PayPalRate": "PayPal rate",
    "cardIssuerRate": "Card issuer rate",
    "totalPayDCC": "Total you'll pay:",
    "youWillPay": "You'll pay:",
    "PayPalConversionRate": "PayPay's conversion rate: {rate}",
    "PayPalConversionSpread": "This rate includes our currency conversion spread of {spread}.",
    "goToXoonLabel": "Click here to continue",
    "conversionIssuerDisclosure": "Your card issuer will determine the currency conversion rate and what fees they may charge. Check your statement for the final amount.",
    "billingAddressPopupTitle": "Your billing address is required to complete this purchase",
    "somethingWentWrong": "Something went wrong. We'll take you back to checkout so you can try again.",
    "cardWasDeclined": "Your card was declined by issuing bank. To complete your payment, try different card.",
    "tryAgain": "Try Again",
    "singleInstallmentLabel": "Installment",
    "multipleInstallmentsLabel": "Select Installments for this purchase",
    "fixedInstallmentsLabel": "Installments",
    "of": "of",
    "billingZipCodeLabel": "Billing ZIP code",
    "DEFAULT_ERROR": "Unfortunately we were unable to process the request. Please try again.",
    "CANNOT_APPROVE_GUEST_CHECKOUT_WITH_CREDIT_CARD": "Invalid credit card data.",
    "HOSTED_FIELD_NOT_ALLOWED": "Session expired.",
    "TAX_ID_REQUIRED": "This card can’t be used for this payment. Please use a different card.",
    "SELECTED_INSTALLMENT_TERM_NOT_AVAILABLE": "We can only offer you a single installment for this credit card.",
    "CANNOT_FIND_ISSUER_COUNTRY_CODE": "Please try a different credit card.",
    "payWithDebitOrCreditCard": "Debit or Credit Card"
  },
  "installments": {
    "title": "Select installment",
    "save": "Save",
    "total": "Total"
  },
  "issuerDecline": {
    "genericDeclineWithIssuer": "Check your account at {issuer} before retrying this card.",
    "genericDecline": "Check your account at your card issuer before retrying this card.",
    "genericActionLink": "Retry",
    "insufficientFunds": "Check your account balance before retrying this card.",
    "expiredCard": "To use this card, give it a quick update.",
    "updateLink": "Update",
    "internalDeclineReview": "This card won't work for this purchase. To continue, choose another way to pay.",
    "internalDeclineAddCard": "This card won't work for this purchase. To continue, add another way to pay."
  },
  "landing": {
    "welcome": "Welcome to PayPal checkout",
    "facebookHeading": "Facebook sign-up",
    "signUpUsingFacebook": "Sign up using Facebook",
    "facebookWallDisclaimer": "We'll never post without your permission.",
    "or": "or",
    "signupOrLogin": "Sign up or log in with PayPal",
    "continueButtonlabel": "Continue",
    "email": "Email",
    "venmoLegal": "Purchases made using Venmo are subject to the <a href=\"https://venmo.com/legal/us-user-agreement\">Venmo User Agreement</a>, <a href=\"https://venmo.com/legal/us-privacy-policy\">Venmo Privacy Statement</a>, and <a href=\"https://venmo.com/legal/us-user-agreement/#authorized_merchant_payment_protection\">Venmo Authorized Merchant Payment Protection Policy</a>, rather than PayPal's policies and agreements.",
    "venmoButton": "Continue with Venmo",
    "venmoAvailableSoon": "Looking to pay with Venmo? It'll be available at {merchant} soon.",
    "baiduLegal": "Purchases made using Baidu are subject to the <a href=\"http://www.baidu.com/\">Baidu User Agreement</a> and <a href=\"http://www.baidu.com/\">Baidu Privacy Statement</a>.",
    "payWithBaidu": "Pay with Baidu",
    "paypalProcessBaidu": "PayPal processes payments to this merchant on behalf of Baidu.",
    "paypalBaiduDisclaimer": "The PayPal and Baidu Wallet partnership allows you to use your Baidu Wallet to pay merchants that support checking out with PayPal."
  },
  "largeScreenAccountCreation": {
    "title": "Create your PayPal account",
    "agreements": "I have read and agree to PayPal’s <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a>, <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a>, and the <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/AcceptableUse_full&locale.x=en_US>Acceptable Use Policy</a>, and the <a class=popup xo-popup target=_blank target=_new href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/esign_full&locale.x=en_US>Electronic Communications Delivery Policy</a>. I understand PayPal will provide me with the information about my account electronically.",
    "understand": "The <a class=popup xo-popup target=_blank target=_new href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/esign_full&locale.x=en_US>Electronic Communications Delivery Policy</a>. I understand PayPal will provide me with information about my account electronically.",
    "propHead": "Discover the world's favorite way to pay",
    "propVal1": "Thousands of shops - one password",
    "propVal2": "Securely store your financial info",
    "propVal3": "Never hunt for your wallet again",
    "propVal4": "Faster, safer, easier. It's everything checkout should be.",
    "agrementError": "Please confirm that you have read and agree to the PayPal Terms and Conditions.",
    "agrementErrorGB": "Please confirm that you have read, and you consent and agree to PayPal’s User Agreement and Privacy Statement.",
    "memberMsg": "Already a PayPal member?",
    "login": "Log in",
    "readAndAgreeEMEA": "I confirm that I have read, consent and agree to PayPal's  <a class=popup xo-popup target=_blank href=https://www.paypal.com/fr/webapps/mpp/ua/useragreement-full?locale.x=en_FR>User Agreement</a> and <a class=popup xo-popup target=_blank href=https://www.paypal.com/fr/webapps/mpp/ua/privacy-full?locale.x=en_FR>Privacy Statement</a> (including the processing and disclosing of my personal data), and I am of legal age. I understand that I can change my communication preferences any time in my PayPal Account Profile. For more information about PayPal, see our <a class=\"popup\" href=https://www.paypal.com/fr/webapps/mpp/ua/servicedescription-full>Key Payment and Service Information</a>.",
    "agreementErrorEMEA": "Please confirm that you have read, and you consent and agree to PayPal’s User Agreement and Privacy Statement."
  },
  "languages": {
    "da": "Dansk",
    "de": "Deutsch",
    "en": "English",
    "es": "Español",
    "fr": "Français",
    "he": "עברית",
    "id": "Bahasa Indonesia",
    "it": "Italiano",
    "ja": "日本語",
    "ko": "한국어",
    "nl": "Nederlands",
    "no": "Norsk Bokmål",
    "pl": "Polski",
    "pt": "Português",
    "ru": "Русский",
    "sv": "Svenska",
    "th": "ไทย",
    "tr": "Türkçe",
    "zh": "中文",
    "label": "Language selector, currently {language}"
  },
  "largeScreenAccountCreationBmlGuest": {
    "title": "Create a PayPal account",
    "description": "Create a PayPal account to easily track your purchases and make online payments.",
    "createAccountSectionTitle": "Create a PayPal account now",
    "signupLaterSectionTitle": "I'll do this later",
    "readAndAgree": "I have read and agree to PayPal's <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a>, <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a>, the <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/AcceptableUse_full&locale.x=en_US>Acceptable Use Policy</a>, and the <a class=popup xo-popup target=_blank target=_new href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/esign_full&locale.x=en_US>Electronic Communications Delivery Policy</a>. I understand that PayPal will provide me with information about my account electronically.",
    "signupLater": "We'll email a reminder to set up your PayPal account, or you can go to PayPal.com to do this at any time.",
    "agreeAndContinue": "Agree & Continue",
    "continueToMerchant": "Continue to {merchantName}",
    "propHead": "Discover the world's favorite way to pay",
    "propVal1": "Thousands of shops - one password",
    "propVal2": "Securely store your financial info",
    "propVal3": "Never hunt for your wallet again",
    "propVal4": "Faster, safer, easier. It's everything checkout should be.",
    "agrementError": "Please confirm that you have read and agree to the PayPal Terms and Conditions.",
    "agrementErrorGB": "Please confirm that you have read, and you consent and agree to PayPal’s and Privacy Statement.",
    "bmlContinue": "Continue",
    "bmlApproved": "You're approved!",
    "bmlApprovedMessage": "<strong>Your new credit line is {currencySymbol}{creditLine}</strong>, and your estimated monthly payment for today's purchase is {paymentCurrencySymbol}{monthlyPayment}. To use your credit line when you shop with PayPal, just create a PayPal account.",
    "bmlApprovedEmail": "Your statements will be sent to {email}."
  },
  "largeScreenAccountCreationGuest": {
    "title": "Create a PayPal account",
    "guestHeader": "Check out without a PayPal account",
    "guestTitle": "Check out as a guest!",
    "upsell": "Join the millions of people who rely on our security and convenience, whether they're shopping online or in stores.",
    "guestUpsell": "For a faster checkout every time you shop, why not create a PayPal account? You’ll be able to check out with just your email address and password.",
    "createAccount": "Yes! I’d like to create a PayPal account.",
    "guestTnc": "I have read, and I consent and agree to PayPal’s <a href=https://cms.paypal.com/uk/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_GB class=popup target=_blank>Privacy Statement</a> (including PayPal processing and disclosing my personal data). I understand I can change my communication preferences any time.  I also agree to the terms of PayPal <a href=https://www.paypal.com/uk/cgi-bin/merchantpaymentweb?cmd=xpt/UserAgreement/ua/PolicyPrivacyWax-outside class=popup target=_blank>Account Optional</a>.",
    "guestTncFR": "Please view, print or save the documents linked below. For more information about PayPal, please read our <a href=https://www.paypal.com/fr/webapps/mpp/ua/servicedescription-full>Key Payment & Service Information.</a> You must be at least 18 years old to use PayPal.<br/><br/>I have read, and I consent and agree to PayPal’s <a href=https://www.paypal.com/fr/webapps/mpp/ua/privacy-full class=popup target=_blank>Privacy Statement</a>, specifically consenting to PayPal processing and disclosing my personal data and communicating with me according to that policy.",
    "emailMember": "You’ll use this email to log in to PayPal. If necessary, you can change your email address at PayPal.com.",
    "emailGuest": "We'll send your receipt to this email address. If you create an account, you'll use this to log in to PayPal.com."
  },
  "largeScreenPayment": {
    "title": "PayPal Guest Checkout",
    "titleProp": "We don’t share your financial details with the merchant.",
    "guestTitle": "Check out as a guest",
    "loginTitle": "Have an account? Log in now!",
    "shipTo": "Ship to my billing address",
    "propHead": "Serious about security",
    "propVal": "We don't share your financial details with the merchant, no matter where you shop.",
    "signupTitle": "Pay with debit or credit card",
    "getInstallments": "Select Installments",
    "bmlSorry": "Sorry…",
    "bmlContinue": "Continue",
    "micaEscapeHatchLink": "Log in now",
    "micaEscapeHatchDesc": "Have a PayPal account?",
    "blockNonDomesticShippingAlert": "The merchant only ships within {shippingCountry}.",
    "chooseAnOption": "Please choose an option before continuing.",
    "guestSignUpDesc": "Have a PayPal account?"
  },
  "largeScreenShipping": {
    "title": "Shipping address",
    "shipTo": "Ship to my billing address",
    "propHead": "Serious about security",
    "propVal": "We don't share your financial details with the merchant, no matter where you shop."
  },
  "largeScreenTermsGuest": {
    "title": "Terms and conditions",
    "spamOptInTitle": "Let's keep in touch!",
    "spamOptInDesc": "We send your receipts and account information via email, as well as special offers and promotions. We don’t share your information without your consent.",
    "agreeMarketing": "Yes!, I'd like to receive information from PayPal about products, services and promotions. PayPal won't share my information without my consent.",
    "viewPrintSaveFR": "Please view, print or save the documents linked below. For more information about PayPal, please read our <a class=\"popup\" href=https://www.paypal.com/fr/webapps/mpp/ua/servicedescription-full>Key Payment & Service Information.</a> You must be at least 18 years old to use PayPal."
  },
  "messenger": {
    "baHeader": "PayPal is on Messenger!",
    "fbHeader": "Add your PayPal account to Facebook",
    "disclaimer": "This authorization skips PayPal login when shopping in Facebook and Messenger. For security, we'll occasionally ask you to enter your username and password. You can cancel this authorization in your PayPal Account Settings.",
    "pluginHeader": "Get PayPal Notifications in Messenger",
    "legal": "Any notifications sent to Messenger may include personal data that can be used according to <a target=_blank href=https://www.facebook.com/policy.php>Facebook’s Data Policy</a>",
    "button_notNow": "Not Now",
    "integration": "Be sure to check Messenger for your receipts whenever you shop using PayPal",
    "linkedTitle": "You're all set to shop on Facebook",
    "linkedSubtitle": "When you're ready to shop, just choose PayPal at checkout!",
    "upsell": "Get PayPal Notifications in Messenger"
  },
  "micaTerms": {
    "headerAlt": "PayPal Credit",
    "returnToCheckout": "Return to Checkout",
    "shopNow": "Shop now.",
    "payOverTime": "Pay over time.",
    "bannerValueProp": "PayPal Credit makes it easier to buy the things you love. The application is simple and you’ll get a decision in seconds. You can manage your credit account at PayPal.com.",
    "easyPayments": "Easy Payments",
    "termsPara1": "Select Easy Payments at checkout to take advantage of special financing offers. If the purchase balance isn’t paid in full within the term you select, interest will be charged at an Annual Percentage Rate (APR) of 19.99% on any remaining balance. Read the complete <a class=\"creditOfferTerms popup\" href=\"https://cms.paypal.com/cgi-bin/marketingweb?cmd=_render-content&content_ID=bml/BMLTerms\">Terms and Conditions</a>.",
    "termsPara2": "If the merchant ships your items separately, the total price of each shipment will be divided into substantially equal payments. After you complete your purchase, your first payment will be due in 25 days or later.",
    "termsPara3": "The minimum payment on your account will include your Easy Payments purchase, as well as any other purchases you’ve made using PayPal Credit.",
    "termsPara4": "You can find your monthly payment amount – including the final payment amount – and other transaction details on your billing statement under the Active Promotions section.",
    "termsPara5": "You’ll need a PayPal account to manage your PayPal Credit account online.",
    "termsPara6": "<sup>*</sup>Special PayPal Credit promotional offers are available for a limited time only and may vary, depending on where you shop. Offers aren’t valid on previous returns, refunds, and exchanges, or when using the Send Money feature in your PayPal account. If approved, Comenity Capital Bank will extend credit to you to pay for your purchase, and will pay the merchant on your behalf.",
    "termsPara10": "The monthly payment shown is an estimated amount and may not include taxes and shipping. The total cost of your purchase will be divided into substantially equal monthly payments.",
    "headerTrusted": "PayPal Credit is trusted by millions of customers and accepted at thousands of stores.",
    "headerBenefits": "The benefits of PayPal Credit",
    "benefitsHeader1": "Flexibility and control",
    "benefitsDesc1": "Pay now or later, the choice is yours.",
    "benefitsHeader2": "An easy way to manage your purchases",
    "benefitsDesc2": "Track and manage purchases online, any time, or on your monthly statements.",
    "benefitsHeader3": "Faster checkout, no card required",
    "benefitsDesc3": "Just select PayPal Credit at checkout.",
    "benefitsHeader4": "Safer and more secure",
    "benefitsDesc4": "Eligible purchases are backed by PayPal purchase protection.",
    "headerFacts": "<sup><strong>†</strong></sup>Important facts",
    "termsPara7": "The minimum credit line is $250 and the Annual Percentage Rate (APR) is 19.99% and the Minimum Interest Charge is $2.00. Read the complete <a class=\"creditOfferTerms popup\" href=\"https://cms.paypal.com/cgi-bin/marketingweb?cmd=_render-content&content_ID=bml/BMLTerms\">Terms and Conditions</a>.",
    "termsPara8": "If you happen to pay late, you could be charged a late fee of up to $35. <a href=\"#termsFaq\">See FAQ</a>.",
    "termsPara9": "PayPal Credit is subject to credit approval as determined by the lender, Comenity Capital Bank, and is available to US customers who are of legal age in their state of residence. Read the complete <a class=\"creditOfferTerms popup\" href=\"https://cms.paypal.com/cgi-bin/marketingweb?cmd=_render-content&content_ID=bml/BMLTerms\">Terms and Conditions</a>.",
    "faqHeader": "Frequently asked questions",
    "faqQuestion1": "What is PayPal Credit?",
    "faqAnswer1": "PayPal Credit is a service with a credit line from Comenity Capital Bank that gives you the flexibility to pay for your purchase now, or pay over time. It’s easy to apply and easy to use.",
    "faqQuestion2": "How do I start using PayPal Credit?",
    "faqAnswer2": "Select PayPal Credit as your payment choice during checkout. You’ll be asked to provide your date of birth and the last 4 digits of your Social Security number, and then to agree to the terms and conditions. You’ll know within seconds if you are approved. And here’s the cool thing: link your PayPal Credit account to your PayPal account and you’ll see it as a payment option when you checkout with PayPal.",
    "faqAnswer2Para2": "Shopping on eBay? Look for the PayPal Credit option on the Choose Payment Method page, or when you check out with PayPal. PayPal Credit can be used for most purchases on eBay, except in the following categories: adult, digital goods, weapons, alcohol, and vehicles (PayPal Credit is available for auto parts and accessories).",
    "faqQuestion3": "How do I pay my PayPal Credit bill?",
    "faqAnswer3": "You’ll receive monthly statements and can choose to pay in full or over time (interest charges apply). For your convenience, you can keep track of your purchases and make payments on PayPal.com.",
    "faqQuestion4": "Is there an annual fee to use PayPal Credit?",
    "faqAnswer4": "Nope! There is no annual fee to use PayPal Credit.",
    "faqQuestion5": "Will I have a Credit Line and how much will it be?",
    "faqAnswer5": "Yes, you will! Once you’re approved, Comenity Capital Bank will open a PayPal Credit account with a Credit Line of at least $250.",
    "faqAnswer5Para2": "You can continue to use PayPal Credit for purchases and, if those purchases cause your outstanding balance to exceed your Credit Line, we’ll evaluate you for a Credit Line increase. This will happen automatically during checkout, so you don’t even need to ask.",
    "faqQuestion6": "What is the Annual Percentage Rate (APR)?",
    "faqAnswer6": "The Annual Percentage Rate for a PayPal Credit line is 19.99%, although some special offers have a lower, promotional APR.",
    "faqQuestion7": "What does ‘Subject to Credit Approval’ mean?",
    "faqAnswer7": "Comenity Capital Bank, the lender for PayPal Credit, will review and consider your credit report and other credit related information. Once you’re approved, they’ll open your account and establish your Credit Line. This process happens in a matter of seconds as a part of the checkout process.",
    "faqQuestion8": "Do you check my credit report every time I make a purchase?",
    "faqAnswer8": "No. A credit report is reviewed when you apply for PayPal Credit and occasionally when you attempt to increase your credit line. Periodically, we’ll obtain updates of your report, but these updates have no impact on your credit score. If for any reason your Credit Line is decreased, you’ll be notified of the reason in writing.",
    "faqQuestion9": "Is there a fee for late payments?",
    "faqAnswer9": "Yes, you will be charged a late fee for each month that the minimum payment is not paid by the payment due date. The first time you’re late, the amount of the late fee will be the same amount as the missed payment, up to $25. If you’re late again, the late fee will be up to $35.",
    "faqQuestion10": "Does PayPal Credit protect me from liability for unauthorized charges?",
    "faqAnswer10": "Yes! PayPal Credit provides zero fraud liability protection, the same protection provided by most major credit cards. And we verify your identity with top-of-mind information such as your date of birth and the last four digits of your Social Security number, so there’s no account number that can be lost or stolen.",
    "faqQuestion11": "Where else can I use PayPal Credit?",
    "faqAnswer11": "PayPal Credit is available on purchases at thousands of stores that accept PayPal. It’s also available for purchases on eBay and exclusively at thousands of other online stores."
  },
  "nbr": {
    "title": "You have a balance due",
    "body": "<p>An earlier payment you made using PayPal wasn’t successful, resulting in a balance of <em>{neg_bal}</em>, payable to PayPal. This balance will be added to today’s purchase and will appear as one charge on your statement.</p><p>For more information, please log in to PayPal.com and review your transaction history.</p>",
    "bodyPlural": "<p>An earlier payment you made using PayPal wasn’t successful, resulting in balances of <em>{neg_bal}</em> and <em>{neg_bal2}</em>, payable to PayPal. The combined amount will be added to today’s purchase and will appear as one charge on your statement.</p><p>For more information, please log in to PayPal.com and review your transaction history.</p>",
    "payBtn": "Continue"
  },
  "northernIreland": {
    "Antrim": "Antrim",
    "Armagh": "Armagh",
    "Down": "Down",
    "Fermanagh": "Fermanagh",
    "Londonderry": "Londonderry",
    "Tyrone": "Tyrone"
  },
  "oneTouchUpsell": {
    "promoHeading": "<b>Want a more convenient checkout experience next time? Try our automatic login – just review and pay</b>",
    "promoText1": "<b>Automatic log in with PayPal One Touch™</b> when you check out on this <b>device and browser</b> – no need to enter your email and password.",
    "promoText2": "Quickly review and pay <b>at millions of PayPal merchants</b>.",
    "promoText3": "For security, <b>we’ll occasionally ask you to log in</b>, including every time you make changes to your account or update your personal or financial info. We don’t recommend using One Touch on shared devices. Turn this off at any time in your PayPal Settings."
  },
  "noBalance": {
    "primaryMsg": "You have money waiting! Accept it when you go to your PayPal account summary.",
    "primaryMsgWithAmt": "You have {amt} waiting! Accept it when you go to your PayPal account summary.",
    "primaryMsgWithMultiAmt": "You have {amt1} and {amt2} waiting! Accept it when you go to your PayPal account summary.",
    "secondaryMsg": "You’ll need to set up PayPal Cash to use the money with PayPal, or you can move it to your bank."
  },
  "outlineOfCredit": {
    "outlineOfCreditTitle": "Outline of Credit",
    "lastUpdated": "Last updated on 05.05.2014",
    "returnToApp": "Return to the application",
    "isPayPalCreditSuitableQuestion": "Is PayPal Credit suitable for the type of credit you are looking for",
    "isPayPalCreditSuitableAnswer": "PayPal Credit is a revolving credit product and would be an expensive way to borrow large amounts over a long period. When making an application for a PayPal credit account, you are applying for Credit. It is important to note that you will only be offered one of these products, depending on your credit score.  It is important that you read the information provided to determine if PayPal Credit is suitable for your needs.",
    "repayUnderCreditQuestion": "How much will I have to repay under the Credit Agreement?",
    "repayUnderCreditAnswer": "The total amount you have to repay will depend on how much you spend using your PayPal Credit and how much of the outstanding balance you repay each month. You can pay off as much of the balance each month as you would like, but you must pay at least the minimum payment set out in your statement each month before the date shown there. Details of how this is calculated are set out in your pre-contract information. If you do not pay off the whole balance owed every month, you will be charged interest, which could mean it will take you longer, and cost you more, to repay the full balance.",
    "noRepaymentQuestion": "What are the consequences to me if I do not keep up with repayments?",
    "noRepaymentAnswer": "It is important that you make at least the minimum payment when it is due. Failure to make the minimum monthly payment on time will result in a late payment fee of £12. Other interest may be charged. As a consequence of this, the total cost of your debt may grow. If you don’t make your payments on time, we are entitled to record any defaults that you make at Credit Reference Agencies. This may make obtaining credit more difficult and more expensive in the future. We may also be entitled to move funds from your digital wallet with PayPal to settle any outstanding payments. It could also result in legal action being taken against you, by us, or a third party to whom we may have sold the debt, which could result in a court order being obtained and you incurring legal costs. A court order may result in any outstanding debt being secured against your home.",
    "withdrawCreditAgreementQuestion": "What rights do I have to withdraw from the Credit Agreement once I have entered it?",
    "withdrawCreditAgreementAnswer": "If you decide that you no longer want your new PayPal Credit, you have 14 days from the day after you receive confirmation of PayPal Credit to tell us you want to withdraw from the Credit Agreement. If you want to withdraw, you must tell us before the end of this time by writing to us at PayPal (Europe) S.à r.l. et Cie, S.C.A. Société en Commandite par Actions.",
    "featuresOfProductQuestion": "Are there any particular features of this credit product that I should be aware of?",
    "featuresOfProductAnswer": "Before accepting a PayPal Credit agreement, you should read the Pre-contract information and the Credit Agreement provided to you carefully, to ensure that this is the best product for you and that you understand the features of this product.Which credit product features should I particularly note?<p>Interest rates<br/>There are different interest rates for purchases and cash transactions.These are all set out in the Summary Box.Interest rates may changeWe may increase interest rates by giving you at least 30 days’ notice.Any increase could increase the amount you have to pay each month andmean that it takes you longer to repay any outstanding balance. We mayincrease your interest rate as a result of a rate change that isapplicable to all borrowers, or we may change the rate you are charged individually based on a number of factors, such as credit risk and the way you use your account.</p><p>Introductory interest rates<br/>Introductory interest rates may be offered with PayPal Credit. Details ofthese are contained in the pre-contract information.</p>"
  },
  "password": {
    "requirementLength": "Password must be between 8-20 characters",
    "requirementNumberSymbol": "Include at least one number or symbol (!@#$%^)",
    "restrictionEmail": "Do not use your email address",
    "restrictionFourRepeated": "Do not use four repeated characters",
    "restrictionFourSequence": "Do not use four key sequence",
    "restrictionMatch": "Passwords must match",
    "showPassword": "Show password",
    "hidePassword": "Hide password"
  },
  "scripts": {
    "restrictionNonValidCharacters": "Include at least 1 number, common punctuation, or symbol (!@#$%^&*)",
    "requirementLength": "Password must be at least 8 characters",
    "requirementNumberSymbol": "Include at least one number or symbol (!@#$%^)",
    "restrictionEmail": "Do not use your email address",
    "restrictionFourRepeated": "Do not use four repeated characters",
    "restrictionFourSequence": "Do not use four key sequence",
    "restrictionMatch": "Passwords must match",
    "restrictionDoubleByte": "Use only Latin characters and numbers",
    "confirm": "Please confirm that you have read and agree to the applicable PayPal agreements.",
    "required": "Required",
    "validZipCode": "Enter a valid ZIP code",
    "validPostalCode": "Enter a valid postal code",
    "validPostCode": "Enter a valid postcode",
    "validPhone": "Enter a valid phone number",
    "validEmail": "Enter a valid email address",
    "validEmailOrPhone": "Enter a valid email address or phone number",
    "validCreditCard": "Enter a valid card number",
    "validStreet": "Enter letters and numbers only",
    "validExpirationDate": "Enter a valid expiration date",
    "validDate": "Enter a valid date",
    "validCSC": "Enter a valid CSC.",
    "validCPF": "Enter a valid CPF",
    "legalAge": "You must be at least 18 years of age",
    "validLast4": "Enter the last 4 digits of your SSN",
    "validAddressSansPoBox": "We cannot accept P.O. Boxes",
    "paypalCheckout": "PayPal Checkout",
    "areYouSure": "Are you sure? If you close this window, the information you just entered will be lost.",
    "editInfo": "Edit info",
    "selectAddress": "Select address",
    "phoneNo": "Account phone number",
    "threeDigits": "3 digits",
    "fourDigits": "4 digits",
    "email": "Email (for receipt)",
    "emailForReceipt": "Email (for receipt)",
    "continuetext": "Continue",
    "payNow": "Pay Now",
    "agreeAndApply": "Agree & Apply for Credit",
    "bmlSorryIneligible": "Sorry, you're not approved for PayPal Credit",
    "validIBAN": "Enter a valid IBAN number",
    "validIBANCountry": "You can only add a German bank account for this purchase.",
    "validRouting": "Enter a valid routing number",
    "validDob": "Enter a valid birth date",
    "agreeAndPay": "Agree and Pay",
    "agreeAndContinue": "Agree and Continue",
    "reviewingApp": "Reviewing your application...",
    "fewMoments": "This will only take a few moments...",
    "secureWindowmsg": "Don’t see the secure PayPal browser? We’ll help you re-launch the window to complete your purchase.  <a onclick='PAYPAL.apps.Checkout.restartFlow();' class='ppbutton'>Continue</a>",
    "addBankandContinue": "Add Bank and Continue",
    "addCardandContinue": "Add Card and Continue",
    "password": "Password",
    "pin": "PIN",
    "passwordOrPin": "Password or PIN"
  },
  "passwordRecovery": {
    "quickSecurityCheck": "Quick security check",
    "stepUpAddCard": "Before you add a debit or credit card, you'll need to do a quick security check and create a PayPal password.",
    "stepUpAddShipping": "Before you add a new shipping address, you'll need to do a quick security check and create a PayPal password.",
    "stepUpBenefits": "Don't worry - you'll only need to do this once. This step will also give you access to all member benefits and account statements.",
    "stepUpApplyPPC": "Before you apply for PayPal Credit you'll need to do a quick security check and create a PayPal password.",
    "stepUpApplyPPCBenefits": "This step will also give you access to all member benefits and account statements, and make it easy to manage your credit line online.",
    "stepUpGeneric": "To make changes to your PayPal account, you'll need to do a quick security check and create a PayPal password.",
    "stepUpGenericBenefits": "Adding a password will also give you access to all member benefits and account statements.",
    "stepUpNewPhone": "The merchant provided a new phone number for you. To confirm this number and add it to your PayPal account, you'll need to do a quick security check and create a PayPal password.",
    "stepUpNeedUSAddress": "The merchant only ships within the United States. To add a US shipping address to your PayPal account, you'll need to do a quick security check and create a PayPal password.",
    "stepUpCardExpired": "Your card has expired. To update it or add a new card to your PayPal account, you'll need to do a quick security check and create a PayPal password.",
    "stepUpMerchantNotAcceptAmex": "The merchant doesn't accept American Express. To add a new card to complete your payment, you'll need to do a quick security check and create a PayPal password.",
    "stepUpContigencyAddCard": "To add a valid card to complete your purchase, you'll need to do a quick security check and create a PayPal password.",
    "stepUpNewAddress": "The merchant provided a shipping address that you haven't used before. To confirm this address and add it to your PayPal account, you'll need to do a quick security check and create a PayPal password.",
    "stepUpBillingAgreements": "Before you set up pre-approved payments, you'll need to do a quick security check and create a PayPal password.",
    "stepUpContigencyGeneric": "Before you complete your purchase, you'll need to do a quick security check and create a PayPal password."
  },
  "payWith": {
    "assistHeader": "How do you want to pay today?",
    "assistBody": "Use this payment method or add another card. We'll save it to your account so you won't need to enter it again when you checkout with PayPal."
  },
  "payment": {
    "existingMemberError": "You might already have an account, <a id=\"loginLink\" href=\"{loginLink}\">Login</a>",
    "signUpMaxCardsError": "This card has been added to the maximum number of PayPal accounts. Already have an account? <a id=\"loginLink\" href=\"{loginLink}\">Log in</a> now. Otherwise, please use a different card.",
    "optionalSignUpMaxCardsError": "This card has been added to the maximum number of PayPal accounts. Already have an account? <a id=\"loginLink\" href=\"{loginLink}\">Log in</a> now. Otherwise, use a different card or continue without creating an account.",
    "paymentTitle": "Pay and create an account",
    "payWithCard": "Pay with a debit or credit card",
    "createAccountA11y": "Account creation",
    "createAccount": "Create your PayPal account",
    "cardNotAccepted": "The merchant doesn't accept this type of card.",
    "cardExists": "Another PayPal member is already using this credit card. Please add a different card.",
    "agreements": "PayPal's <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a>, <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a>, and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/AcceptableUse_full&locale.x=en_US>Acceptable Use Policy</a>.",
    "understand": "The <a class=popup xo-popup target=_blank target=_new href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/esign_full&locale.x=en_US>Electronic Communications Delivery Policy</a>. I understand PayPal will provide me with information about my account electronically. I confirm that I can access emails, web pages, and PDF files.",
    "agreeNote": "You must agree to the terms and conditions.",
    "guestCardDeclined": "This credit card has been denied by the bank that issued it. For details on why your card was denied, please contact your credit card issuer's customer service department. Please enter a different card.",
    "guestLimitsExceeded": "You need to create a PayPal account to complete the payment",
    "guestLimitsExceededForMember": "The card you entered cannot be used for this payment. Please enter a different card.",
    "processorDeclineMember": "Sorry, but your {type} x-{number} was declined. You can complete your purchase with the payment method selected, or choose another way to pay.",
    "processorDeclineMemberGeneric": "Sorry, but your card was declined. You can complete your purchase with the payment method selected, or choose another way to pay.",
    "processorDeclineMemberNoFI": "Sorry, but your {type} x-{number} was declined. Please add another debit or credit card to complete your purchase.",
    "processorDeclineMemberNoFIGeneric": "Sorry, but your card was declined. Please add another debit or credit card to complete your purchase.",
    "processorDeclineMemberBuyerCredit": "Sorry, but we couldn't complete your purchase using the payment method you selected. You can complete your purchase with the payment method shown, or choose another way to pay.",
    "processorDeclineMemberBuyerCreditNoFI": "Sorry, but we couldn't complete your purchase using the payment method you selected. Please add a debit or credit card.",
    "authFailureSingleFI": "Sorry, we weren't able to authorize your card. Please add a different card.",
    "authFailureMultipleFIs": "Sorry, we weren't able to authorize your card. Please choose another way to pay.",
    "processorDeclineIssuerMember": "Hi {name}. {issuer} declined your {type} ••••{number}. You can still complete your purchase—just choose another way to pay.",
    "processorDeclineIssuerMemberNoIssuer": "Hi {name}. Your card issuer declined your {type} ••••{number}. You can still complete your purchase—just choose another way to pay.",
    "processorDeclineIssuerGuest": "Hi there. {issuer} declined your {type} ••••{number}. Check your info and try again, or use another card.",
    "processorDeclineIssuerGuestNoIssuer": "Hi there. Your card issuer declined your {type} ••••{number}. Check your info and try again, or use another card.",
    "processorDeclineBlacklistFIPreferredIssuer": "Hi {name}. {issuer} declined your {type} ••••{number}. You can choose another payment method to pay now, or contact {issuer} and try your preferred card again.",
    "processorDeclineBlacklistFIPreferredNoIssuer": "Hi {name}. Your card issuer declined your {type} ••••{number}. You can choose another payment method to pay now, or contact your card issuer and try your preferred card again.",
    "processorDeclineBlacklistFINoPreferredIssuer": "Hi {name}. {issuer} declined your {type} ••••{number}. You can choose another payment method to pay now, or contact {issuer} and try your card again.",
    "processorDeclineBlacklistFINoPreferredNoIssuer": "Hi {name}. Your card issuer declined your {type} ••••{number}. You can choose another payment method to pay now, or contact your card issuer and try your card again.",
    "processorDeclineBlacklistNoFIPreferredIssuer": "Hi {name}. {issuer} declined your {type} ••••{number}. You can <a href=\"{addCardhref}\" id=\"addCardMessageLink\">add a debit or credit card</a> to pay now, or contact {issuer} and try your preferred card again.",
    "processorDeclineBlacklistNoFIPreferredNoIssuer": "Hi {name}. Your card issuer declined your {type} ••••{number}. You can <a href=\"{addCardhref}\" id=\"addCardMessageLink\">add a debit or credit card</a> to pay now, or contact your card issuer and try your preferred card again.",
    "processorDeclineBlacklistNoFINoPreferredIssuer": "Hi {name}. {issuer} declined your {type} ••••{number}. You can <a href=\"{addCardhref}\" id=\"addCardMessageLink\">add a debit or credit card</a> to pay now, or contact {issuer} and try your card again.",
    "processorDeclineBlacklistNoFINoPreferredNoIssuer": "Hi {name}. Your card issuer declined your {type} ••••{number}. You can <a href=\"{addCardhref}\" id=\"addCardMessageLink\">add a debit or credit card</a> to pay now, or contact your card issuer and try your card again."
  },
  "prefectureListJP": {
    "aa": "Hokkaido",
    "ab": "Aomori",
    "ac": "Iwate",
    "ad": "Miyagi",
    "ae": "Akita",
    "af": "Yamagata",
    "ag": "Fukushima",
    "ah": "Ibaraki",
    "ai": "Tochigi",
    "aj": "Gunma",
    "ak": "Saitama",
    "al": "Chiba",
    "am": "Tokyo",
    "an": "Kanagawa",
    "ao": "Niigata",
    "ap": "Toyama",
    "aq": "Ishikawa",
    "ar": "Fukui",
    "as": "Yamanashi",
    "at": "Nagano",
    "au": "Gifu",
    "av": "Shizuoka",
    "aw": "Aichi",
    "ax": "Mie",
    "ay": "Shiga",
    "az": "Kyoto",
    "ba": "Osaka",
    "bb": "Hyogo",
    "bc": "Nara",
    "bd": "Wakayama",
    "be": "Tottori",
    "bf": "Shimane",
    "bg": "Okayama",
    "bh": "Hiroshima",
    "bi": "Yamaguchi",
    "bj": "Tokushima",
    "bk": "Kagawa",
    "bl": "Ehime",
    "bm": "Kochi",
    "bn": "Fukuoka",
    "bo": "Saga",
    "bp": "Nagasaki",
    "bq": "Kumamoto",
    "br": "Oita",
    "bs": "Miyazaki",
    "bt": "Kagoshima",
    "bu": "Okinawa"
  },
  "paypalCreditContract": {
    "paypalCreditContractTitle": "PayPal Credit Contract",
    "readAndAgree": "Please read and agree to the terms in the PayPal Credit Contract",
    "creditLimit": "Credit Limit",
    "interestRates": "Interest rates",
    "payments": "Payments",
    "charges": "Charges",
    "agreeAndContinue": "Agree and Continue",
    "confirmTerms": "I confirm that I have read and agree to the online PayPal Credit Contract above."
  },
  "paymentMethod": {
    "paymentMethodTitle": "Pay with",
    "eCheckDescription": "eChecks take 3-5 business days to process. We advise merchants not to ship until they receive payment.",
    "conversionRate": "{currencyFrom} = {currencyTo}",
    "backup": "(backup)",
    "noBackup": "No backup",
    "of": "of",
    "payWith": "Pay with",
    "savedPaymentMethods": "Saved payment methods",
    "payMerchantWithPayPal": "Pay {merchantName} with PayPal",
    "payAfter": "Pay After Delivery",
    "eCheck": "eCheck",
    "conversionDate": "Converted as of {date}",
    "changeConversionLink": "View the <a ui-sref=\"checkout.review.sidebar.currencyConversion\">conversion rate options</a> for this purchase",
    "optInConversionLink": "Conversion rate options",
    "changeInstallmentLink": "Select installments",
    "changeInstallmentLongLink": "Select installments for this purchase",
    "installmentPreselectedHelp": "You are only allowed to make a one installment payment with this card.",
    "paypalBalance": "Balance",
    "paymentMethodUpdated": "Payment method updated",
    "guestXoTitle": "Check out as a guest",
    "signupTitle": "Create a PayPal account",
    "padFs": "<span class=\"fsname\">{bank}</span> x-{last4} <span class=\"txt\">on <a href=\"#\" id=\"padHelp\">{date}</a></span>",
    "padHelpTxt": "Get your items before you pay, at no extra cost",
    "padHelpTxtList": "If you have any problems, you have 45 days to file a dispute. See details.",
    "padHelpTxtList1": "We'll send an alert before charging your account on {date}.",
    "padHelpTxtList2": "Eligible purchases are covered by <a href=https://www.paypal.com/us/webapps/mpp/paypal-safety-and-security class=popup target=_blank>PayPal Purchase Protection</a>.",
    "padHelpTxtList3": "Pay After Delivery with PayPal - tell your friends!",
    "padTnc": "<a href='https://www.paypal.com/?cmd=xpt/Marketing/general/Hoptc-outside#tc' class='popup' target='_blank'>Pay After Delivery Terms and Conditions</a>",
    "firstPayment": "Your first payment will be due in 25 days or later.",
    "firstPaymentEmail": "Statements will be sent to {email}.",
    "firstPayment2": "Your first payment will be due in 25 days or later. Statements will be sent to",
    "iach": "Direct debit",
    "meft": "Bank transfer",
    "msbOffer": "Exclusive Offer",
    "msbToolTipOffer": "Exclusive Offer",
    "instantTransfer": "Direct debit",
    "msbHelpText": "You saved {amount} today!",
    "msbDetails": "Details",
    "msbToolTipText": "Thanks for checking out with PayPal! We automatically applied your special offer of {amount} off a purchase of {minimumPurchase} or more.",
    "msbToolTipText2": "Thanks for checking out with PayPal! We automatically applied your special offer of {amount} off.",
    "label": "Change payment method",
    "pinlessDebit": "ATM/Debit card",
    "venmoMerchantDisclosure": "The merchant has requested an authorization for this payment, and the final payment amount may change when the merchant completes the order.",
    "venmoBalance": "Your Venmo Balance",
    "venmoBackupFS": "Your backup payment method {name} x-{last4} may be used if you no longer have enough Venmo balance to cover the entire purchase at the time the transaction is completed by the merchant.",
    "venmoBillingAgreement": "I want to use my Venmo account for future payments to {merchant}, subject to the <a href=https://venmo.com/legal/us-user-agreement/ xo-popup class=popup target=_blank>Venmo User Agreement</a>. I understand that if I have enough available funds in my Venmo balance to cover the entire payment, that balance will be used to complete my payment, but if not, my selected preferred payment method will be used for the entire payment. Payments won’t be split between my Venmo balance and my preferred payment method. I can change my preferred payment method or cancel this authorization in my Venmo Settings.",
    "venmoBalanceInfo": "Money added to your Venmo balance before this transaction completes may be used to complete your payment.",
    "venmoReceipt": "Your merchant receipt may say PayPal, but your Venmo account will be charged.",
    "venmoLearnMore": "<a href=https://venmo.com/legal/us-payment-method-rights/ xo-popup class=popup target=_blank>Learn more</a> about your rights when using different payment methods.",
    "emptyPlanHeader": "Your preapproved payments",
    "baiduWallet": "Baidu Wallet",
    "cardBackupDescription": "We’ll use your backup payment method if there’s a problem with the card you chose.",
    "cycoSsotWarning": "We're sorry, something went wrong. Please choose another way to pay.",
    "chooseBackup": "Choose a backup (recommended)",
    "billmelater": "PayPal Credit",
    "billmelatershort": "PayPal Credit",
    "easyPayments": "<strong>PayPal Credit — {numberOfPayments} payments of ${monthlyInstallment} per month,</strong><br/> {apr}% APR, {interest} est. interest, {totalPayment} payments total.",
    "bmlTitle": "PayPal Credit",
    "SACPayments": "PayPal Credit — No Payments + No Interest if paid in full in 6 months",
    "noInterest": "Estimated interest $0 if paid in full in 6 months."
  },
  "provinceList": {
    "province": "Province",
    "ab": "Alberta",
    "bc": "British Columbia",
    "mb": "Manitoba",
    "nb": "New Brunswick",
    "nl": "Newfoundland and Labrador",
    "ns": "Nova Scotia",
    "nt": "Northwest Territories",
    "nu": "Nunavut",
    "on": "Ontario",
    "pe": "Prince Edward Island",
    "qc": "Quebec",
    "sk": "Saskatchewan",
    "yt": "Yukon"
  },
  "provinceListES": {
    "province": "Province",
    "alava": "Alava",
    "albacete": "Albacete",
    "alicante": "Alicante",
    "almeria": "Almeria",
    "asturias": "Asturias",
    "avila": "Avila",
    "badajoz": "Badajoz",
    "barcelona": "Barcelona",
    "burgos": "Burgos",
    "caceres": "Caceres",
    "cadiz": "Cadiz",
    "cantabria": "Cantabria",
    "castellon": "Castellon",
    "ceuta": "Ceuta",
    "ciudad": "Ciudad",
    "cordoba": "Cordoba",
    "cuenca": "Cuenca",
    "gerona": "Gerona",
    "granada": "Granada",
    "guadalajara": "Guadalajara",
    "guipuzcoa": "Guipuzcoa",
    "huelva": "Huelva",
    "huesca": "Huesca",
    "islasBaleares": "Islas Baleares",
    "jaen": "Jaen",
    "laCoruna": "La Coruna",
    "lasPalmas": "Las Palmas",
    "laRioja": "La Rioja",
    "leon": "Leon",
    "lerida": "Lerida",
    "lugo": "Lugo",
    "madrid": "Madrid",
    "malaga": "Malaga",
    "melilla": "Melilla",
    "murcia": "Murcia",
    "navarra": "Navarra",
    "orense": "Orense",
    "palencia": "Palencia",
    "pontevedra": "Pontevedra",
    "salamanca": "Salamanca",
    "santaCruzdeTenerife": "Santa Cruz de Tenerif",
    "segovia": "Segovia",
    "sevilla": "Sevilla",
    "soria": "Soria",
    "tarragona": "Tarragona",
    "teruel": "Teruel",
    "toledo": "Toledo",
    "valencia": "Valencia",
    "valladolid": "Valladolid",
    "vizcaya": "Vizcaya",
    "zamora": "Zamora",
    "zaragoza": "Zaragoza"
  },
  "provinceListBR": {
    "province": "Estado",
    "AC": "Acre",
    "AL": "Alagoas",
    "AP": "Amapá",
    "AM": "Amazonas",
    "BA": "Bahia",
    "CE": "Ceará",
    "DF": "Distrito Federal",
    "ES": "Espírito Santo",
    "GO": "Goiás",
    "MA": "Maranhão",
    "MT": "Mato Grosso",
    "MS": "Mato Grosso do Sul",
    "MG": "Minas Gerais",
    "PA": "Pará",
    "PB": "Paraíba",
    "PR": "Paraná",
    "PE": "Pernambuco",
    "PI": "Piauí",
    "RJ": "Rio de Janeiro",
    "RN": "Rio Grande do Norte",
    "RS": "Rio Grande do Sul",
    "RO": "Rondônia",
    "RR": "Roraima",
    "SC": "Santa Catarina",
    "SP": "São Paulo",
    "SE": "Sergipe",
    "TO": "Tocantins"
  },
  "poma": {
    "heading": "Save your payment info for faster checkout on this device",
    "para1": "Speed through checkout faster than ever with One Touch™ and a PayPal account.",
    "para2": "How fast?",
    "para2Bullet1": "Choose PayPal on eligible merchant sites",
    "para2Bullet2": "Review your purchase and click to pay",
    "para3": "That’s it! With One Touch, you can skip login on this device – no password or card info to enter. (We don’t recommend enabling One Touch on shared devices.)",
    "para4": "You’ll need to create a password later to access all other member benefits and account statements – check your email for important details.",
    "saveMyInfoCheckBox": "Save my payment info and create a PayPal account",
    "legalTerms": "I want to use PayPal One Touch to pay participating merchants from this device without entering a password. I understand I will need to create a password later to access all other features of my account. Please create my PayPal account now - I have read and agree to the <a href=\"https://www.paypal.com/us/webapps/mpp/ua/esign-full\" target=\"_new\" class=\"popup\">E-Communications Delivery Policy</a>, which provides that PayPal is an online service and that I will receive all account notices and information electronically via my primary email address. I have also read and agree to the <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">User Agreement</a> and <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Privacy Statement</a>. If you provide a mobile phone number, you give us permission to contact you about your PayPal branded accounts using automated calls or texts to: service your accounts, investigate fraud, or collect a debt, but not for telemarketing. If you don’t want to receive automated calls or texts, you can change your preferences by contacting customer support.",
    "headingB": "Now PayPal offers an easier way to create an account for faster check out",
    "para1B": "Save the info you just entered to create a PayPal account enabled with One Touch™. When you shop at eligible merchants on this device, we’ll automatically log you in – no password, or card or shipping details to enter.",
    "para2B": "You’ll need to create a password later to access all PayPal member benefits and account statements – check your email for important details.",
    "saveMyInfoCheckBoxB": "Save my payment info and create a PayPal account enabled with One Touch. (Note: We don’t recommend enabling One Touch on shared devices.)"
  },
  "provinceListIT": {
    "province": "Province",
    "outsideItaly": "Outside of Italy",
    "agrigento": "Agrigento",
    "alessandria": "Alessandria",
    "ancona": "Ancona",
    "aosta": "Aosta",
    "arezzo": "Arezzo",
    "ascolipiceno": "Ascoli Piceno",
    "asti": "Asti",
    "avellino": "Avellino",
    "bari": "Bari",
    "barlettaandriatrani": "Barletta-Andria-Trani",
    "belluno": "Belluno",
    "benevento": "Benevento",
    "bergamo": "Bergamo",
    "biella": "Biella",
    "bologna": "Bologna",
    "bolzano": "Bolzano",
    "brescia": "Brescia",
    "brindisi": "Brindisi",
    "cagliari": "Cagliari",
    "caltanissetta": "Caltanissetta",
    "campobasso": "Campobasso",
    "carboniaiglesias": "Carbonia-Iglesias",
    "caserta": "Caserta",
    "catania": "Catania",
    "catanzaro": "Catanzaro",
    "chieti": "Chieti",
    "como": "Como",
    "cosenza": "Cosenza",
    "cremona": "Cremona",
    "crotone": "Crotone",
    "cuneo": "Cuneo",
    "enna": "Enna",
    "fermo": "Fermo",
    "ferrara": "Ferrara",
    "florence": "Florence",
    "foggia": "Foggia",
    "forli": "Forli",
    "frosinone": "Frosinone",
    "genoa": "Genoa",
    "gorizia": "Gorizia",
    "grosseto": "Grosseto",
    "imperia": "Imperia",
    "isernia": "Isernia",
    "laquila": "L'Aquila",
    "laspezia": "La Spezia",
    "latina": "Latina",
    "lecce": "Lecce",
    "lecco": "Lecco",
    "livorno": "Livorno",
    "lodi": "Lodi",
    "lucca": "Lucca",
    "macerata": "Macerata",
    "mantova": "Mantova",
    "massacarrara": "Massa Carrara",
    "matera": "Matera",
    "mediocampidano": "Medio Campidano",
    "messina": "Messina",
    "milan": "Milan",
    "modena": "Modena",
    "monzabrianza": "Monza Brianza",
    "naples": "Naples",
    "novara": "Novara",
    "nuoro": "Nuoro",
    "ogliastra": "Ogliastra",
    "olbiatempio": "Olbia-Tempio",
    "oristano": "Oristano",
    "padova": "Padova",
    "palermo": "Palermo",
    "parma": "Parma",
    "pavia": "Pavia",
    "perugia": "Perugia",
    "pesaro": "Pesaro",
    "pescara": "Pescara",
    "piacenza": "Piacenza",
    "pisa": "Pisa",
    "pistoia": "Pistoia",
    "pordenone": "Pordenone",
    "potenza": "Potenza",
    "prato": "Prato",
    "ragusa": "Ragusa",
    "ravenna": "Ravenna",
    "reggiocalabria": "Reggio Calabria",
    "reggioemilia": "Reggio Emilia",
    "rieti": "Rieti",
    "rimini": "Rimini",
    "rome": "Rome",
    "rovigo": "Rovigo",
    "salerno": "Salerno",
    "sassari": "Sassari",
    "savona": "Savona",
    "siena": "Siena",
    "sondrio": "Sondrio",
    "syracuse": "Syracuse",
    "taranto": "Taranto",
    "teramo": "Teramo",
    "terni": "Terni",
    "trapani": "Trapani",
    "trento": "Trento",
    "treviso": "Treviso",
    "trieste": "Trieste",
    "torino": "Torino",
    "udine": "Udine",
    "varese": "Varese",
    "venice": "Venice",
    "verbanocusioossola": "Verbano-Cusio-Ossola",
    "vercelli": "Vercelli",
    "verona": "Verona",
    "vibovalentia": "Vibo Valentia",
    "vicenza": "Vicenza",
    "viterbo": "Viterbo"
  },
  "redirectToUX": {
    "proceed": "Click <a href={redirectURL}>here</a> to proceed.",
    "returnToMerchantToFinishCheckout": "Your account's been created. Please  <a href={redirectURL}>return to {merchantName}</a> to finish checking out."
  },
  "rememberMe": {
    "remember": "Remember me for faster checkout on eBay.",
    "more": "Learn more",
    "close": "Close",
    "skipLogin": "Skip PayPal login when you checkout on eBay, on any device.",
    "toCancel": "Good until you cancel in your PayPal profile or My eBay.",
    "protectAccounts": "Protect your eBay and PayPal accounts. On public  or shared devices, always sign out of eBay when you’re done shopping.",
    "new": "New"
  },
  "scotland": {
    "AberdeenCity": "Aberdeen City",
    "Aberdeenshire": "Aberdeenshire",
    "Angus": "Angus",
    "ArgyllandBute": "Argyll and Bute",
    "Banffshire": "Banffshire",
    "Borders": "Borders",
    "Clackmannan": "Clackmannan",
    "DumfriesandGalloway": "Dumfries and Galloway",
    "EastAyrshire": "East Ayrshire",
    "EastDunbartonshire": "East Dunbartonshire",
    "EastLothian": "East Lothian",
    "EastRenfrewshire": "East Renfrewshire",
    "EdinburghCity": "Edinburgh City",
    "Falkirk": "Falkirk",
    "Fife": "Fife",
    "Glasgow": "Glasgow",
    "Highland": "Highland",
    "Inverclyde": "Inverclyde",
    "Midlothian": "Midlothian",
    "Moray": "Moray",
    "NorthAyrshire": "North Ayrshire",
    "NorthLanarkshire": "North Lanarkshire",
    "Orkney": "Orkney",
    "PerthshireandKinross": "Perthshire and Kinross",
    "Renfrewshire": "Renfrewshire",
    "Roxburghshire": "Roxburghshire",
    "Shetland": "Shetland",
    "SouthAyrshire": "South Ayrshire",
    "SouthLanarkshire": "South Lanarkshire",
    "Stirling": "Stirling",
    "WestDunbartonshire": "West Dunbartonshire",
    "WestLothian": "West Lothian",
    "WesternIsles": "Western Isles"
  },
  "rewards": {
    "header": {
      "default": "Credit card rewards",
      "chase": "Pay with Ultimate Rewards<sup>®</sup> Points for a statement credit",
      "citi": "Citi ThankYou<sup>®</sup> Points",
      "discover": {
        "cashback": "Discover Cashback Bonus<sup>®</sup>",
        "miles": "Discover Miles"
      },
      "amex": "Membership Rewards<sup>®</sup> Points"
    },
    "rewardsAvailble": {
      "default": "{rewardPoints} reward points available.",
      "chase": "{rewardPoints} Ultimate Rewards<sup>®</sup> Points available ({currency_symbol}{rewardAmount}).",
      "citi": "{rewardPoints} ThankYou Points<sup>®</sup> available ({currency_symbol}{rewardAmount}).",
      "discover": {
        "cashback": "{currency_symbol}{rewardPoints} Cashback Bonus<sup>®</sup> available",
        "miles": "{rewardPoints} Discover Miles available ({currency_symbol}{rewardAmount})."
      },
      "amex": "{rewardPoints} Membership Rewards<sup>®</sup> Points available ({currency_symbol}{rewardAmount})."
    },
    "formInputLabel": {
      "default": "{currency_symbol}",
      "citi": "{currency_symbol}",
      "discover": {
        "cashback": "Cashback Bonus<sup>®</sup> to use {currency_symbol}",
        "miles": "{currency_symbol}"
      },
      "amex": "{currency_symbol}"
    },
    "formResultLabel": {
      "default": "{rewardPoints} points",
      "citi": "{rewardPoints} points",
      "discover": {
        "miles": "{rewardPoints} miles"
      },
      "amex": "{rewardPoints} points"
    },
    "subText": {
      "default": "Any remainder will be charged to {issuerName} ••••{last4Digits}",
      "chase": "When you use your points for a statement credit, the full purchase amount will be charged to your Chase ••••{last4Digits}. Chase will apply a credit to your account for any available points used.",
      "citi": "Any remainder will be charged to Citi ••••{last4Digits}",
      "discover": {
        "cashback": "Any remainder will be charged to Discover ••••{last4Digits}",
        "miles": "Any remainder will be charged to Discover ••••{last4Digits}"
      },
      "amex": "The full amount for this purchase will be charged to your American Express ••••{last4Digits}. You’ll get a statement credit from American Express for the amount of points used, usually in 2 to 4 business days."
    },
    "policy": {
      "default": "PayPal’s Pay with Rewards terms apply. Points availability and redemption value are determined by {issuerName}",
      "chase": "PayPal’s Pay with Rewards terms apply. Chase Ultimate Rewards points availability and redemption value are determined by Chase.",
      "citi": "PayPal’s Pay with Rewards terms apply. Citi ThankYou Points availability and redemption value are determined by Citi.",
      "discover": {
        "cashback": "PayPal’s Pay with Rewards terms apply. Discover Cashback Bonus availability and redemption value are determined by Discover.",
        "miles": "PayPal’s Pay with Rewards terms apply. Discover Miles availability and redemption value are determined by Discover."
      },
      "amex": "PayPal’s Pay with Rewards terms apply. Membership Rewards Points availability and redemption value are determined by American Express."
    },
    "secondLineText": {
      "default": "Reward Points available",
      "chase": "Ultimate Rewards<sup>®</sup> Points available",
      "citi": "ThankYou<sup>®</sup> Points available",
      "discover": {
        "cashback": "Cashback Bonus<sup>®</sup> available",
        "miles": "Discover Miles available"
      },
      "amex": "Membership Rewards<sup>®</sup> Points available"
    },
    "useAmount": {
      "default": "Use rewards amount: ({rewardAmount})",
      "chase": "Use Ultimate Rewards<sup>®</sup> Points for a",
      "citi": "Use ThankYou<sup>®</sup> Points: {rewardAmount} ({currency_symbol}{currencyAmount})",
      "discover": {
        "cashback": "Use Cashback Bonus<sup>®</sup>: {currency_symbol}{rewardAmount}",
        "miles": "Use Discover Miles: {rewardAmount} ({currency_symbol}{currencyAmount})"
      },
      "amex": "Use Membership Rewards<sup>®</sup> Points for a statement credit: {rewardAmount} ({currency_symbol}{currencyAmount})"
    },
    "chargeAmount": {
      "default": "Total purchase amount will be charged to {issuerName} ••••{last4Digits}",
      "chase": "Total purchase amount will be charged to Chase  ••••{last4Digits}",
      "citi": "Any remainder will be charged to Citi ••••{last4Digits}",
      "discover": {
        "cashback": "Any remainder will be charged to Discover ••••{last4Digits}",
        "miles": "Any remainder will be charged to Discover ••••{last4Digits}"
      },
      "amex": "Total purchase amount will be charged to AmEx ••••{last4Digits}"
    },
    "changeAmount": {
      "default": "Change amount",
      "chase": "statement credit",
      "citi": "Change amount",
      "discover": {
        "cashback": "Change amount",
        "miles": "Change amount"
      },
      "amex": "Change amount"
    },
    "enterValidAmount": {
      "default": "Enter a valid amount",
      "minimum": "Enter an amount greater than {value}.",
      "moreThanAvailable": "The amount you entered is more than the number of available points.",
      "moreThanPurchase": "The amount you entered is more than your purchase amount."
    }
  },
  "review": {
    "reviewTitle": "Pay and create an account",
    "coverMe": "PayPal can cover me, and I'll repay you in 14 days.",
    "a11yDelayedPayment": "Delayed payment for 7 days",
    "wePayMerchant": "We pay the merchant",
    "yougetGoods": "You get your goods",
    "youpayUs": "You pay us within 7 days",
    "noCatch": "No interest, no fees, no catch. We want you to see how fast and easy PayPal is. That’s why we’ll cover your first purchase while you try it out — you have 7 days to pay us back. Just link a card to PayPal within that time, and we’ll charge your payment to it.",
    "noThanksIWillPay": "No, thanks. I'll pay for my stuff now.",
    "payWithCard": "I'll pay with a card now.",
    "payWithDebitCreditCard": "Enter a card",
    "paypalWillCoverMe": "Wait! You cover me, and I'll repay you instead.",
    "a11yAccountCreation": "Account creation",
    "createPaypalAccount": "Create a PayPal account",
    "putYourWalletAway": "Put your wallet away",
    "coverYouForNow": "We'll cover you for now",
    "agreeToTerms": "Please confirm that you have read and agree to the applicable PayPal agreements.",
    "agreements": "PayPal's <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a>, <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a>, and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/AcceptableUse_full&locale.x=en_US>Acceptable Use Policy</a>.",
    "understand": "The <a class=popup xo-popup target=_blank target=_new href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/esign_full&locale.x=en_US>Electronic Communications Delivery Policy</a>. I understand PayPal will provide me with information about my account electronically. I confirm that I can access emails, web pages, and PDF files.",
    "agreeNote": "You must agree to the terms and conditions.",
    "reviewDetailsTitle": "Review the details",
    "tokenizationInfo": "If you don’t have enough PayPal Cash balance to cover your purchase, we’ll automatically top it up from the bank or debit card you choose.",
    "readAndAgree": "I have read & agree to these Terms and Conditions",
    "topupAmountLabel": "Top up amount",
    "topupFundingLabel": "Top up from",
    "topupCommonSetting": "This setting will apply to all PayPal products that use automatic top up.",
    "topupSetupAgreements": "I have read and agree to the PayPal <a class=popup xo-popup target=_blank href=https://www.paypal.com/us/webapps/mpp/ua/ppandroidpay-tnc>Terms of Use for Google Pay</a>.",
    "topupTokenizedWalletSetupAgreements": "I have read and agree to the PayPal <a class=popup xo-popup target=_blank href={link}>Terms of Use for {type}</a>.",
    "topupFundingSourceInfo": "No money will be transferred to your PayPal Cash balance at this time.",
    "inStorePinLabel": "In-Store PIN",
    "inStorePinYear": "Your birth year",
    "inStorePinPhone": "Last 4 of your phone number",
    "inStorePinUnset": "Set a PIN",
    "pinFirstEntry": "Set a PayPal PIN for in-store purchases",
    "pinSecondEntry": "Confirm your in-store PIN",
    "pinBadEntry": "Re-enter your PIN",
    "pinChanged": "You set a PIN for in-store purchases",
    "pinMissMatch": "The PIN you entered did not match.",
    "pinError": "Please set a PIN for in-store purchases.",
    "pinSubText": "You can manage your PIN in your PayPal settings.",
    "pinEasy": "Avoid using an easy-to-guess PIN like 1234 or 5555."
  },
  "selectShipping": {
    "deletePhone": "Delete this phone number?",
    "accountPhone": "Account phone number",
    "deleteAddress": "Delete this address?",
    "addAddress": "Add an address",
    "preferred": "Preferred",
    "others": "Others",
    "blockNonDomesticShippingInfo": "The merchant doesn't ship outside {shippingCountry}."
  },
  "shipping": {
    "shippingTitle": "Shipping address",
    "shipToBillingAddress": "Ship to billing address",
    "shippingLabel": "Shipping",
    "shippingMethodTitle": "Shipping method",
    "orderChoiceLabel": "How do you want to get your order?",
    "shipItTab": "Ship It",
    "pickItUp": "Pick It Up",
    "selectShippingMethod": "Choose a shipping option",
    "selectPickUpLocation": "Choose a pickup option",
    "pickupInStore": "Pick up in store",
    "storePickup": "In-store pick up",
    "pickupOption": "Pick it up",
    "collection": "Collection",
    "expressPickup": "Express pickup",
    "clickCollect": "Click and collect",
    "shipToStore": "Ship to store",
    "collectPlus": "Collect via Collect+",
    "pickupFromStore": "Pick up from store",
    "freeNextDayStoreDelivery": "Free next day store delivery",
    "buyAndCollect": "Buy and collect",
    "shipToLocker": "Ship to locker",
    "shipToHome": "Ship to your address",
    "shipHome": "Shipping method",
    "shipStore": "Pickup option",
    "ShipOnlyHeader": "Ship to",
    "PickupOnlyHeader": "Pick up",
    "pickupDetails": "The merchant will contact you with pickup details.",
    "bopisErrorMessage": "Please make a selection as to how you want to receive this order.",
    "customLabelAndAmount": "{label} – {amount}"
  },
  "sepa": {
    "heading": "Direct Debit Agreement",
    "terms": "European guidelines require that you accept the SEPA direct debit mandate in order to process your payment. This way banks are enabled to process your payment faster and more efficiently.",
    "chkbxLabel": "By Clicking <b>Accept and continue</b> you agree to the <a target=\"blank\" id=\"sepaMandateLink\" href=\"{sepaMandateUrl}\">SEPA direct debit mandate</a> and authorize PayPal to send instructions to your bank account. You also authorize your bank to debit your account in accordance with the instructions from PayPal. A refund must be claimed within 8 weeks starting from the date on which your account was debited.",
    "sepaAcceptance": "You agree to the <a target=\"blank\" id=\"sepaMandateLink\" href=\"{sepaMandateUrl}\">SEPA direct debit mandate</a> and authorize PayPal to send instructions to your bank account. You also authorize your bank to debit your account in accordance with the instructions from PayPal. A refund must be claimed within 8 weeks starting from the date on which your account was debited.",
    "agreeText": "I agree to the above",
    "agreeButton": "Agree & Continue",
    "acceptAndContinue": "Accept and continue",
    "title": "SEPA Direct Debit Mandate",
    "print": "Print this document",
    "intro": "When you make a purchase in the Single Euro Payments Area (SEPA), the Direct Debit Mandate gives you a fast and convenient way to pay directly from your bank account.",
    "owner": "Account owner",
    "iban": "IBAN",
    "bank": "Bank",
    "bic": "BIC",
    "date": "Date",
    "location": "Location",
    "creditor": "Creditor",
    "creditorID": "ID",
    "legal": "By accepting the SEPA direct debit mandate, you authorize PayPal to send instructions to your bank account. You also authorize your bank to debit your account in accordance with the instructions from PayPal. A refund must be claimed within 8 weeks, starting from the date on which your account was debited.",
    "close": "Close this window",
    "decline": "Decline",
    "copyright": "Copyright (c) 1999-2015 PayPal. All rights reserved."
  },
  "shippingAddress": {
    "shippingAddressTitle": "Ship to",
    "shipTo": "Ship to",
    "preferred": "Preferred",
    "label": "Change shipping address",
    "yourAddress": "Your address",
    "merchantReq": "The merchant requires us to provide this information.",
    "errorInfo": "There’s a problem with your shipping address.",
    "errorDetail": "Please return to the merchant and update your information, including your city, state, and ZIP code."
  },
  "shippingMethod": {
    "selectMethod": "Select a shipping method",
    "merchantOptions": "The merchant supplies these shipping choices.",
    "continue": "Continue",
    "storeLocationInfo": "Contact the merchant for information about the pickup location.",
    "shipTo": "Ship to",
    "storeLocation": "Store Location",
    "shipping": "Shipping",
    "guestMerchantOptions": "These options are provided by the merchant based on your shipping address",
    "zipCode": "ZIP code",
    "pickUpNotAvailable": "Select a shipping method.",
    "shippingRegionUnsupported": "{merchant} doesn't ship to this location. Please use a different address.",
    "insuranceNoneSelected": "None",
    "shippingInsurance": "Shipping Insurance",
    "addShippingInsurance": "Add shipping insurance <b>{amount}</b>"
  },
  "shippingCallback": {
    "loading": "Contacting the merchant to update your shipping address.",
    "updated": "Based on your shipping address, your new total is {amount}."
  },
  "shippingCountry": {
    "US": "the United States"
  },
  "shoppingCart": {
    "shoppingCart": "Your shopping cart",
    "continueShopping": "Continue shopping",
    "description": "Description",
    "price": "Price",
    "orderSummary": "Order Summary",
    "shipHandling": "Shipping and handling",
    "welcome": "Welcome back, {userName}!",
    "powered": "Powered by PayPal",
    "poweredBy": "Powered by",
    "payWithoutAccount": "Pay without a PayPal account",
    "safeEasier": "The safer, easier way to pay",
    "remove": "Remove",
    "or": "or",
    "buttonText": "Log in or check out as a guest",
    "optionNames": "{key}:",
    "more": "more",
    "less": "less",
    "quantity": "Quantity",
    "cartEmpty": "Your cart is empty",
    "checkoutOut": "Check Out"
  },
  "signup": {
    "confirm": "Please confirm that you have read and agree to the applicable PayPal agreements.",
    "title": "Create a PayPal account and pay faster every time",
    "eBayTitle": "Speed through checkout on eBay and millions of merchants across the web. Create your PayPal account below.",
    "paypal": "PayPal",
    "agreeAndCreateAcc": "Agree & Create Account",
    "signupTerms": "I have read and agree to PayPal's <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full?locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">User Agreement</a>, <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full?locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Privacy Statement</a>, the <a href=\"https://cms.paypal.com/{country}/cgi-bin/?cmd=_render-content&content_ID=ua/AcceptableUse_full&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Acceptable Use Policy</a>, and the <a href=\"https://cms.paypal.com/{country}/cgi-bin/?cmd=_render-content&content_ID=ua/esign_full&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Electronic Communications Delivery Policy</a>.",
    "agrementError": "Please confirm that you have read and agree to the PayPal Terms and Conditions.",
    "dob": "Date of birth",
    "overlayMsg": "Don't see the secure PayPal browser? We'll help you re-launch the window to complete your signup.  <a onclick=\"PAYPAL.apps.Checkout.restartFlow();\" class=\"ppbutton\">Continue</a>",
    "success": "You now have a PayPal account.",
    "successSubTitle": "We'll send you a welcome email with information about your account.",
    "goBackNow": "Go back now.",
    "returnTimerMsg": "You'll be redirected to eBay in {waitTime} seconds.",
    "ebay": "eBay",
    "successTitle": "Your PayPal account is set up!",
    "successText1": "Use PayPal for faster checkout on eBay and with millions of other merchants.",
    "successText2": "Look for a welcome email with more account details.",
    "successText3": "You can <a href=\"https://www.paypal.com/myaccount/settings/\">manage your communication preferences</a> from your profile.",
    "returnToEbayMsg": "You'll return to eBay in a few seconds, or just select Back to eBay.",
    "backToEbay": "Back to eBay",
    "createAccountToday": "Create your account today",
    "createAccountDetails": "We’ll save your payment info to create your account. Just add a password and your next PayPal checkout could be as fast as 2 steps.",
    "paymentSuccessTitle": "Thanks for using PayPal!",
    "emailHelper": "You’ll use this email to log in to PayPal.",
    "loginDetails": "PayPal login details",
    "androidPayTitleProp": "Add a debit card to automatically top up your PayPal Cash or Cash Plus balance when you're ready to shop with Google Pay.",
    "tokenizedWalletInfoTitleProp": "Add a debit card to automatically top up your PayPal Cash or Cash Plus balance when you're ready to shop with {subject} Pay.",
    "createPayPalAccountFRSLine1Variant1": "Create an account and we'll cover eligible return shipping costs.",
    "createPayPalAccountFRSLine1Variant2": "Create an account to get Purchase Protection, free return shipping, and more.",
    "createPayPalAccountFRSLine1Variant3": "Create an account and we'll cover you if the purchase isn't what you expected.",
    "createPayPalAccountFRSLine1Variant4": "Create a free PayPal account and we'll cover eligible return shipping costs!",
    "createPayPalAccountFRSLine1Variant5": "Create an account to get Purchase Protection, free return shipping, and more.",
    "createPayPalAccountFRSLine1Variant6": "Shop online with peace of mind. Create a PayPal account and we'll cover you if the purchase isn't what you expected.",
    "createPayPalAccountFRSLine1Variant7": "Create a free PayPal account and we'll cover eligible return shipping costs!",
    "createPayPalAccountFRSLine1Variant8": "Create an account to get Purchase Protection, free return shipping, and more.",
    "createPayPalAccountFRSLine1Variant9": "Shop online with peace of mind. Create a PayPal account and we'll cover you if the purchase isn't what you expected.",
    "createPayPalAccountFRSLine2Variant1": "Just add a password to get this perk. <a href=\"https://www.paypal.com/{country}/webapps/mpp/returns/terms?locale.x={lang}_{country}\" target=\"_blank\">See Terms</a>",
    "createPayPalAccountFRSLine2Variant2": "Just add a password to get these perks. <a href=\"https://www.paypal.com/{country}/webapps/mpp/returns/terms?locale.x={lang}_{country}\" target=\"_blank\">See Terms</a>",
    "accountCreationGuest": {
      "heading": "Create a PayPal account!",
      "vprop": "When you pay using your PayPal account, the merchant doesn't see your financial information.",
      "vprop1": "Join the millions of people who rely on our security and convenience, whether they're shopping online or in stores.",
      "password": "Password",
      "cpassword": "Confirm password",
      "optionalHeading": "Create an account and check out faster",
      "optionalProp": "One convenient, secure place to keep all your ways to pay. PayPal doesn't share your financial information with merchants",
      "signupProp": "One convenient, secure place to keep all your ways to pay. PayPal doesn't share your financial information with merchants",
      "signupOptIn": "Yes! I’d like to create a PayPal account.",
      "payLabel": "Pay Now",
      "continueLabel": "Continue",
      "dobLabel": "Date of birth",
      "dobDay": "Day",
      "dobMonth": "Month",
      "dobYear": "Year"
    }
  },
  "shoppingCartBuyNow": {
    "header": "Purchase details",
    "item_name": "Description",
    "amount": "Price per item",
    "quantity": "Quantity",
    "cancel": "Cancel",
    "powered": "Powered by",
    "continue": "Continue"
  },
  "signupAccountCreation": {
    "heading": "Create a PayPal account!",
    "vprop": "When you pay using your PayPal account, the merchant doesn't see your financial information.",
    "vprop1": "Join the millions of people who rely on our security and convenience, whether they’re shopping online or in stores.",
    "password": "Create password",
    "cpassword": "Confirm password",
    "optionalHeading": "Create an account and check out faster",
    "optionalProp": "One convenient, secure place to keep all your ways to pay. PayPal doesn't share your financial information with merchants",
    "signupProp": "One convenient, secure place to keep all your ways to pay. PayPal doesn't share your financial information with merchants",
    "signupOptIn": "Yes! I'd love an easier way to check out. Create my account.",
    "idNumber": "ID number",
    "idType": "ID Type"
  },
  "signupBilling": {
    "heading": "Billing address",
    "shipto": "Ship to a different address"
  },
  "signupOnepage": {
    "updateCard": "Update or add a card",
    "addACard": "Add a card",
    "addNewBillingAddress": "Add new billing address",
    "primary": "Make Primary",
    "member": "Have an account?",
    "loginBtn": "Log in Now!"
  },
  "signupBml": {
    "bmlApplyHeadline": "Apply for PayPal Credit",
    "offerHeadline": "Get more time to pay with PayPal Credit",
    "econsentHeading": "E-Sign Consent",
    "payAnotherWay": "Want to pay with a debit or credit card instead?",
    "bmlApplyESign": "I have read the <a href='https://cms.paypal.com/cgi-bin/marketingweb?cmd=_render-content&content_ID=bml/BMLTerms' class='bmlTermsLink popup'>E-Sign Consent</a> and I agree to have the Terms & Conditions presented electronically.",
    "termsHeading": "PayPal Credit Terms and Conditions",
    "termsDescription": "There's a lot of important information here, so please scroll to the end before continuing.",
    "scrollMessage": "Please scroll down to the end before continuing.",
    "bmlTermsHeading": "PayPal Terms of Service",
    "bmlVerifyHeading": "Verify your identity",
    "seeTerms": "See <a href='https://www.securecheckout.billmelater.com/paycapture-content/fetch?hash=AU826TU8&content=/bmlweb/bmlppaiw.html' class='popup bmlTermsLink'>Terms</a>",
    "billingOfferHeadline": "$10 + 0% for 6 months for this purchase",
    "bmlApplySSNLastFour": "Last 4 SSN",
    "billMeLater": "PayPal Credit",
    "enterBillingAddress": "Enter your billing address",
    "scrollDown": "Please Scroll to the End",
    "bmlSorry": "Sorry, there was a problem",
    "payWithCard": "Pay With Card",
    "successTitle": "You're Approved!",
    "successMessage": "Your new credit line is <strong>${creditLine}</strong>. Use the balance whenever you shop with PayPal.",
    "lineOfCredit": "You're applying for a line of credit",
    "verifyTooltip": "Why do we need this",
    "verifyTooltipContent": "This helps us ensure it's really you applying for credit, and allows us to make a credit decision in seconds."
  },
  "signupShipping": {
    "heading": "Ship to",
    "usebilling": "Use my billing address"
  },
  "signupTerms": {
    "heading": "Agree to Terms",
    "readnAgree": "I have read and agree to the following:",
    "signupC": "I have read and agree to PayPal's <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">User Agreement</a>, <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Privacy Statement</a>, the <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/acceptableuse-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Acceptable Use Policy</a>, and the <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/esign-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Electronic Communications Delivery Policy</a>. I am authorized to add the phone number entered above and understand PayPal may contact me with automated calls and texts as described in the above agreements.",
    "deSignup": "By clicking Agree & Pay Account I agree to PayPal's <a href=\"https://www.paypalobjects.com/MERCHANTPAYMENTWEB-640-20130407-1/ua/DE_en_GB/ua.pdf\" target=\"_blank\">User Agreement</a>.",
    "deAgree": "Yes, I agree with the terms of use and <a href=\"https://cms.paypal.com/de/cgi-bin/marketingweb?cmd=_render-content&content_ID=ua/Privacy_popup\" target=\"_blank\">terms and conditions</a> of PayPal's information security, and accept an <a href=\"https://www.paypal.com/de/cgi-bin/merchantpaymentweb?cmd=xpt/Marketing/popup/UnconfirmedELV-outside\" target=\"_blank\">identity check</a>.",
    "gbTerms": "In order to process your payment, PayPal collects certain personal information from you which it holds in accordance with its <a href=\"https://www.paypal.com/uk/cgi-bin/merchantpaymentweb?cmd=xpt/UserAgreement/ua/PolicyPrivacy-outside\" target=\"_blank\">Privacy Statement</a>.",
    "agrementError": "Please confirm that you have read and agree to the PayPal Terms and Conditions.",
    "consumerAdvisory": "Consumer advisory - PayPal Pte. Ltd., the holder of PayPal's stored value facility, does not require the approval of the Monetary Authority of Singapore. Users are advised to read the <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/legalhub-full\" target=\"_blank\"> Terms and Conditions </a>carefully. By clicking the button below, I agree to be bound by PayPal’s <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full\" target=\"_blank\">  User Agreement </a> and the <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full\" target=\"_blank\">Privacy Statement</a>.",
    "consumerAdvisoryB": "Consumer advisory - PayPal Pte. Ltd., the holder of PayPal's stored value facility, does not require the approval of the Monetary Authority of Singapore. Users are advised to read the <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/legalhub-full\" target=\"_blank\"> Terms and Conditions </a>carefully. By clicking the button below, I agree to be bound by PayPal’s <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full\" target=\"_blank\">  User Agreement </a> and the <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full\" target=\"_blank\">Privacy Statement</a>.",
    "agreeMarketing": "I agree to receive marketing communications from PayPal. I can change my notification preferences at any time.",
    "guestTerms": "I confirm that I am of legal age and agree to the PayPal <a href=https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full xo-popup class=popup target=_blank>Privacy Statement</a>.",
    "marketingOptIn": "Yes, I’d like to receive PayPal marketing info and special offers via email. (Optional)",
    "signupTCPA": "I have read and agree to PayPal's <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">User Agreement</a>, <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Privacy Statement</a> and <a href=\"https://www.paypal.com/us/webapps/mpp/ua/esign-full\" target=\"_new\" class=\"popup\">Electronic Communications Delivery Policy</a>.  If you provide a mobile phone number, you agree that PayPal may contact you to service your account, investigate fraud, or collect a debt, using autodialed or prerecorded calls or texts. You may decline to receive autodialed or prerecorded calls or texts and still use PayPal by contacting <a href=\"https://www.paypal.com/selfhelp/contact/call\" target=\"_new\" class=\"popup\">customer support</a>.",
    "signupTCPA3": "Please create my PayPal account now - I have read and agree to the <a href=\"https://www.paypal.com/us/webapps/mpp/ua/esign-full\" target=\"_new\" class=\"popup\">E-Communications Delivery Policy</a>, which provides that PayPal is an online service and that I will receive all account notices and information electronically via my primary email address. I have also read and agree to the <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">User Agreement</a> and <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Privacy Statement</a>. If you provide a mobile phone number, you give us permission to contact you about your PayPal branded accounts using automated calls or texts to: service your accounts, investigate fraud, or collect a debt, but not for telemarketing. If you don’t want to receive automated calls or texts, you can change your preferences in your account settings at any time.",
    "easySignupTCPA": "You have read and agree to PayPal's <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">User Agreement</a>, <a href=\"https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full?country.x={country}&locale.x={lang}_{country}\" target=\"_new\" class=\"popup\">Privacy Statement</a> and <a href=\"https://www.paypal.com/us/webapps/mpp/ua/esign-full\" target=\"_new\" class=\"popup\">Electronic Communications Delivery Policy</a>.  If you provide your mobile number, you give us permission to contact you about your PayPal branded accounts using automated calls or texts to: service your accounts, investigate fraud, or collect a debt, but not for telemarketing. If you don’t want to receive automated calls or texts, you can change your preferences in your account settings at any time</a>.",
    "signupBankUnBranded": "I confirm that I have read, consent and agree to PayPal’s <a class=popup xo-popup target=_blank href=https://www.paypal.com/{country}/webapps/mpp/ua/useragreement-full?locale.x={lang}_{country}>User Agreement</a> and <a class=popup xo-popup target=_blank href=https://www.paypal.com/{country}/webapps/mpp/ua/privacy-full?locale.x={lang}_{country}>Privacy Statement</a>, and I am of legal age. I understand that I can change my communication preferences any time in my PayPal Account. I can read more about PayPal in the <a class=popup xo-popup target=_blank href=https://www.paypal.com/{country}/webapps/mpp/ua/servicedescription-full?locale.x={lang}_{country}>Key Payment and Service Information</a>."
  },
  "soldout": {
    "icon": "Sold Out",
    "message": "Sorry, <b>{item}</b> isn’t available at this time.",
    "continueShoppingButton": "Continue Shopping",
    "continueToShoppingCartButton": "Go to Shopping Cart",
    "twoItemMessage": "Sorry, <b>{item1}</b> and <b>{item2}</b> aren’t available at this time.",
    "multipleItemMessage": "Sorry, <b>{item1}</b>, <b>{item2}</b>, and <b>{item3}</b> aren’t available at this time.",
    "allItemMessage": "Sorry, your items aren’t available at this time."
  },
  "smartButtons": {
    "instantlyPayWith": "Instantly pay with",
    "poweredBy": "Powered by {paypal}",
    "chooseCardOrShipping": "Choose card or shipping address",
    "useDifferentAccount": "Use a different account",
    "deleteVaultedAccount": "Unlink your saved account",
    "deleteVaultedCard": "Unlink your saved card"
  },
  "smallToolTip": {
    "cardAdded": "Card added",
    "bankAdded": "Bank added",
    "cardUpdated": "Card updated",
    "addressAdded": "Address added",
    "addressUpdated": "Address updated",
    "onlyAddressUpdated": "Your shipping address has been updated.",
    "addressShippingChargesUpdated": "Your address and shipping costs have been updated.",
    "phoneAdded": "Phone number added",
    "phoneUpdated": "Phone number updated",
    "incentiveCreated": "You'll get {incentiveAmount} off this purchase. Welcome to PayPal!"
  },
  "spamOptIn": {
    "spamOptInTitle": "PayPal loves you!",
    "spamDescription": "Would you like to receive emails and possibly text messages from PayPal about their products and offers?",
    "spamDescriptionMobile": "From time to time, we’ll send you special offers and promotions. We don't share your information without your consent.",
    "spamOptInCheck": "Yes! I agree to receive marketing information from PayPal.",
    "yes": "Yes",
    "no": "No"
  },
  "spinner": {
    "authFlowContinue": "After we confirm your card, don't forget to complete your payment at {merchantName}.",
    "authFlowPayNow": "Confirming your card..."
  },
  "softDescriptor": {
    "transaction": "This transaction will appear on your account as a payment to PayPal * {merchantName}."
  },
  "splitScreenExp": {
    "guestOnboardTitle": "How would you like to pay?",
    "guestOnboardSubTitle": "We don’t share your full financial details with the merchant.",
    "signupOnboardTitle": "Create your account and pay",
    "signupOnboardSubTitle": "With a PayPal account, eligible purchases are covered by our Purchase Protection policy. You’re also eligible to enroll in our Return Shipping on Us program (<a href=\"https://www.paypal.com/webapps/mpp/returns/terms\" target=\"_blank\">See terms</a>). We don’t share your full financial details with the merchant.",
    "changeEmailInfo": "Check your email address. If you have a PayPal account with a different email, change it to log in.",
    "payPalAccountDetails": "PayPal account details",
    "paymentDetails": "Payment details",
    "change": "Change",
    "areYouSure": "Are you sure?",
    "confirmEmailChange": "If you change your email address, you’ll need to re-enter your payment details.",
    "yesChange": "Yes, change",
    "noDontChange": "No, don’t change",
    "FGAWarningMsg": "To use PayPal with a card registered in this country or region, you’ll need to <a href=\"{href}\">log in</a> or create a new account with a different email address."
  },
  "msb": {
    "popupContent": "Add your PayPal account and receive a {amount} reward towards your next purchase with PayPal and <span class=nowrap>{type}</span>.",
    "popupBtn": "Get Started",
    "popupLink": "Offer Terms and Conditions"
  },
  "stateList": {
    "AK": "AK - Alaska",
    "AL": "AL - Alabama",
    "AR": "AR - Arkansas",
    "AZ": "AZ - Arizona",
    "CA": "CA - California",
    "CO": "CO - Colorado",
    "CT": "CT - Connecticut",
    "DC": "DC - District of Columbia",
    "DE": "DE - Delaware",
    "FL": "FL - Florida",
    "GA": "GA - Georgia",
    "HI": "HI - Hawaii",
    "IA": "IA - Iowa",
    "ID": "ID - Idaho",
    "IL": "IL - Illinois",
    "IN": "IN - Indiana",
    "KS": "KS - Kansas",
    "KY": "KY - Kentucky",
    "LA": "LA - Louisiana",
    "MA": "MA - Massachusetts",
    "MD": "MD - Maryland",
    "ME": "ME - Maine",
    "MI": "MI - Michigan",
    "MN": "MN - Minnesota",
    "MO": "MO - Missouri",
    "MS": "MS - Mississippi",
    "MT": "MT - Montana",
    "NC": "NC - North Carolina",
    "ND": "ND - North Dakota",
    "NE": "NE - Nebraska",
    "NH": "NH - New Hampshire",
    "NJ": "NJ - New Jersey",
    "NM": "NM - New Mexico",
    "NV": "NV - Nevada",
    "NY": "NY - New York",
    "OH": "OH - Ohio",
    "OK": "OK - Oklahoma",
    "OR": "OR - Oregon",
    "PA": "PA - Pennsylvania",
    "RI": "RI - Rhode Island",
    "SC": "SC - South Carolina",
    "SD": "SD - South Dakota",
    "TN": "TN - Tennessee",
    "TX": "TX - Texas",
    "UT": "UT - Utah",
    "VA": "VA - Virginia",
    "VT": "VT - Vermont",
    "WA": "WA - Washington",
    "WI": "WI - Wisconsin",
    "WV": "WV - West Virginia",
    "WY": "WY - Wyoming",
    "AA": "AA - Armed Forces Americas",
    "AE": "AE - Armed Forces Europe",
    "AP": "AP - Armed Forces Pacific",
    "AS": "AS - American Samoa",
    "FM": "FM - Federated States of Micronesia",
    "GU": "GU - Guam",
    "MH": "MH - Marshall Islands",
    "MP": "MP - Northern Mariana Islands",
    "PR": "PR - Puerto Rico",
    "PW": "PW - Palau",
    "VI": "VI - Virgin Islands"
  },
  "stateListKR": {
    "Chungbuk": "North Chungcheong",
    "Chungam": "South Chungcheong",
    "Gangwon": "Gangwon",
    "Gyeonggi": "Gyeonggi",
    "Gyeongbuk": "North Gyeongsang",
    "Gyeongnam": "South Gyeongsang",
    "Jeju": "Jeju",
    "Jeonbuk": "North Jeolla",
    "Jeonnam": "South Jeolla"
  },
  "stateListAU": {
    "ACT": "ACT",
    "NSW": "NSW",
    "NT": "NT",
    "QLD": "QLD",
    "SA": "SA",
    "TAS": "TAS",
    "VIC": "VIC",
    "WA": "WA"
  },
  "subscriptions": {
    "message": {
      "startDate": "Starts on: {date}",
      "renewsUntilCancelled": "(Renews until you cancel)",
      "includesTax": "Includes a {tax}% tax set by the merchant",
      "setupFee": "One-time setup fee",
      "amount": "Amount",
      "updated": "You updated your automatic payments"
    },
    "guestHeader": "PayPal Guest Subscription"
  },
  "travelRule": {
    "travelRule": "We need more information",
    "note": "We're sorry, but government regulations require PayPal to collect a tax ID number for high-value payments. We keep this information secure and do not share it with the vendor.",
    "idType": "ID type",
    "ssnDropdownLabel": "Social Security Number",
    "taxIdDropdownLabel": "Individual Taxpayer Identification Number",
    "employerIdDropdownLabel": "Employer Identification Number",
    "passportDropdownLabel": "Passport Number",
    "aNumberDropdownLabel": "Alien Registration Number",
    "ssnDesc": "Use the tax ID from your personal tax return.",
    "taxIdDesc": "Use the tax ID from your personal tax return.",
    "employerIdDesc": "Use the tax ID from your business tax return.",
    "passportDesc": "The number and country or region of origin that appears on the identity page of your passport.",
    "aNumberDesc": "The 8-digit A-number as it appears on your Green Card.",
    "ssnPlaceholder": "xxx-xx-xxxx",
    "employerIdPlaceHolder": "xx-xxxxxxx",
    "payButton": "Pay Now",
    "pleaseEnterStreetAddress": "Please enter your street address (no P.O. Boxes):"
  },
  "threeDS": {
    "processing": "Contacting your bank...",
    "iFrameTitle": "Your bank has requested additional verification.",
    "memberDecline": "Sorry, your bank wasn’t able to verify your {cardType}-{last4} at this time. Please choose another way to pay.",
    "guestDecline": "Sorry, your bank wasn’t able to verify your {cardType}-{last4} at this time. Please try a different card.",
    "memberDeclineAfter3DSAccept": "Sorry, your bank wasn't able to verify your {cardType} x-{last4} at this time. Please choose another way to pay.",
    "memberDeclineAfter3DSAcceptNoFI": "Sorry, your bank wasn't able to verify your {cardType} x-{last4} at this time. Add another debit or credit card to complete your purchase.",
    "guestDeclineAfter3DSAccept": "Sorry, your bank wasn't able to verify your {cardType}-{last4} at this time. Please try a different card.",
    "preLoadContactIssuer": "Contacting your card issuer to confirm your card",
    "preLoadWaitMessage": "This may take a few seconds",
    "preLoadCaution": "Don't close or refresh the window"
  },
  "validation": {
    "required": "Required",
    "validZipCode": "Enter a valid ZIP code",
    "validPhone": "Enter a valid phone number",
    "validEmail": "Enter a valid email address",
    "validCreditCard": "Enter a valid card number",
    "validDebitCard": "Enter a valid debit card number",
    "validExpirationDate": "Enter a valid expiration date",
    "validCSC": "Enter a valid CSC",
    "validAddressNoPoBox": "You cannot use a P.O. Box with PayPal Credit.",
    "validDOB": "Enter a valid date of birth",
    "validNationalId": "Enter a valid national id",
    "validPrice": "Enter a valid price",
    "validQuantity": "Enter a valid quantity"
  },
  "ukOffshoreDependencies": {
    "ChannelIslands": "Channel Islands",
    "IsleofMan": "Isle of Man"
  },
  "wales": {
    "BlaenauGwent": "Blaenau Gwent",
    "Bridgend": "Bridgend",
    "Caerphilly": "Caerphilly",
    "Cardiff": "Cardiff",
    "Carmarthenshire": "Carmarthenshire",
    "Ceredigion": "Ceredigion",
    "Conwy": "Conwy",
    "Denbighshire": "Denbighshire",
    "Flintshire": "Flintshire",
    "Gwynedd": "Gwynedd",
    "IsleofAnglesey": "Isle of Anglesey",
    "MerthyrTydfil": "Merthyr Tydfil",
    "Monmouthshire": "Monmouthshire",
    "NeathPortTalbot": "Neath Port Talbot",
    "Newport": "Newport",
    "Pembrokeshire": "Pembrokeshire",
    "Powys": "Powys",
    "RhonddaCynonTaff": "Rhondda Cynon Taff",
    "Swansea": "Swansea",
    "Torfaen": "Torfaen",
    "TheValeofGlamorgan": "The Vale of Glamorgan",
    "Wrexham": "Wrexham"
  },
  "wallet": {
    "unsupportedByProduct": "Unavailable for this purchase. Select another way to pay.",
    "unsupportedDueToSenderPreference": "Unavailable for this purchase. Select another way to pay.",
    "unsupportedDueToReceiverPreference": "The merchant doesn’t accept this payment method.",
    "unsupportedByContry": "The merchant can’t accept this payment method.",
    "unsupportedDueToRisk": "Unavailable for this payment.",
    "unsupportedDueToNegativeBalance": "Your balance is insufficient for this transaction.",
    "disallowedDueToMissingBackupFundingSource": "Add a backup-funding source to complete your payment.",
    "unsupportedDueToExpiration": "Expired",
    "unsupportedDueToLimit": "Sorry, but this payment exceeds your PayPal transaction limit.",
    "unsupportedGeneric": "Unavailable for this purchase. Select another way to pay.",
    "balanceCoversPayment": "Your balance covers this purchase, so we’ll use that to complete the payment.",
    "balanceUsed": "Your balance will be used for this purchase. Select a way to pay the remainder.",
    "delete": "Delete",
    "update": "Update",
    "cardDeleted": "Your {type} x-{number} card has been deleted.",
    "cardUpdated": "Your {type} x-{number} card has been updated.",
    "editDisallowedPayment": "To update or remove this payment method, please log in to PayPal.com.",
    "seletedFIEditDisallowed": "Before you delete this payment method, select or add a different way to pay.",
    "editDisallowedBalance": "Your balance can’t be edited or deleted",
    "disallowedDueToExpiration": "This card has expired.",
    "disallowedDueToMerchantPreference": "The merchant doesn’t accept this card.",
    "disallowedDueToPreAuth": "This card can’t be validated.",
    "disallowedDueToPreAuthWithIssuer": "{issuer} can't validate this card.",
    "processorDeclinedCard": "This card has been declined."
  },
  "topup": {
    "topupAmountDesc": "Set an amount to automatically top up your PayPal Cash or Cash Plus balance if there isn't enough money for your Google Pay purchase.",
    "commonTopupAmountDesc": "Set an amount to automatically top up your PayPal Cash or Cash Plus balance if there isn't enough money for your {type} purchase.",
    "topupFundingDesc": "Choose a bank or debit card to automatically top up your balance if there isn't enough for your Google Pay purchase.",
    "commonTopupFundingDesc": "Choose a bank or debit card to automatically top up your balance if there isn't enough for your {type} purchase.",
    "topupFundingSourceDisallowed": "Can't be used for top up",
    "topupInfo1": "Set up your PayPal Cash account and pay <b>anywhere Google Pay is available</b>.",
    "commonTopupInfo1": "Set up your PayPal Cash account and pay <b>anywhere {type} is available</b>.",
    "topupInfo2": "We’ll <b>automatically top up your PayPal Cash balance</b> from your bank or debit card if you don’t have enough to cover the purchase. You can always update this in your PayPal Profile.",
    "commonTopupInfo2": "We’ll <b>automatically top up your PayPal Cash balance</b> from your bank or debit card if you don’t have enough to cover the purchase. You can always update this in your PayPal Profile.",
    "topupInfo3": "When you shop in stores with PayPal, <b>you may need to enter a PIN.</b> If you don't have a PIN yet, we'll help you set one up.",
    "topupInfoMayNeedPin": "When you shop in stores with PayPal, <b>you may need to enter a PIN.</b> If you don't have a PIN yet, we'll help you set one up.",
    "topupInfoHeading": "Using PayPal with Google Pay",
    "commonTopupInfoHeading": "Using PayPal with {type}",
    "addingAndroidPay": "Adding PayPal to Google Pay…",
    "commonAdding": "Adding PayPal to {type}...",
    "cfpb": {
      "commonHeading1": "Use PayPal in stores",
      "commonHeading2": "with {type}",
      "info": {
        "content1": "Get the security and convenience of PayPal",
        "content2": "everywhere {type} is accepted.",
        "content3": "First, let’s get you set up with a",
        "content4": "PayPal Cash account."
      }
    }
  },
  "wpsSubscription": {
    "label": {
      "free": "Free",
      "day": "day",
      "days": "days",
      "week": "week",
      "weeks": "weeks",
      "month": "month",
      "months": "months",
      "year": "year",
      "years": "years"
    },
    "message": {
      "terms": "Terms",
      "subscriptionDetails": "Subscription Details",
      "firstAmount": "First amount",
      "effectiveStartDate": "Effective Date:",
      "profileId": "Profile Id:",
      "firstTrialPeriod": {
        "singular": "{amount} for the first {timeUnit}",
        "plural": "{amount} for the first {timePeriod} {timeUnit}"
      },
      "secondTrialPeriod": {
        "singular": "Then {amount} for the next {timeUnit}",
        "plural": "Then {amount} for the next {timePeriod} {timeUnit}"
      },
      "regularSubscriptionPeriod": {
        "withPriorTerms": {
          "singular": {
            "recurring": "Then {amount} for each {timeUnit}, for {installmentCount} installments",
            "recurringInfinite": "Then {amount} for each {timeUnit}",
            "nonRecurring": "Then {amount} for one {timeUnit}"
          },
          "plural": {
            "recurring": "Then {amount} for each {timePeriod} {timeUnit}, for {installmentCount} installments",
            "recurringInfinite": "Then {amount} for each {timePeriod} {timeUnit}",
            "nonRecurring": "Then {amount} for {timePeriod} {timeUnit}"
          }
        },
        "noPriorTerms": {
          "singular": {
            "recurring": "{amount} for each {timeUnit}, for {installmentCount} installments",
            "recurringInfinite": "{amount} for each {timeUnit}",
            "nonRecurring": "{amount} for one {timeUnit}"
          },
          "plural": {
            "recurring": "{amount} for each {timePeriod} {timeUnit}, for {installmentCount} installments",
            "recurringInfinite": "{amount} for each {timePeriod} {timeUnit}",
            "nonRecurring": "{amount} for {timePeriod} {timeUnit}"
          }
        }
      },
      "done": {
        "subscriptionSignup": "You created a PayPal account and set up a subscription",
        "subscriptionGuest": "You paid <b>{amt}</b> and set up a subscription",
        "subscriptionMember": "You paid <b>{amt}</b> and set up a subscription",
        "subscriptionGuestFreeTrial": "You set up a subscription",
        "subscriptionMemberFreeTrial": "You set up a subscription",
        "legalText": "To review the agreement, change your payment method, or to cancel this authorization at any time, log in to <b><a href=\"https://www.paypal.com\">PayPal.com</a></b> and access your <b><a href=\"https://www.paypal.com/myaccount/settings/payments?locale.x={lang}_{country}&country.x={country}\">Settings</a></b>, or <b><a href=\"https://www.paypal.com/selfhelp/home?locale.x={lang}_{country}&country.x={country}\">Contact Us</a></b>. If you cancel this authorization, you may still owe the seller money depending on your agreement with them.",
        "papLegalText": "To review the agreement, change your payment method, or to cancel this authorization at any time, log in to <b><a href=\"https://www.paypal.com\">PayPal.com</a></b> and access your <b><a href=\"https://www.paypal.com/myaccount/settings/payments?locale.x={lang}_{country}&country.x={country}\">Settings</a></b>, or <b><a href=\"https://www.paypal.com/selfhelp/home?locale.x={lang}_{country}&country.x={country}\">Contact Us</a></b>.",
        "payment_target": "to {merchantName}"
      },
      "payWithoutAccount": "No PayPal account? Create one!",
      "loginToPay": "Log in to pay",
      "or": "or",
      "guestCheckout": "Guest Check Out",
      "signupSubscribe": "Create a PayPal account to subscribe",
      "memberSubscribe": "Log in to subscribe",
      "guestSubscribe": "Subscribe using a debit or credit card"
    },
    "error": {
      "accountCreatedSubscriptionFailed": "Your PayPal account is created but we weren’t able to complete your subscription.",
      "subscriptionFailed": "Sorry, we weren’t able to set up your {merchant} subscription.",
      "genericError": "Things don’t appear to be working at the moment. Please try again later.",
      "paymentFailure": "Sorry, we couldn't set up your subscription using the payment method you selected. Please try another payment method."
    },
    "button": {
      "signupSubscribe": "Create & Subscribe",
      "guestSubscribe": "Subscribe"
    },
    "guest": {
      "createAccountAndSubscribe": {
        "button": {
          "text": "Create Account & Subscribe"
        }
      }
    }
  },
  "A": "special requirement for credit in the US (and one line in DE) requires content be in English, regardless of localization settings. This solution was agreed upon with the localization team (sgolia@paypal.com). The content in this \"credit\" directory must be left untranslated.",
  "If": "you are tasked with making changes to this content, please ensure content parity with the following folder(s):",
  "-": "US/zh/credit",
  "common": {
    "forgotYourPassword": "Forgot your password?",
    "back": "Back",
    "continuetext": "Continue",
    "paytext": "Pay",
    "OK": "OK",
    "payWithPayPal": "Pay with PayPal",
    "payWithCard": "Pay with debit or credit card",
    "tryPayPal": "Try PayPal as a Guest",
    "addedSecurity": "Added security when you pay with a debit or credit card.",
    "getBenefitsLine1": "The security you want.",
    "getBenefitsLine2": "The protection you deserve.",
    "getBenefitsLine1Test1": "PayPal: brilliantly simple",
    "getBenefitsLine1Test2": "PayPal: easy to get, easy to use",
    "createPayPalProp": "Creating a PayPal account is optional but you’ll get <b>PayPal Purchase Protection</b> on all eligible purchases, plus faster checkout every time you shop. <a href=https://www.paypal.com/{country}/webapps/mpp/paypal-safety-and-security?locale.x={lang}_{country} target=_blank>See terms</a>",
    "createPayPalPropTest1": "We’ll save your payment info to create your account and pay. Just add a password and you’re ready to go.",
    "createPayPalPropTest2": "We’ll use your payment info to set up your PayPal account. Next time you choose PayPal, your checkout could be as fast as 2 steps. Just add a password.",
    "createPayPalPropTest3": "Just add a password – we’ll use your payment details to create your account and pay. Next time, check out in as few as 2 steps.",
    "createPayPalPropTest4": "Just add a password and you can shop at millions of merchants with your email and password – we’ll securely store your payment details.",
    "createPayPalSubTitle": "Create a PayPal account? (It only takes a moment.)",
    "createPayPalSubTitleSignup": "Create your PayPal account",
    "buyerProtectionSignup": "Get <b>PayPal Purchase Protection</b> on <a href=https://www.paypal.com/{country}/webapps/mpp/paypal-safety-and-security?locale.x={lang}_{country} target=_blank>eligible purchases</a>.",
    "cancel": "Cancel",
    "login": "Log In",
    "password": "Password",
    "passwordOrPin": "Password or PIN",
    "confirmPassword": "Confirm password",
    "createPassword": "Create password",
    "payLabel": "Pay Now",
    "continueLabel": "Continue",
    "notInterestedInPaymentPlans": "Not interested in payment plans?",
    "payInFullNow": "Pay in full now",
    "agreeAndPayNowPoma": "Agree & Pay Now",
    "agreeAndPay": "Agree & Pay",
    "agreeAndContinue": "Agree & Continue",
    "agreeAndCreateAccount": "Agree & Create Account",
    "createAccountAndPayNow": "Create Account & Pay Now",
    "textAboveAgreeButton": "You'll return to the merchant to complete your purchase.",
    "readAndAgree": "I have read and agree to these Terms.",
    "readAndAgreeGB": "I have read, and I consent and agree to PayPal's <a class=popup xo-popup target=_blank href=https://www.paypal.com/uk/webapps/mpp/ua/useragreement-full?locale.x=en_GB>User Agreement</a> and <a class=popup xo-popup target=_blank href=https://www.paypal.com/uk/webapps/mpp/ua/privacy-full?locale.x=en_GB>Privacy Statement</a> (including PayPal processing and disclosing my personal data). I understand I can change my communication preferences any time.",
    "readAndAgreeFR": "By ticking the box and clicking the button, I agree and consent to: <ul><li>the terms of the <a class=popup xo-popup target=_blank href=https://www.paypal.com/fr/webapps/mpp/ua/useragreement-full>User Agreement</a> and</li><li>the terms of the <a class=popup xo-popup target=_blank href=https://www.paypal.com/fr/webapps/mpp/ua/privacy-full>Privacy Statement</a></li></ul>",
    "readAndAgreeExtendedFR": "specifically consenting to PayPal processing and disclosing my personal data and communicating with me according to that policy. I understand that I can view and adjust my Communication Preferences at any time in my account Profile.",
    "agreementErrorFR": "Please confirm that you have read, and you consent and agree to PayPal’s <a class=popup xo-popup target=_blank href=https://www.paypal.com/fr/webapps/mpp/ua/useragreement-full>User Agreement</a> and <a class=popup xo-popup target=_blank href=https://www.paypal.com/fr/webapps/mpp/ua/privacy-full?locale.x=en_FR>Privacy Statement</a>.",
    "change": "Change",
    "yesCreateAccount": "Yes, I’d like a PayPal account.",
    "noCreateAccount": "No, I don’t want an account now.",
    "createPayPalAccount": "Would you like to create a PayPal account?",
    "reviewLater": "You’ll be able to review your order before you complete your purchase.",
    "select": "Select",
    "addNew": "Add new",
    "add": "Add",
    "edit": "Edit",
    "done": "Done",
    "save": "Save",
    "saveAndContinue": "Save & Continue",
    "nothanks": "No, thanks",
    "firstName": "First name",
    "lastName": "Last name",
    "name": "Name",
    "email": "Email",
    "emailOrPhone": "Email or Phone",
    "streetAddress": "Street address",
    "streetAddress2": "Apt., suite, bldg., etc.  (optional)",
    "streetAddressOptional": "Additional information (optional)",
    "streetAndHouse": "Street and house number",
    "city": "City",
    "onlyCity": "City",
    "state": "State",
    "stateUS": "State",
    "zip": "ZIP",
    "zipUS": "ZIP",
    "prefecture": "Prefecture",
    "postalCode": "Postal code",
    "postalCodeIfApplicable": "Postal code (if applicable)",
    "postCode": "Postcode",
    "cep": "CEP",
    "cityTown": "Town/City",
    "townCity": "City/Town",
    "countyOptional": "County (optional)",
    "provinceRegion": "Province/Region",
    "district": "District",
    "houseNameStreetAddress": "House name and street address",
    "town": "Town",
    "unitOrBuilding": "Unit number or building name",
    "residentialAddress": "Residential address",
    "residentialAddressTooltip": "We can’t accept a PO box",
    "suburb": "Suburb",
    "stateTerritory": "State/Territory",
    "county": "County",
    "phone": "Phone number",
    "phonePlaceholder": "xxx - xxx - xxxx",
    "phoneType": "Phone type",
    "phoneCountryCode": "Phone Country Code",
    "home": "Home",
    "landline": "Landline",
    "mobile": "Mobile",
    "work": "Work",
    "primary": "Primary",
    "update": "Update",
    "confirm": "Confirm",
    "submit": "Submit",
    "addAddress": "Add an address",
    "nojs": "Sorry, but to check out using PayPal, you need to turn on JavaScript and enable cookies in your web browser’s settings.",
    "preferredShipping": "Make this my preferred shipping address",
    "otherCity": "City / Town / Village",
    "otherState": "State / Province / Region",
    "otherPostalCode": "Postal code",
    "optionalPostalCode": "Postal code (optional)",
    "optionalState": "State / Province / Region (optional)",
    "stAddress": "Address",
    "agreements": "PayPal's <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/UserAgreement_full&locale.x=en_US>User Agreement</a>, <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/Privacy_full&locale.x=en_US>Privacy Statement</a>, and <a class=popup xo-popup target=_blank href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/AcceptableUse_full&locale.x=en_US>Acceptable Use Policy</a>.",
    "understand": "The <a class=popup xo-popup target=_blank target=_new href=https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=ua/esign_full&locale.x=en_US>Electronic Communications Delivery Policy</a>. I understand PayPal will provide me with information about my account electronically.",
    "emailHelper": "You'll use this email to log in to PayPal. If necessary, you can change your email address at PayPal.com.",
    "ak": "AK - Alaska",
    "al": "AL - Alabama",
    "ar": "AR - Arkansas",
    "az": "AZ - Arizona",
    "ca": "CA - California",
    "co": "CO - Colorado",
    "ct": "CT - Connecticut",
    "dc": "DC - District of Columbia",
    "de": "DE - Delaware",
    "fl": "FL - Florida",
    "ga": "GA - Georgia",
    "hi": "HI - Hawaii",
    "ia": "IA - Iowa",
    "id": "ID - Idaho",
    "il": "IL - Illinois",
    "in": "IN - Indiana",
    "ks": "KS - Kansas",
    "ky": "KY - Kentucky",
    "la": "LA - Louisiana",
    "ma": "MA - Massachusetts",
    "md": "MD - Maryland",
    "me": "ME - Maine",
    "mi": "MI - Michigan",
    "mn": "MN - Minnesota",
    "mo": "MO - Missouri",
    "ms": "MS - Mississippi",
    "mt": "MT - Montana",
    "nc": "NC - North Carolina",
    "nd": "ND - North Dakota",
    "ne": "NE - Nebraska",
    "nh": "NH - New Hampshire",
    "nj": "NJ - New Jersey",
    "nm": "NM - New Mexico",
    "nv": "NV - Nevada",
    "ny": "NY - New York",
    "oh": "OH - Ohio",
    "ok": "OK - Oklahoma",
    "or": "or",
    "pa": "PA - Pennsylvania",
    "ri": "RI - Rhode Island",
    "sc": "SC - South Carolina",
    "sd": "SD - South Dakota",
    "tn": "TN - Tennessee",
    "tx": "TX - Texas",
    "ut": "UT - Utah",
    "va": "VA - Virginia",
    "vt": "VT - Vermont",
    "wa": "WA - Washington",
    "wi": "WI - Wisconsin",
    "wv": "WV - West Virginia",
    "wy": "WY - Wyoming",
    "aa": "AA - Armed Forces Americas",
    "ae": "AE - Armed Forces Europe",
    "ap": "AP - Armed Forces Pacific",
    "as": "AS - American Samoa",
    "fm": "FM - Federated States of Micronesia",
    "gu": "GU - Guam",
    "mh": "MH - Marshall Islands",
    "mp": "MP - Northern Mariana Islands",
    "pr": "PR - Puerto Rico",
    "pw": "PW - Palau",
    "vi": "VI - Virgin Islands",
    "country": "Country/Region",
    "unitedStates": "United States",
    "canada": "Canada",
    "english": "English",
    "french": "Français",
    "en_US": "English",
    "en_GB": "English",
    "fr_CA": "Français",
    "fr_FR": "Français",
    "fr_XC": "Français",
    "es_XC": "Español",
    "zh_XC": "中文",
    "de_DE": "German",
    "addBankandContinue": "Add Bank and Continue",
    "addCardandContinue": "Add Card and Continue",
    "bmlCancelConfirmationTitle": "Canceling? You're almost done!",
    "bmlCancelConfirmation": "Your new PayPal Credit account is set up and ready to use. Are you sure you want to cancel this checkout now?",
    "bmlCancelButtonLabel": "Cancel & Return to {merchantName}",
    "bmlContinueButtonLabel": "Continue with PayPal Credit",
    "continueToMerchant": "Continue to Merchant",
    "cancelAndReturnToMerchant": "Cancel & Return to Merchant",
    "returnToDefaultMerchant": "Return to Merchant",
    "returnToMerchant": "Return to {merchantName}",
    "altHelp": "Why do you need this?",
    "valueInvalid": "Value is invalid",
    "england": "England",
    "northernIreland": "Northern Ireland",
    "scotland": "Scotland",
    "wales": "Unitary Authorities of Wales",
    "ukOffshoreDependencies": "UK Offshore Dependencies",
    "emailTooltipGuest": "We will use this email address to send a payment confirmation.",
    "continueAsGuest": "Continue as a Guest",
    "pleaseAgreeToPayPalGuestTerms": "Please read and agree to the PayPal Guest Terms",
    "show": "Show",
    "hide": "Hide",
    "details": "Details",
    "complianceRestricted": "We're sorry, due to government regulations, buyers having a billing address in {merchantCountry} cannot use PayPal to make payments to sellers registered in {merchantCountry}.",
    "notNow": "Not now",
    "next": "Next",
    "backToAndroidPay": "Back to Google Pay Setup",
    "backToAndroidPayB": "Back to Google Pay",
    "backToTokenizedWallet": "Back to {type} Setup",
    "backToTokenizedWalletB": "Back to {type}",
    "activate": "Activate One Touch",
    "noThanks": "No Thanks",
    "haveFeedback": "Have feedback?",
    "letUsKnow": "Let us know.",
    "yesCreateUnBrandedAccount": "Yes, create a PayPal account for free",
    "nothanksUnBranded": "Continue without a PayPal account",
    "createPayPalUnBrandedProp": "With PayPal, you can pay with just your email address and password. And if there’s a problem, our buyer protection can help.",
    "getBenefitsUnBrandedLine1": "Create a PayPal account (recommended)",
    "createPayPalUnBrandedSubTitle": "Create a PayPal account?",
    "confirmShippingDetails": "Confirm shipping details",
    "confirmShippingDetailsReqs": "The merchant requires a shipping address and your email address to complete this payment.",
    "confirmShippingDetailsSub": "Review your shipping address",
    "confirmBaiduPaypalPolicyAgreement": "By continuing, you agree that PayPal will save your payment details. This will allow faster future payments to this and other merchants when you use PayPal with your Baidu wallet. You have read and agree to PayPal’s <a href=https://www.paypal.com/webapps/mpp/ua/privacy-full?country.x=CN&locale.x=zh_CN xo-popup class=popup target=_blank>PayPal Privacy</a>.",
    "streetNumber": "Number",
    "neighborhood": "Neighborhood",
    "showMoreFi": "More",
    "payInCurrencyLabel": "Pay in {currency}",
    "continueInCurrencyLabel": "Continue in {currency}",
    "Themerchant": "The merchant",
    "themerchant": "the merchant",
    "notNowGoToReceipt": "Not now, go to receipt",
    "skipLoginV1": "Skip Login for Future Purchases",
    "skipLoginV2": "Set Up to Log In Automatically",
    "skipLoginV3": "Set Up with One-time Code",
    "checkYourAccount": "Check Your Account"
  },
  "enterpriseAgreement": {
    "eBayNoFiStickyConsent": "I want to use PayPal for future payments to <a class=popup xo-popup target=_blank target=_new href=https://wmsapp.ebay.com/wmsapp/ppba?locale={lang}&country_code={country}&_https2httpredirect=false>eBay Inc. and its subsidiary companies</a> (collectively, “eBay”) for use of eBay programs. This lets me pay faster by not having to log in to PayPal. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment, and that unless I set a payment method in my PayPal Settings, the payment method used will follow PayPal Policies. I can cancel this authorization at any time in my Settings.",
    "eBayFiStickyConsent": "I want to use <b>{fiName} {fiFormatLast4}</b> for future payments to <a class=popup xo-popup target=_blank target=_new href=https://wmsapp.ebay.com/wmsapp/ppba?locale={lang}&country_code={country}&_https2httpredirect=false>eBay Inc. and its subsidiary companies (collectively, “eBay”)</a> for use of eBay programs. If this payment method is expired or declined, the payment method used will follow PayPal Policies. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can also change my preferred payment method or cancel this authorization at any time in my Settings.",
    "eBayNoFiStickyConsentSignup": "I want to use PayPal for future payments to <a class=popup xo-popup target=_blank target=_new href=https://wmsapp.ebay.com/wmsapp/ppba?locale={lang}&country_code={country}&_https2httpredirect=false>eBay Inc. and its subsidiary companies</a> (collectively, “eBay”) for use of eBay programs. This lets me pay faster by not having to log in to PayPal. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment, and that unless I set a payment method in my PayPal Settings, the payment method used will follow PayPal Policies. I can cancel this authorization at any time in my Settings.",
    "facebookp2pFiStickyConsent": "<b>When sending money</b>, {merchantName} will be able to access the names and last 4 digits of your available payment methods, so you can select how to pay. You agree that Facebook is responsible for its use of your information in accordance with its <a class=popup xo-popup target=_blank target=_new href=https://www.facebook.com/privacy/explanation>Privacy Statement</a>.</br></br> <b>When making purchases</b>, <b>{fiName} {fiFormatLast4}</b> will be used for all future PayPal payments on the <b>{merchantName}</b> platform. If this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>. You can also change your payment method or cancel this authorization at any time in your PayPal account settings.",
    "facebookp2pNoFiStickyConsent": "<b>When sending money</b>, {merchantName} will be able to access the names and last 4 digits of your available payment methods, so you can select how to pay. You agree that Facebook is responsible for its use of your information in accordance with its <a class=popup xo-popup target=_blank target=_new href=https://www.facebook.com/privacy/explanation>Privacy Statement</a>.</br></br> <b>When making purchases</b>, <b>{fiName} {fiFormatLast4}</b> will be used for all future PayPal payments on the <b>{merchantName}</b> platform. If this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>. You can also change your payment method or cancel this authorization at any time in your PayPal account settings.",
    "facebookp2pNoFiStickyConsentSignup": "<b>When sending money</b>, {merchantName} will be able to access the names and last 4 digits of your available payment methods, so you can select how to pay. You agree that Facebook is responsible for its use of your information in accordance with its <a class=popup xo-popup target=_blank target=_new href=https://www.facebook.com/privacy/explanation>Privacy Statement</a>.</br></br> <b>When making purchases</b>, the card entered above will be used for all future PayPal payments on the <b>{merchantName}</b> platform. If this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>. You can also change your payment method or cancel this authorization at any time in your PayPal account settings.",
    "fbInstagramNoFiStickyConsentSignup": "I want to use the card I entered above for automatic PayPal payments across <b>Facebook’s</b> products and platforms in accordance with <b>Facebook Inc.’s</b> policies. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment, and that if my preferred payment method is expired or declined, PayPal will charge my backup payment method.  I can change my preferred payment method or cancel this authorization at any time in my Account Profile at PayPal.com.",
    "fbInstagramFiStickyConsent": "I want to use <b>{fiName} {fiFormatLast4}</b> for automatic PayPal payments across <b>Facebook’s</b> products and platforms in accordance with <b>Facebook Inc.’s</b> policies. I understand that if this payment method is unavailable, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>, and if I hold a balance with PayPal, that balance will be used first to complete my payment. I can change my preferred payment method or cancel this authorization in my Settings.",
    "fbInstagramNoFiStickyConsent": "I want to use PayPal for automatic PayPal payments across <b>Facebook’s</b> products and platforms in accordance with <b>Facebook Inc.’s</b> policies. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can set or change the payment method I want to use or cancel this authorization in my Settings. I understand until I set a payment method in my Settings, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>.",
    "paymentusUSNoFiStickyConsentSignup": "I want to use the card I entered above for all future purchases with {merchantName} and with its service provider Paymentus. I understand that if this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank href=https://www.paypal.com/{country}/selfhelp/article/what-is-my-backup-payment-method-faq1054?locale.x={lang}_{country}>PayPal Policies</a>, and if I hold a balance with PayPal, that balance may be used first to complete my payment.  I can change my payment method or cancel this authorization at any time in my Settings.",
    "paymentusUSFiStickyConsent": "I want to use <b>{fiName} {fiFormatLast4}</b> for automatic payments to <b>{merchantName}</b> and to its service provider Paymentus. I understand that if this payment method is unavailable, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a> and that if I hold a balance with PayPal, that balance may be used first to complete my payment. I can also change my payment method or cancel this authorization in my Settings.",
    "paymentusUSNoFiStickyConsent": "I authorize <b>{merchantName}</b> and its service provider Paymentus to each charge my PayPal account for automatic payments. I understand that if I hold a balance with PayPal, that balance may be used first to complete my payment. I can set or change the payment method I want to use or cancel this in my Settings. I understand until I set a payment method in my Settings, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>."
  },
  "genericError": {
    "expiredOrTokenNotFoundError": "You've been inactive for a while, so we logged you out to help protect your account. Please return to the merchant and restart the payment process.",
    "paymentAlreadyProcessedError": "Payment has already been attempted for this session, please go back to merchant and start the checkout again.",
    "genericError": "Things don't appear to be working at the moment. Please try again later.",
    "thingsNotWorking": "Things don’t appear to be working at the moment.",
    "paymentInProgressError": "We are currently processing your payment. Please try again later.",
    "paymentAlreadyCompletedError": "Your payment was completed. To continue shopping, please return to the merchant.",
    "paymentFailedError": "Your payment didn't go through. To complete your purchase, please return to the merchant and restart the payment process.",
    "multipleTokensAndTimedOutError": "You have been logged out for safety as there is another active session in this browser.",
    "paymentDeniedError": "We aren't able to process your payment using your PayPal account at this time. Please go back to merchant and try using a different payment method.",
    "loginSessionTimedOut": "Your session timed out to help protect your account. Please return to the merchant site to restart the payment process.",
    "disabledCookies": "You've disabled cookies. Please enable cookies and return to the merchant and restart the payment process.",
    "buyerRestrictedError": "Your account is limited. Please check your PayPal Account Overview page for information on how to resolve this problem.",
    "incontextGenericPageError": "Some of your information is missing or incorrect. Please check and try again.",
    "pleaseTryAgain": "Please try again.",
    "tryAgain": "Try Again",
    "invalidShipping": "We’re sorry, but residents of United States can’t ship purchases to {country}. Please return to <a id=\"merchant\" href=\"{merchant}\">{merchantName}</a> and enter a different shipping address.",
    "blockNonDomesticShippingTitle": "Sorry, but the merchant only ships within the United States",
    "blockNonDomesticShippingMessage": "Please return to the merchant and choose a US shipping address.",
    "blockPPCIneligibleTitle": "Sorry, PayPal Credit is not available for this item.",
    "blockPPCIneligibleMessage": "Please go back to the shopping cart and choose a different payment method.",
    "guestUpgradeSessionError": "We weren't able to create your account at this time.",
    "guestUpgradeError": "We weren't able to create your account at this time.",
    "payerCountryNotAllowedTitle": "We're sorry",
    "payerCountryNotAllowedTitleMemberDCF": "Sorry, to use PayPal for preapproved payments to {merchantName}, your PayPal and {merchantName} accounts must be registered in the same country or region.",
    "payerCountryNotAllowedTitleMemberDCFDefault": "Sorry, to use PayPal for preapproved payments to this merchant, your PayPal and merchant accounts must be registered in the same country or region.",
    "payerCountryNotAllowedTitleSignupDCF": "Sorry, you can’t use PayPal for preapproved payments to {merchantName}.",
    "payerCountryNotAllowedTitleSignupDCFDefault": "Sorry, you can’t use PayPal for preapproved payments to this merchant.",
    "sorry": "We’re sorry",
    "unauthorizedCountryLogin": "You’re trying to log in from a country or region that doesn’t allow payments to this merchant.",
    "unauthorizedCountryAccountRegistered": "Your PayPal account is registered in a country or region that doesn’t allow payments to this merchant.",
    "unauthorizedCountryAccountMemberDCF": "Please return to {merchantName} and choose another way to pay.",
    "unauthorizedCountryAccountMemberDCFDefault": "Please return to the merchant and choose another way to pay.",
    "unauthorizedCountryAccountSignupDCF": "Your PayPal account was created but we’re unable to set up preapproved payments. To use PayPal for preapproved payments to {merchantName}, your PayPal and {merchantName} accounts must be registered in the same country or region. Please return to {merchantName} and choose another way to pay.",
    "unauthorizedCountryAccountSignupDCFDefault": "Your PayPal account was created but we’re unable to set up preapproved payments. To use PayPal for preapproved payments to this merchant, your PayPal and {merchantName} accounts must be registered in the same country or region. Please return to the merchant and choose another way to pay.",
    "transactionRefusedTitle": "Sorry, we can’t complete your purchase at this time",
    "transactionRefusedMessage": "Please return to the merchant and choose another way to pay.",
    "complianceViolationMessage": "To comply with government regulations, this transaction has been declined.",
    "domesticTransactionRequiredTitle": "Sorry, {merchantName} only accepts payments from PayPal accounts registered in the United States.",
    "domesticTransactionRequiredMessage": "Please return to {merchantName} and choose another way to pay.",
    "domesticTransactionRequiredTitleDefault": "Sorry. This merchant only accepts payments from PayPal accounts registered in the United States.",
    "domesticTransactionRequiredMessageDefault": "Please return to the merchant and choose another way to pay.",
    "negativeBalanceRefusedTitle": "You have a balance due.",
    "negativeBalanceRefusedMessage": "An earlier payment you made using PayPal wasn’t successful, resulting in a balance payable to PayPal. Before you can complete today’s purchase, you’ll need to log in to PayPal.com to clear this balance.<br /><br />You’ll find more information in your transaction history.",
    "studentAccountTitle": "Sorry, you can no longer use your PayPal Student account to check out.",
    "studentAccountMessage": "Please return to the merchant and choose another way to pay.",
    "unsupportedBrowserMessage": "Looks like you’re using an older version of your browser. To check out with PayPal, please upgrade to the latest version.",
    "unsupportedBrowserHeader": "Your browser is out of date",
    "duplicateInvoiceId": "This invoice has already been paid. For more information, please contact the merchant.",
    "androidPayGenericError": "Sorry, we can't add your PayPal account to Google Pay at this time.",
    "transactionRefusedBAnoPurchaseTitle": "Sorry, we weren’t able to set up preapproved payments at this time.",
    "transactionRefusedBAPurchaseTitle": "Sorry, we weren’t able to complete your payment or set up preapproved payments at this time.",
    "androidPayAlreadyProvisioned": "Looks like you already set up PayPal with Google Pay on this device. You're ready to shop!",
    "tokenizedWalletGenericError": "Sorry, we can't add your PayPal account to {type} at this time.",
    "tokenizedWalletAlreadyProvisioned": "Looks like you already set up PayPal with {type} on this device. You're ready to shop!",
    "csrfTokenExpired": "You’ve been inactive for a while and your PayPal checkout session ended. Do you want to try again?",
    "invalidAccountType": "Sorry, you can only make payments to this merchant using a personal PayPal account.",
    "fiIneligible": "Sorry, you can only make payments to this merchant using balance or confirmed bank account.",
    "accountUnverified": "To pay this merchant using your balance, please confirm either your credit card or bank account at <a href=\"https://www.paypal.com\">PayPal.com</a>.",
    "fiUnconfirmed": "To make payments to this merchant, please confirm your bank account at <a href=\"https://www.paypal.com\">PayPal.com</a>.",
    "unsupportedReceiverPreferences": "The merchant can’t process your payment using PayPal at this time.",
    "genericErrorMessageTitle": "Sorry, we can’t complete your payment",
    "sendingLimitExceeded": "This payment exceeds your PayPal sending limit. You can find information about lifting your limits in your <a href=/myaccount>account Profile</a>.",
    "payeeAccountLockedOrClosed": "The merchant isn’t able to accept PayPal payments at this time. Please try again later or return to the merchant and choose another way to pay.",
    "agreementAlreadyCreated": "You’ve already set up preapproved payments with {merchantName}.",
    "unsupportedPayeeCurrency": "Sorry, the merchant doesn’t accept payments in your currency. Please return to the merchant and choose another way to pay.",
    "noscript": "We're sorry, but to check out using PayPal, you need to turn on JavaScript and enable cookies in your web browser's settings.",
    "smartDollarAuthFailedMsg": "Sorry, we weren’t able to authorize your card",
    "paymentDeniedError1": "We couldn't complete your payment for you. To get your payments working again, check your account or <a href=\"https://www.paypal.com/smarthelp/contact-us?locale.x={lang}_{country}&country.x={country}\" xo-popup class=\"popup\" target=\"_blank\">contact us</a>"
  },
  "creditcard": {
    "optional": "Optional",
    "addCardTitle": "Add a card",
    "editCardTitle": "Edit card",
    "updateCardTitle": "Update or add a card",
    "addNewBillingAddress": "Add new billing address",
    "addBtn": "Add",
    "updateBtn": "Update",
    "saveBtn": "Save",
    "cardNumber": "Card number",
    "debitCardNumber": "Debit card number",
    "typeLabel": "Card type",
    "expirationDate": "Expiration date",
    "cscLabel": "CSC",
    "dayLabel": "Day",
    "monthPlaceholder": "MM",
    "monthLabel": "Month",
    "yearPlaceholder": "YY",
    "yearLabel": "Year",
    "cscPlaceholder": "CSC",
    "twoDigits": "2 digits",
    "threeDigits": "3 digits",
    "fourDigits": "4 digits",
    "threeToFourDigits": "3 - 4 digits",
    "defaultCVV": "It's a security code used to verify your credit card.",
    "expiresLabel": "Expires",
    "expiresPlaceholder": "MM/YY",
    "cscHelp": "It's a security code used to verify your credit card.",
    "cscHelp3Digits": "It’s the last 3 digits in the signature area on the back of your card.",
    "cscHelp4Digits": "It’s the last 4 digits printed on the front of your card.",
    "acceptableCards": "The merchant only accepts",
    "acceptDebitCardOnly": "Please add a debit card.",
    "errorExpiredCard": "Your card has expired.  Please update it or add a new card to complete your payment.",
    "addDebitOrCreditCard": "Your balance doesn't cover this purchase. Please add a debit or credit card to complete your payment.",
    "updatedButCannotUse": "The card is updated successfully, but it can't be used for payment.",
    "addedButCannotUse": "We’ve added this card to your account, but you’ll need to use a different card to complete your purchase.",
    "addedButCannotUseContingency": "We’re sorry, but the merchant doesn't accept the card you added. Please add a different debit or credit card to complete your purchase.",
    "updateDebitOrCreditCard": "Update your debit or credit card.",
    "linkedCardToAddNewCard": "The card you entered was already added to another PayPal account. Please use a different debit or credit card to complete your purchase.",
    "noFIContingency": "Please add a debit or credit card to complete your purchase.",
    "noEligibleFI": "Your payment methods are registered in a country or region that doesn’t allow payments to this merchant. Please add a card from the country or region where your PayPal account is registered.",
    "merchantDisallowed": "The merchant doesn’t accept the card you have in your PayPal wallet. Please add another card to complete your payment.",
    "riskDisallowed": "This card can't be used for your payment. Please add a different debit or credit card.",
    "startDate": "Starts",
    "startDatePlaceHolder": "MM/YY",
    "startDateToolTip": "Your card may not have a start date.",
    "issueNoLabel": "Issue number",
    "issueNoLabelToolTip": "Your card may not have an issue number.",
    "issueNoPlaceHolder": "2 digits",
    "interacTooltip": "For this purchase you can use",
    "dobPlaceHolder": "MM/DD/YYYY",
    "dob": "Date of Birth",
    "tipOptionalCsc": "Your card may not have a CSC.",
    "creditErrorMessage": "You weren’t approved for credit, add a debit or credit card to complete your payment.",
    "errorInvalidFirstName": "Invalid first name",
    "errorInvalidLastName": "Invalid last name",
    "errorInvalidExpirationDate": "Invalid expiration date",
    "errorInvalidCCNumberOrType": "Invalid card number or card type",
    "errorInvalidCCNumberOrType_global": "Invalid card number or card type. Please use a different card.",
    "errorInvalidCSC": "Invalid CSC",
    "errorInstrumentRefused": "Your credit card is declined. Please try another one.",
    "errorInstrumentAlreadyExists": "The credit card you want to add is already in your account.",
    "errorInstrumentUpdateNoChange": "Information you want to change is the same as before.",
    "errorInstrumentUnavailable": "This card has already been added to the maximum number of PayPal accounts. To complete your purchase, add a different card.",
    "errorInstrumentBillingAddressNotMatch": "Check your credit card billing address and try again.",
    "errorInstrumentBillingAddressNotAccepted": "Sorry, but this card can’t be used for online purchases or added to your PayPal account. To complete your purchase, try a different card.",
    "errorInternalError": "We’re sorry, but we weren’t able to add this card. Please try again later, or add a different card.",
    "errorInstrumentCountExceeded": "Sorry, but you already have the maximum number of cards in your PayPal account. Please choose a different card.",
    "errorGeneral": "We’re sorry, but we weren’t able to add this card. Please try a different card.",
    "errorAccountRestricted": "Your account is limited. Please check your PayPal Account Overview page for information about resolving this problem.",
    "errorInstrumentBillingAddressUnsupported": "Sorry, but your card issuer wasn’t able to verify your billing address. To complete your purchase, try a different card.",
    "errorInstrumentBillingAddressUnavailable": "Your bank’s verification system is temporarily unavailable. Try again later, or use a different card.",
    "errorInstrumentBillingAddressUnavailableIntl": "Sorry, but we aren’t able to verify billing addresses for cards issued outside the US. Try another card.",
    "errorPaypalDebitRefused": "Sorry, but you can’t add a PayPal debit card to your account. Please try a different card.",
    "errorPaypalCreditRefused": "Sorry, but you can’t add a PayPal credit card to your account. Please try a different card.",
    "errorPaypalRefused": "Sorry, but you can’t add a PayPal card to your account. Please try a different card.",
    "errorCheckDigitsNotPresent": "Please enter a valid card security code (CSC).",
    "errorCheckDigits": "Check the card security code (CSC) and try again, or try a different card. If this problem occurs again, contact your card issuer.",
    "errorIssuerReject": "Sorry, but your card issuer declined this payment. To complete your purchase, try a different card.",
    "errorIssuerRejectIntl": "We weren’t able to verify this card. If this is an international card, you’ll need to open a PayPal account in the country or region where your card is registered. To complete your purchase now, try a different card.",
    "errorIssuerDenied": "Sorry, but the card issuer declined to verify this card. To complete your purchase, try a different card.",
    "errorInvalidAccount": "Please enter a valid card number or try a different card.",
    "errorAmexAdult": "Sorry, but American Express won’t authorize payment for this type of purchase.",
    "errorExcessiveRejectMember": "Sorry, but this card was rejected too many times. To complete your purchase, choose another way to pay.",
    "errorExcessiveRejectGuest": "Sorry, but this card was rejected too many times. To complete your purchase, try a different card.",
    "errorMaxAmountExceeded": "Sorry, but this purchase exceeds your card issuer’s transaction limit. To complete your payment, try a different card.",
    "errorInvalidData": "Sorry, but your card issuer wasn’t able to verify your card. Try again or use a different card.",
    "notEligibleToAddCard": "You are not eligible to add a new credit card",
    "notEligibleToEditCard": "You are not eligible to edit the credit card",
    "cardAmex": "American Express",
    "cardMasterCard": "MasterCard",
    "cardVisa": "Visa",
    "cardDiscover": "Discover",
    "cardMaestro": "Maestro",
    "cardElo": "Elo",
    "cardHiper": "Hiper",
    "cardHipercard": "Hipercard",
    "errorDeleteCard": "Sorry, we weren’t able to delete card at this time. Please try again later.",
    "errorUpdateCard": "Sorry, we weren’t able to update card at this time. Please try again later.",
    "hasMultipleDisallowedFi": "Sorry, your <b>{cardList}</b> and <b>{lastCard}</b> are not accepted. Please add another card to complete your payment.",
    "hasDisallowedAddCardTitle": "Add a new card to your account",
    "hasSingleDisallowedFi": "Sorry, your <b>{cardList}</b> is not accepted. Please add another card to complete your payment.",
    "noDisallowedAddCardTitle": "Add a card to your account",
    "hasNoDisallowedFi": "Your PayPal account is missing a payment method. Please add a card to continue.",
    "hi": "Hi, {userName}!",
    "complianceDecline": "This card can’t be used for your payment. Please use a different card.",
    "preferredExpired": "Your preferred card, <b>{cardType}-{last4}</b>, has expired.",
    "preferredExpireSoon": "Your preferred card, <b>{cardType}-{last4}</b>, will expire soon.",
    "currentCardExpireSoon": "The card you used today, <b>{cardType}-{last4}</b>, will expire soon.",
    "cardExpired": "Your <b>{cardType}-{last4}</b> has expired.",
    "multipleCardsExpired": "One or more of your cards have expired.",
    "expired": "Expired",
    "updateThemNow": "Update them now",
    "updateItNow": "Update it now",
    "updateAnyTime": "You can update it at any time in your PayPal account.",
    "scanCardNumber": "Scan or enter your card number"
  },
  "creditCard": {
    "preAuthMessage": "{issuer} can't validate your <b>{cardType} ••••{last4}</b>. Please add a different card to complete your payment.",
    "preAuthNoIssuer": "Your card issuer can’t validate your <b>{cardType} ••••{last4}</b>. Please add a different card to complete your payment."
  },
  "login": {
    "enterLoginDetails": "Enter your login details",
    "dontHaveAnAccount": "Don't have an account?",
    "dontHaveAnPPAccount": "Don't have a PayPal account?",
    "notMember": "Not a PayPal member?",
    "signup": "Sign up",
    "loginTitle": "Pay with PayPal",
    "loginTitleB": "Log in to PayPal",
    "loginTitleSubtext": "You can review your order after logging in.",
    "guestTitle": "Pay as a guest or log in",
    "loginBtn": "Log In to PayPal",
    "keepMeLoggedIn": "Stay logged in for faster purchases",
    "forgotPasswordLink": "Forgot your password?",
    "signUpLink": "Sign Up",
    "guestLink": "Check Out as a Guest",
    "guestLinkBtn": "Pay with Debit or Credit Card",
    "guestLinkBtnB": "Try PayPal as a Guest",
    "guestProp": "Securely pay using your debit, credit or prepaid card.",
    "createAccount": "Create an Account",
    "signUpTitle": "Don't have an account?",
    "passwordLabel": "Password",
    "invalidPassword": "Check your password and try again. {forgotPasswordURI}",
    "invalidUsernamePassword": "Invalid Username Password",
    "invalidEmailPasswordPageError": "Check your email address and password and try again.",
    "loginStatusTimedOut": "Your PayPal session has timed out. Please log in again.",
    "accountLockedPageError": "We're sorry, but your account is currently locked. Please <a target=_new href=https://www.paypal.com/us/webapps/helpcenter/helphub/home/?action=callus>contact us</a>.",
    "invalidPhone": "Enter a valid mobile number with area code.",
    "invalidPin": "Your mobile number and PIN don’t match. Please try again.",
    "invalidAccessToken": "Sorry, an error has occurred. Please log in again.",
    "securityCodeRequired": "Your account is protected by a security key. Now, please enter both your password and security code as follows: Password123456.",
    "noActiveTokens": "We’re sorry, but your security key is locked. Please visit Settings/Security on <a href=https://www.paypal.com xo-popup class=popup target=_blank >PayPal.com</a> to resolve the issue.",
    "loginDetails": "Enter your login details",
    "userMayHaveAccount": "You might already have an account with this email address. Please try <a href=\"{href}\" id=\"hermesLoginPageLink\">logging in</a>.",
    "userMayHaveAccountGuest": "You may already have an account with this email address. You can <a href=\"{href}\" id=\"hermesLoginPageLinkGuest\">log in</a>, or continue as a guest.",
    "cannotPaySelf": "You are logging into the account of the seller for this purchase. Please change your login information and try again.",
    "propHead": "New. Faster. Easier.",
    "propVal": "Welcome to the new PayPal checkout! <br/>The security you rely on – now even faster. <br/>It’s everything checkout should be.",
    "propHeadAlt": "PayPal Purchase Protection",
    "propValAlt": "As a member, your eligible purchases are covered by <a href=https://www.paypal.com/{country}/webapps/mpp/paypal-safety-and-security?locale.x={lang}_{country} xo-popup class=popup target=_blank >PayPal Purchase Protection. </a>",
    "multipleLogin": "You have PayPal checkout open in another browser. We’ve logged you out of this session to help protect your account.",
    "guestTooltip": "Trouble logging in? You can try again, or <a href='{href}' class='submit' id='guestTooltipLink'>check out as a guest</a>",
    "member": "Already a member?",
    "signUpBml": "Sign up and pay using <a href='{href}' class='submit' id='bmlSignup'>PayPal Credit</a>",
    "guestBml": "Check out as a guest using  <a href='{href}' class='submit' id='bmlSignup'>PayPal Credit</a>",
    "micaLoginGuestHeading": "Apply as a guest",
    "micaLoginGuestContent": "Don't have a PayPal account? You can still apply for PayPal Credit.",
    "micaTitle": "Log in to apply",
    "micaPara": "Use your PayPal account information to apply even faster.",
    "continue": "Continue as Guest",
    "noCreditOffersHeader": "Sorry, but PayPal Credit isn't available for this purchase",
    "noCreditOffersMsg": "You can still securely check out with PayPal.",
    "payFull": "Pay in Full With PayPal",
    "alreadyHaveAccount": "Already have a PayPal account?",
    "login": "Log In",
    "forgotYourPassword": "<a href='{href}' id='forgotPassword' target='_blank'>Forgot your password?</a>",
    "or": "Or",
    "orLowercase": "or",
    "creditLoginTitle": "Log in to apply",
    "creditLoginDetail": "Use your PayPal account to apply even faster.",
    "loginAddCard": "Log in to add a debit or credit card",
    "loginAddAddress": "Log in to add a new address",
    "loginAddBank": "Log in to add a bank account",
    "loginApplyCredit": "Log in to apply for PayPal Credit",
    "loginAddPhone": "The merchant requires your phone number to complete this purchase. Please log in to update your account information.",
    "loginMerchantPassedAddress": "The merchant provided a shipping address you haven't used before. Please log in to use this address.",
    "loginContingency": "For your security, please log in.",
    "riskDeclinePageError": "Sorry, we can't log you in. If you think there's a problem with your account, <a target=_new href=https://www.paypal.com/us/webapps/helpcenter/helphub/home/?action=callus>contact us</a> and we'll help resolve it.",
    "kmliTooltipLine1": "No remembering passwords. No typing in your info. Just tap, pay, and get on your way.",
    "kmliTooltipLine2": "For your security, we'll always ask you to log in to update your PayPal personal or financial info.",
    "kmliTooltipLine3": "You can always log out or turn this off in your Profile.",
    "kmliTooltipTitle": "Learn more about staying logged in.",
    "reactivateOneTouch": "We were unable to keep you logged in. Select the checkbox below to reactivate One Touch™ on this device.",
    "checkOneTouch": "Stay logged in for faster checkout. Select the checkbox below to reactivate One Touch™ on this device.",
    "leaveOneTouchChecked": "Stay logged in for faster checkout. Leave the checkbox below selected to reactivate One Touch™ on this device.",
    "riskyLoginUpdateCard": "Log in to update or add a card.",
    "riskyLoginAddCard": "Log in to add a debit or credit card to complete your purchase.",
    "riskyLoginAddShipping": "Log in to add a United States address.",
    "riskyLoginAddPhone": "Log in to add a phone number.",
    "riskyLoginShippingPassed": "Log in to confirm your shipping details.",
    "riskyLoginExpiredCardST": "Your card is expired.",
    "riskyLoginAddShippingST": "The merchant only ships within the US.",
    "riskyLoginAddPhoneST": "The merchant requires a phone number to complete your purchase.",
    "riskyLoginShippingPassedST": "The merchant provided a shipping address that isn’t on your PayPal account.",
    "rmSubHeading": "You activated PayPal One Touch™, so no need to enter your password today.",
    "loggedInWithOneTouch": "Logged in with PayPal One Touch™.",
    "newToPayPal": "New to PayPal",
    "venmoGenericError": "An Error occurred while processing your Venmo transaction. Please try again with a PayPal account to complete your payment.",
    "latinumNotUsed": "Sorry, {alternativeFunding} can't be used for this purchase. You can still complete your payment using a debit or credit card.",
    "valuePropA": "PayPal covers return shipping. <a href=\"#\" id=\"limitsApply\">Limits Apply</a>",
    "valuePropB": "PayPal makes checkout fast and easy. Just log in to shop",
    "valuePropC": "PayPal is the fast, easy, secure way to pay on eBay",
    "limitsApplyContent": "This is an exclusive offer available to eligible PayPal account owners. With this service you are eligible to receive up to 12 refunds per calendar year (between January 1st and December 31st), and may receive refunds of up to $30 USD per claim. PayPal reserves the right to cancel or modify part of or this entire Offer at any time without notice, for any reason in their sole discretion. See full <a target=_new href=https://www.paypal.com/webapps/mpp/returns/terms>terms and conditions</a>.",
    "confirmPhone": "Add an extra layer of security to your account. <a href='#' id='confirmPhoneBtn'>Confirm your mobile phone</a>.",
    "confirmPhoneWithButton": "Add an extra layer of security for your account. <button id='confirmPhoneBtn'>Confirm Mobile Phone</button>",
    "confirmPhoneLongWithButton": "Confirm the mobile number in your profile to keep your account secure, like for security alerts or for help recovering your account. <button id='confirmPhoneBtn'>Confirm Mobile Phone</button>",
    "confirmPhoneSuccess": "You’ve successfully confirmed your mobile phone number!",
    "addPhone": "Get an extra layer of security for your account. <a href='#' id='confirmPhoneBtn'>Add your mobile phone number</a>.",
    "addPhoneWithButton": "Get an extra layer of security for your account. <button id='confirmPhoneBtn'>Add Mobile Phone</button>",
    "addPhoneLongWithButton": "Add your mobile number so we can easily reach you if there’s ever an issue with your account or to confirm your identity if you have trouble logging in. <button id='confirmPhoneBtn'>Add Mobile Phone</button>",
    "addPhoneSuccess": "You’ve successfully added your mobile number to your profile! ",
    "userMayHaveAccountRecovery": "You may already have a PayPal account. You can <a href=\"{href}\" class=\"strong\">reset your password</a> or create a new account with a different email address.",
    "smsSent": "We sent you a text to confirm your mobile number. Reply when you get a second."
  },
  "memberReview": {
    "memberReviewTitle": "Review your payment",
    "confirmTitle": "Confirm info and pay",
    "passwordLabel": "Password",
    "emailConfirmation": "We'll email confirmation to:",
    "continueLabel": "Continue",
    "micaContinueLabel": "Continue to {merchantName}",
    "payLabel": "Pay Now",
    "agreeAndPayLabel": "Agree & Pay",
    "agreeAndContinueLabel": "Agree & Continue",
    "agreeAndSubscribeLabel": "Agree & Subscribe",
    "forgotPasswordLink": "Forgot password?",
    "disclaimer": "This transaction will appear on your statement as PayPal * {merchantName}.",
    "paymentMethodTitle": "Pay with",
    "shippingAddressTitle": "Ship to",
    "makePreferredShipping": "Make this my preferred shipping address",
    "notYou": "Not you?",
    "preferToPayWithVenmo": "Prefer to pay with Venmo?",
    "preferToPayWithPaypal": "Prefer to pay with Paypal?",
    "nbrMerchantCut": "Payable to {merchantName}",
    "nbrPaypalCut": "Payable to PayPal",
    "nbrMsg": "Your total includes an outstanding payment of <em>{neg_bal}</em> due to PayPal. The combined amount will appear on your statement as PayPal * {merchantName}.",
    "nbrMsgPlural": "Your total includes outstanding payments of <em>{neg_bal}</em> and <em>{neg_bal2}</em> due to PayPal. The combined amount will appear on your statement as PayPal * {merchantName}.",
    "welcomeBack": "Welcome back, {userName}!",
    "loggedInWithOneTouch": "You’re logged in with One Touch™, {userName}.",
    "enterPassword": "Enter your password to confirm",
    "propHead": "PayPal is the safer, easier way to pay",
    "propVal": "No matter where you shop, we keep your financial information secure.",
    "authUser": "The merchant has requested an authorization for this payment, and the final payment amount may change when the merchant completes the order.",
    "learnMore": "Learn more",
    "billingRequired": "The merchant requires your billing address to complete this payment.",
    "bmlAcctLinkedToDiffPp": "It looks like you already have PayPal Credit, and it's linked to a different PayPal account.  Please use another payment method to complete your purchase.",
    "bmlMaxAttempts": "Your PayPal Credit application can't be reviewed because there's something wrong with your information.",
    "bmlDeclineHard": "Sorry, but your PayPal Credit application wasn't approved. You'll receive an email with more information.",
    "creditDeclineHard": "You’ll receive an email with information about why your PayPal Credit application was unsuccessful. To pay in full now, please choose another payment method.",
    "bmlGenericError": "There's a problem with our system, so your PayPal Credit application can't be reviewed at this time.  To complete your purchase, please choose another way to pay.",
    "bmlSuccessHeader": "You're approved!",
    "bmlSuccessMessage": "Your credit line is <strong>${creditLine}</strong>.",
    "bmlSuccessMessageSend": "When your billing statements are ready, we'll send a notification to {email}.",
    "bmlSetPreferred": "Make PayPal Credit my preferred way to pay for all future transactions when available",
    "bmlApprovalMessage": "You've been approved for a line of credit from PayPal Credit. You'll receive your account statements via email.",
    "bmlContinue": "Continue",
    "bmlSorry": "Sorry…",
    "bmlPreferredConfirmation": "PayPal Credit is your preferred payment method",
    "bmlApplyHeader": "Apply for PayPal Credit",
    "bmlApplyOfferSmall": "Get $10 back on your first purchase*",
    "bmlApplyOfferLarge": "No Payments + No Interest for 6 months on all purchases of $99 or more*",
    "bmlMakePreferred": "Make PayPal Credit my preferred payment method.",
    "bmlInvalidFI": "We’re sorry, but PayPal Credit is not available for this purchase. Please choose another way to pay.",
    "bmlFiDefaultError": "There was an issue setting PayPal Credit as your preferred funding source.",
    "bmlNapeLinkSuccess": "Your PayPal Credit account has been added to your PayPal account! Now you can use PayPal Credit for eligible purchases.",
    "payNow": "Pay With PayPal",
    "micaMemberReuseText": "You're using your existing PayPal Credit account to pay for today's purchase.",
    "switchToBml": "You've got PayPal Credit! Get 6 months to pay on purchases of $99 or more.",
    "atoSuccessMessage": "Thanks for confirming. You’re all set to complete your payment!",
    "cannotChangeShippingMsg": "This is the address provided by {merchantName}. You can change it on the {merchantName2} site.",
    "cannotChangeShippingMsgUserActionCommit": "This is the address provided by {merchantName}. To change it, return to {merchantName2} before completing your purchase.",
    "plccCardOfferHeader": "{merchantName} Debit or Credit Card",
    "plccCardOfferDesc": "Add your card now to begin earning rewards.",
    "plccAddNowLink": "Add Now",
    "giftCardDec": "PayPal gift card, certificate, reward, or other discount",
    "redeemGiftLink": "Redeem",
    "viewPaypalPolicies": "View <a href='https://www.paypal.com/us/cgi-bin/webscr?cmd=xpt/cps/popup/FundingMixEducation-outside' xo-popup class=popup target=_blank>PayPal Policies</a> and your payment method rights.",
    "stepupAuthSuccess": "Thanks for confirming. You’re all set to complete your payment!",
    "enterCSC": "Enter the CSC for this card:",
    "emailOptin": "I would like to receive special offers from {merchantName}. By checking this box, I request that PayPal share my email address with {merchantName}, which I agree may use this information according to its Privacy Statement, including to contact me for marketing purposes.",
    "merchantMsgHeader": "Information from {merchantName}",
    "rtrMsg": "Once you send the payment, you'll have 30 minutes to cancel it as long as {merchantName} hasn't received it. To cancel, go to the PayPal website.",
    "invRegEMsg": "You are paying and {merchantName} will receive {amount}.",
    "invRegEMsgWithCurrConv": "You are paying {amountInPayerCurrency} to {merchantName}. With currency conversion, they will receive {amountInInvCurrency}.",
    "preferred": "Preferred",
    "prefer_BANK": "Make this bank account my preferred way to pay",
    "prefer_CARD": "Make this card my preferred way to pay",
    "prefer_BALANCE": "Make my balance my preferred way to pay",
    "prefer_CREDIT": "Make {name} my preferred way to pay",
    "selectFi": "Choose a way to pay",
    "autoLoginOn": "PayPal's auto login for checkout is on.",
    "autoLoginOff": "Enable PayPal's auto login for checkout.",
    "expandedTermsOT": "Convenient, <b>automatic log in with PayPal One Touch™</b> when you check out using this <b>device and browser</b> – just review your details and pay.<br>Works <b>wherever you check out with PayPal.</b>",
    "securityInfoOT": "For security, we'll occasionally ask you to log in. We don't recommend using One Touch on shared devices.",
    "sharedDevicesOT": "Not recommended on shared devices.",
    "hiUser": "Hi, {userName}!",
    "hiUser_welcome": "Hi, {userName}! Welcome to PayPal checkout.",
    "useBalanceLabel": "Use my <em>{amt}</em> balance.",
    "alwaysUseBalanceLabel": "Always use my available balance",
    "savePayPalForFuturePurchaseLabel": "Save PayPal for all {merchantName} purchases",
    "skipLoginAndCheckoutFaster": "Skip log in and check out faster next time",
    "noBal_PAYPAL_EXTRAS_MASTERCARD": "Your {code1} balance cannot be used with PayPal MasterCard.",
    "noBal_PAYPAL_EXTRAS_MASTERCARD_plural": "Your {code1} and {code2} balances cannot be used with PayPal MasterCard.",
    "noBal_BILL_ME_LATER": "Your {code1} balance cannot be used with PayPal Credit.",
    "noBal_BILL_ME_LATER_plural": "Your {code1} and {code2} balances cannot be used with PayPal Credit.",
    "noBal_PAD": "Your {code1} balance cannot be used with Pay After Delivery.",
    "noBal_PAD_plural": "Your {code1} and {code2} balances cannot be used with Pay After Delivery.",
    "noBal_OTHER": "Your {code1} balance cannot be used with this {fi}.",
    "noBal_OTHER_plural": "Your {code1} and {code2} balances cannot be used with this {fi}.",
    "noBal_BANK": "Your {code1} balance cannot be used with this {fi} account.",
    "noBal_BANK_plural": "Your {code1} and {code2} balances cannot be used with this {fi} account.",
    "yesBal_OTHER": "Your {code1} balance must be used with this {fi}.",
    "yesBal_OTHER_plural": "Your {code1} and {code2} balances must be used with this {fi}.",
    "yesBal_BANK": "Your {code1} balance must be used with this {fi} account.",
    "yesBal_BANK_plural": "Your {code1} and {code2} balances must be used with this {fi} account.",
    "ryi_noBal": "Your payment method was updated, but your balance couldn’t be applied.",
    "ryi_noBal_plural": "Your payment method was updated, but some of your balances couldn’t be applied.",
    "ryi_yesBal": "Your payment method was updated, but your balance is required.",
    "ryi_yesBal_plural": "Your payment method was updated, but some of your balances are required.",
    "assistHeader_1page": "Check your details",
    "assistHeader_3page": "Everything look OK?",
    "assistBody_paynow_3page": "If you need to change something, it only takes a moment to add a card or new address.",
    "assistBody_paynow_1page": "Make sure everything looks OK before you continue. Need to change something? It only takes a moment to add a card or new address.",
    "assistBody_continue_3page": "It will only take a moment to add a card or new address before you return to the merchant to complete your purchase.",
    "assistBody_continue_1page": "Make sure everything looks OK before you return to the merchant to complete your purchase. Need to change something? It only takes a moment to add a card or new address.",
    "useShippingAsBilling": "Use this as my Billing Address",
    "nmjDesign2HeaderMsgPayNow": "Hi, {userName}. Check the details before you complete your payment.",
    "nmjDesign2HeaderMsgContinue": "Hi, {userName}. Check the details before you return to the merchant to complete your purchase.",
    "viewYourPaymentMethodRights": "View your <a href='https://www.paypal.com/us/cgi-bin/webscr?cmd=xpt/cps/popup/FundingMixEducation-outside' xo-popup class=popup target=_blank>payment method rights</a>",
    "loggedInFaceBookBA": "You’re logged in because you added PayPal to Facebook, {userName}.",
    "stepUpAddAddress": "To add a new shipping address, we'll need to open your Venmo app so you can log in.",
    "stepUpGeneral": "To proceed with the transaction, we'll need to open your Venmo app so you can log in.",
    "stepUpStatement": "Log in to your Venmo account",
    "useDebitCard": "Pay using debit card or bank. Credit cards can't be used for this transaction."
  },
  "chooseCreditOption": {
    "termsAndConditionsTitle": "Credit Offer Terms and Conditions",
    "SACTermsAndConditions": "SAC Terms and Conditions",
    "title": "Choose your payment plan",
    "titleMicaSpecific": "Choose your payment plan",
    "singleOfferTitle": "Buy now, pay over time",
    "SACTitle": "Get 6 months to pay for today's purchase",
    "SACOfferNotes": "PayPal Credit makes it easy to buy what you need, on a plan that fits your budget. Choose this special offer from PayPal Credit and enjoy no payments plus no interest for 6 months if paid in full within 6 months.",
    "noOfferTitle": "Buy today, pay later with PayPal Credit",
    "noOfferNotes": "You can still apply for PayPal Credit and pay over time.",
    "purchaseAmount": "Your purchase amount: <strong>{amount}</strong>",
    "bmlDescription": "With PayPal Credit, you get a flexible credit line that makes it easier to buy the things you love. It's quick to apply, and you can manage your account at PayPal.com. Select a plan that fits your budget.",
    "bmlDescriptionMica": "PayPal Credit makes it easier to buy the things you love. The application is simple, and you can manage your account at PayPal.com. Select the Easy Payments plan that ﬁts your budget.",
    "firstPaymentDescription": "Your first payment will be due in 25 days or later.",
    "noPaymentsIfPayInFull": "No Payments + No Interest if paid in full in 6 months",
    "buyNow": "PayPal Credit is a flexible credit line that makes it easy to buy now and pay over time.",
    "buyNowDescription": "No lengthy application to fill out - just answer 2 quick questions, accept the terms, and get a decision in seconds.",
    "valueEasyPayments": "<strong>{term} Easy Payments<sup>*</sup></strong>",
    "valuePayments": "<strong>{term} payments<sup>*</sup></strong>",
    "valuePerMonth": "<strong>{monthlyPayment}</strong> per month",
    "valueAPR": "<strong>{apr}%</strong> APR",
    "valueMonths": "<strong>{term} Easy Payments</strong>",
    "valueEveryMonth": "<strong>{term}</strong> month term",
    "valueInterest": "<strong>{interest}</strong> est. interest",
    "valueTotalPayment": "Payments total:",
    "valueTotalPayment2": "Total of payments {totalPayment}.",
    "valueTotalInterest": "<strong>{totalInterest}</strong> est. interest",
    "postScriptCondition": "<sup>*</sup> All payment plans subject to credit approval. Minimum purchase required. May exclude shipping and tax.",
    "postScriptConditionMicaSpecific": "<sup>*</sup> All payment plans subject to credit approval. Minimum purchase required.",
    "postScriptCondition2": "Subject to credit approval. Minimum purchase required. May exclude shipping and tax.",
    "postScriptConditionMicaSpecific2": "<sup>*</sup> Offer subject to credit approval. Minimum purchase required.",
    "notInterested": "Not interested in payment plans?",
    "usePayPal": "You can still securely <a href=\"{href}\" class=\"usePayPal proceed\">check out with PayPal</a>",
    "payInFull": "<a class=\"popup\" xo-popup target=_new href=\"{href}\">See terms</a>",
    "seeTermsInstallment": "<a class=\"popup smallPopup\" xo-popup target=_new href=\"{seeTermsUrl}\">See terms</a>",
    "seeTermsSAC": "<a class=\"popup smallPopup\" xo-popup target=_new href=\"https://www.billmelater.com/cm/paypal/landers/16ppcACQ.html\">See terms</a>",
    "applyNow": "Apply Now",
    "selectOffer": "Select",
    "paymentsTotal": "Payments total:",
    "minimumAmt": "{minAmount} min. purchase",
    "USOfferHeading": "How would you like to pay for today's purchase?",
    "USOfferDescription": "PayPal Credit is a credit line you can use whenever you check out with PayPal. Choose one of these special financing options for your purchase today.",
    "USNIHeading": "No Interest if paid in full in 6 months",
    "USNIDescription": "Make a mininum payment or more each month",
    "USNINote1": "$99 minimum purchase required. Pay off your balance in 6 months to avoid interest.",
    "USNISeeTerms": "Interest will be charged to your account from the purchase date if the balance is not paid in full within 6 months. <a class=\"popup smallPopup\" xo-popup stop-propagation target=_new href=\"https://www.paypal.com/ppclander\">See terms</a>",
    "USPayInFullText": "Don’t want to pay with PayPal Credit? You can still securely",
    "USPayInFullLink": "check out with PayPal.",
    "USLenderDisclaimerText": "Offers subject to credit approval.",
    "USInstallmentHeadingWithAPR": "Easy Payment plans starting at {apr}% APR",
    "USInstallmentHeadingNoAPR": "Easy Payment plans",
    "USInstallmentDescription": "Pay the same amount each month",
    "UKOfferHeading": "Spread the cost with PayPal Credit",
    "UKOfferDescription": "With PayPal Credit you have an instant credit limit to complete this purchase. You can also use it for future purchases by simply selecting it from your PayPal wallet.",
    "UKNoOfferHeading": "Use PayPal Credit without instalments*",
    "UKNoOfferNote1": "No set repayments. You will see this transaction in your next statement.",
    "UKNIHeading": "Get 0% interest for 4 months*",
    "UKNIDescription": "No set repayments. No interest if paid off in 4 months.*",
    "UKNINote1": "With PayPal Credit, whenever you spend over {minAmount} in a single transaction you'll get 0% for 4 months on this purchase.",
    "UKPayInFullText": "Not interested in spreading the cost? You can still securely",
    "UKPayInFullLink": "check out with PayPal.",
    "UKLenderDisclaimerTextNonInst": "* Subject to credit approval. UK customers only. Minimum payment due still applies to 0% interest offer balances. Any remaining balance after the promotional period will be subject to the standard variable rate. To keep your offers, you need to keep up monthly repayments and stay within your credit limit. See the Credit Agreement for more details.",
    "UKLenderDisclaimerTextInst": "* Subject to credit approval. UK customers only. On instalment offers, the agreed interest rate is fixed for the term. Amounts may change if your order is amended before checkout. To keep your offers, you need to keep up monthly repayments and stay within your credit limit. See the Credit Agreement for more details.",
    "UKInstallmentHeading": "Pay the same amount each month",
    "DEInstallmentHeading": "<strong>Your purchase amount, excluding interest: {amount}</strong>",
    "installmentHeading": "Pay the same amount each month",
    "installmentDescription2": "Easy Payment plans from {monthlyPayment}/month for {term} months",
    "installmentDescriptionAprZero": "Easy Payment plans starting at 0% APR",
    "singleInstallmentDescription": "{term} Easy Payments of {monthlyPayment} at {apr}% APR",
    "choose": "Choose",
    "close": "Close",
    "chooseOfferBtn": "Choose Offer",
    "moreInfo": "More info",
    "selectedOfferText1": "{term} payments of {monthlyPayment} per month",
    "selectedOfferText2": "{apr}% APR, {interest} est. interest, {totalPayment} payments total",
    "selectedOfferTerms": "Subject to credit approval. <a class=\"popup\" xo-popup target=_new href=https://www.paypal.com/us/webapps/mpp/credit-easy-payments>See terms</a>",
    "paymentPlan": "Payment Plan",
    "reviewPaymentPlan": "Review your payment details",
    "seeAllPlans": "See all plans",
    "NIOnlyHeading": "Get 0% interest for 4 months",
    "NIOnlyDescription": "No set repayments. No interest if paid off in 4 months.*",
    "noOfferHeading": "Use PayPal Credit for this purchase",
    "noOfferDescription": "Get an instant credit limit to complete this and future purchases. Plus, you get 0% for 4 months on any transaction over £150.",
    "faqLink": "Any questions? <a class=\"popup\" xo-popup target=_new href=https://www.paypal.com/uk/paypalcredit-FAQs><strong>See our FAQs</strong></a>",
    "terms": "T&Cs apply",
    "creditSampleHeader": "How PayPal Credit works for future purchases",
    "creditSamplePara": "With PayPal Credit you have an additional payment option in your PayPal wallet for you to choose whenever you check out with PayPal. Every time you spend over {minAmount} in one transaction, you’ll automatically get 0% interest for 4 months on that purchase. For transactions under {minAmount} the standard variable rate will apply unless a promotional offer is available.",
    "representativeEx": "* This example shows the typical cost of using PayPal Credit without offers.",
    "representativeExHeader": "Representative example",
    "representativeAPR": "Representative APR (variable)",
    "representativeAPRValueControl": "17.9% APR",
    "representativeAPRValue": "19.9% APR",
    "purchaseRateValueControl": "17.9%",
    "purchaseRateValue": "19.9%",
    "purchaseRate": "Purchase rate p.a. (variable)",
    "exCreditLimit": "Assumed credit limit",
    "exCreditLimitValue": "£1,200"
  },
  "applyForBml": {
    "bmlApplyHeadline": "Apply for PayPal Credit",
    "bmlApplyHeadlineShort": "Apply for PayPal Credit",
    "bmlApplyEduTitle": "Benefits of PayPal Credit",
    "bmlApplyEduBullet1": "No Payments + No Interest for 6 months on all purchases of $99 or more",
    "bmlApplyEduBullet1Fullpage": "No Payments + No Interest for 6 months on all purchases of $99 or more*",
    "bmlApplyEduBullet2": "A flexible credit line for your PayPal account",
    "bmlApplyEduBullet3": "Easily pay your balance at PayPal.com",
    "bmlApplyBillingAddress": "Billing address",
    "bmlApplyBillingAddressReview": "Review your billing address",
    "bmlApplyChange": "Change",
    "bmlApplyTelephone": "No thanks",
    "bmlApplyESign": "By clicking <strong>Agree & Continue</strong>, I confirm I have read the <a href=https://cms.paypal.com/cgi-bin/marketingweb?cmd=_render-content&content_ID=bml/BMLTerms xo-popup class=popup target=_blank>E-Sign Consent</a> and I agree to have the Terms & Conditions presented electronically.",
    "bmlApplyContinue": "Continue",
    "bmlApplyNoThanks": "No Thanks",
    "bmlApplyInterestTerms": "* Interest accumulates from the date of purchase and will be charged if the balance is not paid in full within 6 months.",
    "bmlApplyHelpUsVerify": "<strong>Help us verify your identity.</strong>",
    "bmlApplyPleaseVerifyIdentity": "Please verify your identity",
    "bmlApplyReviewYourInfo": "Review your personal information",
    "bmlApplyDateOfBirth": "Date of Birth",
    "bmlApplyDay": "Day",
    "bmlApplyMonth": "Month",
    "bmlApplyDate": "Date",
    "bmlApplyYear": "Year",
    "bmlApplyMM": "Month",
    "bmlApplyDD": "Day",
    "bmlApplyYYYY": "Year",
    "bmlApplyToolTipDob": "You must be 18 years of age to apply for PayPal Credit.",
    "bmlApplyLast4SSN": "SSN",
    "bmlApplyToolTipSSN": "Enter the last 4 digits of your SSN",
    "bmlApplyTermsTitle": "Terms and Conditions",
    "bmlApplyTermsDirections": "There's a lot of important info here, so please scroll to the end before continuing.",
    "bmlApplyTermsDirectionsModal": "Please scroll to the bottom of the Terms and Conditions.",
    "bmlApplyTermsSubmit": "Agree & Continue",
    "bmlApplyRequiredFieldsBlank": "The fields should not be blank.",
    "bmlApplyBlank_dobMonth": "Please enter date of birth Month.",
    "bmlApplyBlank_dobDay": "Please enter date of birth Day.",
    "bmlApplyBlank_dobYear": "Please enter date of birth Year.",
    "bmlApplyBlank_nationalId": "Please enter your national Id.",
    "bmlApplyBlank_street1": "Please enter your street.",
    "bmlApplyBlank_city": "Please enter your city.",
    "bmlApplyBlank_state": "Please enter your state.",
    "bmlApplyBlank_country": "Please enter your country or region.",
    "bmlApplyBlank_postalCode": "Please enter your postal code.",
    "bmlApplyBlank_phoneType": "Please enter your phone type.",
    "bmlApplyBlank_telephone": "Please enter your telephone.",
    "bmlDeclineSoft": "There's a problem with some of your information. Please review and try again.",
    "bmlNapeNegativeMatch": "We’re sorry but we weren’t able to link your PayPal and PayPal Credit accounts. Please complete the form to apply for PayPal Credit.",
    "bmlNapeGreeting": "Welcome back, {firstName}!",
    "bmlNapeItLooksLikeYouAlreadyHave": "It looks like you already have a PayPal Credit account. It will just take a minute to link it to your PayPal account.",
    "paypalBmlSignupProp": "We'll email information and account statements. You can manage your account and make online payments at PayPal.com.",
    "paypalBmlGuestProp": "Join the millions of people who rely on our security & convenience, online and in stores.",
    "emailDisplaySignup": "<strong>{email}</strong> (Login ID)",
    "emailDisplayGuest": "<strong>{email}</strong> (for receipt)",
    "signupAccountCreationHeading": "How to manage your account",
    "guestAccountCreationHeading": "Create an account!",
    "bmlApplyWithPayPal": "You're applying for a credit line to pay for this and future purchases when you shop with PayPal.",
    "bmlApplyWithPayPalMicaSpecific": "You're applying for a credit line to pay for this purchase.",
    "bmlPaymentDetail": "{term} Easy Payments of ${monthlyPayment} per month, {apr}% APR, {interest} est. interest, {totalPayment} payments total.",
    "subjectApproval": "Subject to credit approval.",
    "bmlSACOfferDetail": "No Payments + No Interest if paid in full in 6 months",
    "bmlSACOfferAmount": "Estimated interest $0 if paid in full in 6 months. Total of payments ${totalPayment}.",
    "micaPropDesc": "We understand that you're cautious about providing your personal information. We're serious about protecting your privacy and ask for this information to:",
    "micaProp1": "Make sure it's really you applying for credit",
    "micaProp2": "Make a credit decision in seconds",
    "paymentPlan": "Payment Plan",
    "seeTerms": "See terms",
    "personalInfo": "Your personal information",
    "agreementTermsTitle": "PayPal Credit Terms and Conditions",
    "printCopy": "Print version",
    "agreementTermsFooterInfo1": "There's a lot of important information here.",
    "agreementTermsFooterInfo2": "Please scroll to the end to continue.",
    "beforeYouGo": "Before you go...",
    "payByInstallmentReviewDesc": "Take a moment to review your payment information. You'll return to {merchantName} to complete your purchase.",
    "payByInstallmentReviewDescMica": "You'll return to {merchantName} to complete your purchase. First, take a moment to review your payment information.",
    "payByInstallmentReviewDescMicaExistingMember": "It looks like you already have a PayPal account. To link it to your new PayPal Credit account, log in to PayPal.com at any time.<p>You'll return to {merchantName} to complete your purchase.</p>",
    "paymentMethodUpdated": "Payment method updated",
    "micaApprovalHeadline": "You're approved!",
    "micaApprovalMessageLine1": "<strong>Your new credit line is {currencySymbol}{creditLine}</strong>, and your estimated monthly payment for today's purchase is {paymentCurrencySymbol}{monthlyPayment}. This credit line has been added to your PayPal account and will be available when you shop with PayPal.",
    "micaApprovalMessageLine2": "Your estimated monthly payment for today's purchase is {paymentCurrencySymbol}{monthlyPayment}. This credit line has been added to your PayPal account and will be available when you shop with PayPal.",
    "micaApprovalMessageLine3": "Account statements will be sent to {email}",
    "ssnToolTip": "This helps us ensure it's really you applying for credit, and allows us to make a credit decision in seconds.",
    "lastFour": "Last 4",
    "createPayPalAccount": "Create a PayPal Account.",
    "createPayPalAccountDesc": "Be sure to review your information. And remember, you'll need a PayPal account to manage your new line credit and make payments online.",
    "micaReusePropHeader": "That was fast!",
    "micaReusePropDesc": "PayPal Credit in your PayPal account makes it easier than ever to speed through checkout.",
    "agreeContinue": "Agree & Continue",
    "agreeApply": "Agree & Apply",
    "verifyToolTipAlt": "Why do we need this?",
    "payInFull": "<a href=\"{href}\">Pay in full now</a>",
    "notInterestedNoInstallments": "Not interested in a credit line?",
    "termsPayments": "<strong>{term}</strong> payments",
    "termsAPR": "<strong>{apr}%</strong> APR",
    "termsInterest": "<strong>{interest}</strong> est. interest",
    "termsMonthlyPayment": "<strong>${monthlyPayment}</strong> per month",
    "termsTerm": "<strong>{term}</strong> month term",
    "termsPaymentsTotal": "<strong>{totalPayment}</strong> payments total",
    "termsPaymentPlanHeader": "Details for today's promotional purchase",
    "noShare": "We don't share this sensitive information with the merchant.",
    "return": "Return to {merchantName}",
    "micaMemberToMemberHeader": "Looks like you already have PayPal Credit...",
    "micaMemberToMemberMsg": "You already have a PayPal Credit account, and it's linked to a different PayPal account. Please return to {merchantName} and choose another way to pay.",
    "micaMemberToMemberMsgDefaultMerchant": "You already have a PayPal Credit account, and it's linked to a different PayPal account. Please return to Merchant and choose another way to pay.",
    "download": "Download",
    "confirmationPopupListItem1": "You're applying for a credit line that is subject to interest.",
    "confirmationPopupListItem2": "We'll send an email to {email} each time your new billing statement is ready to view online.",
    "cancelApplication": "Cancel application",
    "payPalCredit": "PayPal Credit",
    "justToConfirm": "Just to confirm...",
    "close": "Close"
  },
  "bmlGuestHeadline": "Get more time with PayPal Credit",
  "bmlGuestValueProp1": "Plus 0% for 6 months for this purchase",
  "bmlGuestValueProp2": "A flexible line of credit, $1000 and up",
  "billingAgreement": {
    "title": "Billing agreement",
    "memberAgreementWithPurchaseButtonPay": "I’ve selected PayPal as my preferred payment method for payments with {merchantName}. Payments will be charged to my <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>default payment method</a>, unless I have a balance. I can change my payment method at any time at <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com>PayPal.com</a>.",
    "memberAgreementWithPurchaseButtonContinue": "I’ve selected PayPal as my preferred payment method for payments with {merchantName}. Payments will be charged to my <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>default payment method</a>, unless I have balance. I can change my payment method at any time at <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com>PayPal.com</a>.",
    "memberAgreementWithoutPurchaseButtonPay": "I’ve selected PayPal as my preferred payment method for future payments with {merchantName}. Payments will be charged to my <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>default payment method</a>, unless I have a balance. I can change my payment method at any time at <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com>PayPal.com</a>.",
    "memberAgreementWithoutPurchaseButtonContinue": "I’ve selected PayPal as my preferred payment method for future payments with {merchantName}. Payments will be charged to my <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>default payment method</a>, unless I have a balance. I can change my payment method at any time at <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com>PayPal.com</a>.",
    "memberAgreementChangeFS": "I agree to use {paymentType} for this payment to {merchantName}. I understand that my <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>default payment method</a> may be used for future payments.",
    "signupAgreementWithPurchase": "I agree to allow {merchantName} to charge payments to my card. I understand that if I add another payment method to my PayPal account, that payment method may be charged instead. I can change my payment method at any time on <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com>PayPal.com</a>.",
    "signupAgreementWithoutPurchase": "I agree to use PayPal for future payments to {merchantName}. I can change my payment method at any time on <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com>PayPal.com</a>.",
    "detailsHeading": "Billing Agreement Details:",
    "agreePay": "I agree to pay",
    "propHead": "Serious about security",
    "propVal": "We don't share your financial details with the merchant, no matter where you shop.",
    "agrementError": "Please read and agree to the billing agreement to continue.",
    "memberAgreementNoFiStickyContinue": "I authorize <b>{merchantName}</b> to charge my PayPal account for automatic payments. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can set or change the payment method I want to use or cancel this in my Settings. I understand until I set a payment method in my Settings, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>.",
    "memberAgreementNoFiStickyContinueCollapsed": "I authorize <b>{merchantName}</b> to charge my PayPal account for future payments.",
    "memberAgreementNoFiStickyPay": "I authorize <b>{merchantName}</b> to charge my PayPal account for automatic payments. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can set or change the payment method I want to use or cancel this in my Settings. I understand until I set a payment method in my Settings, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>.",
    "memberAgreementNoFiStickyPayCollapsed": "I authorize <b>{merchantName}</b> to charge my PayPal account for future payments.",
    "memberAgreementFiStickyContinue": "I want to use <b>{fiName} {fiFormatLast4}</b> for automatic payments to <b>{merchantName}</b>. I understand that if this payment method is unavailable, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a> and that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can also change my payment method or cancel this authorization in my Settings.",
    "memberAgreementFiStickyContinueCollapsed": "I want to use <b>{fiName} {fiFormatLast4}</b> for future payments to <b>{merchantName}</b>.",
    "memberAgreementFiStickyPay": "I want to use <b>{fiName} {fiFormatLast4}</b> for automatic payments to <b>{merchantName}</b>. I understand that if this payment method is unavailable, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a> and that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can also change my payment method or cancel this authorization in my Settings.",
    "memberAgreementFiStickyPayCollapsed": "I want to use <b>{fiName} {fiFormatLast4}</b> for future payments to <b>{merchantName}</b>.",
    "memberAgreementCibSticky": "I want to use <b>{fiName} {fiFormatLast4}</b> for future PayPal payments on the {merchantName} platform in accordance with {merchantName} policies. I understand that if this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>, and if I hold a balance with PayPal, that balance will be used first to complete my payment. I can change my preferred payment method or cancel this authorization at any time in my Settings.",
    "memberAgreementMibShowMore": "Show more",
    "rpAgreementFiStickyPay": "I want to use <b>{fiName} {fiFormatLast4}</b> for automatic payments to <b>{merchantName}</b>. I understand that if this payment method is declined or expired, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a> and that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can also change my payment method or cancel this authorization any time in my Settings.",
    "rpAgreementFiStickyContinue": "I want to use <b>{fiName} {fiFormatLast4}</b> for automatic payments to <b>{merchantName}</b>. I understand that if this payment method is declined or expired, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a> and that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can also change my payment method or cancel this authorization any time in my Settings.",
    "rpAgreementNoFiStickyPay": "I want to use PayPal for automatic payments to <b>{merchantName}</b>. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can set or change the payment method I want to use or cancel this authorization at any time in my Settings. I understand until I set a payment method in my Settings, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>.",
    "rpAgreementNoFiStickyContinue": "I want to use PayPal for automatic payments to <b>{merchantName}</b>. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can set or change the payment method I want to use or cancel this authorization at any time in my Settings. I understand until I set a payment method in my Settings, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>.",
    "signupAgreementCibStickyPay": "I want to use the card I entered above for all future payments on the {merchantName} platform where PayPal is available and in accordance with {merchantName} policies. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment, and that if my preferred payment method is expired or declined, PayPal will charge my backup payment method.  I can change my preferred payment method or cancel this authorization at any time in my Account Profile at PayPal.com.",
    "signupAgreementCibStickyContinue": "I want to use the card I entered above for all future payments on the {merchantName} platform where PayPal is available and in accordance with {merchantName} policies. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment, and that if my preferred payment method is expired or declined, PayPal will charge my backup payment method.  I can change my preferred payment method or cancel this authorization at any time in my Account Profile at PayPal.com.",
    "signupAgreementFiStickyPay": "I want to use the card I entered above for all future purchases with {merchantName}. I understand that if this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank href=https://www.paypal.com/{country}/selfhelp/article/what-is-my-backup-payment-method-faq1054?locale.x={lang}_{country}>PayPal Policies</a>, and if I hold a balance with PayPal, that balance will be used first to complete my payment.  I can change my payment method or cancel this authorization at any time in my Settings.",
    "signupAgreementFiStickyContinue": "I want to use the card I entered above for all future purchases with {merchantName}. I understand that if this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank href=https://www.paypal.com/{country}/selfhelp/article/what-is-my-backup-payment-method-faq1054?locale.x={lang}_{country}>PayPal Policies</a>, and if I hold a balance with PayPal, that balance will be used first to complete my payment.  I can change my payment method or cancel this authorization at any time in my Settings.",
    "signupRpAgreementFiStickyPay": "I want to use the card I entered above for automatic payments to {merchantName}. I understand that if this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank href=https://www.paypal.com/{country}/selfhelp/article/what-is-my-backup-payment-method-faq1054?locale.x={lang}_{country}>PayPal Policies</a>, and if I hold a balance with PayPal, that balance will be used first to complete my payment. I can change my payment method or cancel this authorization at any time in my Settings.",
    "signupRpAgreementFiStickyContinue": "I want to use the card I entered above for automatic payments to {merchantName}. I understand that if this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank href=https://www.paypal.com/{country}/selfhelp/article/what-is-my-backup-payment-method-faq1054?locale.x={lang}_{country}>PayPal Policies</a>, and if I hold a balance with PayPal, that balance will be used first to complete my payment. I can change my payment method or cancel this authorization at any time in my Settings.",
    "memberAgreementCibFiStickyPayCollapsed": "I want to use <b>{fiName} {fiFormatLast4}</b> for PayPal automatic payments on the <b>{merchantName}</b> platform in accordance with <b>{merchantName}</b> policies.",
    "memberAgreementCibFiStickyPayExpanded": "I want to use <b>{fiName} {fiFormatLast4}</b> for Paypal automatic payments on the <b>{merchantName}</b> platform in accordance with <b>{merchantName}</b> policies. I understand that if this payment method is unavailable, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>, and if I hold a balance with PayPal, that balance will be used first to complete my payment. I can change my preferred payment method or cancel this authorization in my Settings.",
    "memberAgreementCibNoFiStickyPayCollapsed": "I want to use PayPal for automatic payments on the <b>{merchantName}</b> platform, where available and in accordance with <b>{merchantName}</b> policies.",
    "memberAgreementCibNoFiStickyPayExpanded": "I want to use PayPal for automatic payments on the <b>{merchantName}</b> platform, where available and in accordance with <b>{merchantName}</b> policies. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can set or change the payment method I want to use or cancel this authorization in my Settings. I understand until I set a payment method in my Settings, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>.",
    "memberAgreementCibFiStickyContinueCollapsed": "I want to use <b>{fiName} {fiFormatLast4}</b> for PayPal automatic payments on the <b>{merchantName}</b> platform in accordance with <b>{merchantName}</b> policies.",
    "memberAgreementCibFiStickyContinueExpanded": "I want to use <b>{fiName} {fiFormatLast4}</b> for PayPal automatic payments on the <b>{merchantName}</b> platform in accordance with <b>{merchantName}</b> policies. I understand that if this payment method is unavailable, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>, and if I hold a balance with PayPal, that balance will be used first to complete my payment. I can change my preferred payment method or cancel this authorization in my Settings.",
    "memberAgreementCibNoFiStickyContinueCollapsed": "I want to use PayPal for automatic payments on the <b>{merchantName}</b> platform, where available and in accordance with <b>{merchantName}</b> policies.",
    "memberAgreementCibNoFiStickyContinueExpanded": "I want to use PayPal for automatic payments on the <b>{merchantName}</b> platform, where available and in accordance with <b>{merchantName}</b> policies. I understand that if I hold a balance with PayPal, that balance will be used first to complete my payment. I can set or change the payment method I want to use or cancel this authorization in my Settings. I understand until I set a payment method in my Settings, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>.",
    "memberAgreementCibShowMore": "Show more",
    "invoicingRegEMsg": "You are transferring and {merchantName} will receive {amountInInvCurrency}.",
    "invoicingRegEMsgWithCurrConversion": "You are paying {amountInPayerCurrency} to {merchantName}. With currency conversion, they will receive {amountInInvCurrency}.",
    "smartDollarAuthText": "When you agree to future payments, you may temporarily see a pending authorization on your card for {amountInPayerCurrency} to ensure your future purchases are successful.",
    "smartDollarAuthTextHoldOnAmt": "When you agree to future payments, you may temporarily see a pending authorization for {amountInPayerCurrency} to help make sure future purchases are successful. This amount may be held for up to five days.",
    "merchantMsgHeader": "Information from {merchantName}",
    "fincen": {
      "rpAgreement": "I authorize <b>{merchantName}</b> to charge my PayPal account for future payments. I understand that I can set or change my payment method at any time in my account settings. If there’s an issue with my preferred payment method, PayPal can try the other payment methods linked to my account as per <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>. This authorization can be cancelled in my account settings.",
      "rtMibAgreement": "I authorize <b>{merchantName}</b> to charge my PayPal account for future payments. I understand that I can set or change my payment method at any time in my account settings. If there’s an issue with my preferred payment method, PayPal can try the other payment methods linked to my account as per <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>. This authorization can be cancelled in my account settings.",
      "rtCibAgreement": "I authorize <b>{merchantName}</b> to charge my PayPal account for future payments in accordance with <b>{merchantName}</b> policies. I understand that I can set or change my payment method at any time in my account settings. If there’s an issue with my preferred payment method, PayPal can try the other payment methods linked to my account as per <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>. This authorization can be cancelled in my account settings."
    },
    "memberAgreementSubscriptionsV1FiSticky": "I want to use <b>{fiName} {fiFormatLast4}</b> for automatic payments to <b>{merchantName}</b>. I understand that my automatic payments could go up to a maximum of {subscriptionsMaxAmount}. I understand that if this payment method is declined or expired, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a> and that if I have a balance with PayPal, that balance will be used first to complete my payment. I can also change my payment method or cancel this authorization any time in my Profile.",
    "memberAgreementSubscriptionsV1NoFiSticky": "I want to use PayPal for automatic payments to <b>{merchantName}</b>. I understand that my automatic payments could go up to a maximum of {subscriptionsMaxAmount}. I understand that if I have a balance with PayPal, that balance will be used first to complete my payment. I can set or change the payment method I want to use or cancel this authorization at any time in my Settings. I understand that until I set a payment method in my Profile, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>.",
    "signupAgreementSubscriptionsV1": "I want to use the card I entered above for automatic payments to {merchantName}. I understand that my automatic payments could go up to a maximum of {subscriptionsMaxAmount}. I understand that if this payment method is expired or declined, the payment method used will follow <a class=popup xo-popup target=_blank target=_new href=https://www.paypal.com/us/webapps/mpp/popup/about-payment-methods>PayPal Policies</a>, and if I have a balance with PayPal, that balance will be used first to complete my payment. I can change my payment method or cancel this authorization at any time in my Profile.",
    "instantlyPayWith": "Instantly pay with",
    "guestAgreementSubscriptionsV1": "I want to use the card I entered above for automatic payments to <b>{merchantName}</b>."
  },
  "offers": {
    "bmlOfferLargeHeadline": "Choose <span class=nowrap>PayPal Credit</span>",
    "bmlOfferLarge": "Now you can have more time to pay for purchases of $99+.",
    "bmlOfferLargeTerms": "Subject to credit approval. <a href='https://www.securecheckout.billmelater.com/paycapture-content/fetch?hash=AU826TU8&content=/bmlweb/bmlppaiw.html' class='bmlTermsLink' xo-popup>See Terms</a>",
    "bmlOfferLargeForWallet": "Get $10 back and 6 months to pay with PayPal Credit",
    "bmlOfferLargeForWalletFlat": "Now you can have more time to pay for purchases of $99+.",
    "bmlOfferSmallHeadline": "Choose <span class=nowrap>PayPal Credit</span>",
    "bmlOfferSmall": "<span class=nowrap>PayPal Credit</span> is a credit line available almost anywhere PayPal is accepted.",
    "bmlOfferSmallLine2": "on your first purchase.*",
    "bmlOfferSmallForWallet": "Get $10 back.",
    "bmlOfferSmallForWalletFlat": "PayPal Credit is a credit line available almost anywhere PayPal is accepted.",
    "bmlOfferSmallLine2ForWallet": "Apply now!",
    "bmlOfferBtn": "Apply Now",
    "apply": "APPLY",
    "seeTerms": "<a href='https://www.securecheckout.billmelater.com/paycapture-content/fetch?hash=AU826TU8&content=/bmlweb/bmlppaiw.html' class='bmlTermsLink'>See Terms</a>",
    "bmlOfferSeeTermsLong": "Subject to credit approval. <a href='https://www.securecheckout.billmelater.com/paycapture-content/fetch?hash=AU826TU8&content=/bmlweb/bmlppaiw.html' class='popup bmlTermsLink' target='_blank' xo-popup>See Terms</a>",
    "seeBmlTerms": "<a class=\"popup\" href=\"https://www.billmelater.com/cm/paypal/landers/14ppbmlREUSEST.html\" target=\"_new\">See Terms</a>",
    "reviewBmlOfferHeadline": "Apply for <span class=nowrap>PayPal Credit</span>",
    "reviewBmlOffer": "Get $10 back and 6 months to pay with PayPal Credit",
    "reviewBmlOfferNoSixMonths": "Get $10 back with PayPal Credit",
    "reviewBmlOfferFlat": "Get $10 back and 6 months to pay with PayPal Credit",
    "reviewBmlOfferNoSixMonthsFlat": "Get $10 back with PayPal Credit",
    "plccCardOfferHeader": "{merchantName} Debit or Credit Card",
    "plccCardOfferDesc": "Add your card now to begin earning rewards.",
    "plccAddNowLink": "Add Now",
    "plccCardOfferDescWallet": "Add your card now to begin earning rewards.",
    "bmlOfferSmallTitle": "Get more time to pay with PayPal Credit",
    "bmlOfferLargeTitle": "Get 6 months to pay with PayPal Credit",
    "bmlOfferSmallTitleWithAmount": "Get more time to pay {cartAmount} with <span class=nowrap>PayPal Credit</span>",
    "bmlOfferLargeTitleWithAmount": "Get 6 months to pay {cartAmount} with <span class=nowrap>PayPal Credit</span>",
    "bmlOfferTitleWithAmountZero": "Get more time to pay for this purchase with PayPal Credit",
    "cycoOfferBtn": "See Offers",
    "bmlExistingOfferTitle": "You have <span class=nowrap>PayPal Credit</span>!",
    "bmlExistingOfferLarge": "Get 6 months to pay for this purchase.",
    "bmlExistingOfferSmall": "Get more time to pay for this purchase.",
    "bmlInWalletDeniedMsg": "<b>Sorry, your PayPal Credit application wasn't approved.</b> You'll receive an email shortly explaining why.",
    "bmlInWalletInvalidInstallmentsMsg": "Easy Payments aren’t available when you have a PayPal Exclusive Offer in your account. You can continue with PayPal Credit or choose another way to pay.",
    "bmlInWalletSuccessMsg": "Congratulations! PayPal Credit is now in your wallet as an additional funding source.",
    "bmlOfferPassiveCta": "Apply for <span class=nowrap>PayPal Credit</span>",
    "bmlOfferPassiveEZPCta": "See Offers & Apply for <span class=nowrap>PayPal Credit</span>",
    "bmlOfferPassiveDetails": "Pay over time for your purchase of {cartAmount} with <span class=nowrap>PayPal Credit</span>.",
    "bmlOfferPassiveSACDetails": "Get 6 months to pay {cartAmount}.",
    "subjectToApproval": "Subject to credit approval.",
    "seeTermsText": "See terms",
    "bmlOfferReuseCta": "Select",
    "bmlIneligibleHeader": "Sorry, we can't offer you PayPal Credit right now.",
    "bmlIneligibleContent": "Please select another funding source to complete your purchase.",
    "bmlCrossBorderIneligibleContent": "The credit offer you selected is only available to {merchantCountry} residents. You can pay using the PayPal Credit offer below or by changing your payment method.",
    "select": "Select",
    "or": "or",
    "assetLite": {
      "bmlOfferSmallTitleWithAmount": "Pay over time for your purchase of {cartAmount} with <span class=nowrap>PayPal Credit</span>.",
      "bmlOfferLargeTitleWithAmount": "No Interest if paid in full in 6 months for your purchase of {cartAmount} with <span class=nowrap>PayPal Credit</span>.",
      "bmlOfferTitleWithAmountZero": "Pay over time for your purchase with <span class=nowrap>PayPal Credit</span>.",
      "bmlOfferEZPTitleWithAmount": "Enjoy special financing for your purchase of {cartAmount} with <span class=nowrap>PayPal Credit</span>.",
      "bmlExistingOfferSmall": "Pay over time for your purchase of {cartAmount}.",
      "bmlExistingOfferLarge": "No Interest if paid in full in 6 months for your purchase of {cartAmount}.",
      "bmlExistingAmountZero": "Pay over time for your purchase.",
      "bmlExistingOfferEZP": "Enjoy special financing for your purchase of {cartAmount}.",
      "cycoOfferBtn": "See offers",
      "cycoOffersThreeMonthCoreBtn": "See offer",
      "bmlExistingOfferSmallDetails": "Pay over time for your purchase.",
      "bmlExistingOfferLargeDetails": "No Interest if paid in full in 6 months.",
      "bmlExistingOfferEZPDetails": "Enjoy special financing for your purchase.",
      "bmlReturnOfferthreeMonthEZPDetails": "3 Easy Payments.",
      "bmlExistingOfferthreeMonthEZPDetails": "Easy Payments available.",
      "bmlExistingOfferAmountZeroDetails": "Pay over time for your purchase.",
      "bmlOfferPassiveCta": "Apply for <span class=nowrap>PayPal Credit</span>",
      "bmlOfferPassiveEZPCta": "See Offers & Apply for <span class=nowrap>PayPal Credit</span>",
      "bmlOfferPassiveDetails": "Pay over time for your purchase of {cartAmount} with <span class=nowrap>PayPal Credit</span>.",
      "bmlOfferPassiveEZPDetails": "Enjoy special financing for your purchase of {cartAmount} with <span class=nowrap>PayPal Credit</span>.",
      "bmlOfferNIWalletDetails": "6 months special financing available",
      "bmlOfferNIWalletCta": "<span class=nowrap>PayPal Credit</span>",
      "bmlOfferPassiveNIDetails": "No Interest if paid in full in 6 months on your purchase of {cartAmount}.",
      "bmlOfferCheckMark2": "Use on any purchase of $99+",
      "threeMonthINSTDetails": "Split into 3 Easy Payments of {monthlyPayment}/mo. at 0% APR with no money due today."
    },
    "assetlite": {
      "bmlOfferNItreatment3": "Why pay {cartAmount} today? Pay over time with No Interest if paid in full in 6 months"
    },
    "specialFinancingBadge": "SPECIAL FINANCING"
  }
}, "3.0.216");