webpackJsonp([0],{

/***/ "../node_modules/base64-js/index.js":
/***/ (function(module, exports) {



exports.byteLength = byteLength;
exports.toByteArray = toByteArray;
exports.fromByteArray = fromByteArray;

var lookup = [];
var revLookup = [];
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i];
  revLookup[code.charCodeAt(i)] = i;
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62;
revLookup['_'.charCodeAt(0)] = 63;

function getLens(b64) {
  var len = b64.length;

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4');
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=');
  if (validLen === -1) validLen = len;

  var placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;

  return [validLen, placeHoldersLen];
}

// base64 is 4/3 + up to two characters of the original data
function byteLength(b64) {
  var lens = getLens(b64);
  var validLen = lens[0];
  var placeHoldersLen = lens[1];
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}

function _byteLength(b64, validLen, placeHoldersLen) {
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}

function toByteArray(b64) {
  var tmp;
  var lens = getLens(b64);
  var validLen = lens[0];
  var placeHoldersLen = lens[1];

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));

  var curByte = 0;

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0 ? validLen - 4 : validLen;

  var i;
  for (i = 0; i < len; i += 4) {
    tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)];
    arr[curByte++] = tmp >> 16 & 0xFF;
    arr[curByte++] = tmp >> 8 & 0xFF;
    arr[curByte++] = tmp & 0xFF;
  }

  if (placeHoldersLen === 2) {
    tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4;
    arr[curByte++] = tmp & 0xFF;
  }

  if (placeHoldersLen === 1) {
    tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2;
    arr[curByte++] = tmp >> 8 & 0xFF;
    arr[curByte++] = tmp & 0xFF;
  }

  return arr;
}

function tripletToBase64(num) {
  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F];
}

function encodeChunk(uint8, start, end) {
  var tmp;
  var output = [];
  for (var i = start; i < end; i += 3) {
    tmp = (uint8[i] << 16 & 0xFF0000) + (uint8[i + 1] << 8 & 0xFF00) + (uint8[i + 2] & 0xFF);
    output.push(tripletToBase64(tmp));
  }
  return output.join('');
}

function fromByteArray(uint8) {
  var tmp;
  var len = uint8.length;
  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
  var parts = [];
  var maxChunkLength = 16383; // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1];
    parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 0x3F] + '==');
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1];
    parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 0x3F] + lookup[tmp << 2 & 0x3F] + '=');
  }

  return parts.join('');
}

/***/ }),

/***/ "../node_modules/buffer/index.js":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



var base64 = __webpack_require__("../node_modules/base64-js/index.js")
var ieee754 = __webpack_require__("../node_modules/ieee754/index.js")
var isArray = __webpack_require__("../node_modules/isarray/index.js")

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  this[offset] = (value & 0xff)
  return offset + 1
}

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24)
    this[offset + 2] = (value >>> 16)
    this[offset + 1] = (value >>> 8)
    this[offset] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
    this[offset + 2] = (value >>> 16)
    this[offset + 3] = (value >>> 24)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start
  var i

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if (code < 256) {
        val = code
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString())
    var len = bytes.length
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}


/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("../node_modules/webpack/buildin/global.js")))

/***/ }),

/***/ "../node_modules/core-js/fn/array/find.js":
/***/ (function(module, exports, __webpack_require__) {



__webpack_require__("../node_modules/core-js/modules/es6.array.find.js");
module.exports = __webpack_require__("../node_modules/core-js/modules/_core.js").Array.find;

/***/ }),

/***/ "../node_modules/core-js/fn/array/includes.js":
/***/ (function(module, exports, __webpack_require__) {



__webpack_require__("../node_modules/core-js/modules/es7.array.includes.js");
module.exports = __webpack_require__("../node_modules/core-js/modules/_core.js").Array.includes;

/***/ }),

/***/ "../node_modules/core-js/fn/object/assign.js":
/***/ (function(module, exports, __webpack_require__) {



__webpack_require__("../node_modules/core-js/modules/es6.object.assign.js");
module.exports = __webpack_require__("../node_modules/core-js/modules/_core.js").Object.assign;

/***/ }),

/***/ "../node_modules/core-js/fn/object/entries.js":
/***/ (function(module, exports, __webpack_require__) {



__webpack_require__("../node_modules/core-js/modules/es7.object.entries.js");
module.exports = __webpack_require__("../node_modules/core-js/modules/_core.js").Object.entries;

/***/ }),

/***/ "../node_modules/core-js/fn/object/values.js":
/***/ (function(module, exports, __webpack_require__) {



__webpack_require__("../node_modules/core-js/modules/es7.object.values.js");
module.exports = __webpack_require__("../node_modules/core-js/modules/_core.js").Object.values;

/***/ }),

/***/ "../node_modules/core-js/fn/string/includes.js":
/***/ (function(module, exports, __webpack_require__) {



__webpack_require__("../node_modules/core-js/modules/es6.string.includes.js");
module.exports = __webpack_require__("../node_modules/core-js/modules/_core.js").String.includes;

/***/ }),

/***/ "../node_modules/core-js/modules/_a-function.js":
/***/ (function(module, exports) {



module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_add-to-unscopables.js":
/***/ (function(module, exports, __webpack_require__) {



// 22.1.3.31 Array.prototype[@@unscopables]
var UNSCOPABLES = __webpack_require__("../node_modules/core-js/modules/_wks.js")('unscopables');
var ArrayProto = Array.prototype;
if (ArrayProto[UNSCOPABLES] == undefined) __webpack_require__("../node_modules/core-js/modules/_hide.js")(ArrayProto, UNSCOPABLES, {});
module.exports = function (key) {
  ArrayProto[UNSCOPABLES][key] = true;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_an-object.js":
/***/ (function(module, exports, __webpack_require__) {



var isObject = __webpack_require__("../node_modules/core-js/modules/_is-object.js");
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_array-includes.js":
/***/ (function(module, exports, __webpack_require__) {



// false -> Array#indexOf
// true  -> Array#includes
var toIObject = __webpack_require__("../node_modules/core-js/modules/_to-iobject.js");
var toLength = __webpack_require__("../node_modules/core-js/modules/_to-length.js");
var toAbsoluteIndex = __webpack_require__("../node_modules/core-js/modules/_to-absolute-index.js");
module.exports = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
      // Array#indexOf ignores holes, Array#includes - not
    } else for (; length > index; index++) {
      if (IS_INCLUDES || index in O) {
        if (O[index] === el) return IS_INCLUDES || index || 0;
      }
    }return !IS_INCLUDES && -1;
  };
};

/***/ }),

/***/ "../node_modules/core-js/modules/_array-methods.js":
/***/ (function(module, exports, __webpack_require__) {



// 0 -> Array#forEach
// 1 -> Array#map
// 2 -> Array#filter
// 3 -> Array#some
// 4 -> Array#every
// 5 -> Array#find
// 6 -> Array#findIndex
var ctx = __webpack_require__("../node_modules/core-js/modules/_ctx.js");
var IObject = __webpack_require__("../node_modules/core-js/modules/_iobject.js");
var toObject = __webpack_require__("../node_modules/core-js/modules/_to-object.js");
var toLength = __webpack_require__("../node_modules/core-js/modules/_to-length.js");
var asc = __webpack_require__("../node_modules/core-js/modules/_array-species-create.js");
module.exports = function (TYPE, $create) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  var create = $create || asc;
  return function ($this, callbackfn, that) {
    var O = toObject($this);
    var self = IObject(O);
    var f = ctx(callbackfn, that, 3);
    var length = toLength(self.length);
    var index = 0;
    var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
    var val, res;
    for (; length > index; index++) {
      if (NO_HOLES || index in self) {
        val = self[index];
        res = f(val, index, O);
        if (TYPE) {
          if (IS_MAP) result[index] = res; // map
          else if (res) switch (TYPE) {
              case 3:
                return true; // some
              case 5:
                return val; // find
              case 6:
                return index; // findIndex
              case 2:
                result.push(val); // filter
            } else if (IS_EVERY) return false; // every
        }
      }
    }return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;
  };
};

/***/ }),

/***/ "../node_modules/core-js/modules/_array-species-constructor.js":
/***/ (function(module, exports, __webpack_require__) {



var isObject = __webpack_require__("../node_modules/core-js/modules/_is-object.js");
var isArray = __webpack_require__("../node_modules/core-js/modules/_is-array.js");
var SPECIES = __webpack_require__("../node_modules/core-js/modules/_wks.js")('species');

module.exports = function (original) {
  var C;
  if (isArray(original)) {
    C = original.constructor;
    // cross-realm fallback
    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
    if (isObject(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  }return C === undefined ? Array : C;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_array-species-create.js":
/***/ (function(module, exports, __webpack_require__) {



// 9.4.2.3 ArraySpeciesCreate(originalArray, length)
var speciesConstructor = __webpack_require__("../node_modules/core-js/modules/_array-species-constructor.js");

module.exports = function (original, length) {
  return new (speciesConstructor(original))(length);
};

/***/ }),

/***/ "../node_modules/core-js/modules/_cof.js":
/***/ (function(module, exports) {



var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};

/***/ }),

/***/ "../node_modules/core-js/modules/_core.js":
/***/ (function(module, exports) {



var core = module.exports = { version: '2.6.10' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef

/***/ }),

/***/ "../node_modules/core-js/modules/_ctx.js":
/***/ (function(module, exports, __webpack_require__) {



// optional / simple context binding
var aFunction = __webpack_require__("../node_modules/core-js/modules/_a-function.js");
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1:
      return function (a) {
        return fn.call(that, a);
      };
    case 2:
      return function (a, b) {
        return fn.call(that, a, b);
      };
    case 3:
      return function (a, b, c) {
        return fn.call(that, a, b, c);
      };
  }
  return function () /* ...args */{
    return fn.apply(that, arguments);
  };
};

/***/ }),

/***/ "../node_modules/core-js/modules/_defined.js":
/***/ (function(module, exports) {



// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_descriptors.js":
/***/ (function(module, exports, __webpack_require__) {



// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__("../node_modules/core-js/modules/_fails.js")(function () {
  return Object.defineProperty({}, 'a', { get: function get() {
      return 7;
    } }).a != 7;
});

/***/ }),

/***/ "../node_modules/core-js/modules/_dom-create.js":
/***/ (function(module, exports, __webpack_require__) {



var isObject = __webpack_require__("../node_modules/core-js/modules/_is-object.js");
var document = __webpack_require__("../node_modules/core-js/modules/_global.js").document;
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};

/***/ }),

/***/ "../node_modules/core-js/modules/_enum-bug-keys.js":
/***/ (function(module, exports) {



// IE 8- don't enum bug keys
module.exports = 'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'.split(',');

/***/ }),

/***/ "../node_modules/core-js/modules/_export.js":
/***/ (function(module, exports, __webpack_require__) {



var global = __webpack_require__("../node_modules/core-js/modules/_global.js");
var core = __webpack_require__("../node_modules/core-js/modules/_core.js");
var hide = __webpack_require__("../node_modules/core-js/modules/_hide.js");
var redefine = __webpack_require__("../node_modules/core-js/modules/_redefine.js");
var ctx = __webpack_require__("../node_modules/core-js/modules/_ctx.js");
var PROTOTYPE = 'prototype';

var $export = function $export(type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] || (global[name] = {}) : (global[name] || {})[PROTOTYPE];
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE] || (exports[PROTOTYPE] = {});
  var key, own, out, exp;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    // export native or passed
    out = (own ? target : source)[key];
    // bind timers to global for call from export context
    exp = IS_BIND && own ? ctx(out, global) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // extend global
    if (target) redefine(target, key, out, type & $export.U);
    // export
    if (exports[key] != out) hide(exports, key, exp);
    if (IS_PROTO && expProto[key] != out) expProto[key] = out;
  }
};
global.core = core;
// type bitmap
$export.F = 1; // forced
$export.G = 2; // global
$export.S = 4; // static
$export.P = 8; // proto
$export.B = 16; // bind
$export.W = 32; // wrap
$export.U = 64; // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;

/***/ }),

/***/ "../node_modules/core-js/modules/_fails-is-regexp.js":
/***/ (function(module, exports, __webpack_require__) {



var MATCH = __webpack_require__("../node_modules/core-js/modules/_wks.js")('match');
module.exports = function (KEY) {
  var re = /./;
  try {
    '/./'[KEY](re);
  } catch (e) {
    try {
      re[MATCH] = false;
      return !'/./'[KEY](re);
    } catch (f) {/* empty */}
  }return true;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_fails.js":
/***/ (function(module, exports) {



module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};

/***/ }),

/***/ "../node_modules/core-js/modules/_function-to-string.js":
/***/ (function(module, exports, __webpack_require__) {



module.exports = __webpack_require__("../node_modules/core-js/modules/_shared.js")('native-function-to-string', Function.toString);

/***/ }),

/***/ "../node_modules/core-js/modules/_global.js":
/***/ (function(module, exports) {



// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math ? window : typeof self != 'undefined' && self.Math == Math ? self
// eslint-disable-next-line no-new-func
: Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef

/***/ }),

/***/ "../node_modules/core-js/modules/_has.js":
/***/ (function(module, exports) {



var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};

/***/ }),

/***/ "../node_modules/core-js/modules/_hide.js":
/***/ (function(module, exports, __webpack_require__) {



var dP = __webpack_require__("../node_modules/core-js/modules/_object-dp.js");
var createDesc = __webpack_require__("../node_modules/core-js/modules/_property-desc.js");
module.exports = __webpack_require__("../node_modules/core-js/modules/_descriptors.js") ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_ie8-dom-define.js":
/***/ (function(module, exports, __webpack_require__) {



module.exports = !__webpack_require__("../node_modules/core-js/modules/_descriptors.js") && !__webpack_require__("../node_modules/core-js/modules/_fails.js")(function () {
  return Object.defineProperty(__webpack_require__("../node_modules/core-js/modules/_dom-create.js")('div'), 'a', { get: function get() {
      return 7;
    } }).a != 7;
});

/***/ }),

/***/ "../node_modules/core-js/modules/_iobject.js":
/***/ (function(module, exports, __webpack_require__) {



// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__("../node_modules/core-js/modules/_cof.js");
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};

/***/ }),

/***/ "../node_modules/core-js/modules/_is-array.js":
/***/ (function(module, exports, __webpack_require__) {



// 7.2.2 IsArray(argument)
var cof = __webpack_require__("../node_modules/core-js/modules/_cof.js");
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};

/***/ }),

/***/ "../node_modules/core-js/modules/_is-object.js":
/***/ (function(module, exports) {



var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

module.exports = function (it) {
  return (typeof it === 'undefined' ? 'undefined' : _typeof(it)) === 'object' ? it !== null : typeof it === 'function';
};

/***/ }),

/***/ "../node_modules/core-js/modules/_is-regexp.js":
/***/ (function(module, exports, __webpack_require__) {



// 7.2.8 IsRegExp(argument)
var isObject = __webpack_require__("../node_modules/core-js/modules/_is-object.js");
var cof = __webpack_require__("../node_modules/core-js/modules/_cof.js");
var MATCH = __webpack_require__("../node_modules/core-js/modules/_wks.js")('match');
module.exports = function (it) {
  var isRegExp;
  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : cof(it) == 'RegExp');
};

/***/ }),

/***/ "../node_modules/core-js/modules/_library.js":
/***/ (function(module, exports) {



module.exports = false;

/***/ }),

/***/ "../node_modules/core-js/modules/_object-assign.js":
/***/ (function(module, exports, __webpack_require__) {


// 19.1.2.1 Object.assign(target, source, ...)

var DESCRIPTORS = __webpack_require__("../node_modules/core-js/modules/_descriptors.js");
var getKeys = __webpack_require__("../node_modules/core-js/modules/_object-keys.js");
var gOPS = __webpack_require__("../node_modules/core-js/modules/_object-gops.js");
var pIE = __webpack_require__("../node_modules/core-js/modules/_object-pie.js");
var toObject = __webpack_require__("../node_modules/core-js/modules/_to-object.js");
var IObject = __webpack_require__("../node_modules/core-js/modules/_iobject.js");
var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
module.exports = !$assign || __webpack_require__("../node_modules/core-js/modules/_fails.js")(function () {
  var A = {};
  var B = {};
  // eslint-disable-next-line no-undef
  var S = Symbol();
  var K = 'abcdefghijklmnopqrst';
  A[S] = 7;
  K.split('').forEach(function (k) {
    B[k] = k;
  });
  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
}) ? function assign(target, source) {
  // eslint-disable-line no-unused-vars
  var T = toObject(target);
  var aLen = arguments.length;
  var index = 1;
  var getSymbols = gOPS.f;
  var isEnum = pIE.f;
  while (aLen > index) {
    var S = IObject(arguments[index++]);
    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS || isEnum.call(S, key)) T[key] = S[key];
    }
  }return T;
} : $assign;

/***/ }),

/***/ "../node_modules/core-js/modules/_object-dp.js":
/***/ (function(module, exports, __webpack_require__) {



var anObject = __webpack_require__("../node_modules/core-js/modules/_an-object.js");
var IE8_DOM_DEFINE = __webpack_require__("../node_modules/core-js/modules/_ie8-dom-define.js");
var toPrimitive = __webpack_require__("../node_modules/core-js/modules/_to-primitive.js");
var dP = Object.defineProperty;

exports.f = __webpack_require__("../node_modules/core-js/modules/_descriptors.js") ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) {/* empty */}
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_object-gops.js":
/***/ (function(module, exports) {



exports.f = Object.getOwnPropertySymbols;

/***/ }),

/***/ "../node_modules/core-js/modules/_object-keys-internal.js":
/***/ (function(module, exports, __webpack_require__) {



var has = __webpack_require__("../node_modules/core-js/modules/_has.js");
var toIObject = __webpack_require__("../node_modules/core-js/modules/_to-iobject.js");
var arrayIndexOf = __webpack_require__("../node_modules/core-js/modules/_array-includes.js")(false);
var IE_PROTO = __webpack_require__("../node_modules/core-js/modules/_shared-key.js")('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) {
    if (key != IE_PROTO) has(O, key) && result.push(key);
  } // Don't enum bug & hidden keys
  while (names.length > i) {
    if (has(O, key = names[i++])) {
      ~arrayIndexOf(result, key) || result.push(key);
    }
  }return result;
};

/***/ }),

/***/ "../node_modules/core-js/modules/_object-keys.js":
/***/ (function(module, exports, __webpack_require__) {



// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__("../node_modules/core-js/modules/_object-keys-internal.js");
var enumBugKeys = __webpack_require__("../node_modules/core-js/modules/_enum-bug-keys.js");

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};

/***/ }),

/***/ "../node_modules/core-js/modules/_object-pie.js":
/***/ (function(module, exports) {



exports.f = {}.propertyIsEnumerable;

/***/ }),

/***/ "../node_modules/core-js/modules/_object-to-array.js":
/***/ (function(module, exports, __webpack_require__) {



var DESCRIPTORS = __webpack_require__("../node_modules/core-js/modules/_descriptors.js");
var getKeys = __webpack_require__("../node_modules/core-js/modules/_object-keys.js");
var toIObject = __webpack_require__("../node_modules/core-js/modules/_to-iobject.js");
var isEnum = __webpack_require__("../node_modules/core-js/modules/_object-pie.js").f;
module.exports = function (isEntries) {
  return function (it) {
    var O = toIObject(it);
    var keys = getKeys(O);
    var length = keys.length;
    var i = 0;
    var result = [];
    var key;
    while (length > i) {
      key = keys[i++];
      if (!DESCRIPTORS || isEnum.call(O, key)) {
        result.push(isEntries ? [key, O[key]] : O[key]);
      }
    }
    return result;
  };
};

/***/ }),

/***/ "../node_modules/core-js/modules/_property-desc.js":
/***/ (function(module, exports) {



module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

/***/ }),

/***/ "../node_modules/core-js/modules/_redefine.js":
/***/ (function(module, exports, __webpack_require__) {



var global = __webpack_require__("../node_modules/core-js/modules/_global.js");
var hide = __webpack_require__("../node_modules/core-js/modules/_hide.js");
var has = __webpack_require__("../node_modules/core-js/modules/_has.js");
var SRC = __webpack_require__("../node_modules/core-js/modules/_uid.js")('src');
var $toString = __webpack_require__("../node_modules/core-js/modules/_function-to-string.js");
var TO_STRING = 'toString';
var TPL = ('' + $toString).split(TO_STRING);

__webpack_require__("../node_modules/core-js/modules/_core.js").inspectSource = function (it) {
  return $toString.call(it);
};

(module.exports = function (O, key, val, safe) {
  var isFunction = typeof val == 'function';
  if (isFunction) has(val, 'name') || hide(val, 'name', key);
  if (O[key] === val) return;
  if (isFunction) has(val, SRC) || hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));
  if (O === global) {
    O[key] = val;
  } else if (!safe) {
    delete O[key];
    hide(O, key, val);
  } else if (O[key]) {
    O[key] = val;
  } else {
    hide(O, key, val);
  }
  // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
})(Function.prototype, TO_STRING, function toString() {
  return typeof this == 'function' && this[SRC] || $toString.call(this);
});

/***/ }),

/***/ "../node_modules/core-js/modules/_shared-key.js":
/***/ (function(module, exports, __webpack_require__) {



var shared = __webpack_require__("../node_modules/core-js/modules/_shared.js")('keys');
var uid = __webpack_require__("../node_modules/core-js/modules/_uid.js");
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};

/***/ }),

/***/ "../node_modules/core-js/modules/_shared.js":
/***/ (function(module, exports, __webpack_require__) {



var core = __webpack_require__("../node_modules/core-js/modules/_core.js");
var global = __webpack_require__("../node_modules/core-js/modules/_global.js");
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: core.version,
  mode: __webpack_require__("../node_modules/core-js/modules/_library.js") ? 'pure' : 'global',
  copyright: '© 2019 Denis Pushkarev (zloirock.ru)'
});

/***/ }),

/***/ "../node_modules/core-js/modules/_string-context.js":
/***/ (function(module, exports, __webpack_require__) {



// helper for String#{startsWith, endsWith, includes}
var isRegExp = __webpack_require__("../node_modules/core-js/modules/_is-regexp.js");
var defined = __webpack_require__("../node_modules/core-js/modules/_defined.js");

module.exports = function (that, searchString, NAME) {
  if (isRegExp(searchString)) throw TypeError('String#' + NAME + " doesn't accept regex!");
  return String(defined(that));
};

/***/ }),

/***/ "../node_modules/core-js/modules/_to-absolute-index.js":
/***/ (function(module, exports, __webpack_require__) {



var toInteger = __webpack_require__("../node_modules/core-js/modules/_to-integer.js");
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};

/***/ }),

/***/ "../node_modules/core-js/modules/_to-integer.js":
/***/ (function(module, exports) {



// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};

/***/ }),

/***/ "../node_modules/core-js/modules/_to-iobject.js":
/***/ (function(module, exports, __webpack_require__) {



// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__("../node_modules/core-js/modules/_iobject.js");
var defined = __webpack_require__("../node_modules/core-js/modules/_defined.js");
module.exports = function (it) {
  return IObject(defined(it));
};

/***/ }),

/***/ "../node_modules/core-js/modules/_to-length.js":
/***/ (function(module, exports, __webpack_require__) {



// 7.1.15 ToLength
var toInteger = __webpack_require__("../node_modules/core-js/modules/_to-integer.js");
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};

/***/ }),

/***/ "../node_modules/core-js/modules/_to-object.js":
/***/ (function(module, exports, __webpack_require__) {



// 7.1.13 ToObject(argument)
var defined = __webpack_require__("../node_modules/core-js/modules/_defined.js");
module.exports = function (it) {
  return Object(defined(it));
};

/***/ }),

/***/ "../node_modules/core-js/modules/_to-primitive.js":
/***/ (function(module, exports, __webpack_require__) {



// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__("../node_modules/core-js/modules/_is-object.js");
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};

/***/ }),

/***/ "../node_modules/core-js/modules/_uid.js":
/***/ (function(module, exports) {



var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};

/***/ }),

/***/ "../node_modules/core-js/modules/_wks.js":
/***/ (function(module, exports, __webpack_require__) {



var store = __webpack_require__("../node_modules/core-js/modules/_shared.js")('wks');
var uid = __webpack_require__("../node_modules/core-js/modules/_uid.js");
var _Symbol = __webpack_require__("../node_modules/core-js/modules/_global.js").Symbol;
var USE_SYMBOL = typeof _Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] = USE_SYMBOL && _Symbol[name] || (USE_SYMBOL ? _Symbol : uid)('Symbol.' + name));
};

$exports.store = store;

/***/ }),

/***/ "../node_modules/core-js/modules/es6.array.find.js":
/***/ (function(module, exports, __webpack_require__) {


// 22.1.3.8 Array.prototype.find(predicate, thisArg = undefined)

var $export = __webpack_require__("../node_modules/core-js/modules/_export.js");
var $find = __webpack_require__("../node_modules/core-js/modules/_array-methods.js")(5);
var KEY = 'find';
var forced = true;
// Shouldn't skip holes
if (KEY in []) Array(1)[KEY](function () {
  forced = false;
});
$export($export.P + $export.F * forced, 'Array', {
  find: function find(callbackfn /* , that = undefined */) {
    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});
__webpack_require__("../node_modules/core-js/modules/_add-to-unscopables.js")(KEY);

/***/ }),

/***/ "../node_modules/core-js/modules/es6.object.assign.js":
/***/ (function(module, exports, __webpack_require__) {



// 19.1.3.1 Object.assign(target, source)
var $export = __webpack_require__("../node_modules/core-js/modules/_export.js");

$export($export.S + $export.F, 'Object', { assign: __webpack_require__("../node_modules/core-js/modules/_object-assign.js") });

/***/ }),

/***/ "../node_modules/core-js/modules/es6.string.includes.js":
/***/ (function(module, exports, __webpack_require__) {

// 21.1.3.7 String.prototype.includes(searchString, position = 0)


var $export = __webpack_require__("../node_modules/core-js/modules/_export.js");
var context = __webpack_require__("../node_modules/core-js/modules/_string-context.js");
var INCLUDES = 'includes';

$export($export.P + $export.F * __webpack_require__("../node_modules/core-js/modules/_fails-is-regexp.js")(INCLUDES), 'String', {
  includes: function includes(searchString /* , position = 0 */) {
    return !!~context(this, searchString, INCLUDES).indexOf(searchString, arguments.length > 1 ? arguments[1] : undefined);
  }
});

/***/ }),

/***/ "../node_modules/core-js/modules/es7.array.includes.js":
/***/ (function(module, exports, __webpack_require__) {


// https://github.com/tc39/Array.prototype.includes

var $export = __webpack_require__("../node_modules/core-js/modules/_export.js");
var $includes = __webpack_require__("../node_modules/core-js/modules/_array-includes.js")(true);

$export($export.P, 'Array', {
  includes: function includes(el /* , fromIndex = 0 */) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
});

__webpack_require__("../node_modules/core-js/modules/_add-to-unscopables.js")('includes');

/***/ }),

/***/ "../node_modules/core-js/modules/es7.object.entries.js":
/***/ (function(module, exports, __webpack_require__) {



// https://github.com/tc39/proposal-object-values-entries
var $export = __webpack_require__("../node_modules/core-js/modules/_export.js");
var $entries = __webpack_require__("../node_modules/core-js/modules/_object-to-array.js")(true);

$export($export.S, 'Object', {
  entries: function entries(it) {
    return $entries(it);
  }
});

/***/ }),

/***/ "../node_modules/core-js/modules/es7.object.values.js":
/***/ (function(module, exports, __webpack_require__) {



// https://github.com/tc39/proposal-object-values-entries
var $export = __webpack_require__("../node_modules/core-js/modules/_export.js");
var $values = __webpack_require__("../node_modules/core-js/modules/_object-to-array.js")(false);

$export($export.S, 'Object', {
  values: function values(it) {
    return $values(it);
  }
});

/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-page-components/src/cart/installmentPlan/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/**\n * @fileOverview Variables contains variables\n * @name Variables\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Fonts */\n/* Colors */\n/**\n * @fileOverview Mixins contains mixins\n * @name Mixins\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n#installmentPlanTerms {\n  box-sizing: border-box;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#installmentPlanTerms .minicart {\n  background-color: #f1f4f5;\n  font-size: 13px;\n  color: #2c2e2f;\n  line-height: 16px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#installmentPlanTerms .minicart .installmentPlanDetails {\n  padding-left: 15px;\n  padding-right: 15px;\n  margin-top: 10px;\n  margin-bottom: 10px;\n}\n#installmentPlanTerms .minicart .installmentPlanDetails .heading {\n  font-weight: bold;\n  margin-bottom: 5px;\n  display: block;\n}\n#installmentPlanTerms .minicart .installmentPlanDetails .item-name {\n  font-weight: normal;\n  margin-bottom: 5px;\n  display: block;\n}\n#installmentPlanTerms .minicart .installmentPlanDetails .item-option {\n  font-weight: normal;\n  margin-bottom: 5px;\n  display: block;\n}\n#installmentPlanTerms .minicart .installmentTermsText {\n  padding-left: 15px;\n  padding-right: 15px;\n  margin-top: 10px;\n  margin-bottom: 10px;\n}\n#installmentPlanTerms .minicart .installmentTermsText .heading {\n  font-weight: bold;\n  margin-bottom: 5px;\n  display: block;\n}\n#installmentPlanTerms .minicart .installmentTermsText .bill-cycle {\n  width: 100%;\n  box-sizing: border-box;\n  white-space: nowrap;\n}\n#installmentPlanTerms .minicart .installmentTermsText .bill-cycle-term {\n  display: inline-block;\n  width: 50%;\n  box-sizing: border-box;\n  text-align: left;\n}\n#installmentPlanTerms .minicart .installmentTermsText .bill-cycle-amount {\n  display: inline-block;\n  width: 50%;\n  box-sizing: border-box;\n  text-align: right;\n}\n#installmentPlanTerms .minicart .installmentTermsText .term-line {\n  font-weight: normal;\n  margin-bottom: 5px;\n}\n#installmentPlanTerms .minicart .installmentTermsText .amount-line {\n  font-weight: normal;\n  margin-bottom: 5px;\n}\n#installmentPlanTerms .minicart .installmentTermsText .display-total {\n  width: 100%;\n  box-sizing: border-box;\n  white-space: nowrap;\n}\n#installmentPlanTerms .minicart .installmentPlanLegal {\n  padding-left: 15px;\n  padding-right: 15px;\n  margin-top: 10px;\n  margin-bottom: 10px;\n}\n#installmentPlanTerms .minicart .installmentPlanLegal .content {\n  text-align: left;\n}\n#installmentPlanTerms .minicart .installmentPlanLegal .legal-text {\n  display: block;\n  font-weight: normal;\n  margin-bottom: 15px;\n}\n#installmentPlanTerms .minicart .installmentPlanLegal .legal-info {\n  display: block;\n  font-weight: normal;\n  margin-bottom: 5px;\n}\n#installmentPlanTerms .minicart .firstAmount {\n  height: 31px;\n  padding-left: 15px;\n  padding-right: 15px;\n  border-top: 1px solid #ccc;\n  font-weight: bold;\n  vertical-align: middle;\n  padding-top: 10px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#installmentPlanTerms .minicart .firstAmount .heading {\n  display: inline-block;\n  width: 50%;\n  float: left;\n  font-size: 13px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#installmentPlanTerms .minicart .firstAmount .content {\n  display: inline-block;\n  width: 50%;\n  float: right;\n  text-align: right;\n  font-size: 13px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#installmentPlanTerms .minicart .firstAmount .currencyCode {\n  font-size: 10px;\n}\n*[dir=\"rtl\"] #installmentPlanTerms {\n  text-align: right;\n}\n*[dir=\"rtl\"] #installmentPlanTerms .heading {\n  text-align: right;\n}\n*[dir=\"rtl\"] #installmentPlanTerms .content {\n  text-align: right;\n}\n*[dir=\"rtl\"] #installmentPlanTerms .firstAmount .heading {\n  float: right;\n}\n*[dir=\"rtl\"] #installmentPlanTerms .firstAmount .content {\n  float: left;\n  text-align: left;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-page-components/src/cart/subscription/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/**\n * @fileOverview Variables contains variables\n * @name Variables\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Fonts */\n/* Colors */\n/**\n * @fileOverview Mixins contains mixins\n * @name Mixins\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n#subscriptionTerms {\n  box-sizing: border-box;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart {\n  background-color: #f1f4f5;\n  font-size: 13px;\n  color: #2c2e2f;\n  line-height: 16px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart .subscriptionDetails {\n  padding-left: 15px;\n  padding-right: 15px;\n  margin-top: 10px;\n  margin-bottom: 10px;\n}\n#subscriptionTerms .minicart .subscriptionDetails .heading {\n  font-weight: bold;\n  margin-bottom: 5px;\n  display: block;\n}\n#subscriptionTerms .minicart .subscriptionDetails .item-name {\n  font-weight: normal;\n  margin-bottom: 5px;\n  display: block;\n}\n#subscriptionTerms .minicart .subscriptionDetails .item-option {\n  font-weight: normal;\n  margin-bottom: 5px;\n  display: block;\n}\n#subscriptionTerms .minicart .subs-terms-text {\n  padding-left: 15px;\n  padding-right: 15px;\n  margin-top: 10px;\n  margin-bottom: 10px;\n}\n#subscriptionTerms .minicart .subs-terms-text .heading {\n  font-weight: bold;\n  margin-bottom: 5px;\n  display: block;\n}\n#subscriptionTerms .minicart .subs-terms-text .term-line {\n  display: block;\n  font-weight: normal;\n  margin-bottom: 5px;\n}\n#subscriptionTerms .minicart .firstAmount {\n  height: 31px;\n  padding-left: 15px;\n  padding-right: 15px;\n  border-top: 1px solid #ccc;\n  font-weight: bold;\n  vertical-align: middle;\n  padding-top: 10px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart .firstAmount .heading {\n  display: inline-block;\n  width: 50%;\n  float: left;\n  font-size: 13px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart .firstAmount .content {\n  display: inline-block;\n  width: 50%;\n  float: right;\n  text-align: right;\n  font-size: 13px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart .firstAmount .currencyCode {\n  font-size: 10px;\n}\n*[dir=\"rtl\"] #subscriptionTerms {\n  text-align: right;\n}\n*[dir=\"rtl\"] #subscriptionTerms .heading {\n  text-align: right;\n}\n*[dir=\"rtl\"] #subscriptionTerms .content {\n  text-align: right;\n}\n*[dir=\"rtl\"] #subscriptionTerms .firstAmount .heading {\n  float: right;\n}\n*[dir=\"rtl\"] #subscriptionTerms .firstAmount .content {\n  float: left;\n  text-align: left;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-page-components/src/cart/subscriptionsV1/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/**\n * @fileOverview Variables contains variables\n * @name Variables\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Fonts */\n/* Colors */\n/**\n * @fileOverview Mixins contains mixins\n * @name Mixins\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n#subscriptionTerms {\n  box-sizing: border-box;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart {\n  background-color: #f1f4f5;\n  font-size: 13px;\n  color: #2c2e2f;\n  line-height: 16px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart .subscriptionDetails {\n  padding-left: 15px;\n  padding-right: 15px;\n  margin-top: 10px;\n  margin-bottom: 10px;\n}\n#subscriptionTerms .minicart .subscriptionDetails .heading {\n  font-weight: bold;\n  margin-bottom: 5px;\n  display: block;\n}\n#subscriptionTerms .minicart .subscriptionDetails .item-name {\n  font-weight: normal;\n  margin-bottom: 5px;\n  display: block;\n}\n#subscriptionTerms .minicart .subscriptionDetails .item-option {\n  font-weight: normal;\n  margin-bottom: 5px;\n  display: block;\n}\n#subscriptionTerms .minicart .subs-terms-text {\n  padding-left: 15px;\n  padding-right: 15px;\n  margin-top: 10px;\n  margin-bottom: 10px;\n}\n#subscriptionTerms .minicart .subs-terms-text .heading {\n  font-weight: bold;\n  margin-bottom: 5px;\n  display: block;\n}\n#subscriptionTerms .minicart .subs-terms-text .term-line {\n  display: block;\n  font-weight: normal;\n  margin-bottom: 5px;\n}\n#subscriptionTerms .minicart .firstAmount,\n#subscriptionTerms .landing-page-item-details-container {\n  height: 31px;\n  padding-left: 15px;\n  padding-right: 15px;\n  border-top: 1px solid #ccc;\n  font-weight: bold;\n  vertical-align: middle;\n  padding-top: 10px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart .firstAmount .heading {\n  display: inline-block;\n  width: 50%;\n  float: left;\n  font-size: 13px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart .firstAmount .content {\n  display: inline-block;\n  width: 50%;\n  float: right;\n  text-align: right;\n  font-size: 13px;\n  -webkit-border-radius: 0 0 5px 5px;\n  -moz-border-radius: 0 0 5px 5px;\n  border-radius: 0 0 5px 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n#subscriptionTerms .minicart .firstAmount .currencyCode {\n  font-size: 10px;\n}\n*[dir=\"rtl\"] #subscriptionTerms {\n  text-align: right;\n}\n*[dir=\"rtl\"] #subscriptionTerms .heading {\n  text-align: right;\n}\n*[dir=\"rtl\"] #subscriptionTerms .content {\n  text-align: right;\n}\n*[dir=\"rtl\"] #subscriptionTerms .firstAmount .heading {\n  float: right;\n}\n*[dir=\"rtl\"] #subscriptionTerms .firstAmount .content {\n  float: left;\n  text-align: left;\n}\n#subscriptionTerms .minicart .subscriptionDetails .heading {\n  margin-bottom: 10px;\n}\n#subscriptionTerms .start-date {\n  border: 1px solid #8db7d7;\n  border-radius: 5px;\n  padding: 5px 5px 5px 10px;\n  background: #f4f8fb;\n  margin-top: 10px;\n  display: inline-block;\n  min-width: 150px;\n}\n#subscriptionTerms .subscription-terms {\n  padding-top: 5px;\n}\n#subscriptionTerms .landing-page-item-details-container {\n  font-weight: normal;\n  height: auto;\n}\n#subscriptionTerms .item-details-row {\n  box-sizing: border-box;\n  margin-bottom: 10px;\n  width: 100%;\n  min-width: 250px;\n  display: table;\n}\n#subscriptionTerms .item-details-row .item-details-left {\n  display: table-cell;\n  width: 75%;\n}\n#subscriptionTerms .item-details-row .item-details-right {\n  display: table-cell;\n  text-align: right;\n  width: 25%;\n  margin-left: auto;\n  margin-right: 0;\n  min-width: 100px;\n}\n#subscriptionTerms .tax-indicator-after:after,\n#subscriptionTerms .tax-indicator-before:before {\n  vertical-align: top;\n  content: \"*\";\n}\n#subscriptionTerms .margin-top-30 {\n  margin-top: 30px;\n}\n#subscriptionTerms .label-color {\n  color: #919191;\n}\n#subscriptionTerms .no-margin-bottom {\n  margin-bottom: 0;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-page-components/src/footer/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, ".popupModalContainer {\n  position: relative;\n}\n.popupModal {\n  width: 100%;\n  height: 100%;\n  position: fixed;\n  top: 0;\n  left: 0;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-page-components/src/gdprCookieBanner/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/* For GDPR banner component */\nbody.gdprCookieBanner-acceptedAll {\n  height: auto;\n  margin-bottom: 14em;\n}\n@media only screen and (max-width: 500px) {\n  /* For mobile phones: */\n  body.gdprCookieBanner-acceptedAll {\n    margin-bottom: 18em;\n  }\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-page-components/src/header/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, ".paypalHeader .languageToggleDisplay {\n  position: relative;\n  bottom: 0;\n  clear: left;\n  right: 0;\n  top: 20px;\n  margin-bottom: 20px;\n}\n.paypalHeader #langDropdownBlock {\n  right: auto;\n}\n.paypalHeader .messengerLogo {\n  margin-left: 25%;\n  padding-top: 20px;\n}\n.paypalHeader .venmoLogo {\n  position: relative;\n  width: 100px;\n  float: left;\n  height: 20px;\n  margin-top: 0px;\n  background-image: url(https://www.paypalobjects.com/images/checkout/venmo/venmo-logo-blue.png);\n  background-repeat: no-repeat;\n  background-size: 100px 20px;\n}\n.facebookPayPalHeader {\n  padding-top: 20px;\n  text-align: center;\n}\n.facebookPayPalHeader-logo {\n  width: auto;\n  height: 30px;\n  display: inline-block;\n  vertical-align: middle;\n}\n.facebookPayPalHeader-separator {\n  margin: 0 20px 0 14px;\n  font-size: 26px;\n  border-right: 1px solid #dbdbdb;\n  vertical-align: middle;\n}\n#mobileMerchantHeader {\n  display: none;\n}\n@media (max-width: 41.3125em) {\n  .paypalHeaderWrapper.langDropdown {\n    margin-bottom: 30px;\n  }\n  .paypalHeader .venmoLogo {\n    position: relative;\n    width: 100px;\n    float: left;\n    height: 20px;\n    margin-top: 30px;\n    background-image: url(https://www.paypalobjects.com/images/checkout/venmo/venmo-logo-blue.png);\n    background-repeat: no-repeat;\n    background-size: 100px 20px;\n  }\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-ui-components/src/banner/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/**\n* @fileOverview Base contains variables, mixins, reset, baseline, grid, and utilities\n* @name Base\n* @author hdoan\n* @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n*/\n/**\n * @fileOverview Variables contains variables\n * @name Variables\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Fonts */\n/* Colors */\n/**\n * @fileOverview Mixins contains mixins\n * @name Mixins\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/**\n * @fileOverview Reset contains reset and baseline styles\n * @name Reset\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Reset ====================================== */\nhtml,\nbody,\ndiv,\ndl,\ndt,\ndd,\nul,\nol,\nli,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\npre,\ncode,\nform,\nfieldset,\nlegend,\ninput,\ntextarea,\np,\nblockquote,\nth,\ntd {\n  margin: 0;\n  padding: 0;\n}\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\nfieldset,\nimg {\n  border: 0;\n}\naddress,\ncaption,\ncite,\ncode,\ndfn,\nem,\nstrong,\nth,\nvar {\n  font-style: normal;\n  font-weight: normal;\n}\nol,\nul {\n  list-style: none;\n}\ncaption,\nth {\n  text-align: left;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6 {\n  font-size: 100%;\n  font-weight: normal;\n}\nq:before,\nq:after {\n  content: \"\";\n}\nabbr,\nacronym {\n  border: 0;\n  font-variant: normal;\n}\n/* to preserve line-height and selector appearance */\nsup {\n  vertical-align: text-top;\n}\nsub {\n  vertical-align: text-bottom;\n}\ninput,\ntextarea,\nselect {\n  font-family: inherit;\n  font-size: inherit;\n  font-weight: inherit;\n}\n/*to enable resizing for IE*/\ninput,\ntextarea,\nselect {\n  *font-size: 100%;\n}\n/*because legend doesn't inherit in IE */\nlegend {\n  color: #000;\n}\n/* Start of base-lining, some from YUI's CSS Foundation ==================== */\nbody {\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 95%;\n  /* Base font-size is 15px */\n  color: #2c2e2f;\n  line-height: 1.35em;\n}\nh1 {\n  /*18px via YUI Fonts CSS foundation*/\n  font-size: 138.5%;\n}\nh2 {\n  /*16px via YUI Fonts CSS foundation*/\n  font-size: 123.1%;\n}\nh3 {\n  /*14px via YUI Fonts CSS foundation*/\n  font-size: 108%;\n}\nh1,\nh2,\nh3 {\n  /* top & bottom margin based on font size */\n  margin: 1em 0;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\nstrong {\n  /*bringing boldness back to headers and the strong element*/\n  font-weight: bold;\n}\na {\n  color: #0070BA;\n}\nabbr,\nacronym {\n  /*indicating to users that more info is available */\n  border-bottom: 1px dotted #000;\n  cursor: help;\n}\nem {\n  /*bringing italics back to the em element*/\n  font-style: italic;\n}\nblockquote,\nul,\nol,\ndl {\n  /*giving blockquotes and lists room to breath*/\n  margin: 1em;\n}\nol,\nul,\ndl {\n  /*bringing lists on to the page with breathing room */\n  margin-left: 2em;\n}\nol {\n  /*giving OL's LIs generated numbers*/\n  list-style: decimal outside;\n}\nul {\n  /*giving UL's LIs generated disc markers*/\n  list-style: disc outside;\n}\ndl dd {\n  /*providing spacing for definition terms*/\n  margin-left: 1em;\n}\nth,\ntd {\n  /*borders and padding to make the table readable*/\n  border: 1px solid #000;\n  padding: .5em;\n}\nth {\n  /*distinguishing table headers from data cells*/\n  font-weight: bold;\n  text-align: center;\n}\ninput {\n  margin-bottom: 10px;\n}\ncaption {\n  /*coordinated margin to match cell's padding*/\n  margin-bottom: .5em;\n  /*centered so it doesn't blend in to other content*/\n  text-align: center;\n}\np,\nfieldset,\ntable,\npre,\nlegend {\n  /*so things don't run into each other*/\n  margin-bottom: 1em;\n}\n/* setting a consistent width, 160px;\n   control of type=file still not possible */\ninput[type=text],\ninput[type=password],\ntextarea {\n  width: 12.25em;\n  *width: 11.9em;\n}\n/**\n * @fileOverview Grid contains grid rules\n * @name Grid\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n.row-fluid {\n  width: 100%;\n  *zoom: 1;\n}\n.row-fluid:before,\n.row-fluid:after {\n  display: table;\n  content: \"\";\n}\n.row-fluid:after {\n  clear: both;\n}\n.row-fluid > [class*=\"span\"] {\n  float: left;\n  margin-left: 4.127659574%;\n}\n.row-fluid > [class*=\"span\"]:first-child {\n  margin-left: 0;\n}\n.row-fluid > .span24 {\n  width: 99.999999978%;\n}\n.row-fluid > .span23 {\n  width: 95.74468083%;\n}\n.row-fluid > .span22 {\n  width: 91.48936168200001%;\n}\n.row-fluid > .span21 {\n  width: 87.234042534%;\n}\n.row-fluid > .span20 {\n  width: 82.97872338599998%;\n}\n.row-fluid > .span19 {\n  width: 78.723404238%;\n}\n.row-fluid > .span18 {\n  width: 74.46808508999999%;\n}\n.row-fluid > .span17 {\n  width: 70.212765942%;\n}\n.row-fluid > .span16 {\n  width: 65.95744679399999%;\n}\n.row-fluid > .span15 {\n  width: 61.702127646%;\n}\n.row-fluid > .span14 {\n  width: 54.446808497999996%;\n}\n.row-fluid > .span13 {\n  width: 53.19148935%;\n}\n.row-fluid > .span12 {\n  width: 48.936170202%;\n}\n.row-fluid > .span11 {\n  width: 44.680851054%;\n}\n.row-fluid > .span10 {\n  width: 40.425531905999996%;\n}\n.row-fluid > .span9 {\n  width: 36.170212758%;\n}\n.row-fluid > .span8 {\n  width: 31.91489361%;\n}\n.row-fluid > .span7 {\n  width: 27.659574462000002%;\n}\n.row-fluid > .span6 {\n  width: 23.404255313999997%;\n}\n.row-fluid > .span5 {\n  width: 19.148936166%;\n}\n.row-fluid > .span4 {\n  width: 14.893617018%;\n}\n.row-fluid > .span3 {\n  width: 10.638297869999999%;\n}\n.row-fluid > .span2 {\n  width: 6.382978722%;\n}\n.row-fluid > .span1 {\n  width: 2.127659574%;\n}\n.container-fluid {\n  padding-left: 20px;\n  padding-right: 20px;\n  *zoom: 1;\n}\n.container-fluid:before,\n.container-fluid:after {\n  display: table;\n  content: \"\";\n}\n.container-fluid:after {\n  clear: both;\n}\n.mt10 {\n  margin-top: 10px;\n}\n.mt15 {\n  margin-top: 10px;\n}\n.pt10 {\n  padding-top: 10px;\n}\n.pt15 {\n  padding-top: 15px;\n}\n.mb10 {\n  margin-bottom: 10px;\n}\n.mb15 {\n  margin-bottom: 15px;\n}\n.pb10 {\n  padding-bottom: 10px;\n}\n.pb15 {\n  padding-bottom: 15px;\n}\n.ml10 {\n  margin-left: 10px;\n}\n.ml15 {\n  margin-left: 15px;\n}\n.pl10 {\n  padding-left: 10px;\n}\n.pl15 {\n  padding-left: 15px;\n}\n.mr10 {\n  margin-right: 10px;\n}\n.mr15 {\n  margin-right: 15px;\n}\n.pr10 {\n  padding-right: 10px;\n}\n.pr15 {\n  padding-right: 15px;\n}\n/* Button styles */\n.btn {\n  height: 44px;\n  margin-bottom: 0;\n  border-style: solid;\n  border-width: 1px;\n  border-color: #0070BA;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  *margin-left: .3em;\n  display: inline-block;\n  /* IE7 inline-block hack */\n  *display: inline;\n  *zoom: 1;\n  background-color: #0070BA;\n  -webkit-transition: background-color 0.4s ease-out 0s;\n  -moz-transition: background-color 0.4s ease-out 0s;\n  -ms-transition: background-color 0.4s ease-out 0s;\n  -o-transition: background-color 0.4s ease-out 0s;\n  transition: background-color 0.4s ease-out 0s;\n  font-size: 1.0em;\n  font-weight: bold;\n  line-height: 42px;\n  color: #fff;\n  text-align: center;\n  vertical-align: middle;\n  cursor: pointer;\n  outline: none;\n  -webkit-font-smoothing: antialiased;\n}\n.btn .btn-secondary {\n  -webkit-font-smoothing: auto;\n}\n.btn:hover,\n.btn:focus {\n  background-color: #005EA6;\n}\n.btn:focus {\n  text-decoration: underline;\n}\n.btn.active,\n.btn:active {\n  background-color: #005EA6;\n  outline: 0;\n}\n.btn.disabled,\n.btn[disabled] {\n  background-color: #B2D9EA;\n  border-color: #B2D9EA;\n  cursor: default;\n}\n.btn.firstHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n.btn.secondHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\na.btn:focus,\na.btn:hover {\n  color: #fff;\n}\n.btn:first-child {\n  *margin-left: 0;\n}\n.btn-large {\n  padding: 8px 15px;\n  font-size: 18px;\n  line-height: normal;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n}\n.btn-small {\n  padding: 5px 9px;\n  font-size: 11px;\n  line-height: 16px;\n}\n.btn-mini {\n  padding: 2px 6px;\n  font-size: 11px;\n  line-height: 14px;\n}\n.btn-secondary {\n  border-style: solid;\n  border-color: #E1E7Eb;\n  color: #393F44;\n  background-color: #E1E7Eb;\n}\n.btn-secondary:hover {\n  color: #393F44;\n  border-color: #EDF2F5;\n  background-color: #EDF2F5;\n  text-decoration: none;\n}\n.btn-secondary:active,\n.btn-secondary:focus {\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n  text-decoration: underline;\n}\n.btn-secondary.disabled,\n.btn-secondary[disabled] {\n  color: #393F55;\n}\na.btn-secondary:hover,\na.btn-secondary:focus,\na.btn-secondary:active {\n  color: #393F44;\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n}\na.btn-secondary.disabled,\na.btn-secondary[disabled] {\n  color: #393F55;\n  background-color: #E7EDF0;\n}\nbutton.btn,\ninput[type=\"submit\"].btn {\n  *padding-top: 2px;\n  *padding-bottom: 2px;\n}\nbutton.btn::-moz-focus-inner,\ninput[type=\"submit\"].btn::-moz-focus-inner {\n  padding: 0;\n  border: 0;\n}\nbutton.btn.btn-large,\ninput[type=\"submit\"].btn.btn-large {\n  *padding-top: 7px;\n  *padding-bottom: 7px;\n}\nbutton.btn.btn-small,\ninput[type=\"submit\"].btn.btn-small {\n  *padding-top: 3px;\n  *padding-bottom: 3px;\n}\nbutton.btn.btn-mini,\ninput[type=\"submit\"].btn.btn-mini {\n  *padding-top: 1px;\n  *padding-bottom: 1px;\n}\nsection .buttons #backButton,\n#largeScreenAccountCreation .buttons #backButton {\n  width: 30%;\n}\nsection .buttons #proceedButton,\n#largeScreenAccountCreation .buttons #proceedButton {\n  width: 65%;\n}\nsection .buttons #proceedButton.full,\n#largeScreenAccountCreation .buttons #proceedButton.full {\n  width: 100%;\n}\nsection .buttons #proceedButton-venmoBA,\n#largeScreenAccountCreation .buttons #proceedButton-venmoBA {\n  width: 100%;\n}\n/* mixin for Select element - Dropdowns\n    *\n    * We style native select element on web and it uses native element on other devices\n    * HTML Format to use for select element:\n    *   <div class=\"dropdown\">\n    *           <label for=\"selectID\" class=\"accessAid\" id=\"forSelectID\">Select Label</label>\n    *           <select id=\"selectID\" name=\"selectID\">\n    *               <option value=\"\">Option 1</option>\n    *               <option value=\"2\">Option 2</option>\n    *           </select>\n    *       </div>\n    *\n    * @param width - defines the width of the select dropdown on form\n*/\n.custom-select-container {\n  position: relative;\n}\n/* Set the dimensions of the replaced select element and make it transparent. */\nselect.replaced {\n  position: relative;\n  z-index: 8;\n  width: 100%;\n  height: 44px;\n  border: 0;\n  line-height: 2;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  /* Move to IE-speci    fic CSS file if you want to. */\n}\n.custom-select {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 1;\n  display: block;\n  width: 100%;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.custom-select > span {\n  display: block;\n  padding: 7px 30px 7px 13px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: right -7px top -1178px;\n  color: #000;\n  line-height: 28px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .custom-select > span {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.disabled .custom-select > span {\n  background-position: right -7px top -6990px;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat right 10px center;\n  background-size: 16px;\n  color: #c72e2e;\n  border: 1px solid #c72e2e;\n}\n.custom-select span span {\n  display: block;\n  overflow: hidden;\n  height: 28px;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-size: 1em;\n}\n.custom-select.active > span {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n#task .custom-select {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.mobile .dob label {\n  position: static;\n  top: 0;\n  left: 0;\n}\ninput[type=date] {\n  padding: 5px 38px 3px 6px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  color: #333;\n  background-size: 24px;\n  background: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_cart_icons.png\") no-repeat 100% 61%;\n}\ninput[type=date]:focus {\n  border-color: #3399ff;\n}\n.showDropdopwnLabels .labelText {\n  float: left;\n  color: #aaa;\n}\n.showDropdopwnLabels .valueText {\n  float: right;\n  min-width: 90px;\n}\n@media (min-width: 0) and (max-width: 40em) {\n  .showDropdopwnLabels .labelText {\n    display: none;\n  }\n  .showDropdopwnLabels .valueText {\n    float: none;\n    min-width: 0;\n  }\n}\n.multiline-select-container {\n  outline: 0 none;\n}\n.multiline-select-container:active .innerContainer,\n.multiline-select-container:focus .innerContainer {\n  border-color: #009cde;\n}\n.multiline-select-container.open:active .innerContainer,\n.multiline-select-container.open:focus .innerContainer {\n  border-color: #ccd0d4;\n}\n.multiline-select-container option,\n.multiline-select-container select {\n  position: absolute !important;\n  left: -9999px;\n}\n.multiline-select-container .custom-select {\n  position: relative;\n}\n.multiline-select-container .custom-select span span {\n  height: auto;\n  white-space: initial;\n}\n.multiline-select-container .custom-select > span {\n  background: none;\n}\n.multiline-select-container.open .custom-select > span {\n  border-radius: 5px 5px 0 0;\n  border-bottom-color: #eee;\n}\n.multiline-select-container .arrow {\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_forms.png\");\n  background-position: left -8px top -1198px;\n  background-repeat: no-repeat;\n  height: 10px;\n  position: absolute;\n  width: 14px;\n  top: 40%;\n  right: 12px;\n}\n.validated .multiline-select-container .ng-invalid + .custom-select .arrow,\n.backendError .multiline-select-container .ng-invalid + .custom-select .arrow {\n  display: none;\n}\n.multiline-select-list {\n  position: absolute;\n  list-style: none;\n  margin: 0;\n  background-color: #fff;\n  z-index: 1000;\n  border-radius: 0 0 5px 5px;\n  border-bottom: 1px solid #ccd0d4;\n  max-height: 200px;\n  overflow: auto;\n  box-shadow: #ccc 0px -1px 1px 0px;\n}\n.multiline-select-list li {\n  padding: 10px;\n  border: 1px solid;\n  border-color: #eee #ccd0d4;\n  border-top: 0 none;\n  cursor: pointer;\n  line-height: 1.35em;\n  vertical-align: middle;\n}\n.multiline-select-list li:hover,\n.multiline-select-list li:focus,\n.multiline-select-list li:active {\n  background-color: #e5f5fc;\n  outline: 0 none;\n}\n.multiline-select-list li:first-of-type {\n  border-top: 0 none;\n}\n.multiline-select-list li:last-of-type {\n  border-bottom: 0 none;\n}\n.multiline-select-list:hover li:focus {\n  background-color: #fff;\n}\n.multiline-select-list:hover li:focus:hover,\n.multiline-select-list:hover li:focus:active {\n  background-color: #e5f5fc;\n}\n.accessAid,\n#midflash {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n/*\n * HTML elements\n */\nbody {\n  -webkit-tap-highlight-color: transparent;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  background-color: #fff;\n}\na {\n  text-decoration: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0.2);\n}\na:hover,\na:focus {\n  color: #005EA6;\n  text-decoration: underline;\n  outline: none;\n}\na.dashed {\n  text-decoration: none;\n  border-bottom: 1px #0070BA dashed;\n  font-size: 0.9em;\n}\n*[tabindex=\"-1\"] {\n  outline: none;\n}\nem {\n  font-style: normal;\n  font-weight: bold;\n}\nfieldset {\n  margin: 0;\n  padding: 0;\n  border: 0;\n}\nfieldset legend {\n  padding-bottom: 0.5em;\n  font-size: 1.5em;\n}\nsection:focus {\n  outline: none;\n}\n.show-section {\n  display: block;\n}\nhr.faded {\n  width: 100%;\n  height: 1px;\n  margin: 10px 0;\n  border: 0;\n  background-image: -webkit-gradient(linear, left top, right top, color-stop(0, transparent), color-stop(0.5, rgba(0, 0, 0, 0.3)), color-stop(1, transparent));\n  background-image: -webkit-linear-gradient(left, transparent, rgba(0, 0, 0, 0.3), transparent);\n  background-image: -moz-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -ms-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -o-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n}\n.alpha {\n  font-size: 1.50em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin: 0.5em 0;\n  line-height: 1.154em;\n}\n#loginSection h1.alpha {\n  max-width: 240px;\n}\n.asideAlpha {\n  font-size: 1.44em;\n}\naside .aside .header.noButtons .walletHeading {\n  text-align: center;\n  line-height: 1.05em;\n}\n.beta {\n  font-size: 1.54em;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.gamma {\n  font-size: 1.30em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.zeta {\n  font-size: 1.25em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.delta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin-bottom: 12px;\n  font-weight: normal;\n}\n.vprop-header {\n  font-size: 1.60em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin: 10px 0;\n  font-weight: lighter;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  line-height: 1.2em;\n}\n.vprop-content {\n  font-size: 1.0em;\n  font-family: \"HelveticaNeue\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.vprop-image {\n  margin-top: 25px;\n}\n.eta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.theta {\n  font-size: 1.0em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.value-prop-title {\n  color: #2c2e2f;\n  font-size: 24px;\n  font-weight: lighter;\n  margin: 10px 0;\n}\n.props {\n  padding: 0 0 0 5px;\n  clear: both;\n  text-align: center;\n}\n.props p,\n.props li {\n  line-height: 1.154em;\n  font-size: 0.9em;\n  font-weight: normal;\n  line-height: 1.2em;\n  margin: 5px 0;\n}\n.secondary {\n  color: #6C7378;\n  font-size: 0.85em;\n}\n.legal {\n  color: #6C7378;\n  font-size: 0.75em;\n  line-height: 1.154em;\n}\n.legal a {\n  font-weight: bold;\n}\n.mu {\n  font-size: 2.46em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-weight: normal;\n  text-shadow: 0 1px 0 #fff;\n  color: #0079c1;\n}\n/* Single property classes - 0 value or common attributes */\n.noHead {\n  margin-top: 0;\n}\n.noBottom {\n  margin-bottom: 0;\n}\n.showTray #task {\n  overflow: hidden;\n  margin-left: 0;\n}\n.hide,\n#spinner {\n  display: none;\n}\n.clearfix,\nhtml[xmlns] .clearfix,\n.loading #spinner,\n.media .img img {\n  display: block;\n}\n#billingToggleLink {\n  display: inline-block;\n}\n.left {\n  float: left;\n}\n.right {\n  float: right;\n}\n.center {\n  text-align: center;\n}\n/* End single property classes */\n.outerWrapper {\n  position: relative;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-color: #ffffff;\n}\nheader {\n  z-index: 2;\n}\nhtml.framed,\n.framed #wrapper {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\nhtml.framed .trayOpen #main {\n  height: 585px;\n}\nhtml.framed .trayOpen .asideContent {\n  height: 495px;\n}\nbody > iframe,\nbody > img {\n  display: none;\n}\n#wrapper {\n  margin: 0 auto;\n  max-width: 780px;\n  border: 1px solid #e3e3e3;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  overflow-y: visible;\n  outline: none;\n  background-color: #fff;\n}\n#wrapper #header {\n  -webkit-border-radius: 5px 5px 0 0;\n  -moz-border-radius: 5px 5px 0 0;\n  border-radius: 5px 5px 0 0;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  width: 100%;\n  background-color: #fff;\n  z-index: 4;\n  -webkit-box-shadow: 0 0 3px 0;\n  -moz-box-shadow: 0 0 3px 0;\n  box-shadow: 0 0 3px 0;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n#contents {\n  position: relative;\n  z-index: 1;\n}\n.active #wrapper {\n  visibility: visible;\n  -webkit-animation-duration: 400ms;\n  -webkit-animation-timing-function: ease;\n  -webkit-animation-name: slideUp;\n}\n#logo {\n  margin: 22px 0 0 20px;\n}\n.container {\n  clear: both;\n  padding: 20px;\n}\n.containerNoHead {\n  padding-top: 0;\n}\n.noPaddingBottom {\n  padding-bottom: 0;\n}\n.noPaddingTop {\n  padding-top: 0;\n}\n.subContainer {\n  border-top: 1px solid #e3e3e3;\n  padding: 20px 0 20px;\n  position: relative;\n}\n#proceedButton {\n  width: 46.4%;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\n#proceedButton.full {\n  width: 100%;\n}\n#proceedButton:focus {\n  color: #fff;\n}\n#backButton {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n#backButton:hover,\n#backButton:focus {\n  color: #2c2e2f;\n}\n.middleName {\n  display: none;\n  float: right;\n}\n.h2,\nh2 {\n  font-size: 1.2em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  margin-top: 0;\n  font-weight: normal;\n  color: #0666B3;\n}\n.clearfix:after {\n  height: 0;\n  display: block;\n  visibility: hidden;\n  clear: both;\n  overflow: auto;\n  line-height: 0;\n  content: \" \";\n}\n* html .clearfix {\n  height: 1%;\n}\n#sliding-area {\n  overflow: hidden;\n}\n#main {\n  padding: 25px 30px 15px;\n  -webkit-transition: margin 0.3s ease-out;\n  -moz-transition: margin 0.3s ease-out;\n  -ms-transition: margin 0.3s ease-out;\n  -o-transition: margin 0.3s ease-out;\n  transition: margin 0.3s ease-out;\n  width: 100%;\n  float: right;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.loading #main {\n  background: none;\n}\n.loginLoadingMessage,\n.bmlLoadingMessage {\n  display: none;\n}\n.loginProcessing .genericLoadingMessage {\n  display: none;\n}\n.loginProcessing .loginLoadingMessage {\n  display: block;\n}\n.full {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  text-decoration: none;\n}\n.trayInner {\n  padding: 20px 0;\n}\n.disclaimer {\n  font-size: 0.75em;\n  color: #6C7378;\n}\n.reviewMsg {\n  margin-top: 10px;\n  line-height: 1.5;\n}\n.infoTxt {\n  clear: both;\n  padding-top: 10px;\n}\n.help {\n  color: #A9A9A9;\n}\n.keyValue label {\n  color: #292929;\n}\n.frontArrow {\n  position: absolute;\n  display: inline-block;\n  width: 9px;\n  height: 15px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -196px -177px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .frontArrow {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.focusableIcon:focus {\n  box-shadow: 0 0 1px #6C7378;\n}\n.caret-down {\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -233px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .caret-down {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n/* Form styles */\ninput[type=submit],\ninput[type=button] {\n  -webkit-appearance: none;\n}\ninput[disabled=disabled],\n.inputField input[disabled=disabled],\n.inputField input[disabled=disabled]:active {\n  background: #F7F9FA;\n  border: 1px solid #CBD2D6;\n  color: #6C7378;\n}\ninput::-ms-clear {\n  display: none;\n}\ninput.link:hover {\n  cursor: pointer;\n}\ninput.xsmall {\n  width: 2em;\n}\ninput.small {\n  width: 3.35em;\n  font-size: 1em;\n}\ninput.medium {\n  width: 7em;\n}\ninput.large {\n  width: 14em;\n}\ninput.xlarge {\n  width: 20em;\n}\n.button-as-link {\n  margin: 0;\n  padding: 0;\n  border: none;\n  width: auto;\n  font-size: 0.85em;\n  background: transparent;\n  color: #0070BA;\n  cursor: pointer;\n}\n/* Hide spinner on type=number fields */\ninput[type=number]::-webkit-inner-spin-button,\ninput[type=number]::-webkit-outer-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n.buttons {\n  margin-top: 15px;\n  margin-bottom: 15px;\n  overflow: hidden;\n}\n.inputField {\n  position: relative;\n}\n.inputField label,\n.inputField input {\n  display: block;\n  vertical-align: top;\n}\n.inputField input,\n.ignoreValidation .inputField.error input,\n.validated .ignoreValidation .inputField input.ng-invalid,\n.validated .ignoreValidation .inputField input.backendError {\n  width: 100%;\n  height: 44px;\n  padding: 0 14px;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  border: 1px solid #C5CCD1;\n  color: #000;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  background: none;\n}\n.inputField input::-webkit-input-placeholder,\n.ignoreValidation .inputField.error input::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-webkit-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:-moz-placeholder,\n.ignoreValidation .inputField.error input:-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n}\n.inputField input::-moz-placeholder,\n.ignoreValidation .inputField.error input::-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n}\n.inputField input:-ms-input-placeholder,\n.ignoreValidation .inputField.error input:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-ms-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:active,\n.inputField input:focus {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n.inputField select {\n  font-size: 1.5em;\n  margin-bottom: 10px;\n}\n.custom-select-container select {\n  font-size: 15px;\n}\n.inputField label {\n  position: absolute;\n  top: 14px;\n  left: 14px;\n  cursor: text;\n  text-align: left;\n  color: #666;\n  font-size: 1em;\n}\n.no-js .inputField label,\n.no-js .dropdown label {\n  position: static;\n}\n.fieldGroup .inputField {\n  float: left;\n  padding: 0 0.5em 0 0;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.inputField.error input::-webkit-input-placeholder,\n.validated .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .inputField input.backendError::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.inputField.error input:-moz-placeholder,\n.validated .inputField input.ng-invalid:-moz-placeholder,\n.validated .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.inputField.error input::-moz-placeholder,\n.validated .inputField input.ng-invalid::-moz-placeholder,\n.validated .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.inputField.error input:-ms-input-placeholder,\n.validated .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .inputField input.backendError:-ms-input-placeholder {\n  color: #c72e2e;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n  background-size: 40px 8000px, 18px;\n}\n.inputField.valid input {\n  background: #fff url(https://www.paypalobjects.com/images/checkout/hermes/icon_checkmark_wallet_2x.png) no-repeat 98% center;\n  background-size: 14px;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  background-position: -webkit-calc(100% - 10px) center;\n  background-position: right 10px center;\n}\n.creditCardField.valid input {\n  background: #fff;\n}\n.inputField.error select,\n.dropdown.error select {\n  border: 1px solid #c72e2e;\n}\n.selectLabel {\n  display: block;\n}\ninput::-webkit-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 1em;\n}\ninput:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput:-ms-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\n/* End form styles */\n.checkbox input[type=checkbox] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.checkbox input[type=checkbox] ~ label,\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: inline-block;\n  position: static;\n  min-height: 25px;\n  padding-left: 35px;\n  line-height: 27px;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px 0;\n  vertical-align: middle;\n  cursor: pointer;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .checkbox input[type=checkbox] ~ label,\n  .checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 25px;\n  margin-left: -35px;\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.checkbox.error input[type=checkbox] ~ label,\n.checkbox.error input[type=checkbox]:focus ~ label,\n.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.checkbox input[type=checkbox]:checked ~ label,\n.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -400px;\n}\n.checkbox input[type=checkbox]:focus:checked ~ label,\n.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4801px;\n}\n.checkbox input[type=checkbox]:focus ~ label,\n.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4601px;\n}\n.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -800px;\n}\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 25px 25px;\n}\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 0;\n}\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 2600px;\n}\n.validated input[type=checkbox].ng-invalid ~ label,\n.validated input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.validated input[type=radio].ng-invalid + label::before,\n.validated input[type=radio].ng-invalid:focus + label::before,\n.validated input[type=radio].ng-invalid + label.bgImgOnSpan span.bgImg,\n.validated input[type=radio].ng-invalid:focus + label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2200px;\n}\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox {\n  position: relative;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label,\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  line-height: 19px;\n  padding-left: 27px;\n  font-size: 0.85em;\n  background-position: -9px -2600px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 19px;\n  margin-left: -27px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.sCheckbox.checkbox.error input[type=checkbox] ~ label,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3000px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -5409px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2800px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3400px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 18px 19px;\n}\n.radioButton input[type=radio] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.radioButton input[type=radio] ~ label {\n  display: inline-block;\n  min-height: 26px;\n  padding-left: 35px;\n  line-height: 27px;\n  vertical-align: middle;\n  cursor: pointer;\n  position: relative;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label {\n  padding-left: unset;\n  padding-right: 35px;\n}\n.radioButton input[type=radio] ~ label::before {\n  content: \" \";\n  display: block;\n  width: 30px;\n  height: 30px;\n  position: absolute;\n  top: 0;\n  left: 0;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px -1600px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .radioButton input[type=radio] ~ label::before {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label::before,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label::before {\n  right: 0;\n  left: unset;\n}\n.radioButton.error input[type=radio] + label::before,\n.radioButton.error input[type=radio]:focus + label::before {\n  background-position: -9px -2200px;\n}\n.radioButton.warning input[type=radio] + label::before,\n.radioButton.warning input[type=radio]:focus + label::before {\n  background-position: -9px -7405px;\n}\n.radioButton input[type=radio]:checked + label::before {\n  background-position: -9px -2000px;\n}\n.radioButton input[type=radio]:focus:checked + label::before {\n  background-position: -9px -6010px;\n}\n.radioButton input[type=radio]:focus + label::before {\n  background-position: -9px -1800px;\n}\n.inputField label.nolap {\n  position: relative;\n  top: auto;\n  left: auto;\n  color: #2c2e2f;\n}\n.inputField.half {\n  width: 48.15%;\n  margin-right: 3.7%;\n  padding-right: 0;\n}\n.singlePagePaymentForm .inputField.half,\n.multistepSignupForm .inputField.half {\n  width: 48.7%;\n  margin-right: 2.6%;\n  padding-right: 0;\n}\n.inputField.half.issueNo {\n  width: 42%;\n  margin-top: 15px;\n}\n.inputField.half.startDate {\n  width: 54%;\n  margin-right: 10px;\n}\n#cardIssueInfo .inputField.half.startDate {\n  width: 48%;\n  margin-right: 0;\n}\n#cardIssueInfo .inputField.half.issueNo {\n  width: 48%;\n  margin-top: 0;\n  float: right;\n}\n#cardIssueInfo .inputField.half.issueNo:before {\n  content: \"\\200C\";\n}\n.inputField.half.last-child {\n  margin-right: 0;\n}\n.fieldGroup .inputField.last-child {\n  padding-right: 0;\n}\n.fidobDay {\n  width: 30%;\n  float: left;\n}\n.fidobDay .custom-select > span {\n  border-radius: 5px 0 0 5px;\n  border-right: 0;\n}\n.fidobMonth {\n  width: 30%;\n  float: left;\n}\n.fidobMonth .custom-select > span {\n  border-radius: 0px;\n}\n.fidobYear {\n  width: 40%;\n  float: left;\n}\n.fidobYear .custom-select > span {\n  border-radius: 0px 5px 5px 0;\n  border-left: 0;\n}\n.cardDOB {\n  width: 100%;\n  clear: both;\n}\n.dobLabel {\n  top: auto;\n  left: auto;\n  position: relative;\n  display: block;\n  bottom: 4px;\n}\n.dobTXT {\n  margin-top: 10px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .inputField.error input,\n  .validated .inputField input.ng-invalid,\n  .validated .inputField input.backendError {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .validated select.ng-invalid + .custom-select > span,\n  .validated select.backendError + .custom-select > span {\n    background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n    background-size: 40px 8000px, 18px;\n  }\n}\n.submitted input.ng-invalid {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.submitted input.ng-invalid::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-ms-input-placeholder {\n  color: #c72e2e;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .submitted input.ng-invalid {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n.merchantHeader {\n  height: 90px;\n  margin: 0 auto;\n}\n.merchantHeader .headerWrapper {\n  max-width: 780px;\n  margin: 0 auto;\n  overflow: hidden;\n  max-height: 90px;\n  line-height: 90px;\n}\n.merchantHeader .merchantName {\n  font-size: 1.6em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n  width: 575px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  display: inline-block;\n}\n.merchantHeader img {\n  vertical-align: middle;\n}\n.paypalHeaderWrapper .logo {\n  float: left;\n  width: 112px;\n  height: 29px;\n  margin-top: 0;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .paypalHeaderWrapper .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.paypalHeaderWrapper .span14 {\n  padding-bottom: 20px;\n  border-bottom: 1px solid #dbdbdb;\n}\n.paypalHeaderWrapper .cartContainer {\n  position: static;\n  line-height: 29px;\n}\n.paypalHeaderWrapper .transctionCartDetails {\n  z-index: 2;\n}\n.paypalHeaderWrapper.paypalCredit .logo {\n  height: 35px;\n  background-position: 0 -129px;\n}\n.aside .header {\n  padding: 15px;\n  vertical-align: middle;\n  line-height: 50px;\n  border-bottom: 1px solid #e3e3e3;\n}\n.aside .header.tall {\n  min-height: 65px;\n  line-height: normal;\n  padding: 13px 15px 10px;\n  margin-bottom: 0;\n}\n.aside .asideAlpha {\n  padding: 0 30px;\n  text-align: center;\n  line-height: 1.2em;\n}\n.aside .walletHeading {\n  text-align: center;\n}\n.aside .close {\n  position: absolute;\n  top: 10px;\n  right: 15px;\n  width: 19px;\n  height: 19px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .close:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 19px;\n  height: 19px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px 0;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .close:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .close:hover:before,\n.aside .close:focus:before {\n  background-position: -223px -22px;\n}\n.aside .backArrow {\n  position: absolute;\n  top: 10px;\n  left: 15px;\n  width: 9px;\n  height: 18px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .backArrow:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 9px;\n  height: 18px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -232px -46px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .backArrow:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .backArrow:hover:before,\n.aside .backArrow:focus:before {\n  background-position: -232px -68px;\n}\n.aside .addOptions {\n  margin-top: 20px;\n}\n.aside .addOptions h2 {\n  float: left;\n  width: 70%;\n  margin-bottom: 0;\n}\n.aside .addOptions a {\n  float: right;\n  display: block;\n  line-height: 1.9em;\n  font-size: .85em;\n}\n.aside .subHeader {\n  margin-top: 20px;\n}\n.pageSepaAgreementContingency .paypalHeader.span14,\n.pageSepaMandateContingency .paypalHeader.span14,\n.pageSepaMandate .paypalHeader.span14,\n.CYCOPage .paypalHeader.span14 {\n  width: 100%;\n}\n#mobileMerchantHeader {\n  display: none;\n}\n@media (max-width: 41.3125em) {\n  .merchantHeader {\n    display: none;\n  }\n  .paypalHeaderWrapper {\n    height: 65px;\n  }\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -5px;\n    margin-right: 15px;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 30px;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -10px;\n    margin-right: 0;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 0;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n  .header {\n    height: 55px;\n  }\n  .aside .header {\n    height: auto;\n  }\n  .aside .close {\n    right: 15px;\n  }\n}\n.footer {\n  max-width: 780px;\n  margin: 10px auto;\n  font-size: 0.75em;\n}\n.cancelUrl {\n  float: left;\n}\n.micaLender {\n  display: none;\n  color: #2c2e2f;\n  clear: both;\n}\n.footerWrapper {\n  text-align: left;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper {\n    float: right;\n  }\n}\n.footerWrapper table {\n  display: inline;\n  float: left;\n  table-layout: fixed;\n  border: none;\n}\n.footerWrapper tr,\n.footerWrapper th,\n.footerWrapper td {\n  border: none;\n  font-weight: normal;\n  padding-bottom: 0;\n  padding-top: 0;\n  text-align: left;\n}\n.footerWrapper .footerLinks {\n  float: left;\n  border: none;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .footerLinks {\n    margin-right: 1em;\n  }\n}\n.footerWrapper .footerLinks li {\n  padding: 0 0.5em;\n  color: #6C7378;\n}\n.footerWrapper .footerLinks li:first-child {\n  padding-left: 0;\n}\n.footerWrapper .footerLinks li.feedbackLink {\n  color: #0070BA;\n}\n.footerWrapper .footerLinks .underline th {\n  border-bottom: 1px solid #ccc;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .languageToggleDisplay {\n    clear: none;\n    margin-left: 1.5em;\n  }\n  .footerWrapper .languageToggleDisplay::before {\n    border-left: 2px solid #9da3a6;\n    content: \" \";\n    margin: 0 0.15em;\n    display: inline-block;\n    height: 1em;\n    position: absolute;\n    left: 0;\n    top: 50%;\n    transform: translateY(-50%);\n    margin-left: -0.85em;\n  }\n}\n.footerLinks {\n  margin: 0;\n  display: inline-block;\n  text-align: left;\n}\n.footerLinks a {\n  color: #6C7378;\n}\n.footerLinks a.feedbackLink {\n  color: #0070BA;\n  margin-left: 5px;\n}\n.footerLinks th,\ntd {\n  border: none;\n}\n.policyInfoWrapper {\n  color: #6C7378;\n}\n.policyInfoWrapper p.moreInfo {\n  padding: 15px 0 20px 0;\n  float: left;\n}\n.copyright {\n  display: inline;\n  width: auto;\n  float: right;\n  margin: 0;\n  vertical-align: top;\n  color: #6C7378;\n}\n@media screen and (min-width: 41em) {\n  .copyright {\n    float: left;\n  }\n}\n.secureIcon {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: 0 -33px;\n  margin-left: 3px;\n  margin-right: 3px;\n  margin-top: 3px;\n  width: 10px;\n  height: 12px;\n  vertical-align: top;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .secureIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.poweredBy {\n  float: right;\n  margin-top: -49px;\n}\n.poweredBy .text {\n  float: left;\n  margin-top: 8px;\n  margin-right: 8px;\n  font-size: 12px;\n  font-weight: normal;\n  font-style: italic;\n  color: #6c7378;\n}\n.footerLinks li {\n  padding: 0 12px 0 0;\n  display: inline-block;\n}\n.footerLinks .last {\n  padding-right: 18px;\n  border-right: none;\n}\n.footer .policyInfoWrapper p {\n  line-height: 1.3em;\n}\n.footer .policyInfoWrapper p a {\n  font-weight: bold;\n}\n.minibrowser.AU .footer,\n.minibrowser .APAC.footer {\n  position: relative;\n  bottom: 0;\n  width: auto;\n}\n.minibrowser.AU .footer .policyInfoWrapper,\n.minibrowser .APAC.footer .policyInfoWrapper {\n  padding: 0;\n}\n.minibrowser .cancelUrl {\n  display: none;\n}\n.minibrowser .footerWrapper {\n  padding: 0 10px;\n  float: none;\n  width: 95%;\n  margin: 0;\n}\n.minibrowser .footerLinks li {\n  padding: 0 5px 0 0px;\n}\n/*\n//Country specific rules\n.DE, .fr.FR, .fr.CA {\n    .footerWrapper {\n        &:after {\n            height: 0;\n            display: block;\n            visibility: hidden;\n            clear: both;\n            overflow: auto;\n            line-height: 0;\n            content: \" \";\n        }\n    }\n    .footerLinks {\n        float: left;\n        width: 70%;\n        text-align: left;\n        li:first-child {\n            padding-left: 0;\n        }\n    }\n\n    .cancelUrl {\n        float: none;\n        margin: 5px 0;\n        width: 100%;\n    }\n}\n*/\n.APAC .policyInfoWrapper {\n  padding: 5px 0 10px 0;\n}\n.APAC .policyInfoWrapper p.moreInfo {\n  line-height: 1.3em;\n}\n.en_AU .policyInfoWrapper,\n.AU .policyInfoWrapper {\n  padding: 20px 0 10px 0;\n  color: #6C7378;\n}\n.en_AU .policyInfoWrapper p.moreInfo,\n.AU .policyInfoWrapper p.moreInfo {\n  border-bottom: 1px solid #ccc;\n}\n.en_AU .policyInfoWrapper p.moreCopyRight,\n.AU .policyInfoWrapper p.moreCopyRight {\n  padding: 5px 0 0 0;\n  clear: both;\n}\n.fr_XC .footerWrapper {\n  float: left;\n  width: 70%;\n  text-align: left;\n  padding-left: 0;\n  margin-left: -7px;\n}\n@media (max-width: 41.25em) {\n  .footer {\n    border-top: 1px solid #ccc;\n    padding: 5px 20px;\n    margin-top: 10px;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0 10px;\n  }\n  .footerWrapper {\n    padding: 0;\n    margin: 0;\n  }\n  .footerWrapper:after {\n    height: 0;\n    display: block;\n    visibility: hidden;\n    clear: both;\n    overflow: auto;\n    line-height: 0;\n    content: \" \";\n  }\n  .footerLinks {\n    float: left;\n    width: 70%;\n    text-align: left;\n  }\n  .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n  .cancelUrl {\n    float: none;\n    margin: 5px 0;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .footer {\n    margin-top: 0;\n    padding: 0.5em 2em;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0;\n  }\n  .footerWrapper,\n  .cancelUrl {\n    padding: 0;\n    margin: 5px 0px;\n    width: 100%;\n  }\n  .footerLinks,\n  .DE .footerLinks,\n  .fr.FR .footerLinks {\n    width: 65%;\n  }\n  .footerLinks li,\n  .DE .footerLinks li,\n  .fr.FR .footerLinks li {\n    padding: 0;\n    margin-right: 10px;\n  }\n  .footerLinks li.last,\n  .DE .footerLinks li.last,\n  .fr.FR .footerLinks li.last {\n    margin-right: 0;\n  }\n  .footerLinks .feedback,\n  .DE .footerLinks .feedback,\n  .fr.FR .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .copyright {\n    margin-right: 0;\n    width: 30%;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n}\n.modal-open {\n  overflow: hidden;\n}\n.modal-open .outerWrapper,\n.modal-open #wrapper,\n.modal-open #contents {\n  position: static;\n}\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 140;\n  background-color: #000;\n}\n.modal-backdrop.fade {\n  opacity: 0;\n}\n.modal-backdrop,\n.modal-backdrop.fade.in {\n  opacity: 0.54;\n}\n.modal {\n  display: none;\n  overflow: auto;\n  overflow-y: scroll;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 150;\n}\n.modal.fade .modal-wrap {\n  -webkit-transform: translate(0, -25%);\n  -moz-transform: translate(0, -25%);\n  -ms-transform: translate(0, -25%);\n  -o-transform: translate(0, -25%);\n  transform: translate(0, -25%);\n  -webkit-transition: -webkit-transform 0.3s ease-out;\n  -moz-transition: -moz-transform 0.3s ease-out;\n  -o-transition: -o-transform 0.3s ease-out;\n  transition: transform 0.3s ease-out;\n}\n.modal.fade.in .modal-wrap {\n  -webkit-transform: translate(0, 0);\n  -moz-transform: translate(0, 0);\n  -ms-transform: translate(0, 0);\n  -o-transform: translate(0, 0);\n  transform: translate(0, 0);\n}\n.modal-wrap {\n  position: relative;\n  margin: 10px;\n  background-color: #fff;\n  border: 1px solid #999;\n  border: 1px solid rgba(0, 0, 0, 0.3);\n  -webkit-border-radius: 6px;\n  -moz-border-radius: 6px;\n  border-radius: 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  -moz-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  outline: none;\n}\n.modal-header {\n  padding: 9px 15px;\n  border-bottom: 1px solid #eee;\n}\n.modal-header .close {\n  margin-top: 2px;\n}\n.modal-header h3 {\n  margin: 0;\n  line-height: 30px;\n}\n.modal-body {\n  position: relative;\n  overflow-y: auto;\n  max-height: 400px;\n  padding: 15px;\n}\n.modal-form {\n  margin-bottom: 0;\n}\n.modal-footer {\n  padding: 14px 15px 15px;\n  margin-bottom: 0;\n  text-align: right;\n  background-color: #f5f5f5;\n  border-top: 1px solid #ddd;\n  -webkit-border-radius: 0 0 6px 6px;\n  -moz-border-radius: 0 0 6px 6px;\n  border-radius: 0 0 6px 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: inset 0 1px 0 #fff;\n  -moz-box-shadow: inset 0 1px 0 #fff;\n  box-shadow: inset 0 1px 0 #fff;\n}\n.modal-footer:before,\n.modal-footer:after {\n  display: table;\n  content: \"\";\n  line-height: 0;\n}\n.modal-footer:after {\n  clear: both;\n}\n.modal-footer .btn + .btn {\n  margin-left: 5px;\n  margin-bottom: 0;\n}\n.modal-footer .btn-group .btn + .btn {\n  margin-left: -1px;\n}\n.modal-footer .btn-block + .btn-block {\n  margin-left: 0;\n}\n.spinner {\n  height: 100%;\n  width: 100%;\n  position: fixed;\n  z-index: 10;\n}\n.spinner .spinWrap {\n  width: 200px;\n  height: 100px;\n  position: fixed;\n  top: 42%;\n  left: 50%;\n  margin-left: -98px;\n  margin-top: -50px;\n}\n.spinner .spinnerImage {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 28px 0 0 -25px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/icon_ot_spin_lock_skinny.png') no-repeat;\n}\n.spinner .loader {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 0 0 0 -55px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background-color: transparent;\n  -webkit-animation: rotation .7s infinite linear;\n  -moz-animation: rotation .7s infinite linear;\n  -o-animation: rotation .7s infinite linear;\n  animation: rotation .7s infinite linear;\n  border-left: 5px solid #cbcbca;\n  border-right: 5px solid #cbcbca;\n  border-bottom: 5px solid #cbcbca;\n  border-top: 5px solid #2380be;\n  border-radius: 100%;\n}\n.spinner .genericLoadingMessage,\n.spinner .loginLoadingMessage,\n.spinner .bmlLoadingMessage {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  margin-top: 125px;\n  text-align: center;\n  z-index: 100;\n}\n.spinner.preloader {\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 1000;\n  background-color: #fff;\n}\n@-webkit-keyframes rotation {\n  from {\n    -webkit-transform: rotate(0deg);\n  }\n  to {\n    -webkit-transform: rotate(359deg);\n  }\n}\n@-moz-keyframes rotation {\n  from {\n    -moz-transform: rotate(0deg);\n  }\n  to {\n    -moz-transform: rotate(359deg);\n  }\n}\n@-o-keyframes rotation {\n  from {\n    -o-transform: rotate(0deg);\n  }\n  to {\n    -o-transform: rotate(359deg);\n  }\n}\n@keyframes rotation {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(359deg);\n  }\n}\n@media only screen and (max-width: 768px) {\n  .spinner .spinWrap {\n    width: 200px;\n    height: 100px;\n    position: fixed;\n    top: 40%;\n    left: 50%;\n    margin-left: -93px;\n    margin-top: -50px;\n  }\n}\n.aside {\n  min-height: 380px;\n}\n.aside .container {\n  padding: 15px;\n}\n.asideContent {\n  height: 100%;\n}\n.centerText {\n  text-align: center;\n}\n.fsIcons {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  min-width: 32px;\n  width: 25px;\n  height: 21px;\n  padding-right: 5px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.HOLDING .fsIcons,\n.BALANCE .fsIcons,\n.DELAYED_TRANSFER .fsIcons {\n  background-position: 0px 0px;\n}\n.ELO .fsIcons {\n  background-position: 0 -479px;\n}\n.HIPER .fsIcons {\n  background-position: 0 -458px;\n}\n.HIPERCARD .fsIcons {\n  background-position: 0 -500px;\n}\n.EBAY_MASTERCARD .fsIcons {\n  background-position: 0px -606px;\n}\n.PayPal.MasterCard .fsIcons {\n  background-position: 0 -604px;\n}\n.pinlessGlyphIcon {\n  display: inline-block;\n  position: relative;\n  top: -5px;\n  left: -8px;\n  width: 32px;\n  height: 20px;\n  font-size: 3.1rem;\n  padding-right: 5px;\n}\n.IACH .fsIcons,\n.BANK .fsIcons,\n.BANK_ACCOUNT .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.ELV .fsIcons,\n.ECHECK .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n}\n.TAB.DELAYED_TRANSFER .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.BILL_ME_LATER .fsIcons,\n.BML .fsIcons,\n.PPCREDIT .fsIcons,\n.CREDIT_OPTION .fsIcons {\n  background-position: 0 -105px;\n}\n.PAYPAL_SMART_CONNECT .fsIcons {\n  background-position: 0px 0px;\n}\n.VISA .fsIcons {\n  background-position: 0 -21px;\n}\n.MASTERCARD .fsIcons {\n  background-position: 0 -42px;\n}\n.AMEX .fsIcons {\n  background-position: 0 -63px;\n  left: 19px;\n  height: 20px;\n}\n.DISCOVER .fsIcons,\n.DISC .fsIcons {\n  background-position: 0 -84px;\n}\n.JCB .fsIcons {\n  background-position: 0px -353px;\n}\n.CHINA_UNION_PAY .fsIcons {\n  background-position: 0px -563px;\n}\n.ELECTRON .fsIcons {\n  background-position: 0 -146px;\n}\n.MAESTRO .fsIcons,\n.MSTRO .fsIcons,\n.SWITCH .fsIcons {\n  background-position: 0 -168px;\n}\n.CB_NATIONALE .fsIcons,\n.CBN .fsIcons {\n  background-position: 0 -210px;\n}\n.CELEM .fsIcons,\n.CETELEM .fsIcons {\n  background-position: 0 -311px;\n}\n.CONF .fsIcons,\n.COFINOGA .fsIcons {\n  background-position: 0 -231px;\n}\n.COFID .fsIcons,\n.COFIDIS .fsIcons {\n  background-position: 0 -437px;\n  left: 20px;\n}\n.INCENTIVE .fsIcons {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.PPSMTCONNECT .fsIcons {\n  background-position: 0 0;\n}\n.RUPAY .fsIcons {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.fsIcon {\n  display: block;\n  position: absolute;\n  width: 32px;\n  height: 21px;\n  left: 15px;\n  top: 20px;\n  min-width: 32px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  background-position: 0px 0px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.fsIcon.PAYPAL_SMART_CONNECT {\n  background-position: 0 0;\n}\n.fsIcon.PPSMTCONNECT {\n  background-position: 0 0;\n}\n.fsIcon.VISA {\n  background-position: 0 -21px;\n}\n.fsIcon.MASTER,\n.fsIcon.MCARD,\n.fsIcon.MASTERCARD {\n  background-position: 0 -42px;\n}\n.fsIcon.AMEX,\n.fsIcon.Amex {\n  background-position: 6px -63px;\n  left: 19px;\n  height: 20px;\n}\n.fsIcon.DISCOVER,\n.fsIcon.DISC {\n  background-position: 0 -84px;\n}\n.fsIcon.PPCREDIT,\n.fsIcon.BML,\n.fsIcon.BILL_ME_LATER {\n  background-position: 0 -105px;\n}\n.fsIcon.SWITCH,\n.fsIcon.MSTRO,\n.fsIcon.MAESTRO {\n  background-position: 0 -168px;\n}\n.fsIcon.CBN,\n.fsIcon.CB_NATIONALE {\n  background-position: 0 -210px;\n}\n.fsIcon.CONF,\n.fsIcon.COFINOGA {\n  background-position: 0 -231px;\n}\n.fsIcon.BANK,\n.fsIcon.PAD {\n  background-position: 6px -252px;\n  height: 19px;\n  left: 19px;\n}\n.fsIcon.INCENTIVE {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.fsIcon.CELEM,\n.fsIcon.CETELEM {\n  background-position: 0 -311px;\n}\n.fsIcon.JCB {\n  background-position: 0px -353px;\n}\n.fsIcon.COFID,\n.fsIcon.COFIDIS {\n  background-position: 0 -437px;\n  left: 20px;\n  height: 20px;\n}\n.fsIcon.HIPER {\n  background-position: 0 -458px;\n}\n.fsIcon.ELO {\n  background-position: 0 -479px;\n}\n.fsIcon.HIPERCARD {\n  background-position: 0 -500px;\n}\n.fsIcon.CHINA_UNION_PAY,\n.fsIcon.CUP {\n  background-position: 0px -563px;\n}\n.fsIcon.PayPal.MasterCard,\n.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.fsIcon.PPXMCARD {\n  background-position: 0 -584px;\n}\n.fsIcon.EBAY_MASTERCARD,\n.fsIcon.EBAYMCARD {\n  background-position: 0px -605px;\n}\n.fsIcon.CHASEPAY {\n  background-position: 0px -626px;\n  width: 36px;\n  height: 14px;\n  display: inline-block;\n  vertical-align: baseline;\n  position: static;\n  margin-bottom: -1px;\n}\n.fsIcon.pinlessIcon {\n  background-image: none;\n  font-size: 3.1rem;\n  left: 5px;\n  top: 14px;\n}\n.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.PayPal.MasterCard .fsIcons,\n.PayPal.MasterCard .fsIcon,\n.PPXMCARD .fsIcons,\n.PPXMCARD .fsIcon,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcons,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcon {\n  background-position: 0 -584px;\n}\n.fsIcon.BILL_ME_LATER_DE,\n.fsIcons.BILL_ME_LATER_DE {\n  position: static;\n  float: left;\n  background-size: auto;\n  background-image: url(\"https://www.paypalobjects.com/webstatic/credit/img/pp-ratenzahlung-logo.png\");\n  background-repeat: no-repeat;\n  background-position: initial;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n}\n.standardCardIcon.pinlessGlyphIcon {\n  display: inline-block;\n  width: 37.12px;\n  height: 24.36px;\n  font-size: 3.6rem;\n  padding-right: 8px;\n  position: relative;\n}\n.standardCardIcon.pinlessGlyphIcon:before {\n  position: absolute;\n  left: -11px;\n  top: 0px;\n}\n.standardCardIcon.fsIcon {\n  background-size: 42.92px 745.88px;\n  width: 37.12px;\n  height: 24.36px;\n}\n.standardCardIcon.fsIcon.VISA {\n  background-position: 0 -24.36px;\n}\n.standardCardIcon.fsIcon.MASTER,\n.standardCardIcon.fsIcon.MCARD,\n.standardCardIcon.fsIcon.MASTERCARD {\n  background-position: 0 -48.72px;\n}\n.standardCardIcon.fsIcon.AMEX,\n.standardCardIcon.fsIcon.Amex {\n  background-position: 5px -73.08px;\n  height: 23.2px;\n}\n.standardCardIcon.fsIcon.DISCOVER,\n.standardCardIcon.fsIcon.DISC {\n  background-position: 0 -97.44px;\n}\n.standardCardIcon.fsIcon.PPCREDIT,\n.standardCardIcon.fsIcon.BML,\n.standardCardIcon.fsIcon.BILL_ME_LATER {\n  background-position: 0 -121.8px;\n}\n.standardCardIcon.fsIcon.SWITCH,\n.standardCardIcon.fsIcon.MSTRO,\n.standardCardIcon.fsIcon.MAESTRO {\n  background-position: 0 -194.88px;\n}\n.standardCardIcon.fsIcon.CBN,\n.standardCardIcon.fsIcon.CB_NATIONALE {\n  background-position: 0 -243.6px;\n}\n.standardCardIcon.fsIcon.CONF,\n.standardCardIcon.fsIcon.COFINOGA {\n  background-position: 0 -267.96px;\n}\n.standardCardIcon.fsIcon.BANK,\n.standardCardIcon.fsIcon.BANK_ACCOUNT,\n.standardCardIcon.fsIcon.PAD {\n  background-position: 5px -292.32px;\n  height: 22.04px;\n}\n.standardCardIcon.fsIcon.INCENTIVE {\n  background-position: 0 -314.36px;\n  height: 20.88px;\n}\n.standardCardIcon.fsIcon.CELEM,\n.standardCardIcon.fsIcon.CETELEM {\n  background-position: 0 -360.76px;\n}\n.standardCardIcon.fsIcon.JCB {\n  background-position: 0px -409.48px;\n}\n.standardCardIcon.fsIcon.HIPER {\n  background-position: 0px -531.28px;\n}\n.standardCardIcon.fsIcon.ELO {\n  background-position: 0px -555.64px;\n}\n.standardCardIcon.fsIcon.HIPERCARD {\n  background-position: 0px -580px;\n}\n.standardCardIcon.fsIcon.Thirdlast {\n  background-position: 0px -600px;\n}\n.standardCardIcon.fsIcon.COFID,\n.standardCardIcon.fsIcon.COFIDIS {\n  background-position: 0px -506.92px;\n}\n.standardCardIcon.fsIcon.CHINA_UNION_PAY,\n.standardCardIcon.fsIcon.CUP {\n  background-position: 0px -653.08px;\n}\n.standardCardIcon.fsIcon.PayPal.MasterCard,\n.standardCardIcon.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.standardCardIcon.fsIcon.PPXMCARD {\n  background-position: 0 -677.44px;\n}\n.standardCardIcon.fsIcon.EBAY_MASTERCARD,\n.standardCardIcon.fsIcon.EBAYMCARD {\n  background-position: 0 -701.8px;\n}\n.standardCardIcon.fsIcon.CHASEPAY {\n  background-position: 0px -726.16px;\n  width: 36px;\n  height: 14px;\n}\n.standardCardIcon.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.infoIcon {\n  width: 19px;\n  height: 18px;\n  display: inline-block;\n  position: absolute;\n  top: 25px;\n  right: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -89px -1px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .infoIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.addOption {\n  padding: 25px 10px;\n  margin: 0 0 0 44px;\n  color: #0070BA;\n  font-size: .85em;\n}\n.plusicon {\n  display: block;\n  position: absolute;\n  left: 15px;\n  top: 22px;\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -97px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .plusicon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.infoIcon + .checkIcon {\n  display: none;\n}\n.infoMsg {\n  margin: 0;\n  overflow: hidden;\n  font-size: .85em;\n}\n.expiredIcon {\n  background: white url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  top: 6px;\n  position: relative;\n}\n.plccIcon {\n  float: left;\n  display: inline-block;\n  height: 20px;\n  background: none;\n  width: 32px;\n  position: relative;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .fsIcons {\n    height: 20px;\n  }\n  .fsIcon {\n    height: 20px;\n  }\n}\n.walletIcons {\n  position: absolute;\n  width: 30px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .walletIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons_2x.png\");\n    background-size: 90px 970px;\n  }\n}\n.walletIcons.BANK,\n.walletIcons.BANK_ACCOUNT {\n  background-position: -50px -460px;\n}\n.walletIcons.BANK.BOFA,\n.walletIcons.BANK_ACCOUNT.BOFA {\n  background-position: -50px -10px;\n}\n.walletIcons.BANK.CHASE,\n.walletIcons.BANK_ACCOUNT.CHASE {\n  background-position: -50px -130px;\n}\n.walletIcons.BANK.WELLSFARGO,\n.walletIcons.BANK_ACCOUNT.WELLSFARGO {\n  background-position: -50px -100px;\n}\n.walletIcons.BANK.CITI,\n.walletIcons.BANK_ACCOUNT.CITI {\n  background-position: -50px -40px;\n}\n.walletIcons.BANK.FIFTHTHIRD,\n.walletIcons.BANK_ACCOUNT.FIFTHTHIRD {\n  background-position: -50px -220px;\n}\n.walletIcons.BANK.CAPITAL,\n.walletIcons.BANK_ACCOUNT.CAPITAL {\n  background-position: -50px -70px;\n}\n.walletIcons.BANK.AMERITRADE,\n.walletIcons.BANK_ACCOUNT.AMERITRADE {\n  background-position: -50px -160px;\n}\n.walletIcons.BANK.SUNTRUST,\n.walletIcons.BANK_ACCOUNT.SUNTRUST {\n  background-position: -50px -280px;\n}\n.walletIcons.BANK.USBANK,\n.walletIcons.BANK_ACCOUNT.USBANK {\n  background-position: -50px -310px;\n}\n.walletIcons.BANK.USAA,\n.walletIcons.BANK_ACCOUNT.USAA {\n  background-position: -50px -250px;\n}\n.walletIcons.CARD.VISA,\n.walletIcons.PAYMENT_CARD.VISA {\n  background-position: -10px -40px;\n}\n.walletIcons.CARD.MASTER,\n.walletIcons.PAYMENT_CARD.MASTER,\n.walletIcons.CARD.MASTERCARD,\n.walletIcons.PAYMENT_CARD.MASTERCARD {\n  background-position: -10px -70px;\n}\n.walletIcons.CARD.DISCOVER,\n.walletIcons.PAYMENT_CARD.DISCOVER {\n  background-position: -10px -100px;\n}\n.walletIcons.CARD.AMEX,\n.walletIcons.PAYMENT_CARD.AMEX {\n  background-position: -10px -130px;\n}\nhr.sep,\nhr.sepPlain {\n  padding: 0;\n  margin-top: 25px;\n  height: auto;\n  border: none;\n  border-top: 1px solid #ccc;\n  color: #2c2e2f;\n  text-align: center;\n  overflow: visible;\n}\nhr.sep:after,\nhr.sepPlain:after,\nhr.sep::after,\nhr.sepPlain::after {\n  content: \"or\";\n  display: inline-block;\n  position: relative;\n  top: -0.7em;\n  font-size: 1em;\n  padding: 0 0.50em;\n  background: white;\n  color: #6c7378;\n  font-weight: normal;\n}\n.de hr.sep:after,\n.de hr.sep::after {\n  content: \"oder\";\n}\n.da hr.sep:after,\n.da hr.sep::after {\n  content: \"eller\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\n.es hr.sep:after,\n.es hr.sep::after {\n  content: \"o\";\n}\n.fr hr.sep:after,\n.fr hr.sep::after {\n  content: \"ou\";\n}\n.he hr.sep:after,\n.he hr.sep::after {\n  content: \"\\5D0\\5D5\";\n}\n.id hr.sep:after,\n.id hr.sep::after {\n  content: \"Atau\";\n}\n.it hr.sep:after,\n.it hr.sep::after {\n  content: \"oppure\";\n}\n.ja hr.sep:after,\n.ja hr.sep::after {\n  content: \"\\307E\\305F\\306F\";\n}\n.ko hr.sep:after,\n.ko hr.sep::after {\n  content: \"\\B610\\B294\";\n}\n.nl hr.sep:after,\n.nl hr.sep::after {\n  content: \"of\";\n}\n.no hr.sep:after,\n.no hr.sep::after {\n  content: \"eller\";\n}\n.pl hr.sep:after,\n.pl hr.sep::after {\n  content: \"lub\";\n}\n.pt hr.sep:after,\n.pt hr.sep::after {\n  content: \"ou\";\n}\n.ru hr.sep:after,\n.ru hr.sep::after {\n  content: \"\\418\\43B\\438\";\n}\n.sv hr.sep:after,\n.sv hr.sep::after {\n  content: \"eller\";\n}\n.th hr.sep:after,\n.th hr.sep::after {\n  content: \"\\E2B\\E23\\E37\\E2D\";\n}\n.tr hr.sep:after,\n.tr hr.sep::after {\n  content: \"Veya\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\nhr.sepPlain:after,\nhr.sepPlain::after {\n  content: '';\n}\n/*\n * @fileOverview queries.css contains media queries for responsive design/layout breakpoints.\n * @name Queries\n * @author abadri\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n@media (min-width: 0) and (max-width: 23em) {\n  #loginSection .xoTitle h1 {\n    max-width: 10em;\n  }\n}\n@media (min-width: 0) and (max-width: 30em), (max-width: 40em) and (orientation: landscape) {\n  body {\n    -webkit-text-size-adjust: 100%;\n  }\n  .merchantBrand {\n    display: none;\n  }\n  .outerWrapper {\n    background-position: left 50px;\n  }\n  .centerTray.loginSignup {\n    margin-bottom: 60px;\n  }\n  #main {\n    padding: 0;\n    background: none;\n    z-index: 2;\n  }\n  #contents {\n    padding: 0 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  .tokenization #contents {\n    padding: 0 30px;\n  }\n  .paypalHeader {\n    padding: 0 20px 20px 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  .review #wrapper {\n    min-height: 512px;\n  }\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .loginProcessing,\n  .bmlAppProcessing {\n    background-color: #f9f9f9;\n  }\n  .loggingIn {\n    margin: 0 25px;\n  }\n  .mobile .loggingIn {\n    margin: 0;\n  }\n  .saferEasier,\n  .simpler {\n    display: none;\n  }\n  #login .row-fluid {\n    padding-top: 0px;\n  }\n  #login .centerTray {\n    padding: 0;\n  }\n  #login #signupLink.btn {\n    margin: 5px 0;\n  }\n  #wrapper {\n    margin: 0;\n    width: auto;\n    -webkit-border-radius: 0;\n    -moz-border-radius: 0;\n    border-radius: 0;\n    -webkit-background-clip: padding-box;\n    -moz-background-clip: padding-box;\n    background-clip: padding-box;\n    border: none;\n  }\n  #task {\n    width: 295px;\n  }\n  .loading .spinner {\n    background-position-y: 35%;\n  }\n  .centerTray {\n    width: auto;\n  }\n  .tray .inner,\n  .accountTerms .tray .inner {\n    padding: 10px;\n  }\n  .row-fluid > [class*=\"span\"],\n  .signup {\n    width: 100%;\n    margin-left: 0;\n    float: none;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .gamma,\n  .delta {\n    font-size: 1.2em;\n  }\n  .inputField label {\n    left: 7px;\n    top: 13px;\n  }\n  .saferEasier {\n    display: none;\n  }\n  #fundingInstruments .buttons {\n    height: 40px;\n  }\n  .cityState select {\n    font-size: 14px;\n  }\n  .cityState .city {\n    width: 100%;\n  }\n  .cityState .state {\n    width: 55%;\n  }\n  .cityState .postalCode {\n    width: 40.8%;\n  }\n  #tab {\n    margin-top: 0;\n    height: 125px;\n  }\n  .toolTip.whatsthis ul {\n    width: 242px;\n    left: 9px;\n  }\n  .toolTip.whatsthis ul li {\n    font-size: 0.9em;\n  }\n  #expiration.varB .expires {\n    width: 49%;\n  }\n  #expiration .inputField {\n    padding: 0;\n  }\n  #expiration .cvc {\n    width: 44%;\n    float: right;\n  }\n  #expiration.varB .cvc {\n    width: 49%;\n  }\n  .month {\n    margin-left: 46px;\n  }\n  .separator {\n    margin-left: 5px;\n    margin-top: 3px;\n  }\n  .year {\n    margin-left: 0;\n  }\n  #expiration .cardIcon {\n    position: absolute;\n    right: 4px;\n  }\n  .details {\n    margin-right: 2px;\n  }\n  .mask #header,\n  .mask #closeButton {\n    display: none;\n  }\n}\n@media (min-width: 30.0625em) and (max-width: 41.25em) {\n  .row-fluid > .span10,\n  .row-fluid > .span12,\n  .row-fluid > .span14 {\n    width: 100%;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .outerWrapper {\n    background-position: left 59px;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  #wrapper {\n    margin: 0;\n    border: none;\n  }\n  #main {\n    padding: 0;\n  }\n  #contents {\n    padding: 0 25px;\n  }\n}\n@media (min-width: 41.3125em) {\n  .banner {\n    display: block;\n  }\n  #wrapper {\n    min-height: 0;\n    width: 95%;\n  }\n  .merchantHeader,\n  .footer {\n    width: 95%;\n  }\n  .largeScreen .centerTray {\n    margin-top: 0;\n  }\n  .signup {\n    margin-bottom: 0;\n  }\n  #genericError {\n    min-height: 375px;\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/scr_cloud_balloon.png) no-repeat center bottom;\n  }\n  #transactionDetails .merchantName {\n    display: none;\n  }\n}\n@media (device-height: 568px) and (-webkit-min-device-pixel-ratio: 2) {\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .pageLanding #contents {\n    margin: 70px auto 40px 0px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .cardType {\n    display: none;\n  }\n  ul.validations li.restriction.active {\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/close3_2x.png) no-repeat 0 2px;\n    background-size: 10px;\n  }\n  .inputField.error input {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .inputField.error input,\n  .inputField.valid input {\n    background-position: -webkit-calc(100% - 10px) center;\n    background-position: right 10px center;\n  }\n  .error .custom-select > span,\n  .error .custom-select.active > span {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2) and (min-width: 41.3125em) {\n  #genericError {\n    background-size: 640px 242px;\n  }\n}\n/*\n    .within-rtl({ ... });\n    Targets rules for both xoon and hermes, when RTL applies\n*/\n*[dir=\"rtl\"] .footerWrapper .footerLinks,\n.outerWrapper.rtl .footerWrapper .footerLinks {\n  float: right;\n}\n*[dir=\"rtl\"] .footerWrapper .footerLinks li:first-child,\n.outerWrapper.rtl .footerWrapper .footerLinks li:first-child {\n  padding-left: 12px;\n}\n@media screen and (max-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: none;\n    clear: both;\n  }\n}\n@media screen and (min-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: left;\n  }\n  *[dir=\"rtl\"] .footerWrapper .languageToggleDisplay::before,\n  .outerWrapper.rtl .footerWrapper .languageToggleDisplay::before {\n    right: 0;\n    margin-left: 0.85em;\n  }\n}\n*[dir=\"rtl\"] .paypalHeader .languageToggleDisplay,\n.outerWrapper.rtl .paypalHeader .languageToggleDisplay {\n  float: right;\n}\n#banner-wrapper {\n  padding: 5px;\n  border-bottom: 1px solid #e3e3e3;\n}\n#banner-picture {\n  width: 40px;\n  height: 40px;\n  border-radius: 40px;\n  -webkit-border-radius: 40px;\n  -moz-border-radius: 40px;\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/icon_ot_phantom.png') no-repeat;\n  background-size: cover;\n  float: left;\n  margin-top: 10px;\n  margin-bottom: 10px;\n  margin-right: 10px;\n}\n#banner-picture.initials {\n  color: #fff;\n  font-size: 18px;\n  line-height: 40px;\n  text-align: center;\n  background-color: #57c8f7;\n  background-image: none;\n}\n#banner-content {\n  height: 26px;\n  font-family: \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 13px;\n  font-weight: normal;\n  color: #000000;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 10px;\n  display: table-cell;\n  vertical-align: middle;\n}\n#banner-content > p {\n  font-size: inherit;\n  margin: 0;\n  padding-bottom: 0;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-ui-components/src/directionality/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, ".ltrOverride {\n  direction: ltr !important;\n  unicode-bidi: bidi-override !important;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-ui-components/src/floating-label/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/**\n* @fileOverview Base contains variables, mixins, reset, baseline, grid, and utilities\n* @name Base\n* @author hdoan\n* @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n*/\n/**\n * @fileOverview Variables contains variables\n * @name Variables\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Fonts */\n/* Colors */\n/**\n * @fileOverview Mixins contains mixins\n * @name Mixins\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/**\n * @fileOverview Reset contains reset and baseline styles\n * @name Reset\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Reset ====================================== */\nhtml,\nbody,\ndiv,\ndl,\ndt,\ndd,\nul,\nol,\nli,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\npre,\ncode,\nform,\nfieldset,\nlegend,\ninput,\ntextarea,\np,\nblockquote,\nth,\ntd {\n  margin: 0;\n  padding: 0;\n}\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\nfieldset,\nimg {\n  border: 0;\n}\naddress,\ncaption,\ncite,\ncode,\ndfn,\nem,\nstrong,\nth,\nvar {\n  font-style: normal;\n  font-weight: normal;\n}\nol,\nul {\n  list-style: none;\n}\ncaption,\nth {\n  text-align: left;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6 {\n  font-size: 100%;\n  font-weight: normal;\n}\nq:before,\nq:after {\n  content: \"\";\n}\nabbr,\nacronym {\n  border: 0;\n  font-variant: normal;\n}\n/* to preserve line-height and selector appearance */\nsup {\n  vertical-align: text-top;\n}\nsub {\n  vertical-align: text-bottom;\n}\ninput,\ntextarea,\nselect {\n  font-family: inherit;\n  font-size: inherit;\n  font-weight: inherit;\n}\n/*to enable resizing for IE*/\ninput,\ntextarea,\nselect {\n  *font-size: 100%;\n}\n/*because legend doesn't inherit in IE */\nlegend {\n  color: #000;\n}\n/* Start of base-lining, some from YUI's CSS Foundation ==================== */\nbody {\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 95%;\n  /* Base font-size is 15px */\n  color: #2c2e2f;\n  line-height: 1.35em;\n}\nh1 {\n  /*18px via YUI Fonts CSS foundation*/\n  font-size: 138.5%;\n}\nh2 {\n  /*16px via YUI Fonts CSS foundation*/\n  font-size: 123.1%;\n}\nh3 {\n  /*14px via YUI Fonts CSS foundation*/\n  font-size: 108%;\n}\nh1,\nh2,\nh3 {\n  /* top & bottom margin based on font size */\n  margin: 1em 0;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\nstrong {\n  /*bringing boldness back to headers and the strong element*/\n  font-weight: bold;\n}\na {\n  color: #0070BA;\n}\nabbr,\nacronym {\n  /*indicating to users that more info is available */\n  border-bottom: 1px dotted #000;\n  cursor: help;\n}\nem {\n  /*bringing italics back to the em element*/\n  font-style: italic;\n}\nblockquote,\nul,\nol,\ndl {\n  /*giving blockquotes and lists room to breath*/\n  margin: 1em;\n}\nol,\nul,\ndl {\n  /*bringing lists on to the page with breathing room */\n  margin-left: 2em;\n}\nol {\n  /*giving OL's LIs generated numbers*/\n  list-style: decimal outside;\n}\nul {\n  /*giving UL's LIs generated disc markers*/\n  list-style: disc outside;\n}\ndl dd {\n  /*providing spacing for definition terms*/\n  margin-left: 1em;\n}\nth,\ntd {\n  /*borders and padding to make the table readable*/\n  border: 1px solid #000;\n  padding: .5em;\n}\nth {\n  /*distinguishing table headers from data cells*/\n  font-weight: bold;\n  text-align: center;\n}\ninput {\n  margin-bottom: 10px;\n}\ncaption {\n  /*coordinated margin to match cell's padding*/\n  margin-bottom: .5em;\n  /*centered so it doesn't blend in to other content*/\n  text-align: center;\n}\np,\nfieldset,\ntable,\npre,\nlegend {\n  /*so things don't run into each other*/\n  margin-bottom: 1em;\n}\n/* setting a consistent width, 160px;\n   control of type=file still not possible */\ninput[type=text],\ninput[type=password],\ntextarea {\n  width: 12.25em;\n  *width: 11.9em;\n}\n/**\n * @fileOverview Grid contains grid rules\n * @name Grid\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n.row-fluid {\n  width: 100%;\n  *zoom: 1;\n}\n.row-fluid:before,\n.row-fluid:after {\n  display: table;\n  content: \"\";\n}\n.row-fluid:after {\n  clear: both;\n}\n.row-fluid > [class*=\"span\"] {\n  float: left;\n  margin-left: 4.127659574%;\n}\n.row-fluid > [class*=\"span\"]:first-child {\n  margin-left: 0;\n}\n.row-fluid > .span24 {\n  width: 99.999999978%;\n}\n.row-fluid > .span23 {\n  width: 95.74468083%;\n}\n.row-fluid > .span22 {\n  width: 91.48936168200001%;\n}\n.row-fluid > .span21 {\n  width: 87.234042534%;\n}\n.row-fluid > .span20 {\n  width: 82.97872338599998%;\n}\n.row-fluid > .span19 {\n  width: 78.723404238%;\n}\n.row-fluid > .span18 {\n  width: 74.46808508999999%;\n}\n.row-fluid > .span17 {\n  width: 70.212765942%;\n}\n.row-fluid > .span16 {\n  width: 65.95744679399999%;\n}\n.row-fluid > .span15 {\n  width: 61.702127646%;\n}\n.row-fluid > .span14 {\n  width: 54.446808497999996%;\n}\n.row-fluid > .span13 {\n  width: 53.19148935%;\n}\n.row-fluid > .span12 {\n  width: 48.936170202%;\n}\n.row-fluid > .span11 {\n  width: 44.680851054%;\n}\n.row-fluid > .span10 {\n  width: 40.425531905999996%;\n}\n.row-fluid > .span9 {\n  width: 36.170212758%;\n}\n.row-fluid > .span8 {\n  width: 31.91489361%;\n}\n.row-fluid > .span7 {\n  width: 27.659574462000002%;\n}\n.row-fluid > .span6 {\n  width: 23.404255313999997%;\n}\n.row-fluid > .span5 {\n  width: 19.148936166%;\n}\n.row-fluid > .span4 {\n  width: 14.893617018%;\n}\n.row-fluid > .span3 {\n  width: 10.638297869999999%;\n}\n.row-fluid > .span2 {\n  width: 6.382978722%;\n}\n.row-fluid > .span1 {\n  width: 2.127659574%;\n}\n.container-fluid {\n  padding-left: 20px;\n  padding-right: 20px;\n  *zoom: 1;\n}\n.container-fluid:before,\n.container-fluid:after {\n  display: table;\n  content: \"\";\n}\n.container-fluid:after {\n  clear: both;\n}\n.mt10 {\n  margin-top: 10px;\n}\n.mt15 {\n  margin-top: 10px;\n}\n.pt10 {\n  padding-top: 10px;\n}\n.pt15 {\n  padding-top: 15px;\n}\n.mb10 {\n  margin-bottom: 10px;\n}\n.mb15 {\n  margin-bottom: 15px;\n}\n.pb10 {\n  padding-bottom: 10px;\n}\n.pb15 {\n  padding-bottom: 15px;\n}\n.ml10 {\n  margin-left: 10px;\n}\n.ml15 {\n  margin-left: 15px;\n}\n.pl10 {\n  padding-left: 10px;\n}\n.pl15 {\n  padding-left: 15px;\n}\n.mr10 {\n  margin-right: 10px;\n}\n.mr15 {\n  margin-right: 15px;\n}\n.pr10 {\n  padding-right: 10px;\n}\n.pr15 {\n  padding-right: 15px;\n}\n/* Button styles */\n.btn {\n  height: 44px;\n  margin-bottom: 0;\n  border-style: solid;\n  border-width: 1px;\n  border-color: #0070BA;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  *margin-left: .3em;\n  display: inline-block;\n  /* IE7 inline-block hack */\n  *display: inline;\n  *zoom: 1;\n  background-color: #0070BA;\n  -webkit-transition: background-color 0.4s ease-out 0s;\n  -moz-transition: background-color 0.4s ease-out 0s;\n  -ms-transition: background-color 0.4s ease-out 0s;\n  -o-transition: background-color 0.4s ease-out 0s;\n  transition: background-color 0.4s ease-out 0s;\n  font-size: 1.0em;\n  font-weight: bold;\n  line-height: 42px;\n  color: #fff;\n  text-align: center;\n  vertical-align: middle;\n  cursor: pointer;\n  outline: none;\n  -webkit-font-smoothing: antialiased;\n}\n.btn .btn-secondary {\n  -webkit-font-smoothing: auto;\n}\n.btn:hover,\n.btn:focus {\n  background-color: #005EA6;\n}\n.btn:focus {\n  text-decoration: underline;\n}\n.btn.active,\n.btn:active {\n  background-color: #005EA6;\n  outline: 0;\n}\n.btn.disabled,\n.btn[disabled] {\n  background-color: #B2D9EA;\n  border-color: #B2D9EA;\n  cursor: default;\n}\n.btn.firstHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n.btn.secondHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\na.btn:focus,\na.btn:hover {\n  color: #fff;\n}\n.btn:first-child {\n  *margin-left: 0;\n}\n.btn-large {\n  padding: 8px 15px;\n  font-size: 18px;\n  line-height: normal;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n}\n.btn-small {\n  padding: 5px 9px;\n  font-size: 11px;\n  line-height: 16px;\n}\n.btn-mini {\n  padding: 2px 6px;\n  font-size: 11px;\n  line-height: 14px;\n}\n.btn-secondary {\n  border-style: solid;\n  border-color: #E1E7Eb;\n  color: #393F44;\n  background-color: #E1E7Eb;\n}\n.btn-secondary:hover {\n  color: #393F44;\n  border-color: #EDF2F5;\n  background-color: #EDF2F5;\n  text-decoration: none;\n}\n.btn-secondary:active,\n.btn-secondary:focus {\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n  text-decoration: underline;\n}\n.btn-secondary.disabled,\n.btn-secondary[disabled] {\n  color: #393F55;\n}\na.btn-secondary:hover,\na.btn-secondary:focus,\na.btn-secondary:active {\n  color: #393F44;\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n}\na.btn-secondary.disabled,\na.btn-secondary[disabled] {\n  color: #393F55;\n  background-color: #E7EDF0;\n}\nbutton.btn,\ninput[type=\"submit\"].btn {\n  *padding-top: 2px;\n  *padding-bottom: 2px;\n}\nbutton.btn::-moz-focus-inner,\ninput[type=\"submit\"].btn::-moz-focus-inner {\n  padding: 0;\n  border: 0;\n}\nbutton.btn.btn-large,\ninput[type=\"submit\"].btn.btn-large {\n  *padding-top: 7px;\n  *padding-bottom: 7px;\n}\nbutton.btn.btn-small,\ninput[type=\"submit\"].btn.btn-small {\n  *padding-top: 3px;\n  *padding-bottom: 3px;\n}\nbutton.btn.btn-mini,\ninput[type=\"submit\"].btn.btn-mini {\n  *padding-top: 1px;\n  *padding-bottom: 1px;\n}\nsection .buttons #backButton,\n#largeScreenAccountCreation .buttons #backButton {\n  width: 30%;\n}\nsection .buttons #proceedButton,\n#largeScreenAccountCreation .buttons #proceedButton {\n  width: 65%;\n}\nsection .buttons #proceedButton.full,\n#largeScreenAccountCreation .buttons #proceedButton.full {\n  width: 100%;\n}\nsection .buttons #proceedButton-venmoBA,\n#largeScreenAccountCreation .buttons #proceedButton-venmoBA {\n  width: 100%;\n}\n/* mixin for Select element - Dropdowns\n    *\n    * We style native select element on web and it uses native element on other devices\n    * HTML Format to use for select element:\n    *   <div class=\"dropdown\">\n    *           <label for=\"selectID\" class=\"accessAid\" id=\"forSelectID\">Select Label</label>\n    *           <select id=\"selectID\" name=\"selectID\">\n    *               <option value=\"\">Option 1</option>\n    *               <option value=\"2\">Option 2</option>\n    *           </select>\n    *       </div>\n    *\n    * @param width - defines the width of the select dropdown on form\n*/\n.custom-select-container {\n  position: relative;\n}\n/* Set the dimensions of the replaced select element and make it transparent. */\nselect.replaced {\n  position: relative;\n  z-index: 8;\n  width: 100%;\n  height: 44px;\n  border: 0;\n  line-height: 2;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  /* Move to IE-speci    fic CSS file if you want to. */\n}\n.custom-select {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 1;\n  display: block;\n  width: 100%;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.custom-select > span {\n  display: block;\n  padding: 7px 30px 7px 13px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: right -7px top -1178px;\n  color: #000;\n  line-height: 28px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .custom-select > span {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.disabled .custom-select > span {\n  background-position: right -7px top -6990px;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat right 10px center;\n  background-size: 16px;\n  color: #c72e2e;\n  border: 1px solid #c72e2e;\n}\n.custom-select span span {\n  display: block;\n  overflow: hidden;\n  height: 28px;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-size: 1em;\n}\n.custom-select.active > span {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n#task .custom-select {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.mobile .dob label {\n  position: static;\n  top: 0;\n  left: 0;\n}\ninput[type=date] {\n  padding: 5px 38px 3px 6px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  color: #333;\n  background-size: 24px;\n  background: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_cart_icons.png\") no-repeat 100% 61%;\n}\ninput[type=date]:focus {\n  border-color: #3399ff;\n}\n.showDropdopwnLabels .labelText {\n  float: left;\n  color: #aaa;\n}\n.showDropdopwnLabels .valueText {\n  float: right;\n  min-width: 90px;\n}\n@media (min-width: 0) and (max-width: 40em) {\n  .showDropdopwnLabels .labelText {\n    display: none;\n  }\n  .showDropdopwnLabels .valueText {\n    float: none;\n    min-width: 0;\n  }\n}\n.multiline-select-container {\n  outline: 0 none;\n}\n.multiline-select-container:active .innerContainer,\n.multiline-select-container:focus .innerContainer {\n  border-color: #009cde;\n}\n.multiline-select-container.open:active .innerContainer,\n.multiline-select-container.open:focus .innerContainer {\n  border-color: #ccd0d4;\n}\n.multiline-select-container option,\n.multiline-select-container select {\n  position: absolute !important;\n  left: -9999px;\n}\n.multiline-select-container .custom-select {\n  position: relative;\n}\n.multiline-select-container .custom-select span span {\n  height: auto;\n  white-space: initial;\n}\n.multiline-select-container .custom-select > span {\n  background: none;\n}\n.multiline-select-container.open .custom-select > span {\n  border-radius: 5px 5px 0 0;\n  border-bottom-color: #eee;\n}\n.multiline-select-container .arrow {\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_forms.png\");\n  background-position: left -8px top -1198px;\n  background-repeat: no-repeat;\n  height: 10px;\n  position: absolute;\n  width: 14px;\n  top: 40%;\n  right: 12px;\n}\n.validated .multiline-select-container .ng-invalid + .custom-select .arrow,\n.backendError .multiline-select-container .ng-invalid + .custom-select .arrow {\n  display: none;\n}\n.multiline-select-list {\n  position: absolute;\n  list-style: none;\n  margin: 0;\n  background-color: #fff;\n  z-index: 1000;\n  border-radius: 0 0 5px 5px;\n  border-bottom: 1px solid #ccd0d4;\n  max-height: 200px;\n  overflow: auto;\n  box-shadow: #ccc 0px -1px 1px 0px;\n}\n.multiline-select-list li {\n  padding: 10px;\n  border: 1px solid;\n  border-color: #eee #ccd0d4;\n  border-top: 0 none;\n  cursor: pointer;\n  line-height: 1.35em;\n  vertical-align: middle;\n}\n.multiline-select-list li:hover,\n.multiline-select-list li:focus,\n.multiline-select-list li:active {\n  background-color: #e5f5fc;\n  outline: 0 none;\n}\n.multiline-select-list li:first-of-type {\n  border-top: 0 none;\n}\n.multiline-select-list li:last-of-type {\n  border-bottom: 0 none;\n}\n.multiline-select-list:hover li:focus {\n  background-color: #fff;\n}\n.multiline-select-list:hover li:focus:hover,\n.multiline-select-list:hover li:focus:active {\n  background-color: #e5f5fc;\n}\n.accessAid,\n#midflash {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n/*\n * HTML elements\n */\nbody {\n  -webkit-tap-highlight-color: transparent;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  background-color: #fff;\n}\na {\n  text-decoration: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0.2);\n}\na:hover,\na:focus {\n  color: #005EA6;\n  text-decoration: underline;\n  outline: none;\n}\na.dashed {\n  text-decoration: none;\n  border-bottom: 1px #0070BA dashed;\n  font-size: 0.9em;\n}\n*[tabindex=\"-1\"] {\n  outline: none;\n}\nem {\n  font-style: normal;\n  font-weight: bold;\n}\nfieldset {\n  margin: 0;\n  padding: 0;\n  border: 0;\n}\nfieldset legend {\n  padding-bottom: 0.5em;\n  font-size: 1.5em;\n}\nsection:focus {\n  outline: none;\n}\n.show-section {\n  display: block;\n}\nhr.faded {\n  width: 100%;\n  height: 1px;\n  margin: 10px 0;\n  border: 0;\n  background-image: -webkit-gradient(linear, left top, right top, color-stop(0, transparent), color-stop(0.5, rgba(0, 0, 0, 0.3)), color-stop(1, transparent));\n  background-image: -webkit-linear-gradient(left, transparent, rgba(0, 0, 0, 0.3), transparent);\n  background-image: -moz-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -ms-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -o-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n}\n.alpha {\n  font-size: 1.50em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin: 0.5em 0;\n  line-height: 1.154em;\n}\n#loginSection h1.alpha {\n  max-width: 240px;\n}\n.asideAlpha {\n  font-size: 1.44em;\n}\naside .aside .header.noButtons .walletHeading {\n  text-align: center;\n  line-height: 1.05em;\n}\n.beta {\n  font-size: 1.54em;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.gamma {\n  font-size: 1.30em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.zeta {\n  font-size: 1.25em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.delta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin-bottom: 12px;\n  font-weight: normal;\n}\n.vprop-header {\n  font-size: 1.60em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin: 10px 0;\n  font-weight: lighter;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  line-height: 1.2em;\n}\n.vprop-content {\n  font-size: 1.0em;\n  font-family: \"HelveticaNeue\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.vprop-image {\n  margin-top: 25px;\n}\n.eta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.theta {\n  font-size: 1.0em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.value-prop-title {\n  color: #2c2e2f;\n  font-size: 24px;\n  font-weight: lighter;\n  margin: 10px 0;\n}\n.props {\n  padding: 0 0 0 5px;\n  clear: both;\n  text-align: center;\n}\n.props p,\n.props li {\n  line-height: 1.154em;\n  font-size: 0.9em;\n  font-weight: normal;\n  line-height: 1.2em;\n  margin: 5px 0;\n}\n.secondary {\n  color: #6C7378;\n  font-size: 0.85em;\n}\n.legal {\n  color: #6C7378;\n  font-size: 0.75em;\n  line-height: 1.154em;\n}\n.legal a {\n  font-weight: bold;\n}\n.mu {\n  font-size: 2.46em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-weight: normal;\n  text-shadow: 0 1px 0 #fff;\n  color: #0079c1;\n}\n/* Single property classes - 0 value or common attributes */\n.noHead {\n  margin-top: 0;\n}\n.noBottom {\n  margin-bottom: 0;\n}\n.showTray #task {\n  overflow: hidden;\n  margin-left: 0;\n}\n.hide,\n#spinner {\n  display: none;\n}\n.clearfix,\nhtml[xmlns] .clearfix,\n.loading #spinner,\n.media .img img {\n  display: block;\n}\n#billingToggleLink {\n  display: inline-block;\n}\n.left {\n  float: left;\n}\n.right {\n  float: right;\n}\n.center {\n  text-align: center;\n}\n/* End single property classes */\n.outerWrapper {\n  position: relative;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-color: #ffffff;\n}\nheader {\n  z-index: 2;\n}\nhtml.framed,\n.framed #wrapper {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\nhtml.framed .trayOpen #main {\n  height: 585px;\n}\nhtml.framed .trayOpen .asideContent {\n  height: 495px;\n}\nbody > iframe,\nbody > img {\n  display: none;\n}\n#wrapper {\n  margin: 0 auto;\n  max-width: 780px;\n  border: 1px solid #e3e3e3;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  overflow-y: visible;\n  outline: none;\n  background-color: #fff;\n}\n#wrapper #header {\n  -webkit-border-radius: 5px 5px 0 0;\n  -moz-border-radius: 5px 5px 0 0;\n  border-radius: 5px 5px 0 0;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  width: 100%;\n  background-color: #fff;\n  z-index: 4;\n  -webkit-box-shadow: 0 0 3px 0;\n  -moz-box-shadow: 0 0 3px 0;\n  box-shadow: 0 0 3px 0;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n#contents {\n  position: relative;\n  z-index: 1;\n}\n.active #wrapper {\n  visibility: visible;\n  -webkit-animation-duration: 400ms;\n  -webkit-animation-timing-function: ease;\n  -webkit-animation-name: slideUp;\n}\n#logo {\n  margin: 22px 0 0 20px;\n}\n.container {\n  clear: both;\n  padding: 20px;\n}\n.containerNoHead {\n  padding-top: 0;\n}\n.noPaddingBottom {\n  padding-bottom: 0;\n}\n.noPaddingTop {\n  padding-top: 0;\n}\n.subContainer {\n  border-top: 1px solid #e3e3e3;\n  padding: 20px 0 20px;\n  position: relative;\n}\n#proceedButton {\n  width: 46.4%;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\n#proceedButton.full {\n  width: 100%;\n}\n#proceedButton:focus {\n  color: #fff;\n}\n#backButton {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n#backButton:hover,\n#backButton:focus {\n  color: #2c2e2f;\n}\n.middleName {\n  display: none;\n  float: right;\n}\n.h2,\nh2 {\n  font-size: 1.2em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  margin-top: 0;\n  font-weight: normal;\n  color: #0666B3;\n}\n.clearfix:after {\n  height: 0;\n  display: block;\n  visibility: hidden;\n  clear: both;\n  overflow: auto;\n  line-height: 0;\n  content: \" \";\n}\n* html .clearfix {\n  height: 1%;\n}\n#sliding-area {\n  overflow: hidden;\n}\n#main {\n  padding: 25px 30px 15px;\n  -webkit-transition: margin 0.3s ease-out;\n  -moz-transition: margin 0.3s ease-out;\n  -ms-transition: margin 0.3s ease-out;\n  -o-transition: margin 0.3s ease-out;\n  transition: margin 0.3s ease-out;\n  width: 100%;\n  float: right;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.loading #main {\n  background: none;\n}\n.loginLoadingMessage,\n.bmlLoadingMessage {\n  display: none;\n}\n.loginProcessing .genericLoadingMessage {\n  display: none;\n}\n.loginProcessing .loginLoadingMessage {\n  display: block;\n}\n.full {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  text-decoration: none;\n}\n.trayInner {\n  padding: 20px 0;\n}\n.disclaimer {\n  font-size: 0.75em;\n  color: #6C7378;\n}\n.reviewMsg {\n  margin-top: 10px;\n  line-height: 1.5;\n}\n.infoTxt {\n  clear: both;\n  padding-top: 10px;\n}\n.help {\n  color: #A9A9A9;\n}\n.keyValue label {\n  color: #292929;\n}\n.frontArrow {\n  position: absolute;\n  display: inline-block;\n  width: 9px;\n  height: 15px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -196px -177px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .frontArrow {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.focusableIcon:focus {\n  box-shadow: 0 0 1px #6C7378;\n}\n.caret-down {\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -233px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .caret-down {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n/* Form styles */\ninput[type=submit],\ninput[type=button] {\n  -webkit-appearance: none;\n}\ninput[disabled=disabled],\n.inputField input[disabled=disabled],\n.inputField input[disabled=disabled]:active {\n  background: #F7F9FA;\n  border: 1px solid #CBD2D6;\n  color: #6C7378;\n}\ninput::-ms-clear {\n  display: none;\n}\ninput.link:hover {\n  cursor: pointer;\n}\ninput.xsmall {\n  width: 2em;\n}\ninput.small {\n  width: 3.35em;\n  font-size: 1em;\n}\ninput.medium {\n  width: 7em;\n}\ninput.large {\n  width: 14em;\n}\ninput.xlarge {\n  width: 20em;\n}\n.button-as-link {\n  margin: 0;\n  padding: 0;\n  border: none;\n  width: auto;\n  font-size: 0.85em;\n  background: transparent;\n  color: #0070BA;\n  cursor: pointer;\n}\n/* Hide spinner on type=number fields */\ninput[type=number]::-webkit-inner-spin-button,\ninput[type=number]::-webkit-outer-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n.buttons {\n  margin-top: 15px;\n  margin-bottom: 15px;\n  overflow: hidden;\n}\n.inputField {\n  position: relative;\n}\n.inputField label,\n.inputField input {\n  display: block;\n  vertical-align: top;\n}\n.inputField input,\n.ignoreValidation .inputField.error input,\n.validated .ignoreValidation .inputField input.ng-invalid,\n.validated .ignoreValidation .inputField input.backendError {\n  width: 100%;\n  height: 44px;\n  padding: 0 14px;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  border: 1px solid #C5CCD1;\n  color: #000;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  background: none;\n}\n.inputField input::-webkit-input-placeholder,\n.ignoreValidation .inputField.error input::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-webkit-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:-moz-placeholder,\n.ignoreValidation .inputField.error input:-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n}\n.inputField input::-moz-placeholder,\n.ignoreValidation .inputField.error input::-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n}\n.inputField input:-ms-input-placeholder,\n.ignoreValidation .inputField.error input:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-ms-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:active,\n.inputField input:focus {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n.inputField select {\n  font-size: 1.5em;\n  margin-bottom: 10px;\n}\n.custom-select-container select {\n  font-size: 15px;\n}\n.inputField label {\n  position: absolute;\n  top: 14px;\n  left: 14px;\n  cursor: text;\n  text-align: left;\n  color: #666;\n  font-size: 1em;\n}\n.no-js .inputField label,\n.no-js .dropdown label {\n  position: static;\n}\n.fieldGroup .inputField {\n  float: left;\n  padding: 0 0.5em 0 0;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.inputField.error input::-webkit-input-placeholder,\n.validated .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .inputField input.backendError::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.inputField.error input:-moz-placeholder,\n.validated .inputField input.ng-invalid:-moz-placeholder,\n.validated .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.inputField.error input::-moz-placeholder,\n.validated .inputField input.ng-invalid::-moz-placeholder,\n.validated .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.inputField.error input:-ms-input-placeholder,\n.validated .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .inputField input.backendError:-ms-input-placeholder {\n  color: #c72e2e;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n  background-size: 40px 8000px, 18px;\n}\n.inputField.valid input {\n  background: #fff url(https://www.paypalobjects.com/images/checkout/hermes/icon_checkmark_wallet_2x.png) no-repeat 98% center;\n  background-size: 14px;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  background-position: -webkit-calc(100% - 10px) center;\n  background-position: right 10px center;\n}\n.creditCardField.valid input {\n  background: #fff;\n}\n.inputField.error select,\n.dropdown.error select {\n  border: 1px solid #c72e2e;\n}\n.selectLabel {\n  display: block;\n}\ninput::-webkit-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 1em;\n}\ninput:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput:-ms-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\n/* End form styles */\n.checkbox input[type=checkbox] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.checkbox input[type=checkbox] ~ label,\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: inline-block;\n  position: static;\n  min-height: 25px;\n  padding-left: 35px;\n  line-height: 27px;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px 0;\n  vertical-align: middle;\n  cursor: pointer;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .checkbox input[type=checkbox] ~ label,\n  .checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 25px;\n  margin-left: -35px;\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.checkbox.error input[type=checkbox] ~ label,\n.checkbox.error input[type=checkbox]:focus ~ label,\n.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.checkbox input[type=checkbox]:checked ~ label,\n.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -400px;\n}\n.checkbox input[type=checkbox]:focus:checked ~ label,\n.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4801px;\n}\n.checkbox input[type=checkbox]:focus ~ label,\n.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4601px;\n}\n.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -800px;\n}\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 25px 25px;\n}\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 0;\n}\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 2600px;\n}\n.validated input[type=checkbox].ng-invalid ~ label,\n.validated input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.validated input[type=radio].ng-invalid + label::before,\n.validated input[type=radio].ng-invalid:focus + label::before,\n.validated input[type=radio].ng-invalid + label.bgImgOnSpan span.bgImg,\n.validated input[type=radio].ng-invalid:focus + label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2200px;\n}\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox {\n  position: relative;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label,\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  line-height: 19px;\n  padding-left: 27px;\n  font-size: 0.85em;\n  background-position: -9px -2600px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 19px;\n  margin-left: -27px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.sCheckbox.checkbox.error input[type=checkbox] ~ label,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3000px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -5409px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2800px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3400px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 18px 19px;\n}\n.radioButton input[type=radio] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.radioButton input[type=radio] ~ label {\n  display: inline-block;\n  min-height: 26px;\n  padding-left: 35px;\n  line-height: 27px;\n  vertical-align: middle;\n  cursor: pointer;\n  position: relative;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label {\n  padding-left: unset;\n  padding-right: 35px;\n}\n.radioButton input[type=radio] ~ label::before {\n  content: \" \";\n  display: block;\n  width: 30px;\n  height: 30px;\n  position: absolute;\n  top: 0;\n  left: 0;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px -1600px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .radioButton input[type=radio] ~ label::before {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label::before,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label::before {\n  right: 0;\n  left: unset;\n}\n.radioButton.error input[type=radio] + label::before,\n.radioButton.error input[type=radio]:focus + label::before {\n  background-position: -9px -2200px;\n}\n.radioButton.warning input[type=radio] + label::before,\n.radioButton.warning input[type=radio]:focus + label::before {\n  background-position: -9px -7405px;\n}\n.radioButton input[type=radio]:checked + label::before {\n  background-position: -9px -2000px;\n}\n.radioButton input[type=radio]:focus:checked + label::before {\n  background-position: -9px -6010px;\n}\n.radioButton input[type=radio]:focus + label::before {\n  background-position: -9px -1800px;\n}\n.inputField label.nolap {\n  position: relative;\n  top: auto;\n  left: auto;\n  color: #2c2e2f;\n}\n.inputField.half {\n  width: 48.15%;\n  margin-right: 3.7%;\n  padding-right: 0;\n}\n.singlePagePaymentForm .inputField.half,\n.multistepSignupForm .inputField.half {\n  width: 48.7%;\n  margin-right: 2.6%;\n  padding-right: 0;\n}\n.inputField.half.issueNo {\n  width: 42%;\n  margin-top: 15px;\n}\n.inputField.half.startDate {\n  width: 54%;\n  margin-right: 10px;\n}\n#cardIssueInfo .inputField.half.startDate {\n  width: 48%;\n  margin-right: 0;\n}\n#cardIssueInfo .inputField.half.issueNo {\n  width: 48%;\n  margin-top: 0;\n  float: right;\n}\n#cardIssueInfo .inputField.half.issueNo:before {\n  content: \"\\200C\";\n}\n.inputField.half.last-child {\n  margin-right: 0;\n}\n.fieldGroup .inputField.last-child {\n  padding-right: 0;\n}\n.fidobDay {\n  width: 30%;\n  float: left;\n}\n.fidobDay .custom-select > span {\n  border-radius: 5px 0 0 5px;\n  border-right: 0;\n}\n.fidobMonth {\n  width: 30%;\n  float: left;\n}\n.fidobMonth .custom-select > span {\n  border-radius: 0px;\n}\n.fidobYear {\n  width: 40%;\n  float: left;\n}\n.fidobYear .custom-select > span {\n  border-radius: 0px 5px 5px 0;\n  border-left: 0;\n}\n.cardDOB {\n  width: 100%;\n  clear: both;\n}\n.dobLabel {\n  top: auto;\n  left: auto;\n  position: relative;\n  display: block;\n  bottom: 4px;\n}\n.dobTXT {\n  margin-top: 10px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .inputField.error input,\n  .validated .inputField input.ng-invalid,\n  .validated .inputField input.backendError {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .validated select.ng-invalid + .custom-select > span,\n  .validated select.backendError + .custom-select > span {\n    background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n    background-size: 40px 8000px, 18px;\n  }\n}\n.submitted input.ng-invalid {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.submitted input.ng-invalid::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-ms-input-placeholder {\n  color: #c72e2e;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .submitted input.ng-invalid {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n.merchantHeader {\n  height: 90px;\n  margin: 0 auto;\n}\n.merchantHeader .headerWrapper {\n  max-width: 780px;\n  margin: 0 auto;\n  overflow: hidden;\n  max-height: 90px;\n  line-height: 90px;\n}\n.merchantHeader .merchantName {\n  font-size: 1.6em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n  width: 575px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  display: inline-block;\n}\n.merchantHeader img {\n  vertical-align: middle;\n}\n.paypalHeaderWrapper .logo {\n  float: left;\n  width: 112px;\n  height: 29px;\n  margin-top: 0;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .paypalHeaderWrapper .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.paypalHeaderWrapper .span14 {\n  padding-bottom: 20px;\n  border-bottom: 1px solid #dbdbdb;\n}\n.paypalHeaderWrapper .cartContainer {\n  position: static;\n  line-height: 29px;\n}\n.paypalHeaderWrapper .transctionCartDetails {\n  z-index: 2;\n}\n.paypalHeaderWrapper.paypalCredit .logo {\n  height: 35px;\n  background-position: 0 -129px;\n}\n.aside .header {\n  padding: 15px;\n  vertical-align: middle;\n  line-height: 50px;\n  border-bottom: 1px solid #e3e3e3;\n}\n.aside .header.tall {\n  min-height: 65px;\n  line-height: normal;\n  padding: 13px 15px 10px;\n  margin-bottom: 0;\n}\n.aside .asideAlpha {\n  padding: 0 30px;\n  text-align: center;\n  line-height: 1.2em;\n}\n.aside .walletHeading {\n  text-align: center;\n}\n.aside .close {\n  position: absolute;\n  top: 10px;\n  right: 15px;\n  width: 19px;\n  height: 19px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .close:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 19px;\n  height: 19px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px 0;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .close:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .close:hover:before,\n.aside .close:focus:before {\n  background-position: -223px -22px;\n}\n.aside .backArrow {\n  position: absolute;\n  top: 10px;\n  left: 15px;\n  width: 9px;\n  height: 18px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .backArrow:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 9px;\n  height: 18px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -232px -46px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .backArrow:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .backArrow:hover:before,\n.aside .backArrow:focus:before {\n  background-position: -232px -68px;\n}\n.aside .addOptions {\n  margin-top: 20px;\n}\n.aside .addOptions h2 {\n  float: left;\n  width: 70%;\n  margin-bottom: 0;\n}\n.aside .addOptions a {\n  float: right;\n  display: block;\n  line-height: 1.9em;\n  font-size: .85em;\n}\n.aside .subHeader {\n  margin-top: 20px;\n}\n.pageSepaAgreementContingency .paypalHeader.span14,\n.pageSepaMandateContingency .paypalHeader.span14,\n.pageSepaMandate .paypalHeader.span14,\n.CYCOPage .paypalHeader.span14 {\n  width: 100%;\n}\n#mobileMerchantHeader {\n  display: none;\n}\n@media (max-width: 41.3125em) {\n  .merchantHeader {\n    display: none;\n  }\n  .paypalHeaderWrapper {\n    height: 65px;\n  }\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -5px;\n    margin-right: 15px;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 30px;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -10px;\n    margin-right: 0;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 0;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n  .header {\n    height: 55px;\n  }\n  .aside .header {\n    height: auto;\n  }\n  .aside .close {\n    right: 15px;\n  }\n}\n.footer {\n  max-width: 780px;\n  margin: 10px auto;\n  font-size: 0.75em;\n}\n.cancelUrl {\n  float: left;\n}\n.micaLender {\n  display: none;\n  color: #2c2e2f;\n  clear: both;\n}\n.footerWrapper {\n  text-align: left;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper {\n    float: right;\n  }\n}\n.footerWrapper table {\n  display: inline;\n  float: left;\n  table-layout: fixed;\n  border: none;\n}\n.footerWrapper tr,\n.footerWrapper th,\n.footerWrapper td {\n  border: none;\n  font-weight: normal;\n  padding-bottom: 0;\n  padding-top: 0;\n  text-align: left;\n}\n.footerWrapper .footerLinks {\n  float: left;\n  border: none;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .footerLinks {\n    margin-right: 1em;\n  }\n}\n.footerWrapper .footerLinks li {\n  padding: 0 0.5em;\n  color: #6C7378;\n}\n.footerWrapper .footerLinks li:first-child {\n  padding-left: 0;\n}\n.footerWrapper .footerLinks li.feedbackLink {\n  color: #0070BA;\n}\n.footerWrapper .footerLinks .underline th {\n  border-bottom: 1px solid #ccc;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .languageToggleDisplay {\n    clear: none;\n    margin-left: 1.5em;\n  }\n  .footerWrapper .languageToggleDisplay::before {\n    border-left: 2px solid #9da3a6;\n    content: \" \";\n    margin: 0 0.15em;\n    display: inline-block;\n    height: 1em;\n    position: absolute;\n    left: 0;\n    top: 50%;\n    transform: translateY(-50%);\n    margin-left: -0.85em;\n  }\n}\n.footerLinks {\n  margin: 0;\n  display: inline-block;\n  text-align: left;\n}\n.footerLinks a {\n  color: #6C7378;\n}\n.footerLinks a.feedbackLink {\n  color: #0070BA;\n  margin-left: 5px;\n}\n.footerLinks th,\ntd {\n  border: none;\n}\n.policyInfoWrapper {\n  color: #6C7378;\n}\n.policyInfoWrapper p.moreInfo {\n  padding: 15px 0 20px 0;\n  float: left;\n}\n.copyright {\n  display: inline;\n  width: auto;\n  float: right;\n  margin: 0;\n  vertical-align: top;\n  color: #6C7378;\n}\n@media screen and (min-width: 41em) {\n  .copyright {\n    float: left;\n  }\n}\n.secureIcon {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: 0 -33px;\n  margin-left: 3px;\n  margin-right: 3px;\n  margin-top: 3px;\n  width: 10px;\n  height: 12px;\n  vertical-align: top;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .secureIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.poweredBy {\n  float: right;\n  margin-top: -49px;\n}\n.poweredBy .text {\n  float: left;\n  margin-top: 8px;\n  margin-right: 8px;\n  font-size: 12px;\n  font-weight: normal;\n  font-style: italic;\n  color: #6c7378;\n}\n.footerLinks li {\n  padding: 0 12px 0 0;\n  display: inline-block;\n}\n.footerLinks .last {\n  padding-right: 18px;\n  border-right: none;\n}\n.footer .policyInfoWrapper p {\n  line-height: 1.3em;\n}\n.footer .policyInfoWrapper p a {\n  font-weight: bold;\n}\n.minibrowser.AU .footer,\n.minibrowser .APAC.footer {\n  position: relative;\n  bottom: 0;\n  width: auto;\n}\n.minibrowser.AU .footer .policyInfoWrapper,\n.minibrowser .APAC.footer .policyInfoWrapper {\n  padding: 0;\n}\n.minibrowser .cancelUrl {\n  display: none;\n}\n.minibrowser .footerWrapper {\n  padding: 0 10px;\n  float: none;\n  width: 95%;\n  margin: 0;\n}\n.minibrowser .footerLinks li {\n  padding: 0 5px 0 0px;\n}\n/*\n//Country specific rules\n.DE, .fr.FR, .fr.CA {\n    .footerWrapper {\n        &:after {\n            height: 0;\n            display: block;\n            visibility: hidden;\n            clear: both;\n            overflow: auto;\n            line-height: 0;\n            content: \" \";\n        }\n    }\n    .footerLinks {\n        float: left;\n        width: 70%;\n        text-align: left;\n        li:first-child {\n            padding-left: 0;\n        }\n    }\n\n    .cancelUrl {\n        float: none;\n        margin: 5px 0;\n        width: 100%;\n    }\n}\n*/\n.APAC .policyInfoWrapper {\n  padding: 5px 0 10px 0;\n}\n.APAC .policyInfoWrapper p.moreInfo {\n  line-height: 1.3em;\n}\n.en_AU .policyInfoWrapper,\n.AU .policyInfoWrapper {\n  padding: 20px 0 10px 0;\n  color: #6C7378;\n}\n.en_AU .policyInfoWrapper p.moreInfo,\n.AU .policyInfoWrapper p.moreInfo {\n  border-bottom: 1px solid #ccc;\n}\n.en_AU .policyInfoWrapper p.moreCopyRight,\n.AU .policyInfoWrapper p.moreCopyRight {\n  padding: 5px 0 0 0;\n  clear: both;\n}\n.fr_XC .footerWrapper {\n  float: left;\n  width: 70%;\n  text-align: left;\n  padding-left: 0;\n  margin-left: -7px;\n}\n@media (max-width: 41.25em) {\n  .footer {\n    border-top: 1px solid #ccc;\n    padding: 5px 20px;\n    margin-top: 10px;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0 10px;\n  }\n  .footerWrapper {\n    padding: 0;\n    margin: 0;\n  }\n  .footerWrapper:after {\n    height: 0;\n    display: block;\n    visibility: hidden;\n    clear: both;\n    overflow: auto;\n    line-height: 0;\n    content: \" \";\n  }\n  .footerLinks {\n    float: left;\n    width: 70%;\n    text-align: left;\n  }\n  .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n  .cancelUrl {\n    float: none;\n    margin: 5px 0;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .footer {\n    margin-top: 0;\n    padding: 0.5em 2em;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0;\n  }\n  .footerWrapper,\n  .cancelUrl {\n    padding: 0;\n    margin: 5px 0px;\n    width: 100%;\n  }\n  .footerLinks,\n  .DE .footerLinks,\n  .fr.FR .footerLinks {\n    width: 65%;\n  }\n  .footerLinks li,\n  .DE .footerLinks li,\n  .fr.FR .footerLinks li {\n    padding: 0;\n    margin-right: 10px;\n  }\n  .footerLinks li.last,\n  .DE .footerLinks li.last,\n  .fr.FR .footerLinks li.last {\n    margin-right: 0;\n  }\n  .footerLinks .feedback,\n  .DE .footerLinks .feedback,\n  .fr.FR .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .copyright {\n    margin-right: 0;\n    width: 30%;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n}\n.modal-open {\n  overflow: hidden;\n}\n.modal-open .outerWrapper,\n.modal-open #wrapper,\n.modal-open #contents {\n  position: static;\n}\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 140;\n  background-color: #000;\n}\n.modal-backdrop.fade {\n  opacity: 0;\n}\n.modal-backdrop,\n.modal-backdrop.fade.in {\n  opacity: 0.54;\n}\n.modal {\n  display: none;\n  overflow: auto;\n  overflow-y: scroll;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 150;\n}\n.modal.fade .modal-wrap {\n  -webkit-transform: translate(0, -25%);\n  -moz-transform: translate(0, -25%);\n  -ms-transform: translate(0, -25%);\n  -o-transform: translate(0, -25%);\n  transform: translate(0, -25%);\n  -webkit-transition: -webkit-transform 0.3s ease-out;\n  -moz-transition: -moz-transform 0.3s ease-out;\n  -o-transition: -o-transform 0.3s ease-out;\n  transition: transform 0.3s ease-out;\n}\n.modal.fade.in .modal-wrap {\n  -webkit-transform: translate(0, 0);\n  -moz-transform: translate(0, 0);\n  -ms-transform: translate(0, 0);\n  -o-transform: translate(0, 0);\n  transform: translate(0, 0);\n}\n.modal-wrap {\n  position: relative;\n  margin: 10px;\n  background-color: #fff;\n  border: 1px solid #999;\n  border: 1px solid rgba(0, 0, 0, 0.3);\n  -webkit-border-radius: 6px;\n  -moz-border-radius: 6px;\n  border-radius: 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  -moz-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  outline: none;\n}\n.modal-header {\n  padding: 9px 15px;\n  border-bottom: 1px solid #eee;\n}\n.modal-header .close {\n  margin-top: 2px;\n}\n.modal-header h3 {\n  margin: 0;\n  line-height: 30px;\n}\n.modal-body {\n  position: relative;\n  overflow-y: auto;\n  max-height: 400px;\n  padding: 15px;\n}\n.modal-form {\n  margin-bottom: 0;\n}\n.modal-footer {\n  padding: 14px 15px 15px;\n  margin-bottom: 0;\n  text-align: right;\n  background-color: #f5f5f5;\n  border-top: 1px solid #ddd;\n  -webkit-border-radius: 0 0 6px 6px;\n  -moz-border-radius: 0 0 6px 6px;\n  border-radius: 0 0 6px 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: inset 0 1px 0 #fff;\n  -moz-box-shadow: inset 0 1px 0 #fff;\n  box-shadow: inset 0 1px 0 #fff;\n}\n.modal-footer:before,\n.modal-footer:after {\n  display: table;\n  content: \"\";\n  line-height: 0;\n}\n.modal-footer:after {\n  clear: both;\n}\n.modal-footer .btn + .btn {\n  margin-left: 5px;\n  margin-bottom: 0;\n}\n.modal-footer .btn-group .btn + .btn {\n  margin-left: -1px;\n}\n.modal-footer .btn-block + .btn-block {\n  margin-left: 0;\n}\n.spinner {\n  height: 100%;\n  width: 100%;\n  position: fixed;\n  z-index: 10;\n}\n.spinner .spinWrap {\n  width: 200px;\n  height: 100px;\n  position: fixed;\n  top: 42%;\n  left: 50%;\n  margin-left: -98px;\n  margin-top: -50px;\n}\n.spinner .spinnerImage {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 28px 0 0 -25px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/icon_ot_spin_lock_skinny.png') no-repeat;\n}\n.spinner .loader {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 0 0 0 -55px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background-color: transparent;\n  -webkit-animation: rotation .7s infinite linear;\n  -moz-animation: rotation .7s infinite linear;\n  -o-animation: rotation .7s infinite linear;\n  animation: rotation .7s infinite linear;\n  border-left: 5px solid #cbcbca;\n  border-right: 5px solid #cbcbca;\n  border-bottom: 5px solid #cbcbca;\n  border-top: 5px solid #2380be;\n  border-radius: 100%;\n}\n.spinner .genericLoadingMessage,\n.spinner .loginLoadingMessage,\n.spinner .bmlLoadingMessage {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  margin-top: 125px;\n  text-align: center;\n  z-index: 100;\n}\n.spinner.preloader {\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 1000;\n  background-color: #fff;\n}\n@-webkit-keyframes rotation {\n  from {\n    -webkit-transform: rotate(0deg);\n  }\n  to {\n    -webkit-transform: rotate(359deg);\n  }\n}\n@-moz-keyframes rotation {\n  from {\n    -moz-transform: rotate(0deg);\n  }\n  to {\n    -moz-transform: rotate(359deg);\n  }\n}\n@-o-keyframes rotation {\n  from {\n    -o-transform: rotate(0deg);\n  }\n  to {\n    -o-transform: rotate(359deg);\n  }\n}\n@keyframes rotation {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(359deg);\n  }\n}\n@media only screen and (max-width: 768px) {\n  .spinner .spinWrap {\n    width: 200px;\n    height: 100px;\n    position: fixed;\n    top: 40%;\n    left: 50%;\n    margin-left: -93px;\n    margin-top: -50px;\n  }\n}\n.aside {\n  min-height: 380px;\n}\n.aside .container {\n  padding: 15px;\n}\n.asideContent {\n  height: 100%;\n}\n.centerText {\n  text-align: center;\n}\n.fsIcons {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  min-width: 32px;\n  width: 25px;\n  height: 21px;\n  padding-right: 5px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.HOLDING .fsIcons,\n.BALANCE .fsIcons,\n.DELAYED_TRANSFER .fsIcons {\n  background-position: 0px 0px;\n}\n.ELO .fsIcons {\n  background-position: 0 -479px;\n}\n.HIPER .fsIcons {\n  background-position: 0 -458px;\n}\n.HIPERCARD .fsIcons {\n  background-position: 0 -500px;\n}\n.EBAY_MASTERCARD .fsIcons {\n  background-position: 0px -606px;\n}\n.PayPal.MasterCard .fsIcons {\n  background-position: 0 -604px;\n}\n.pinlessGlyphIcon {\n  display: inline-block;\n  position: relative;\n  top: -5px;\n  left: -8px;\n  width: 32px;\n  height: 20px;\n  font-size: 3.1rem;\n  padding-right: 5px;\n}\n.IACH .fsIcons,\n.BANK .fsIcons,\n.BANK_ACCOUNT .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.ELV .fsIcons,\n.ECHECK .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n}\n.TAB.DELAYED_TRANSFER .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.BILL_ME_LATER .fsIcons,\n.BML .fsIcons,\n.PPCREDIT .fsIcons,\n.CREDIT_OPTION .fsIcons {\n  background-position: 0 -105px;\n}\n.PAYPAL_SMART_CONNECT .fsIcons {\n  background-position: 0px 0px;\n}\n.VISA .fsIcons {\n  background-position: 0 -21px;\n}\n.MASTERCARD .fsIcons {\n  background-position: 0 -42px;\n}\n.AMEX .fsIcons {\n  background-position: 0 -63px;\n  left: 19px;\n  height: 20px;\n}\n.DISCOVER .fsIcons,\n.DISC .fsIcons {\n  background-position: 0 -84px;\n}\n.JCB .fsIcons {\n  background-position: 0px -353px;\n}\n.CHINA_UNION_PAY .fsIcons {\n  background-position: 0px -563px;\n}\n.ELECTRON .fsIcons {\n  background-position: 0 -146px;\n}\n.MAESTRO .fsIcons,\n.MSTRO .fsIcons,\n.SWITCH .fsIcons {\n  background-position: 0 -168px;\n}\n.CB_NATIONALE .fsIcons,\n.CBN .fsIcons {\n  background-position: 0 -210px;\n}\n.CELEM .fsIcons,\n.CETELEM .fsIcons {\n  background-position: 0 -311px;\n}\n.CONF .fsIcons,\n.COFINOGA .fsIcons {\n  background-position: 0 -231px;\n}\n.COFID .fsIcons,\n.COFIDIS .fsIcons {\n  background-position: 0 -437px;\n  left: 20px;\n}\n.INCENTIVE .fsIcons {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.PPSMTCONNECT .fsIcons {\n  background-position: 0 0;\n}\n.RUPAY .fsIcons {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.fsIcon {\n  display: block;\n  position: absolute;\n  width: 32px;\n  height: 21px;\n  left: 15px;\n  top: 20px;\n  min-width: 32px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  background-position: 0px 0px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.fsIcon.PAYPAL_SMART_CONNECT {\n  background-position: 0 0;\n}\n.fsIcon.PPSMTCONNECT {\n  background-position: 0 0;\n}\n.fsIcon.VISA {\n  background-position: 0 -21px;\n}\n.fsIcon.MASTER,\n.fsIcon.MCARD,\n.fsIcon.MASTERCARD {\n  background-position: 0 -42px;\n}\n.fsIcon.AMEX,\n.fsIcon.Amex {\n  background-position: 6px -63px;\n  left: 19px;\n  height: 20px;\n}\n.fsIcon.DISCOVER,\n.fsIcon.DISC {\n  background-position: 0 -84px;\n}\n.fsIcon.PPCREDIT,\n.fsIcon.BML,\n.fsIcon.BILL_ME_LATER {\n  background-position: 0 -105px;\n}\n.fsIcon.SWITCH,\n.fsIcon.MSTRO,\n.fsIcon.MAESTRO {\n  background-position: 0 -168px;\n}\n.fsIcon.CBN,\n.fsIcon.CB_NATIONALE {\n  background-position: 0 -210px;\n}\n.fsIcon.CONF,\n.fsIcon.COFINOGA {\n  background-position: 0 -231px;\n}\n.fsIcon.BANK,\n.fsIcon.PAD {\n  background-position: 6px -252px;\n  height: 19px;\n  left: 19px;\n}\n.fsIcon.INCENTIVE {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.fsIcon.CELEM,\n.fsIcon.CETELEM {\n  background-position: 0 -311px;\n}\n.fsIcon.JCB {\n  background-position: 0px -353px;\n}\n.fsIcon.COFID,\n.fsIcon.COFIDIS {\n  background-position: 0 -437px;\n  left: 20px;\n  height: 20px;\n}\n.fsIcon.HIPER {\n  background-position: 0 -458px;\n}\n.fsIcon.ELO {\n  background-position: 0 -479px;\n}\n.fsIcon.HIPERCARD {\n  background-position: 0 -500px;\n}\n.fsIcon.CHINA_UNION_PAY,\n.fsIcon.CUP {\n  background-position: 0px -563px;\n}\n.fsIcon.PayPal.MasterCard,\n.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.fsIcon.PPXMCARD {\n  background-position: 0 -584px;\n}\n.fsIcon.EBAY_MASTERCARD,\n.fsIcon.EBAYMCARD {\n  background-position: 0px -605px;\n}\n.fsIcon.CHASEPAY {\n  background-position: 0px -626px;\n  width: 36px;\n  height: 14px;\n  display: inline-block;\n  vertical-align: baseline;\n  position: static;\n  margin-bottom: -1px;\n}\n.fsIcon.pinlessIcon {\n  background-image: none;\n  font-size: 3.1rem;\n  left: 5px;\n  top: 14px;\n}\n.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.PayPal.MasterCard .fsIcons,\n.PayPal.MasterCard .fsIcon,\n.PPXMCARD .fsIcons,\n.PPXMCARD .fsIcon,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcons,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcon {\n  background-position: 0 -584px;\n}\n.fsIcon.BILL_ME_LATER_DE,\n.fsIcons.BILL_ME_LATER_DE {\n  position: static;\n  float: left;\n  background-size: auto;\n  background-image: url(\"https://www.paypalobjects.com/webstatic/credit/img/pp-ratenzahlung-logo.png\");\n  background-repeat: no-repeat;\n  background-position: initial;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n}\n.standardCardIcon.pinlessGlyphIcon {\n  display: inline-block;\n  width: 37.12px;\n  height: 24.36px;\n  font-size: 3.6rem;\n  padding-right: 8px;\n  position: relative;\n}\n.standardCardIcon.pinlessGlyphIcon:before {\n  position: absolute;\n  left: -11px;\n  top: 0px;\n}\n.standardCardIcon.fsIcon {\n  background-size: 42.92px 745.88px;\n  width: 37.12px;\n  height: 24.36px;\n}\n.standardCardIcon.fsIcon.VISA {\n  background-position: 0 -24.36px;\n}\n.standardCardIcon.fsIcon.MASTER,\n.standardCardIcon.fsIcon.MCARD,\n.standardCardIcon.fsIcon.MASTERCARD {\n  background-position: 0 -48.72px;\n}\n.standardCardIcon.fsIcon.AMEX,\n.standardCardIcon.fsIcon.Amex {\n  background-position: 5px -73.08px;\n  height: 23.2px;\n}\n.standardCardIcon.fsIcon.DISCOVER,\n.standardCardIcon.fsIcon.DISC {\n  background-position: 0 -97.44px;\n}\n.standardCardIcon.fsIcon.PPCREDIT,\n.standardCardIcon.fsIcon.BML,\n.standardCardIcon.fsIcon.BILL_ME_LATER {\n  background-position: 0 -121.8px;\n}\n.standardCardIcon.fsIcon.SWITCH,\n.standardCardIcon.fsIcon.MSTRO,\n.standardCardIcon.fsIcon.MAESTRO {\n  background-position: 0 -194.88px;\n}\n.standardCardIcon.fsIcon.CBN,\n.standardCardIcon.fsIcon.CB_NATIONALE {\n  background-position: 0 -243.6px;\n}\n.standardCardIcon.fsIcon.CONF,\n.standardCardIcon.fsIcon.COFINOGA {\n  background-position: 0 -267.96px;\n}\n.standardCardIcon.fsIcon.BANK,\n.standardCardIcon.fsIcon.BANK_ACCOUNT,\n.standardCardIcon.fsIcon.PAD {\n  background-position: 5px -292.32px;\n  height: 22.04px;\n}\n.standardCardIcon.fsIcon.INCENTIVE {\n  background-position: 0 -314.36px;\n  height: 20.88px;\n}\n.standardCardIcon.fsIcon.CELEM,\n.standardCardIcon.fsIcon.CETELEM {\n  background-position: 0 -360.76px;\n}\n.standardCardIcon.fsIcon.JCB {\n  background-position: 0px -409.48px;\n}\n.standardCardIcon.fsIcon.HIPER {\n  background-position: 0px -531.28px;\n}\n.standardCardIcon.fsIcon.ELO {\n  background-position: 0px -555.64px;\n}\n.standardCardIcon.fsIcon.HIPERCARD {\n  background-position: 0px -580px;\n}\n.standardCardIcon.fsIcon.Thirdlast {\n  background-position: 0px -600px;\n}\n.standardCardIcon.fsIcon.COFID,\n.standardCardIcon.fsIcon.COFIDIS {\n  background-position: 0px -506.92px;\n}\n.standardCardIcon.fsIcon.CHINA_UNION_PAY,\n.standardCardIcon.fsIcon.CUP {\n  background-position: 0px -653.08px;\n}\n.standardCardIcon.fsIcon.PayPal.MasterCard,\n.standardCardIcon.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.standardCardIcon.fsIcon.PPXMCARD {\n  background-position: 0 -677.44px;\n}\n.standardCardIcon.fsIcon.EBAY_MASTERCARD,\n.standardCardIcon.fsIcon.EBAYMCARD {\n  background-position: 0 -701.8px;\n}\n.standardCardIcon.fsIcon.CHASEPAY {\n  background-position: 0px -726.16px;\n  width: 36px;\n  height: 14px;\n}\n.standardCardIcon.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.infoIcon {\n  width: 19px;\n  height: 18px;\n  display: inline-block;\n  position: absolute;\n  top: 25px;\n  right: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -89px -1px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .infoIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.addOption {\n  padding: 25px 10px;\n  margin: 0 0 0 44px;\n  color: #0070BA;\n  font-size: .85em;\n}\n.plusicon {\n  display: block;\n  position: absolute;\n  left: 15px;\n  top: 22px;\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -97px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .plusicon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.infoIcon + .checkIcon {\n  display: none;\n}\n.infoMsg {\n  margin: 0;\n  overflow: hidden;\n  font-size: .85em;\n}\n.expiredIcon {\n  background: white url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  top: 6px;\n  position: relative;\n}\n.plccIcon {\n  float: left;\n  display: inline-block;\n  height: 20px;\n  background: none;\n  width: 32px;\n  position: relative;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .fsIcons {\n    height: 20px;\n  }\n  .fsIcon {\n    height: 20px;\n  }\n}\n.walletIcons {\n  position: absolute;\n  width: 30px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .walletIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons_2x.png\");\n    background-size: 90px 970px;\n  }\n}\n.walletIcons.BANK,\n.walletIcons.BANK_ACCOUNT {\n  background-position: -50px -460px;\n}\n.walletIcons.BANK.BOFA,\n.walletIcons.BANK_ACCOUNT.BOFA {\n  background-position: -50px -10px;\n}\n.walletIcons.BANK.CHASE,\n.walletIcons.BANK_ACCOUNT.CHASE {\n  background-position: -50px -130px;\n}\n.walletIcons.BANK.WELLSFARGO,\n.walletIcons.BANK_ACCOUNT.WELLSFARGO {\n  background-position: -50px -100px;\n}\n.walletIcons.BANK.CITI,\n.walletIcons.BANK_ACCOUNT.CITI {\n  background-position: -50px -40px;\n}\n.walletIcons.BANK.FIFTHTHIRD,\n.walletIcons.BANK_ACCOUNT.FIFTHTHIRD {\n  background-position: -50px -220px;\n}\n.walletIcons.BANK.CAPITAL,\n.walletIcons.BANK_ACCOUNT.CAPITAL {\n  background-position: -50px -70px;\n}\n.walletIcons.BANK.AMERITRADE,\n.walletIcons.BANK_ACCOUNT.AMERITRADE {\n  background-position: -50px -160px;\n}\n.walletIcons.BANK.SUNTRUST,\n.walletIcons.BANK_ACCOUNT.SUNTRUST {\n  background-position: -50px -280px;\n}\n.walletIcons.BANK.USBANK,\n.walletIcons.BANK_ACCOUNT.USBANK {\n  background-position: -50px -310px;\n}\n.walletIcons.BANK.USAA,\n.walletIcons.BANK_ACCOUNT.USAA {\n  background-position: -50px -250px;\n}\n.walletIcons.CARD.VISA,\n.walletIcons.PAYMENT_CARD.VISA {\n  background-position: -10px -40px;\n}\n.walletIcons.CARD.MASTER,\n.walletIcons.PAYMENT_CARD.MASTER,\n.walletIcons.CARD.MASTERCARD,\n.walletIcons.PAYMENT_CARD.MASTERCARD {\n  background-position: -10px -70px;\n}\n.walletIcons.CARD.DISCOVER,\n.walletIcons.PAYMENT_CARD.DISCOVER {\n  background-position: -10px -100px;\n}\n.walletIcons.CARD.AMEX,\n.walletIcons.PAYMENT_CARD.AMEX {\n  background-position: -10px -130px;\n}\nhr.sep,\nhr.sepPlain {\n  padding: 0;\n  margin-top: 25px;\n  height: auto;\n  border: none;\n  border-top: 1px solid #ccc;\n  color: #2c2e2f;\n  text-align: center;\n  overflow: visible;\n}\nhr.sep:after,\nhr.sepPlain:after,\nhr.sep::after,\nhr.sepPlain::after {\n  content: \"or\";\n  display: inline-block;\n  position: relative;\n  top: -0.7em;\n  font-size: 1em;\n  padding: 0 0.50em;\n  background: white;\n  color: #6c7378;\n  font-weight: normal;\n}\n.de hr.sep:after,\n.de hr.sep::after {\n  content: \"oder\";\n}\n.da hr.sep:after,\n.da hr.sep::after {\n  content: \"eller\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\n.es hr.sep:after,\n.es hr.sep::after {\n  content: \"o\";\n}\n.fr hr.sep:after,\n.fr hr.sep::after {\n  content: \"ou\";\n}\n.he hr.sep:after,\n.he hr.sep::after {\n  content: \"\\5D0\\5D5\";\n}\n.id hr.sep:after,\n.id hr.sep::after {\n  content: \"Atau\";\n}\n.it hr.sep:after,\n.it hr.sep::after {\n  content: \"oppure\";\n}\n.ja hr.sep:after,\n.ja hr.sep::after {\n  content: \"\\307E\\305F\\306F\";\n}\n.ko hr.sep:after,\n.ko hr.sep::after {\n  content: \"\\B610\\B294\";\n}\n.nl hr.sep:after,\n.nl hr.sep::after {\n  content: \"of\";\n}\n.no hr.sep:after,\n.no hr.sep::after {\n  content: \"eller\";\n}\n.pl hr.sep:after,\n.pl hr.sep::after {\n  content: \"lub\";\n}\n.pt hr.sep:after,\n.pt hr.sep::after {\n  content: \"ou\";\n}\n.ru hr.sep:after,\n.ru hr.sep::after {\n  content: \"\\418\\43B\\438\";\n}\n.sv hr.sep:after,\n.sv hr.sep::after {\n  content: \"eller\";\n}\n.th hr.sep:after,\n.th hr.sep::after {\n  content: \"\\E2B\\E23\\E37\\E2D\";\n}\n.tr hr.sep:after,\n.tr hr.sep::after {\n  content: \"Veya\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\nhr.sepPlain:after,\nhr.sepPlain::after {\n  content: '';\n}\n/*\n * @fileOverview queries.css contains media queries for responsive design/layout breakpoints.\n * @name Queries\n * @author abadri\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n@media (min-width: 0) and (max-width: 23em) {\n  #loginSection .xoTitle h1 {\n    max-width: 10em;\n  }\n}\n@media (min-width: 0) and (max-width: 30em), (max-width: 40em) and (orientation: landscape) {\n  body {\n    -webkit-text-size-adjust: 100%;\n  }\n  .merchantBrand {\n    display: none;\n  }\n  .outerWrapper {\n    background-position: left 50px;\n  }\n  .centerTray.loginSignup {\n    margin-bottom: 60px;\n  }\n  #main {\n    padding: 0;\n    background: none;\n    z-index: 2;\n  }\n  #contents {\n    padding: 0 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  .tokenization #contents {\n    padding: 0 30px;\n  }\n  .paypalHeader {\n    padding: 0 20px 20px 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  .review #wrapper {\n    min-height: 512px;\n  }\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .loginProcessing,\n  .bmlAppProcessing {\n    background-color: #f9f9f9;\n  }\n  .loggingIn {\n    margin: 0 25px;\n  }\n  .mobile .loggingIn {\n    margin: 0;\n  }\n  .saferEasier,\n  .simpler {\n    display: none;\n  }\n  #login .row-fluid {\n    padding-top: 0px;\n  }\n  #login .centerTray {\n    padding: 0;\n  }\n  #login #signupLink.btn {\n    margin: 5px 0;\n  }\n  #wrapper {\n    margin: 0;\n    width: auto;\n    -webkit-border-radius: 0;\n    -moz-border-radius: 0;\n    border-radius: 0;\n    -webkit-background-clip: padding-box;\n    -moz-background-clip: padding-box;\n    background-clip: padding-box;\n    border: none;\n  }\n  #task {\n    width: 295px;\n  }\n  .loading .spinner {\n    background-position-y: 35%;\n  }\n  .centerTray {\n    width: auto;\n  }\n  .tray .inner,\n  .accountTerms .tray .inner {\n    padding: 10px;\n  }\n  .row-fluid > [class*=\"span\"],\n  .signup {\n    width: 100%;\n    margin-left: 0;\n    float: none;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .gamma,\n  .delta {\n    font-size: 1.2em;\n  }\n  .inputField label {\n    left: 7px;\n    top: 13px;\n  }\n  .saferEasier {\n    display: none;\n  }\n  #fundingInstruments .buttons {\n    height: 40px;\n  }\n  .cityState select {\n    font-size: 14px;\n  }\n  .cityState .city {\n    width: 100%;\n  }\n  .cityState .state {\n    width: 55%;\n  }\n  .cityState .postalCode {\n    width: 40.8%;\n  }\n  #tab {\n    margin-top: 0;\n    height: 125px;\n  }\n  .toolTip.whatsthis ul {\n    width: 242px;\n    left: 9px;\n  }\n  .toolTip.whatsthis ul li {\n    font-size: 0.9em;\n  }\n  #expiration.varB .expires {\n    width: 49%;\n  }\n  #expiration .inputField {\n    padding: 0;\n  }\n  #expiration .cvc {\n    width: 44%;\n    float: right;\n  }\n  #expiration.varB .cvc {\n    width: 49%;\n  }\n  .month {\n    margin-left: 46px;\n  }\n  .separator {\n    margin-left: 5px;\n    margin-top: 3px;\n  }\n  .year {\n    margin-left: 0;\n  }\n  #expiration .cardIcon {\n    position: absolute;\n    right: 4px;\n  }\n  .details {\n    margin-right: 2px;\n  }\n  .mask #header,\n  .mask #closeButton {\n    display: none;\n  }\n}\n@media (min-width: 30.0625em) and (max-width: 41.25em) {\n  .row-fluid > .span10,\n  .row-fluid > .span12,\n  .row-fluid > .span14 {\n    width: 100%;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .outerWrapper {\n    background-position: left 59px;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  #wrapper {\n    margin: 0;\n    border: none;\n  }\n  #main {\n    padding: 0;\n  }\n  #contents {\n    padding: 0 25px;\n  }\n}\n@media (min-width: 41.3125em) {\n  .banner {\n    display: block;\n  }\n  #wrapper {\n    min-height: 0;\n    width: 95%;\n  }\n  .merchantHeader,\n  .footer {\n    width: 95%;\n  }\n  .largeScreen .centerTray {\n    margin-top: 0;\n  }\n  .signup {\n    margin-bottom: 0;\n  }\n  #genericError {\n    min-height: 375px;\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/scr_cloud_balloon.png) no-repeat center bottom;\n  }\n  #transactionDetails .merchantName {\n    display: none;\n  }\n}\n@media (device-height: 568px) and (-webkit-min-device-pixel-ratio: 2) {\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .pageLanding #contents {\n    margin: 70px auto 40px 0px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .cardType {\n    display: none;\n  }\n  ul.validations li.restriction.active {\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/close3_2x.png) no-repeat 0 2px;\n    background-size: 10px;\n  }\n  .inputField.error input {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .inputField.error input,\n  .inputField.valid input {\n    background-position: -webkit-calc(100% - 10px) center;\n    background-position: right 10px center;\n  }\n  .error .custom-select > span,\n  .error .custom-select.active > span {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2) and (min-width: 41.3125em) {\n  #genericError {\n    background-size: 640px 242px;\n  }\n}\n/*\n    .within-rtl({ ... });\n    Targets rules for both xoon and hermes, when RTL applies\n*/\n*[dir=\"rtl\"] .footerWrapper .footerLinks,\n.outerWrapper.rtl .footerWrapper .footerLinks {\n  float: right;\n}\n*[dir=\"rtl\"] .footerWrapper .footerLinks li:first-child,\n.outerWrapper.rtl .footerWrapper .footerLinks li:first-child {\n  padding-left: 12px;\n}\n@media screen and (max-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: none;\n    clear: both;\n  }\n}\n@media screen and (min-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: left;\n  }\n  *[dir=\"rtl\"] .footerWrapper .languageToggleDisplay::before,\n  .outerWrapper.rtl .footerWrapper .languageToggleDisplay::before {\n    right: 0;\n    margin-left: 0.85em;\n  }\n}\n*[dir=\"rtl\"] .paypalHeader .languageToggleDisplay,\n.outerWrapper.rtl .paypalHeader .languageToggleDisplay {\n  float: right;\n}\n.inputField.floatingLabel input {\n  height: 49px;\n}\n.inputField.floatingLabel select {\n  height: 48px;\n  font-size: 15px;\n}\n.inputField.floatingLabel select:focus ~ label.hide,\n.inputField.floatingLabel select.focused ~ label.hide {\n  display: none;\n}\n.inputField.floatingLabel.dropdown label {\n  color: transparent;\n}\n.inputField.floatingLabel.dropdown .custom-select span {\n  padding: 0 14px;\n  position: relative;\n  height: 47px;\n}\n.inputField.floatingLabel.dropdown .custom-select span span {\n  top: 18px;\n  padding: 0;\n}\n.inputField.floatingLabel.dropdown .custom-select span span.noValue {\n  top: 9px;\n}\n.inputField.floatingLabel input:focus,\n.inputField.floatingLabel select:focus,\n.inputField.floatingLabel input.focused,\n.inputField.floatingLabel select.focused {\n  padding-top: 16px;\n}\n.inputField.floatingLabel input:focus::-webkit-input-placeholder,\n.inputField.floatingLabel select:focus::-webkit-input-placeholder,\n.inputField.floatingLabel input.focused::-webkit-input-placeholder,\n.inputField.floatingLabel select.focused::-webkit-input-placeholder {\n  color: #6C7378;\n}\n.inputField.floatingLabel input:focus:-moz-placeholder,\n.inputField.floatingLabel select:focus:-moz-placeholder,\n.inputField.floatingLabel input.focused:-moz-placeholder,\n.inputField.floatingLabel select.focused:-moz-placeholder {\n  color: #6C7378;\n}\n.inputField.floatingLabel input:focus::-moz-placeholder,\n.inputField.floatingLabel select:focus::-moz-placeholder,\n.inputField.floatingLabel input.focused::-moz-placeholder,\n.inputField.floatingLabel select.focused::-moz-placeholder {\n  color: #6C7378;\n}\n.inputField.floatingLabel input:focus:-ms-input-placeholder,\n.inputField.floatingLabel select:focus:-ms-input-placeholder,\n.inputField.floatingLabel input.focused:-ms-input-placeholder,\n.inputField.floatingLabel select.focused:-ms-input-placeholder {\n  color: #6C7378;\n}\n.inputField.floatingLabel input:focus ~ label,\n.inputField.floatingLabel select:focus ~ label,\n.inputField.floatingLabel input.focused ~ label,\n.inputField.floatingLabel select.focused ~ label {\n  color: #0070BA;\n  -webkit-transform: translate3d(0, -7px, 0) scale(0.8);\n  transform: translate3d(0, -7px, 0) scale(0.8);\n  text-overflow: ellipsis;\n  overflow-x: hidden;\n  width: 100%;\n  display: inline-block;\n  white-space: nowrap;\n}\n.inputField.floatingLabel input.focused:not(:focus) ~ label,\n.inputField.floatingLabel select.focused:not(:focus) ~ label {\n  color: #6C7378;\n}\n.inputField.floatingLabel input::-webkit-input-placeholder,\n.inputField.floatingLabel select::-webkit-input-placeholder {\n  color: transparent;\n}\n.inputField.floatingLabel input:-moz-placeholder,\n.inputField.floatingLabel select:-moz-placeholder {\n  color: transparent;\n}\n.inputField.floatingLabel input::-moz-placeholder,\n.inputField.floatingLabel select::-moz-placeholder {\n  color: transparent;\n}\n.inputField.floatingLabel input:-ms-input-placeholder,\n.inputField.floatingLabel select:-ms-input-placeholder {\n  color: transparent;\n}\n.inputField.floatingLabel label {\n  color: #6C7378;\n  position: absolute;\n  top: 14px;\n  left: 14px;\n  pointer-events: none;\n  -webkit-transform: translate3d(0, 0, 0) scale(1);\n  transform: translate3d(0, 0, 0) scale(1);\n  transform-origin: left top 0px;\n  transition: all 0.25s ease-in-out;\n  text-overflow: ellipsis;\n  overflow-x: hidden;\n  width: 90%;\n  display: inline-block;\n  white-space: nowrap;\n}\n.validated .inputField.floatingLabel input.ng-invalid:focus::-webkit-input-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid:focus::-webkit-input-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid:focus::-webkit-input-placeholder,\n.validated .inputField.floatingLabel input.ng-invalid.focused::-webkit-input-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid.focused::-webkit-input-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid.focused::-webkit-input-placeholder {\n  color: #6C7378;\n}\n.validated .inputField.floatingLabel input.ng-invalid:focus:-moz-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid:focus:-moz-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid:focus:-moz-placeholder,\n.validated .inputField.floatingLabel input.ng-invalid.focused:-moz-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid.focused:-moz-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid.focused:-moz-placeholder {\n  color: #6C7378;\n}\n.validated .inputField.floatingLabel input.ng-invalid:focus::-moz-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid:focus::-moz-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid:focus::-moz-placeholder,\n.validated .inputField.floatingLabel input.ng-invalid.focused::-moz-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid.focused::-moz-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid.focused::-moz-placeholder {\n  color: #6C7378;\n}\n.validated .inputField.floatingLabel input.ng-invalid:focus:-ms-input-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid:focus:-ms-input-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid:focus:-ms-input-placeholder,\n.validated .inputField.floatingLabel input.ng-invalid.focused:-ms-input-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid.focused:-ms-input-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid.focused:-ms-input-placeholder {\n  color: #6C7378;\n}\n.validated .inputField.floatingLabel input.ng-invalid:not(:focus):not(.focused) ~ label,\n.validated .inputField.floatingLabelDropdown input.ng-invalid:not(:focus):not(.focused) ~ label,\n.validated .inputField.noFloatingLabel input.ng-invalid:not(:focus):not(.focused) ~ label {\n  color: #c72e2e;\n}\n.validated .inputField.floatingLabel input.ng-invalid::-webkit-input-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid::-webkit-input-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid::-webkit-input-placeholder {\n  color: transparent;\n}\n.validated .inputField.floatingLabel input.ng-invalid:-moz-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid:-moz-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid:-moz-placeholder {\n  color: transparent;\n}\n.validated .inputField.floatingLabel input.ng-invalid::-moz-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid::-moz-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid::-moz-placeholder {\n  color: transparent;\n}\n.validated .inputField.floatingLabel input.ng-invalid:-ms-input-placeholder,\n.validated .inputField.floatingLabelDropdown input.ng-invalid:-ms-input-placeholder,\n.validated .inputField.noFloatingLabel input.ng-invalid:-ms-input-placeholder {\n  color: transparent;\n}\n.validated .inputField.floatingLabel input.ng-invalid ~ label,\n.validated .inputField.floatingLabelDropdown input.ng-invalid ~ label,\n.validated .inputField.noFloatingLabel input.ng-invalid ~ label {\n  color: #c72e2e;\n}\n.validated .inputField.floatingLabel input.ng-invalid ~ label.hide,\n.validated .inputField.floatingLabelDropdown input.ng-invalid ~ label.hide,\n.validated .inputField.noFloatingLabel input.ng-invalid ~ label.hide {\n  color: transparent;\n}\n.validated .inputField.noFloatingLabel input.ng-invalid.focused ~ label {\n  color: transparent;\n}\n/* pxp control group styling */\n.inputField.noFloatingLabel label {\n  color: transparent;\n  left: 14px;\n  text-overflow: ellipsis;\n  overflow-x: hidden;\n  width: 90%;\n  white-space: nowrap;\n  pointer-events: none;\n}\n.inputField.noFloatingLabel input {\n  height: 49px;\n}\n.inputField.noFloatingLabel input::-webkit-input-placeholder {\n  color: transparent;\n}\n.inputField.noFloatingLabel input:-moz-placeholder {\n  color: transparent;\n}\n.inputField.noFloatingLabel input::-moz-placeholder {\n  color: transparent;\n}\n.inputField.noFloatingLabel input:-ms-input-placeholder {\n  color: transparent;\n}\n.inputField.noFloatingLabel input:focus.focused ~ label {\n  color: transparent;\n}\n.inputField.noFloatingLabel input:not(.focused):focus ~ label {\n  color: #6C7378;\n}\n.inputField.noFloatingLabel input:not(.focused):focus.hasPlaceholder ~ label {\n  color: transparent;\n}\n.inputField.noFloatingLabel input:not(.focused):focus.hasPlaceholder::-webkit-input-placeholder {\n  color: #6C7378;\n}\n.inputField.noFloatingLabel input:not(.focused):focus.hasPlaceholder:-moz-placeholder {\n  color: #6C7378;\n}\n.inputField.noFloatingLabel input:not(.focused):focus.hasPlaceholder::-moz-placeholder {\n  color: #6C7378;\n}\n.inputField.noFloatingLabel input:not(.focused):focus.hasPlaceholder:-ms-input-placeholder {\n  color: #6C7378;\n}\n.inputField.noFloatingLabel input:not(:focus):not(.focused) ~ label {\n  color: #6C7378;\n}\n.inputField.noFloatingLabel select {\n  height: 48px;\n  font-size: 15px;\n}\n.inputField.noFloatingLabel select:focus ~ label,\n.inputField.noFloatingLabel select.focused ~ label {\n  color: transparent;\n}\n.inputField.noFloatingLabel .custom-select span {\n  padding: 0 14px;\n  position: relative;\n  height: 47px;\n}\n.inputField.noFloatingLabel .custom-select span span {\n  top: 11px;\n  padding: 0;\n}\n.inputField.noFloatingLabel#nationalityDropDown,\n.inputField.noFloatingLabel#countryOfResidenceDropDown {\n  min-height: 87px;\n}\n.inputField.noFloatingLabel#nationalityDropDown select,\n.inputField.noFloatingLabel#countryOfResidenceDropDown select,\n.inputField.noFloatingLabel#nationalityDropDown .custom-select,\n.inputField.noFloatingLabel#countryOfResidenceDropDown .custom-select {\n  top: 20px;\n}\n.inputField.noFloatingLabel#nationalityDropDown label,\n.inputField.noFloatingLabel#countryOfResidenceDropDown label {\n  color: #6C7378;\n  top: 0px;\n  left: 0px;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!../node_modules/xo-ui-components/src/generic-error/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/**\n* @fileOverview Base contains variables, mixins, reset, baseline, grid, and utilities\n* @name Base\n* @author hdoan\n* @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n*/\n/**\n * @fileOverview Variables contains variables\n * @name Variables\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Fonts */\n/* Colors */\n/**\n * @fileOverview Mixins contains mixins\n * @name Mixins\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/**\n * @fileOverview Reset contains reset and baseline styles\n * @name Reset\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Reset ====================================== */\nhtml,\nbody,\ndiv,\ndl,\ndt,\ndd,\nul,\nol,\nli,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\npre,\ncode,\nform,\nfieldset,\nlegend,\ninput,\ntextarea,\np,\nblockquote,\nth,\ntd {\n  margin: 0;\n  padding: 0;\n}\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\nfieldset,\nimg {\n  border: 0;\n}\naddress,\ncaption,\ncite,\ncode,\ndfn,\nem,\nstrong,\nth,\nvar {\n  font-style: normal;\n  font-weight: normal;\n}\nol,\nul {\n  list-style: none;\n}\ncaption,\nth {\n  text-align: left;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6 {\n  font-size: 100%;\n  font-weight: normal;\n}\nq:before,\nq:after {\n  content: \"\";\n}\nabbr,\nacronym {\n  border: 0;\n  font-variant: normal;\n}\n/* to preserve line-height and selector appearance */\nsup {\n  vertical-align: text-top;\n}\nsub {\n  vertical-align: text-bottom;\n}\ninput,\ntextarea,\nselect {\n  font-family: inherit;\n  font-size: inherit;\n  font-weight: inherit;\n}\n/*to enable resizing for IE*/\ninput,\ntextarea,\nselect {\n  *font-size: 100%;\n}\n/*because legend doesn't inherit in IE */\nlegend {\n  color: #000;\n}\n/* Start of base-lining, some from YUI's CSS Foundation ==================== */\nbody {\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 95%;\n  /* Base font-size is 15px */\n  color: #2c2e2f;\n  line-height: 1.35em;\n}\nh1 {\n  /*18px via YUI Fonts CSS foundation*/\n  font-size: 138.5%;\n}\nh2 {\n  /*16px via YUI Fonts CSS foundation*/\n  font-size: 123.1%;\n}\nh3 {\n  /*14px via YUI Fonts CSS foundation*/\n  font-size: 108%;\n}\nh1,\nh2,\nh3 {\n  /* top & bottom margin based on font size */\n  margin: 1em 0;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\nstrong {\n  /*bringing boldness back to headers and the strong element*/\n  font-weight: bold;\n}\na {\n  color: #0070BA;\n}\nabbr,\nacronym {\n  /*indicating to users that more info is available */\n  border-bottom: 1px dotted #000;\n  cursor: help;\n}\nem {\n  /*bringing italics back to the em element*/\n  font-style: italic;\n}\nblockquote,\nul,\nol,\ndl {\n  /*giving blockquotes and lists room to breath*/\n  margin: 1em;\n}\nol,\nul,\ndl {\n  /*bringing lists on to the page with breathing room */\n  margin-left: 2em;\n}\nol {\n  /*giving OL's LIs generated numbers*/\n  list-style: decimal outside;\n}\nul {\n  /*giving UL's LIs generated disc markers*/\n  list-style: disc outside;\n}\ndl dd {\n  /*providing spacing for definition terms*/\n  margin-left: 1em;\n}\nth,\ntd {\n  /*borders and padding to make the table readable*/\n  border: 1px solid #000;\n  padding: .5em;\n}\nth {\n  /*distinguishing table headers from data cells*/\n  font-weight: bold;\n  text-align: center;\n}\ninput {\n  margin-bottom: 10px;\n}\ncaption {\n  /*coordinated margin to match cell's padding*/\n  margin-bottom: .5em;\n  /*centered so it doesn't blend in to other content*/\n  text-align: center;\n}\np,\nfieldset,\ntable,\npre,\nlegend {\n  /*so things don't run into each other*/\n  margin-bottom: 1em;\n}\n/* setting a consistent width, 160px;\n   control of type=file still not possible */\ninput[type=text],\ninput[type=password],\ntextarea {\n  width: 12.25em;\n  *width: 11.9em;\n}\n/**\n * @fileOverview Grid contains grid rules\n * @name Grid\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n.row-fluid {\n  width: 100%;\n  *zoom: 1;\n}\n.row-fluid:before,\n.row-fluid:after {\n  display: table;\n  content: \"\";\n}\n.row-fluid:after {\n  clear: both;\n}\n.row-fluid > [class*=\"span\"] {\n  float: left;\n  margin-left: 4.127659574%;\n}\n.row-fluid > [class*=\"span\"]:first-child {\n  margin-left: 0;\n}\n.row-fluid > .span24 {\n  width: 99.999999978%;\n}\n.row-fluid > .span23 {\n  width: 95.74468083%;\n}\n.row-fluid > .span22 {\n  width: 91.48936168200001%;\n}\n.row-fluid > .span21 {\n  width: 87.234042534%;\n}\n.row-fluid > .span20 {\n  width: 82.97872338599998%;\n}\n.row-fluid > .span19 {\n  width: 78.723404238%;\n}\n.row-fluid > .span18 {\n  width: 74.46808508999999%;\n}\n.row-fluid > .span17 {\n  width: 70.212765942%;\n}\n.row-fluid > .span16 {\n  width: 65.95744679399999%;\n}\n.row-fluid > .span15 {\n  width: 61.702127646%;\n}\n.row-fluid > .span14 {\n  width: 54.446808497999996%;\n}\n.row-fluid > .span13 {\n  width: 53.19148935%;\n}\n.row-fluid > .span12 {\n  width: 48.936170202%;\n}\n.row-fluid > .span11 {\n  width: 44.680851054%;\n}\n.row-fluid > .span10 {\n  width: 40.425531905999996%;\n}\n.row-fluid > .span9 {\n  width: 36.170212758%;\n}\n.row-fluid > .span8 {\n  width: 31.91489361%;\n}\n.row-fluid > .span7 {\n  width: 27.659574462000002%;\n}\n.row-fluid > .span6 {\n  width: 23.404255313999997%;\n}\n.row-fluid > .span5 {\n  width: 19.148936166%;\n}\n.row-fluid > .span4 {\n  width: 14.893617018%;\n}\n.row-fluid > .span3 {\n  width: 10.638297869999999%;\n}\n.row-fluid > .span2 {\n  width: 6.382978722%;\n}\n.row-fluid > .span1 {\n  width: 2.127659574%;\n}\n.container-fluid {\n  padding-left: 20px;\n  padding-right: 20px;\n  *zoom: 1;\n}\n.container-fluid:before,\n.container-fluid:after {\n  display: table;\n  content: \"\";\n}\n.container-fluid:after {\n  clear: both;\n}\n.mt10 {\n  margin-top: 10px;\n}\n.mt15 {\n  margin-top: 10px;\n}\n.pt10 {\n  padding-top: 10px;\n}\n.pt15 {\n  padding-top: 15px;\n}\n.mb10 {\n  margin-bottom: 10px;\n}\n.mb15 {\n  margin-bottom: 15px;\n}\n.pb10 {\n  padding-bottom: 10px;\n}\n.pb15 {\n  padding-bottom: 15px;\n}\n.ml10 {\n  margin-left: 10px;\n}\n.ml15 {\n  margin-left: 15px;\n}\n.pl10 {\n  padding-left: 10px;\n}\n.pl15 {\n  padding-left: 15px;\n}\n.mr10 {\n  margin-right: 10px;\n}\n.mr15 {\n  margin-right: 15px;\n}\n.pr10 {\n  padding-right: 10px;\n}\n.pr15 {\n  padding-right: 15px;\n}\n/* Button styles */\n.btn {\n  height: 44px;\n  margin-bottom: 0;\n  border-style: solid;\n  border-width: 1px;\n  border-color: #0070BA;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  *margin-left: .3em;\n  display: inline-block;\n  /* IE7 inline-block hack */\n  *display: inline;\n  *zoom: 1;\n  background-color: #0070BA;\n  -webkit-transition: background-color 0.4s ease-out 0s;\n  -moz-transition: background-color 0.4s ease-out 0s;\n  -ms-transition: background-color 0.4s ease-out 0s;\n  -o-transition: background-color 0.4s ease-out 0s;\n  transition: background-color 0.4s ease-out 0s;\n  font-size: 1.0em;\n  font-weight: bold;\n  line-height: 42px;\n  color: #fff;\n  text-align: center;\n  vertical-align: middle;\n  cursor: pointer;\n  outline: none;\n  -webkit-font-smoothing: antialiased;\n}\n.btn .btn-secondary {\n  -webkit-font-smoothing: auto;\n}\n.btn:hover,\n.btn:focus {\n  background-color: #005EA6;\n}\n.btn:focus {\n  text-decoration: underline;\n}\n.btn.active,\n.btn:active {\n  background-color: #005EA6;\n  outline: 0;\n}\n.btn.disabled,\n.btn[disabled] {\n  background-color: #B2D9EA;\n  border-color: #B2D9EA;\n  cursor: default;\n}\n.btn.firstHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n.btn.secondHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\na.btn:focus,\na.btn:hover {\n  color: #fff;\n}\n.btn:first-child {\n  *margin-left: 0;\n}\n.btn-large {\n  padding: 8px 15px;\n  font-size: 18px;\n  line-height: normal;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n}\n.btn-small {\n  padding: 5px 9px;\n  font-size: 11px;\n  line-height: 16px;\n}\n.btn-mini {\n  padding: 2px 6px;\n  font-size: 11px;\n  line-height: 14px;\n}\n.btn-secondary {\n  border-style: solid;\n  border-color: #E1E7Eb;\n  color: #393F44;\n  background-color: #E1E7Eb;\n}\n.btn-secondary:hover {\n  color: #393F44;\n  border-color: #EDF2F5;\n  background-color: #EDF2F5;\n  text-decoration: none;\n}\n.btn-secondary:active,\n.btn-secondary:focus {\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n  text-decoration: underline;\n}\n.btn-secondary.disabled,\n.btn-secondary[disabled] {\n  color: #393F55;\n}\na.btn-secondary:hover,\na.btn-secondary:focus,\na.btn-secondary:active {\n  color: #393F44;\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n}\na.btn-secondary.disabled,\na.btn-secondary[disabled] {\n  color: #393F55;\n  background-color: #E7EDF0;\n}\nbutton.btn,\ninput[type=\"submit\"].btn {\n  *padding-top: 2px;\n  *padding-bottom: 2px;\n}\nbutton.btn::-moz-focus-inner,\ninput[type=\"submit\"].btn::-moz-focus-inner {\n  padding: 0;\n  border: 0;\n}\nbutton.btn.btn-large,\ninput[type=\"submit\"].btn.btn-large {\n  *padding-top: 7px;\n  *padding-bottom: 7px;\n}\nbutton.btn.btn-small,\ninput[type=\"submit\"].btn.btn-small {\n  *padding-top: 3px;\n  *padding-bottom: 3px;\n}\nbutton.btn.btn-mini,\ninput[type=\"submit\"].btn.btn-mini {\n  *padding-top: 1px;\n  *padding-bottom: 1px;\n}\nsection .buttons #backButton,\n#largeScreenAccountCreation .buttons #backButton {\n  width: 30%;\n}\nsection .buttons #proceedButton,\n#largeScreenAccountCreation .buttons #proceedButton {\n  width: 65%;\n}\nsection .buttons #proceedButton.full,\n#largeScreenAccountCreation .buttons #proceedButton.full {\n  width: 100%;\n}\nsection .buttons #proceedButton-venmoBA,\n#largeScreenAccountCreation .buttons #proceedButton-venmoBA {\n  width: 100%;\n}\n/* mixin for Select element - Dropdowns\n    *\n    * We style native select element on web and it uses native element on other devices\n    * HTML Format to use for select element:\n    *   <div class=\"dropdown\">\n    *           <label for=\"selectID\" class=\"accessAid\" id=\"forSelectID\">Select Label</label>\n    *           <select id=\"selectID\" name=\"selectID\">\n    *               <option value=\"\">Option 1</option>\n    *               <option value=\"2\">Option 2</option>\n    *           </select>\n    *       </div>\n    *\n    * @param width - defines the width of the select dropdown on form\n*/\n.custom-select-container {\n  position: relative;\n}\n/* Set the dimensions of the replaced select element and make it transparent. */\nselect.replaced {\n  position: relative;\n  z-index: 8;\n  width: 100%;\n  height: 44px;\n  border: 0;\n  line-height: 2;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  /* Move to IE-speci    fic CSS file if you want to. */\n}\n.custom-select {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 1;\n  display: block;\n  width: 100%;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.custom-select > span {\n  display: block;\n  padding: 7px 30px 7px 13px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: right -7px top -1178px;\n  color: #000;\n  line-height: 28px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .custom-select > span {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.disabled .custom-select > span {\n  background-position: right -7px top -6990px;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat right 10px center;\n  background-size: 16px;\n  color: #c72e2e;\n  border: 1px solid #c72e2e;\n}\n.custom-select span span {\n  display: block;\n  overflow: hidden;\n  height: 28px;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-size: 1em;\n}\n.custom-select.active > span {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n#task .custom-select {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.mobile .dob label {\n  position: static;\n  top: 0;\n  left: 0;\n}\ninput[type=date] {\n  padding: 5px 38px 3px 6px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  color: #333;\n  background-size: 24px;\n  background: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_cart_icons.png\") no-repeat 100% 61%;\n}\ninput[type=date]:focus {\n  border-color: #3399ff;\n}\n.showDropdopwnLabels .labelText {\n  float: left;\n  color: #aaa;\n}\n.showDropdopwnLabels .valueText {\n  float: right;\n  min-width: 90px;\n}\n@media (min-width: 0) and (max-width: 40em) {\n  .showDropdopwnLabels .labelText {\n    display: none;\n  }\n  .showDropdopwnLabels .valueText {\n    float: none;\n    min-width: 0;\n  }\n}\n.multiline-select-container {\n  outline: 0 none;\n}\n.multiline-select-container:active .innerContainer,\n.multiline-select-container:focus .innerContainer {\n  border-color: #009cde;\n}\n.multiline-select-container.open:active .innerContainer,\n.multiline-select-container.open:focus .innerContainer {\n  border-color: #ccd0d4;\n}\n.multiline-select-container option,\n.multiline-select-container select {\n  position: absolute !important;\n  left: -9999px;\n}\n.multiline-select-container .custom-select {\n  position: relative;\n}\n.multiline-select-container .custom-select span span {\n  height: auto;\n  white-space: initial;\n}\n.multiline-select-container .custom-select > span {\n  background: none;\n}\n.multiline-select-container.open .custom-select > span {\n  border-radius: 5px 5px 0 0;\n  border-bottom-color: #eee;\n}\n.multiline-select-container .arrow {\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_forms.png\");\n  background-position: left -8px top -1198px;\n  background-repeat: no-repeat;\n  height: 10px;\n  position: absolute;\n  width: 14px;\n  top: 40%;\n  right: 12px;\n}\n.validated .multiline-select-container .ng-invalid + .custom-select .arrow,\n.backendError .multiline-select-container .ng-invalid + .custom-select .arrow {\n  display: none;\n}\n.multiline-select-list {\n  position: absolute;\n  list-style: none;\n  margin: 0;\n  background-color: #fff;\n  z-index: 1000;\n  border-radius: 0 0 5px 5px;\n  border-bottom: 1px solid #ccd0d4;\n  max-height: 200px;\n  overflow: auto;\n  box-shadow: #ccc 0px -1px 1px 0px;\n}\n.multiline-select-list li {\n  padding: 10px;\n  border: 1px solid;\n  border-color: #eee #ccd0d4;\n  border-top: 0 none;\n  cursor: pointer;\n  line-height: 1.35em;\n  vertical-align: middle;\n}\n.multiline-select-list li:hover,\n.multiline-select-list li:focus,\n.multiline-select-list li:active {\n  background-color: #e5f5fc;\n  outline: 0 none;\n}\n.multiline-select-list li:first-of-type {\n  border-top: 0 none;\n}\n.multiline-select-list li:last-of-type {\n  border-bottom: 0 none;\n}\n.multiline-select-list:hover li:focus {\n  background-color: #fff;\n}\n.multiline-select-list:hover li:focus:hover,\n.multiline-select-list:hover li:focus:active {\n  background-color: #e5f5fc;\n}\n.accessAid,\n#midflash {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n/*\n * HTML elements\n */\nbody {\n  -webkit-tap-highlight-color: transparent;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  background-color: #fff;\n}\na {\n  text-decoration: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0.2);\n}\na:hover,\na:focus {\n  color: #005EA6;\n  text-decoration: underline;\n  outline: none;\n}\na.dashed {\n  text-decoration: none;\n  border-bottom: 1px #0070BA dashed;\n  font-size: 0.9em;\n}\n*[tabindex=\"-1\"] {\n  outline: none;\n}\nem {\n  font-style: normal;\n  font-weight: bold;\n}\nfieldset {\n  margin: 0;\n  padding: 0;\n  border: 0;\n}\nfieldset legend {\n  padding-bottom: 0.5em;\n  font-size: 1.5em;\n}\nsection:focus {\n  outline: none;\n}\n.show-section {\n  display: block;\n}\nhr.faded {\n  width: 100%;\n  height: 1px;\n  margin: 10px 0;\n  border: 0;\n  background-image: -webkit-gradient(linear, left top, right top, color-stop(0, transparent), color-stop(0.5, rgba(0, 0, 0, 0.3)), color-stop(1, transparent));\n  background-image: -webkit-linear-gradient(left, transparent, rgba(0, 0, 0, 0.3), transparent);\n  background-image: -moz-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -ms-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -o-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n}\n.alpha {\n  font-size: 1.50em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin: 0.5em 0;\n  line-height: 1.154em;\n}\n#loginSection h1.alpha {\n  max-width: 240px;\n}\n.asideAlpha {\n  font-size: 1.44em;\n}\naside .aside .header.noButtons .walletHeading {\n  text-align: center;\n  line-height: 1.05em;\n}\n.beta {\n  font-size: 1.54em;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.gamma {\n  font-size: 1.30em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.zeta {\n  font-size: 1.25em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.delta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin-bottom: 12px;\n  font-weight: normal;\n}\n.vprop-header {\n  font-size: 1.60em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin: 10px 0;\n  font-weight: lighter;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  line-height: 1.2em;\n}\n.vprop-content {\n  font-size: 1.0em;\n  font-family: \"HelveticaNeue\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.vprop-image {\n  margin-top: 25px;\n}\n.eta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.theta {\n  font-size: 1.0em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.value-prop-title {\n  color: #2c2e2f;\n  font-size: 24px;\n  font-weight: lighter;\n  margin: 10px 0;\n}\n.props {\n  padding: 0 0 0 5px;\n  clear: both;\n  text-align: center;\n}\n.props p,\n.props li {\n  line-height: 1.154em;\n  font-size: 0.9em;\n  font-weight: normal;\n  line-height: 1.2em;\n  margin: 5px 0;\n}\n.secondary {\n  color: #6C7378;\n  font-size: 0.85em;\n}\n.legal {\n  color: #6C7378;\n  font-size: 0.75em;\n  line-height: 1.154em;\n}\n.legal a {\n  font-weight: bold;\n}\n.mu {\n  font-size: 2.46em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-weight: normal;\n  text-shadow: 0 1px 0 #fff;\n  color: #0079c1;\n}\n/* Single property classes - 0 value or common attributes */\n.noHead {\n  margin-top: 0;\n}\n.noBottom {\n  margin-bottom: 0;\n}\n.showTray #task {\n  overflow: hidden;\n  margin-left: 0;\n}\n.hide,\n#spinner {\n  display: none;\n}\n.clearfix,\nhtml[xmlns] .clearfix,\n.loading #spinner,\n.media .img img {\n  display: block;\n}\n#billingToggleLink {\n  display: inline-block;\n}\n.left {\n  float: left;\n}\n.right {\n  float: right;\n}\n.center {\n  text-align: center;\n}\n/* End single property classes */\n.outerWrapper {\n  position: relative;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-color: #ffffff;\n}\nheader {\n  z-index: 2;\n}\nhtml.framed,\n.framed #wrapper {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\nhtml.framed .trayOpen #main {\n  height: 585px;\n}\nhtml.framed .trayOpen .asideContent {\n  height: 495px;\n}\nbody > iframe,\nbody > img {\n  display: none;\n}\n#wrapper {\n  margin: 0 auto;\n  max-width: 780px;\n  border: 1px solid #e3e3e3;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  overflow-y: visible;\n  outline: none;\n  background-color: #fff;\n}\n#wrapper #header {\n  -webkit-border-radius: 5px 5px 0 0;\n  -moz-border-radius: 5px 5px 0 0;\n  border-radius: 5px 5px 0 0;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  width: 100%;\n  background-color: #fff;\n  z-index: 4;\n  -webkit-box-shadow: 0 0 3px 0;\n  -moz-box-shadow: 0 0 3px 0;\n  box-shadow: 0 0 3px 0;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n#contents {\n  position: relative;\n  z-index: 1;\n}\n.active #wrapper {\n  visibility: visible;\n  -webkit-animation-duration: 400ms;\n  -webkit-animation-timing-function: ease;\n  -webkit-animation-name: slideUp;\n}\n#logo {\n  margin: 22px 0 0 20px;\n}\n.container {\n  clear: both;\n  padding: 20px;\n}\n.containerNoHead {\n  padding-top: 0;\n}\n.noPaddingBottom {\n  padding-bottom: 0;\n}\n.noPaddingTop {\n  padding-top: 0;\n}\n.subContainer {\n  border-top: 1px solid #e3e3e3;\n  padding: 20px 0 20px;\n  position: relative;\n}\n#proceedButton {\n  width: 46.4%;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\n#proceedButton.full {\n  width: 100%;\n}\n#proceedButton:focus {\n  color: #fff;\n}\n#backButton {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n#backButton:hover,\n#backButton:focus {\n  color: #2c2e2f;\n}\n.middleName {\n  display: none;\n  float: right;\n}\n.h2,\nh2 {\n  font-size: 1.2em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  margin-top: 0;\n  font-weight: normal;\n  color: #0666B3;\n}\n.clearfix:after {\n  height: 0;\n  display: block;\n  visibility: hidden;\n  clear: both;\n  overflow: auto;\n  line-height: 0;\n  content: \" \";\n}\n* html .clearfix {\n  height: 1%;\n}\n#sliding-area {\n  overflow: hidden;\n}\n#main {\n  padding: 25px 30px 15px;\n  -webkit-transition: margin 0.3s ease-out;\n  -moz-transition: margin 0.3s ease-out;\n  -ms-transition: margin 0.3s ease-out;\n  -o-transition: margin 0.3s ease-out;\n  transition: margin 0.3s ease-out;\n  width: 100%;\n  float: right;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.loading #main {\n  background: none;\n}\n.loginLoadingMessage,\n.bmlLoadingMessage {\n  display: none;\n}\n.loginProcessing .genericLoadingMessage {\n  display: none;\n}\n.loginProcessing .loginLoadingMessage {\n  display: block;\n}\n.full {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  text-decoration: none;\n}\n.trayInner {\n  padding: 20px 0;\n}\n.disclaimer {\n  font-size: 0.75em;\n  color: #6C7378;\n}\n.reviewMsg {\n  margin-top: 10px;\n  line-height: 1.5;\n}\n.infoTxt {\n  clear: both;\n  padding-top: 10px;\n}\n.help {\n  color: #A9A9A9;\n}\n.keyValue label {\n  color: #292929;\n}\n.frontArrow {\n  position: absolute;\n  display: inline-block;\n  width: 9px;\n  height: 15px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -196px -177px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .frontArrow {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.focusableIcon:focus {\n  box-shadow: 0 0 1px #6C7378;\n}\n.caret-down {\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -233px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .caret-down {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n/* Form styles */\ninput[type=submit],\ninput[type=button] {\n  -webkit-appearance: none;\n}\ninput[disabled=disabled],\n.inputField input[disabled=disabled],\n.inputField input[disabled=disabled]:active {\n  background: #F7F9FA;\n  border: 1px solid #CBD2D6;\n  color: #6C7378;\n}\ninput::-ms-clear {\n  display: none;\n}\ninput.link:hover {\n  cursor: pointer;\n}\ninput.xsmall {\n  width: 2em;\n}\ninput.small {\n  width: 3.35em;\n  font-size: 1em;\n}\ninput.medium {\n  width: 7em;\n}\ninput.large {\n  width: 14em;\n}\ninput.xlarge {\n  width: 20em;\n}\n.button-as-link {\n  margin: 0;\n  padding: 0;\n  border: none;\n  width: auto;\n  font-size: 0.85em;\n  background: transparent;\n  color: #0070BA;\n  cursor: pointer;\n}\n/* Hide spinner on type=number fields */\ninput[type=number]::-webkit-inner-spin-button,\ninput[type=number]::-webkit-outer-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n.buttons {\n  margin-top: 15px;\n  margin-bottom: 15px;\n  overflow: hidden;\n}\n.inputField {\n  position: relative;\n}\n.inputField label,\n.inputField input {\n  display: block;\n  vertical-align: top;\n}\n.inputField input,\n.ignoreValidation .inputField.error input,\n.validated .ignoreValidation .inputField input.ng-invalid,\n.validated .ignoreValidation .inputField input.backendError {\n  width: 100%;\n  height: 44px;\n  padding: 0 14px;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  border: 1px solid #C5CCD1;\n  color: #000;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  background: none;\n}\n.inputField input::-webkit-input-placeholder,\n.ignoreValidation .inputField.error input::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-webkit-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:-moz-placeholder,\n.ignoreValidation .inputField.error input:-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n}\n.inputField input::-moz-placeholder,\n.ignoreValidation .inputField.error input::-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n}\n.inputField input:-ms-input-placeholder,\n.ignoreValidation .inputField.error input:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-ms-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:active,\n.inputField input:focus {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n.inputField select {\n  font-size: 1.5em;\n  margin-bottom: 10px;\n}\n.custom-select-container select {\n  font-size: 15px;\n}\n.inputField label {\n  position: absolute;\n  top: 14px;\n  left: 14px;\n  cursor: text;\n  text-align: left;\n  color: #666;\n  font-size: 1em;\n}\n.no-js .inputField label,\n.no-js .dropdown label {\n  position: static;\n}\n.fieldGroup .inputField {\n  float: left;\n  padding: 0 0.5em 0 0;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.inputField.error input::-webkit-input-placeholder,\n.validated .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .inputField input.backendError::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.inputField.error input:-moz-placeholder,\n.validated .inputField input.ng-invalid:-moz-placeholder,\n.validated .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.inputField.error input::-moz-placeholder,\n.validated .inputField input.ng-invalid::-moz-placeholder,\n.validated .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.inputField.error input:-ms-input-placeholder,\n.validated .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .inputField input.backendError:-ms-input-placeholder {\n  color: #c72e2e;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n  background-size: 40px 8000px, 18px;\n}\n.inputField.valid input {\n  background: #fff url(https://www.paypalobjects.com/images/checkout/hermes/icon_checkmark_wallet_2x.png) no-repeat 98% center;\n  background-size: 14px;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  background-position: -webkit-calc(100% - 10px) center;\n  background-position: right 10px center;\n}\n.creditCardField.valid input {\n  background: #fff;\n}\n.inputField.error select,\n.dropdown.error select {\n  border: 1px solid #c72e2e;\n}\n.selectLabel {\n  display: block;\n}\ninput::-webkit-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 1em;\n}\ninput:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput:-ms-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\n/* End form styles */\n.checkbox input[type=checkbox] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.checkbox input[type=checkbox] ~ label,\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: inline-block;\n  position: static;\n  min-height: 25px;\n  padding-left: 35px;\n  line-height: 27px;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px 0;\n  vertical-align: middle;\n  cursor: pointer;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .checkbox input[type=checkbox] ~ label,\n  .checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 25px;\n  margin-left: -35px;\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.checkbox.error input[type=checkbox] ~ label,\n.checkbox.error input[type=checkbox]:focus ~ label,\n.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.checkbox input[type=checkbox]:checked ~ label,\n.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -400px;\n}\n.checkbox input[type=checkbox]:focus:checked ~ label,\n.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4801px;\n}\n.checkbox input[type=checkbox]:focus ~ label,\n.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4601px;\n}\n.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -800px;\n}\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 25px 25px;\n}\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 0;\n}\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 2600px;\n}\n.validated input[type=checkbox].ng-invalid ~ label,\n.validated input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.validated input[type=radio].ng-invalid + label::before,\n.validated input[type=radio].ng-invalid:focus + label::before,\n.validated input[type=radio].ng-invalid + label.bgImgOnSpan span.bgImg,\n.validated input[type=radio].ng-invalid:focus + label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2200px;\n}\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox {\n  position: relative;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label,\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  line-height: 19px;\n  padding-left: 27px;\n  font-size: 0.85em;\n  background-position: -9px -2600px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 19px;\n  margin-left: -27px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.sCheckbox.checkbox.error input[type=checkbox] ~ label,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3000px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -5409px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2800px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3400px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 18px 19px;\n}\n.radioButton input[type=radio] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.radioButton input[type=radio] ~ label {\n  display: inline-block;\n  min-height: 26px;\n  padding-left: 35px;\n  line-height: 27px;\n  vertical-align: middle;\n  cursor: pointer;\n  position: relative;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label {\n  padding-left: unset;\n  padding-right: 35px;\n}\n.radioButton input[type=radio] ~ label::before {\n  content: \" \";\n  display: block;\n  width: 30px;\n  height: 30px;\n  position: absolute;\n  top: 0;\n  left: 0;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px -1600px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .radioButton input[type=radio] ~ label::before {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label::before,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label::before {\n  right: 0;\n  left: unset;\n}\n.radioButton.error input[type=radio] + label::before,\n.radioButton.error input[type=radio]:focus + label::before {\n  background-position: -9px -2200px;\n}\n.radioButton.warning input[type=radio] + label::before,\n.radioButton.warning input[type=radio]:focus + label::before {\n  background-position: -9px -7405px;\n}\n.radioButton input[type=radio]:checked + label::before {\n  background-position: -9px -2000px;\n}\n.radioButton input[type=radio]:focus:checked + label::before {\n  background-position: -9px -6010px;\n}\n.radioButton input[type=radio]:focus + label::before {\n  background-position: -9px -1800px;\n}\n.inputField label.nolap {\n  position: relative;\n  top: auto;\n  left: auto;\n  color: #2c2e2f;\n}\n.inputField.half {\n  width: 48.15%;\n  margin-right: 3.7%;\n  padding-right: 0;\n}\n.singlePagePaymentForm .inputField.half,\n.multistepSignupForm .inputField.half {\n  width: 48.7%;\n  margin-right: 2.6%;\n  padding-right: 0;\n}\n.inputField.half.issueNo {\n  width: 42%;\n  margin-top: 15px;\n}\n.inputField.half.startDate {\n  width: 54%;\n  margin-right: 10px;\n}\n#cardIssueInfo .inputField.half.startDate {\n  width: 48%;\n  margin-right: 0;\n}\n#cardIssueInfo .inputField.half.issueNo {\n  width: 48%;\n  margin-top: 0;\n  float: right;\n}\n#cardIssueInfo .inputField.half.issueNo:before {\n  content: \"\\200C\";\n}\n.inputField.half.last-child {\n  margin-right: 0;\n}\n.fieldGroup .inputField.last-child {\n  padding-right: 0;\n}\n.fidobDay {\n  width: 30%;\n  float: left;\n}\n.fidobDay .custom-select > span {\n  border-radius: 5px 0 0 5px;\n  border-right: 0;\n}\n.fidobMonth {\n  width: 30%;\n  float: left;\n}\n.fidobMonth .custom-select > span {\n  border-radius: 0px;\n}\n.fidobYear {\n  width: 40%;\n  float: left;\n}\n.fidobYear .custom-select > span {\n  border-radius: 0px 5px 5px 0;\n  border-left: 0;\n}\n.cardDOB {\n  width: 100%;\n  clear: both;\n}\n.dobLabel {\n  top: auto;\n  left: auto;\n  position: relative;\n  display: block;\n  bottom: 4px;\n}\n.dobTXT {\n  margin-top: 10px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .inputField.error input,\n  .validated .inputField input.ng-invalid,\n  .validated .inputField input.backendError {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .validated select.ng-invalid + .custom-select > span,\n  .validated select.backendError + .custom-select > span {\n    background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n    background-size: 40px 8000px, 18px;\n  }\n}\n.submitted input.ng-invalid {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.submitted input.ng-invalid::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-ms-input-placeholder {\n  color: #c72e2e;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .submitted input.ng-invalid {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n.merchantHeader {\n  height: 90px;\n  margin: 0 auto;\n}\n.merchantHeader .headerWrapper {\n  max-width: 780px;\n  margin: 0 auto;\n  overflow: hidden;\n  max-height: 90px;\n  line-height: 90px;\n}\n.merchantHeader .merchantName {\n  font-size: 1.6em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n  width: 575px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  display: inline-block;\n}\n.merchantHeader img {\n  vertical-align: middle;\n}\n.paypalHeaderWrapper .logo {\n  float: left;\n  width: 112px;\n  height: 29px;\n  margin-top: 0;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .paypalHeaderWrapper .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.paypalHeaderWrapper .span14 {\n  padding-bottom: 20px;\n  border-bottom: 1px solid #dbdbdb;\n}\n.paypalHeaderWrapper .cartContainer {\n  position: static;\n  line-height: 29px;\n}\n.paypalHeaderWrapper .transctionCartDetails {\n  z-index: 2;\n}\n.paypalHeaderWrapper.paypalCredit .logo {\n  height: 35px;\n  background-position: 0 -129px;\n}\n.aside .header {\n  padding: 15px;\n  vertical-align: middle;\n  line-height: 50px;\n  border-bottom: 1px solid #e3e3e3;\n}\n.aside .header.tall {\n  min-height: 65px;\n  line-height: normal;\n  padding: 13px 15px 10px;\n  margin-bottom: 0;\n}\n.aside .asideAlpha {\n  padding: 0 30px;\n  text-align: center;\n  line-height: 1.2em;\n}\n.aside .walletHeading {\n  text-align: center;\n}\n.aside .close {\n  position: absolute;\n  top: 10px;\n  right: 15px;\n  width: 19px;\n  height: 19px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .close:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 19px;\n  height: 19px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px 0;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .close:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .close:hover:before,\n.aside .close:focus:before {\n  background-position: -223px -22px;\n}\n.aside .backArrow {\n  position: absolute;\n  top: 10px;\n  left: 15px;\n  width: 9px;\n  height: 18px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .backArrow:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 9px;\n  height: 18px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -232px -46px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .backArrow:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .backArrow:hover:before,\n.aside .backArrow:focus:before {\n  background-position: -232px -68px;\n}\n.aside .addOptions {\n  margin-top: 20px;\n}\n.aside .addOptions h2 {\n  float: left;\n  width: 70%;\n  margin-bottom: 0;\n}\n.aside .addOptions a {\n  float: right;\n  display: block;\n  line-height: 1.9em;\n  font-size: .85em;\n}\n.aside .subHeader {\n  margin-top: 20px;\n}\n.pageSepaAgreementContingency .paypalHeader.span14,\n.pageSepaMandateContingency .paypalHeader.span14,\n.pageSepaMandate .paypalHeader.span14,\n.CYCOPage .paypalHeader.span14 {\n  width: 100%;\n}\n#mobileMerchantHeader {\n  display: none;\n}\n@media (max-width: 41.3125em) {\n  .merchantHeader {\n    display: none;\n  }\n  .paypalHeaderWrapper {\n    height: 65px;\n  }\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -5px;\n    margin-right: 15px;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 30px;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -10px;\n    margin-right: 0;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 0;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n  .header {\n    height: 55px;\n  }\n  .aside .header {\n    height: auto;\n  }\n  .aside .close {\n    right: 15px;\n  }\n}\n.footer {\n  max-width: 780px;\n  margin: 10px auto;\n  font-size: 0.75em;\n}\n.cancelUrl {\n  float: left;\n}\n.micaLender {\n  display: none;\n  color: #2c2e2f;\n  clear: both;\n}\n.footerWrapper {\n  text-align: left;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper {\n    float: right;\n  }\n}\n.footerWrapper table {\n  display: inline;\n  float: left;\n  table-layout: fixed;\n  border: none;\n}\n.footerWrapper tr,\n.footerWrapper th,\n.footerWrapper td {\n  border: none;\n  font-weight: normal;\n  padding-bottom: 0;\n  padding-top: 0;\n  text-align: left;\n}\n.footerWrapper .footerLinks {\n  float: left;\n  border: none;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .footerLinks {\n    margin-right: 1em;\n  }\n}\n.footerWrapper .footerLinks li {\n  padding: 0 0.5em;\n  color: #6C7378;\n}\n.footerWrapper .footerLinks li:first-child {\n  padding-left: 0;\n}\n.footerWrapper .footerLinks li.feedbackLink {\n  color: #0070BA;\n}\n.footerWrapper .footerLinks .underline th {\n  border-bottom: 1px solid #ccc;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .languageToggleDisplay {\n    clear: none;\n    margin-left: 1.5em;\n  }\n  .footerWrapper .languageToggleDisplay::before {\n    border-left: 2px solid #9da3a6;\n    content: \" \";\n    margin: 0 0.15em;\n    display: inline-block;\n    height: 1em;\n    position: absolute;\n    left: 0;\n    top: 50%;\n    transform: translateY(-50%);\n    margin-left: -0.85em;\n  }\n}\n.footerLinks {\n  margin: 0;\n  display: inline-block;\n  text-align: left;\n}\n.footerLinks a {\n  color: #6C7378;\n}\n.footerLinks a.feedbackLink {\n  color: #0070BA;\n  margin-left: 5px;\n}\n.footerLinks th,\ntd {\n  border: none;\n}\n.policyInfoWrapper {\n  color: #6C7378;\n}\n.policyInfoWrapper p.moreInfo {\n  padding: 15px 0 20px 0;\n  float: left;\n}\n.copyright {\n  display: inline;\n  width: auto;\n  float: right;\n  margin: 0;\n  vertical-align: top;\n  color: #6C7378;\n}\n@media screen and (min-width: 41em) {\n  .copyright {\n    float: left;\n  }\n}\n.secureIcon {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: 0 -33px;\n  margin-left: 3px;\n  margin-right: 3px;\n  margin-top: 3px;\n  width: 10px;\n  height: 12px;\n  vertical-align: top;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .secureIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.poweredBy {\n  float: right;\n  margin-top: -49px;\n}\n.poweredBy .text {\n  float: left;\n  margin-top: 8px;\n  margin-right: 8px;\n  font-size: 12px;\n  font-weight: normal;\n  font-style: italic;\n  color: #6c7378;\n}\n.footerLinks li {\n  padding: 0 12px 0 0;\n  display: inline-block;\n}\n.footerLinks .last {\n  padding-right: 18px;\n  border-right: none;\n}\n.footer .policyInfoWrapper p {\n  line-height: 1.3em;\n}\n.footer .policyInfoWrapper p a {\n  font-weight: bold;\n}\n.minibrowser.AU .footer,\n.minibrowser .APAC.footer {\n  position: relative;\n  bottom: 0;\n  width: auto;\n}\n.minibrowser.AU .footer .policyInfoWrapper,\n.minibrowser .APAC.footer .policyInfoWrapper {\n  padding: 0;\n}\n.minibrowser .cancelUrl {\n  display: none;\n}\n.minibrowser .footerWrapper {\n  padding: 0 10px;\n  float: none;\n  width: 95%;\n  margin: 0;\n}\n.minibrowser .footerLinks li {\n  padding: 0 5px 0 0px;\n}\n/*\n//Country specific rules\n.DE, .fr.FR, .fr.CA {\n    .footerWrapper {\n        &:after {\n            height: 0;\n            display: block;\n            visibility: hidden;\n            clear: both;\n            overflow: auto;\n            line-height: 0;\n            content: \" \";\n        }\n    }\n    .footerLinks {\n        float: left;\n        width: 70%;\n        text-align: left;\n        li:first-child {\n            padding-left: 0;\n        }\n    }\n\n    .cancelUrl {\n        float: none;\n        margin: 5px 0;\n        width: 100%;\n    }\n}\n*/\n.APAC .policyInfoWrapper {\n  padding: 5px 0 10px 0;\n}\n.APAC .policyInfoWrapper p.moreInfo {\n  line-height: 1.3em;\n}\n.en_AU .policyInfoWrapper,\n.AU .policyInfoWrapper {\n  padding: 20px 0 10px 0;\n  color: #6C7378;\n}\n.en_AU .policyInfoWrapper p.moreInfo,\n.AU .policyInfoWrapper p.moreInfo {\n  border-bottom: 1px solid #ccc;\n}\n.en_AU .policyInfoWrapper p.moreCopyRight,\n.AU .policyInfoWrapper p.moreCopyRight {\n  padding: 5px 0 0 0;\n  clear: both;\n}\n.fr_XC .footerWrapper {\n  float: left;\n  width: 70%;\n  text-align: left;\n  padding-left: 0;\n  margin-left: -7px;\n}\n@media (max-width: 41.25em) {\n  .footer {\n    border-top: 1px solid #ccc;\n    padding: 5px 20px;\n    margin-top: 10px;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0 10px;\n  }\n  .footerWrapper {\n    padding: 0;\n    margin: 0;\n  }\n  .footerWrapper:after {\n    height: 0;\n    display: block;\n    visibility: hidden;\n    clear: both;\n    overflow: auto;\n    line-height: 0;\n    content: \" \";\n  }\n  .footerLinks {\n    float: left;\n    width: 70%;\n    text-align: left;\n  }\n  .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n  .cancelUrl {\n    float: none;\n    margin: 5px 0;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .footer {\n    margin-top: 0;\n    padding: 0.5em 2em;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0;\n  }\n  .footerWrapper,\n  .cancelUrl {\n    padding: 0;\n    margin: 5px 0px;\n    width: 100%;\n  }\n  .footerLinks,\n  .DE .footerLinks,\n  .fr.FR .footerLinks {\n    width: 65%;\n  }\n  .footerLinks li,\n  .DE .footerLinks li,\n  .fr.FR .footerLinks li {\n    padding: 0;\n    margin-right: 10px;\n  }\n  .footerLinks li.last,\n  .DE .footerLinks li.last,\n  .fr.FR .footerLinks li.last {\n    margin-right: 0;\n  }\n  .footerLinks .feedback,\n  .DE .footerLinks .feedback,\n  .fr.FR .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .copyright {\n    margin-right: 0;\n    width: 30%;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n}\n.modal-open {\n  overflow: hidden;\n}\n.modal-open .outerWrapper,\n.modal-open #wrapper,\n.modal-open #contents {\n  position: static;\n}\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 140;\n  background-color: #000;\n}\n.modal-backdrop.fade {\n  opacity: 0;\n}\n.modal-backdrop,\n.modal-backdrop.fade.in {\n  opacity: 0.54;\n}\n.modal {\n  display: none;\n  overflow: auto;\n  overflow-y: scroll;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 150;\n}\n.modal.fade .modal-wrap {\n  -webkit-transform: translate(0, -25%);\n  -moz-transform: translate(0, -25%);\n  -ms-transform: translate(0, -25%);\n  -o-transform: translate(0, -25%);\n  transform: translate(0, -25%);\n  -webkit-transition: -webkit-transform 0.3s ease-out;\n  -moz-transition: -moz-transform 0.3s ease-out;\n  -o-transition: -o-transform 0.3s ease-out;\n  transition: transform 0.3s ease-out;\n}\n.modal.fade.in .modal-wrap {\n  -webkit-transform: translate(0, 0);\n  -moz-transform: translate(0, 0);\n  -ms-transform: translate(0, 0);\n  -o-transform: translate(0, 0);\n  transform: translate(0, 0);\n}\n.modal-wrap {\n  position: relative;\n  margin: 10px;\n  background-color: #fff;\n  border: 1px solid #999;\n  border: 1px solid rgba(0, 0, 0, 0.3);\n  -webkit-border-radius: 6px;\n  -moz-border-radius: 6px;\n  border-radius: 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  -moz-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  outline: none;\n}\n.modal-header {\n  padding: 9px 15px;\n  border-bottom: 1px solid #eee;\n}\n.modal-header .close {\n  margin-top: 2px;\n}\n.modal-header h3 {\n  margin: 0;\n  line-height: 30px;\n}\n.modal-body {\n  position: relative;\n  overflow-y: auto;\n  max-height: 400px;\n  padding: 15px;\n}\n.modal-form {\n  margin-bottom: 0;\n}\n.modal-footer {\n  padding: 14px 15px 15px;\n  margin-bottom: 0;\n  text-align: right;\n  background-color: #f5f5f5;\n  border-top: 1px solid #ddd;\n  -webkit-border-radius: 0 0 6px 6px;\n  -moz-border-radius: 0 0 6px 6px;\n  border-radius: 0 0 6px 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: inset 0 1px 0 #fff;\n  -moz-box-shadow: inset 0 1px 0 #fff;\n  box-shadow: inset 0 1px 0 #fff;\n}\n.modal-footer:before,\n.modal-footer:after {\n  display: table;\n  content: \"\";\n  line-height: 0;\n}\n.modal-footer:after {\n  clear: both;\n}\n.modal-footer .btn + .btn {\n  margin-left: 5px;\n  margin-bottom: 0;\n}\n.modal-footer .btn-group .btn + .btn {\n  margin-left: -1px;\n}\n.modal-footer .btn-block + .btn-block {\n  margin-left: 0;\n}\n.spinner {\n  height: 100%;\n  width: 100%;\n  position: fixed;\n  z-index: 10;\n}\n.spinner .spinWrap {\n  width: 200px;\n  height: 100px;\n  position: fixed;\n  top: 42%;\n  left: 50%;\n  margin-left: -98px;\n  margin-top: -50px;\n}\n.spinner .spinnerImage {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 28px 0 0 -25px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/icon_ot_spin_lock_skinny.png') no-repeat;\n}\n.spinner .loader {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 0 0 0 -55px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background-color: transparent;\n  -webkit-animation: rotation .7s infinite linear;\n  -moz-animation: rotation .7s infinite linear;\n  -o-animation: rotation .7s infinite linear;\n  animation: rotation .7s infinite linear;\n  border-left: 5px solid #cbcbca;\n  border-right: 5px solid #cbcbca;\n  border-bottom: 5px solid #cbcbca;\n  border-top: 5px solid #2380be;\n  border-radius: 100%;\n}\n.spinner .genericLoadingMessage,\n.spinner .loginLoadingMessage,\n.spinner .bmlLoadingMessage {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  margin-top: 125px;\n  text-align: center;\n  z-index: 100;\n}\n.spinner.preloader {\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 1000;\n  background-color: #fff;\n}\n@-webkit-keyframes rotation {\n  from {\n    -webkit-transform: rotate(0deg);\n  }\n  to {\n    -webkit-transform: rotate(359deg);\n  }\n}\n@-moz-keyframes rotation {\n  from {\n    -moz-transform: rotate(0deg);\n  }\n  to {\n    -moz-transform: rotate(359deg);\n  }\n}\n@-o-keyframes rotation {\n  from {\n    -o-transform: rotate(0deg);\n  }\n  to {\n    -o-transform: rotate(359deg);\n  }\n}\n@keyframes rotation {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(359deg);\n  }\n}\n@media only screen and (max-width: 768px) {\n  .spinner .spinWrap {\n    width: 200px;\n    height: 100px;\n    position: fixed;\n    top: 40%;\n    left: 50%;\n    margin-left: -93px;\n    margin-top: -50px;\n  }\n}\n.aside {\n  min-height: 380px;\n}\n.aside .container {\n  padding: 15px;\n}\n.asideContent {\n  height: 100%;\n}\n.centerText {\n  text-align: center;\n}\n.fsIcons {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  min-width: 32px;\n  width: 25px;\n  height: 21px;\n  padding-right: 5px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.HOLDING .fsIcons,\n.BALANCE .fsIcons,\n.DELAYED_TRANSFER .fsIcons {\n  background-position: 0px 0px;\n}\n.ELO .fsIcons {\n  background-position: 0 -479px;\n}\n.HIPER .fsIcons {\n  background-position: 0 -458px;\n}\n.HIPERCARD .fsIcons {\n  background-position: 0 -500px;\n}\n.EBAY_MASTERCARD .fsIcons {\n  background-position: 0px -606px;\n}\n.PayPal.MasterCard .fsIcons {\n  background-position: 0 -604px;\n}\n.pinlessGlyphIcon {\n  display: inline-block;\n  position: relative;\n  top: -5px;\n  left: -8px;\n  width: 32px;\n  height: 20px;\n  font-size: 3.1rem;\n  padding-right: 5px;\n}\n.IACH .fsIcons,\n.BANK .fsIcons,\n.BANK_ACCOUNT .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.ELV .fsIcons,\n.ECHECK .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n}\n.TAB.DELAYED_TRANSFER .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.BILL_ME_LATER .fsIcons,\n.BML .fsIcons,\n.PPCREDIT .fsIcons,\n.CREDIT_OPTION .fsIcons {\n  background-position: 0 -105px;\n}\n.PAYPAL_SMART_CONNECT .fsIcons {\n  background-position: 0px 0px;\n}\n.VISA .fsIcons {\n  background-position: 0 -21px;\n}\n.MASTERCARD .fsIcons {\n  background-position: 0 -42px;\n}\n.AMEX .fsIcons {\n  background-position: 0 -63px;\n  left: 19px;\n  height: 20px;\n}\n.DISCOVER .fsIcons,\n.DISC .fsIcons {\n  background-position: 0 -84px;\n}\n.JCB .fsIcons {\n  background-position: 0px -353px;\n}\n.CHINA_UNION_PAY .fsIcons {\n  background-position: 0px -563px;\n}\n.ELECTRON .fsIcons {\n  background-position: 0 -146px;\n}\n.MAESTRO .fsIcons,\n.MSTRO .fsIcons,\n.SWITCH .fsIcons {\n  background-position: 0 -168px;\n}\n.CB_NATIONALE .fsIcons,\n.CBN .fsIcons {\n  background-position: 0 -210px;\n}\n.CELEM .fsIcons,\n.CETELEM .fsIcons {\n  background-position: 0 -311px;\n}\n.CONF .fsIcons,\n.COFINOGA .fsIcons {\n  background-position: 0 -231px;\n}\n.COFID .fsIcons,\n.COFIDIS .fsIcons {\n  background-position: 0 -437px;\n  left: 20px;\n}\n.INCENTIVE .fsIcons {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.PPSMTCONNECT .fsIcons {\n  background-position: 0 0;\n}\n.RUPAY .fsIcons {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.fsIcon {\n  display: block;\n  position: absolute;\n  width: 32px;\n  height: 21px;\n  left: 15px;\n  top: 20px;\n  min-width: 32px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  background-position: 0px 0px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.fsIcon.PAYPAL_SMART_CONNECT {\n  background-position: 0 0;\n}\n.fsIcon.PPSMTCONNECT {\n  background-position: 0 0;\n}\n.fsIcon.VISA {\n  background-position: 0 -21px;\n}\n.fsIcon.MASTER,\n.fsIcon.MCARD,\n.fsIcon.MASTERCARD {\n  background-position: 0 -42px;\n}\n.fsIcon.AMEX,\n.fsIcon.Amex {\n  background-position: 6px -63px;\n  left: 19px;\n  height: 20px;\n}\n.fsIcon.DISCOVER,\n.fsIcon.DISC {\n  background-position: 0 -84px;\n}\n.fsIcon.PPCREDIT,\n.fsIcon.BML,\n.fsIcon.BILL_ME_LATER {\n  background-position: 0 -105px;\n}\n.fsIcon.SWITCH,\n.fsIcon.MSTRO,\n.fsIcon.MAESTRO {\n  background-position: 0 -168px;\n}\n.fsIcon.CBN,\n.fsIcon.CB_NATIONALE {\n  background-position: 0 -210px;\n}\n.fsIcon.CONF,\n.fsIcon.COFINOGA {\n  background-position: 0 -231px;\n}\n.fsIcon.BANK,\n.fsIcon.PAD {\n  background-position: 6px -252px;\n  height: 19px;\n  left: 19px;\n}\n.fsIcon.INCENTIVE {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.fsIcon.CELEM,\n.fsIcon.CETELEM {\n  background-position: 0 -311px;\n}\n.fsIcon.JCB {\n  background-position: 0px -353px;\n}\n.fsIcon.COFID,\n.fsIcon.COFIDIS {\n  background-position: 0 -437px;\n  left: 20px;\n  height: 20px;\n}\n.fsIcon.HIPER {\n  background-position: 0 -458px;\n}\n.fsIcon.ELO {\n  background-position: 0 -479px;\n}\n.fsIcon.HIPERCARD {\n  background-position: 0 -500px;\n}\n.fsIcon.CHINA_UNION_PAY,\n.fsIcon.CUP {\n  background-position: 0px -563px;\n}\n.fsIcon.PayPal.MasterCard,\n.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.fsIcon.PPXMCARD {\n  background-position: 0 -584px;\n}\n.fsIcon.EBAY_MASTERCARD,\n.fsIcon.EBAYMCARD {\n  background-position: 0px -605px;\n}\n.fsIcon.CHASEPAY {\n  background-position: 0px -626px;\n  width: 36px;\n  height: 14px;\n  display: inline-block;\n  vertical-align: baseline;\n  position: static;\n  margin-bottom: -1px;\n}\n.fsIcon.pinlessIcon {\n  background-image: none;\n  font-size: 3.1rem;\n  left: 5px;\n  top: 14px;\n}\n.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.PayPal.MasterCard .fsIcons,\n.PayPal.MasterCard .fsIcon,\n.PPXMCARD .fsIcons,\n.PPXMCARD .fsIcon,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcons,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcon {\n  background-position: 0 -584px;\n}\n.fsIcon.BILL_ME_LATER_DE,\n.fsIcons.BILL_ME_LATER_DE {\n  position: static;\n  float: left;\n  background-size: auto;\n  background-image: url(\"https://www.paypalobjects.com/webstatic/credit/img/pp-ratenzahlung-logo.png\");\n  background-repeat: no-repeat;\n  background-position: initial;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n}\n.standardCardIcon.pinlessGlyphIcon {\n  display: inline-block;\n  width: 37.12px;\n  height: 24.36px;\n  font-size: 3.6rem;\n  padding-right: 8px;\n  position: relative;\n}\n.standardCardIcon.pinlessGlyphIcon:before {\n  position: absolute;\n  left: -11px;\n  top: 0px;\n}\n.standardCardIcon.fsIcon {\n  background-size: 42.92px 745.88px;\n  width: 37.12px;\n  height: 24.36px;\n}\n.standardCardIcon.fsIcon.VISA {\n  background-position: 0 -24.36px;\n}\n.standardCardIcon.fsIcon.MASTER,\n.standardCardIcon.fsIcon.MCARD,\n.standardCardIcon.fsIcon.MASTERCARD {\n  background-position: 0 -48.72px;\n}\n.standardCardIcon.fsIcon.AMEX,\n.standardCardIcon.fsIcon.Amex {\n  background-position: 5px -73.08px;\n  height: 23.2px;\n}\n.standardCardIcon.fsIcon.DISCOVER,\n.standardCardIcon.fsIcon.DISC {\n  background-position: 0 -97.44px;\n}\n.standardCardIcon.fsIcon.PPCREDIT,\n.standardCardIcon.fsIcon.BML,\n.standardCardIcon.fsIcon.BILL_ME_LATER {\n  background-position: 0 -121.8px;\n}\n.standardCardIcon.fsIcon.SWITCH,\n.standardCardIcon.fsIcon.MSTRO,\n.standardCardIcon.fsIcon.MAESTRO {\n  background-position: 0 -194.88px;\n}\n.standardCardIcon.fsIcon.CBN,\n.standardCardIcon.fsIcon.CB_NATIONALE {\n  background-position: 0 -243.6px;\n}\n.standardCardIcon.fsIcon.CONF,\n.standardCardIcon.fsIcon.COFINOGA {\n  background-position: 0 -267.96px;\n}\n.standardCardIcon.fsIcon.BANK,\n.standardCardIcon.fsIcon.BANK_ACCOUNT,\n.standardCardIcon.fsIcon.PAD {\n  background-position: 5px -292.32px;\n  height: 22.04px;\n}\n.standardCardIcon.fsIcon.INCENTIVE {\n  background-position: 0 -314.36px;\n  height: 20.88px;\n}\n.standardCardIcon.fsIcon.CELEM,\n.standardCardIcon.fsIcon.CETELEM {\n  background-position: 0 -360.76px;\n}\n.standardCardIcon.fsIcon.JCB {\n  background-position: 0px -409.48px;\n}\n.standardCardIcon.fsIcon.HIPER {\n  background-position: 0px -531.28px;\n}\n.standardCardIcon.fsIcon.ELO {\n  background-position: 0px -555.64px;\n}\n.standardCardIcon.fsIcon.HIPERCARD {\n  background-position: 0px -580px;\n}\n.standardCardIcon.fsIcon.Thirdlast {\n  background-position: 0px -600px;\n}\n.standardCardIcon.fsIcon.COFID,\n.standardCardIcon.fsIcon.COFIDIS {\n  background-position: 0px -506.92px;\n}\n.standardCardIcon.fsIcon.CHINA_UNION_PAY,\n.standardCardIcon.fsIcon.CUP {\n  background-position: 0px -653.08px;\n}\n.standardCardIcon.fsIcon.PayPal.MasterCard,\n.standardCardIcon.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.standardCardIcon.fsIcon.PPXMCARD {\n  background-position: 0 -677.44px;\n}\n.standardCardIcon.fsIcon.EBAY_MASTERCARD,\n.standardCardIcon.fsIcon.EBAYMCARD {\n  background-position: 0 -701.8px;\n}\n.standardCardIcon.fsIcon.CHASEPAY {\n  background-position: 0px -726.16px;\n  width: 36px;\n  height: 14px;\n}\n.standardCardIcon.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.infoIcon {\n  width: 19px;\n  height: 18px;\n  display: inline-block;\n  position: absolute;\n  top: 25px;\n  right: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -89px -1px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .infoIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.addOption {\n  padding: 25px 10px;\n  margin: 0 0 0 44px;\n  color: #0070BA;\n  font-size: .85em;\n}\n.plusicon {\n  display: block;\n  position: absolute;\n  left: 15px;\n  top: 22px;\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -97px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .plusicon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.infoIcon + .checkIcon {\n  display: none;\n}\n.infoMsg {\n  margin: 0;\n  overflow: hidden;\n  font-size: .85em;\n}\n.expiredIcon {\n  background: white url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  top: 6px;\n  position: relative;\n}\n.plccIcon {\n  float: left;\n  display: inline-block;\n  height: 20px;\n  background: none;\n  width: 32px;\n  position: relative;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .fsIcons {\n    height: 20px;\n  }\n  .fsIcon {\n    height: 20px;\n  }\n}\n.walletIcons {\n  position: absolute;\n  width: 30px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .walletIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons_2x.png\");\n    background-size: 90px 970px;\n  }\n}\n.walletIcons.BANK,\n.walletIcons.BANK_ACCOUNT {\n  background-position: -50px -460px;\n}\n.walletIcons.BANK.BOFA,\n.walletIcons.BANK_ACCOUNT.BOFA {\n  background-position: -50px -10px;\n}\n.walletIcons.BANK.CHASE,\n.walletIcons.BANK_ACCOUNT.CHASE {\n  background-position: -50px -130px;\n}\n.walletIcons.BANK.WELLSFARGO,\n.walletIcons.BANK_ACCOUNT.WELLSFARGO {\n  background-position: -50px -100px;\n}\n.walletIcons.BANK.CITI,\n.walletIcons.BANK_ACCOUNT.CITI {\n  background-position: -50px -40px;\n}\n.walletIcons.BANK.FIFTHTHIRD,\n.walletIcons.BANK_ACCOUNT.FIFTHTHIRD {\n  background-position: -50px -220px;\n}\n.walletIcons.BANK.CAPITAL,\n.walletIcons.BANK_ACCOUNT.CAPITAL {\n  background-position: -50px -70px;\n}\n.walletIcons.BANK.AMERITRADE,\n.walletIcons.BANK_ACCOUNT.AMERITRADE {\n  background-position: -50px -160px;\n}\n.walletIcons.BANK.SUNTRUST,\n.walletIcons.BANK_ACCOUNT.SUNTRUST {\n  background-position: -50px -280px;\n}\n.walletIcons.BANK.USBANK,\n.walletIcons.BANK_ACCOUNT.USBANK {\n  background-position: -50px -310px;\n}\n.walletIcons.BANK.USAA,\n.walletIcons.BANK_ACCOUNT.USAA {\n  background-position: -50px -250px;\n}\n.walletIcons.CARD.VISA,\n.walletIcons.PAYMENT_CARD.VISA {\n  background-position: -10px -40px;\n}\n.walletIcons.CARD.MASTER,\n.walletIcons.PAYMENT_CARD.MASTER,\n.walletIcons.CARD.MASTERCARD,\n.walletIcons.PAYMENT_CARD.MASTERCARD {\n  background-position: -10px -70px;\n}\n.walletIcons.CARD.DISCOVER,\n.walletIcons.PAYMENT_CARD.DISCOVER {\n  background-position: -10px -100px;\n}\n.walletIcons.CARD.AMEX,\n.walletIcons.PAYMENT_CARD.AMEX {\n  background-position: -10px -130px;\n}\nhr.sep,\nhr.sepPlain {\n  padding: 0;\n  margin-top: 25px;\n  height: auto;\n  border: none;\n  border-top: 1px solid #ccc;\n  color: #2c2e2f;\n  text-align: center;\n  overflow: visible;\n}\nhr.sep:after,\nhr.sepPlain:after,\nhr.sep::after,\nhr.sepPlain::after {\n  content: \"or\";\n  display: inline-block;\n  position: relative;\n  top: -0.7em;\n  font-size: 1em;\n  padding: 0 0.50em;\n  background: white;\n  color: #6c7378;\n  font-weight: normal;\n}\n.de hr.sep:after,\n.de hr.sep::after {\n  content: \"oder\";\n}\n.da hr.sep:after,\n.da hr.sep::after {\n  content: \"eller\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\n.es hr.sep:after,\n.es hr.sep::after {\n  content: \"o\";\n}\n.fr hr.sep:after,\n.fr hr.sep::after {\n  content: \"ou\";\n}\n.he hr.sep:after,\n.he hr.sep::after {\n  content: \"\\5D0\\5D5\";\n}\n.id hr.sep:after,\n.id hr.sep::after {\n  content: \"Atau\";\n}\n.it hr.sep:after,\n.it hr.sep::after {\n  content: \"oppure\";\n}\n.ja hr.sep:after,\n.ja hr.sep::after {\n  content: \"\\307E\\305F\\306F\";\n}\n.ko hr.sep:after,\n.ko hr.sep::after {\n  content: \"\\B610\\B294\";\n}\n.nl hr.sep:after,\n.nl hr.sep::after {\n  content: \"of\";\n}\n.no hr.sep:after,\n.no hr.sep::after {\n  content: \"eller\";\n}\n.pl hr.sep:after,\n.pl hr.sep::after {\n  content: \"lub\";\n}\n.pt hr.sep:after,\n.pt hr.sep::after {\n  content: \"ou\";\n}\n.ru hr.sep:after,\n.ru hr.sep::after {\n  content: \"\\418\\43B\\438\";\n}\n.sv hr.sep:after,\n.sv hr.sep::after {\n  content: \"eller\";\n}\n.th hr.sep:after,\n.th hr.sep::after {\n  content: \"\\E2B\\E23\\E37\\E2D\";\n}\n.tr hr.sep:after,\n.tr hr.sep::after {\n  content: \"Veya\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\nhr.sepPlain:after,\nhr.sepPlain::after {\n  content: '';\n}\n/*\n * @fileOverview queries.css contains media queries for responsive design/layout breakpoints.\n * @name Queries\n * @author abadri\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n@media (min-width: 0) and (max-width: 23em) {\n  #loginSection .xoTitle h1 {\n    max-width: 10em;\n  }\n}\n@media (min-width: 0) and (max-width: 30em), (max-width: 40em) and (orientation: landscape) {\n  body {\n    -webkit-text-size-adjust: 100%;\n  }\n  .merchantBrand {\n    display: none;\n  }\n  .outerWrapper {\n    background-position: left 50px;\n  }\n  .centerTray.loginSignup {\n    margin-bottom: 60px;\n  }\n  #main {\n    padding: 0;\n    background: none;\n    z-index: 2;\n  }\n  #contents {\n    padding: 0 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  .tokenization #contents {\n    padding: 0 30px;\n  }\n  .paypalHeader {\n    padding: 0 20px 20px 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  .review #wrapper {\n    min-height: 512px;\n  }\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .loginProcessing,\n  .bmlAppProcessing {\n    background-color: #f9f9f9;\n  }\n  .loggingIn {\n    margin: 0 25px;\n  }\n  .mobile .loggingIn {\n    margin: 0;\n  }\n  .saferEasier,\n  .simpler {\n    display: none;\n  }\n  #login .row-fluid {\n    padding-top: 0px;\n  }\n  #login .centerTray {\n    padding: 0;\n  }\n  #login #signupLink.btn {\n    margin: 5px 0;\n  }\n  #wrapper {\n    margin: 0;\n    width: auto;\n    -webkit-border-radius: 0;\n    -moz-border-radius: 0;\n    border-radius: 0;\n    -webkit-background-clip: padding-box;\n    -moz-background-clip: padding-box;\n    background-clip: padding-box;\n    border: none;\n  }\n  #task {\n    width: 295px;\n  }\n  .loading .spinner {\n    background-position-y: 35%;\n  }\n  .centerTray {\n    width: auto;\n  }\n  .tray .inner,\n  .accountTerms .tray .inner {\n    padding: 10px;\n  }\n  .row-fluid > [class*=\"span\"],\n  .signup {\n    width: 100%;\n    margin-left: 0;\n    float: none;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .gamma,\n  .delta {\n    font-size: 1.2em;\n  }\n  .inputField label {\n    left: 7px;\n    top: 13px;\n  }\n  .saferEasier {\n    display: none;\n  }\n  #fundingInstruments .buttons {\n    height: 40px;\n  }\n  .cityState select {\n    font-size: 14px;\n  }\n  .cityState .city {\n    width: 100%;\n  }\n  .cityState .state {\n    width: 55%;\n  }\n  .cityState .postalCode {\n    width: 40.8%;\n  }\n  #tab {\n    margin-top: 0;\n    height: 125px;\n  }\n  .toolTip.whatsthis ul {\n    width: 242px;\n    left: 9px;\n  }\n  .toolTip.whatsthis ul li {\n    font-size: 0.9em;\n  }\n  #expiration.varB .expires {\n    width: 49%;\n  }\n  #expiration .inputField {\n    padding: 0;\n  }\n  #expiration .cvc {\n    width: 44%;\n    float: right;\n  }\n  #expiration.varB .cvc {\n    width: 49%;\n  }\n  .month {\n    margin-left: 46px;\n  }\n  .separator {\n    margin-left: 5px;\n    margin-top: 3px;\n  }\n  .year {\n    margin-left: 0;\n  }\n  #expiration .cardIcon {\n    position: absolute;\n    right: 4px;\n  }\n  .details {\n    margin-right: 2px;\n  }\n  .mask #header,\n  .mask #closeButton {\n    display: none;\n  }\n}\n@media (min-width: 30.0625em) and (max-width: 41.25em) {\n  .row-fluid > .span10,\n  .row-fluid > .span12,\n  .row-fluid > .span14 {\n    width: 100%;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .outerWrapper {\n    background-position: left 59px;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  #wrapper {\n    margin: 0;\n    border: none;\n  }\n  #main {\n    padding: 0;\n  }\n  #contents {\n    padding: 0 25px;\n  }\n}\n@media (min-width: 41.3125em) {\n  .banner {\n    display: block;\n  }\n  #wrapper {\n    min-height: 0;\n    width: 95%;\n  }\n  .merchantHeader,\n  .footer {\n    width: 95%;\n  }\n  .largeScreen .centerTray {\n    margin-top: 0;\n  }\n  .signup {\n    margin-bottom: 0;\n  }\n  #genericError {\n    min-height: 375px;\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/scr_cloud_balloon.png) no-repeat center bottom;\n  }\n  #transactionDetails .merchantName {\n    display: none;\n  }\n}\n@media (device-height: 568px) and (-webkit-min-device-pixel-ratio: 2) {\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .pageLanding #contents {\n    margin: 70px auto 40px 0px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .cardType {\n    display: none;\n  }\n  ul.validations li.restriction.active {\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/close3_2x.png) no-repeat 0 2px;\n    background-size: 10px;\n  }\n  .inputField.error input {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .inputField.error input,\n  .inputField.valid input {\n    background-position: -webkit-calc(100% - 10px) center;\n    background-position: right 10px center;\n  }\n  .error .custom-select > span,\n  .error .custom-select.active > span {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2) and (min-width: 41.3125em) {\n  #genericError {\n    background-size: 640px 242px;\n  }\n}\n/*\n    .within-rtl({ ... });\n    Targets rules for both xoon and hermes, when RTL applies\n*/\n*[dir=\"rtl\"] .footerWrapper .footerLinks,\n.outerWrapper.rtl .footerWrapper .footerLinks {\n  float: right;\n}\n*[dir=\"rtl\"] .footerWrapper .footerLinks li:first-child,\n.outerWrapper.rtl .footerWrapper .footerLinks li:first-child {\n  padding-left: 12px;\n}\n@media screen and (max-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: none;\n    clear: both;\n  }\n}\n@media screen and (min-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: left;\n  }\n  *[dir=\"rtl\"] .footerWrapper .languageToggleDisplay::before,\n  .outerWrapper.rtl .footerWrapper .languageToggleDisplay::before {\n    right: 0;\n    margin-left: 0.85em;\n  }\n}\n*[dir=\"rtl\"] .paypalHeader .languageToggleDisplay,\n.outerWrapper.rtl .paypalHeader .languageToggleDisplay {\n  float: right;\n}\n@media (min-width: 41.3125em) {\n  section#genericError .container {\n    width: 400px;\n  }\n  .genericError.footerWrapper {\n    padding: 0 3px;\n  }\n  .genericError.footerWrapper .footerLinks {\n    text-align: left;\n  }\n}\nsection#genericError {\n  height: 450px;\n  background: none;\n}\nsection#genericError .container {\n  position: relative;\n  margin: 0 auto;\n  top: 50%;\n  -webkit-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  transform: translateY(-50%);\n}\nsection#genericError .title {\n  font-size: 1.5em;\n  margin-bottom: 15px;\n  line-height: 1.2;\n}\nsection#genericError .message {\n  font-size: 1em;\n  margin-bottom: 15px;\n  color: #7b8388;\n}\nsection#genericError .secondaryMessage {\n  color: #979797;\n  line-height: 20px;\n}\nsection#genericError .logo {\n  width: 112px;\n  height: 29px;\n  margin: 5px 0 20px;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  section#genericError .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\nsection#genericError .cancelLink {\n  margin-top: 20px;\n}\nsection#genericError .logoutLink {\n  margin-top: 20px;\n  font-weight: 400;\n  text-align: center;\n  font-size: 0.86666667em;\n}\nsection#genericError .logoutLink:hover,\nsection#genericError .logoutLink:focus {\n  text-decoration: underline;\n}\nsection#genericError .full {\n  padding-left: 20px;\n  padding-right: 20px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n}\nsection#genericError .banner {\n  margin-bottom: 30px;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!./css/app.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/**\n* @fileOverview Base contains variables, mixins, reset, baseline, grid, and utilities\n* @name Base\n* @author hdoan\n* @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n*/\n/**\n * @fileOverview Variables contains variables\n * @name Variables\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Fonts */\n/* Colors */\n/**\n * @fileOverview Mixins contains mixins\n * @name Mixins\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/**\n * @fileOverview Reset contains reset and baseline styles\n * @name Reset\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Reset ====================================== */\nhtml,\nbody,\ndiv,\ndl,\ndt,\ndd,\nul,\nol,\nli,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\npre,\ncode,\nform,\nfieldset,\nlegend,\ninput,\ntextarea,\np,\nblockquote,\nth,\ntd {\n  margin: 0;\n  padding: 0;\n}\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\nfieldset,\nimg {\n  border: 0;\n}\naddress,\ncaption,\ncite,\ncode,\ndfn,\nem,\nstrong,\nth,\nvar {\n  font-style: normal;\n  font-weight: normal;\n}\nol,\nul {\n  list-style: none;\n}\ncaption,\nth {\n  text-align: left;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6 {\n  font-size: 100%;\n  font-weight: normal;\n}\nq:before,\nq:after {\n  content: \"\";\n}\nabbr,\nacronym {\n  border: 0;\n  font-variant: normal;\n}\n/* to preserve line-height and selector appearance */\nsup {\n  vertical-align: text-top;\n}\nsub {\n  vertical-align: text-bottom;\n}\ninput,\ntextarea,\nselect {\n  font-family: inherit;\n  font-size: inherit;\n  font-weight: inherit;\n}\n/*to enable resizing for IE*/\ninput,\ntextarea,\nselect {\n  *font-size: 100%;\n}\n/*because legend doesn't inherit in IE */\nlegend {\n  color: #000;\n}\n/* Start of base-lining, some from YUI's CSS Foundation ==================== */\nbody {\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 95%;\n  /* Base font-size is 15px */\n  color: #2c2e2f;\n  line-height: 1.35em;\n}\nh1 {\n  /*18px via YUI Fonts CSS foundation*/\n  font-size: 138.5%;\n}\nh2 {\n  /*16px via YUI Fonts CSS foundation*/\n  font-size: 123.1%;\n}\nh3 {\n  /*14px via YUI Fonts CSS foundation*/\n  font-size: 108%;\n}\nh1,\nh2,\nh3 {\n  /* top & bottom margin based on font size */\n  margin: 1em 0;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\nstrong {\n  /*bringing boldness back to headers and the strong element*/\n  font-weight: bold;\n}\na {\n  color: #0070BA;\n}\nabbr,\nacronym {\n  /*indicating to users that more info is available */\n  border-bottom: 1px dotted #000;\n  cursor: help;\n}\nem {\n  /*bringing italics back to the em element*/\n  font-style: italic;\n}\nblockquote,\nul,\nol,\ndl {\n  /*giving blockquotes and lists room to breath*/\n  margin: 1em;\n}\nol,\nul,\ndl {\n  /*bringing lists on to the page with breathing room */\n  margin-left: 2em;\n}\nol {\n  /*giving OL's LIs generated numbers*/\n  list-style: decimal outside;\n}\nul {\n  /*giving UL's LIs generated disc markers*/\n  list-style: disc outside;\n}\ndl dd {\n  /*providing spacing for definition terms*/\n  margin-left: 1em;\n}\nth,\ntd {\n  /*borders and padding to make the table readable*/\n  border: 1px solid #000;\n  padding: .5em;\n}\nth {\n  /*distinguishing table headers from data cells*/\n  font-weight: bold;\n  text-align: center;\n}\ninput {\n  margin-bottom: 10px;\n}\ncaption {\n  /*coordinated margin to match cell's padding*/\n  margin-bottom: .5em;\n  /*centered so it doesn't blend in to other content*/\n  text-align: center;\n}\np,\nfieldset,\ntable,\npre,\nlegend {\n  /*so things don't run into each other*/\n  margin-bottom: 1em;\n}\n/* setting a consistent width, 160px;\n   control of type=file still not possible */\ninput[type=text],\ninput[type=password],\ntextarea {\n  width: 12.25em;\n  *width: 11.9em;\n}\n/**\n * @fileOverview Grid contains grid rules\n * @name Grid\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n.row-fluid {\n  width: 100%;\n  *zoom: 1;\n}\n.row-fluid:before,\n.row-fluid:after {\n  display: table;\n  content: \"\";\n}\n.row-fluid:after {\n  clear: both;\n}\n.row-fluid > [class*=\"span\"] {\n  float: left;\n  margin-left: 4.127659574%;\n}\n.row-fluid > [class*=\"span\"]:first-child {\n  margin-left: 0;\n}\n.row-fluid > .span24 {\n  width: 99.999999978%;\n}\n.row-fluid > .span23 {\n  width: 95.74468083%;\n}\n.row-fluid > .span22 {\n  width: 91.48936168200001%;\n}\n.row-fluid > .span21 {\n  width: 87.234042534%;\n}\n.row-fluid > .span20 {\n  width: 82.97872338599998%;\n}\n.row-fluid > .span19 {\n  width: 78.723404238%;\n}\n.row-fluid > .span18 {\n  width: 74.46808508999999%;\n}\n.row-fluid > .span17 {\n  width: 70.212765942%;\n}\n.row-fluid > .span16 {\n  width: 65.95744679399999%;\n}\n.row-fluid > .span15 {\n  width: 61.702127646%;\n}\n.row-fluid > .span14 {\n  width: 54.446808497999996%;\n}\n.row-fluid > .span13 {\n  width: 53.19148935%;\n}\n.row-fluid > .span12 {\n  width: 48.936170202%;\n}\n.row-fluid > .span11 {\n  width: 44.680851054%;\n}\n.row-fluid > .span10 {\n  width: 40.425531905999996%;\n}\n.row-fluid > .span9 {\n  width: 36.170212758%;\n}\n.row-fluid > .span8 {\n  width: 31.91489361%;\n}\n.row-fluid > .span7 {\n  width: 27.659574462000002%;\n}\n.row-fluid > .span6 {\n  width: 23.404255313999997%;\n}\n.row-fluid > .span5 {\n  width: 19.148936166%;\n}\n.row-fluid > .span4 {\n  width: 14.893617018%;\n}\n.row-fluid > .span3 {\n  width: 10.638297869999999%;\n}\n.row-fluid > .span2 {\n  width: 6.382978722%;\n}\n.row-fluid > .span1 {\n  width: 2.127659574%;\n}\n.container-fluid {\n  padding-left: 20px;\n  padding-right: 20px;\n  *zoom: 1;\n}\n.container-fluid:before,\n.container-fluid:after {\n  display: table;\n  content: \"\";\n}\n.container-fluid:after {\n  clear: both;\n}\n.mt10 {\n  margin-top: 10px;\n}\n.mt15 {\n  margin-top: 10px;\n}\n.pt10 {\n  padding-top: 10px;\n}\n.pt15 {\n  padding-top: 15px;\n}\n.mb10 {\n  margin-bottom: 10px;\n}\n.mb15 {\n  margin-bottom: 15px;\n}\n.pb10 {\n  padding-bottom: 10px;\n}\n.pb15 {\n  padding-bottom: 15px;\n}\n.ml10 {\n  margin-left: 10px;\n}\n.ml15 {\n  margin-left: 15px;\n}\n.pl10 {\n  padding-left: 10px;\n}\n.pl15 {\n  padding-left: 15px;\n}\n.mr10 {\n  margin-right: 10px;\n}\n.mr15 {\n  margin-right: 15px;\n}\n.pr10 {\n  padding-right: 10px;\n}\n.pr15 {\n  padding-right: 15px;\n}\n/* Button styles */\n.btn {\n  height: 44px;\n  margin-bottom: 0;\n  border-style: solid;\n  border-width: 1px;\n  border-color: #0070BA;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  *margin-left: .3em;\n  display: inline-block;\n  /* IE7 inline-block hack */\n  *display: inline;\n  *zoom: 1;\n  background-color: #0070BA;\n  -webkit-transition: background-color 0.4s ease-out 0s;\n  -moz-transition: background-color 0.4s ease-out 0s;\n  -ms-transition: background-color 0.4s ease-out 0s;\n  -o-transition: background-color 0.4s ease-out 0s;\n  transition: background-color 0.4s ease-out 0s;\n  font-size: 1.0em;\n  font-weight: bold;\n  line-height: 42px;\n  color: #fff;\n  text-align: center;\n  vertical-align: middle;\n  cursor: pointer;\n  outline: none;\n  -webkit-font-smoothing: antialiased;\n}\n.btn .btn-secondary {\n  -webkit-font-smoothing: auto;\n}\n.btn:hover,\n.btn:focus {\n  background-color: #005EA6;\n}\n.btn:focus {\n  text-decoration: underline;\n}\n.btn.active,\n.btn:active {\n  background-color: #005EA6;\n  outline: 0;\n}\n.btn.disabled,\n.btn[disabled] {\n  background-color: #B2D9EA;\n  border-color: #B2D9EA;\n  cursor: default;\n}\n.btn.firstHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n.btn.secondHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\na.btn:focus,\na.btn:hover {\n  color: #fff;\n}\n.btn:first-child {\n  *margin-left: 0;\n}\n.btn-large {\n  padding: 8px 15px;\n  font-size: 18px;\n  line-height: normal;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n}\n.btn-small {\n  padding: 5px 9px;\n  font-size: 11px;\n  line-height: 16px;\n}\n.btn-mini {\n  padding: 2px 6px;\n  font-size: 11px;\n  line-height: 14px;\n}\n.btn-secondary {\n  border-style: solid;\n  border-color: #E1E7Eb;\n  color: #393F44;\n  background-color: #E1E7Eb;\n}\n.btn-secondary:hover {\n  color: #393F44;\n  border-color: #EDF2F5;\n  background-color: #EDF2F5;\n  text-decoration: none;\n}\n.btn-secondary:active,\n.btn-secondary:focus {\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n  text-decoration: underline;\n}\n.btn-secondary.disabled,\n.btn-secondary[disabled] {\n  color: #393F55;\n}\na.btn-secondary:hover,\na.btn-secondary:focus,\na.btn-secondary:active {\n  color: #393F44;\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n}\na.btn-secondary.disabled,\na.btn-secondary[disabled] {\n  color: #393F55;\n  background-color: #E7EDF0;\n}\nbutton.btn,\ninput[type=\"submit\"].btn {\n  *padding-top: 2px;\n  *padding-bottom: 2px;\n}\nbutton.btn::-moz-focus-inner,\ninput[type=\"submit\"].btn::-moz-focus-inner {\n  padding: 0;\n  border: 0;\n}\nbutton.btn.btn-large,\ninput[type=\"submit\"].btn.btn-large {\n  *padding-top: 7px;\n  *padding-bottom: 7px;\n}\nbutton.btn.btn-small,\ninput[type=\"submit\"].btn.btn-small {\n  *padding-top: 3px;\n  *padding-bottom: 3px;\n}\nbutton.btn.btn-mini,\ninput[type=\"submit\"].btn.btn-mini {\n  *padding-top: 1px;\n  *padding-bottom: 1px;\n}\nsection .buttons #backButton,\n#largeScreenAccountCreation .buttons #backButton {\n  width: 30%;\n}\nsection .buttons #proceedButton,\n#largeScreenAccountCreation .buttons #proceedButton {\n  width: 65%;\n}\nsection .buttons #proceedButton.full,\n#largeScreenAccountCreation .buttons #proceedButton.full {\n  width: 100%;\n}\nsection .buttons #proceedButton-venmoBA,\n#largeScreenAccountCreation .buttons #proceedButton-venmoBA {\n  width: 100%;\n}\n/* mixin for Select element - Dropdowns\n    *\n    * We style native select element on web and it uses native element on other devices\n    * HTML Format to use for select element:\n    *   <div class=\"dropdown\">\n    *           <label for=\"selectID\" class=\"accessAid\" id=\"forSelectID\">Select Label</label>\n    *           <select id=\"selectID\" name=\"selectID\">\n    *               <option value=\"\">Option 1</option>\n    *               <option value=\"2\">Option 2</option>\n    *           </select>\n    *       </div>\n    *\n    * @param width - defines the width of the select dropdown on form\n*/\n.custom-select-container {\n  position: relative;\n}\n/* Set the dimensions of the replaced select element and make it transparent. */\nselect.replaced {\n  position: relative;\n  z-index: 8;\n  width: 100%;\n  height: 44px;\n  border: 0;\n  line-height: 2;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  /* Move to IE-speci    fic CSS file if you want to. */\n}\n.custom-select {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 1;\n  display: block;\n  width: 100%;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.custom-select > span {\n  display: block;\n  padding: 7px 30px 7px 13px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: right -7px top -1178px;\n  color: #000;\n  line-height: 28px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .custom-select > span {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.disabled .custom-select > span {\n  background-position: right -7px top -6990px;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat right 10px center;\n  background-size: 16px;\n  color: #c72e2e;\n  border: 1px solid #c72e2e;\n}\n.custom-select span span {\n  display: block;\n  overflow: hidden;\n  height: 28px;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-size: 1em;\n}\n.custom-select.active > span {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n#task .custom-select {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.mobile .dob label {\n  position: static;\n  top: 0;\n  left: 0;\n}\ninput[type=date] {\n  padding: 5px 38px 3px 6px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  color: #333;\n  background-size: 24px;\n  background: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_cart_icons.png\") no-repeat 100% 61%;\n}\ninput[type=date]:focus {\n  border-color: #3399ff;\n}\n.showDropdopwnLabels .labelText {\n  float: left;\n  color: #aaa;\n}\n.showDropdopwnLabels .valueText {\n  float: right;\n  min-width: 90px;\n}\n@media (min-width: 0) and (max-width: 40em) {\n  .showDropdopwnLabels .labelText {\n    display: none;\n  }\n  .showDropdopwnLabels .valueText {\n    float: none;\n    min-width: 0;\n  }\n}\n.multiline-select-container {\n  outline: 0 none;\n}\n.multiline-select-container:active .innerContainer,\n.multiline-select-container:focus .innerContainer {\n  border-color: #009cde;\n}\n.multiline-select-container.open:active .innerContainer,\n.multiline-select-container.open:focus .innerContainer {\n  border-color: #ccd0d4;\n}\n.multiline-select-container option,\n.multiline-select-container select {\n  position: absolute !important;\n  left: -9999px;\n}\n.multiline-select-container .custom-select {\n  position: relative;\n}\n.multiline-select-container .custom-select span span {\n  height: auto;\n  white-space: initial;\n}\n.multiline-select-container .custom-select > span {\n  background: none;\n}\n.multiline-select-container.open .custom-select > span {\n  border-radius: 5px 5px 0 0;\n  border-bottom-color: #eee;\n}\n.multiline-select-container .arrow {\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_forms.png\");\n  background-position: left -8px top -1198px;\n  background-repeat: no-repeat;\n  height: 10px;\n  position: absolute;\n  width: 14px;\n  top: 40%;\n  right: 12px;\n}\n.validated .multiline-select-container .ng-invalid + .custom-select .arrow,\n.backendError .multiline-select-container .ng-invalid + .custom-select .arrow {\n  display: none;\n}\n.multiline-select-list {\n  position: absolute;\n  list-style: none;\n  margin: 0;\n  background-color: #fff;\n  z-index: 1000;\n  border-radius: 0 0 5px 5px;\n  border-bottom: 1px solid #ccd0d4;\n  max-height: 200px;\n  overflow: auto;\n  box-shadow: #ccc 0px -1px 1px 0px;\n}\n.multiline-select-list li {\n  padding: 10px;\n  border: 1px solid;\n  border-color: #eee #ccd0d4;\n  border-top: 0 none;\n  cursor: pointer;\n  line-height: 1.35em;\n  vertical-align: middle;\n}\n.multiline-select-list li:hover,\n.multiline-select-list li:focus,\n.multiline-select-list li:active {\n  background-color: #e5f5fc;\n  outline: 0 none;\n}\n.multiline-select-list li:first-of-type {\n  border-top: 0 none;\n}\n.multiline-select-list li:last-of-type {\n  border-bottom: 0 none;\n}\n.multiline-select-list:hover li:focus {\n  background-color: #fff;\n}\n.multiline-select-list:hover li:focus:hover,\n.multiline-select-list:hover li:focus:active {\n  background-color: #e5f5fc;\n}\n.accessAid,\n#midflash {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n/*\n * HTML elements\n */\nbody {\n  -webkit-tap-highlight-color: transparent;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  background-color: #fff;\n}\na {\n  text-decoration: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0.2);\n}\na:hover,\na:focus {\n  color: #005EA6;\n  text-decoration: underline;\n  outline: none;\n}\na.dashed {\n  text-decoration: none;\n  border-bottom: 1px #0070BA dashed;\n  font-size: 0.9em;\n}\n*[tabindex=\"-1\"] {\n  outline: none;\n}\nem {\n  font-style: normal;\n  font-weight: bold;\n}\nfieldset {\n  margin: 0;\n  padding: 0;\n  border: 0;\n}\nfieldset legend {\n  padding-bottom: 0.5em;\n  font-size: 1.5em;\n}\nsection:focus {\n  outline: none;\n}\n.show-section {\n  display: block;\n}\nhr.faded {\n  width: 100%;\n  height: 1px;\n  margin: 10px 0;\n  border: 0;\n  background-image: -webkit-gradient(linear, left top, right top, color-stop(0, transparent), color-stop(0.5, rgba(0, 0, 0, 0.3)), color-stop(1, transparent));\n  background-image: -webkit-linear-gradient(left, transparent, rgba(0, 0, 0, 0.3), transparent);\n  background-image: -moz-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -ms-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -o-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n}\n.alpha {\n  font-size: 1.50em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin: 0.5em 0;\n  line-height: 1.154em;\n}\n#loginSection h1.alpha {\n  max-width: 240px;\n}\n.asideAlpha {\n  font-size: 1.44em;\n}\naside .aside .header.noButtons .walletHeading {\n  text-align: center;\n  line-height: 1.05em;\n}\n.beta {\n  font-size: 1.54em;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.gamma {\n  font-size: 1.30em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.zeta {\n  font-size: 1.25em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.delta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin-bottom: 12px;\n  font-weight: normal;\n}\n.vprop-header {\n  font-size: 1.60em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin: 10px 0;\n  font-weight: lighter;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  line-height: 1.2em;\n}\n.vprop-content {\n  font-size: 1.0em;\n  font-family: \"HelveticaNeue\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.vprop-image {\n  margin-top: 25px;\n}\n.eta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.theta {\n  font-size: 1.0em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.value-prop-title {\n  color: #2c2e2f;\n  font-size: 24px;\n  font-weight: lighter;\n  margin: 10px 0;\n}\n.props {\n  padding: 0 0 0 5px;\n  clear: both;\n  text-align: center;\n}\n.props p,\n.props li {\n  line-height: 1.154em;\n  font-size: 0.9em;\n  font-weight: normal;\n  line-height: 1.2em;\n  margin: 5px 0;\n}\n.secondary {\n  color: #6C7378;\n  font-size: 0.85em;\n}\n.legal {\n  color: #6C7378;\n  font-size: 0.75em;\n  line-height: 1.154em;\n}\n.legal a {\n  font-weight: bold;\n}\n.mu {\n  font-size: 2.46em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-weight: normal;\n  text-shadow: 0 1px 0 #fff;\n  color: #0079c1;\n}\n/* Single property classes - 0 value or common attributes */\n.noHead {\n  margin-top: 0;\n}\n.noBottom {\n  margin-bottom: 0;\n}\n.showTray #task {\n  overflow: hidden;\n  margin-left: 0;\n}\n.hide,\n#spinner {\n  display: none;\n}\n.clearfix,\nhtml[xmlns] .clearfix,\n.loading #spinner,\n.media .img img {\n  display: block;\n}\n#billingToggleLink {\n  display: inline-block;\n}\n.left {\n  float: left;\n}\n.right {\n  float: right;\n}\n.center {\n  text-align: center;\n}\n/* End single property classes */\n.outerWrapper {\n  position: relative;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-color: #ffffff;\n}\nheader {\n  z-index: 2;\n}\nhtml.framed,\n.framed #wrapper {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\nhtml.framed .trayOpen #main {\n  height: 585px;\n}\nhtml.framed .trayOpen .asideContent {\n  height: 495px;\n}\nbody > iframe,\nbody > img {\n  display: none;\n}\n#wrapper {\n  margin: 0 auto;\n  max-width: 780px;\n  border: 1px solid #e3e3e3;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  overflow-y: visible;\n  outline: none;\n  background-color: #fff;\n}\n#wrapper #header {\n  -webkit-border-radius: 5px 5px 0 0;\n  -moz-border-radius: 5px 5px 0 0;\n  border-radius: 5px 5px 0 0;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  width: 100%;\n  background-color: #fff;\n  z-index: 4;\n  -webkit-box-shadow: 0 0 3px 0;\n  -moz-box-shadow: 0 0 3px 0;\n  box-shadow: 0 0 3px 0;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n#contents {\n  position: relative;\n  z-index: 1;\n}\n.active #wrapper {\n  visibility: visible;\n  -webkit-animation-duration: 400ms;\n  -webkit-animation-timing-function: ease;\n  -webkit-animation-name: slideUp;\n}\n#logo {\n  margin: 22px 0 0 20px;\n}\n.container {\n  clear: both;\n  padding: 20px;\n}\n.containerNoHead {\n  padding-top: 0;\n}\n.noPaddingBottom {\n  padding-bottom: 0;\n}\n.noPaddingTop {\n  padding-top: 0;\n}\n.subContainer {\n  border-top: 1px solid #e3e3e3;\n  padding: 20px 0 20px;\n  position: relative;\n}\n#proceedButton {\n  width: 46.4%;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\n#proceedButton.full {\n  width: 100%;\n}\n#proceedButton:focus {\n  color: #fff;\n}\n#backButton {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n#backButton:hover,\n#backButton:focus {\n  color: #2c2e2f;\n}\n.middleName {\n  display: none;\n  float: right;\n}\n.h2,\nh2 {\n  font-size: 1.2em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  margin-top: 0;\n  font-weight: normal;\n  color: #0666B3;\n}\n.clearfix:after {\n  height: 0;\n  display: block;\n  visibility: hidden;\n  clear: both;\n  overflow: auto;\n  line-height: 0;\n  content: \" \";\n}\n* html .clearfix {\n  height: 1%;\n}\n#sliding-area {\n  overflow: hidden;\n}\n#main {\n  padding: 25px 30px 15px;\n  -webkit-transition: margin 0.3s ease-out;\n  -moz-transition: margin 0.3s ease-out;\n  -ms-transition: margin 0.3s ease-out;\n  -o-transition: margin 0.3s ease-out;\n  transition: margin 0.3s ease-out;\n  width: 100%;\n  float: right;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.loading #main {\n  background: none;\n}\n.loginLoadingMessage,\n.bmlLoadingMessage {\n  display: none;\n}\n.loginProcessing .genericLoadingMessage {\n  display: none;\n}\n.loginProcessing .loginLoadingMessage {\n  display: block;\n}\n.full {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  text-decoration: none;\n}\n.trayInner {\n  padding: 20px 0;\n}\n.disclaimer {\n  font-size: 0.75em;\n  color: #6C7378;\n}\n.reviewMsg {\n  margin-top: 10px;\n  line-height: 1.5;\n}\n.infoTxt {\n  clear: both;\n  padding-top: 10px;\n}\n.help {\n  color: #A9A9A9;\n}\n.keyValue label {\n  color: #292929;\n}\n.frontArrow {\n  position: absolute;\n  display: inline-block;\n  width: 9px;\n  height: 15px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -196px -177px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .frontArrow {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.focusableIcon:focus {\n  box-shadow: 0 0 1px #6C7378;\n}\n.caret-down {\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -233px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .caret-down {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n/* Form styles */\ninput[type=submit],\ninput[type=button] {\n  -webkit-appearance: none;\n}\ninput[disabled=disabled],\n.inputField input[disabled=disabled],\n.inputField input[disabled=disabled]:active {\n  background: #F7F9FA;\n  border: 1px solid #CBD2D6;\n  color: #6C7378;\n}\ninput::-ms-clear {\n  display: none;\n}\ninput.link:hover {\n  cursor: pointer;\n}\ninput.xsmall {\n  width: 2em;\n}\ninput.small {\n  width: 3.35em;\n  font-size: 1em;\n}\ninput.medium {\n  width: 7em;\n}\ninput.large {\n  width: 14em;\n}\ninput.xlarge {\n  width: 20em;\n}\n.button-as-link {\n  margin: 0;\n  padding: 0;\n  border: none;\n  width: auto;\n  font-size: 0.85em;\n  background: transparent;\n  color: #0070BA;\n  cursor: pointer;\n}\n/* Hide spinner on type=number fields */\ninput[type=number]::-webkit-inner-spin-button,\ninput[type=number]::-webkit-outer-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n.buttons {\n  margin-top: 15px;\n  margin-bottom: 15px;\n  overflow: hidden;\n}\n.inputField {\n  position: relative;\n}\n.inputField label,\n.inputField input {\n  display: block;\n  vertical-align: top;\n}\n.inputField input,\n.ignoreValidation .inputField.error input,\n.validated .ignoreValidation .inputField input.ng-invalid,\n.validated .ignoreValidation .inputField input.backendError {\n  width: 100%;\n  height: 44px;\n  padding: 0 14px;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  border: 1px solid #C5CCD1;\n  color: #000;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  background: none;\n}\n.inputField input::-webkit-input-placeholder,\n.ignoreValidation .inputField.error input::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-webkit-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:-moz-placeholder,\n.ignoreValidation .inputField.error input:-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n}\n.inputField input::-moz-placeholder,\n.ignoreValidation .inputField.error input::-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n}\n.inputField input:-ms-input-placeholder,\n.ignoreValidation .inputField.error input:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-ms-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:active,\n.inputField input:focus {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n.inputField select {\n  font-size: 1.5em;\n  margin-bottom: 10px;\n}\n.custom-select-container select {\n  font-size: 15px;\n}\n.inputField label {\n  position: absolute;\n  top: 14px;\n  left: 14px;\n  cursor: text;\n  text-align: left;\n  color: #666;\n  font-size: 1em;\n}\n.no-js .inputField label,\n.no-js .dropdown label {\n  position: static;\n}\n.fieldGroup .inputField {\n  float: left;\n  padding: 0 0.5em 0 0;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.inputField.error input::-webkit-input-placeholder,\n.validated .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .inputField input.backendError::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.inputField.error input:-moz-placeholder,\n.validated .inputField input.ng-invalid:-moz-placeholder,\n.validated .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.inputField.error input::-moz-placeholder,\n.validated .inputField input.ng-invalid::-moz-placeholder,\n.validated .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.inputField.error input:-ms-input-placeholder,\n.validated .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .inputField input.backendError:-ms-input-placeholder {\n  color: #c72e2e;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n  background-size: 40px 8000px, 18px;\n}\n.inputField.valid input {\n  background: #fff url(https://www.paypalobjects.com/images/checkout/hermes/icon_checkmark_wallet_2x.png) no-repeat 98% center;\n  background-size: 14px;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  background-position: -webkit-calc(100% - 10px) center;\n  background-position: right 10px center;\n}\n.creditCardField.valid input {\n  background: #fff;\n}\n.inputField.error select,\n.dropdown.error select {\n  border: 1px solid #c72e2e;\n}\n.selectLabel {\n  display: block;\n}\ninput::-webkit-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 1em;\n}\ninput:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput:-ms-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\n/* End form styles */\n.checkbox input[type=checkbox] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.checkbox input[type=checkbox] ~ label,\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: inline-block;\n  position: static;\n  min-height: 25px;\n  padding-left: 35px;\n  line-height: 27px;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px 0;\n  vertical-align: middle;\n  cursor: pointer;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .checkbox input[type=checkbox] ~ label,\n  .checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 25px;\n  margin-left: -35px;\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.checkbox.error input[type=checkbox] ~ label,\n.checkbox.error input[type=checkbox]:focus ~ label,\n.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.checkbox input[type=checkbox]:checked ~ label,\n.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -400px;\n}\n.checkbox input[type=checkbox]:focus:checked ~ label,\n.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4801px;\n}\n.checkbox input[type=checkbox]:focus ~ label,\n.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4601px;\n}\n.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -800px;\n}\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 25px 25px;\n}\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 0;\n}\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 2600px;\n}\n.validated input[type=checkbox].ng-invalid ~ label,\n.validated input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.validated input[type=radio].ng-invalid + label::before,\n.validated input[type=radio].ng-invalid:focus + label::before,\n.validated input[type=radio].ng-invalid + label.bgImgOnSpan span.bgImg,\n.validated input[type=radio].ng-invalid:focus + label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2200px;\n}\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox {\n  position: relative;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label,\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  line-height: 19px;\n  padding-left: 27px;\n  font-size: 0.85em;\n  background-position: -9px -2600px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 19px;\n  margin-left: -27px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.sCheckbox.checkbox.error input[type=checkbox] ~ label,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3000px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -5409px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2800px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3400px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 18px 19px;\n}\n.radioButton input[type=radio] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.radioButton input[type=radio] ~ label {\n  display: inline-block;\n  min-height: 26px;\n  padding-left: 35px;\n  line-height: 27px;\n  vertical-align: middle;\n  cursor: pointer;\n  position: relative;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label {\n  padding-left: unset;\n  padding-right: 35px;\n}\n.radioButton input[type=radio] ~ label::before {\n  content: \" \";\n  display: block;\n  width: 30px;\n  height: 30px;\n  position: absolute;\n  top: 0;\n  left: 0;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px -1600px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .radioButton input[type=radio] ~ label::before {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label::before,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label::before {\n  right: 0;\n  left: unset;\n}\n.radioButton.error input[type=radio] + label::before,\n.radioButton.error input[type=radio]:focus + label::before {\n  background-position: -9px -2200px;\n}\n.radioButton.warning input[type=radio] + label::before,\n.radioButton.warning input[type=radio]:focus + label::before {\n  background-position: -9px -7405px;\n}\n.radioButton input[type=radio]:checked + label::before {\n  background-position: -9px -2000px;\n}\n.radioButton input[type=radio]:focus:checked + label::before {\n  background-position: -9px -6010px;\n}\n.radioButton input[type=radio]:focus + label::before {\n  background-position: -9px -1800px;\n}\n.inputField label.nolap {\n  position: relative;\n  top: auto;\n  left: auto;\n  color: #2c2e2f;\n}\n.inputField.half {\n  width: 48.15%;\n  margin-right: 3.7%;\n  padding-right: 0;\n}\n.singlePagePaymentForm .inputField.half,\n.multistepSignupForm .inputField.half {\n  width: 48.7%;\n  margin-right: 2.6%;\n  padding-right: 0;\n}\n.inputField.half.issueNo {\n  width: 42%;\n  margin-top: 15px;\n}\n.inputField.half.startDate {\n  width: 54%;\n  margin-right: 10px;\n}\n#cardIssueInfo .inputField.half.startDate {\n  width: 48%;\n  margin-right: 0;\n}\n#cardIssueInfo .inputField.half.issueNo {\n  width: 48%;\n  margin-top: 0;\n  float: right;\n}\n#cardIssueInfo .inputField.half.issueNo:before {\n  content: \"\\200C\";\n}\n.inputField.half.last-child {\n  margin-right: 0;\n}\n.fieldGroup .inputField.last-child {\n  padding-right: 0;\n}\n.fidobDay {\n  width: 30%;\n  float: left;\n}\n.fidobDay .custom-select > span {\n  border-radius: 5px 0 0 5px;\n  border-right: 0;\n}\n.fidobMonth {\n  width: 30%;\n  float: left;\n}\n.fidobMonth .custom-select > span {\n  border-radius: 0px;\n}\n.fidobYear {\n  width: 40%;\n  float: left;\n}\n.fidobYear .custom-select > span {\n  border-radius: 0px 5px 5px 0;\n  border-left: 0;\n}\n.cardDOB {\n  width: 100%;\n  clear: both;\n}\n.dobLabel {\n  top: auto;\n  left: auto;\n  position: relative;\n  display: block;\n  bottom: 4px;\n}\n.dobTXT {\n  margin-top: 10px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .inputField.error input,\n  .validated .inputField input.ng-invalid,\n  .validated .inputField input.backendError {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .validated select.ng-invalid + .custom-select > span,\n  .validated select.backendError + .custom-select > span {\n    background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n    background-size: 40px 8000px, 18px;\n  }\n}\n.submitted input.ng-invalid {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.submitted input.ng-invalid::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-ms-input-placeholder {\n  color: #c72e2e;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .submitted input.ng-invalid {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n.merchantHeader {\n  height: 90px;\n  margin: 0 auto;\n}\n.merchantHeader .headerWrapper {\n  max-width: 780px;\n  margin: 0 auto;\n  overflow: hidden;\n  max-height: 90px;\n  line-height: 90px;\n}\n.merchantHeader .merchantName {\n  font-size: 1.6em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n  width: 575px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  display: inline-block;\n}\n.merchantHeader img {\n  vertical-align: middle;\n}\n.paypalHeaderWrapper .logo {\n  float: left;\n  width: 112px;\n  height: 29px;\n  margin-top: 0;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .paypalHeaderWrapper .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.paypalHeaderWrapper .span14 {\n  padding-bottom: 20px;\n  border-bottom: 1px solid #dbdbdb;\n}\n.paypalHeaderWrapper .cartContainer {\n  position: static;\n  line-height: 29px;\n}\n.paypalHeaderWrapper .transctionCartDetails {\n  z-index: 2;\n}\n.paypalHeaderWrapper.paypalCredit .logo {\n  height: 35px;\n  background-position: 0 -129px;\n}\n.aside .header {\n  padding: 15px;\n  vertical-align: middle;\n  line-height: 50px;\n  border-bottom: 1px solid #e3e3e3;\n}\n.aside .header.tall {\n  min-height: 65px;\n  line-height: normal;\n  padding: 13px 15px 10px;\n  margin-bottom: 0;\n}\n.aside .asideAlpha {\n  padding: 0 30px;\n  text-align: center;\n  line-height: 1.2em;\n}\n.aside .walletHeading {\n  text-align: center;\n}\n.aside .close {\n  position: absolute;\n  top: 10px;\n  right: 15px;\n  width: 19px;\n  height: 19px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .close:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 19px;\n  height: 19px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px 0;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .close:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .close:hover:before,\n.aside .close:focus:before {\n  background-position: -223px -22px;\n}\n.aside .backArrow {\n  position: absolute;\n  top: 10px;\n  left: 15px;\n  width: 9px;\n  height: 18px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .backArrow:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 9px;\n  height: 18px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -232px -46px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .backArrow:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .backArrow:hover:before,\n.aside .backArrow:focus:before {\n  background-position: -232px -68px;\n}\n.aside .addOptions {\n  margin-top: 20px;\n}\n.aside .addOptions h2 {\n  float: left;\n  width: 70%;\n  margin-bottom: 0;\n}\n.aside .addOptions a {\n  float: right;\n  display: block;\n  line-height: 1.9em;\n  font-size: .85em;\n}\n.aside .subHeader {\n  margin-top: 20px;\n}\n.pageSepaAgreementContingency .paypalHeader.span14,\n.pageSepaMandateContingency .paypalHeader.span14,\n.pageSepaMandate .paypalHeader.span14,\n.CYCOPage .paypalHeader.span14 {\n  width: 100%;\n}\n#mobileMerchantHeader {\n  display: none;\n}\n@media (max-width: 41.3125em) {\n  .merchantHeader {\n    display: none;\n  }\n  .paypalHeaderWrapper {\n    height: 65px;\n  }\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -5px;\n    margin-right: 15px;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 30px;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -10px;\n    margin-right: 0;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 0;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n  .header {\n    height: 55px;\n  }\n  .aside .header {\n    height: auto;\n  }\n  .aside .close {\n    right: 15px;\n  }\n}\n.footer {\n  max-width: 780px;\n  margin: 10px auto;\n  font-size: 0.75em;\n}\n.cancelUrl {\n  float: left;\n}\n.micaLender {\n  display: none;\n  color: #2c2e2f;\n  clear: both;\n}\n.footerWrapper {\n  text-align: left;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper {\n    float: right;\n  }\n}\n.footerWrapper table {\n  display: inline;\n  float: left;\n  table-layout: fixed;\n  border: none;\n}\n.footerWrapper tr,\n.footerWrapper th,\n.footerWrapper td {\n  border: none;\n  font-weight: normal;\n  padding-bottom: 0;\n  padding-top: 0;\n  text-align: left;\n}\n.footerWrapper .footerLinks {\n  float: left;\n  border: none;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .footerLinks {\n    margin-right: 1em;\n  }\n}\n.footerWrapper .footerLinks li {\n  padding: 0 0.5em;\n  color: #6C7378;\n}\n.footerWrapper .footerLinks li:first-child {\n  padding-left: 0;\n}\n.footerWrapper .footerLinks li.feedbackLink {\n  color: #0070BA;\n}\n.footerWrapper .footerLinks .underline th {\n  border-bottom: 1px solid #ccc;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .languageToggleDisplay {\n    clear: none;\n    margin-left: 1.5em;\n  }\n  .footerWrapper .languageToggleDisplay::before {\n    border-left: 2px solid #9da3a6;\n    content: \" \";\n    margin: 0 0.15em;\n    display: inline-block;\n    height: 1em;\n    position: absolute;\n    left: 0;\n    top: 50%;\n    transform: translateY(-50%);\n    margin-left: -0.85em;\n  }\n}\n.footerLinks {\n  margin: 0;\n  display: inline-block;\n  text-align: left;\n}\n.footerLinks a {\n  color: #6C7378;\n}\n.footerLinks a.feedbackLink {\n  color: #0070BA;\n  margin-left: 5px;\n}\n.footerLinks th,\ntd {\n  border: none;\n}\n.policyInfoWrapper {\n  color: #6C7378;\n}\n.policyInfoWrapper p.moreInfo {\n  padding: 15px 0 20px 0;\n  float: left;\n}\n.copyright {\n  display: inline;\n  width: auto;\n  float: right;\n  margin: 0;\n  vertical-align: top;\n  color: #6C7378;\n}\n@media screen and (min-width: 41em) {\n  .copyright {\n    float: left;\n  }\n}\n.secureIcon {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: 0 -33px;\n  margin-left: 3px;\n  margin-right: 3px;\n  margin-top: 3px;\n  width: 10px;\n  height: 12px;\n  vertical-align: top;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .secureIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.poweredBy {\n  float: right;\n  margin-top: -49px;\n}\n.poweredBy .text {\n  float: left;\n  margin-top: 8px;\n  margin-right: 8px;\n  font-size: 12px;\n  font-weight: normal;\n  font-style: italic;\n  color: #6c7378;\n}\n.footerLinks li {\n  padding: 0 12px 0 0;\n  display: inline-block;\n}\n.footerLinks .last {\n  padding-right: 18px;\n  border-right: none;\n}\n.footer .policyInfoWrapper p {\n  line-height: 1.3em;\n}\n.footer .policyInfoWrapper p a {\n  font-weight: bold;\n}\n.minibrowser.AU .footer,\n.minibrowser .APAC.footer {\n  position: relative;\n  bottom: 0;\n  width: auto;\n}\n.minibrowser.AU .footer .policyInfoWrapper,\n.minibrowser .APAC.footer .policyInfoWrapper {\n  padding: 0;\n}\n.minibrowser .cancelUrl {\n  display: none;\n}\n.minibrowser .footerWrapper {\n  padding: 0 10px;\n  float: none;\n  width: 95%;\n  margin: 0;\n}\n.minibrowser .footerLinks li {\n  padding: 0 5px 0 0px;\n}\n/*\n//Country specific rules\n.DE, .fr.FR, .fr.CA {\n    .footerWrapper {\n        &:after {\n            height: 0;\n            display: block;\n            visibility: hidden;\n            clear: both;\n            overflow: auto;\n            line-height: 0;\n            content: \" \";\n        }\n    }\n    .footerLinks {\n        float: left;\n        width: 70%;\n        text-align: left;\n        li:first-child {\n            padding-left: 0;\n        }\n    }\n\n    .cancelUrl {\n        float: none;\n        margin: 5px 0;\n        width: 100%;\n    }\n}\n*/\n.APAC .policyInfoWrapper {\n  padding: 5px 0 10px 0;\n}\n.APAC .policyInfoWrapper p.moreInfo {\n  line-height: 1.3em;\n}\n.en_AU .policyInfoWrapper,\n.AU .policyInfoWrapper {\n  padding: 20px 0 10px 0;\n  color: #6C7378;\n}\n.en_AU .policyInfoWrapper p.moreInfo,\n.AU .policyInfoWrapper p.moreInfo {\n  border-bottom: 1px solid #ccc;\n}\n.en_AU .policyInfoWrapper p.moreCopyRight,\n.AU .policyInfoWrapper p.moreCopyRight {\n  padding: 5px 0 0 0;\n  clear: both;\n}\n.fr_XC .footerWrapper {\n  float: left;\n  width: 70%;\n  text-align: left;\n  padding-left: 0;\n  margin-left: -7px;\n}\n@media (max-width: 41.25em) {\n  .footer {\n    border-top: 1px solid #ccc;\n    padding: 5px 20px;\n    margin-top: 10px;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0 10px;\n  }\n  .footerWrapper {\n    padding: 0;\n    margin: 0;\n  }\n  .footerWrapper:after {\n    height: 0;\n    display: block;\n    visibility: hidden;\n    clear: both;\n    overflow: auto;\n    line-height: 0;\n    content: \" \";\n  }\n  .footerLinks {\n    float: left;\n    width: 70%;\n    text-align: left;\n  }\n  .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n  .cancelUrl {\n    float: none;\n    margin: 5px 0;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .footer {\n    margin-top: 0;\n    padding: 0.5em 2em;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0;\n  }\n  .footerWrapper,\n  .cancelUrl {\n    padding: 0;\n    margin: 5px 0px;\n    width: 100%;\n  }\n  .footerLinks,\n  .DE .footerLinks,\n  .fr.FR .footerLinks {\n    width: 65%;\n  }\n  .footerLinks li,\n  .DE .footerLinks li,\n  .fr.FR .footerLinks li {\n    padding: 0;\n    margin-right: 10px;\n  }\n  .footerLinks li.last,\n  .DE .footerLinks li.last,\n  .fr.FR .footerLinks li.last {\n    margin-right: 0;\n  }\n  .footerLinks .feedback,\n  .DE .footerLinks .feedback,\n  .fr.FR .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .copyright {\n    margin-right: 0;\n    width: 30%;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n}\n.modal-open {\n  overflow: hidden;\n}\n.modal-open .outerWrapper,\n.modal-open #wrapper,\n.modal-open #contents {\n  position: static;\n}\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 140;\n  background-color: #000;\n}\n.modal-backdrop.fade {\n  opacity: 0;\n}\n.modal-backdrop,\n.modal-backdrop.fade.in {\n  opacity: 0.54;\n}\n.modal {\n  display: none;\n  overflow: auto;\n  overflow-y: scroll;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 150;\n}\n.modal.fade .modal-wrap {\n  -webkit-transform: translate(0, -25%);\n  -moz-transform: translate(0, -25%);\n  -ms-transform: translate(0, -25%);\n  -o-transform: translate(0, -25%);\n  transform: translate(0, -25%);\n  -webkit-transition: -webkit-transform 0.3s ease-out;\n  -moz-transition: -moz-transform 0.3s ease-out;\n  -o-transition: -o-transform 0.3s ease-out;\n  transition: transform 0.3s ease-out;\n}\n.modal.fade.in .modal-wrap {\n  -webkit-transform: translate(0, 0);\n  -moz-transform: translate(0, 0);\n  -ms-transform: translate(0, 0);\n  -o-transform: translate(0, 0);\n  transform: translate(0, 0);\n}\n.modal-wrap {\n  position: relative;\n  margin: 10px;\n  background-color: #fff;\n  border: 1px solid #999;\n  border: 1px solid rgba(0, 0, 0, 0.3);\n  -webkit-border-radius: 6px;\n  -moz-border-radius: 6px;\n  border-radius: 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  -moz-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  outline: none;\n}\n.modal-header {\n  padding: 9px 15px;\n  border-bottom: 1px solid #eee;\n}\n.modal-header .close {\n  margin-top: 2px;\n}\n.modal-header h3 {\n  margin: 0;\n  line-height: 30px;\n}\n.modal-body {\n  position: relative;\n  overflow-y: auto;\n  max-height: 400px;\n  padding: 15px;\n}\n.modal-form {\n  margin-bottom: 0;\n}\n.modal-footer {\n  padding: 14px 15px 15px;\n  margin-bottom: 0;\n  text-align: right;\n  background-color: #f5f5f5;\n  border-top: 1px solid #ddd;\n  -webkit-border-radius: 0 0 6px 6px;\n  -moz-border-radius: 0 0 6px 6px;\n  border-radius: 0 0 6px 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: inset 0 1px 0 #fff;\n  -moz-box-shadow: inset 0 1px 0 #fff;\n  box-shadow: inset 0 1px 0 #fff;\n}\n.modal-footer:before,\n.modal-footer:after {\n  display: table;\n  content: \"\";\n  line-height: 0;\n}\n.modal-footer:after {\n  clear: both;\n}\n.modal-footer .btn + .btn {\n  margin-left: 5px;\n  margin-bottom: 0;\n}\n.modal-footer .btn-group .btn + .btn {\n  margin-left: -1px;\n}\n.modal-footer .btn-block + .btn-block {\n  margin-left: 0;\n}\n.spinner {\n  height: 100%;\n  width: 100%;\n  position: fixed;\n  z-index: 10;\n}\n.spinner .spinWrap {\n  width: 200px;\n  height: 100px;\n  position: fixed;\n  top: 42%;\n  left: 50%;\n  margin-left: -98px;\n  margin-top: -50px;\n}\n.spinner .spinnerImage {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 28px 0 0 -25px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/icon_ot_spin_lock_skinny.png') no-repeat;\n}\n.spinner .loader {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 0 0 0 -55px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background-color: transparent;\n  -webkit-animation: rotation .7s infinite linear;\n  -moz-animation: rotation .7s infinite linear;\n  -o-animation: rotation .7s infinite linear;\n  animation: rotation .7s infinite linear;\n  border-left: 5px solid #cbcbca;\n  border-right: 5px solid #cbcbca;\n  border-bottom: 5px solid #cbcbca;\n  border-top: 5px solid #2380be;\n  border-radius: 100%;\n}\n.spinner .genericLoadingMessage,\n.spinner .loginLoadingMessage,\n.spinner .bmlLoadingMessage {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  margin-top: 125px;\n  text-align: center;\n  z-index: 100;\n}\n.spinner.preloader {\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 1000;\n  background-color: #fff;\n}\n@-webkit-keyframes rotation {\n  from {\n    -webkit-transform: rotate(0deg);\n  }\n  to {\n    -webkit-transform: rotate(359deg);\n  }\n}\n@-moz-keyframes rotation {\n  from {\n    -moz-transform: rotate(0deg);\n  }\n  to {\n    -moz-transform: rotate(359deg);\n  }\n}\n@-o-keyframes rotation {\n  from {\n    -o-transform: rotate(0deg);\n  }\n  to {\n    -o-transform: rotate(359deg);\n  }\n}\n@keyframes rotation {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(359deg);\n  }\n}\n@media only screen and (max-width: 768px) {\n  .spinner .spinWrap {\n    width: 200px;\n    height: 100px;\n    position: fixed;\n    top: 40%;\n    left: 50%;\n    margin-left: -93px;\n    margin-top: -50px;\n  }\n}\n.aside {\n  min-height: 380px;\n}\n.aside .container {\n  padding: 15px;\n}\n.asideContent {\n  height: 100%;\n}\n.centerText {\n  text-align: center;\n}\n.fsIcons {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  min-width: 32px;\n  width: 25px;\n  height: 21px;\n  padding-right: 5px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.HOLDING .fsIcons,\n.BALANCE .fsIcons,\n.DELAYED_TRANSFER .fsIcons {\n  background-position: 0px 0px;\n}\n.ELO .fsIcons {\n  background-position: 0 -479px;\n}\n.HIPER .fsIcons {\n  background-position: 0 -458px;\n}\n.HIPERCARD .fsIcons {\n  background-position: 0 -500px;\n}\n.EBAY_MASTERCARD .fsIcons {\n  background-position: 0px -606px;\n}\n.PayPal.MasterCard .fsIcons {\n  background-position: 0 -604px;\n}\n.pinlessGlyphIcon {\n  display: inline-block;\n  position: relative;\n  top: -5px;\n  left: -8px;\n  width: 32px;\n  height: 20px;\n  font-size: 3.1rem;\n  padding-right: 5px;\n}\n.IACH .fsIcons,\n.BANK .fsIcons,\n.BANK_ACCOUNT .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.ELV .fsIcons,\n.ECHECK .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n}\n.TAB.DELAYED_TRANSFER .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.BILL_ME_LATER .fsIcons,\n.BML .fsIcons,\n.PPCREDIT .fsIcons,\n.CREDIT_OPTION .fsIcons {\n  background-position: 0 -105px;\n}\n.PAYPAL_SMART_CONNECT .fsIcons {\n  background-position: 0px 0px;\n}\n.VISA .fsIcons {\n  background-position: 0 -21px;\n}\n.MASTERCARD .fsIcons {\n  background-position: 0 -42px;\n}\n.AMEX .fsIcons {\n  background-position: 0 -63px;\n  left: 19px;\n  height: 20px;\n}\n.DISCOVER .fsIcons,\n.DISC .fsIcons {\n  background-position: 0 -84px;\n}\n.JCB .fsIcons {\n  background-position: 0px -353px;\n}\n.CHINA_UNION_PAY .fsIcons {\n  background-position: 0px -563px;\n}\n.ELECTRON .fsIcons {\n  background-position: 0 -146px;\n}\n.MAESTRO .fsIcons,\n.MSTRO .fsIcons,\n.SWITCH .fsIcons {\n  background-position: 0 -168px;\n}\n.CB_NATIONALE .fsIcons,\n.CBN .fsIcons {\n  background-position: 0 -210px;\n}\n.CELEM .fsIcons,\n.CETELEM .fsIcons {\n  background-position: 0 -311px;\n}\n.CONF .fsIcons,\n.COFINOGA .fsIcons {\n  background-position: 0 -231px;\n}\n.COFID .fsIcons,\n.COFIDIS .fsIcons {\n  background-position: 0 -437px;\n  left: 20px;\n}\n.INCENTIVE .fsIcons {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.PPSMTCONNECT .fsIcons {\n  background-position: 0 0;\n}\n.RUPAY .fsIcons {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.fsIcon {\n  display: block;\n  position: absolute;\n  width: 32px;\n  height: 21px;\n  left: 15px;\n  top: 20px;\n  min-width: 32px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  background-position: 0px 0px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.fsIcon.PAYPAL_SMART_CONNECT {\n  background-position: 0 0;\n}\n.fsIcon.PPSMTCONNECT {\n  background-position: 0 0;\n}\n.fsIcon.VISA {\n  background-position: 0 -21px;\n}\n.fsIcon.MASTER,\n.fsIcon.MCARD,\n.fsIcon.MASTERCARD {\n  background-position: 0 -42px;\n}\n.fsIcon.AMEX,\n.fsIcon.Amex {\n  background-position: 6px -63px;\n  left: 19px;\n  height: 20px;\n}\n.fsIcon.DISCOVER,\n.fsIcon.DISC {\n  background-position: 0 -84px;\n}\n.fsIcon.PPCREDIT,\n.fsIcon.BML,\n.fsIcon.BILL_ME_LATER {\n  background-position: 0 -105px;\n}\n.fsIcon.SWITCH,\n.fsIcon.MSTRO,\n.fsIcon.MAESTRO {\n  background-position: 0 -168px;\n}\n.fsIcon.CBN,\n.fsIcon.CB_NATIONALE {\n  background-position: 0 -210px;\n}\n.fsIcon.CONF,\n.fsIcon.COFINOGA {\n  background-position: 0 -231px;\n}\n.fsIcon.BANK,\n.fsIcon.PAD {\n  background-position: 6px -252px;\n  height: 19px;\n  left: 19px;\n}\n.fsIcon.INCENTIVE {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.fsIcon.CELEM,\n.fsIcon.CETELEM {\n  background-position: 0 -311px;\n}\n.fsIcon.JCB {\n  background-position: 0px -353px;\n}\n.fsIcon.COFID,\n.fsIcon.COFIDIS {\n  background-position: 0 -437px;\n  left: 20px;\n  height: 20px;\n}\n.fsIcon.HIPER {\n  background-position: 0 -458px;\n}\n.fsIcon.ELO {\n  background-position: 0 -479px;\n}\n.fsIcon.HIPERCARD {\n  background-position: 0 -500px;\n}\n.fsIcon.CHINA_UNION_PAY,\n.fsIcon.CUP {\n  background-position: 0px -563px;\n}\n.fsIcon.PayPal.MasterCard,\n.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.fsIcon.PPXMCARD {\n  background-position: 0 -584px;\n}\n.fsIcon.EBAY_MASTERCARD,\n.fsIcon.EBAYMCARD {\n  background-position: 0px -605px;\n}\n.fsIcon.CHASEPAY {\n  background-position: 0px -626px;\n  width: 36px;\n  height: 14px;\n  display: inline-block;\n  vertical-align: baseline;\n  position: static;\n  margin-bottom: -1px;\n}\n.fsIcon.pinlessIcon {\n  background-image: none;\n  font-size: 3.1rem;\n  left: 5px;\n  top: 14px;\n}\n.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.PayPal.MasterCard .fsIcons,\n.PayPal.MasterCard .fsIcon,\n.PPXMCARD .fsIcons,\n.PPXMCARD .fsIcon,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcons,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcon {\n  background-position: 0 -584px;\n}\n.fsIcon.BILL_ME_LATER_DE,\n.fsIcons.BILL_ME_LATER_DE {\n  position: static;\n  float: left;\n  background-size: auto;\n  background-image: url(\"https://www.paypalobjects.com/webstatic/credit/img/pp-ratenzahlung-logo.png\");\n  background-repeat: no-repeat;\n  background-position: initial;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n}\n.standardCardIcon.pinlessGlyphIcon {\n  display: inline-block;\n  width: 37.12px;\n  height: 24.36px;\n  font-size: 3.6rem;\n  padding-right: 8px;\n  position: relative;\n}\n.standardCardIcon.pinlessGlyphIcon:before {\n  position: absolute;\n  left: -11px;\n  top: 0px;\n}\n.standardCardIcon.fsIcon {\n  background-size: 42.92px 745.88px;\n  width: 37.12px;\n  height: 24.36px;\n}\n.standardCardIcon.fsIcon.VISA {\n  background-position: 0 -24.36px;\n}\n.standardCardIcon.fsIcon.MASTER,\n.standardCardIcon.fsIcon.MCARD,\n.standardCardIcon.fsIcon.MASTERCARD {\n  background-position: 0 -48.72px;\n}\n.standardCardIcon.fsIcon.AMEX,\n.standardCardIcon.fsIcon.Amex {\n  background-position: 5px -73.08px;\n  height: 23.2px;\n}\n.standardCardIcon.fsIcon.DISCOVER,\n.standardCardIcon.fsIcon.DISC {\n  background-position: 0 -97.44px;\n}\n.standardCardIcon.fsIcon.PPCREDIT,\n.standardCardIcon.fsIcon.BML,\n.standardCardIcon.fsIcon.BILL_ME_LATER {\n  background-position: 0 -121.8px;\n}\n.standardCardIcon.fsIcon.SWITCH,\n.standardCardIcon.fsIcon.MSTRO,\n.standardCardIcon.fsIcon.MAESTRO {\n  background-position: 0 -194.88px;\n}\n.standardCardIcon.fsIcon.CBN,\n.standardCardIcon.fsIcon.CB_NATIONALE {\n  background-position: 0 -243.6px;\n}\n.standardCardIcon.fsIcon.CONF,\n.standardCardIcon.fsIcon.COFINOGA {\n  background-position: 0 -267.96px;\n}\n.standardCardIcon.fsIcon.BANK,\n.standardCardIcon.fsIcon.BANK_ACCOUNT,\n.standardCardIcon.fsIcon.PAD {\n  background-position: 5px -292.32px;\n  height: 22.04px;\n}\n.standardCardIcon.fsIcon.INCENTIVE {\n  background-position: 0 -314.36px;\n  height: 20.88px;\n}\n.standardCardIcon.fsIcon.CELEM,\n.standardCardIcon.fsIcon.CETELEM {\n  background-position: 0 -360.76px;\n}\n.standardCardIcon.fsIcon.JCB {\n  background-position: 0px -409.48px;\n}\n.standardCardIcon.fsIcon.HIPER {\n  background-position: 0px -531.28px;\n}\n.standardCardIcon.fsIcon.ELO {\n  background-position: 0px -555.64px;\n}\n.standardCardIcon.fsIcon.HIPERCARD {\n  background-position: 0px -580px;\n}\n.standardCardIcon.fsIcon.Thirdlast {\n  background-position: 0px -600px;\n}\n.standardCardIcon.fsIcon.COFID,\n.standardCardIcon.fsIcon.COFIDIS {\n  background-position: 0px -506.92px;\n}\n.standardCardIcon.fsIcon.CHINA_UNION_PAY,\n.standardCardIcon.fsIcon.CUP {\n  background-position: 0px -653.08px;\n}\n.standardCardIcon.fsIcon.PayPal.MasterCard,\n.standardCardIcon.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.standardCardIcon.fsIcon.PPXMCARD {\n  background-position: 0 -677.44px;\n}\n.standardCardIcon.fsIcon.EBAY_MASTERCARD,\n.standardCardIcon.fsIcon.EBAYMCARD {\n  background-position: 0 -701.8px;\n}\n.standardCardIcon.fsIcon.CHASEPAY {\n  background-position: 0px -726.16px;\n  width: 36px;\n  height: 14px;\n}\n.standardCardIcon.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.infoIcon {\n  width: 19px;\n  height: 18px;\n  display: inline-block;\n  position: absolute;\n  top: 25px;\n  right: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -89px -1px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .infoIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.addOption {\n  padding: 25px 10px;\n  margin: 0 0 0 44px;\n  color: #0070BA;\n  font-size: .85em;\n}\n.plusicon {\n  display: block;\n  position: absolute;\n  left: 15px;\n  top: 22px;\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -97px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .plusicon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.infoIcon + .checkIcon {\n  display: none;\n}\n.infoMsg {\n  margin: 0;\n  overflow: hidden;\n  font-size: .85em;\n}\n.expiredIcon {\n  background: white url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  top: 6px;\n  position: relative;\n}\n.plccIcon {\n  float: left;\n  display: inline-block;\n  height: 20px;\n  background: none;\n  width: 32px;\n  position: relative;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .fsIcons {\n    height: 20px;\n  }\n  .fsIcon {\n    height: 20px;\n  }\n}\n.walletIcons {\n  position: absolute;\n  width: 30px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .walletIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons_2x.png\");\n    background-size: 90px 970px;\n  }\n}\n.walletIcons.BANK,\n.walletIcons.BANK_ACCOUNT {\n  background-position: -50px -460px;\n}\n.walletIcons.BANK.BOFA,\n.walletIcons.BANK_ACCOUNT.BOFA {\n  background-position: -50px -10px;\n}\n.walletIcons.BANK.CHASE,\n.walletIcons.BANK_ACCOUNT.CHASE {\n  background-position: -50px -130px;\n}\n.walletIcons.BANK.WELLSFARGO,\n.walletIcons.BANK_ACCOUNT.WELLSFARGO {\n  background-position: -50px -100px;\n}\n.walletIcons.BANK.CITI,\n.walletIcons.BANK_ACCOUNT.CITI {\n  background-position: -50px -40px;\n}\n.walletIcons.BANK.FIFTHTHIRD,\n.walletIcons.BANK_ACCOUNT.FIFTHTHIRD {\n  background-position: -50px -220px;\n}\n.walletIcons.BANK.CAPITAL,\n.walletIcons.BANK_ACCOUNT.CAPITAL {\n  background-position: -50px -70px;\n}\n.walletIcons.BANK.AMERITRADE,\n.walletIcons.BANK_ACCOUNT.AMERITRADE {\n  background-position: -50px -160px;\n}\n.walletIcons.BANK.SUNTRUST,\n.walletIcons.BANK_ACCOUNT.SUNTRUST {\n  background-position: -50px -280px;\n}\n.walletIcons.BANK.USBANK,\n.walletIcons.BANK_ACCOUNT.USBANK {\n  background-position: -50px -310px;\n}\n.walletIcons.BANK.USAA,\n.walletIcons.BANK_ACCOUNT.USAA {\n  background-position: -50px -250px;\n}\n.walletIcons.CARD.VISA,\n.walletIcons.PAYMENT_CARD.VISA {\n  background-position: -10px -40px;\n}\n.walletIcons.CARD.MASTER,\n.walletIcons.PAYMENT_CARD.MASTER,\n.walletIcons.CARD.MASTERCARD,\n.walletIcons.PAYMENT_CARD.MASTERCARD {\n  background-position: -10px -70px;\n}\n.walletIcons.CARD.DISCOVER,\n.walletIcons.PAYMENT_CARD.DISCOVER {\n  background-position: -10px -100px;\n}\n.walletIcons.CARD.AMEX,\n.walletIcons.PAYMENT_CARD.AMEX {\n  background-position: -10px -130px;\n}\nhr.sep,\nhr.sepPlain {\n  padding: 0;\n  margin-top: 25px;\n  height: auto;\n  border: none;\n  border-top: 1px solid #ccc;\n  color: #2c2e2f;\n  text-align: center;\n  overflow: visible;\n}\nhr.sep:after,\nhr.sepPlain:after,\nhr.sep::after,\nhr.sepPlain::after {\n  content: \"or\";\n  display: inline-block;\n  position: relative;\n  top: -0.7em;\n  font-size: 1em;\n  padding: 0 0.50em;\n  background: white;\n  color: #6c7378;\n  font-weight: normal;\n}\n.de hr.sep:after,\n.de hr.sep::after {\n  content: \"oder\";\n}\n.da hr.sep:after,\n.da hr.sep::after {\n  content: \"eller\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\n.es hr.sep:after,\n.es hr.sep::after {\n  content: \"o\";\n}\n.fr hr.sep:after,\n.fr hr.sep::after {\n  content: \"ou\";\n}\n.he hr.sep:after,\n.he hr.sep::after {\n  content: \"\\5D0\\5D5\";\n}\n.id hr.sep:after,\n.id hr.sep::after {\n  content: \"Atau\";\n}\n.it hr.sep:after,\n.it hr.sep::after {\n  content: \"oppure\";\n}\n.ja hr.sep:after,\n.ja hr.sep::after {\n  content: \"\\307E\\305F\\306F\";\n}\n.ko hr.sep:after,\n.ko hr.sep::after {\n  content: \"\\B610\\B294\";\n}\n.nl hr.sep:after,\n.nl hr.sep::after {\n  content: \"of\";\n}\n.no hr.sep:after,\n.no hr.sep::after {\n  content: \"eller\";\n}\n.pl hr.sep:after,\n.pl hr.sep::after {\n  content: \"lub\";\n}\n.pt hr.sep:after,\n.pt hr.sep::after {\n  content: \"ou\";\n}\n.ru hr.sep:after,\n.ru hr.sep::after {\n  content: \"\\418\\43B\\438\";\n}\n.sv hr.sep:after,\n.sv hr.sep::after {\n  content: \"eller\";\n}\n.th hr.sep:after,\n.th hr.sep::after {\n  content: \"\\E2B\\E23\\E37\\E2D\";\n}\n.tr hr.sep:after,\n.tr hr.sep::after {\n  content: \"Veya\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\nhr.sepPlain:after,\nhr.sepPlain::after {\n  content: '';\n}\n/*\n * @fileOverview queries.css contains media queries for responsive design/layout breakpoints.\n * @name Queries\n * @author abadri\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n@media (min-width: 0) and (max-width: 23em) {\n  #loginSection .xoTitle h1 {\n    max-width: 10em;\n  }\n}\n@media (min-width: 0) and (max-width: 30em), (max-width: 40em) and (orientation: landscape) {\n  body {\n    -webkit-text-size-adjust: 100%;\n  }\n  .merchantBrand {\n    display: none;\n  }\n  .outerWrapper {\n    background-position: left 50px;\n  }\n  .centerTray.loginSignup {\n    margin-bottom: 60px;\n  }\n  #main {\n    padding: 0;\n    background: none;\n    z-index: 2;\n  }\n  #contents {\n    padding: 0 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  .tokenization #contents {\n    padding: 0 30px;\n  }\n  .paypalHeader {\n    padding: 0 20px 20px 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  .review #wrapper {\n    min-height: 512px;\n  }\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .loginProcessing,\n  .bmlAppProcessing {\n    background-color: #f9f9f9;\n  }\n  .loggingIn {\n    margin: 0 25px;\n  }\n  .mobile .loggingIn {\n    margin: 0;\n  }\n  .saferEasier,\n  .simpler {\n    display: none;\n  }\n  #login .row-fluid {\n    padding-top: 0px;\n  }\n  #login .centerTray {\n    padding: 0;\n  }\n  #login #signupLink.btn {\n    margin: 5px 0;\n  }\n  #wrapper {\n    margin: 0;\n    width: auto;\n    -webkit-border-radius: 0;\n    -moz-border-radius: 0;\n    border-radius: 0;\n    -webkit-background-clip: padding-box;\n    -moz-background-clip: padding-box;\n    background-clip: padding-box;\n    border: none;\n  }\n  #task {\n    width: 295px;\n  }\n  .loading .spinner {\n    background-position-y: 35%;\n  }\n  .centerTray {\n    width: auto;\n  }\n  .tray .inner,\n  .accountTerms .tray .inner {\n    padding: 10px;\n  }\n  .row-fluid > [class*=\"span\"],\n  .signup {\n    width: 100%;\n    margin-left: 0;\n    float: none;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .gamma,\n  .delta {\n    font-size: 1.2em;\n  }\n  .inputField label {\n    left: 7px;\n    top: 13px;\n  }\n  .saferEasier {\n    display: none;\n  }\n  #fundingInstruments .buttons {\n    height: 40px;\n  }\n  .cityState select {\n    font-size: 14px;\n  }\n  .cityState .city {\n    width: 100%;\n  }\n  .cityState .state {\n    width: 55%;\n  }\n  .cityState .postalCode {\n    width: 40.8%;\n  }\n  #tab {\n    margin-top: 0;\n    height: 125px;\n  }\n  .toolTip.whatsthis ul {\n    width: 242px;\n    left: 9px;\n  }\n  .toolTip.whatsthis ul li {\n    font-size: 0.9em;\n  }\n  #expiration.varB .expires {\n    width: 49%;\n  }\n  #expiration .inputField {\n    padding: 0;\n  }\n  #expiration .cvc {\n    width: 44%;\n    float: right;\n  }\n  #expiration.varB .cvc {\n    width: 49%;\n  }\n  .month {\n    margin-left: 46px;\n  }\n  .separator {\n    margin-left: 5px;\n    margin-top: 3px;\n  }\n  .year {\n    margin-left: 0;\n  }\n  #expiration .cardIcon {\n    position: absolute;\n    right: 4px;\n  }\n  .details {\n    margin-right: 2px;\n  }\n  .mask #header,\n  .mask #closeButton {\n    display: none;\n  }\n}\n@media (min-width: 30.0625em) and (max-width: 41.25em) {\n  .row-fluid > .span10,\n  .row-fluid > .span12,\n  .row-fluid > .span14 {\n    width: 100%;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .outerWrapper {\n    background-position: left 59px;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  #wrapper {\n    margin: 0;\n    border: none;\n  }\n  #main {\n    padding: 0;\n  }\n  #contents {\n    padding: 0 25px;\n  }\n}\n@media (min-width: 41.3125em) {\n  .banner {\n    display: block;\n  }\n  #wrapper {\n    min-height: 0;\n    width: 95%;\n  }\n  .merchantHeader,\n  .footer {\n    width: 95%;\n  }\n  .largeScreen .centerTray {\n    margin-top: 0;\n  }\n  .signup {\n    margin-bottom: 0;\n  }\n  #genericError {\n    min-height: 375px;\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/scr_cloud_balloon.png) no-repeat center bottom;\n  }\n  #transactionDetails .merchantName {\n    display: none;\n  }\n}\n@media (device-height: 568px) and (-webkit-min-device-pixel-ratio: 2) {\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .pageLanding #contents {\n    margin: 70px auto 40px 0px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .cardType {\n    display: none;\n  }\n  ul.validations li.restriction.active {\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/close3_2x.png) no-repeat 0 2px;\n    background-size: 10px;\n  }\n  .inputField.error input {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .inputField.error input,\n  .inputField.valid input {\n    background-position: -webkit-calc(100% - 10px) center;\n    background-position: right 10px center;\n  }\n  .error .custom-select > span,\n  .error .custom-select.active > span {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2) and (min-width: 41.3125em) {\n  #genericError {\n    background-size: 640px 242px;\n  }\n}\n/*\n    .within-rtl({ ... });\n    Targets rules for both xoon and hermes, when RTL applies\n*/\n*[dir=\"rtl\"] .footerWrapper .footerLinks,\n.outerWrapper.rtl .footerWrapper .footerLinks {\n  float: right;\n}\n*[dir=\"rtl\"] .footerWrapper .footerLinks li:first-child,\n.outerWrapper.rtl .footerWrapper .footerLinks li:first-child {\n  padding-left: 12px;\n}\n@media screen and (max-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: none;\n    clear: both;\n  }\n}\n@media screen and (min-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: left;\n  }\n  *[dir=\"rtl\"] .footerWrapper .languageToggleDisplay::before,\n  .outerWrapper.rtl .footerWrapper .languageToggleDisplay::before {\n    right: 0;\n    margin-left: 0.85em;\n  }\n}\n*[dir=\"rtl\"] .paypalHeader .languageToggleDisplay,\n.outerWrapper.rtl .paypalHeader .languageToggleDisplay {\n  float: right;\n}\n#soldOut {\n  text-align: center;\n  width: 0;\n  margin: 0 auto;\n  position: relative;\n  min-width: 320px;\n  min-height: 500px;\n  min-height: 70vh;\n}\n#soldOut #soldouticon {\n  text-align: center;\n  display: inline-block;\n  margin: 0 auto;\n  position: relative;\n  margin-top: 35%;\n}\n#soldOut .left_section {\n  width: 40px;\n  height: 44px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v14.png\");\n  background-position: -160px -252px;\n  background-repeat: no-repeat;\n  background-color: #ffffff;\n  float: left;\n}\n#soldOut .text_lines {\n  float: left;\n  border-top: 2px solid #c72e2e;\n  border-bottom: 2px solid #c72e2e;\n  box-sizing: border-box;\n  line-height: 39px;\n}\n#soldOut #text {\n  font-family: \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 18px;\n  color: #c72f2e;\n  white-space: nowrap;\n}\n#soldOut #rightSection {\n  float: left;\n}\n#soldOut .shape-right {\n  display: inline-block;\n  width: 14px;\n  height: 45px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v14.png\");\n  background-position: -187px -306px;\n  background-repeat: no-repeat;\n  background-color: #ffffff;\n}\n#soldOut .soldOutMessage {\n  width: 343px;\n  height: auto;\n  font-family: \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 24px;\n  color: #2c2e2f;\n  line-height: initial;\n  margin-top: 20px;\n  float: left;\n  max-width: 290px;\n  margin-left: 10%;\n  overflow-wrap: break-word;\n}\n#soldOut #continueButtons {\n  margin-bottom: 150px;\n}\n#soldOut #Continue-Shopping {\n  margin-top: 60px;\n  max-width: 345px;\n}\n#soldOut #Continue-Shopping:hover,\n#soldOut #Continue-Shopping:focus {\n  text-decoration: underline;\n  background-color: #005EA6;\n  border-color: #005EA6;\n}\n#soldOut #Continue-ShoppingCart {\n  margin-top: 25.5px;\n  background-color: #E1E7Eb;\n  border-color: #E1E7Eb;\n  color: #323232;\n}\n#soldOut #Continue-ShoppingCart:hover {\n  text-decoration: underline;\n}\n#soldOut .optionLine {\n  width: 100%;\n  margin-top: 19.5px;\n  height: 10px;\n  border-bottom: 1px solid #d8d8d8;\n  text-align: center;\n  background-color: inherit;\n}\n#soldOut .optionText {\n  font-size: 13px;\n  background-color: #fff;\n  line-height: 13px;\n  padding: 0 5px;\n  color: #6C7378;\n  font-weight: normal;\n}\n.merchantHeader {\n  max-width: 940px!important;\n}\n@media (min-width: 0) and (max-width: 21em) {\n  #soldOut #soldouticon {\n    margin-right: 10%;\n  }\n  #soldOut .left_section {\n    margin-left: inherit;\n  }\n  #soldOut .soldOutMessage {\n    margin-left: 0;\n    margin-bottom: 30px;\n    max-width: 280px;\n  }\n  #continueButtons {\n    margin-bottom: 0!important;\n  }\n  #soldOut #Continue-Shopping {\n    margin: 40px 10% 40px 0;\n    margin-bottom: 0;\n    max-width: 280px;\n  }\n  #soldOut #Continue-ShoppingCart {\n    margin: 25.5px 10% 40px 0;\n    max-width: 280px;\n  }\n  .optionLine {\n    max-width: 280px;\n    margin-left: 0;\n  }\n  #soldOut #Continue-Shopping:hover,\n  #Continue-Shopping:focus {\n    text-decoration: underline;\n    background-color: #005EA6;\n    border-color: #005EA6;\n  }\n  .footer {\n    margin-top: 25%;\n  }\n  header,\n  .props {\n    display: BLOCK;\n    transform: translateY(25%);\n  }\n}\n@media (min-width: 21em) and (max-width: 23.438em) {\n  #soldOut .left_section {\n    margin-left: inherit;\n  }\n  #soldOut #Continue-Shopping {\n    margin: 40px 10% 120px;\n    margin-bottom: 0;\n    max-width: 280px;\n  }\n  #soldOut #Continue-ShoppingCart {\n    margin: 25.5px 10% 120px;\n    max-width: 280px;\n  }\n  #continueButtons {\n    margin-bottom: 0!important;\n  }\n  .optionLine {\n    max-width: 280px;\n    margin-left: 10%;\n  }\n  #soldOut #Continue-Shopping:hover,\n  #Continue-Shopping:focus {\n    text-decoration: underline;\n    background-color: #005EA6;\n    border-color: #005EA6;\n  }\n  #soldOut .soldOutMessage {\n    margin: 20px 10% 30px;\n    max-width: 280px;\n  }\n  .footer {\n    margin-top: 25%;\n  }\n  header,\n  .props {\n    display: BLOCK;\n    transform: translateY(25%);\n  }\n}\n@media (min-width: 23.438em) and (max-width: 27.188em) {\n  #soldOut .left_section {\n    margin-left: inherit;\n  }\n  #soldOut #Continue-Shopping {\n    margin: 40px 5% 131px;\n    margin-bottom: 0;\n    max-width: 280px;\n  }\n  #soldOut #Continue-ShoppingCart {\n    margin: 25.5px 5% 131px;\n    max-width: 280px;\n  }\n  #continueButtons {\n    margin-bottom: 0!important;\n  }\n  .optionLine {\n    max-width: 280px;\n    margin-left: 5%;\n  }\n  #soldOut #Continue-Shopping:hover,\n  #Continue-Shopping:focus {\n    text-decoration: underline;\n    background-color: #005EA6;\n    border-color: #005EA6;\n  }\n  #soldOut .soldOutMessage {\n    margin: 20px 5% 30px;\n    max-width: 280px;\n  }\n  .footer {\n    margin-top: 25%;\n  }\n  header,\n  .props {\n    display: BLOCK;\n    transform: translateY(25%);\n  }\n}\n#shoppingCart {\n  font-size: 13px;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  background-color: #fff;\n}\n#shoppingCart :focus {\n  outline-style: solid;\n  outline-color: #009cde;\n  outline-width: 2px;\n}\n#shoppingCart .header {\n  border-bottom: 1px solid #e3e3e3;\n  padding-top: 15px;\n  padding-bottom: 20px;\n}\n#shoppingCart #headerText {\n  font-size: 15px;\n  font-weight: 500;\n  display: inline;\n}\n#shoppingCart .errorMessage {\n  padding-top: 5px;\n  margin-top: 5px;\n  color: #c72f38;\n  vertical-align: 11px;\n}\n#shoppingCart .errorIcon {\n  width: 24px;\n  height: 40px;\n  display: inline-block;\n  background-image: url(https://www.paypalobjects.com/webstatic/i/consumer/onboarding/sprite_form_2x.png);\n  background-position: 99% -409px;\n  background-position: top -409px right 0px;\n  background-size: 25px;\n  background-repeat: no-repeat;\n}\n#shoppingCart .notification {\n  margin-bottom: -30px;\n}\n#shoppingCart #cartContents {\n  min-height: 500px;\n  min-height: 70vh;\n}\n#shoppingCart .continueLink {\n  display: inline;\n  position: relative;\n  font-size: 13px;\n  top: 1px;\n  float: right;\n}\n#shoppingCart a:hover,\n#shoppingCart a:focus {\n  cursor: pointer;\n}\n#shoppingCart .options {\n  color: #6C7378;\n}\n#shoppingCart .key {\n  font-weight: 500;\n}\n#shoppingCart .remove,\n#shoppingCart .update {\n  padding-top: 4px;\n  display: block;\n}\n#shoppingCart .frontArrow {\n  top: 7px;\n  right: 0;\n  position: relative;\n  background-position: -196px -181px;\n}\n#shoppingCart .frontArrow.disabled,\n#shoppingCart .frontArrow.disabled:hover,\n#shoppingCart .frontArrow.disabled:focus {\n  background-position: -196px -181px;\n}\n#shoppingCart .arrow {\n  display: none;\n  margin: 5px 0 0 5px;\n  vertical-align: middle;\n  width: 12px;\n  height: 10px;\n  cursor: pointer;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -23px -10px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  #shoppingCart .arrow {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n#shoppingCart .downward {\n  background-position: -23px 0;\n}\n#shoppingCart .guestText {\n  font-weight: 300;\n  font-size: 14px;\n  color: #2b2b2b;\n}\n#shoppingCart .formatCurrency {\n  -webkit-font-smoothing: antialiased;\n  text-decoration: inherit;\n}\n#shoppingCart .formatCurrency .currencyCode {\n  display: none;\n  font-size: 1em;\n}\n#shoppingCart .optionLine {\n  width: 100%;\n  height: 10px;\n  border-bottom: 1px solid #d8d8d8;\n  text-align: center;\n  margin: auto;\n  background-color: inherit;\n}\n#shoppingCart .optionText {\n  font-size: 13px;\n  background-color: #f7f9fa;\n  line-height: 13px;\n  padding: 0 5px;\n  font-weight: 300;\n}\n#shoppingCart .row {\n  width: 100%;\n  display: table;\n}\n#shoppingCart .total {\n  font-weight: bold;\n  width: 100%;\n  padding: 8px 0 20px 0;\n  display: table;\n}\n#shoppingCart .total .formatCurrency .currencyCode {\n  display: inherit;\n}\n#shoppingCart .memberCheckout {\n  text-align: center;\n  padding-bottom: 20px;\n  padding-top: 5px;\n}\n#shoppingCart .guestCheckout {\n  text-align: center;\n  padding-top: 25px;\n  padding-bottom: 15px;\n}\n#shoppingCart .checkoutButtons .disabled {\n  opacity: 0.5;\n}\n#shoppingCart .wrapword {\n  white-space: -moz-pre-wrap !important;\n  /* Mozilla, since 1999 */\n  white-space: -webkit-pre-wrap;\n  /*Chrome & Safari */\n  white-space: -pre-wrap;\n  /* Opera 4-6 */\n  white-space: -o-pre-wrap;\n  /* Opera 7 */\n  white-space: pre-wrap;\n  /* css-3 */\n  word-wrap: break-word;\n  /* Internet Explorer 5.5+ */\n  word-break: break-all;\n  white-space: normal;\n}\n#shoppingCart #items {\n  width: 62%;\n  margin-top: 30px;\n  display: inline-table;\n}\n#shoppingCart #items .row {\n  padding: 25px 0 25px 0;\n  border-bottom: 1px solid #e3e3e3;\n}\n#shoppingCart #items .nameOfItem {\n  width: 100%;\n  max-height: 26em;\n  font-weight: 500;\n  display: block;\n  word-wrap: break-word;\n  overflow: hidden;\n  padding-right: 10px;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n}\n#shoppingCart #items .nameOfItem.ellipsisEffect {\n  max-height: 20px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  padding-right: 10px;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n}\n#shoppingCart #items .nowrap {\n  white-space: nowrap;\n}\n#shoppingCart #items .itemNumber {\n  width: 100%;\n  max-height: 26em;\n  display: block;\n  color: #6C7378;\n  word-wrap: break-word;\n  overflow: hidden;\n  padding-right: 10px;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n}\n#shoppingCart #items .itemNumber.ellipsisEffect {\n  max-height: 20px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  padding-right: 10px;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n}\n#shoppingCart #items .hide {\n  max-height: 0!important;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n}\n#shoppingCart #items .showItem {\n  max-height: 999999px;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n}\n#shoppingCart #items .showItem.hideItem {\n  max-height: 0;\n  overflow: hidden;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n}\n#shoppingCart #items .hideDetails {\n  max-height: 0;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n  overflow: hidden;\n}\n#shoppingCart #items .hideDetails.showDetails {\n  max-height: 350px;\n  -webkit-transition: max-height 0.5s ease-in;\n  -moz-transition: max-height 0.5s ease-in;\n  -ms-transition: max-height 0.5s ease-in;\n  -o-transition: max-height 0.5s ease-in;\n  transition: max-height 0.5s ease-in;\n}\n#shoppingCart #items .rowHead {\n  padding-top: 15px;\n  padding-bottom: 14px;\n}\n#shoppingCart #items .itemDetails {\n  clear: both;\n}\n#shoppingCart .moreLessDetails {\n  display: block;\n  clear: both;\n}\n#shoppingCart .lessDetails {\n  display: block;\n  clear: both;\n}\n#shoppingCart #orderSummary {\n  width: 32%;\n  display: inline-table;\n  margin-top: 30px;\n  float: right;\n  background-color: #f7f9fa;\n  -webkit-transition: transform 0.1s linear;\n  -moz-transition: transform 0.1s linear;\n  -ms-transition: transform 0.1s linear;\n  -o-transition: transform 0.1s linear;\n  transition: transform 0.1s linear;\n  transform: translateY(0);\n}\n#shoppingCart #orderSummary .row {\n  width: 100%;\n  padding: 3.5px 0 3.5px 0;\n  display: table;\n}\n#shoppingCart #orderSummary .firstRow {\n  width: 100%;\n  padding: 15px 0 3.5px 0;\n  display: table;\n}\n#shoppingCart #orderSummary .rowHead {\n  padding-top: 15px;\n  padding-bottom: 14px;\n  border-bottom: 1px solid #e3e3e3;\n}\n#shoppingCart #orderSummary .rowHead .formatCurrency .currencyCode {\n  display: inherit;\n}\n#shoppingCart #orderSummary .lastRow {\n  width: 100%;\n  padding: 8px 0 20px 0;\n  display: table;\n}\n#shoppingCart #orderSummary .lastRow .formatCurrency .currencyCode {\n  display: inherit;\n}\n#shoppingCart #orderSummary .checkoutButtons {\n  float: none;\n  padding: 0!important;\n  border-top: 1px solid #e3e3e3;\n}\n#shoppingCart #orderSummary .checkoutButtons .paypal-button {\n  padding-bottom: 2px;\n}\n#shoppingCart #orderSummary .checkoutButtons .paypal-button-widget {\n  display: block;\n}\n#shoppingCart #orderSummary .checkoutButtons .paypal-button-tag-content {\n  display: none;\n}\n#shoppingCart #orderSummary .orderTotal {\n  font-weight: bold;\n  display: none;\n}\n#shoppingCart .alignCenter {\n  text-align: center;\n}\n#shoppingCart .alignDirection {\n  text-align: right;\n}\n#shoppingCart div .col {\n  float: left;\n  min-height: 1px;\n  overflow: visible;\n}\n#shoppingCart .description {\n  width: 30%;\n}\n#shoppingCart .quantity {\n  width: 30%;\n}\n#shoppingCart .price {\n  width: 15%;\n  text-align: left;\n  margin-left: 10px;\n}\n#shoppingCart .itemTotalCost {\n  width: 20%;\n}\n#shoppingCart .summaryElement {\n  padding-left: 20px;\n  width: 40%;\n}\n#shoppingCart .summaryElementHead {\n  padding-left: 20px;\n  width: 70%;\n}\n#shoppingCart .summaryElementCost {\n  padding-right: 20px;\n  width: 60%;\n}\n#shoppingCart .buttonsContainer {\n  padding: 20px 12% 25px 12%;\n  min-width: 226px;\n}\n#shoppingCart h4 {\n  font-size: 13px;\n  font-family: \"HelveticaNeueBold\", \"HelveticaNeue-Bold\", \"Helvetica Neue Bold\", \"HelveticaNeue\", \"Helvetica Neue\", sans-serif;\n}\n#shoppingCart #orderSummaryHead h2 {\n  font-size: 13px;\n  font-family: \"HelveticaNeueBold\", \"HelveticaNeue-Bold\", \"Helvetica Neue Bold\", \"HelveticaNeue\", \"Helvetica Neue\", sans-serif;\n  color: #2c2e2f;\n  margin-bottom: 0;\n}\n#shoppingCart .quantity {\n  text-align: center;\n}\n#shoppingCart .quantity div {\n  width: 37px;\n  display: inline;\n  border: 1px solid #cbd2d6;\n  padding: 7px 10px 7px 10px;\n  vertical-align: -10px;\n}\n#shoppingCart .quantity a.remove {\n  font-size: 13px;\n}\n#shoppingCart .quantity input {\n  border: none;\n  width: inherit;\n}\n#shoppingCart .itemTotalCost div.itemTotalInputContainer {\n  width: 37px;\n  display: inline;\n  border: 1px solid #c72f38;\n  padding: 7px 10px 7px 10px;\n  vertical-align: -10px;\n}\n#shoppingCart .itemTotalCost a {\n  font-size: 13px;\n}\n#shoppingCart .itemTotalCost input {\n  border: none;\n  width: inherit;\n}\n#shoppingCart .itemTotalCost input:focus {\n  outline: none;\n}\n#shoppingCart .stepper {\n  color: #2c2e2f;\n}\n#shoppingCart a.incr {\n  margin-right: -1px;\n  margin-left: -1px;\n  font-size: 15px;\n}\n#shoppingCart a.decr {\n  font-size: 15px;\n}\n#shoppingCart * {\n  box-sizing: border-box;\n}\n@media (max-width: 60em) and (min-width: 50em) {\n  #shoppingCart #items {\n    width: 53%;\n  }\n}\n@media (max-width: 50em) and (min-width: 20em) {\n  #shoppingCart #items {\n    width: 50%;\n  }\n  #shoppingCart .price,\n  #shoppingCart .itemPrice {\n    display: none;\n  }\n  #shoppingCart .row {\n    padding: 15px 0 15px 0;\n    border-bottom: 0;\n  }\n  #shoppingCart .moreLessDetails {\n    display: block;\n    clear: both;\n  }\n  #shoppingCart .description {\n    width: 35%;\n  }\n  #shoppingCart .quantity {\n    width: 35%;\n  }\n  #shoppingCart .price {\n    width: 15%;\n    padding-right: 20px;\n  }\n  #shoppingCart .itemTotalCost {\n    width: 30%;\n  }\n  #shoppingCart .buttonsContainer {\n    padding: 20px 4% 25px 4%;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  #shoppingCart #items {\n    display: block;\n    overflow-y: scroll;\n    width: 100%;\n    margin-top: 0;\n  }\n  #shoppingCart #items .rowHead,\n  #shoppingCart #items .itemPrice {\n    display: none;\n  }\n  #shoppingCart #items .row {\n    padding: 15px 0 15px 0;\n    border-bottom: 0;\n    border-top: 5px solid #F7F9FA;\n  }\n  #shoppingCart #items .itemDetails {\n    padding: 0 20px 0 20px;\n  }\n  #shoppingCart #items .moreLessDetails {\n    display: block;\n    clear: both;\n  }\n  #shoppingCart #items .lessDetails {\n    padding: 0 20px;\n  }\n  #shoppingCart .optionLine {\n    width: 222px;\n  }\n  #shoppingCart #orderSummary {\n    width: 100%;\n    float: left;\n    background-color: #fff;\n  }\n  #shoppingCart #orderSummary .row {\n    border: none;\n  }\n  #shoppingCart #orderSummary .rowHead {\n    border-top: 1px solid #e3e3e3;\n    padding-top: 20px;\n    padding-bottom: 20px;\n  }\n  #shoppingCart #orderSummary .firstRow {\n    padding-top: 0;\n  }\n  #shoppingCart #orderSummary .checkoutButtons {\n    border-top: 1px solid #e3e3e3;\n    background-color: #ffffff;\n  }\n  #shoppingCart #orderSummary .optionText {\n    background-color: #ffffff;\n  }\n  #shoppingCart #orderSummary .details-expand {\n    max-height: 0;\n    background-color: #f7f9fa;\n    -webkit-transition: max-height 0.5s ease-in;\n    -moz-transition: max-height 0.5s ease-in;\n    -ms-transition: max-height 0.5s ease-in;\n    -o-transition: max-height 0.5s ease-in;\n    transition: max-height 0.5s ease-in;\n    overflow: hidden;\n  }\n  #shoppingCart #orderSummary .details-expand.expansion {\n    max-height: 350px;\n    -webkit-transition: max-height 0.5s ease-in;\n    -moz-transition: max-height 0.5s ease-in;\n    -ms-transition: max-height 0.5s ease-in;\n    -o-transition: max-height 0.5s ease-in;\n    transition: max-height 0.5s ease-in;\n  }\n  #shoppingCart #orderSummary .transparent {\n    background-color: #f7f9fa;\n    background-color: rgba(247, 249, 250, 0.85);\n  }\n  #shoppingCart #orderSummary .orderTotal {\n    display: inline-block;\n  }\n  #shoppingCart #orderSummary .buttonsContainer {\n    padding-bottom: 20px;\n    width: 100%;\n  }\n  #shoppingCart #orderSummary .opaque {\n    background-color: #fff;\n  }\n  #shoppingCart .summaryElementHead {\n    width: 40%;\n  }\n  #shoppingCart #cartContents {\n    min-height: 0;\n  }\n  #shoppingCart .transparentBgr {\n    background: transparent!important;\n  }\n  #shoppingCart .arrow {\n    display: inline-block;\n  }\n  #shoppingCart .header {\n    padding-top: 15px;\n  }\n  #shoppingCart .description {\n    width: 35%;\n    padding-left: 20px;\n  }\n  #shoppingCart .quantity {\n    width: 40%;\n  }\n  #shoppingCart .price {\n    width: 15%;\n    padding-right: 20px;\n  }\n  #shoppingCart .itemTotalCost {\n    width: 25%;\n    padding-right: 20px;\n  }\n  #shoppingCart *[dir=\"ltr\"] .itemTotalCost {\n    float: right!important;\n  }\n  #shoppingCart .tileArrow::after {\n    content: \"^\";\n  }\n  #shoppingCart .itemTotal {\n    font-weight: 500;\n  }\n  #shoppingCart .notification {\n    padding-left: 20px;\n    margin-bottom: 0;\n  }\n}\n@media (max-height: 40em) and (min-height: 0) {\n  #shoppingCart .buttonsContainer {\n    padding: 5px 4% 5px 4%;\n  }\n  #shoppingCart .memberCheckout {\n    padding-bottom: 5px;\n  }\n  #shoppingCart .guestCheckout {\n    padding-top: 15px;\n    padding-bottom: 10px;\n  }\n}\n*[dir=\"rtl\"] #shoppingCart .continueLink {\n  float: left;\n}\n*[dir=\"rtl\"] #shoppingCart .frontArrow {\n  background-position: -196px -220px;\n}\n*[dir=\"rtl\"] #shoppingCart .frontArrow.disabled,\n*[dir=\"rtl\"] #shoppingCart .frontArrow.disabled:hover,\n*[dir=\"rtl\"] #shoppingCart .frontArrow.disabled:focus {\n  background-position: -196px -220px;\n}\n*[dir=\"rtl\"] #shoppingCart div.col {\n  float: right;\n}\n*[dir=\"rtl\"] #shoppingCart .alignDirection {\n  text-align: left;\n}\n*[dir=\"rtl\"] #shoppingCart #items {\n  background-color: #fff;\n  float: right;\n}\n*[dir=\"rtl\"] #shoppingCart #items .nameOfItem {\n  padding-left: 10px;\n  padding-right: 0;\n}\n*[dir=\"rtl\"] #shoppingCart #items .nameOfItem.ellipsisEffect {\n  padding-left: 10px;\n  padding-right: 0;\n}\n*[dir=\"rtl\"] #shoppingCart #items .itemNumber {\n  padding-left: 10px;\n  padding-right: 0;\n}\n*[dir=\"rtl\"] #shoppingCart #items .itemNumber.ellipsisEffect {\n  padding-left: 10px;\n  padding-right: 0;\n}\n*[dir=\"rtl\"] #shoppingCart #items .itemTotalCost {\n  padding-left: 10px;\n}\n*[dir=\"rtl\"] #shoppingCart #items .itemTotalCost.alignDirection {\n  text-align: left;\n}\n*[dir=\"rtl\"] #shoppingCart #items .moreLessDetails {\n  clear: none;\n}\n*[dir=\"rtl\"] #shoppingCart #orderSummary {\n  float: left;\n}\n*[dir=\"rtl\"] #shoppingCart #orderSummary .summaryElementHead {\n  float: right;\n  padding-left: 0;\n  padding-right: 20px;\n}\n*[dir=\"rtl\"] #shoppingCart #orderSummary .summaryElement {\n  padding-left: 0;\n  padding-right: 20px;\n}\n*[dir=\"rtl\"] #shoppingCart #orderSummary .summaryElementCost {\n  padding-right: 0;\n  padding-left: 20px;\n}\n@media (max-width: 30em) and (min-width: 0) {\n  *[dir=\"rtl\"] #shoppingCart #items .moreLessDetails {\n    display: block;\n    clear: both;\n  }\n  *[dir=\"rtl\"] #shoppingCart #items .lessDetails {\n    padding: 0 20px;\n  }\n  *[dir=\"rtl\"] #shoppingCart #items .itemTotalCost {\n    float: left;\n    padding-right: 0;\n    padding-left: 20px;\n  }\n  *[dir=\"rtl\"] #shoppingCart #items .description {\n    padding-left: 0;\n    padding-right: 20px;\n  }\n  *[dir=\"rtl\"] #shoppingCart .price {\n    padding-right: 0;\n    padding-left: 20px;\n  }\n  *[dir=\"rtl\"] #shoppingCart .notification {\n    padding-left: 0;\n    padding-right: 20px;\n  }\n}\n*[dir=\"rtl\"] #shoppingCart .paypal-button-content {\n  direction: ltr;\n}\n*[dir=\"rtl\"] .shopping-cart-container .footerLinks {\n  float: right;\n}\n*[dir=\"rtl\"] .shopping-cart-container .headerWrapper {\n  margin-right: 0!important;\n}\n.shopping-cart-container .headerWrapper {\n  margin-left: 0!important;\n}\n.shopping-cart-container .merchantHeader {\n  border-bottom: 1px solid #e3e3e3;\n  display: none;\n}\n.shopping-cart-container .showMerchantHeader {\n  display: inherit!important;\n}\n.shopping-cart-container .footer {\n  position: static;\n  max-width: 940px!important;\n  background-color: #fff;\n  margin-top: 50px!important;\n  margin-bottom: 50px!important;\n  border-top: 1px solid #d4d9dc;\n}\n.shopping-cart-container .footerWrapper {\n  width: 100%!important;\n  padding-top: 10px;\n}\n.shopping-cart-container .footerLinks {\n  float: left;\n}\n.shopping-cart-container div#wrapper {\n  border: none;\n  max-width: 1000px;\n  min-height: 540px;\n  min-height: 70vh;\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .shopping-cart-container .cartBody {\n    background-color: #F7F9FA!important;\n  }\n  .shopping-cart-container .header {\n    padding: 0 20px;\n  }\n  .shopping-cart-container #contents {\n    padding: 0!important;\n  }\n  .shopping-cart-container .footer {\n    margin-top: 0!important;\n    margin-bottom: 0!important;\n    padding-left: 15px!important;\n    padding-right: 15px!important;\n  }\n  .shopping-cart-container .poweredBy {\n    display: none;\n  }\n}\n#emptyCart .header {\n  border-bottom: 1px solid #e3e3e3;\n  padding-top: 15px;\n  padding-bottom: 20px;\n}\n#emptyCart #headerText {\n  font-size: 15px;\n  font-weight: 500;\n  display: inline;\n}\n#emptyCart .emptyCartContainer {\n  margin-top: 25%;\n  margin-bottom: 25%;\n  text-align: center;\n}\n#emptyCart .message {\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 24px;\n  font-weight: 300;\n  color: #2c2e2f;\n  width: 80%;\n  margin-left: auto;\n  margin-right: auto;\n}\n#emptyCart .message:focus {\n  outline-style: none;\n}\n#emptyCart .confirmation {\n  font-size: 1.5em;\n  text-align: center;\n  color: #2c2e2f;\n}\n#emptyCart .btn {\n  height: 44px;\n  margin-top: 30px;\n  width: 380px;\n}\n#emptyCart .btn:hover,\n#emptyCart .btn:focus {\n  text-decoration: underline;\n  background-color: #005EA6;\n  border-color: #005EA6;\n}\n#emptyCart * {\n  box-sizing: border-box;\n}\n@media (max-width: 30em) and (min-width: 0) {\n  #emptyCart .btn {\n    width: 80%;\n  }\n  #emptyCart .emptyCartContainer {\n    margin-top: 50%;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .shopping-cart-container .header {\n    padding: 0 20px;\n  }\n  .shopping-cart-container #contents {\n    padding: 0!important;\n  }\n}\n.buy-now-container {\n  width: 480px;\n  margin: 0 auto;\n}\n@media (max-width: 30em) {\n  .buy-now-container {\n    width: 100%;\n  }\n}\n.buy-now-container.error-page {\n  width: auto;\n}\n.buy-now-container #wrapper {\n  width: 100%;\n  border: 1px solid #e3e3e3;\n}\n.buy-now-container #main,\n.buy-now-container #contents {\n  padding: 0;\n}\n.buy-now-container .openbutton-wrapper {\n  padding-top: 25px;\n}\n.buy-now-container .header {\n  background-color: #f2f3f4;\n  border-top: 1px solid #e3e3e3;\n  border-bottom: 1px solid #e3e3e3;\n  padding: 10px;\n  text-align: center;\n  height: auto;\n  word-wrap: break-word;\n}\n.buy-now-container .form-wrap {\n  padding: 25px;\n}\n.buy-now-container .form-wrap form {\n  margin-bottom: 45px;\n}\n@media (max-width: 30em) {\n  .buy-now-container .form-wrap {\n    padding: 25px 10px;\n  }\n}\n.buy-now-container .inputField input {\n  border: 1px solid #9da3a6;\n}\n.buy-now-container .inputField input[disabled] {\n  cursor: not-allowed;\n  background-color: #f2f3f4;\n  border: 1px solid #9da3a6;\n  -webkit-text-fill-color: #6c7378;\n}\n.buy-now-container .amount-col,\n.buy-now-container .quantity-col {\n  box-sizing: border-box;\n}\n.buy-now-container .amount-col {\n  width: 70%;\n  float: left;\n  padding-right: 10px;\n}\n@media (max-width: 30em) {\n  .buy-now-container .amount-col {\n    width: 100%;\n    padding-right: 0;\n  }\n}\n.buy-now-container .quantity-col {\n  width: 30%;\n  float: left;\n}\n@media (max-width: 30em) {\n  .buy-now-container .quantity-col {\n    width: 100%;\n  }\n}\n.buy-now-container .continue-btn {\n  width: 100%;\n}\n.buy-now-container .cancel-link {\n  text-align: center;\n}\n.buy-now-container .description-txt {\n  text-align: center;\n  margin-bottom: 1em;\n}\n.buy-now-container .input-group {\n  position: relative;\n  display: table;\n  border-collapse: separate;\n}\n@media (max-width: 30em) {\n  .buy-now-container .input-group {\n    margin-bottom: 10px;\n  }\n}\n.buy-now-container .input-group .input-group-addon,\n.buy-now-container .input-group input {\n  display: table-cell;\n}\n.buy-now-container #itemPrice {\n  border-top-right-radius: 0;\n  border-bottom-right-radius: 0;\n  width: 100%;\n  margin: 0;\n}\n.buy-now-container .currency {\n  width: 1%;\n  vertical-align: middle;\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n  padding: 0 14px;\n  color: #6c7378;\n  border: 1px solid #9da3a6;\n  border-left: 0;\n}\n.buy-now-container .powered-by {\n  color: #6c7378;\n  text-align: center;\n  font-style: italic;\n  line-height: 2em;\n}\n.buy-now-container .powered-by .logo {\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v15.png\");\n  background-repeat: no-repeat;\n  width: 112px;\n  height: 29px;\n  display: inline-block;\n  vertical-align: middle;\n  margin-left: 5px;\n}\n.buy-now-container .footer {\n  margin: 0 auto;\n  padding: 0;\n  width: 100%;\n  border: 0;\n  box-sizing: border-box;\n}\n.buy-now-container .footer .cancelUrl,\n.buy-now-container .footer .poweredBy {\n  display: none;\n}\n.buy-now-container .footer .footerWrapper {\n  padding-top: 10px;\n  margin: 0;\n  width: 100%;\n}\n.buy-now-container .footer .footerLinks {\n  width: 70%;\n  text-align: left;\n  float: left;\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .buy-now-container .footer {\n    padding: 0 10px !important;\n  }\n  .buy-now-container .footer .footerLinks {\n    width: 65%;\n  }\n}\n*[dir=\"rtl\"] .buy-now-container .inputField.floatingLabel label {\n  right: 14px;\n  transform-origin: right top 0px;\n  left: auto;\n}\n*[dir=\"rtl\"] .buy-now-container .inputField.ltrOverride .errorTooltip {\n  right: 0;\n}\n*[dir=\"rtl\"] .buy-now-container .validated .inputField.floatingLabel input.ng-invalid {\n  padding-top: 16px;\n  padding-right: 14px;\n  padding-left: 34px;\n  background-position: 10px;\n}\n*[dir=\"rtl\"] .buy-now-container .currency {\n  border-top-right-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-top-left-radius: 4px;\n  border-bottom-left-radius: 4px;\n  border-left: 1px solid #9da3a6;\n  border-right: 0;\n}\n*[dir=\"rtl\"] .buy-now-container #itemPrice {\n  border-top-left-radius: 0;\n  border-bottom-left-radius: 0;\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n*[dir=\"rtl\"] .buy-now-container .amount-col {\n  float: right;\n  padding-right: 0;\n  padding-left: 10px;\n}\n@media (max-width: 30em) {\n  *[dir=\"rtl\"] .buy-now-container .amount-col {\n    padding-left: 0;\n  }\n}\n*[dir=\"rtl\"] .buy-now-container .quantity-col {\n  float: left;\n}\n*[dir=\"rtl\"] .buy-now-container .footer .footerLinks {\n  float: right;\n}\n/* this import should be something generated by the grunt */\n/* This file should be removed once we do the same using grunt */\n@media (min-width: 41.3125em) {\n  section#genericError .container {\n    width: 400px;\n  }\n  .genericError.footerWrapper {\n    padding: 0 3px;\n  }\n  .genericError.footerWrapper .footerLinks {\n    text-align: left;\n  }\n}\nsection#genericError {\n  height: 450px;\n  background: none;\n}\nsection#genericError .container {\n  position: relative;\n  margin: 0 auto;\n  top: 50%;\n  -webkit-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  transform: translateY(-50%);\n}\nsection#genericError .title {\n  font-size: 1.5em;\n  margin-bottom: 15px;\n  line-height: 1.2;\n}\nsection#genericError .message {\n  font-size: 1em;\n  margin-bottom: 15px;\n  color: #7b8388;\n}\nsection#genericError .secondaryMessage {\n  color: #979797;\n  line-height: 20px;\n}\nsection#genericError .logo {\n  width: 112px;\n  height: 29px;\n  margin: 5px 0 20px;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  section#genericError .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\nsection#genericError .cancelLink {\n  margin-top: 20px;\n}\nsection#genericError .logoutLink {\n  margin-top: 20px;\n  font-weight: 400;\n  text-align: center;\n  font-size: 0.86666667em;\n}\nsection#genericError .logoutLink:hover,\nsection#genericError .logoutLink:focus {\n  text-decoration: underline;\n}\nsection#genericError .full {\n  padding-left: 20px;\n  padding-right: 20px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n}\nsection#genericError .banner {\n  margin-bottom: 30px;\n}\n@media (min-width: 41.3125em) {\n  section#genericMessage .container {\n    width: 400px;\n  }\n  .genericMessage.footerWrapper {\n    float: none;\n    width: 99.4%;\n    padding: 0 3px;\n  }\n  .genericMessage.footerWrapper .footerLinks {\n    float: left;\n    width: 70%;\n    text-align: left;\n  }\n}\nsection#genericMessage {\n  height: 450px;\n  background: none;\n}\nsection#genericMessage .container {\n  position: relative;\n  margin: 0 auto;\n  top: 50%;\n  -webkit-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  transform: translateY(-50%);\n}\nsection#genericMessage .title {\n  font-size: 1.5em;\n  margin-bottom: 15px;\n}\nsection#genericMessage .message {\n  font-size: 1.0em;\n  margin-bottom: 15px;\n  color: #7b8388;\n}\nsection#genericMessage .secondaryMessage {\n  color: #979797;\n  line-height: 20px;\n}\nsection#genericMessage .logo {\n  width: 112px;\n  height: 29px;\n  margin: 5px 0 20px;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  section#genericMessage .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\nsection#genericMessage .cancelLink {\n  margin-top: 20px;\n}\nsection#genericMessage .returnButton {\n  margin-top: 30px;\n}\n.spinnerBtn .spinner {\n  margin: 8px 0 0;\n  height: 25px;\n  width: 25px;\n  position: static;\n  display: inline-block;\n  z-index: 10;\n  padding: 0;\n  background-color: transparent;\n  border-width: 1.5px;\n  border-style: solid;\n  border-radius: 100%;\n  border-color: #009cde #fff #fff;\n  top: 0;\n  left: 50%;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  -webkit-animation: rotation .7s infinite linear;\n  -moz-animation: rotation .7s infinite linear;\n  -o-animation: rotation .7s infinite linear;\n  animation: rotation .7s infinite linear;\n}\n.loading #main {\n  opacity: .1;\n}\n.spinner {\n  height: 100%;\n  width: 100%;\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 10;\n}\n.spinner .spinWrap {\n  width: 200px;\n  height: 100px;\n  position: fixed;\n  top: 42%;\n  left: 50%;\n  margin-left: -100px;\n  margin-top: -50px;\n}\n.spinner .spinnerImage {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 28px 0 0 -25px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/icon_ot_spin_lock_skinny.png') no-repeat;\n}\n.spinner .loader {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 0 0 0 -55px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background-color: transparent;\n  -webkit-animation: rotation .7s infinite linear;\n  -moz-animation: rotation .7s infinite linear;\n  -o-animation: rotation .7s infinite linear;\n  animation: rotation .7s infinite linear;\n  border-left: 5px solid #cbcbca;\n  border-right: 5px solid #cbcbca;\n  border-bottom: 5px solid #cbcbca;\n  border-top: 5px solid #2380be;\n  border-radius: 100%;\n}\n.spinner .loadingMessage {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  margin-top: 125px;\n  text-align: center;\n  z-index: 100;\n  outline: none;\n}\n@-webkit-keyframes rotation {\n  from {\n    -webkit-transform: rotate(0deg);\n  }\n  to {\n    -webkit-transform: rotate(359deg);\n  }\n}\n@-moz-keyframes rotation {\n  from {\n    -moz-transform: rotate(0deg);\n  }\n  to {\n    -moz-transform: rotate(359deg);\n  }\n}\n@-o-keyframes rotation {\n  from {\n    -o-transform: rotate(0deg);\n  }\n  to {\n    -o-transform: rotate(359deg);\n  }\n}\n@keyframes rotation {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(359deg);\n  }\n}\n@media only screen and (max-width: 768px) {\n  .spinner .spinWrap {\n    width: 200px;\n    height: 100px;\n    position: fixed;\n    top: 40%;\n    left: 50%;\n    margin-left: -93px;\n    margin-top: -50px;\n  }\n}\n@keyframes slideUp {\n  from {\n    top: 100%;\n    opacity: 0;\n  }\n  to {\n    top: 0;\n    opacity: 1;\n  }\n}\n@keyframes slideDown {\n  from {\n    top: 0;\n    opacity: 1;\n  }\n  to {\n    top: 100%;\n    opacity: 0;\n  }\n}\n@keyframes fadeIn {\n  from {\n    opacity: 0;\n    max-height: 100%;\n  }\n  to {\n    opacity: 0.85;\n    max-height: 100%;\n  }\n}\n@keyframes fadeOut {\n  from {\n    opacity: 0.85;\n    max-height: 100%;\n  }\n  to {\n    opacity: 0;\n    max-height: 100%;\n  }\n}\n.modal-wrapper .modal-overlay {\n  background: #6C7378;\n  position: fixed;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  z-index: 150;\n  display: block;\n  opacity: 0.85;\n  max-height: 100%;\n}\n.modal-wrapper .modal-dialog {\n  overflow: hidden;\n  position: fixed;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  z-index: 150;\n  opacity: 1;\n}\n.modal-wrapper .modal-content {\n  display: block;\n  position: absolute;\n  max-height: 100%;\n  overflow-y: auto;\n  left: 50%;\n  top: 50%;\n  background-color: #fff;\n  -webkit-transform: translate(-50%, -50%);\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  box-sizing: border-box;\n}\n.modal-wrapper .modal-content .close {\n  position: absolute;\n  top: 15px;\n  right: 20px;\n  width: 19px;\n  height: 19px;\n  padding: 0;\n  font-size: 0;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px 0;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .modal-wrapper .modal-content .close {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.modal-wrapper .modal-content .close:hover,\n.modal-wrapper .modal-content .close:focus {\n  background-position: -223px -22px;\n  text-decoration: none;\n}\n.modal-wrapper .modal-default {\n  height: auto;\n  width: 200px;\n  max-width: 100%;\n  padding: 30px;\n  background-clip: padding-box;\n}\n.modal-wrapper .popLink {\n  word-break: break-all;\n  font-size: 0.8em;\n}\n.modal-wrapper.animate .modal-dialog {\n  animation-name: slideUp;\n  animation-duration: 0.4s;\n}\n.modal-wrapper.animate .modal-overlay {\n  animation-name: fadeIn;\n  animation-duration: 0.4s;\n}\n.modal-wrapper.ng-hide {\n  overflow: hidden;\n}\n.modal-wrapper.ng-hide .modal-dialog {\n  opacity: 0;\n  top: 100%;\n}\n.modal-wrapper.ng-hide .modal-overlay {\n  opacity: 0;\n  max-height: 0;\n}\n.modal-wrapper.ng-hide.animate .modal-dialog {\n  animation-name: slideDown;\n  animation-duration: 0.4s;\n}\n.modal-wrapper.ng-hide.animate .modal-overlay {\n  animation-name: fadeOut;\n  animation-duration: 0.4s;\n}\n@media screen and (max-width: 660px) {\n  .mobile-interstitial,\n  .full-height.mobile-interstitial {\n    background: #fff;\n    min-height: 100%;\n    height: auto;\n  }\n  .mobile-interstitial .modal-content,\n  .full-height.mobile-interstitial .modal-content {\n    -webkit-box-sizing: border-box;\n    box-sizing: border-box;\n    position: static;\n    transform: none;\n    min-width: none;\n    width: 100%;\n    max-width: 100%;\n    top: 0;\n    left: 0;\n    padding: 15px;\n  }\n}\n.errorTooltip {\n  background-color: #c72e2e;\n  border-radius: 5px;\n  color: #fff;\n  display: none;\n  padding: 7px;\n  position: absolute;\n  top: 49px;\n  z-index: 2;\n  font-size: .8em;\n}\n.errorTooltip.fixed {\n  position: relative;\n  top: 0;\n  margin-bottom: 10px;\n}\n.errorTooltipRequired {\n  z-index: 3;\n}\n.validated .ng-invalid:focus ~ .errorTooltipRuleSpecific,\n.validated .ng-invalid:focus ~ .errorTooltipRequired ~ .errorTooltipRuleSpecific {\n  display: block !important;\n}\n.validated .ng-invalid-required:focus ~ .errorTooltipRuleSpecific,\n.validated .ng-invalid-required:focus ~ .errorTooltipRequired ~ .errorTooltipRuleSpecific {\n  display: none !important;\n}\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ .errorTooltipRuleSpecific,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ .errorTooltipRuleSpecific {\n  display: none !important;\n}\n.validated .ng-invalid-required:focus:not([type=checkbox]) ~ .errorTooltipRequired,\n.validated input[type=checkbox].ng-invalid:focus:not(.hasErrorTooltipRuleSpecific) ~ .errorTooltipRequired,\n.validated input[type=checkbox].ng-invalid.hasErrorTooltipRuleSpecific:focus ~ .errorTooltipRuleSpecific {\n  display: block !important;\n}\n.validated input[type=checkbox].ng-invalid + .errorTooltipRuleSpecific,\n.validated input[type=checkbox].ng-invalid + .errorTooltipRequired + .errorTooltipRuleSpecific {\n  top: 35px;\n  left: -20px;\n}\n.validated .errorTooltip:empty {\n  display: none !important;\n}\n.backendError:focus ~ .errorTooltipRuleSpecific {\n  display: block;\n}\n.validated .ng-invalid,\n.validated input.ng-invalid:focus,\n.validated input.ng-invalid:active,\n.custom-select-container > select.backendError + span.custom-select > span,\ninput.backendError,\n.inputField input.backendError {\n  border: 1px solid #c72e2e;\n}\n.toolTip {\n  display: none;\n  font-size: .8em;\n  color: #2c2e2f;\n}\n.toolTip.balloon {\n  position: absolute;\n  z-index: 2;\n  padding: 7px;\n  text-align: left;\n  border: 1px solid #e1e7eb;\n  border-radius: 5px;\n  background: #e1e7eb;\n}\n.toolTip.displayInline {\n  font-size: .9em;\n  padding: 10px 30px;\n  font-size: 0.85em;\n}\n.highZindexTooltip .toolTip.balloon {\n  z-index: 3;\n}\n.left {\n  left: 0;\n}\n.right {\n  right: 0;\n}\n/**\n * DO NOT EDIT THIS FILE AS IT'S GENERATED CODE.\n * PLEASE NOTE: If you have specific icon needs, place them in your project's own Less file.\n*/\n/*\n * Use this for local testing\n *\n@font-face {\n\tfont-family: 'consumer-icons';\n\n\tsrc: url('fonts/ConsumerIcons-Regular.eot');\n\tsrc: url('fonts/ConsumerIcons-Regular.eot?#iefix') format('embedded-opentype'),\n\t\turl('fonts/ConsumerIcons-Regular.woff') format('woff'),\n\t\turl('fonts/ConsumerIcons-Regular.ttf')  format('truetype'),\n\t\turl('fonts/ConsumerIcons-Regular.svg#69ac2c9fc1e0803e59e06e93859bed03') format('svg');\n\n\tfont-style: normal;\n\tfont-weight: 400;\n} */\n/*\n * Use this for production\n *\n */\n@font-face {\n  font-family: 'consumer-icons';\n  src: url('https://www.paypalobjects.com/ui-web/iconfont-consumer/3-4-0/fonts/ConsumerIcons-Regular.eot');\n  src: url('https://www.paypalobjects.com/ui-web/iconfont-consumer/3-4-0/fonts/ConsumerIcons-Regular.eot?#iefix') format('embedded-opentype'), url('https://www.paypalobjects.com/ui-web/iconfont-consumer/3-4-0/fonts/ConsumerIcons-Regular.woff') format('woff'), url('https://www.paypalobjects.com/ui-web/iconfont-consumer/3-4-0/fonts/ConsumerIcons-Regular.ttf') format('truetype'), url('https://www.paypalobjects.com/ui-web/iconfont-consumer/3-4-0/fonts/ConsumerIcons-Regular.svg#69ac2c9fc1e0803e59e06e93859bed03') format('svg');\n  font-style: normal;\n  font-weight: 400;\n}\n.icon {\n  font-family: 'consumer-icons';\n  speak: none;\n  font-style: normal;\n  font-weight: normal;\n  font-variant: normal;\n  text-transform: none;\n  line-height: 0;\n  /* Better Font Rendering =========== */\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n.icon-small:before {\n  font-size: 1.58rem;\n}\n.icon-medium:before {\n  font-size: 2.6rem;\n}\n.icon-large:before {\n  font-size: 7.8rem;\n}\n.icon-burger-small:before {\n  content: \"\\E000\";\n}\n.icon-slider-small:before {\n  content: \"\\E001\";\n}\n.icon-slider-half-small:before {\n  content: \"\\E002\";\n}\n.icon-close-small:before {\n  content: \"\\E003\";\n}\n.icon-add-small:before {\n  content: \"\\E004\";\n}\n.icon-arrow-down-small:before {\n  content: \"\\E005\";\n}\n.icon-arrow-up-small:before {\n  content: \"\\E006\";\n}\n.icon-arrow-left-small:before {\n  content: \"\\E007\";\n}\n.icon-arrow-right-small:before {\n  content: \"\\E008\";\n}\n.icon-arrow-down-half-small:before {\n  content: \"\\E009\";\n}\n.icon-arrow-up-half-small:before {\n  content: \"\\E010\";\n}\n.icon-arrow-left-half-small:before {\n  content: \"\\E011\";\n}\n.icon-arrow-right-half-small:before {\n  content: \"\\E012\";\n}\n.icon-clear-half-small:before {\n  content: \"\\E013\";\n}\n.icon-checkmark-small:before {\n  content: \"\\E014\";\n}\n.icon-checkmark-small-bold:before {\n  content: \"\\E015\";\n}\n.icon-action-arrow-half-small:before {\n  content: \"\\E016\";\n}\n.icon-tooltip-outline-small:before {\n  content: \"\\E017\";\n}\n.icon-tooltip-small:before {\n  content: \"\\E018\";\n}\n.icon-info-small:before {\n  content: \"\\E019\";\n}\n.icon-positive-small:before {\n  content: \"\\E020\";\n}\n.icon-attention-small:before {\n  content: \"\\E021\";\n}\n.icon-critical-small:before {\n  content: \"\\E022\";\n}\n.icon-info-large:before {\n  content: \"\\E023\";\n}\n.icon-positive-large:before {\n  content: \"\\E024\";\n}\n.icon-attention-large:before {\n  content: \"\\E025\";\n}\n.icon-critical-large:before {\n  content: \"\\E026\";\n}\n.icon-pp-logo:before {\n  content: \"\\E029\";\n}\n.icon-visa-logo:before {\n  content: \"\\E030\";\n}\n.icon-mastercard-logo:before {\n  content: \"\\E031\";\n}\n.icon-maestro-logo:before {\n  content: \"\\E032\";\n}\n.icon-amex-logo:before {\n  content: \"\\E033\";\n}\n.icon-discover-logo:before {\n  content: \"\\E034\";\n}\n.icon-card-half-solid:before {\n  content: \"\\E035\";\n}\n.icon-bank-half-solid:before {\n  content: \"\\E036\";\n}\n.icon-profile-large:before {\n  content: \"\\E037\";\n}\n.icon-profile-add-large:before {\n  content: \"\\E038\";\n}\n.icon-notification-small:before {\n  content: \"\\E039\";\n}\n.icon-settings-small:before {\n  content: \"\\E040\";\n}\n.icon-profile-small:before {\n  content: \"\\E041\";\n}\n.icon-funnel-small:before {\n  content: \"\\E042\";\n}\n.icon-delete-small:before {\n  content: \"\\E043\";\n}\n.icon-edit-small:before {\n  content: \"\\E044\";\n}\n.icon-lock-small:before {\n  content: \"\\E045\";\n}\n.icon-pdf-small:before {\n  content: \"\\E046\";\n}\n.icon-contact-small:before {\n  content: \"\\E047\";\n}\n.icon-undo-small:before {\n  content: \"\\E048\";\n}\n.icon-cancel-small:before {\n  content: \"\\E049\";\n}\n.icon-simple-list-small:before {\n  content: \"\\E050\";\n}\n.icon-detailed-list-small:before {\n  content: \"\\E051\";\n}\n.icon-print-small:before {\n  content: \"\\E052\";\n}\n.icon-camera-small:before {\n  content: \"\\E053\";\n}\n.icon-info-outline-small:before {\n  content: \"\\E054\";\n}\n.icon-us-dollar-outline-small:before {\n  content: \"\\E055\";\n}\n.icon-calendar-half-small:before {\n  content: \"\\E056\";\n}\n.icon-hiper-logo:before {\n  content: \"\\E057\";\n}\n.icon-hipercard-logo:before {\n  content: \"\\E058\";\n}\n.icon-elo-logo:before {\n  content: \"\\E059\";\n}\n.icon-star-small:before {\n  content: \"\\E060\";\n}\n.icon-jcb-logo:before {\n  content: \"\\E061\";\n}\n.icon-attention-outline-small:before {\n  content: \"\\E062\";\n}\n.icon-unionpay-logo:before {\n  content: \"\\E063\";\n}\n.icon-search-small:before {\n  content: \"\\E064\";\n}\n.icon-desktop-small:before {\n  content: \"\\E065\";\n}\n.icon-mobile-small:before {\n  content: \"\\E066\";\n}\n.icon-laptop-small:before {\n  content: \"\\E067\";\n}\n.icon-tablet-small:before {\n  content: \"\\E068\";\n}\n.icon-send-money:before {\n  content: \"\\E500\";\n}\n.icon-request-money:before {\n  content: \"\\E501\";\n}\n.icon-photo:before {\n  content: \"\\E502\";\n}\n.icon-gift-cards:before {\n  content: \"\\E503\";\n}\n.icon-credit-card:before {\n  content: \"\\E504\";\n}\n.icon-truck:before {\n  content: \"\\E505\";\n}\n.icon-email:before {\n  content: \"\\E506\";\n}\n.icon-email-solid:before {\n  content: \"\\E507\";\n}\n.icon-bank-check:before {\n  content: \"\\E508\";\n}\n.icon-calendar:before {\n  content: \"\\E509\";\n}\n.icon-holiday:before {\n  content: \"\\E510\";\n}\n.icon-gift:before {\n  content: \"\\E511\";\n}\n.icon-wallet:before {\n  content: \"\\E512\";\n}\n.icon-play-video:before {\n  content: \"\\E513\";\n}\n.icon-heart:before {\n  content: \"\\E514\";\n}\n.icon-shield:before {\n  content: \"\\E515\";\n}\n.icon-tunes:before {\n  content: \"\\E516\";\n}\n.icon-invoice:before {\n  content: \"\\E517\";\n}\n.icon-shopping-bag:before {\n  content: \"\\E518\";\n}\n.icon-phone:before {\n  content: \"\\E519\";\n}\n.icon-phone-solid:before {\n  content: \"\\E520\";\n}\n.icon-tag:before {\n  content: \"\\E521\";\n}\n.icon-delivery:before {\n  content: \"\\E522\";\n}\n.icon-questionmark:before {\n  content: \"\\E523\";\n}\n.icon-cut-coupons:before {\n  content: \"\\E524\";\n}\n.icon-register:before {\n  content: \"\\E525\";\n}\n.icon-house:before {\n  content: \"\\E526\";\n}\n.icon-gift-card:before {\n  content: \"\\E527\";\n}\n.icon-messages:before {\n  content: \"\\E528\";\n}\n.icon-add-money:before {\n  content: \"\\E529\";\n}\n.icon-send-check:before {\n  content: \"\\E530\";\n}\n.icon-paypal-me:before {\n  content: \"\\E531\";\n}\n.icon-pp-logo-outline:before {\n  content: \"\\E532\";\n}\n.icon-money-bag:before {\n  content: \"\\E533\";\n}\n.icon-chip-pin:before {\n  content: \"\\E534\";\n}\n.icon-boleto-ready:before {\n  content: \"\\E535\";\n}\n.icon-boleto-topup:before {\n  content: \"\\E536\";\n}\n.icon-clock-pay:before {\n  content: \"\\E537\";\n}\n.icon-speeding-cart:before {\n  content: \"\\E538\";\n}\n.icon-international-transfer:before {\n  content: \"\\E539\";\n}\n.icon-link-small:before {\n  content: \"\\E540\";\n}\n@media (min-width: 42em) {\n  .mobileApp header {\n    display: none;\n  }\n  .mobileApp #wrapper {\n    margin: 0;\n    max-width: inherit;\n    width: 100%;\n  }\n  .mobileApp .paypalHeader {\n    width: 100%;\n  }\n  .mobileApp .footer {\n    max-width: inherit;\n  }\n  .mobileApp section .row-fluid .span14 {\n    width: 100%;\n  }\n  .mobileApp section .row-fluid .span10 {\n    display: none;\n  }\n  .mobileApp .feedback {\n    display: none;\n  }\n}\n@keyframes pulse {\n  from {\n    transform: scale(1, 1);\n    -webkit-transform: scale(1, 1);\n  }\n  50% {\n    transform: scale(1.1, 1.1);\n    -webkit-transform: scale(1.1, 1.1);\n  }\n  to {\n    transform: scale(1, 1);\n    -webkit-transform: scale(1, 1);\n  }\n}\n@-webkit-keyframes pulse {\n  from {\n    transform: scale(1, 1);\n    -webkit-transform: scale(1, 1);\n  }\n  50% {\n    transform: scale(1.1, 1.1);\n    -webkit-transform: scale(1.1, 1.1);\n  }\n  to {\n    transform: scale(1, 1);\n    -webkit-transform: scale(1, 1);\n  }\n}\n.pulseAnimation {\n  animation-name: pulse;\n  animation-duration: 1s;\n  animation-iteration-count: 1;\n  animation-delay: 0s;\n  -webkit-animation-name: pulse;\n  -webkit-animation-duration: 1s;\n  -webkit-animation-iteration-count: 1;\n  -webkit-animation-delay: 0s;\n}\n@keyframes shake {\n  0%,\n  100% {\n    -webkit-transform: translateX(0);\n    -ms-transform: translateX(0);\n    transform: translateX(0);\n  }\n  10%,\n  30%,\n  50%,\n  70%,\n  90% {\n    -webkit-transform: translateX(-10px);\n    -ms-transform: translateX(-10px);\n    transform: translateX(-10px);\n  }\n  20%,\n  40%,\n  60%,\n  80% {\n    -webkit-transform: translateX(10px);\n    -ms-transform: translateX(10px);\n    transform: translateX(10px);\n  }\n}\n@-webkit-keyframes shake {\n  0%,\n  100% {\n    -webkit-transform: translateX(0);\n    -ms-transform: translateX(0);\n    transform: translateX(0);\n  }\n  10%,\n  30%,\n  50%,\n  70%,\n  90% {\n    -webkit-transform: translateX(-10px);\n    -ms-transform: translateX(-10px);\n    transform: translateX(-10px);\n  }\n  20%,\n  40%,\n  60%,\n  80% {\n    -webkit-transform: translateX(10px);\n    -ms-transform: translateX(10px);\n    transform: translateX(10px);\n  }\n}\n.shakeAnimation {\n  animation-name: shake;\n  animation-duration: 1s;\n  animation-iteration-count: 1;\n  animation-delay: 0s;\n  -webkit-animation-name: shake;\n  -webkit-animation-duration: 1s;\n  -webkit-animation-iteration-count: 1;\n  -webkit-animation-delay: 0s;\n}\n.custom-select-container {\n  position: relative;\n}\n/* Set the dimensions of the replaced select element and make it transparent. */\nselect.replaced {\n  position: relative;\n  z-index: 8;\n  width: 100%;\n  height: 44px;\n  border: 0;\n  line-height: 2;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  /* Move to IE-specific CSS file if you want to. */\n}\n.custom-select {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 1;\n  display: block;\n  width: 100%;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.custom-select > span {\n  display: block;\n  padding: 7px 33px 7px 13px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: right -7px top -1182px;\n  color: #000;\n  line-height: 28px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .custom-select > span {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.error .custom-select > span,\n.error .custom-select.active > span {\n  background: url(\"https://www.paypalobjects.com/images/checkout/hermes/error-icon.png\") no-repeat right 10px center;\n  background-size: 16px;\n  color: #c72e2e;\n  border: 1px solid #c72e2e;\n}\n.custom-select span span {\n  display: block;\n  overflow: hidden;\n  height: 28px;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-size: 1em;\n}\n.custom-select.active > span {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n#task .custom-select {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.mobile .dob label {\n  position: static;\n  top: 0;\n  left: 0;\n}\ninput[type=date] {\n  padding: 5px 38px 3px 6px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  color: #333;\n  background-size: 24px;\n  background: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_cart_icons.png\") no-repeat 100% 61%;\n}\ninput[type=date]:focus {\n  border-color: #3399ff;\n}\n@media (min-width: 0) and (max-width: 40em) {\n  .showDropdopwnLabels .labelText {\n    display: none;\n  }\n  .showDropdopwnLabels .valueText {\n    float: none;\n    min-width: 0;\n  }\n}\n.framed ul.footerLinks::before {\n  width: 12px;\n  height: 12px;\n  margin: 3px 10px 10px 0;\n  display: block;\n  float: left;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: 0 -33px;\n  content: '';\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .framed ul.footerLinks::before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.framed .btn.escapeHatch {\n  width: 22px;\n  height: 20px;\n  border: 0;\n  margin-left: 0;\n  display: inline-block;\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png');\n  background-size: 200px;\n  background-position: -151px -35px;\n  background-color: transparent;\n  cursor: pointer;\n}\n.framed #closeButton {\n  width: 11px;\n  height: 14px;\n  padding: 0;\n  position: fixed;\n  top: 29px;\n  right: 20px;\n  display: block;\n  z-index: 5;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -44px 1px;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0.2);\n  text-indent: -999em;\n  overflow: hidden;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .framed #closeButton {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.framed .paypalHeaderWrapper .cartContainer {\n  margin-top: 10px;\n  margin-right: 35px;\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .framed .footerLinks,\n  .framed .DE footerLinks,\n  .framed .fr.FR .footerLinks {\n    width: 45%;\n  }\n  .framed .copyright,\n  .framed .DE .copyright {\n    float: left;\n    width: 28%;\n  }\n  .framed .paypalHeaderWrapper .paypalHeader {\n    padding-bottom: 15px;\n  }\n  .framed .paypalHeaderWrapper .cartContainer {\n    margin-top: 10px;\n    margin-right: 35px;\n  }\n  .framed .paypalHeaderWrapper .logo {\n    margin: 18px 0 0;\n  }\n  .framed .spinner {\n    position: fixed;\n  }\n  .framed .spinner .spinWrap {\n    position: fixed;\n    top: 50%;\n    height: 48px;\n    margin-top: -24px;\n  }\n  .framed .footer {\n    padding: 5px 22px;\n  }\n  .framed .secureIcon {\n    display: none;\n  }\n}\n@media (max-width: 41.3125em) {\n  .framed .paypalHeaderWrapper .cartContainer {\n    margin-top: 10px;\n    margin-right: 35px;\n  }\n}\n*[dir=\"rtl\"] {\n  direction: rtl;\n  unicode-bidi: embed;\n}\n*[dir=\"rtl\"] .ltrOverride {\n  direction: ltr;\n  unicode-bidi: bidi-override;\n}\n*[dir=\"rtl\"] .row-fluid > [class*=\"span\"] {\n  float: right;\n}\n*[dir=\"rtl\"] .row-fluid > .span10 {\n  float: left;\n  margin-left: 0;\n}\n*[dir=\"rtl\"] .paypalHeaderWrapper .logo {\n  float: right;\n  margin-right: 5px;\n}\n*[dir=\"rtl\"] input::-webkit-input-placeholder {\n  /* WebKit browsers */\n  direction: rtl;\n}\n*[dir=\"rtl\"] input:-moz-placeholder {\n  /* Mozilla Firefox 4 to 18 */\n  direction: rtl;\n  text-align: right;\n}\n*[dir=\"rtl\"] input::-moz-placeholder {\n  /* Mozilla Firefox 19+  */\n  direction: rtl;\n  text-align: right;\n}\n*[dir=\"rtl\"] input:-ms-input-placeholder {\n  /* Internet Explorer 10+ */\n  direction: rtl;\n}\n*[dir=\"rtl\"] .msg-error .icon,\n*[dir=\"rtl\"] .msg-info .icon,\n*[dir=\"rtl\"] .msg-warning .icon,\n*[dir=\"rtl\"] .msg-success .icon,\n*[dir=\"rtl\"] .msg-desc .icon {\n  left: auto;\n  right: 0;\n}\n*[dir=\"rtl\"] .msgPage ul {\n  padding: 0 25px 0 0;\n}\n*[dir=\"rtl\"] .merchantHeader .merchantName {\n  text-align: right;\n}\n*[dir=\"rtl\"] .cartContainer {\n  float: left;\n  right: auto;\n  left: 0;\n  margin-left: 0;\n}\n*[dir=\"rtl\"] #transactionCart {\n  float: left;\n}\n*[dir=\"rtl\"] #transactionCart .arrow {\n  margin: 5px 5px 0 0;\n}\n*[dir=\"rtl\"] #transactionCart .cartIcon {\n  margin: 0 0 0 6px;\n}\n*[dir=\"rtl\"] .hasNoItems.transactionDetails #transactionCart,\n*[dir=\"rtl\"] .hasNoItems.transactionDetails:active #transactionCart,\n*[dir=\"rtl\"] .hasNoItems.transactionDetails:focus #transactionCart,\n*[dir=\"rtl\"] #transactionDetails.cart .hasNoItems #transactionCart {\n  background-position: right 9px;\n  padding-right: 27px;\n  padding-left: 0;\n}\n*[dir=\"rtl\"] .transctionCartDetails {\n  left: 43.425531928%;\n  right: auto;\n}\n*[dir=\"rtl\"] .transctionCartDetails .pointer {\n  right: auto;\n  left: 38px;\n}\n*[dir=\"rtl\"] .transctionCartDetails .detail-items .items .itemPrice,\n*[dir=\"rtl\"] .transctionCartDetails .detail-extras .amounts .itemPrice,\n*[dir=\"rtl\"] .transctionCartDetails .subTotal .itemPrice {\n  text-align: left;\n}\n*[dir=\"rtl\"] .transctionCartDetails .detail-items .items .itemName,\n*[dir=\"rtl\"] .transctionCartDetails .detail-extras .amounts .itemName,\n*[dir=\"rtl\"] .transctionCartDetails .subTotal .itemName {\n  text-align: right;\n}\n*[dir=\"rtl\"] .cartContainer .hasAmount .pointer {\n  right: auto;\n  left: 57px;\n}\n*[dir=\"rtl\"] .emailField input,\n*[dir=\"rtl\"] .passwordField input {\n  direction: ltr;\n  unicode-bidi: bidi-override;\n}\n*[dir=\"rtl\"] .checkbox input[type=checkbox] ~ label {\n  padding-left: 0;\n  background-position: right 0;\n  margin-right: -5px;\n  padding-right: 40px;\n}\n*[dir=\"rtl\"] .checkbox.error input[type=checkbox] ~ label,\n*[dir=\"rtl\"] .checkbox.error input[type=checkbox]:focus ~ label {\n  background-position: right -600px;\n}\n*[dir=\"rtl\"] .checkbox input[type=checkbox]:checked ~ label {\n  background-position: right -400px;\n}\n*[dir=\"rtl\"] .checkbox input[type=checkbox]:focus:checked ~ label {\n  background-position: right -4801px;\n}\n*[dir=\"rtl\"] .checkbox input[type=checkbox]:focus ~ label {\n  background-position: right -4601px;\n}\n*[dir=\"rtl\"] .validated .ignoreValidation input[type=checkbox].ng-invalid ~ label,\n*[dir=\"rtl\"] .validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label {\n  background-position: right 0;\n}\n*[dir=\"rtl\"] .validated input[type=checkbox].ng-invalid ~ label {\n  background-position: right -600px;\n}\n*[dir=\"rtl\"] .validated input[type=radio].ng-invalid + label,\n*[dir=\"rtl\"] .validated input[type=radio].ng-invalid:focus + label {\n  background-position: right -2200px;\n}\n*[dir=\"rtl\"] .sCheckbox.checkbox input[type=checkbox] ~ label {\n  background-position: right -2600px;\n}\n*[dir=\"rtl\"] .sCheckbox.checkbox.error input[type=checkbox] ~ label,\n*[dir=\"rtl\"] .sCheckbox.checkbox.error input[type=checkbox]:focus ~ label {\n  background-position: right -3200px;\n}\n*[dir=\"rtl\"] .sCheckbox.checkbox input[type=checkbox]:checked ~ label {\n  background-position: right -3000px;\n}\n*[dir=\"rtl\"] .sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label {\n  background-position: right -5409px;\n}\n*[dir=\"rtl\"] .sCheckbox.checkbox input[type=checkbox]:focus ~ label {\n  background-position: right -2800px;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label {\n  padding-left: 0;\n  background-position: right -1600px;\n  margin-right: -5px;\n  padding-right: 40px;\n}\n*[dir=\"rtl\"] .radioButton.error input[type=radio] + label,\n*[dir=\"rtl\"] .radioButton.error input[type=radio]:focus + label {\n  background-position: right -2200px;\n}\n*[dir=\"rtl\"] .radioButton.warning input[type=radio] + label,\n*[dir=\"rtl\"] .radioButton.warning input[type=radio]:focus + label {\n  background-position: right -7405px;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio]:checked + label {\n  background-position: right -2000px;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio]:focus:checked + label {\n  background-position: right -6010px;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio]:focus + label {\n  background-position: right -1800px;\n}\n*[dir=\"rtl\"] .inputField label {\n  text-align: right;\n}\n*[dir=\"rtl\"] .dropdown.billingAddress a {\n  float: left;\n}\n*[dir=\"rtl\"] .allFundingInstrumentsList li .fsIcon {\n  margin: 18px 15px 0 10px;\n}\n*[dir=\"rtl\"] .validated select.ng-invalid + .custom-select > span,\n*[dir=\"rtl\"] .validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat left 10px center;\n  background-size: 18px;\n}\n*[dir=\"rtl\"] .validated div.inputField:not(.ltrOverride).error input,\n*[dir=\"rtl\"] .validated div.inputField:not(.ltrOverride) input.ng-invalid,\n*[dir=\"rtl\"] .validated div.inputField:not(.ltrOverride) input.backendError {\n  background-size: 18px;\n  background-position: 10px;\n  padding: 0 14px 0 29px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  *[dir=\"rtl\"] .inputField.error input,\n  *[dir=\"rtl\"] .validated .inputField input.ng-invalid,\n  *[dir=\"rtl\"] .validated .inputField input.backendError {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat 98% left;\n    background-size: 18px;\n    background-position: 10px;\n  }\n  *[dir=\"rtl\"] .validated select.ng-invalid + .custom-select > span,\n  *[dir=\"rtl\"] .validated select.backendError + .custom-select > span {\n    background: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat left 10px center;\n    background-size: 18px;\n  }\n}\n*[dir=\"rtl\"] .fsIcons {\n  padding-right: 0;\n  float: right;\n  margin-left: 10px;\n}\n*[dir=\"rtl\"] div.inputField:not(.ltrOverride) .inputField input {\n  padding-right: 10px;\n}\n*[dir=\"rtl\"] div.inputField:not(.ltrOverride) #securityCode.creditCard,\n*[dir=\"rtl\"] div.inputField:not(.ltrOverride) .creditCardField .creditCard,\n*[dir=\"rtl\"] div.inputField:not(.ltrOverride) .ccard {\n  left: 10px;\n  right: inherit;\n}\n*[dir=\"rtl\"] .verifyHelp {\n  text-indent: 100%;\n  white-space: nowrap;\n  overflow: hidden;\n}\n*[dir=\"rtl\"] .toolTip.balloon {\n  text-align: right;\n  top: 125px;\n}\n*[dir=\"rtl\"] #payUponInvoice .edits {\n  padding: 7px 10px 4px 0;\n}\n*[dir=\"rtl\"] .cardType.split {\n  float: left;\n}\n*[dir=\"rtl\"] .creditCardField.split {\n  float: right;\n}\n*[dir=\"rtl\"] div#phoneTypeSelection {\n  float: right;\n}\n*[dir=\"rtl\"] .custom-select > span {\n  background-position: left 5px top -1182px;\n  padding: 7px 13px 7px 30px;\n}\n*[dir=\"rtl\"] .error .custom-select > span,\n*[dir=\"rtl\"] .error .custom-select.active > span {\n  background-position: left 10px center;\n}\n*[dir=\"rtl\"] .emailHelper {\n  left: 10px;\n  right: inherit;\n}\n*[dir=\"rtl\"] .footer .languageToggleDisplay #langDropdownBlock {\n  right: -50px;\n  left: 5px;\n}\n*[dir=\"rtl\"] .footer .languageToggleDisplay #langDropdownBlock.bottom > .arrow:after {\n  margin-left: 0;\n  margin-right: -10px;\n}\n*[dir=\"rtl\"] .footer .languageToggleDisplay .changeLanguage {\n  margin: 5px 5px 0 0 ;\n}\n*[dir=\"rtl\"] .footer .cancelUrl {\n  float: right;\n}\n*[dir=\"rtl\"] .footer .footerWrapper {\n  float: left;\n  text-align: left;\n}\n*[dir=\"rtl\"] .footer .footerWrapper .footerLinks {\n  background-position: right;\n  padding-right: 0px;\n  width: auto;\n}\n*[dir=\"rtl\"] .footer .footerWrapper .footerLinks li {\n  padding-right: 0;\n  padding-left: 12px;\n}\n*[dir=\"rtl\"] .footer .footerWrapper .copyright {\n  width: auto;\n  padding-right: 10px;\n}\n*[dir=\"rtl\"] .poweredBy {\n  float: left;\n}\n*[dir=\"rtl\"] .poweredBy .text {\n  float: right;\n  margin-top: 12px;\n}\n*[dir=\"rtl\"] .paywith .method {\n  float: right;\n}\n*[dir=\"rtl\"] .paywith .method .name {\n  direction: ltr;\n  unicode-bidi: bidi-override;\n}\n*[dir=\"rtl\"] .paywith .methodAmount {\n  float: left;\n}\n*[dir=\"rtl\"] .paywith .methodAmount .currencyCode {\n  text-align: left;\n}\n*[dir=\"rtl\"] .paywith .conversion {\n  text-align: left;\n}\n*[dir=\"rtl\"] .paywith .billingTxt {\n  text-align: right;\n}\n*[dir=\"rtl\"] #shippingAddress .edits,\n*[dir=\"rtl\"] #paymentMethod .edits {\n  right: auto;\n  left: -9px;\n}\n*[dir=\"rtl\"] .sidebar {\n  left: 0;\n  right: -357px;\n}\n*[dir=\"rtl\"] .trayOpen #main {\n  margin-left: -327px;\n}\n*[dir=\"rtl\"] #disclaimerWithBmlCta span {\n  direction: ltr;\n  unicode-bidi: bidi-override;\n}\n*[dir=\"rtl\"] #main {\n  float: left;\n  margin-right: 0px;\n}\n*[dir=\"rtl\"] .trayOpen .maskMember .trayViewMask {\n  left: 38px;\n}\n*[dir=\"rtl\"] #selectFunding .checkIcon,\n*[dir=\"rtl\"] #selectShipping .checkIcon {\n  left: 15px;\n  right: auto;\n}\n*[dir=\"rtl\"] #selectFunding .infoIcon,\n*[dir=\"rtl\"] #selectShipping .infoIcon {\n  left: 15px;\n  right: auto;\n}\n*[dir=\"rtl\"] #selectFunding .fsIcon,\n*[dir=\"rtl\"] #manageFunding .fsIcon {\n  float: right;\n}\n*[dir=\"rtl\"] #closeCart {\n  float: left;\n  margin: 15px 0 0 15px;\n}\n*[dir=\"rtl\"] .languageToggleDisplay {\n  left: 0;\n  right: auto;\n}\n*[dir=\"rtl\"] .languageToggleDisplay .displayText {\n  margin-right: 0;\n}\n*[dir=\"rtl\"] .languageToggleDisplay .changeLanguage {\n  margin: 5px 10px 0 0;\n}\n*[dir=\"rtl\"] .aside .close {\n  left: 10px;\n  right: auto;\n}\n*[dir=\"rtl\"] .aside .backArrow {\n  right: 10px;\n}\n*[dir=\"rtl\"] .aside .backArrow:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 9px;\n  height: 18px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -232px -256px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  *[dir=\"rtl\"] .aside .backArrow:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n*[dir=\"rtl\"] .aside .backArrow:hover:before,\n*[dir=\"rtl\"] .aside .backArrow:focus:before {\n  background-position: -232px -278px;\n}\n*[dir=\"rtl\"] .right {\n  left: 0;\n  float: left;\n}\n*[dir=\"rtl\"] .left {\n  float: right;\n}\n*[dir=\"rtl\"] #selectShipping .subHeader .rightIcon,\n*[dir=\"rtl\"] .subHeader .rightIcon {\n  float: left !important;\n  margin: 4px 6px 0 0;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -200px -220px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  *[dir=\"rtl\"] #selectShipping .subHeader .rightIcon,\n  *[dir=\"rtl\"] .subHeader .rightIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n*[dir=\"rtl\"] #selectShipping .subHeader .rightIcon:hover,\n*[dir=\"rtl\"] .subHeader .rightIcon:hover,\n*[dir=\"rtl\"] #selectShipping .subHeader .rightIcon:focus,\n*[dir=\"rtl\"] .subHeader .rightIcon:focus {\n  background-position: -200px -235px;\n}\n*[dir=\"rtl\"] #selectShipping .subHeader .leftIcon,\n*[dir=\"rtl\"] .subHeader .leftIcon {\n  float: right !important;\n  margin: 4px 0 0 6px;\n}\n*[dir=\"rtl\"] #addCard .addNewBillingAddress {\n  float: left;\n}\n*[dir=\"rtl\"] .creditCardInput .expirationField,\n*[dir=\"rtl\"] .creditCardInput .cardIcon {\n  float: right;\n}\n*[dir=\"rtl\"] .creditCardInput .cvvField {\n  float: left;\n}\n*[dir=\"rtl\"] .inputField.noFloatingLabel label {\n  right: 14px;\n  left: auto;\n  text-align: right;\n}\n*[dir=\"rtl\"] #manageFunding .manageLinks {\n  position: absolute;\n  top: 25px;\n  left: 0;\n  right: auto;\n}\n*[dir=\"rtl\"] #manageFunding .manageLinks .updateButton {\n  padding: 0 0 0 10px;\n}\n*[dir=\"rtl\"] #manageFunding .manageLinks .deleteButton {\n  padding: 0 10px 0 15px;\n}\n*[dir=\"rtl\"] #manageFunding .infoIcon {\n  right: auto;\n  left: 15px;\n}\n*[dir=\"rtl\"] #manageFunding .confirm {\n  left: 0;\n  right: auto;\n  transform: translate(-100%, 0%);\n}\n*[dir=\"rtl\"] #manageFunding .slideIn {\n  transform: translate(0%, 0%);\n}\n*[dir=\"rtl\"] #manageFunding .slide {\n  transform: translate(6%, 0%);\n}\n*[dir=\"rtl\"] #deleteShipping .delete {\n  left: 0;\n  right: auto;\n  -webkit-transform: translate(0%, 0%);\n  -moz-transform: translate(0%, 0%);\n  -ms-transform: translate(0%, 0%);\n  -o-transform: translate(0%, 0%);\n  transform: translate(0%, 0%);\n}\n*[dir=\"rtl\"] #deleteShipping .delete.slideOut {\n  -webkit-transform: translate(-102%, 0%);\n  -moz-transform: translate(-102%, 0%);\n  -ms-transform: translate(-102%, 0%);\n  -o-transform: translate(-102%, 0%);\n  transform: translate(-102%, 0%);\n}\n*[dir=\"rtl\"] #deleteShipping .msgIcon {\n  right: auto;\n  left: 15px;\n}\n*[dir=\"rtl\"] #deleteShipping .slide {\n  transform: translate(15%, 0%);\n}\n*[dir=\"rtl\"] #deleteShipping .confirm {\n  -webkit-transform: translate(-102%, 0%);\n  -moz-transform: translate(-102%, 0%);\n  -ms-transform: translate(-102%, 0%);\n  -o-transform: translate(-102%, 0%);\n  transform: translate(-102%, 0%);\n}\n*[dir=\"rtl\"] #deleteShipping .confirm.slidein {\n  -webkit-transform: translate(0%, 0%);\n  -moz-transform: translate(0%, 0%);\n  -ms-transform: translate(0%, 0%);\n  -o-transform: translate(0%, 0%);\n  transform: translate(0%, 0%);\n}\n*[dir=\"rtl\"] .overlayWrapper {\n  right: auto;\n}\n*[dir=\"rtl\"] #langDropdownBlock {\n  left: -15px;\n  right: auto;\n}\n*[dir=\"rtl\"] #langDropdownBlock.bottom > .arrow:after {\n  margin: 0 -10px 0 0;\n}\n*[dir=\"rtl\"] #shippingAddress .frontArrow,\n*[dir=\"rtl\"] .paywith .frontArrow {\n  left: 0;\n  right: auto;\n  background-position: -200px -216px;\n}\n*[dir=\"rtl\"] .footer .footerWrapper .copyright {\n  direction: ltr;\n  unicode-bidi: bidi-override;\n}\n*[dir=\"rtl\"] .footer .footerWrapper .copyright .secureIcon {\n  float: left;\n  margin: 3px 8px 0 0;\n}\n@media (max-width: 41.25em) {\n  *[dir=\"rtl\"] .trayOpen .sidebar {\n    right: -327px;\n  }\n  *[dir=\"rtl\"] .trayOpen .maskMember .trayViewMask {\n    left: 32px;\n  }\n  *[dir=\"rtl\"] .footer .footerWrapper .footerLinks {\n    float: right;\n    width: 50%;\n    text-align: right;\n  }\n  *[dir=\"rtl\"] .footer .footerWrapper .footerLinks li {\n    padding-left: 0;\n    margin-left: 10px;\n    margin-right: 0;\n  }\n  *[dir=\"rtl\"] .footer .footerWrapper .copyright {\n    float: left;\n  }\n  *[dir=\"rtl\"] .transctionCartDetails {\n    left: 0;\n    right: auto;\n    width: 320px;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  *[dir=\"rtl\"] .footer li {\n    margin-right: 0;\n  }\n  *[dir=\"rtl\"] .footer .footerWrapper .footerLinks {\n    width: 48%;\n    padding-right: 0;\n  }\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/index.js!../node_modules/less-loader/index.js!./pages/xo-error/xo-invalid-address-error/styles.less":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/**\n* @fileOverview Base contains variables, mixins, reset, baseline, grid, and utilities\n* @name Base\n* @author hdoan\n* @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n*/\n/**\n * @fileOverview Variables contains variables\n * @name Variables\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Fonts */\n/* Colors */\n/**\n * @fileOverview Mixins contains mixins\n * @name Mixins\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/**\n * @fileOverview Reset contains reset and baseline styles\n * @name Reset\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n/* Reset ====================================== */\nhtml,\nbody,\ndiv,\ndl,\ndt,\ndd,\nul,\nol,\nli,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\npre,\ncode,\nform,\nfieldset,\nlegend,\ninput,\ntextarea,\np,\nblockquote,\nth,\ntd {\n  margin: 0;\n  padding: 0;\n}\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\nfieldset,\nimg {\n  border: 0;\n}\naddress,\ncaption,\ncite,\ncode,\ndfn,\nem,\nstrong,\nth,\nvar {\n  font-style: normal;\n  font-weight: normal;\n}\nol,\nul {\n  list-style: none;\n}\ncaption,\nth {\n  text-align: left;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6 {\n  font-size: 100%;\n  font-weight: normal;\n}\nq:before,\nq:after {\n  content: \"\";\n}\nabbr,\nacronym {\n  border: 0;\n  font-variant: normal;\n}\n/* to preserve line-height and selector appearance */\nsup {\n  vertical-align: text-top;\n}\nsub {\n  vertical-align: text-bottom;\n}\ninput,\ntextarea,\nselect {\n  font-family: inherit;\n  font-size: inherit;\n  font-weight: inherit;\n}\n/*to enable resizing for IE*/\ninput,\ntextarea,\nselect {\n  *font-size: 100%;\n}\n/*because legend doesn't inherit in IE */\nlegend {\n  color: #000;\n}\n/* Start of base-lining, some from YUI's CSS Foundation ==================== */\nbody {\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 95%;\n  /* Base font-size is 15px */\n  color: #2c2e2f;\n  line-height: 1.35em;\n}\nh1 {\n  /*18px via YUI Fonts CSS foundation*/\n  font-size: 138.5%;\n}\nh2 {\n  /*16px via YUI Fonts CSS foundation*/\n  font-size: 123.1%;\n}\nh3 {\n  /*14px via YUI Fonts CSS foundation*/\n  font-size: 108%;\n}\nh1,\nh2,\nh3 {\n  /* top & bottom margin based on font size */\n  margin: 1em 0;\n}\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\nstrong {\n  /*bringing boldness back to headers and the strong element*/\n  font-weight: bold;\n}\na {\n  color: #0070BA;\n}\nabbr,\nacronym {\n  /*indicating to users that more info is available */\n  border-bottom: 1px dotted #000;\n  cursor: help;\n}\nem {\n  /*bringing italics back to the em element*/\n  font-style: italic;\n}\nblockquote,\nul,\nol,\ndl {\n  /*giving blockquotes and lists room to breath*/\n  margin: 1em;\n}\nol,\nul,\ndl {\n  /*bringing lists on to the page with breathing room */\n  margin-left: 2em;\n}\nol {\n  /*giving OL's LIs generated numbers*/\n  list-style: decimal outside;\n}\nul {\n  /*giving UL's LIs generated disc markers*/\n  list-style: disc outside;\n}\ndl dd {\n  /*providing spacing for definition terms*/\n  margin-left: 1em;\n}\nth,\ntd {\n  /*borders and padding to make the table readable*/\n  border: 1px solid #000;\n  padding: .5em;\n}\nth {\n  /*distinguishing table headers from data cells*/\n  font-weight: bold;\n  text-align: center;\n}\ninput {\n  margin-bottom: 10px;\n}\ncaption {\n  /*coordinated margin to match cell's padding*/\n  margin-bottom: .5em;\n  /*centered so it doesn't blend in to other content*/\n  text-align: center;\n}\np,\nfieldset,\ntable,\npre,\nlegend {\n  /*so things don't run into each other*/\n  margin-bottom: 1em;\n}\n/* setting a consistent width, 160px;\n   control of type=file still not possible */\ninput[type=text],\ninput[type=password],\ntextarea {\n  width: 12.25em;\n  *width: 11.9em;\n}\n/**\n * @fileOverview Grid contains grid rules\n * @name Grid\n * @author hdoan\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n.row-fluid {\n  width: 100%;\n  *zoom: 1;\n}\n.row-fluid:before,\n.row-fluid:after {\n  display: table;\n  content: \"\";\n}\n.row-fluid:after {\n  clear: both;\n}\n.row-fluid > [class*=\"span\"] {\n  float: left;\n  margin-left: 4.127659574%;\n}\n.row-fluid > [class*=\"span\"]:first-child {\n  margin-left: 0;\n}\n.row-fluid > .span24 {\n  width: 99.999999978%;\n}\n.row-fluid > .span23 {\n  width: 95.74468083%;\n}\n.row-fluid > .span22 {\n  width: 91.48936168200001%;\n}\n.row-fluid > .span21 {\n  width: 87.234042534%;\n}\n.row-fluid > .span20 {\n  width: 82.97872338599998%;\n}\n.row-fluid > .span19 {\n  width: 78.723404238%;\n}\n.row-fluid > .span18 {\n  width: 74.46808508999999%;\n}\n.row-fluid > .span17 {\n  width: 70.212765942%;\n}\n.row-fluid > .span16 {\n  width: 65.95744679399999%;\n}\n.row-fluid > .span15 {\n  width: 61.702127646%;\n}\n.row-fluid > .span14 {\n  width: 54.446808497999996%;\n}\n.row-fluid > .span13 {\n  width: 53.19148935%;\n}\n.row-fluid > .span12 {\n  width: 48.936170202%;\n}\n.row-fluid > .span11 {\n  width: 44.680851054%;\n}\n.row-fluid > .span10 {\n  width: 40.425531905999996%;\n}\n.row-fluid > .span9 {\n  width: 36.170212758%;\n}\n.row-fluid > .span8 {\n  width: 31.91489361%;\n}\n.row-fluid > .span7 {\n  width: 27.659574462000002%;\n}\n.row-fluid > .span6 {\n  width: 23.404255313999997%;\n}\n.row-fluid > .span5 {\n  width: 19.148936166%;\n}\n.row-fluid > .span4 {\n  width: 14.893617018%;\n}\n.row-fluid > .span3 {\n  width: 10.638297869999999%;\n}\n.row-fluid > .span2 {\n  width: 6.382978722%;\n}\n.row-fluid > .span1 {\n  width: 2.127659574%;\n}\n.container-fluid {\n  padding-left: 20px;\n  padding-right: 20px;\n  *zoom: 1;\n}\n.container-fluid:before,\n.container-fluid:after {\n  display: table;\n  content: \"\";\n}\n.container-fluid:after {\n  clear: both;\n}\n.mt10 {\n  margin-top: 10px;\n}\n.mt15 {\n  margin-top: 10px;\n}\n.pt10 {\n  padding-top: 10px;\n}\n.pt15 {\n  padding-top: 15px;\n}\n.mb10 {\n  margin-bottom: 10px;\n}\n.mb15 {\n  margin-bottom: 15px;\n}\n.pb10 {\n  padding-bottom: 10px;\n}\n.pb15 {\n  padding-bottom: 15px;\n}\n.ml10 {\n  margin-left: 10px;\n}\n.ml15 {\n  margin-left: 15px;\n}\n.pl10 {\n  padding-left: 10px;\n}\n.pl15 {\n  padding-left: 15px;\n}\n.mr10 {\n  margin-right: 10px;\n}\n.mr15 {\n  margin-right: 15px;\n}\n.pr10 {\n  padding-right: 10px;\n}\n.pr15 {\n  padding-right: 15px;\n}\n/* Button styles */\n.btn {\n  height: 44px;\n  margin-bottom: 0;\n  border-style: solid;\n  border-width: 1px;\n  border-color: #0070BA;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  *margin-left: .3em;\n  display: inline-block;\n  /* IE7 inline-block hack */\n  *display: inline;\n  *zoom: 1;\n  background-color: #0070BA;\n  -webkit-transition: background-color 0.4s ease-out 0s;\n  -moz-transition: background-color 0.4s ease-out 0s;\n  -ms-transition: background-color 0.4s ease-out 0s;\n  -o-transition: background-color 0.4s ease-out 0s;\n  transition: background-color 0.4s ease-out 0s;\n  font-size: 1.0em;\n  font-weight: bold;\n  line-height: 42px;\n  color: #fff;\n  text-align: center;\n  vertical-align: middle;\n  cursor: pointer;\n  outline: none;\n  -webkit-font-smoothing: antialiased;\n}\n.btn .btn-secondary {\n  -webkit-font-smoothing: auto;\n}\n.btn:hover,\n.btn:focus {\n  background-color: #005EA6;\n}\n.btn:focus {\n  text-decoration: underline;\n}\n.btn.active,\n.btn:active {\n  background-color: #005EA6;\n  outline: 0;\n}\n.btn.disabled,\n.btn[disabled] {\n  background-color: #B2D9EA;\n  border-color: #B2D9EA;\n  cursor: default;\n}\n.btn.firstHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n.btn.secondHalf {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\na.btn:focus,\na.btn:hover {\n  color: #fff;\n}\n.btn:first-child {\n  *margin-left: 0;\n}\n.btn-large {\n  padding: 8px 15px;\n  font-size: 18px;\n  line-height: normal;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n}\n.btn-small {\n  padding: 5px 9px;\n  font-size: 11px;\n  line-height: 16px;\n}\n.btn-mini {\n  padding: 2px 6px;\n  font-size: 11px;\n  line-height: 14px;\n}\n.btn-secondary {\n  border-style: solid;\n  border-color: #E1E7Eb;\n  color: #393F44;\n  background-color: #E1E7Eb;\n}\n.btn-secondary:hover {\n  color: #393F44;\n  border-color: #EDF2F5;\n  background-color: #EDF2F5;\n  text-decoration: none;\n}\n.btn-secondary:active,\n.btn-secondary:focus {\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n  text-decoration: underline;\n}\n.btn-secondary.disabled,\n.btn-secondary[disabled] {\n  color: #393F55;\n}\na.btn-secondary:hover,\na.btn-secondary:focus,\na.btn-secondary:active {\n  color: #393F44;\n  border-color: #C5CCD1;\n  background-color: #C5CCD1;\n}\na.btn-secondary.disabled,\na.btn-secondary[disabled] {\n  color: #393F55;\n  background-color: #E7EDF0;\n}\nbutton.btn,\ninput[type=\"submit\"].btn {\n  *padding-top: 2px;\n  *padding-bottom: 2px;\n}\nbutton.btn::-moz-focus-inner,\ninput[type=\"submit\"].btn::-moz-focus-inner {\n  padding: 0;\n  border: 0;\n}\nbutton.btn.btn-large,\ninput[type=\"submit\"].btn.btn-large {\n  *padding-top: 7px;\n  *padding-bottom: 7px;\n}\nbutton.btn.btn-small,\ninput[type=\"submit\"].btn.btn-small {\n  *padding-top: 3px;\n  *padding-bottom: 3px;\n}\nbutton.btn.btn-mini,\ninput[type=\"submit\"].btn.btn-mini {\n  *padding-top: 1px;\n  *padding-bottom: 1px;\n}\nsection .buttons #backButton,\n#largeScreenAccountCreation .buttons #backButton {\n  width: 30%;\n}\nsection .buttons #proceedButton,\n#largeScreenAccountCreation .buttons #proceedButton {\n  width: 65%;\n}\nsection .buttons #proceedButton.full,\n#largeScreenAccountCreation .buttons #proceedButton.full {\n  width: 100%;\n}\nsection .buttons #proceedButton-venmoBA,\n#largeScreenAccountCreation .buttons #proceedButton-venmoBA {\n  width: 100%;\n}\n/* mixin for Select element - Dropdowns\n    *\n    * We style native select element on web and it uses native element on other devices\n    * HTML Format to use for select element:\n    *   <div class=\"dropdown\">\n    *           <label for=\"selectID\" class=\"accessAid\" id=\"forSelectID\">Select Label</label>\n    *           <select id=\"selectID\" name=\"selectID\">\n    *               <option value=\"\">Option 1</option>\n    *               <option value=\"2\">Option 2</option>\n    *           </select>\n    *       </div>\n    *\n    * @param width - defines the width of the select dropdown on form\n*/\n.custom-select-container {\n  position: relative;\n}\n/* Set the dimensions of the replaced select element and make it transparent. */\nselect.replaced {\n  position: relative;\n  z-index: 8;\n  width: 100%;\n  height: 44px;\n  border: 0;\n  line-height: 2;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  /* Move to IE-speci    fic CSS file if you want to. */\n}\n.custom-select {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 1;\n  display: block;\n  width: 100%;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.custom-select > span {\n  display: block;\n  padding: 7px 30px 7px 13px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: right -7px top -1178px;\n  color: #000;\n  line-height: 28px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .custom-select > span {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.disabled .custom-select > span {\n  background-position: right -7px top -6990px;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat right 10px center;\n  background-size: 16px;\n  color: #c72e2e;\n  border: 1px solid #c72e2e;\n}\n.custom-select span span {\n  display: block;\n  overflow: hidden;\n  height: 28px;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-size: 1em;\n}\n.custom-select.active > span {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n#task .custom-select {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\n.mobile .dob label {\n  position: static;\n  top: 0;\n  left: 0;\n}\ninput[type=date] {\n  padding: 5px 38px 3px 6px;\n  border: 1px solid #ccd0d4;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  color: #333;\n  background-size: 24px;\n  background: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_cart_icons.png\") no-repeat 100% 61%;\n}\ninput[type=date]:focus {\n  border-color: #3399ff;\n}\n.showDropdopwnLabels .labelText {\n  float: left;\n  color: #aaa;\n}\n.showDropdopwnLabels .valueText {\n  float: right;\n  min-width: 90px;\n}\n@media (min-width: 0) and (max-width: 40em) {\n  .showDropdopwnLabels .labelText {\n    display: none;\n  }\n  .showDropdopwnLabels .valueText {\n    float: none;\n    min-width: 0;\n  }\n}\n.multiline-select-container {\n  outline: 0 none;\n}\n.multiline-select-container:active .innerContainer,\n.multiline-select-container:focus .innerContainer {\n  border-color: #009cde;\n}\n.multiline-select-container.open:active .innerContainer,\n.multiline-select-container.open:focus .innerContainer {\n  border-color: #ccd0d4;\n}\n.multiline-select-container option,\n.multiline-select-container select {\n  position: absolute !important;\n  left: -9999px;\n}\n.multiline-select-container .custom-select {\n  position: relative;\n}\n.multiline-select-container .custom-select span span {\n  height: auto;\n  white-space: initial;\n}\n.multiline-select-container .custom-select > span {\n  background: none;\n}\n.multiline-select-container.open .custom-select > span {\n  border-radius: 5px 5px 0 0;\n  border-bottom-color: #eee;\n}\n.multiline-select-container .arrow {\n  background-clip: padding-box;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_forms.png\");\n  background-position: left -8px top -1198px;\n  background-repeat: no-repeat;\n  height: 10px;\n  position: absolute;\n  width: 14px;\n  top: 40%;\n  right: 12px;\n}\n.validated .multiline-select-container .ng-invalid + .custom-select .arrow,\n.backendError .multiline-select-container .ng-invalid + .custom-select .arrow {\n  display: none;\n}\n.multiline-select-list {\n  position: absolute;\n  list-style: none;\n  margin: 0;\n  background-color: #fff;\n  z-index: 1000;\n  border-radius: 0 0 5px 5px;\n  border-bottom: 1px solid #ccd0d4;\n  max-height: 200px;\n  overflow: auto;\n  box-shadow: #ccc 0px -1px 1px 0px;\n}\n.multiline-select-list li {\n  padding: 10px;\n  border: 1px solid;\n  border-color: #eee #ccd0d4;\n  border-top: 0 none;\n  cursor: pointer;\n  line-height: 1.35em;\n  vertical-align: middle;\n}\n.multiline-select-list li:hover,\n.multiline-select-list li:focus,\n.multiline-select-list li:active {\n  background-color: #e5f5fc;\n  outline: 0 none;\n}\n.multiline-select-list li:first-of-type {\n  border-top: 0 none;\n}\n.multiline-select-list li:last-of-type {\n  border-bottom: 0 none;\n}\n.multiline-select-list:hover li:focus {\n  background-color: #fff;\n}\n.multiline-select-list:hover li:focus:hover,\n.multiline-select-list:hover li:focus:active {\n  background-color: #e5f5fc;\n}\n.accessAid,\n#midflash {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n/*\n * HTML elements\n */\nbody {\n  -webkit-tap-highlight-color: transparent;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  background-color: #fff;\n}\na {\n  text-decoration: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0.2);\n}\na:hover,\na:focus {\n  color: #005EA6;\n  text-decoration: underline;\n  outline: none;\n}\na.dashed {\n  text-decoration: none;\n  border-bottom: 1px #0070BA dashed;\n  font-size: 0.9em;\n}\n*[tabindex=\"-1\"] {\n  outline: none;\n}\nem {\n  font-style: normal;\n  font-weight: bold;\n}\nfieldset {\n  margin: 0;\n  padding: 0;\n  border: 0;\n}\nfieldset legend {\n  padding-bottom: 0.5em;\n  font-size: 1.5em;\n}\nsection:focus {\n  outline: none;\n}\n.show-section {\n  display: block;\n}\nhr.faded {\n  width: 100%;\n  height: 1px;\n  margin: 10px 0;\n  border: 0;\n  background-image: -webkit-gradient(linear, left top, right top, color-stop(0, transparent), color-stop(0.5, rgba(0, 0, 0, 0.3)), color-stop(1, transparent));\n  background-image: -webkit-linear-gradient(left, transparent, rgba(0, 0, 0, 0.3), transparent);\n  background-image: -moz-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -ms-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n  background-image: -o-linear-gradient(left, transparent, rgba(0, 0, 0, 0.75), transparent);\n}\n.alpha {\n  font-size: 1.50em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin: 0.5em 0;\n  line-height: 1.154em;\n}\n#loginSection h1.alpha {\n  max-width: 240px;\n}\n.asideAlpha {\n  font-size: 1.44em;\n}\naside .aside .header.noButtons .walletHeading {\n  text-align: center;\n  line-height: 1.05em;\n}\n.beta {\n  font-size: 1.54em;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.gamma {\n  font-size: 1.30em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.zeta {\n  font-size: 1.25em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  margin-bottom: 0.75em;\n}\n.delta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin-bottom: 12px;\n  font-weight: normal;\n}\n.vprop-header {\n  font-size: 1.60em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  margin: 10px 0;\n  font-weight: lighter;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  line-height: 1.2em;\n}\n.vprop-content {\n  font-size: 1.0em;\n  font-family: \"HelveticaNeue\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: lighter;\n  line-height: 1.2em;\n}\n.vprop-image {\n  margin-top: 25px;\n}\n.eta {\n  font-size: 1.10em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.theta {\n  font-size: 1.0em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n}\n.value-prop-title {\n  color: #2c2e2f;\n  font-size: 24px;\n  font-weight: lighter;\n  margin: 10px 0;\n}\n.props {\n  padding: 0 0 0 5px;\n  clear: both;\n  text-align: center;\n}\n.props p,\n.props li {\n  line-height: 1.154em;\n  font-size: 0.9em;\n  font-weight: normal;\n  line-height: 1.2em;\n  margin: 5px 0;\n}\n.secondary {\n  color: #6C7378;\n  font-size: 0.85em;\n}\n.legal {\n  color: #6C7378;\n  font-size: 0.75em;\n  line-height: 1.154em;\n}\n.legal a {\n  font-weight: bold;\n}\n.mu {\n  font-size: 2.46em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-weight: normal;\n  text-shadow: 0 1px 0 #fff;\n  color: #0079c1;\n}\n/* Single property classes - 0 value or common attributes */\n.noHead {\n  margin-top: 0;\n}\n.noBottom {\n  margin-bottom: 0;\n}\n.showTray #task {\n  overflow: hidden;\n  margin-left: 0;\n}\n.hide,\n#spinner {\n  display: none;\n}\n.clearfix,\nhtml[xmlns] .clearfix,\n.loading #spinner,\n.media .img img {\n  display: block;\n}\n#billingToggleLink {\n  display: inline-block;\n}\n.left {\n  float: left;\n}\n.right {\n  float: right;\n}\n.center {\n  text-align: center;\n}\n/* End single property classes */\n.outerWrapper {\n  position: relative;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  background-color: #ffffff;\n}\nheader {\n  z-index: 2;\n}\nhtml.framed,\n.framed #wrapper {\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n}\nhtml.framed .trayOpen #main {\n  height: 585px;\n}\nhtml.framed .trayOpen .asideContent {\n  height: 495px;\n}\nbody > iframe,\nbody > img {\n  display: none;\n}\n#wrapper {\n  margin: 0 auto;\n  max-width: 780px;\n  border: 1px solid #e3e3e3;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  overflow-y: visible;\n  outline: none;\n  background-color: #fff;\n}\n#wrapper #header {\n  -webkit-border-radius: 5px 5px 0 0;\n  -moz-border-radius: 5px 5px 0 0;\n  border-radius: 5px 5px 0 0;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  position: relative;\n  width: 100%;\n  background-color: #fff;\n  z-index: 4;\n  -webkit-box-shadow: 0 0 3px 0;\n  -moz-box-shadow: 0 0 3px 0;\n  box-shadow: 0 0 3px 0;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n#contents {\n  position: relative;\n  z-index: 1;\n}\n.active #wrapper {\n  visibility: visible;\n  -webkit-animation-duration: 400ms;\n  -webkit-animation-timing-function: ease;\n  -webkit-animation-name: slideUp;\n}\n#logo {\n  margin: 22px 0 0 20px;\n}\n.container {\n  clear: both;\n  padding: 20px;\n}\n.containerNoHead {\n  padding-top: 0;\n}\n.noPaddingBottom {\n  padding-bottom: 0;\n}\n.noPaddingTop {\n  padding-top: 0;\n}\n.subContainer {\n  border-top: 1px solid #e3e3e3;\n  padding: 20px 0 20px;\n  position: relative;\n}\n#proceedButton {\n  width: 46.4%;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: right;\n}\n#proceedButton.full {\n  width: 100%;\n}\n#proceedButton:focus {\n  color: #fff;\n}\n#backButton {\n  width: 46.4%;\n  text-decoration: none;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  float: left;\n}\n#backButton:hover,\n#backButton:focus {\n  color: #2c2e2f;\n}\n.middleName {\n  display: none;\n  float: right;\n}\n.h2,\nh2 {\n  font-size: 1.2em;\n  font-family: \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  margin-top: 0;\n  font-weight: normal;\n  color: #0666B3;\n}\n.clearfix:after {\n  height: 0;\n  display: block;\n  visibility: hidden;\n  clear: both;\n  overflow: auto;\n  line-height: 0;\n  content: \" \";\n}\n* html .clearfix {\n  height: 1%;\n}\n#sliding-area {\n  overflow: hidden;\n}\n#main {\n  padding: 25px 30px 15px;\n  -webkit-transition: margin 0.3s ease-out;\n  -moz-transition: margin 0.3s ease-out;\n  -ms-transition: margin 0.3s ease-out;\n  -o-transition: margin 0.3s ease-out;\n  transition: margin 0.3s ease-out;\n  width: 100%;\n  float: right;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.loading #main {\n  background: none;\n}\n.loginLoadingMessage,\n.bmlLoadingMessage {\n  display: none;\n}\n.loginProcessing .genericLoadingMessage {\n  display: none;\n}\n.loginProcessing .loginLoadingMessage {\n  display: block;\n}\n.full {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  text-decoration: none;\n}\n.trayInner {\n  padding: 20px 0;\n}\n.disclaimer {\n  font-size: 0.75em;\n  color: #6C7378;\n}\n.reviewMsg {\n  margin-top: 10px;\n  line-height: 1.5;\n}\n.infoTxt {\n  clear: both;\n  padding-top: 10px;\n}\n.help {\n  color: #A9A9A9;\n}\n.keyValue label {\n  color: #292929;\n}\n.frontArrow {\n  position: absolute;\n  display: inline-block;\n  width: 9px;\n  height: 15px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -196px -177px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .frontArrow {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.focusableIcon:focus {\n  box-shadow: 0 0 1px #6C7378;\n}\n.caret-down {\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -233px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .caret-down {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n/* Form styles */\ninput[type=submit],\ninput[type=button] {\n  -webkit-appearance: none;\n}\ninput[disabled=disabled],\n.inputField input[disabled=disabled],\n.inputField input[disabled=disabled]:active {\n  background: #F7F9FA;\n  border: 1px solid #CBD2D6;\n  color: #6C7378;\n}\ninput::-ms-clear {\n  display: none;\n}\ninput.link:hover {\n  cursor: pointer;\n}\ninput.xsmall {\n  width: 2em;\n}\ninput.small {\n  width: 3.35em;\n  font-size: 1em;\n}\ninput.medium {\n  width: 7em;\n}\ninput.large {\n  width: 14em;\n}\ninput.xlarge {\n  width: 20em;\n}\n.button-as-link {\n  margin: 0;\n  padding: 0;\n  border: none;\n  width: auto;\n  font-size: 0.85em;\n  background: transparent;\n  color: #0070BA;\n  cursor: pointer;\n}\n/* Hide spinner on type=number fields */\ninput[type=number]::-webkit-inner-spin-button,\ninput[type=number]::-webkit-outer-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n.buttons {\n  margin-top: 15px;\n  margin-bottom: 15px;\n  overflow: hidden;\n}\n.inputField {\n  position: relative;\n}\n.inputField label,\n.inputField input {\n  display: block;\n  vertical-align: top;\n}\n.inputField input,\n.ignoreValidation .inputField.error input,\n.validated .ignoreValidation .inputField input.ng-invalid,\n.validated .ignoreValidation .inputField input.backendError {\n  width: 100%;\n  height: 44px;\n  padding: 0 14px;\n  -webkit-border-radius: 5px;\n  -moz-border-radius: 5px;\n  border-radius: 5px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  border: 1px solid #C5CCD1;\n  color: #000;\n  -webkit-transition: border-color 0.3s ease 0s;\n  -moz-transition: border-color 0.3s ease 0s;\n  -ms-transition: border-color 0.3s ease 0s;\n  -o-transition: border-color 0.3s ease 0s;\n  transition: border-color 0.3s ease 0s;\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  background: none;\n}\n.inputField input::-webkit-input-placeholder,\n.ignoreValidation .inputField.error input::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-webkit-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:-moz-placeholder,\n.ignoreValidation .inputField.error input:-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n}\n.inputField input::-moz-placeholder,\n.ignoreValidation .inputField.error input::-moz-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid::-moz-placeholder,\n.validated .ignoreValidation .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n}\n.inputField input:-ms-input-placeholder,\n.ignoreValidation .inputField.error input:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .ignoreValidation .inputField input.backendError:-ms-input-placeholder {\n  color: #6C7378;\n}\n.inputField input:active,\n.inputField input:focus {\n  border: 1px solid #009cde;\n  outline: 0;\n}\n.inputField select {\n  font-size: 1.5em;\n  margin-bottom: 10px;\n}\n.custom-select-container select {\n  font-size: 15px;\n}\n.inputField label {\n  position: absolute;\n  top: 14px;\n  left: 14px;\n  cursor: text;\n  text-align: left;\n  color: #666;\n  font-size: 1em;\n}\n.no-js .inputField label,\n.no-js .dropdown label {\n  position: static;\n}\n.fieldGroup .inputField {\n  float: left;\n  padding: 0 0.5em 0 0;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.inputField.error input::-webkit-input-placeholder,\n.validated .inputField input.ng-invalid::-webkit-input-placeholder,\n.validated .inputField input.backendError::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.inputField.error input:-moz-placeholder,\n.validated .inputField input.ng-invalid:-moz-placeholder,\n.validated .inputField input.backendError:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.inputField.error input::-moz-placeholder,\n.validated .inputField input.ng-invalid::-moz-placeholder,\n.validated .inputField input.backendError::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.inputField.error input:-ms-input-placeholder,\n.validated .inputField input.ng-invalid:-ms-input-placeholder,\n.validated .inputField input.backendError:-ms-input-placeholder {\n  color: #c72e2e;\n}\n.validated select.ng-invalid + .custom-select > span,\n.validated select.backendError + .custom-select > span {\n  background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n  background-size: 40px 8000px, 18px;\n}\n.inputField.valid input {\n  background: #fff url(https://www.paypalobjects.com/images/checkout/hermes/icon_checkmark_wallet_2x.png) no-repeat 98% center;\n  background-size: 14px;\n}\n.inputField.error input,\n.validated .inputField input.ng-invalid,\n.validated .inputField input.backendError {\n  background-position: -webkit-calc(100% - 10px) center;\n  background-position: right 10px center;\n}\n.creditCardField.valid input {\n  background: #fff;\n}\n.inputField.error select,\n.dropdown.error select {\n  border: 1px solid #c72e2e;\n}\n.selectLabel {\n  display: block;\n}\ninput::-webkit-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 1em;\n}\ninput:-moz-placeholder {\n  /* Firefox 18- */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #6C7378;\n  opacity: 1;\n  /* for some reason, FF seems to put the opacity of placeholder text to 50% by default */\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\ninput:-ms-input-placeholder {\n  color: #6C7378;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\n/* End form styles */\n.checkbox input[type=checkbox] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.checkbox input[type=checkbox] ~ label,\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: inline-block;\n  position: static;\n  min-height: 25px;\n  padding-left: 35px;\n  line-height: 27px;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px 0;\n  vertical-align: middle;\n  cursor: pointer;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .checkbox input[type=checkbox] ~ label,\n  .checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 25px;\n  margin-left: -35px;\n}\n.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.checkbox.error input[type=checkbox] ~ label,\n.checkbox.error input[type=checkbox]:focus ~ label,\n.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.checkbox input[type=checkbox]:checked ~ label,\n.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -400px;\n}\n.checkbox input[type=checkbox]:focus:checked ~ label,\n.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4801px;\n}\n.checkbox input[type=checkbox]:focus ~ label,\n.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -4601px;\n}\n.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -800px;\n}\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 25px 25px;\n}\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 0;\n}\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg,\n.validated .ignoreValidation .sCheckbox.checkbox input[type=checkbox].ng-invalid:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px 2600px;\n}\n.validated input[type=checkbox].ng-invalid ~ label,\n.validated input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -600px;\n}\n.validated input[type=radio].ng-invalid + label::before,\n.validated input[type=radio].ng-invalid:focus + label::before,\n.validated input[type=radio].ng-invalid + label.bgImgOnSpan span.bgImg,\n.validated input[type=radio].ng-invalid:focus + label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2200px;\n}\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label,\n.validated .sCheckbox.checkbox input[type=checkbox].ng-invalid ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox {\n  position: relative;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label,\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  line-height: 19px;\n  padding-left: 27px;\n  font-size: 0.85em;\n  background-position: -9px -2600px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan span.bgImg {\n  display: block;\n  float: left;\n  width: 0px;\n  height: 19px;\n  margin-left: -27px;\n}\n.sCheckbox.checkbox input[type=checkbox] ~ label.bgImgOnSpan {\n  background-image: none;\n}\n.sCheckbox.checkbox.error input[type=checkbox] ~ label,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox.error input[type=checkbox] ~ label.bgImgOnSpan span.bgImg,\n.sCheckbox.checkbox.error input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3200px;\n}\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3000px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus:checked ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -5409px;\n}\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label,\n.sCheckbox.checkbox input[type=checkbox]:focus ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -2800px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled] ~ label.bgImgOnSpan span.bgImg {\n  background-position: -9px -3400px;\n}\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label,\n.sCheckbox.checkbox input[type=checkbox][disabled=disabled]:checked ~ label.bgImgOnSpan span.bgImg {\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/checkbox-disabled.png\");\n  background-position: 0 0;\n  background-size: 18px 19px;\n}\n.radioButton input[type=radio] {\n  position: absolute !important;\n  clip: rect(1px 1px 1px 1px);\n  /* IE6, IE7 */\n  clip: rect(1px, 1px, 1px, 1px);\n  padding: 0 !important;\n  border: 0 !important;\n  height: 1px !important;\n  width: 1px !important;\n  overflow: hidden;\n}\n.radioButton input[type=radio] ~ label {\n  display: inline-block;\n  min-height: 26px;\n  padding-left: 35px;\n  line-height: 27px;\n  vertical-align: middle;\n  cursor: pointer;\n  position: relative;\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label {\n  padding-left: unset;\n  padding-right: 35px;\n}\n.radioButton input[type=radio] ~ label::before {\n  content: \" \";\n  display: block;\n  width: 30px;\n  height: 30px;\n  position: absolute;\n  top: 0;\n  left: 0;\n  background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_1x.png\");\n  background-repeat: no-repeat;\n  background-position: -9px -1600px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .radioButton input[type=radio] ~ label::before {\n    background-image: url(\"https://www.paypalobjects.com/images/shared/sprite_forms_2x.png\");\n    background-size: 40px 8000px;\n  }\n}\n*[dir=\"rtl\"] .radioButton input[type=radio] ~ label::before,\n.outerWrapper.rtl .radioButton input[type=radio] ~ label::before {\n  right: 0;\n  left: unset;\n}\n.radioButton.error input[type=radio] + label::before,\n.radioButton.error input[type=radio]:focus + label::before {\n  background-position: -9px -2200px;\n}\n.radioButton.warning input[type=radio] + label::before,\n.radioButton.warning input[type=radio]:focus + label::before {\n  background-position: -9px -7405px;\n}\n.radioButton input[type=radio]:checked + label::before {\n  background-position: -9px -2000px;\n}\n.radioButton input[type=radio]:focus:checked + label::before {\n  background-position: -9px -6010px;\n}\n.radioButton input[type=radio]:focus + label::before {\n  background-position: -9px -1800px;\n}\n.inputField label.nolap {\n  position: relative;\n  top: auto;\n  left: auto;\n  color: #2c2e2f;\n}\n.inputField.half {\n  width: 48.15%;\n  margin-right: 3.7%;\n  padding-right: 0;\n}\n.singlePagePaymentForm .inputField.half,\n.multistepSignupForm .inputField.half {\n  width: 48.7%;\n  margin-right: 2.6%;\n  padding-right: 0;\n}\n.inputField.half.issueNo {\n  width: 42%;\n  margin-top: 15px;\n}\n.inputField.half.startDate {\n  width: 54%;\n  margin-right: 10px;\n}\n#cardIssueInfo .inputField.half.startDate {\n  width: 48%;\n  margin-right: 0;\n}\n#cardIssueInfo .inputField.half.issueNo {\n  width: 48%;\n  margin-top: 0;\n  float: right;\n}\n#cardIssueInfo .inputField.half.issueNo:before {\n  content: \"\\200C\";\n}\n.inputField.half.last-child {\n  margin-right: 0;\n}\n.fieldGroup .inputField.last-child {\n  padding-right: 0;\n}\n.fidobDay {\n  width: 30%;\n  float: left;\n}\n.fidobDay .custom-select > span {\n  border-radius: 5px 0 0 5px;\n  border-right: 0;\n}\n.fidobMonth {\n  width: 30%;\n  float: left;\n}\n.fidobMonth .custom-select > span {\n  border-radius: 0px;\n}\n.fidobYear {\n  width: 40%;\n  float: left;\n}\n.fidobYear .custom-select > span {\n  border-radius: 0px 5px 5px 0;\n  border-left: 0;\n}\n.cardDOB {\n  width: 100%;\n  clear: both;\n}\n.dobLabel {\n  top: auto;\n  left: auto;\n  position: relative;\n  display: block;\n  bottom: 4px;\n}\n.dobTXT {\n  margin-top: 10px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .inputField.error input,\n  .validated .inputField input.ng-invalid,\n  .validated .inputField input.backendError {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .validated select.ng-invalid + .custom-select > span,\n  .validated select.backendError + .custom-select > span {\n    background: url('https://www.paypalobjects.com/images/shared/sprite_forms_2x.png') no-repeat right 15px top -1180px, url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png') no-repeat right 10px center;\n    background-size: 40px 8000px, 18px;\n  }\n}\n.submitted input.ng-invalid {\n  border-color: #c72e2e;\n  padding-right: 29px;\n  background: #ffffff url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n}\n.submitted input.ng-invalid::-webkit-input-placeholder {\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-moz-placeholder {\n  /* Firefox 18- */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid::-moz-placeholder {\n  /* Firefox 19+ */\n  color: #c72e2e;\n}\n.submitted input.ng-invalid:-ms-input-placeholder {\n  color: #c72e2e;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .submitted input.ng-invalid {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n.merchantHeader {\n  height: 90px;\n  margin: 0 auto;\n}\n.merchantHeader .headerWrapper {\n  max-width: 780px;\n  margin: 0 auto;\n  overflow: hidden;\n  max-height: 90px;\n  line-height: 90px;\n}\n.merchantHeader .merchantName {\n  font-size: 1.6em;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  color: #2c2e2f;\n  font-weight: normal;\n  width: 575px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  display: inline-block;\n}\n.merchantHeader img {\n  vertical-align: middle;\n}\n.paypalHeaderWrapper .logo {\n  float: left;\n  width: 112px;\n  height: 29px;\n  margin-top: 0;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .paypalHeaderWrapper .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.paypalHeaderWrapper .span14 {\n  padding-bottom: 20px;\n  border-bottom: 1px solid #dbdbdb;\n}\n.paypalHeaderWrapper .cartContainer {\n  position: static;\n  line-height: 29px;\n}\n.paypalHeaderWrapper .transctionCartDetails {\n  z-index: 2;\n}\n.paypalHeaderWrapper.paypalCredit .logo {\n  height: 35px;\n  background-position: 0 -129px;\n}\n.aside .header {\n  padding: 15px;\n  vertical-align: middle;\n  line-height: 50px;\n  border-bottom: 1px solid #e3e3e3;\n}\n.aside .header.tall {\n  min-height: 65px;\n  line-height: normal;\n  padding: 13px 15px 10px;\n  margin-bottom: 0;\n}\n.aside .asideAlpha {\n  padding: 0 30px;\n  text-align: center;\n  line-height: 1.2em;\n}\n.aside .walletHeading {\n  text-align: center;\n}\n.aside .close {\n  position: absolute;\n  top: 10px;\n  right: 15px;\n  width: 19px;\n  height: 19px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .close:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 19px;\n  height: 19px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px 0;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .close:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .close:hover:before,\n.aside .close:focus:before {\n  background-position: -223px -22px;\n}\n.aside .backArrow {\n  position: absolute;\n  top: 10px;\n  left: 15px;\n  width: 9px;\n  height: 18px;\n  padding: 5px;\n  border-radius: 3px;\n}\n.aside .backArrow:before {\n  content: \"\";\n  display: inline-block;\n  position: absolute;\n  width: 9px;\n  height: 18px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -232px -46px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .aside .backArrow:before {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.aside .backArrow:hover:before,\n.aside .backArrow:focus:before {\n  background-position: -232px -68px;\n}\n.aside .addOptions {\n  margin-top: 20px;\n}\n.aside .addOptions h2 {\n  float: left;\n  width: 70%;\n  margin-bottom: 0;\n}\n.aside .addOptions a {\n  float: right;\n  display: block;\n  line-height: 1.9em;\n  font-size: .85em;\n}\n.aside .subHeader {\n  margin-top: 20px;\n}\n.pageSepaAgreementContingency .paypalHeader.span14,\n.pageSepaMandateContingency .paypalHeader.span14,\n.pageSepaMandate .paypalHeader.span14,\n.CYCOPage .paypalHeader.span14 {\n  width: 100%;\n}\n#mobileMerchantHeader {\n  display: none;\n}\n@media (max-width: 41.3125em) {\n  .merchantHeader {\n    display: none;\n  }\n  .paypalHeaderWrapper {\n    height: 65px;\n  }\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -5px;\n    margin-right: 15px;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 30px;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .paypalHeaderWrapper .cartContainer {\n    margin-top: 15px;\n    margin-bottom: -10px;\n    margin-right: 0;\n  }\n  .paypalHeaderWrapper .logo {\n    margin: 15px 0 0 0;\n  }\n  .paypalHeaderWrapper.paypalCredit .logo {\n    height: 35px;\n    margin: 15px 0 0 0;\n    background-position: 0 -129px;\n  }\n  .header {\n    height: 55px;\n  }\n  .aside .header {\n    height: auto;\n  }\n  .aside .close {\n    right: 15px;\n  }\n}\n.footer {\n  max-width: 780px;\n  margin: 10px auto;\n  font-size: 0.75em;\n}\n.cancelUrl {\n  float: left;\n}\n.micaLender {\n  display: none;\n  color: #2c2e2f;\n  clear: both;\n}\n.footerWrapper {\n  text-align: left;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper {\n    float: right;\n  }\n}\n.footerWrapper table {\n  display: inline;\n  float: left;\n  table-layout: fixed;\n  border: none;\n}\n.footerWrapper tr,\n.footerWrapper th,\n.footerWrapper td {\n  border: none;\n  font-weight: normal;\n  padding-bottom: 0;\n  padding-top: 0;\n  text-align: left;\n}\n.footerWrapper .footerLinks {\n  float: left;\n  border: none;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .footerLinks {\n    margin-right: 1em;\n  }\n}\n.footerWrapper .footerLinks li {\n  padding: 0 0.5em;\n  color: #6C7378;\n}\n.footerWrapper .footerLinks li:first-child {\n  padding-left: 0;\n}\n.footerWrapper .footerLinks li.feedbackLink {\n  color: #0070BA;\n}\n.footerWrapper .footerLinks .underline th {\n  border-bottom: 1px solid #ccc;\n}\n@media screen and (min-width: 41em) {\n  .footerWrapper .languageToggleDisplay {\n    clear: none;\n    margin-left: 1.5em;\n  }\n  .footerWrapper .languageToggleDisplay::before {\n    border-left: 2px solid #9da3a6;\n    content: \" \";\n    margin: 0 0.15em;\n    display: inline-block;\n    height: 1em;\n    position: absolute;\n    left: 0;\n    top: 50%;\n    transform: translateY(-50%);\n    margin-left: -0.85em;\n  }\n}\n.footerLinks {\n  margin: 0;\n  display: inline-block;\n  text-align: left;\n}\n.footerLinks a {\n  color: #6C7378;\n}\n.footerLinks a.feedbackLink {\n  color: #0070BA;\n  margin-left: 5px;\n}\n.footerLinks th,\ntd {\n  border: none;\n}\n.policyInfoWrapper {\n  color: #6C7378;\n}\n.policyInfoWrapper p.moreInfo {\n  padding: 15px 0 20px 0;\n  float: left;\n}\n.copyright {\n  display: inline;\n  width: auto;\n  float: right;\n  margin: 0;\n  vertical-align: top;\n  color: #6C7378;\n}\n@media screen and (min-width: 41em) {\n  .copyright {\n    float: left;\n  }\n}\n.secureIcon {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: 0 -33px;\n  margin-left: 3px;\n  margin-right: 3px;\n  margin-top: 3px;\n  width: 10px;\n  height: 12px;\n  vertical-align: top;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .secureIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.poweredBy {\n  float: right;\n  margin-top: -49px;\n}\n.poweredBy .text {\n  float: left;\n  margin-top: 8px;\n  margin-right: 8px;\n  font-size: 12px;\n  font-weight: normal;\n  font-style: italic;\n  color: #6c7378;\n}\n.footerLinks li {\n  padding: 0 12px 0 0;\n  display: inline-block;\n}\n.footerLinks .last {\n  padding-right: 18px;\n  border-right: none;\n}\n.footer .policyInfoWrapper p {\n  line-height: 1.3em;\n}\n.footer .policyInfoWrapper p a {\n  font-weight: bold;\n}\n.minibrowser.AU .footer,\n.minibrowser .APAC.footer {\n  position: relative;\n  bottom: 0;\n  width: auto;\n}\n.minibrowser.AU .footer .policyInfoWrapper,\n.minibrowser .APAC.footer .policyInfoWrapper {\n  padding: 0;\n}\n.minibrowser .cancelUrl {\n  display: none;\n}\n.minibrowser .footerWrapper {\n  padding: 0 10px;\n  float: none;\n  width: 95%;\n  margin: 0;\n}\n.minibrowser .footerLinks li {\n  padding: 0 5px 0 0px;\n}\n/*\n//Country specific rules\n.DE, .fr.FR, .fr.CA {\n    .footerWrapper {\n        &:after {\n            height: 0;\n            display: block;\n            visibility: hidden;\n            clear: both;\n            overflow: auto;\n            line-height: 0;\n            content: \" \";\n        }\n    }\n    .footerLinks {\n        float: left;\n        width: 70%;\n        text-align: left;\n        li:first-child {\n            padding-left: 0;\n        }\n    }\n\n    .cancelUrl {\n        float: none;\n        margin: 5px 0;\n        width: 100%;\n    }\n}\n*/\n.APAC .policyInfoWrapper {\n  padding: 5px 0 10px 0;\n}\n.APAC .policyInfoWrapper p.moreInfo {\n  line-height: 1.3em;\n}\n.en_AU .policyInfoWrapper,\n.AU .policyInfoWrapper {\n  padding: 20px 0 10px 0;\n  color: #6C7378;\n}\n.en_AU .policyInfoWrapper p.moreInfo,\n.AU .policyInfoWrapper p.moreInfo {\n  border-bottom: 1px solid #ccc;\n}\n.en_AU .policyInfoWrapper p.moreCopyRight,\n.AU .policyInfoWrapper p.moreCopyRight {\n  padding: 5px 0 0 0;\n  clear: both;\n}\n.fr_XC .footerWrapper {\n  float: left;\n  width: 70%;\n  text-align: left;\n  padding-left: 0;\n  margin-left: -7px;\n}\n@media (max-width: 41.25em) {\n  .footer {\n    border-top: 1px solid #ccc;\n    padding: 5px 20px;\n    margin-top: 10px;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0 10px;\n  }\n  .footerWrapper {\n    padding: 0;\n    margin: 0;\n  }\n  .footerWrapper:after {\n    height: 0;\n    display: block;\n    visibility: hidden;\n    clear: both;\n    overflow: auto;\n    line-height: 0;\n    content: \" \";\n  }\n  .footerLinks {\n    float: left;\n    width: 70%;\n    text-align: left;\n  }\n  .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n  .cancelUrl {\n    float: none;\n    margin: 5px 0;\n  }\n}\n@media (max-width: 30em) and (min-width: 0) {\n  .footer {\n    margin-top: 0;\n    padding: 0.5em 2em;\n  }\n  .footer .policyInfoWrapper {\n    padding: 0;\n  }\n  .footerWrapper,\n  .cancelUrl {\n    padding: 0;\n    margin: 5px 0px;\n    width: 100%;\n  }\n  .footerLinks,\n  .DE .footerLinks,\n  .fr.FR .footerLinks {\n    width: 65%;\n  }\n  .footerLinks li,\n  .DE .footerLinks li,\n  .fr.FR .footerLinks li {\n    padding: 0;\n    margin-right: 10px;\n  }\n  .footerLinks li.last,\n  .DE .footerLinks li.last,\n  .fr.FR .footerLinks li.last {\n    margin-right: 0;\n  }\n  .footerLinks .feedback,\n  .DE .footerLinks .feedback,\n  .fr.FR .footerLinks .feedback {\n    display: none;\n  }\n  .minibrowser .copyright {\n    margin-right: 0;\n    width: 30%;\n  }\n  .minibrowser .footerLinks .feedback {\n    display: inline-block;\n  }\n}\n.modal-open {\n  overflow: hidden;\n}\n.modal-open .outerWrapper,\n.modal-open #wrapper,\n.modal-open #contents {\n  position: static;\n}\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 140;\n  background-color: #000;\n}\n.modal-backdrop.fade {\n  opacity: 0;\n}\n.modal-backdrop,\n.modal-backdrop.fade.in {\n  opacity: 0.54;\n}\n.modal {\n  display: none;\n  overflow: auto;\n  overflow-y: scroll;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 150;\n}\n.modal.fade .modal-wrap {\n  -webkit-transform: translate(0, -25%);\n  -moz-transform: translate(0, -25%);\n  -ms-transform: translate(0, -25%);\n  -o-transform: translate(0, -25%);\n  transform: translate(0, -25%);\n  -webkit-transition: -webkit-transform 0.3s ease-out;\n  -moz-transition: -moz-transform 0.3s ease-out;\n  -o-transition: -o-transform 0.3s ease-out;\n  transition: transform 0.3s ease-out;\n}\n.modal.fade.in .modal-wrap {\n  -webkit-transform: translate(0, 0);\n  -moz-transform: translate(0, 0);\n  -ms-transform: translate(0, 0);\n  -o-transform: translate(0, 0);\n  transform: translate(0, 0);\n}\n.modal-wrap {\n  position: relative;\n  margin: 10px;\n  background-color: #fff;\n  border: 1px solid #999;\n  border: 1px solid rgba(0, 0, 0, 0.3);\n  -webkit-border-radius: 6px;\n  -moz-border-radius: 6px;\n  border-radius: 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  -moz-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  box-shadow: 0 3px 9px rgba(0, 0, 0, 0.3);\n  outline: none;\n}\n.modal-header {\n  padding: 9px 15px;\n  border-bottom: 1px solid #eee;\n}\n.modal-header .close {\n  margin-top: 2px;\n}\n.modal-header h3 {\n  margin: 0;\n  line-height: 30px;\n}\n.modal-body {\n  position: relative;\n  overflow-y: auto;\n  max-height: 400px;\n  padding: 15px;\n}\n.modal-form {\n  margin-bottom: 0;\n}\n.modal-footer {\n  padding: 14px 15px 15px;\n  margin-bottom: 0;\n  text-align: right;\n  background-color: #f5f5f5;\n  border-top: 1px solid #ddd;\n  -webkit-border-radius: 0 0 6px 6px;\n  -moz-border-radius: 0 0 6px 6px;\n  border-radius: 0 0 6px 6px;\n  -webkit-background-clip: padding-box;\n  -moz-background-clip: padding-box;\n  background-clip: padding-box;\n  -webkit-box-shadow: inset 0 1px 0 #fff;\n  -moz-box-shadow: inset 0 1px 0 #fff;\n  box-shadow: inset 0 1px 0 #fff;\n}\n.modal-footer:before,\n.modal-footer:after {\n  display: table;\n  content: \"\";\n  line-height: 0;\n}\n.modal-footer:after {\n  clear: both;\n}\n.modal-footer .btn + .btn {\n  margin-left: 5px;\n  margin-bottom: 0;\n}\n.modal-footer .btn-group .btn + .btn {\n  margin-left: -1px;\n}\n.modal-footer .btn-block + .btn-block {\n  margin-left: 0;\n}\n.spinner {\n  height: 100%;\n  width: 100%;\n  position: fixed;\n  z-index: 10;\n}\n.spinner .spinWrap {\n  width: 200px;\n  height: 100px;\n  position: fixed;\n  top: 42%;\n  left: 50%;\n  margin-left: -98px;\n  margin-top: -50px;\n}\n.spinner .spinnerImage {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 28px 0 0 -25px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background: url('https://www.paypalobjects.com/images/checkout/hermes/icon_ot_spin_lock_skinny.png') no-repeat;\n}\n.spinner .loader {\n  height: 100px;\n  width: 100px;\n  position: absolute;\n  top: 0;\n  left: 50%;\n  margin: 0 0 0 -55px;\n  opacity: 1;\n  filter: alpha(opacity=100);\n  background-color: transparent;\n  -webkit-animation: rotation .7s infinite linear;\n  -moz-animation: rotation .7s infinite linear;\n  -o-animation: rotation .7s infinite linear;\n  animation: rotation .7s infinite linear;\n  border-left: 5px solid #cbcbca;\n  border-right: 5px solid #cbcbca;\n  border-bottom: 5px solid #cbcbca;\n  border-top: 5px solid #2380be;\n  border-radius: 100%;\n}\n.spinner .genericLoadingMessage,\n.spinner .loginLoadingMessage,\n.spinner .bmlLoadingMessage {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  margin-top: 125px;\n  text-align: center;\n  z-index: 100;\n}\n.spinner.preloader {\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 1000;\n  background-color: #fff;\n}\n@-webkit-keyframes rotation {\n  from {\n    -webkit-transform: rotate(0deg);\n  }\n  to {\n    -webkit-transform: rotate(359deg);\n  }\n}\n@-moz-keyframes rotation {\n  from {\n    -moz-transform: rotate(0deg);\n  }\n  to {\n    -moz-transform: rotate(359deg);\n  }\n}\n@-o-keyframes rotation {\n  from {\n    -o-transform: rotate(0deg);\n  }\n  to {\n    -o-transform: rotate(359deg);\n  }\n}\n@keyframes rotation {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(359deg);\n  }\n}\n@media only screen and (max-width: 768px) {\n  .spinner .spinWrap {\n    width: 200px;\n    height: 100px;\n    position: fixed;\n    top: 40%;\n    left: 50%;\n    margin-left: -93px;\n    margin-top: -50px;\n  }\n}\n.aside {\n  min-height: 380px;\n}\n.aside .container {\n  padding: 15px;\n}\n.asideContent {\n  height: 100%;\n}\n.centerText {\n  text-align: center;\n}\n.fsIcons {\n  display: inline-block;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  min-width: 32px;\n  width: 25px;\n  height: 21px;\n  padding-right: 5px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.HOLDING .fsIcons,\n.BALANCE .fsIcons,\n.DELAYED_TRANSFER .fsIcons {\n  background-position: 0px 0px;\n}\n.ELO .fsIcons {\n  background-position: 0 -479px;\n}\n.HIPER .fsIcons {\n  background-position: 0 -458px;\n}\n.HIPERCARD .fsIcons {\n  background-position: 0 -500px;\n}\n.EBAY_MASTERCARD .fsIcons {\n  background-position: 0px -606px;\n}\n.PayPal.MasterCard .fsIcons {\n  background-position: 0 -604px;\n}\n.pinlessGlyphIcon {\n  display: inline-block;\n  position: relative;\n  top: -5px;\n  left: -8px;\n  width: 32px;\n  height: 20px;\n  font-size: 3.1rem;\n  padding-right: 5px;\n}\n.IACH .fsIcons,\n.BANK .fsIcons,\n.BANK_ACCOUNT .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.ELV .fsIcons,\n.ECHECK .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n}\n.TAB.DELAYED_TRANSFER .fsIcons {\n  background-position: 0 -252px;\n  height: 19px;\n  left: 19px;\n}\n.BILL_ME_LATER .fsIcons,\n.BML .fsIcons,\n.PPCREDIT .fsIcons,\n.CREDIT_OPTION .fsIcons {\n  background-position: 0 -105px;\n}\n.PAYPAL_SMART_CONNECT .fsIcons {\n  background-position: 0px 0px;\n}\n.VISA .fsIcons {\n  background-position: 0 -21px;\n}\n.MASTERCARD .fsIcons {\n  background-position: 0 -42px;\n}\n.AMEX .fsIcons {\n  background-position: 0 -63px;\n  left: 19px;\n  height: 20px;\n}\n.DISCOVER .fsIcons,\n.DISC .fsIcons {\n  background-position: 0 -84px;\n}\n.JCB .fsIcons {\n  background-position: 0px -353px;\n}\n.CHINA_UNION_PAY .fsIcons {\n  background-position: 0px -563px;\n}\n.ELECTRON .fsIcons {\n  background-position: 0 -146px;\n}\n.MAESTRO .fsIcons,\n.MSTRO .fsIcons,\n.SWITCH .fsIcons {\n  background-position: 0 -168px;\n}\n.CB_NATIONALE .fsIcons,\n.CBN .fsIcons {\n  background-position: 0 -210px;\n}\n.CELEM .fsIcons,\n.CETELEM .fsIcons {\n  background-position: 0 -311px;\n}\n.CONF .fsIcons,\n.COFINOGA .fsIcons {\n  background-position: 0 -231px;\n}\n.COFID .fsIcons,\n.COFIDIS .fsIcons {\n  background-position: 0 -437px;\n  left: 20px;\n}\n.INCENTIVE .fsIcons {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.PPSMTCONNECT .fsIcons {\n  background-position: 0 0;\n}\n.RUPAY .fsIcons {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.fsIcon {\n  display: block;\n  position: absolute;\n  width: 32px;\n  height: 21px;\n  left: 15px;\n  top: 20px;\n  min-width: 32px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_1x.png\");\n  background-repeat: no-repeat;\n  background-position: 0px 0px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .fsIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_logos_wallet_v15_2x.png\");\n    background-size: 37px 643px;\n  }\n}\n.fsIcon.PAYPAL_SMART_CONNECT {\n  background-position: 0 0;\n}\n.fsIcon.PPSMTCONNECT {\n  background-position: 0 0;\n}\n.fsIcon.VISA {\n  background-position: 0 -21px;\n}\n.fsIcon.MASTER,\n.fsIcon.MCARD,\n.fsIcon.MASTERCARD {\n  background-position: 0 -42px;\n}\n.fsIcon.AMEX,\n.fsIcon.Amex {\n  background-position: 6px -63px;\n  left: 19px;\n  height: 20px;\n}\n.fsIcon.DISCOVER,\n.fsIcon.DISC {\n  background-position: 0 -84px;\n}\n.fsIcon.PPCREDIT,\n.fsIcon.BML,\n.fsIcon.BILL_ME_LATER {\n  background-position: 0 -105px;\n}\n.fsIcon.SWITCH,\n.fsIcon.MSTRO,\n.fsIcon.MAESTRO {\n  background-position: 0 -168px;\n}\n.fsIcon.CBN,\n.fsIcon.CB_NATIONALE {\n  background-position: 0 -210px;\n}\n.fsIcon.CONF,\n.fsIcon.COFINOGA {\n  background-position: 0 -231px;\n}\n.fsIcon.BANK,\n.fsIcon.PAD {\n  background-position: 6px -252px;\n  height: 19px;\n  left: 19px;\n}\n.fsIcon.INCENTIVE {\n  background-position: 0 -271px;\n  height: 18px;\n}\n.fsIcon.CELEM,\n.fsIcon.CETELEM {\n  background-position: 0 -311px;\n}\n.fsIcon.JCB {\n  background-position: 0px -353px;\n}\n.fsIcon.COFID,\n.fsIcon.COFIDIS {\n  background-position: 0 -437px;\n  left: 20px;\n  height: 20px;\n}\n.fsIcon.HIPER {\n  background-position: 0 -458px;\n}\n.fsIcon.ELO {\n  background-position: 0 -479px;\n}\n.fsIcon.HIPERCARD {\n  background-position: 0 -500px;\n}\n.fsIcon.CHINA_UNION_PAY,\n.fsIcon.CUP {\n  background-position: 0px -563px;\n}\n.fsIcon.PayPal.MasterCard,\n.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.fsIcon.PPXMCARD {\n  background-position: 0 -584px;\n}\n.fsIcon.EBAY_MASTERCARD,\n.fsIcon.EBAYMCARD {\n  background-position: 0px -605px;\n}\n.fsIcon.CHASEPAY {\n  background-position: 0px -626px;\n  width: 36px;\n  height: 14px;\n  display: inline-block;\n  vertical-align: baseline;\n  position: static;\n  margin-bottom: -1px;\n}\n.fsIcon.pinlessIcon {\n  background-image: none;\n  font-size: 3.1rem;\n  left: 5px;\n  top: 14px;\n}\n.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.PayPal.MasterCard .fsIcons,\n.PayPal.MasterCard .fsIcon,\n.PPXMCARD .fsIcons,\n.PPXMCARD .fsIcon,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcons,\n.PAYPAL_EXTRAS_MASTERCARD .fsIcon {\n  background-position: 0 -584px;\n}\n.fsIcon.BILL_ME_LATER_DE,\n.fsIcons.BILL_ME_LATER_DE {\n  position: static;\n  float: left;\n  background-size: auto;\n  background-image: url(\"https://www.paypalobjects.com/webstatic/credit/img/pp-ratenzahlung-logo.png\");\n  background-repeat: no-repeat;\n  background-position: initial;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n}\n.standardCardIcon.pinlessGlyphIcon {\n  display: inline-block;\n  width: 37.12px;\n  height: 24.36px;\n  font-size: 3.6rem;\n  padding-right: 8px;\n  position: relative;\n}\n.standardCardIcon.pinlessGlyphIcon:before {\n  position: absolute;\n  left: -11px;\n  top: 0px;\n}\n.standardCardIcon.fsIcon {\n  background-size: 42.92px 745.88px;\n  width: 37.12px;\n  height: 24.36px;\n}\n.standardCardIcon.fsIcon.VISA {\n  background-position: 0 -24.36px;\n}\n.standardCardIcon.fsIcon.MASTER,\n.standardCardIcon.fsIcon.MCARD,\n.standardCardIcon.fsIcon.MASTERCARD {\n  background-position: 0 -48.72px;\n}\n.standardCardIcon.fsIcon.AMEX,\n.standardCardIcon.fsIcon.Amex {\n  background-position: 5px -73.08px;\n  height: 23.2px;\n}\n.standardCardIcon.fsIcon.DISCOVER,\n.standardCardIcon.fsIcon.DISC {\n  background-position: 0 -97.44px;\n}\n.standardCardIcon.fsIcon.PPCREDIT,\n.standardCardIcon.fsIcon.BML,\n.standardCardIcon.fsIcon.BILL_ME_LATER {\n  background-position: 0 -121.8px;\n}\n.standardCardIcon.fsIcon.SWITCH,\n.standardCardIcon.fsIcon.MSTRO,\n.standardCardIcon.fsIcon.MAESTRO {\n  background-position: 0 -194.88px;\n}\n.standardCardIcon.fsIcon.CBN,\n.standardCardIcon.fsIcon.CB_NATIONALE {\n  background-position: 0 -243.6px;\n}\n.standardCardIcon.fsIcon.CONF,\n.standardCardIcon.fsIcon.COFINOGA {\n  background-position: 0 -267.96px;\n}\n.standardCardIcon.fsIcon.BANK,\n.standardCardIcon.fsIcon.BANK_ACCOUNT,\n.standardCardIcon.fsIcon.PAD {\n  background-position: 5px -292.32px;\n  height: 22.04px;\n}\n.standardCardIcon.fsIcon.INCENTIVE {\n  background-position: 0 -314.36px;\n  height: 20.88px;\n}\n.standardCardIcon.fsIcon.CELEM,\n.standardCardIcon.fsIcon.CETELEM {\n  background-position: 0 -360.76px;\n}\n.standardCardIcon.fsIcon.JCB {\n  background-position: 0px -409.48px;\n}\n.standardCardIcon.fsIcon.HIPER {\n  background-position: 0px -531.28px;\n}\n.standardCardIcon.fsIcon.ELO {\n  background-position: 0px -555.64px;\n}\n.standardCardIcon.fsIcon.HIPERCARD {\n  background-position: 0px -580px;\n}\n.standardCardIcon.fsIcon.Thirdlast {\n  background-position: 0px -600px;\n}\n.standardCardIcon.fsIcon.COFID,\n.standardCardIcon.fsIcon.COFIDIS {\n  background-position: 0px -506.92px;\n}\n.standardCardIcon.fsIcon.CHINA_UNION_PAY,\n.standardCardIcon.fsIcon.CUP {\n  background-position: 0px -653.08px;\n}\n.standardCardIcon.fsIcon.PayPal.MasterCard,\n.standardCardIcon.fsIcon.PAYPAL_EXTRAS_MASTERCARD,\n.standardCardIcon.fsIcon.PPXMCARD {\n  background-position: 0 -677.44px;\n}\n.standardCardIcon.fsIcon.EBAY_MASTERCARD,\n.standardCardIcon.fsIcon.EBAYMCARD {\n  background-position: 0 -701.8px;\n}\n.standardCardIcon.fsIcon.CHASEPAY {\n  background-position: 0px -726.16px;\n  width: 36px;\n  height: 14px;\n}\n.standardCardIcon.fsIcon.RUPAY {\n  background-image: url('https://www.paypalobjects.com/images/checkout/hermes/rupay_logo.svg');\n  background-position: 0 0px;\n  background-size: 32px 20px;\n  background-repeat: no-repeat;\n}\n.infoIcon {\n  width: 19px;\n  height: 18px;\n  display: inline-block;\n  position: absolute;\n  top: 25px;\n  right: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -89px -1px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .infoIcon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.addOption {\n  padding: 25px 10px;\n  margin: 0 0 0 44px;\n  color: #0070BA;\n  font-size: .85em;\n}\n.plusicon {\n  display: block;\n  position: absolute;\n  left: 15px;\n  top: 22px;\n  width: 20px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n  background-position: -223px -97px;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .plusicon {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\n.infoIcon + .checkIcon {\n  display: none;\n}\n.infoMsg {\n  margin: 0;\n  overflow: hidden;\n  font-size: .85em;\n}\n.expiredIcon {\n  background: white url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1.png') no-repeat 98% center;\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  top: 6px;\n  position: relative;\n}\n.plccIcon {\n  float: left;\n  display: inline-block;\n  height: 20px;\n  background: none;\n  width: 32px;\n  position: relative;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .fsIcons {\n    height: 20px;\n  }\n  .fsIcon {\n    height: 20px;\n  }\n}\n.walletIcons {\n  position: absolute;\n  width: 30px;\n  height: 20px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  .walletIcons {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/sprite_wallet_icons_2x.png\");\n    background-size: 90px 970px;\n  }\n}\n.walletIcons.BANK,\n.walletIcons.BANK_ACCOUNT {\n  background-position: -50px -460px;\n}\n.walletIcons.BANK.BOFA,\n.walletIcons.BANK_ACCOUNT.BOFA {\n  background-position: -50px -10px;\n}\n.walletIcons.BANK.CHASE,\n.walletIcons.BANK_ACCOUNT.CHASE {\n  background-position: -50px -130px;\n}\n.walletIcons.BANK.WELLSFARGO,\n.walletIcons.BANK_ACCOUNT.WELLSFARGO {\n  background-position: -50px -100px;\n}\n.walletIcons.BANK.CITI,\n.walletIcons.BANK_ACCOUNT.CITI {\n  background-position: -50px -40px;\n}\n.walletIcons.BANK.FIFTHTHIRD,\n.walletIcons.BANK_ACCOUNT.FIFTHTHIRD {\n  background-position: -50px -220px;\n}\n.walletIcons.BANK.CAPITAL,\n.walletIcons.BANK_ACCOUNT.CAPITAL {\n  background-position: -50px -70px;\n}\n.walletIcons.BANK.AMERITRADE,\n.walletIcons.BANK_ACCOUNT.AMERITRADE {\n  background-position: -50px -160px;\n}\n.walletIcons.BANK.SUNTRUST,\n.walletIcons.BANK_ACCOUNT.SUNTRUST {\n  background-position: -50px -280px;\n}\n.walletIcons.BANK.USBANK,\n.walletIcons.BANK_ACCOUNT.USBANK {\n  background-position: -50px -310px;\n}\n.walletIcons.BANK.USAA,\n.walletIcons.BANK_ACCOUNT.USAA {\n  background-position: -50px -250px;\n}\n.walletIcons.CARD.VISA,\n.walletIcons.PAYMENT_CARD.VISA {\n  background-position: -10px -40px;\n}\n.walletIcons.CARD.MASTER,\n.walletIcons.PAYMENT_CARD.MASTER,\n.walletIcons.CARD.MASTERCARD,\n.walletIcons.PAYMENT_CARD.MASTERCARD {\n  background-position: -10px -70px;\n}\n.walletIcons.CARD.DISCOVER,\n.walletIcons.PAYMENT_CARD.DISCOVER {\n  background-position: -10px -100px;\n}\n.walletIcons.CARD.AMEX,\n.walletIcons.PAYMENT_CARD.AMEX {\n  background-position: -10px -130px;\n}\nhr.sep,\nhr.sepPlain {\n  padding: 0;\n  margin-top: 25px;\n  height: auto;\n  border: none;\n  border-top: 1px solid #ccc;\n  color: #2c2e2f;\n  text-align: center;\n  overflow: visible;\n}\nhr.sep:after,\nhr.sepPlain:after,\nhr.sep::after,\nhr.sepPlain::after {\n  content: \"or\";\n  display: inline-block;\n  position: relative;\n  top: -0.7em;\n  font-size: 1em;\n  padding: 0 0.50em;\n  background: white;\n  color: #6c7378;\n  font-weight: normal;\n}\n.de hr.sep:after,\n.de hr.sep::after {\n  content: \"oder\";\n}\n.da hr.sep:after,\n.da hr.sep::after {\n  content: \"eller\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\n.es hr.sep:after,\n.es hr.sep::after {\n  content: \"o\";\n}\n.fr hr.sep:after,\n.fr hr.sep::after {\n  content: \"ou\";\n}\n.he hr.sep:after,\n.he hr.sep::after {\n  content: \"\\5D0\\5D5\";\n}\n.id hr.sep:after,\n.id hr.sep::after {\n  content: \"Atau\";\n}\n.it hr.sep:after,\n.it hr.sep::after {\n  content: \"oppure\";\n}\n.ja hr.sep:after,\n.ja hr.sep::after {\n  content: \"\\307E\\305F\\306F\";\n}\n.ko hr.sep:after,\n.ko hr.sep::after {\n  content: \"\\B610\\B294\";\n}\n.nl hr.sep:after,\n.nl hr.sep::after {\n  content: \"of\";\n}\n.no hr.sep:after,\n.no hr.sep::after {\n  content: \"eller\";\n}\n.pl hr.sep:after,\n.pl hr.sep::after {\n  content: \"lub\";\n}\n.pt hr.sep:after,\n.pt hr.sep::after {\n  content: \"ou\";\n}\n.ru hr.sep:after,\n.ru hr.sep::after {\n  content: \"\\418\\43B\\438\";\n}\n.sv hr.sep:after,\n.sv hr.sep::after {\n  content: \"eller\";\n}\n.th hr.sep:after,\n.th hr.sep::after {\n  content: \"\\E2B\\E23\\E37\\E2D\";\n}\n.tr hr.sep:after,\n.tr hr.sep::after {\n  content: \"Veya\";\n}\n.zh hr.sep:after,\n.zh hr.sep::after {\n  content: \"\\6216\";\n}\nhr.sepPlain:after,\nhr.sepPlain::after {\n  content: '';\n}\n/*\n * @fileOverview queries.css contains media queries for responsive design/layout breakpoints.\n * @name Queries\n * @author abadri\n * @tested browsers FF 12, Chrome 18, Safari 5 on Mac\n */\n@media (min-width: 0) and (max-width: 23em) {\n  #loginSection .xoTitle h1 {\n    max-width: 10em;\n  }\n}\n@media (min-width: 0) and (max-width: 30em), (max-width: 40em) and (orientation: landscape) {\n  body {\n    -webkit-text-size-adjust: 100%;\n  }\n  .merchantBrand {\n    display: none;\n  }\n  .outerWrapper {\n    background-position: left 50px;\n  }\n  .centerTray.loginSignup {\n    margin-bottom: 60px;\n  }\n  #main {\n    padding: 0;\n    background: none;\n    z-index: 2;\n  }\n  #contents {\n    padding: 0 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  .tokenization #contents {\n    padding: 0 30px;\n  }\n  .paypalHeader {\n    padding: 0 20px 20px 20px;\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    -ms-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  .review #wrapper {\n    min-height: 512px;\n  }\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .loginProcessing,\n  .bmlAppProcessing {\n    background-color: #f9f9f9;\n  }\n  .loggingIn {\n    margin: 0 25px;\n  }\n  .mobile .loggingIn {\n    margin: 0;\n  }\n  .saferEasier,\n  .simpler {\n    display: none;\n  }\n  #login .row-fluid {\n    padding-top: 0px;\n  }\n  #login .centerTray {\n    padding: 0;\n  }\n  #login #signupLink.btn {\n    margin: 5px 0;\n  }\n  #wrapper {\n    margin: 0;\n    width: auto;\n    -webkit-border-radius: 0;\n    -moz-border-radius: 0;\n    border-radius: 0;\n    -webkit-background-clip: padding-box;\n    -moz-background-clip: padding-box;\n    background-clip: padding-box;\n    border: none;\n  }\n  #task {\n    width: 295px;\n  }\n  .loading .spinner {\n    background-position-y: 35%;\n  }\n  .centerTray {\n    width: auto;\n  }\n  .tray .inner,\n  .accountTerms .tray .inner {\n    padding: 10px;\n  }\n  .row-fluid > [class*=\"span\"],\n  .signup {\n    width: 100%;\n    margin-left: 0;\n    float: none;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .gamma,\n  .delta {\n    font-size: 1.2em;\n  }\n  .inputField label {\n    left: 7px;\n    top: 13px;\n  }\n  .saferEasier {\n    display: none;\n  }\n  #fundingInstruments .buttons {\n    height: 40px;\n  }\n  .cityState select {\n    font-size: 14px;\n  }\n  .cityState .city {\n    width: 100%;\n  }\n  .cityState .state {\n    width: 55%;\n  }\n  .cityState .postalCode {\n    width: 40.8%;\n  }\n  #tab {\n    margin-top: 0;\n    height: 125px;\n  }\n  .toolTip.whatsthis ul {\n    width: 242px;\n    left: 9px;\n  }\n  .toolTip.whatsthis ul li {\n    font-size: 0.9em;\n  }\n  #expiration.varB .expires {\n    width: 49%;\n  }\n  #expiration .inputField {\n    padding: 0;\n  }\n  #expiration .cvc {\n    width: 44%;\n    float: right;\n  }\n  #expiration.varB .cvc {\n    width: 49%;\n  }\n  .month {\n    margin-left: 46px;\n  }\n  .separator {\n    margin-left: 5px;\n    margin-top: 3px;\n  }\n  .year {\n    margin-left: 0;\n  }\n  #expiration .cardIcon {\n    position: absolute;\n    right: 4px;\n  }\n  .details {\n    margin-right: 2px;\n  }\n  .mask #header,\n  .mask #closeButton {\n    display: none;\n  }\n}\n@media (min-width: 30.0625em) and (max-width: 41.25em) {\n  .row-fluid > .span10,\n  .row-fluid > .span12,\n  .row-fluid > .span14 {\n    width: 100%;\n  }\n  #notifications {\n    width: 100%;\n  }\n  .outerWrapper {\n    background-position: left 59px;\n  }\n  header,\n  .props {\n    display: none;\n  }\n  #wrapper {\n    margin: 0;\n    border: none;\n  }\n  #main {\n    padding: 0;\n  }\n  #contents {\n    padding: 0 25px;\n  }\n}\n@media (min-width: 41.3125em) {\n  .banner {\n    display: block;\n  }\n  #wrapper {\n    min-height: 0;\n    width: 95%;\n  }\n  .merchantHeader,\n  .footer {\n    width: 95%;\n  }\n  .largeScreen .centerTray {\n    margin-top: 0;\n  }\n  .signup {\n    margin-bottom: 0;\n  }\n  #genericError {\n    min-height: 375px;\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/scr_cloud_balloon.png) no-repeat center bottom;\n  }\n  #transactionDetails .merchantName {\n    display: none;\n  }\n}\n@media (device-height: 568px) and (-webkit-min-device-pixel-ratio: 2) {\n  #contents {\n    min-height: 0;\n    margin-bottom: 0;\n  }\n  .pageLanding #contents {\n    margin: 70px auto 40px 0px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2) {\n  .cardType {\n    display: none;\n  }\n  ul.validations li.restriction.active {\n    background: url(https://www.paypalobjects.com/images/checkout/hermes/close3_2x.png) no-repeat 0 2px;\n    background-size: 10px;\n  }\n  .inputField.error input {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n  .inputField.error input,\n  .inputField.valid input {\n    background-position: -webkit-calc(100% - 10px) center;\n    background-position: right 10px center;\n  }\n  .error .custom-select > span,\n  .error .custom-select.active > span {\n    background-image: url('https://www.paypalobjects.com/images/checkout/hermes/error-icon_v1_2x.png');\n    background-size: 18px;\n  }\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2) and (min-width: 41.3125em) {\n  #genericError {\n    background-size: 640px 242px;\n  }\n}\n/*\n    .within-rtl({ ... });\n    Targets rules for both xoon and hermes, when RTL applies\n*/\n*[dir=\"rtl\"] .footerWrapper .footerLinks,\n.outerWrapper.rtl .footerWrapper .footerLinks {\n  float: right;\n}\n*[dir=\"rtl\"] .footerWrapper .footerLinks li:first-child,\n.outerWrapper.rtl .footerWrapper .footerLinks li:first-child {\n  padding-left: 12px;\n}\n@media screen and (max-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: none;\n    clear: both;\n  }\n}\n@media screen and (min-width: 41em) {\n  *[dir=\"rtl\"] .footerWrapper,\n  .outerWrapper.rtl .footerWrapper {\n    float: left;\n  }\n  *[dir=\"rtl\"] .footerWrapper .languageToggleDisplay::before,\n  .outerWrapper.rtl .footerWrapper .languageToggleDisplay::before {\n    right: 0;\n    margin-left: 0.85em;\n  }\n}\n*[dir=\"rtl\"] .paypalHeader .languageToggleDisplay,\n.outerWrapper.rtl .paypalHeader .languageToggleDisplay {\n  float: right;\n}\n@media (min-width: 41.3125em) {\n  section#invalidAddressGenericError .container {\n    width: 400px;\n  }\n  .genericError.footerWrapper {\n    float: none;\n    width: 99.4%;\n    padding: 0 3px;\n  }\n  .genericError.footerWrapper .footerLinks {\n    float: left;\n    width: 70%;\n    text-align: left;\n  }\n}\nsection#invalidAddressGenericError {\n  height: 450px;\n  background: none;\n}\nsection#invalidAddressGenericError .container {\n  position: relative;\n  margin: 0 auto;\n  top: 50%;\n  -webkit-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  transform: translateY(-50%);\n}\nsection#invalidAddressGenericError .title {\n  font-size: 1.5em;\n  margin-bottom: 20px;\n  line-height: 1.25;\n  font-weight: 300;\n  color: #2c2e2f;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\nsection#invalidAddressGenericError .message {\n  font-size: 1.0em;\n  margin-bottom: 20px;\n  color: #6c7378;\n  font-weight: 400;\n  line-height: 1.33;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n}\nsection#invalidAddressGenericError .secondaryMessage {\n  color: #979797;\n  line-height: 20px;\n}\nsection#invalidAddressGenericError .logo {\n  width: 112px;\n  height: 29px;\n  margin: 5px 0 20px;\n  background-position: 0 -47px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  section#invalidAddressGenericError .logo {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\nsection#invalidAddressGenericError .redirectLink {\n  margin-top: 20px;\n}\nsection#invalidAddressGenericError .errorField {\n  width: 22px;\n  height: 22px;\n  margin: 0px -30px -20px;\n  background-position: -137px 0px;\n  background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16.png\");\n  background-repeat: no-repeat;\n}\n@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {\n  section#invalidAddressGenericError .errorField {\n    background-image: url(\"https://www.paypalobjects.com/images/checkout/hermes/hermes_window_sprite_v16_2x.png\");\n    background-size: 250px 350px;\n  }\n}\nsection#invalidAddressGenericError .shippingAddress {\n  margin: 20px 8px;\n  padding: 13px 19px;\n  border-radius: 4px;\n  line-height: 1.35em;\n}\nsection#invalidAddressGenericError .shippingAddress .firstLine {\n  display: inline-block;\n  margin-bottom: 0;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 15px;\n  font-weight: 400;\n}\nsection#invalidAddressGenericError .shippingAddress .secondLine {\n  margin-bottom: 0;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 15px;\n  font-weight: 400;\n}\nsection#invalidAddressGenericError .shippingAddress .thirdLine {\n  margin-bottom: 0;\n  font-family: \"Helvetica Neue\", \"HelveticaNeue\", \"HelveticaNeue-Light\", \"Helvetica Neue Light\", helvetica, arial, sans-serif;\n  font-size: 15px;\n  font-weight: 400;\n}\n", ""]);

// exports


/***/ }),

/***/ "../node_modules/css-loader/lib/css-base.js":
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}



/***/ }),

/***/ "../node_modules/ieee754/index.js":
/***/ (function(module, exports) {

exports.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var nBits = -7
  var i = isLE ? (nBytes - 1) : 0
  var d = isLE ? -1 : 1
  var s = buffer[offset + i]

  i += d

  e = s & ((1 << (-nBits)) - 1)
  s >>= (-nBits)
  nBits += eLen
  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1)
  e >>= (-nBits)
  nBits += mLen
  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen)
    e = e - eBias
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
}

exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
  var i = isLE ? 0 : (nBytes - 1)
  var d = isLE ? 1 : -1
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0

  value = Math.abs(value)

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0
    e = eMax
  } else {
    e = Math.floor(Math.log(value) / Math.LN2)
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--
      c *= 2
    }
    if (e + eBias >= 1) {
      value += rt / c
    } else {
      value += rt * Math.pow(2, 1 - eBias)
    }
    if (value * c >= 2) {
      e++
      c /= 2
    }

    if (e + eBias >= eMax) {
      m = 0
      e = eMax
    } else if (e + eBias >= 1) {
      m = ((value * c) - 1) * Math.pow(2, mLen)
      e = e + eBias
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
      e = 0
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m
  eLen += mLen
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128
}



/***/ }),

/***/ "../node_modules/isarray/index.js":
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};



/***/ }),

/***/ "../node_modules/lodash/index.js":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module, global) {var __WEBPACK_AMD_DEFINE_RESULT__;/**
 * @license
 * lodash 3.10.1 (Custom Build) <https://lodash.com/>
 * Build: `lodash modern -d -o ./index.js`
 * Copyright 2012-2015 The Dojo Foundation <http://dojofoundation.org/>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 * Available under MIT license <https://lodash.com/license>
 */
;(function() {

  /** Used as a safe reference for `undefined` in pre-ES5 environments. */
  var undefined;

  /** Used as the semantic version number. */
  var VERSION = '3.10.1';

  /** Used to compose bitmasks for wrapper metadata. */
  var BIND_FLAG = 1,
      BIND_KEY_FLAG = 2,
      CURRY_BOUND_FLAG = 4,
      CURRY_FLAG = 8,
      CURRY_RIGHT_FLAG = 16,
      PARTIAL_FLAG = 32,
      PARTIAL_RIGHT_FLAG = 64,
      ARY_FLAG = 128,
      REARG_FLAG = 256;

  /** Used as default options for `_.trunc`. */
  var DEFAULT_TRUNC_LENGTH = 30,
      DEFAULT_TRUNC_OMISSION = '...';

  /** Used to detect when a function becomes hot. */
  var HOT_COUNT = 150,
      HOT_SPAN = 16;

  /** Used as the size to enable large array optimizations. */
  var LARGE_ARRAY_SIZE = 200;

  /** Used to indicate the type of lazy iteratees. */
  var LAZY_FILTER_FLAG = 1,
      LAZY_MAP_FLAG = 2;

  /** Used as the `TypeError` message for "Functions" methods. */
  var FUNC_ERROR_TEXT = 'Expected a function';

  /** Used as the internal argument placeholder. */
  var PLACEHOLDER = '__lodash_placeholder__';

  /** `Object#toString` result references. */
  var argsTag = '[object Arguments]',
      arrayTag = '[object Array]',
      boolTag = '[object Boolean]',
      dateTag = '[object Date]',
      errorTag = '[object Error]',
      funcTag = '[object Function]',
      mapTag = '[object Map]',
      numberTag = '[object Number]',
      objectTag = '[object Object]',
      regexpTag = '[object RegExp]',
      setTag = '[object Set]',
      stringTag = '[object String]',
      weakMapTag = '[object WeakMap]';

  var arrayBufferTag = '[object ArrayBuffer]',
      float32Tag = '[object Float32Array]',
      float64Tag = '[object Float64Array]',
      int8Tag = '[object Int8Array]',
      int16Tag = '[object Int16Array]',
      int32Tag = '[object Int32Array]',
      uint8Tag = '[object Uint8Array]',
      uint8ClampedTag = '[object Uint8ClampedArray]',
      uint16Tag = '[object Uint16Array]',
      uint32Tag = '[object Uint32Array]';

  /** Used to match empty string literals in compiled template source. */
  var reEmptyStringLeading = /\b__p \+= '';/g,
      reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
      reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;

  /** Used to match HTML entities and HTML characters. */
  var reEscapedHtml = /&(?:amp|lt|gt|quot|#39|#96);/g,
      reUnescapedHtml = /[&<>"'`]/g,
      reHasEscapedHtml = RegExp(reEscapedHtml.source),
      reHasUnescapedHtml = RegExp(reUnescapedHtml.source);

  /** Used to match template delimiters. */
  var reEscape = /<%-([\s\S]+?)%>/g,
      reEvaluate = /<%([\s\S]+?)%>/g,
      reInterpolate = /<%=([\s\S]+?)%>/g;

  /** Used to match property names within property paths. */
  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\n\\]|\\.)*?\1)\]/,
      reIsPlainProp = /^\w*$/,
      rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\n\\]|\\.)*?)\2)\]/g;

  /**
   * Used to match `RegExp` [syntax characters](http://ecma-international.org/ecma-262/6.0/#sec-patterns)
   * and those outlined by [`EscapeRegExpPattern`](http://ecma-international.org/ecma-262/6.0/#sec-escaperegexppattern).
   */
  var reRegExpChars = /^[:!,]|[\\^$.*+?()[\]{}|\/]|(^[0-9a-fA-Fnrtuvx])|([\n\r\u2028\u2029])/g,
      reHasRegExpChars = RegExp(reRegExpChars.source);

  /** Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks). */
  var reComboMark = /[\u0300-\u036f\ufe20-\ufe23]/g;

  /** Used to match backslashes in property paths. */
  var reEscapeChar = /\\(\\)?/g;

  /** Used to match [ES template delimiters](http://ecma-international.org/ecma-262/6.0/#sec-template-literal-lexical-components). */
  var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;

  /** Used to match `RegExp` flags from their coerced string values. */
  var reFlags = /\w*$/;

  /** Used to detect hexadecimal string values. */
  var reHasHexPrefix = /^0[xX]/;

  /** Used to detect host constructors (Safari > 5). */
  var reIsHostCtor = /^\[object .+?Constructor\]$/;

  /** Used to detect unsigned integer values. */
  var reIsUint = /^\d+$/;

  /** Used to match latin-1 supplementary letters (excluding mathematical operators). */
  var reLatin1 = /[\xc0-\xd6\xd8-\xde\xdf-\xf6\xf8-\xff]/g;

  /** Used to ensure capturing order of template delimiters. */
  var reNoMatch = /($^)/;

  /** Used to match unescaped characters in compiled string literals. */
  var reUnescapedString = /['\n\r\u2028\u2029\\]/g;

  /** Used to match words to create compound words. */
  var reWords = (function() {
    var upper = '[A-Z\\xc0-\\xd6\\xd8-\\xde]',
        lower = '[a-z\\xdf-\\xf6\\xf8-\\xff]+';

    return RegExp(upper + '+(?=' + upper + lower + ')|' + upper + '?' + lower + '|' + upper + '+|[0-9]+', 'g');
  }());

  /** Used to assign default `context` object properties. */
  var contextProps = [
    'Array', 'ArrayBuffer', 'Date', 'Error', 'Float32Array', 'Float64Array',
    'Function', 'Int8Array', 'Int16Array', 'Int32Array', 'Math', 'Number',
    'Object', 'RegExp', 'Set', 'String', '_', 'clearTimeout', 'isFinite',
    'parseFloat', 'parseInt', 'setTimeout', 'TypeError', 'Uint8Array',
    'Uint8ClampedArray', 'Uint16Array', 'Uint32Array', 'WeakMap'
  ];

  /** Used to make template sourceURLs easier to identify. */
  var templateCounter = -1;

  /** Used to identify `toStringTag` values of typed arrays. */
  var typedArrayTags = {};
  typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
  typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
  typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
  typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
  typedArrayTags[uint32Tag] = true;
  typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
  typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
  typedArrayTags[dateTag] = typedArrayTags[errorTag] =
  typedArrayTags[funcTag] = typedArrayTags[mapTag] =
  typedArrayTags[numberTag] = typedArrayTags[objectTag] =
  typedArrayTags[regexpTag] = typedArrayTags[setTag] =
  typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;

  /** Used to identify `toStringTag` values supported by `_.clone`. */
  var cloneableTags = {};
  cloneableTags[argsTag] = cloneableTags[arrayTag] =
  cloneableTags[arrayBufferTag] = cloneableTags[boolTag] =
  cloneableTags[dateTag] = cloneableTags[float32Tag] =
  cloneableTags[float64Tag] = cloneableTags[int8Tag] =
  cloneableTags[int16Tag] = cloneableTags[int32Tag] =
  cloneableTags[numberTag] = cloneableTags[objectTag] =
  cloneableTags[regexpTag] = cloneableTags[stringTag] =
  cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
  cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  cloneableTags[errorTag] = cloneableTags[funcTag] =
  cloneableTags[mapTag] = cloneableTags[setTag] =
  cloneableTags[weakMapTag] = false;

  /** Used to map latin-1 supplementary letters to basic latin letters. */
  var deburredLetters = {
    '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
    '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
    '\xc7': 'C',  '\xe7': 'c',
    '\xd0': 'D',  '\xf0': 'd',
    '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
    '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
    '\xcC': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
    '\xeC': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
    '\xd1': 'N',  '\xf1': 'n',
    '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
    '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
    '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
    '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
    '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
    '\xc6': 'Ae', '\xe6': 'ae',
    '\xde': 'Th', '\xfe': 'th',
    '\xdf': 'ss'
  };

  /** Used to map characters to HTML entities. */
  var htmlEscapes = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;',
    '`': '&#96;'
  };

  /** Used to map HTML entities to characters. */
  var htmlUnescapes = {
    '&amp;': '&',
    '&lt;': '<',
    '&gt;': '>',
    '&quot;': '"',
    '&#39;': "'",
    '&#96;': '`'
  };

  /** Used to determine if values are of the language type `Object`. */
  var objectTypes = {
    'function': true,
    'object': true
  };

  /** Used to escape characters for inclusion in compiled regexes. */
  var regexpEscapes = {
    '0': 'x30', '1': 'x31', '2': 'x32', '3': 'x33', '4': 'x34',
    '5': 'x35', '6': 'x36', '7': 'x37', '8': 'x38', '9': 'x39',
    'A': 'x41', 'B': 'x42', 'C': 'x43', 'D': 'x44', 'E': 'x45', 'F': 'x46',
    'a': 'x61', 'b': 'x62', 'c': 'x63', 'd': 'x64', 'e': 'x65', 'f': 'x66',
    'n': 'x6e', 'r': 'x72', 't': 'x74', 'u': 'x75', 'v': 'x76', 'x': 'x78'
  };

  /** Used to escape characters for inclusion in compiled string literals. */
  var stringEscapes = {
    '\\': '\\',
    "'": "'",
    '\n': 'n',
    '\r': 'r',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };

  /** Detect free variable `exports`. */
  var freeExports = objectTypes[typeof exports] && exports && !exports.nodeType && exports;

  /** Detect free variable `module`. */
  var freeModule = objectTypes[typeof module] && module && !module.nodeType && module;

  /** Detect free variable `global` from Node.js. */
  var freeGlobal = freeExports && freeModule && typeof global == 'object' && global && global.Object && global;

  /** Detect free variable `self`. */
  var freeSelf = objectTypes[typeof self] && self && self.Object && self;

  /** Detect free variable `window`. */
  var freeWindow = objectTypes[typeof window] && window && window.Object && window;

  /** Detect the popular CommonJS extension `module.exports`. */
  var moduleExports = freeModule && freeModule.exports === freeExports && freeExports;

  /**
   * Used as a reference to the global object.
   *
   * The `this` value is used if it's the global object to avoid Greasemonkey's
   * restricted `window` object, otherwise the `window` object is used.
   */
  var root = freeGlobal || ((freeWindow !== (this && this.window)) && freeWindow) || freeSelf || this;

  /*--------------------------------------------------------------------------*/

  /**
   * The base implementation of `compareAscending` which compares values and
   * sorts them in ascending order without guaranteeing a stable sort.
   *
   * @private
   * @param {*} value The value to compare.
   * @param {*} other The other value to compare.
   * @returns {number} Returns the sort order indicator for `value`.
   */
  function baseCompareAscending(value, other) {
    if (value !== other) {
      var valIsNull = value === null,
          valIsUndef = value === undefined,
          valIsReflexive = value === value;

      var othIsNull = other === null,
          othIsUndef = other === undefined,
          othIsReflexive = other === other;

      if ((value > other && !othIsNull) || !valIsReflexive ||
          (valIsNull && !othIsUndef && othIsReflexive) ||
          (valIsUndef && othIsReflexive)) {
        return 1;
      }
      if ((value < other && !valIsNull) || !othIsReflexive ||
          (othIsNull && !valIsUndef && valIsReflexive) ||
          (othIsUndef && valIsReflexive)) {
        return -1;
      }
    }
    return 0;
  }

  /**
   * The base implementation of `_.findIndex` and `_.findLastIndex` without
   * support for callback shorthands and `this` binding.
   *
   * @private
   * @param {Array} array The array to search.
   * @param {Function} predicate The function invoked per iteration.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseFindIndex(array, predicate, fromRight) {
    var length = array.length,
        index = fromRight ? length : -1;

    while ((fromRight ? index-- : ++index < length)) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }
    return -1;
  }

  /**
   * The base implementation of `_.indexOf` without support for binary searches.
   *
   * @private
   * @param {Array} array The array to search.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseIndexOf(array, value, fromIndex) {
    if (value !== value) {
      return indexOfNaN(array, fromIndex);
    }
    var index = fromIndex - 1,
        length = array.length;

    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }
    return -1;
  }

  /**
   * The base implementation of `_.isFunction` without support for environments
   * with incorrect `typeof` results.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
   */
  function baseIsFunction(value) {
    // Avoid a Chakra JIT bug in compatibility modes of IE 11.
    // See https://github.com/jashkenas/underscore/issues/1621 for more details.
    return typeof value == 'function' || false;
  }

  /**
   * Converts `value` to a string if it's not one. An empty string is returned
   * for `null` or `undefined` values.
   *
   * @private
   * @param {*} value The value to process.
   * @returns {string} Returns the string.
   */
  function baseToString(value) {
    return value == null ? '' : (value + '');
  }

  /**
   * Used by `_.trim` and `_.trimLeft` to get the index of the first character
   * of `string` that is not found in `chars`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @param {string} chars The characters to find.
   * @returns {number} Returns the index of the first character not found in `chars`.
   */
  function charsLeftIndex(string, chars) {
    var index = -1,
        length = string.length;

    while (++index < length && chars.indexOf(string.charAt(index)) > -1) {}
    return index;
  }

  /**
   * Used by `_.trim` and `_.trimRight` to get the index of the last character
   * of `string` that is not found in `chars`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @param {string} chars The characters to find.
   * @returns {number} Returns the index of the last character not found in `chars`.
   */
  function charsRightIndex(string, chars) {
    var index = string.length;

    while (index-- && chars.indexOf(string.charAt(index)) > -1) {}
    return index;
  }

  /**
   * Used by `_.sortBy` to compare transformed elements of a collection and stable
   * sort them in ascending order.
   *
   * @private
   * @param {Object} object The object to compare.
   * @param {Object} other The other object to compare.
   * @returns {number} Returns the sort order indicator for `object`.
   */
  function compareAscending(object, other) {
    return baseCompareAscending(object.criteria, other.criteria) || (object.index - other.index);
  }

  /**
   * Used by `_.sortByOrder` to compare multiple properties of a value to another
   * and stable sort them.
   *
   * If `orders` is unspecified, all valuess are sorted in ascending order. Otherwise,
   * a value is sorted in ascending order if its corresponding order is "asc", and
   * descending if "desc".
   *
   * @private
   * @param {Object} object The object to compare.
   * @param {Object} other The other object to compare.
   * @param {boolean[]} orders The order to sort by for each property.
   * @returns {number} Returns the sort order indicator for `object`.
   */
  function compareMultiple(object, other, orders) {
    var index = -1,
        objCriteria = object.criteria,
        othCriteria = other.criteria,
        length = objCriteria.length,
        ordersLength = orders.length;

    while (++index < length) {
      var result = baseCompareAscending(objCriteria[index], othCriteria[index]);
      if (result) {
        if (index >= ordersLength) {
          return result;
        }
        var order = orders[index];
        return result * ((order === 'asc' || order === true) ? 1 : -1);
      }
    }
    // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
    // that causes it, under certain circumstances, to provide the same value for
    // `object` and `other`. See https://github.com/jashkenas/underscore/pull/1247
    // for more details.
    //
    // This also ensures a stable sort in V8 and other engines.
    // See https://code.google.com/p/v8/issues/detail?id=90 for more details.
    return object.index - other.index;
  }

  /**
   * Used by `_.deburr` to convert latin-1 supplementary letters to basic latin letters.
   *
   * @private
   * @param {string} letter The matched letter to deburr.
   * @returns {string} Returns the deburred letter.
   */
  function deburrLetter(letter) {
    return deburredLetters[letter];
  }

  /**
   * Used by `_.escape` to convert characters to HTML entities.
   *
   * @private
   * @param {string} chr The matched character to escape.
   * @returns {string} Returns the escaped character.
   */
  function escapeHtmlChar(chr) {
    return htmlEscapes[chr];
  }

  /**
   * Used by `_.escapeRegExp` to escape characters for inclusion in compiled regexes.
   *
   * @private
   * @param {string} chr The matched character to escape.
   * @param {string} leadingChar The capture group for a leading character.
   * @param {string} whitespaceChar The capture group for a whitespace character.
   * @returns {string} Returns the escaped character.
   */
  function escapeRegExpChar(chr, leadingChar, whitespaceChar) {
    if (leadingChar) {
      chr = regexpEscapes[chr];
    } else if (whitespaceChar) {
      chr = stringEscapes[chr];
    }
    return '\\' + chr;
  }

  /**
   * Used by `_.template` to escape characters for inclusion in compiled string literals.
   *
   * @private
   * @param {string} chr The matched character to escape.
   * @returns {string} Returns the escaped character.
   */
  function escapeStringChar(chr) {
    return '\\' + stringEscapes[chr];
  }

  /**
   * Gets the index at which the first occurrence of `NaN` is found in `array`.
   *
   * @private
   * @param {Array} array The array to search.
   * @param {number} fromIndex The index to search from.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched `NaN`, else `-1`.
   */
  function indexOfNaN(array, fromIndex, fromRight) {
    var length = array.length,
        index = fromIndex + (fromRight ? 0 : -1);

    while ((fromRight ? index-- : ++index < length)) {
      var other = array[index];
      if (other !== other) {
        return index;
      }
    }
    return -1;
  }

  /**
   * Checks if `value` is object-like.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   */
  function isObjectLike(value) {
    return !!value && typeof value == 'object';
  }

  /**
   * Used by `trimmedLeftIndex` and `trimmedRightIndex` to determine if a
   * character code is whitespace.
   *
   * @private
   * @param {number} charCode The character code to inspect.
   * @returns {boolean} Returns `true` if `charCode` is whitespace, else `false`.
   */
  function isSpace(charCode) {
    return ((charCode <= 160 && (charCode >= 9 && charCode <= 13) || charCode == 32 || charCode == 160) || charCode == 5760 || charCode == 6158 ||
      (charCode >= 8192 && (charCode <= 8202 || charCode == 8232 || charCode == 8233 || charCode == 8239 || charCode == 8287 || charCode == 12288 || charCode == 65279)));
  }

  /**
   * Replaces all `placeholder` elements in `array` with an internal placeholder
   * and returns an array of their indexes.
   *
   * @private
   * @param {Array} array The array to modify.
   * @param {*} placeholder The placeholder to replace.
   * @returns {Array} Returns the new array of placeholder indexes.
   */
  function replaceHolders(array, placeholder) {
    var index = -1,
        length = array.length,
        resIndex = -1,
        result = [];

    while (++index < length) {
      if (array[index] === placeholder) {
        array[index] = PLACEHOLDER;
        result[++resIndex] = index;
      }
    }
    return result;
  }

  /**
   * An implementation of `_.uniq` optimized for sorted arrays without support
   * for callback shorthands and `this` binding.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Function} [iteratee] The function invoked per iteration.
   * @returns {Array} Returns the new duplicate-value-free array.
   */
  function sortedUniq(array, iteratee) {
    var seen,
        index = -1,
        length = array.length,
        resIndex = -1,
        result = [];

    while (++index < length) {
      var value = array[index],
          computed = iteratee ? iteratee(value, index, array) : value;

      if (!index || seen !== computed) {
        seen = computed;
        result[++resIndex] = value;
      }
    }
    return result;
  }

  /**
   * Used by `_.trim` and `_.trimLeft` to get the index of the first non-whitespace
   * character of `string`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {number} Returns the index of the first non-whitespace character.
   */
  function trimmedLeftIndex(string) {
    var index = -1,
        length = string.length;

    while (++index < length && isSpace(string.charCodeAt(index))) {}
    return index;
  }

  /**
   * Used by `_.trim` and `_.trimRight` to get the index of the last non-whitespace
   * character of `string`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {number} Returns the index of the last non-whitespace character.
   */
  function trimmedRightIndex(string) {
    var index = string.length;

    while (index-- && isSpace(string.charCodeAt(index))) {}
    return index;
  }

  /**
   * Used by `_.unescape` to convert HTML entities to characters.
   *
   * @private
   * @param {string} chr The matched character to unescape.
   * @returns {string} Returns the unescaped character.
   */
  function unescapeHtmlChar(chr) {
    return htmlUnescapes[chr];
  }

  /*--------------------------------------------------------------------------*/

  /**
   * Create a new pristine `lodash` function using the given `context` object.
   *
   * @static
   * @memberOf _
   * @category Utility
   * @param {Object} [context=root] The context object.
   * @returns {Function} Returns a new `lodash` function.
   * @example
   *
   * _.mixin({ 'foo': _.constant('foo') });
   *
   * var lodash = _.runInContext();
   * lodash.mixin({ 'bar': lodash.constant('bar') });
   *
   * _.isFunction(_.foo);
   * // => true
   * _.isFunction(_.bar);
   * // => false
   *
   * lodash.isFunction(lodash.foo);
   * // => false
   * lodash.isFunction(lodash.bar);
   * // => true
   *
   * // using `context` to mock `Date#getTime` use in `_.now`
   * var mock = _.runInContext({
   *   'Date': function() {
   *     return { 'getTime': getTimeMock };
   *   }
   * });
   *
   * // or creating a suped-up `defer` in Node.js
   * var defer = _.runInContext({ 'setTimeout': setImmediate }).defer;
   */
  function runInContext(context) {
    // Avoid issues with some ES3 environments that attempt to use values, named
    // after built-in constructors like `Object`, for the creation of literals.
    // ES5 clears this up by stating that literals must use built-in constructors.
    // See https://es5.github.io/#x11.1.5 for more details.
    context = context ? _.defaults(root.Object(), context, _.pick(root, contextProps)) : root;

    /** Native constructor references. */
    var Array = context.Array,
        Date = context.Date,
        Error = context.Error,
        Function = context.Function,
        Math = context.Math,
        Number = context.Number,
        Object = context.Object,
        RegExp = context.RegExp,
        String = context.String,
        TypeError = context.TypeError;

    /** Used for native method references. */
    var arrayProto = Array.prototype,
        objectProto = Object.prototype,
        stringProto = String.prototype;

    /** Used to resolve the decompiled source of functions. */
    var fnToString = Function.prototype.toString;

    /** Used to check objects for own properties. */
    var hasOwnProperty = objectProto.hasOwnProperty;

    /** Used to generate unique IDs. */
    var idCounter = 0;

    /**
     * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
     * of values.
     */
    var objToString = objectProto.toString;

    /** Used to restore the original `_` reference in `_.noConflict`. */
    var oldDash = root._;

    /** Used to detect if a method is native. */
    var reIsNative = RegExp('^' +
      fnToString.call(hasOwnProperty).replace(/[\\^$.*+?()[\]{}|]/g, '\\$&')
      .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
    );

    /** Native method references. */
    var ArrayBuffer = context.ArrayBuffer,
        clearTimeout = context.clearTimeout,
        parseFloat = context.parseFloat,
        pow = Math.pow,
        propertyIsEnumerable = objectProto.propertyIsEnumerable,
        Set = getNative(context, 'Set'),
        setTimeout = context.setTimeout,
        splice = arrayProto.splice,
        Uint8Array = context.Uint8Array,
        WeakMap = getNative(context, 'WeakMap');

    /* Native method references for those with the same name as other `lodash` methods. */
    var nativeCeil = Math.ceil,
        nativeCreate = getNative(Object, 'create'),
        nativeFloor = Math.floor,
        nativeIsArray = getNative(Array, 'isArray'),
        nativeIsFinite = context.isFinite,
        nativeKeys = getNative(Object, 'keys'),
        nativeMax = Math.max,
        nativeMin = Math.min,
        nativeNow = getNative(Date, 'now'),
        nativeParseInt = context.parseInt,
        nativeRandom = Math.random;

    /** Used as references for `-Infinity` and `Infinity`. */
    var NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY,
        POSITIVE_INFINITY = Number.POSITIVE_INFINITY;

    /** Used as references for the maximum length and index of an array. */
    var MAX_ARRAY_LENGTH = 4294967295,
        MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1,
        HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;

    /**
     * Used as the [maximum length](http://ecma-international.org/ecma-262/6.0/#sec-number.max_safe_integer)
     * of an array-like value.
     */
    var MAX_SAFE_INTEGER = 9007199254740991;

    /** Used to store function metadata. */
    var metaMap = WeakMap && new WeakMap;

    /** Used to lookup unminified function names. */
    var realNames = {};

    /*------------------------------------------------------------------------*/

    /**
     * Creates a `lodash` object which wraps `value` to enable implicit chaining.
     * Methods that operate on and return arrays, collections, and functions can
     * be chained together. Methods that retrieve a single value or may return a
     * primitive value will automatically end the chain returning the unwrapped
     * value. Explicit chaining may be enabled using `_.chain`. The execution of
     * chained methods is lazy, that is, execution is deferred until `_#value`
     * is implicitly or explicitly called.
     *
     * Lazy evaluation allows several methods to support shortcut fusion. Shortcut
     * fusion is an optimization strategy which merge iteratee calls; this can help
     * to avoid the creation of intermediate data structures and greatly reduce the
     * number of iteratee executions.
     *
     * Chaining is supported in custom builds as long as the `_#value` method is
     * directly or indirectly included in the build.
     *
     * In addition to lodash methods, wrappers have `Array` and `String` methods.
     *
     * The wrapper `Array` methods are:
     * `concat`, `join`, `pop`, `push`, `reverse`, `shift`, `slice`, `sort`,
     * `splice`, and `unshift`
     *
     * The wrapper `String` methods are:
     * `replace` and `split`
     *
     * The wrapper methods that support shortcut fusion are:
     * `compact`, `drop`, `dropRight`, `dropRightWhile`, `dropWhile`, `filter`,
     * `first`, `initial`, `last`, `map`, `pluck`, `reject`, `rest`, `reverse`,
     * `slice`, `take`, `takeRight`, `takeRightWhile`, `takeWhile`, `toArray`,
     * and `where`
     *
     * The chainable wrapper methods are:
     * `after`, `ary`, `assign`, `at`, `before`, `bind`, `bindAll`, `bindKey`,
     * `callback`, `chain`, `chunk`, `commit`, `compact`, `concat`, `constant`,
     * `countBy`, `create`, `curry`, `debounce`, `defaults`, `defaultsDeep`,
     * `defer`, `delay`, `difference`, `drop`, `dropRight`, `dropRightWhile`,
     * `dropWhile`, `fill`, `filter`, `flatten`, `flattenDeep`, `flow`, `flowRight`,
     * `forEach`, `forEachRight`, `forIn`, `forInRight`, `forOwn`, `forOwnRight`,
     * `functions`, `groupBy`, `indexBy`, `initial`, `intersection`, `invert`,
     * `invoke`, `keys`, `keysIn`, `map`, `mapKeys`, `mapValues`, `matches`,
     * `matchesProperty`, `memoize`, `merge`, `method`, `methodOf`, `mixin`,
     * `modArgs`, `negate`, `omit`, `once`, `pairs`, `partial`, `partialRight`,
     * `partition`, `pick`, `plant`, `pluck`, `property`, `propertyOf`, `pull`,
     * `pullAt`, `push`, `range`, `rearg`, `reject`, `remove`, `rest`, `restParam`,
     * `reverse`, `set`, `shuffle`, `slice`, `sort`, `sortBy`, `sortByAll`,
     * `sortByOrder`, `splice`, `spread`, `take`, `takeRight`, `takeRightWhile`,
     * `takeWhile`, `tap`, `throttle`, `thru`, `times`, `toArray`, `toPlainObject`,
     * `transform`, `union`, `uniq`, `unshift`, `unzip`, `unzipWith`, `values`,
     * `valuesIn`, `where`, `without`, `wrap`, `xor`, `zip`, `zipObject`, `zipWith`
     *
     * The wrapper methods that are **not** chainable by default are:
     * `add`, `attempt`, `camelCase`, `capitalize`, `ceil`, `clone`, `cloneDeep`,
     * `deburr`, `endsWith`, `escape`, `escapeRegExp`, `every`, `find`, `findIndex`,
     * `findKey`, `findLast`, `findLastIndex`, `findLastKey`, `findWhere`, `first`,
     * `floor`, `get`, `gt`, `gte`, `has`, `identity`, `includes`, `indexOf`,
     * `inRange`, `isArguments`, `isArray`, `isBoolean`, `isDate`, `isElement`,
     * `isEmpty`, `isEqual`, `isError`, `isFinite` `isFunction`, `isMatch`,
     * `isNative`, `isNaN`, `isNull`, `isNumber`, `isObject`, `isPlainObject`,
     * `isRegExp`, `isString`, `isUndefined`, `isTypedArray`, `join`, `kebabCase`,
     * `last`, `lastIndexOf`, `lt`, `lte`, `max`, `min`, `noConflict`, `noop`,
     * `now`, `pad`, `padLeft`, `padRight`, `parseInt`, `pop`, `random`, `reduce`,
     * `reduceRight`, `repeat`, `result`, `round`, `runInContext`, `shift`, `size`,
     * `snakeCase`, `some`, `sortedIndex`, `sortedLastIndex`, `startCase`,
     * `startsWith`, `sum`, `template`, `trim`, `trimLeft`, `trimRight`, `trunc`,
     * `unescape`, `uniqueId`, `value`, and `words`
     *
     * The wrapper method `sample` will return a wrapped value when `n` is provided,
     * otherwise an unwrapped value is returned.
     *
     * @name _
     * @constructor
     * @category Chain
     * @param {*} value The value to wrap in a `lodash` instance.
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var wrapped = _([1, 2, 3]);
     *
     * // returns an unwrapped value
     * wrapped.reduce(function(total, n) {
     *   return total + n;
     * });
     * // => 6
     *
     * // returns a wrapped value
     * var squares = wrapped.map(function(n) {
     *   return n * n;
     * });
     *
     * _.isArray(squares);
     * // => false
     *
     * _.isArray(squares.value());
     * // => true
     */
    function lodash(value) {
      if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
        if (value instanceof LodashWrapper) {
          return value;
        }
        if (hasOwnProperty.call(value, '__chain__') && hasOwnProperty.call(value, '__wrapped__')) {
          return wrapperClone(value);
        }
      }
      return new LodashWrapper(value);
    }

    /**
     * The function whose prototype all chaining wrappers inherit from.
     *
     * @private
     */
    function baseLodash() {
      // No operation performed.
    }

    /**
     * The base constructor for creating `lodash` wrapper objects.
     *
     * @private
     * @param {*} value The value to wrap.
     * @param {boolean} [chainAll] Enable chaining for all wrapper methods.
     * @param {Array} [actions=[]] Actions to peform to resolve the unwrapped value.
     */
    function LodashWrapper(value, chainAll, actions) {
      this.__wrapped__ = value;
      this.__actions__ = actions || [];
      this.__chain__ = !!chainAll;
    }

    /**
     * An object environment feature flags.
     *
     * @static
     * @memberOf _
     * @type Object
     */
    var support = lodash.support = {};

    /**
     * By default, the template delimiters used by lodash are like those in
     * embedded Ruby (ERB). Change the following template settings to use
     * alternative delimiters.
     *
     * @static
     * @memberOf _
     * @type Object
     */
    lodash.templateSettings = {

      /**
       * Used to detect `data` property values to be HTML-escaped.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'escape': reEscape,

      /**
       * Used to detect code to be evaluated.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'evaluate': reEvaluate,

      /**
       * Used to detect `data` property values to inject.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'interpolate': reInterpolate,

      /**
       * Used to reference the data object in the template text.
       *
       * @memberOf _.templateSettings
       * @type string
       */
      'variable': '',

      /**
       * Used to import variables into the compiled template.
       *
       * @memberOf _.templateSettings
       * @type Object
       */
      'imports': {

        /**
         * A reference to the `lodash` function.
         *
         * @memberOf _.templateSettings.imports
         * @type Function
         */
        '_': lodash
      }
    };

    /*------------------------------------------------------------------------*/

    /**
     * Creates a lazy wrapper object which wraps `value` to enable lazy evaluation.
     *
     * @private
     * @param {*} value The value to wrap.
     */
    function LazyWrapper(value) {
      this.__wrapped__ = value;
      this.__actions__ = [];
      this.__dir__ = 1;
      this.__filtered__ = false;
      this.__iteratees__ = [];
      this.__takeCount__ = POSITIVE_INFINITY;
      this.__views__ = [];
    }

    /**
     * Creates a clone of the lazy wrapper object.
     *
     * @private
     * @name clone
     * @memberOf LazyWrapper
     * @returns {Object} Returns the cloned `LazyWrapper` object.
     */
    function lazyClone() {
      var result = new LazyWrapper(this.__wrapped__);
      result.__actions__ = arrayCopy(this.__actions__);
      result.__dir__ = this.__dir__;
      result.__filtered__ = this.__filtered__;
      result.__iteratees__ = arrayCopy(this.__iteratees__);
      result.__takeCount__ = this.__takeCount__;
      result.__views__ = arrayCopy(this.__views__);
      return result;
    }

    /**
     * Reverses the direction of lazy iteration.
     *
     * @private
     * @name reverse
     * @memberOf LazyWrapper
     * @returns {Object} Returns the new reversed `LazyWrapper` object.
     */
    function lazyReverse() {
      if (this.__filtered__) {
        var result = new LazyWrapper(this);
        result.__dir__ = -1;
        result.__filtered__ = true;
      } else {
        result = this.clone();
        result.__dir__ *= -1;
      }
      return result;
    }

    /**
     * Extracts the unwrapped value from its lazy wrapper.
     *
     * @private
     * @name value
     * @memberOf LazyWrapper
     * @returns {*} Returns the unwrapped value.
     */
    function lazyValue() {
      var array = this.__wrapped__.value(),
          dir = this.__dir__,
          isArr = isArray(array),
          isRight = dir < 0,
          arrLength = isArr ? array.length : 0,
          view = getView(0, arrLength, this.__views__),
          start = view.start,
          end = view.end,
          length = end - start,
          index = isRight ? end : (start - 1),
          iteratees = this.__iteratees__,
          iterLength = iteratees.length,
          resIndex = 0,
          takeCount = nativeMin(length, this.__takeCount__);

      if (!isArr || arrLength < LARGE_ARRAY_SIZE || (arrLength == length && takeCount == length)) {
        return baseWrapperValue((isRight && isArr) ? array.reverse() : array, this.__actions__);
      }
      var result = [];

      outer:
      while (length-- && resIndex < takeCount) {
        index += dir;

        var iterIndex = -1,
            value = array[index];

        while (++iterIndex < iterLength) {
          var data = iteratees[iterIndex],
              iteratee = data.iteratee,
              type = data.type,
              computed = iteratee(value);

          if (type == LAZY_MAP_FLAG) {
            value = computed;
          } else if (!computed) {
            if (type == LAZY_FILTER_FLAG) {
              continue outer;
            } else {
              break outer;
            }
          }
        }
        result[resIndex++] = value;
      }
      return result;
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates a cache object to store key/value pairs.
     *
     * @private
     * @static
     * @name Cache
     * @memberOf _.memoize
     */
    function MapCache() {
      this.__data__ = {};
    }

    /**
     * Removes `key` and its value from the cache.
     *
     * @private
     * @name delete
     * @memberOf _.memoize.Cache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed successfully, else `false`.
     */
    function mapDelete(key) {
      return this.has(key) && delete this.__data__[key];
    }

    /**
     * Gets the cached value for `key`.
     *
     * @private
     * @name get
     * @memberOf _.memoize.Cache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the cached value.
     */
    function mapGet(key) {
      return key == '__proto__' ? undefined : this.__data__[key];
    }

    /**
     * Checks if a cached value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf _.memoize.Cache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function mapHas(key) {
      return key != '__proto__' && hasOwnProperty.call(this.__data__, key);
    }

    /**
     * Sets `value` to `key` of the cache.
     *
     * @private
     * @name set
     * @memberOf _.memoize.Cache
     * @param {string} key The key of the value to cache.
     * @param {*} value The value to cache.
     * @returns {Object} Returns the cache object.
     */
    function mapSet(key, value) {
      if (key != '__proto__') {
        this.__data__[key] = value;
      }
      return this;
    }

    /*------------------------------------------------------------------------*/

    /**
     *
     * Creates a cache object to store unique values.
     *
     * @private
     * @param {Array} [values] The values to cache.
     */
    function SetCache(values) {
      var length = values ? values.length : 0;

      this.data = { 'hash': nativeCreate(null), 'set': new Set };
      while (length--) {
        this.push(values[length]);
      }
    }

    /**
     * Checks if `value` is in `cache` mimicking the return signature of
     * `_.indexOf` by returning `0` if the value is found, else `-1`.
     *
     * @private
     * @param {Object} cache The cache to search.
     * @param {*} value The value to search for.
     * @returns {number} Returns `0` if `value` is found, else `-1`.
     */
    function cacheIndexOf(cache, value) {
      var data = cache.data,
          result = (typeof value == 'string' || isObject(value)) ? data.set.has(value) : data.hash[value];

      return result ? 0 : -1;
    }

    /**
     * Adds `value` to the cache.
     *
     * @private
     * @name push
     * @memberOf SetCache
     * @param {*} value The value to cache.
     */
    function cachePush(value) {
      var data = this.data;
      if (typeof value == 'string' || isObject(value)) {
        data.set.add(value);
      } else {
        data.hash[value] = true;
      }
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates a new array joining `array` with `other`.
     *
     * @private
     * @param {Array} array The array to join.
     * @param {Array} other The other array to join.
     * @returns {Array} Returns the new concatenated array.
     */
    function arrayConcat(array, other) {
      var index = -1,
          length = array.length,
          othIndex = -1,
          othLength = other.length,
          result = Array(length + othLength);

      while (++index < length) {
        result[index] = array[index];
      }
      while (++othIndex < othLength) {
        result[index++] = other[othIndex];
      }
      return result;
    }

    /**
     * Copies the values of `source` to `array`.
     *
     * @private
     * @param {Array} source The array to copy values from.
     * @param {Array} [array=[]] The array to copy values to.
     * @returns {Array} Returns `array`.
     */
    function arrayCopy(source, array) {
      var index = -1,
          length = source.length;

      array || (array = Array(length));
      while (++index < length) {
        array[index] = source[index];
      }
      return array;
    }

    /**
     * A specialized version of `_.forEach` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns `array`.
     */
    function arrayEach(array, iteratee) {
      var index = -1,
          length = array.length;

      while (++index < length) {
        if (iteratee(array[index], index, array) === false) {
          break;
        }
      }
      return array;
    }

    /**
     * A specialized version of `_.forEachRight` for arrays without support for
     * callback shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns `array`.
     */
    function arrayEachRight(array, iteratee) {
      var length = array.length;

      while (length--) {
        if (iteratee(array[length], length, array) === false) {
          break;
        }
      }
      return array;
    }

    /**
     * A specialized version of `_.every` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if all elements pass the predicate check,
     *  else `false`.
     */
    function arrayEvery(array, predicate) {
      var index = -1,
          length = array.length;

      while (++index < length) {
        if (!predicate(array[index], index, array)) {
          return false;
        }
      }
      return true;
    }

    /**
     * A specialized version of `baseExtremum` for arrays which invokes `iteratee`
     * with one argument: (value).
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {Function} comparator The function used to compare values.
     * @param {*} exValue The initial extremum value.
     * @returns {*} Returns the extremum value.
     */
    function arrayExtremum(array, iteratee, comparator, exValue) {
      var index = -1,
          length = array.length,
          computed = exValue,
          result = computed;

      while (++index < length) {
        var value = array[index],
            current = +iteratee(value);

        if (comparator(current, computed)) {
          computed = current;
          result = value;
        }
      }
      return result;
    }

    /**
     * A specialized version of `_.filter` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     */
    function arrayFilter(array, predicate) {
      var index = -1,
          length = array.length,
          resIndex = -1,
          result = [];

      while (++index < length) {
        var value = array[index];
        if (predicate(value, index, array)) {
          result[++resIndex] = value;
        }
      }
      return result;
    }

    /**
     * A specialized version of `_.map` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     */
    function arrayMap(array, iteratee) {
      var index = -1,
          length = array.length,
          result = Array(length);

      while (++index < length) {
        result[index] = iteratee(array[index], index, array);
      }
      return result;
    }

    /**
     * Appends the elements of `values` to `array`.
     *
     * @private
     * @param {Array} array The array to modify.
     * @param {Array} values The values to append.
     * @returns {Array} Returns `array`.
     */
    function arrayPush(array, values) {
      var index = -1,
          length = values.length,
          offset = array.length;

      while (++index < length) {
        array[offset + index] = values[index];
      }
      return array;
    }

    /**
     * A specialized version of `_.reduce` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {boolean} [initFromArray] Specify using the first element of `array`
     *  as the initial value.
     * @returns {*} Returns the accumulated value.
     */
    function arrayReduce(array, iteratee, accumulator, initFromArray) {
      var index = -1,
          length = array.length;

      if (initFromArray && length) {
        accumulator = array[++index];
      }
      while (++index < length) {
        accumulator = iteratee(accumulator, array[index], index, array);
      }
      return accumulator;
    }

    /**
     * A specialized version of `_.reduceRight` for arrays without support for
     * callback shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {boolean} [initFromArray] Specify using the last element of `array`
     *  as the initial value.
     * @returns {*} Returns the accumulated value.
     */
    function arrayReduceRight(array, iteratee, accumulator, initFromArray) {
      var length = array.length;
      if (initFromArray && length) {
        accumulator = array[--length];
      }
      while (length--) {
        accumulator = iteratee(accumulator, array[length], length, array);
      }
      return accumulator;
    }

    /**
     * A specialized version of `_.some` for arrays without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     */
    function arraySome(array, predicate) {
      var index = -1,
          length = array.length;

      while (++index < length) {
        if (predicate(array[index], index, array)) {
          return true;
        }
      }
      return false;
    }

    /**
     * A specialized version of `_.sum` for arrays without support for callback
     * shorthands and `this` binding..
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {number} Returns the sum.
     */
    function arraySum(array, iteratee) {
      var length = array.length,
          result = 0;

      while (length--) {
        result += +iteratee(array[length]) || 0;
      }
      return result;
    }

    /**
     * Used by `_.defaults` to customize its `_.assign` use.
     *
     * @private
     * @param {*} objectValue The destination object property value.
     * @param {*} sourceValue The source object property value.
     * @returns {*} Returns the value to assign to the destination object.
     */
    function assignDefaults(objectValue, sourceValue) {
      return objectValue === undefined ? sourceValue : objectValue;
    }

    /**
     * Used by `_.template` to customize its `_.assign` use.
     *
     * **Note:** This function is like `assignDefaults` except that it ignores
     * inherited property values when checking if a property is `undefined`.
     *
     * @private
     * @param {*} objectValue The destination object property value.
     * @param {*} sourceValue The source object property value.
     * @param {string} key The key associated with the object and source values.
     * @param {Object} object The destination object.
     * @returns {*} Returns the value to assign to the destination object.
     */
    function assignOwnDefaults(objectValue, sourceValue, key, object) {
      return (objectValue === undefined || !hasOwnProperty.call(object, key))
        ? sourceValue
        : objectValue;
    }

    /**
     * A specialized version of `_.assign` for customizing assigned values without
     * support for argument juggling, multiple sources, and `this` binding `customizer`
     * functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {Function} customizer The function to customize assigned values.
     * @returns {Object} Returns `object`.
     */
    function assignWith(object, source, customizer) {
      var index = -1,
          props = keys(source),
          length = props.length;

      while (++index < length) {
        var key = props[index],
            value = object[key],
            result = customizer(value, source[key], key, object, source);

        if ((result === result ? (result !== value) : (value === value)) ||
            (value === undefined && !(key in object))) {
          object[key] = result;
        }
      }
      return object;
    }

    /**
     * The base implementation of `_.assign` without support for argument juggling,
     * multiple sources, and `customizer` functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @returns {Object} Returns `object`.
     */
    function baseAssign(object, source) {
      return source == null
        ? object
        : baseCopy(source, keys(source), object);
    }

    /**
     * The base implementation of `_.at` without support for string collections
     * and individual key arguments.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {number[]|string[]} props The property names or indexes of elements to pick.
     * @returns {Array} Returns the new array of picked elements.
     */
    function baseAt(collection, props) {
      var index = -1,
          isNil = collection == null,
          isArr = !isNil && isArrayLike(collection),
          length = isArr ? collection.length : 0,
          propsLength = props.length,
          result = Array(propsLength);

      while(++index < propsLength) {
        var key = props[index];
        if (isArr) {
          result[index] = isIndex(key, length) ? collection[key] : undefined;
        } else {
          result[index] = isNil ? undefined : collection[key];
        }
      }
      return result;
    }

    /**
     * Copies properties of `source` to `object`.
     *
     * @private
     * @param {Object} source The object to copy properties from.
     * @param {Array} props The property names to copy.
     * @param {Object} [object={}] The object to copy properties to.
     * @returns {Object} Returns `object`.
     */
    function baseCopy(source, props, object) {
      object || (object = {});

      var index = -1,
          length = props.length;

      while (++index < length) {
        var key = props[index];
        object[key] = source[key];
      }
      return object;
    }

    /**
     * The base implementation of `_.callback` which supports specifying the
     * number of arguments to provide to `func`.
     *
     * @private
     * @param {*} [func=_.identity] The value to convert to a callback.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {number} [argCount] The number of arguments to provide to `func`.
     * @returns {Function} Returns the callback.
     */
    function baseCallback(func, thisArg, argCount) {
      var type = typeof func;
      if (type == 'function') {
        return thisArg === undefined
          ? func
          : bindCallback(func, thisArg, argCount);
      }
      if (func == null) {
        return identity;
      }
      if (type == 'object') {
        return baseMatches(func);
      }
      return thisArg === undefined
        ? property(func)
        : baseMatchesProperty(func, thisArg);
    }

    /**
     * The base implementation of `_.clone` without support for argument juggling
     * and `this` binding `customizer` functions.
     *
     * @private
     * @param {*} value The value to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @param {Function} [customizer] The function to customize cloning values.
     * @param {string} [key] The key of `value`.
     * @param {Object} [object] The object `value` belongs to.
     * @param {Array} [stackA=[]] Tracks traversed source objects.
     * @param {Array} [stackB=[]] Associates clones with source counterparts.
     * @returns {*} Returns the cloned value.
     */
    function baseClone(value, isDeep, customizer, key, object, stackA, stackB) {
      var result;
      if (customizer) {
        result = object ? customizer(value, key, object) : customizer(value);
      }
      if (result !== undefined) {
        return result;
      }
      if (!isObject(value)) {
        return value;
      }
      var isArr = isArray(value);
      if (isArr) {
        result = initCloneArray(value);
        if (!isDeep) {
          return arrayCopy(value, result);
        }
      } else {
        var tag = objToString.call(value),
            isFunc = tag == funcTag;

        if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
          result = initCloneObject(isFunc ? {} : value);
          if (!isDeep) {
            return baseAssign(result, value);
          }
        } else {
          return cloneableTags[tag]
            ? initCloneByTag(value, tag, isDeep)
            : (object ? value : {});
        }
      }
      // Check for circular references and return its corresponding clone.
      stackA || (stackA = []);
      stackB || (stackB = []);

      var length = stackA.length;
      while (length--) {
        if (stackA[length] == value) {
          return stackB[length];
        }
      }
      // Add the source value to the stack of traversed objects and associate it with its clone.
      stackA.push(value);
      stackB.push(result);

      // Recursively populate clone (susceptible to call stack limits).
      (isArr ? arrayEach : baseForOwn)(value, function(subValue, key) {
        result[key] = baseClone(subValue, isDeep, customizer, key, value, stackA, stackB);
      });
      return result;
    }

    /**
     * The base implementation of `_.create` without support for assigning
     * properties to the created object.
     *
     * @private
     * @param {Object} prototype The object to inherit from.
     * @returns {Object} Returns the new object.
     */
    var baseCreate = (function() {
      function object() {}
      return function(prototype) {
        if (isObject(prototype)) {
          object.prototype = prototype;
          var result = new object;
          object.prototype = undefined;
        }
        return result || {};
      };
    }());

    /**
     * The base implementation of `_.delay` and `_.defer` which accepts an index
     * of where to slice the arguments to provide to `func`.
     *
     * @private
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay invocation.
     * @param {Object} args The arguments provide to `func`.
     * @returns {number} Returns the timer id.
     */
    function baseDelay(func, wait, args) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      return setTimeout(function() { func.apply(undefined, args); }, wait);
    }

    /**
     * The base implementation of `_.difference` which accepts a single array
     * of values to exclude.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Array} values The values to exclude.
     * @returns {Array} Returns the new array of filtered values.
     */
    function baseDifference(array, values) {
      var length = array ? array.length : 0,
          result = [];

      if (!length) {
        return result;
      }
      var index = -1,
          indexOf = getIndexOf(),
          isCommon = indexOf == baseIndexOf,
          cache = (isCommon && values.length >= LARGE_ARRAY_SIZE) ? createCache(values) : null,
          valuesLength = values.length;

      if (cache) {
        indexOf = cacheIndexOf;
        isCommon = false;
        values = cache;
      }
      outer:
      while (++index < length) {
        var value = array[index];

        if (isCommon && value === value) {
          var valuesIndex = valuesLength;
          while (valuesIndex--) {
            if (values[valuesIndex] === value) {
              continue outer;
            }
          }
          result.push(value);
        }
        else if (indexOf(values, value, 0) < 0) {
          result.push(value);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.forEach` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array|Object|string} Returns `collection`.
     */
    var baseEach = createBaseEach(baseForOwn);

    /**
     * The base implementation of `_.forEachRight` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array|Object|string} Returns `collection`.
     */
    var baseEachRight = createBaseEach(baseForOwnRight, true);

    /**
     * The base implementation of `_.every` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if all elements pass the predicate check,
     *  else `false`
     */
    function baseEvery(collection, predicate) {
      var result = true;
      baseEach(collection, function(value, index, collection) {
        result = !!predicate(value, index, collection);
        return result;
      });
      return result;
    }

    /**
     * Gets the extremum value of `collection` invoking `iteratee` for each value
     * in `collection` to generate the criterion by which the value is ranked.
     * The `iteratee` is invoked with three arguments: (value, index|key, collection).
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {Function} comparator The function used to compare values.
     * @param {*} exValue The initial extremum value.
     * @returns {*} Returns the extremum value.
     */
    function baseExtremum(collection, iteratee, comparator, exValue) {
      var computed = exValue,
          result = computed;

      baseEach(collection, function(value, index, collection) {
        var current = +iteratee(value, index, collection);
        if (comparator(current, computed) || (current === exValue && current === result)) {
          computed = current;
          result = value;
        }
      });
      return result;
    }

    /**
     * The base implementation of `_.fill` without an iteratee call guard.
     *
     * @private
     * @param {Array} array The array to fill.
     * @param {*} value The value to fill `array` with.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns `array`.
     */
    function baseFill(array, value, start, end) {
      var length = array.length;

      start = start == null ? 0 : (+start || 0);
      if (start < 0) {
        start = -start > length ? 0 : (length + start);
      }
      end = (end === undefined || end > length) ? length : (+end || 0);
      if (end < 0) {
        end += length;
      }
      length = start > end ? 0 : (end >>> 0);
      start >>>= 0;

      while (start < length) {
        array[start++] = value;
      }
      return array;
    }

    /**
     * The base implementation of `_.filter` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     */
    function baseFilter(collection, predicate) {
      var result = [];
      baseEach(collection, function(value, index, collection) {
        if (predicate(value, index, collection)) {
          result.push(value);
        }
      });
      return result;
    }

    /**
     * The base implementation of `_.find`, `_.findLast`, `_.findKey`, and `_.findLastKey`,
     * without support for callback shorthands and `this` binding, which iterates
     * over `collection` using the provided `eachFunc`.
     *
     * @private
     * @param {Array|Object|string} collection The collection to search.
     * @param {Function} predicate The function invoked per iteration.
     * @param {Function} eachFunc The function to iterate over `collection`.
     * @param {boolean} [retKey] Specify returning the key of the found element
     *  instead of the element itself.
     * @returns {*} Returns the found element or its key, else `undefined`.
     */
    function baseFind(collection, predicate, eachFunc, retKey) {
      var result;
      eachFunc(collection, function(value, key, collection) {
        if (predicate(value, key, collection)) {
          result = retKey ? key : value;
          return false;
        }
      });
      return result;
    }

    /**
     * The base implementation of `_.flatten` with added support for restricting
     * flattening and specifying the start index.
     *
     * @private
     * @param {Array} array The array to flatten.
     * @param {boolean} [isDeep] Specify a deep flatten.
     * @param {boolean} [isStrict] Restrict flattening to arrays-like objects.
     * @param {Array} [result=[]] The initial result value.
     * @returns {Array} Returns the new flattened array.
     */
    function baseFlatten(array, isDeep, isStrict, result) {
      result || (result = []);

      var index = -1,
          length = array.length;

      while (++index < length) {
        var value = array[index];
        if (isObjectLike(value) && isArrayLike(value) &&
            (isStrict || isArray(value) || isArguments(value))) {
          if (isDeep) {
            // Recursively flatten arrays (susceptible to call stack limits).
            baseFlatten(value, isDeep, isStrict, result);
          } else {
            arrayPush(result, value);
          }
        } else if (!isStrict) {
          result[result.length] = value;
        }
      }
      return result;
    }

    /**
     * The base implementation of `baseForIn` and `baseForOwn` which iterates
     * over `object` properties returned by `keysFunc` invoking `iteratee` for
     * each property. Iteratee functions may exit iteration early by explicitly
     * returning `false`.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @returns {Object} Returns `object`.
     */
    var baseFor = createBaseFor();

    /**
     * This function is like `baseFor` except that it iterates over properties
     * in the opposite order.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @returns {Object} Returns `object`.
     */
    var baseForRight = createBaseFor(true);

    /**
     * The base implementation of `_.forIn` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Object} Returns `object`.
     */
    function baseForIn(object, iteratee) {
      return baseFor(object, iteratee, keysIn);
    }

    /**
     * The base implementation of `_.forOwn` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Object} Returns `object`.
     */
    function baseForOwn(object, iteratee) {
      return baseFor(object, iteratee, keys);
    }

    /**
     * The base implementation of `_.forOwnRight` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Object} Returns `object`.
     */
    function baseForOwnRight(object, iteratee) {
      return baseForRight(object, iteratee, keys);
    }

    /**
     * The base implementation of `_.functions` which creates an array of
     * `object` function property names filtered from those provided.
     *
     * @private
     * @param {Object} object The object to inspect.
     * @param {Array} props The property names to filter.
     * @returns {Array} Returns the new array of filtered property names.
     */
    function baseFunctions(object, props) {
      var index = -1,
          length = props.length,
          resIndex = -1,
          result = [];

      while (++index < length) {
        var key = props[index];
        if (isFunction(object[key])) {
          result[++resIndex] = key;
        }
      }
      return result;
    }

    /**
     * The base implementation of `get` without support for string paths
     * and default values.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array} path The path of the property to get.
     * @param {string} [pathKey] The key representation of path.
     * @returns {*} Returns the resolved value.
     */
    function baseGet(object, path, pathKey) {
      if (object == null) {
        return;
      }
      if (pathKey !== undefined && pathKey in toObject(object)) {
        path = [pathKey];
      }
      var index = 0,
          length = path.length;

      while (object != null && index < length) {
        object = object[path[index++]];
      }
      return (index && index == length) ? object : undefined;
    }

    /**
     * The base implementation of `_.isEqual` without support for `this` binding
     * `customizer` functions.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @param {Function} [customizer] The function to customize comparing values.
     * @param {boolean} [isLoose] Specify performing partial comparisons.
     * @param {Array} [stackA] Tracks traversed `value` objects.
     * @param {Array} [stackB] Tracks traversed `other` objects.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     */
    function baseIsEqual(value, other, customizer, isLoose, stackA, stackB) {
      if (value === other) {
        return true;
      }
      if (value == null || other == null || (!isObject(value) && !isObjectLike(other))) {
        return value !== value && other !== other;
      }
      return baseIsEqualDeep(value, other, baseIsEqual, customizer, isLoose, stackA, stackB);
    }

    /**
     * A specialized version of `baseIsEqual` for arrays and objects which performs
     * deep comparisons and tracks traversed objects enabling objects with circular
     * references to be compared.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} [customizer] The function to customize comparing objects.
     * @param {boolean} [isLoose] Specify performing partial comparisons.
     * @param {Array} [stackA=[]] Tracks traversed `value` objects.
     * @param {Array} [stackB=[]] Tracks traversed `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function baseIsEqualDeep(object, other, equalFunc, customizer, isLoose, stackA, stackB) {
      var objIsArr = isArray(object),
          othIsArr = isArray(other),
          objTag = arrayTag,
          othTag = arrayTag;

      if (!objIsArr) {
        objTag = objToString.call(object);
        if (objTag == argsTag) {
          objTag = objectTag;
        } else if (objTag != objectTag) {
          objIsArr = isTypedArray(object);
        }
      }
      if (!othIsArr) {
        othTag = objToString.call(other);
        if (othTag == argsTag) {
          othTag = objectTag;
        } else if (othTag != objectTag) {
          othIsArr = isTypedArray(other);
        }
      }
      var objIsObj = objTag == objectTag,
          othIsObj = othTag == objectTag,
          isSameTag = objTag == othTag;

      if (isSameTag && !(objIsArr || objIsObj)) {
        return equalByTag(object, other, objTag);
      }
      if (!isLoose) {
        var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
            othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

        if (objIsWrapped || othIsWrapped) {
          return equalFunc(objIsWrapped ? object.value() : object, othIsWrapped ? other.value() : other, customizer, isLoose, stackA, stackB);
        }
      }
      if (!isSameTag) {
        return false;
      }
      // Assume cyclic values are equal.
      // For more information on detecting circular references see https://es5.github.io/#JO.
      stackA || (stackA = []);
      stackB || (stackB = []);

      var length = stackA.length;
      while (length--) {
        if (stackA[length] == object) {
          return stackB[length] == other;
        }
      }
      // Add `object` and `other` to the stack of traversed objects.
      stackA.push(object);
      stackB.push(other);

      var result = (objIsArr ? equalArrays : equalObjects)(object, other, equalFunc, customizer, isLoose, stackA, stackB);

      stackA.pop();
      stackB.pop();

      return result;
    }

    /**
     * The base implementation of `_.isMatch` without support for callback
     * shorthands and `this` binding.
     *
     * @private
     * @param {Object} object The object to inspect.
     * @param {Array} matchData The propery names, values, and compare flags to match.
     * @param {Function} [customizer] The function to customize comparing objects.
     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
     */
    function baseIsMatch(object, matchData, customizer) {
      var index = matchData.length,
          length = index,
          noCustomizer = !customizer;

      if (object == null) {
        return !length;
      }
      object = toObject(object);
      while (index--) {
        var data = matchData[index];
        if ((noCustomizer && data[2])
              ? data[1] !== object[data[0]]
              : !(data[0] in object)
            ) {
          return false;
        }
      }
      while (++index < length) {
        data = matchData[index];
        var key = data[0],
            objValue = object[key],
            srcValue = data[1];

        if (noCustomizer && data[2]) {
          if (objValue === undefined && !(key in object)) {
            return false;
          }
        } else {
          var result = customizer ? customizer(objValue, srcValue, key) : undefined;
          if (!(result === undefined ? baseIsEqual(srcValue, objValue, customizer, true) : result)) {
            return false;
          }
        }
      }
      return true;
    }

    /**
     * The base implementation of `_.map` without support for callback shorthands
     * and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     */
    function baseMap(collection, iteratee) {
      var index = -1,
          result = isArrayLike(collection) ? Array(collection.length) : [];

      baseEach(collection, function(value, key, collection) {
        result[++index] = iteratee(value, key, collection);
      });
      return result;
    }

    /**
     * The base implementation of `_.matches` which does not clone `source`.
     *
     * @private
     * @param {Object} source The object of property values to match.
     * @returns {Function} Returns the new function.
     */
    function baseMatches(source) {
      var matchData = getMatchData(source);
      if (matchData.length == 1 && matchData[0][2]) {
        var key = matchData[0][0],
            value = matchData[0][1];

        return function(object) {
          if (object == null) {
            return false;
          }
          return object[key] === value && (value !== undefined || (key in toObject(object)));
        };
      }
      return function(object) {
        return baseIsMatch(object, matchData);
      };
    }

    /**
     * The base implementation of `_.matchesProperty` which does not clone `srcValue`.
     *
     * @private
     * @param {string} path The path of the property to get.
     * @param {*} srcValue The value to compare.
     * @returns {Function} Returns the new function.
     */
    function baseMatchesProperty(path, srcValue) {
      var isArr = isArray(path),
          isCommon = isKey(path) && isStrictComparable(srcValue),
          pathKey = (path + '');

      path = toPath(path);
      return function(object) {
        if (object == null) {
          return false;
        }
        var key = pathKey;
        object = toObject(object);
        if ((isArr || !isCommon) && !(key in object)) {
          object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
          if (object == null) {
            return false;
          }
          key = last(path);
          object = toObject(object);
        }
        return object[key] === srcValue
          ? (srcValue !== undefined || (key in object))
          : baseIsEqual(srcValue, object[key], undefined, true);
      };
    }

    /**
     * The base implementation of `_.merge` without support for argument juggling,
     * multiple sources, and `this` binding `customizer` functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {Function} [customizer] The function to customize merged values.
     * @param {Array} [stackA=[]] Tracks traversed source objects.
     * @param {Array} [stackB=[]] Associates values with source counterparts.
     * @returns {Object} Returns `object`.
     */
    function baseMerge(object, source, customizer, stackA, stackB) {
      if (!isObject(object)) {
        return object;
      }
      var isSrcArr = isArrayLike(source) && (isArray(source) || isTypedArray(source)),
          props = isSrcArr ? undefined : keys(source);

      arrayEach(props || source, function(srcValue, key) {
        if (props) {
          key = srcValue;
          srcValue = source[key];
        }
        if (isObjectLike(srcValue)) {
          stackA || (stackA = []);
          stackB || (stackB = []);
          baseMergeDeep(object, source, key, baseMerge, customizer, stackA, stackB);
        }
        else {
          var value = object[key],
              result = customizer ? customizer(value, srcValue, key, object, source) : undefined,
              isCommon = result === undefined;

          if (isCommon) {
            result = srcValue;
          }
          if ((result !== undefined || (isSrcArr && !(key in object))) &&
              (isCommon || (result === result ? (result !== value) : (value === value)))) {
            object[key] = result;
          }
        }
      });
      return object;
    }

    /**
     * A specialized version of `baseMerge` for arrays and objects which performs
     * deep merges and tracks traversed objects enabling objects with circular
     * references to be merged.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {string} key The key of the value to merge.
     * @param {Function} mergeFunc The function to merge values.
     * @param {Function} [customizer] The function to customize merged values.
     * @param {Array} [stackA=[]] Tracks traversed source objects.
     * @param {Array} [stackB=[]] Associates values with source counterparts.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function baseMergeDeep(object, source, key, mergeFunc, customizer, stackA, stackB) {
      var length = stackA.length,
          srcValue = source[key];

      while (length--) {
        if (stackA[length] == srcValue) {
          object[key] = stackB[length];
          return;
        }
      }
      var value = object[key],
          result = customizer ? customizer(value, srcValue, key, object, source) : undefined,
          isCommon = result === undefined;

      if (isCommon) {
        result = srcValue;
        if (isArrayLike(srcValue) && (isArray(srcValue) || isTypedArray(srcValue))) {
          result = isArray(value)
            ? value
            : (isArrayLike(value) ? arrayCopy(value) : []);
        }
        else if (isPlainObject(srcValue) || isArguments(srcValue)) {
          result = isArguments(value)
            ? toPlainObject(value)
            : (isPlainObject(value) ? value : {});
        }
        else {
          isCommon = false;
        }
      }
      // Add the source value to the stack of traversed objects and associate
      // it with its merged value.
      stackA.push(srcValue);
      stackB.push(result);

      if (isCommon) {
        // Recursively merge objects and arrays (susceptible to call stack limits).
        object[key] = mergeFunc(result, srcValue, customizer, stackA, stackB);
      } else if (result === result ? (result !== value) : (value === value)) {
        object[key] = result;
      }
    }

    /**
     * The base implementation of `_.property` without support for deep paths.
     *
     * @private
     * @param {string} key The key of the property to get.
     * @returns {Function} Returns the new function.
     */
    function baseProperty(key) {
      return function(object) {
        return object == null ? undefined : object[key];
      };
    }

    /**
     * A specialized version of `baseProperty` which supports deep paths.
     *
     * @private
     * @param {Array|string} path The path of the property to get.
     * @returns {Function} Returns the new function.
     */
    function basePropertyDeep(path) {
      var pathKey = (path + '');
      path = toPath(path);
      return function(object) {
        return baseGet(object, path, pathKey);
      };
    }

    /**
     * The base implementation of `_.pullAt` without support for individual
     * index arguments and capturing the removed elements.
     *
     * @private
     * @param {Array} array The array to modify.
     * @param {number[]} indexes The indexes of elements to remove.
     * @returns {Array} Returns `array`.
     */
    function basePullAt(array, indexes) {
      var length = array ? indexes.length : 0;
      while (length--) {
        var index = indexes[length];
        if (index != previous && isIndex(index)) {
          var previous = index;
          splice.call(array, index, 1);
        }
      }
      return array;
    }

    /**
     * The base implementation of `_.random` without support for argument juggling
     * and returning floating-point numbers.
     *
     * @private
     * @param {number} min The minimum possible value.
     * @param {number} max The maximum possible value.
     * @returns {number} Returns the random number.
     */
    function baseRandom(min, max) {
      return min + nativeFloor(nativeRandom() * (max - min + 1));
    }

    /**
     * The base implementation of `_.reduce` and `_.reduceRight` without support
     * for callback shorthands and `this` binding, which iterates over `collection`
     * using the provided `eachFunc`.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {*} accumulator The initial value.
     * @param {boolean} initFromCollection Specify using the first or last element
     *  of `collection` as the initial value.
     * @param {Function} eachFunc The function to iterate over `collection`.
     * @returns {*} Returns the accumulated value.
     */
    function baseReduce(collection, iteratee, accumulator, initFromCollection, eachFunc) {
      eachFunc(collection, function(value, index, collection) {
        accumulator = initFromCollection
          ? (initFromCollection = false, value)
          : iteratee(accumulator, value, index, collection);
      });
      return accumulator;
    }

    /**
     * The base implementation of `setData` without support for hot loop detection.
     *
     * @private
     * @param {Function} func The function to associate metadata with.
     * @param {*} data The metadata.
     * @returns {Function} Returns `func`.
     */
    var baseSetData = !metaMap ? identity : function(func, data) {
      metaMap.set(func, data);
      return func;
    };

    /**
     * The base implementation of `_.slice` without an iteratee call guard.
     *
     * @private
     * @param {Array} array The array to slice.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the slice of `array`.
     */
    function baseSlice(array, start, end) {
      var index = -1,
          length = array.length;

      start = start == null ? 0 : (+start || 0);
      if (start < 0) {
        start = -start > length ? 0 : (length + start);
      }
      end = (end === undefined || end > length) ? length : (+end || 0);
      if (end < 0) {
        end += length;
      }
      length = start > end ? 0 : ((end - start) >>> 0);
      start >>>= 0;

      var result = Array(length);
      while (++index < length) {
        result[index] = array[index + start];
      }
      return result;
    }

    /**
     * The base implementation of `_.some` without support for callback shorthands
     * and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     */
    function baseSome(collection, predicate) {
      var result;

      baseEach(collection, function(value, index, collection) {
        result = predicate(value, index, collection);
        return !result;
      });
      return !!result;
    }

    /**
     * The base implementation of `_.sortBy` which uses `comparer` to define
     * the sort order of `array` and replaces criteria objects with their
     * corresponding values.
     *
     * @private
     * @param {Array} array The array to sort.
     * @param {Function} comparer The function to define sort order.
     * @returns {Array} Returns `array`.
     */
    function baseSortBy(array, comparer) {
      var length = array.length;

      array.sort(comparer);
      while (length--) {
        array[length] = array[length].value;
      }
      return array;
    }

    /**
     * The base implementation of `_.sortByOrder` without param guards.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
     * @param {boolean[]} orders The sort orders of `iteratees`.
     * @returns {Array} Returns the new sorted array.
     */
    function baseSortByOrder(collection, iteratees, orders) {
      var callback = getCallback(),
          index = -1;

      iteratees = arrayMap(iteratees, function(iteratee) { return callback(iteratee); });

      var result = baseMap(collection, function(value) {
        var criteria = arrayMap(iteratees, function(iteratee) { return iteratee(value); });
        return { 'criteria': criteria, 'index': ++index, 'value': value };
      });

      return baseSortBy(result, function(object, other) {
        return compareMultiple(object, other, orders);
      });
    }

    /**
     * The base implementation of `_.sum` without support for callback shorthands
     * and `this` binding.
     *
     * @private
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {number} Returns the sum.
     */
    function baseSum(collection, iteratee) {
      var result = 0;
      baseEach(collection, function(value, index, collection) {
        result += +iteratee(value, index, collection) || 0;
      });
      return result;
    }

    /**
     * The base implementation of `_.uniq` without support for callback shorthands
     * and `this` binding.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Function} [iteratee] The function invoked per iteration.
     * @returns {Array} Returns the new duplicate-value-free array.
     */
    function baseUniq(array, iteratee) {
      var index = -1,
          indexOf = getIndexOf(),
          length = array.length,
          isCommon = indexOf == baseIndexOf,
          isLarge = isCommon && length >= LARGE_ARRAY_SIZE,
          seen = isLarge ? createCache() : null,
          result = [];

      if (seen) {
        indexOf = cacheIndexOf;
        isCommon = false;
      } else {
        isLarge = false;
        seen = iteratee ? [] : result;
      }
      outer:
      while (++index < length) {
        var value = array[index],
            computed = iteratee ? iteratee(value, index, array) : value;

        if (isCommon && value === value) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value);
        }
        else if (indexOf(seen, computed, 0) < 0) {
          if (iteratee || isLarge) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.values` and `_.valuesIn` which creates an
     * array of `object` property values corresponding to the property names
     * of `props`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array} props The property names to get values for.
     * @returns {Object} Returns the array of property values.
     */
    function baseValues(object, props) {
      var index = -1,
          length = props.length,
          result = Array(length);

      while (++index < length) {
        result[index] = object[props[index]];
      }
      return result;
    }

    /**
     * The base implementation of `_.dropRightWhile`, `_.dropWhile`, `_.takeRightWhile`,
     * and `_.takeWhile` without support for callback shorthands and `this` binding.
     *
     * @private
     * @param {Array} array The array to query.
     * @param {Function} predicate The function invoked per iteration.
     * @param {boolean} [isDrop] Specify dropping elements instead of taking them.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Array} Returns the slice of `array`.
     */
    function baseWhile(array, predicate, isDrop, fromRight) {
      var length = array.length,
          index = fromRight ? length : -1;

      while ((fromRight ? index-- : ++index < length) && predicate(array[index], index, array)) {}
      return isDrop
        ? baseSlice(array, (fromRight ? 0 : index), (fromRight ? index + 1 : length))
        : baseSlice(array, (fromRight ? index + 1 : 0), (fromRight ? length : index));
    }

    /**
     * The base implementation of `wrapperValue` which returns the result of
     * performing a sequence of actions on the unwrapped `value`, where each
     * successive action is supplied the return value of the previous.
     *
     * @private
     * @param {*} value The unwrapped value.
     * @param {Array} actions Actions to peform to resolve the unwrapped value.
     * @returns {*} Returns the resolved value.
     */
    function baseWrapperValue(value, actions) {
      var result = value;
      if (result instanceof LazyWrapper) {
        result = result.value();
      }
      var index = -1,
          length = actions.length;

      while (++index < length) {
        var action = actions[index];
        result = action.func.apply(action.thisArg, arrayPush([result], action.args));
      }
      return result;
    }

    /**
     * Performs a binary search of `array` to determine the index at which `value`
     * should be inserted into `array` in order to maintain its sort order.
     *
     * @private
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {boolean} [retHighest] Specify returning the highest qualified index.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     */
    function binaryIndex(array, value, retHighest) {
      var low = 0,
          high = array ? array.length : low;

      if (typeof value == 'number' && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
        while (low < high) {
          var mid = (low + high) >>> 1,
              computed = array[mid];

          if ((retHighest ? (computed <= value) : (computed < value)) && computed !== null) {
            low = mid + 1;
          } else {
            high = mid;
          }
        }
        return high;
      }
      return binaryIndexBy(array, value, identity, retHighest);
    }

    /**
     * This function is like `binaryIndex` except that it invokes `iteratee` for
     * `value` and each element of `array` to compute their sort ranking. The
     * iteratee is invoked with one argument; (value).
     *
     * @private
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {boolean} [retHighest] Specify returning the highest qualified index.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     */
    function binaryIndexBy(array, value, iteratee, retHighest) {
      value = iteratee(value);

      var low = 0,
          high = array ? array.length : 0,
          valIsNaN = value !== value,
          valIsNull = value === null,
          valIsUndef = value === undefined;

      while (low < high) {
        var mid = nativeFloor((low + high) / 2),
            computed = iteratee(array[mid]),
            isDef = computed !== undefined,
            isReflexive = computed === computed;

        if (valIsNaN) {
          var setLow = isReflexive || retHighest;
        } else if (valIsNull) {
          setLow = isReflexive && isDef && (retHighest || computed != null);
        } else if (valIsUndef) {
          setLow = isReflexive && (retHighest || isDef);
        } else if (computed == null) {
          setLow = false;
        } else {
          setLow = retHighest ? (computed <= value) : (computed < value);
        }
        if (setLow) {
          low = mid + 1;
        } else {
          high = mid;
        }
      }
      return nativeMin(high, MAX_ARRAY_INDEX);
    }

    /**
     * A specialized version of `baseCallback` which only supports `this` binding
     * and specifying the number of arguments to provide to `func`.
     *
     * @private
     * @param {Function} func The function to bind.
     * @param {*} thisArg The `this` binding of `func`.
     * @param {number} [argCount] The number of arguments to provide to `func`.
     * @returns {Function} Returns the callback.
     */
    function bindCallback(func, thisArg, argCount) {
      if (typeof func != 'function') {
        return identity;
      }
      if (thisArg === undefined) {
        return func;
      }
      switch (argCount) {
        case 1: return function(value) {
          return func.call(thisArg, value);
        };
        case 3: return function(value, index, collection) {
          return func.call(thisArg, value, index, collection);
        };
        case 4: return function(accumulator, value, index, collection) {
          return func.call(thisArg, accumulator, value, index, collection);
        };
        case 5: return function(value, other, key, object, source) {
          return func.call(thisArg, value, other, key, object, source);
        };
      }
      return function() {
        return func.apply(thisArg, arguments);
      };
    }

    /**
     * Creates a clone of the given array buffer.
     *
     * @private
     * @param {ArrayBuffer} buffer The array buffer to clone.
     * @returns {ArrayBuffer} Returns the cloned array buffer.
     */
    function bufferClone(buffer) {
      var result = new ArrayBuffer(buffer.byteLength),
          view = new Uint8Array(result);

      view.set(new Uint8Array(buffer));
      return result;
    }

    /**
     * Creates an array that is the composition of partially applied arguments,
     * placeholders, and provided arguments into a single array of arguments.
     *
     * @private
     * @param {Array|Object} args The provided arguments.
     * @param {Array} partials The arguments to prepend to those provided.
     * @param {Array} holders The `partials` placeholder indexes.
     * @returns {Array} Returns the new array of composed arguments.
     */
    function composeArgs(args, partials, holders) {
      var holdersLength = holders.length,
          argsIndex = -1,
          argsLength = nativeMax(args.length - holdersLength, 0),
          leftIndex = -1,
          leftLength = partials.length,
          result = Array(leftLength + argsLength);

      while (++leftIndex < leftLength) {
        result[leftIndex] = partials[leftIndex];
      }
      while (++argsIndex < holdersLength) {
        result[holders[argsIndex]] = args[argsIndex];
      }
      while (argsLength--) {
        result[leftIndex++] = args[argsIndex++];
      }
      return result;
    }

    /**
     * This function is like `composeArgs` except that the arguments composition
     * is tailored for `_.partialRight`.
     *
     * @private
     * @param {Array|Object} args The provided arguments.
     * @param {Array} partials The arguments to append to those provided.
     * @param {Array} holders The `partials` placeholder indexes.
     * @returns {Array} Returns the new array of composed arguments.
     */
    function composeArgsRight(args, partials, holders) {
      var holdersIndex = -1,
          holdersLength = holders.length,
          argsIndex = -1,
          argsLength = nativeMax(args.length - holdersLength, 0),
          rightIndex = -1,
          rightLength = partials.length,
          result = Array(argsLength + rightLength);

      while (++argsIndex < argsLength) {
        result[argsIndex] = args[argsIndex];
      }
      var offset = argsIndex;
      while (++rightIndex < rightLength) {
        result[offset + rightIndex] = partials[rightIndex];
      }
      while (++holdersIndex < holdersLength) {
        result[offset + holders[holdersIndex]] = args[argsIndex++];
      }
      return result;
    }

    /**
     * Creates a `_.countBy`, `_.groupBy`, `_.indexBy`, or `_.partition` function.
     *
     * @private
     * @param {Function} setter The function to set keys and values of the accumulator object.
     * @param {Function} [initializer] The function to initialize the accumulator object.
     * @returns {Function} Returns the new aggregator function.
     */
    function createAggregator(setter, initializer) {
      return function(collection, iteratee, thisArg) {
        var result = initializer ? initializer() : {};
        iteratee = getCallback(iteratee, thisArg, 3);

        if (isArray(collection)) {
          var index = -1,
              length = collection.length;

          while (++index < length) {
            var value = collection[index];
            setter(result, value, iteratee(value, index, collection), collection);
          }
        } else {
          baseEach(collection, function(value, key, collection) {
            setter(result, value, iteratee(value, key, collection), collection);
          });
        }
        return result;
      };
    }

    /**
     * Creates a `_.assign`, `_.defaults`, or `_.merge` function.
     *
     * @private
     * @param {Function} assigner The function to assign values.
     * @returns {Function} Returns the new assigner function.
     */
    function createAssigner(assigner) {
      return restParam(function(object, sources) {
        var index = -1,
            length = object == null ? 0 : sources.length,
            customizer = length > 2 ? sources[length - 2] : undefined,
            guard = length > 2 ? sources[2] : undefined,
            thisArg = length > 1 ? sources[length - 1] : undefined;

        if (typeof customizer == 'function') {
          customizer = bindCallback(customizer, thisArg, 5);
          length -= 2;
        } else {
          customizer = typeof thisArg == 'function' ? thisArg : undefined;
          length -= (customizer ? 1 : 0);
        }
        if (guard && isIterateeCall(sources[0], sources[1], guard)) {
          customizer = length < 3 ? undefined : customizer;
          length = 1;
        }
        while (++index < length) {
          var source = sources[index];
          if (source) {
            assigner(object, source, customizer);
          }
        }
        return object;
      });
    }

    /**
     * Creates a `baseEach` or `baseEachRight` function.
     *
     * @private
     * @param {Function} eachFunc The function to iterate over a collection.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new base function.
     */
    function createBaseEach(eachFunc, fromRight) {
      return function(collection, iteratee) {
        var length = collection ? getLength(collection) : 0;
        if (!isLength(length)) {
          return eachFunc(collection, iteratee);
        }
        var index = fromRight ? length : -1,
            iterable = toObject(collection);

        while ((fromRight ? index-- : ++index < length)) {
          if (iteratee(iterable[index], index, iterable) === false) {
            break;
          }
        }
        return collection;
      };
    }

    /**
     * Creates a base function for `_.forIn` or `_.forInRight`.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new base function.
     */
    function createBaseFor(fromRight) {
      return function(object, iteratee, keysFunc) {
        var iterable = toObject(object),
            props = keysFunc(object),
            length = props.length,
            index = fromRight ? length : -1;

        while ((fromRight ? index-- : ++index < length)) {
          var key = props[index];
          if (iteratee(iterable[key], key, iterable) === false) {
            break;
          }
        }
        return object;
      };
    }

    /**
     * Creates a function that wraps `func` and invokes it with the `this`
     * binding of `thisArg`.
     *
     * @private
     * @param {Function} func The function to bind.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @returns {Function} Returns the new bound function.
     */
    function createBindWrapper(func, thisArg) {
      var Ctor = createCtorWrapper(func);

      function wrapper() {
        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
        return fn.apply(thisArg, arguments);
      }
      return wrapper;
    }

    /**
     * Creates a `Set` cache object to optimize linear searches of large arrays.
     *
     * @private
     * @param {Array} [values] The values to cache.
     * @returns {null|Object} Returns the new cache object if `Set` is supported, else `null`.
     */
    function createCache(values) {
      return (nativeCreate && Set) ? new SetCache(values) : null;
    }

    /**
     * Creates a function that produces compound words out of the words in a
     * given string.
     *
     * @private
     * @param {Function} callback The function to combine each word.
     * @returns {Function} Returns the new compounder function.
     */
    function createCompounder(callback) {
      return function(string) {
        var index = -1,
            array = words(deburr(string)),
            length = array.length,
            result = '';

        while (++index < length) {
          result = callback(result, array[index], index);
        }
        return result;
      };
    }

    /**
     * Creates a function that produces an instance of `Ctor` regardless of
     * whether it was invoked as part of a `new` expression or by `call` or `apply`.
     *
     * @private
     * @param {Function} Ctor The constructor to wrap.
     * @returns {Function} Returns the new wrapped function.
     */
    function createCtorWrapper(Ctor) {
      return function() {
        // Use a `switch` statement to work with class constructors.
        // See http://ecma-international.org/ecma-262/6.0/#sec-ecmascript-function-objects-call-thisargument-argumentslist
        // for more details.
        var args = arguments;
        switch (args.length) {
          case 0: return new Ctor;
          case 1: return new Ctor(args[0]);
          case 2: return new Ctor(args[0], args[1]);
          case 3: return new Ctor(args[0], args[1], args[2]);
          case 4: return new Ctor(args[0], args[1], args[2], args[3]);
          case 5: return new Ctor(args[0], args[1], args[2], args[3], args[4]);
          case 6: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
          case 7: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
        }
        var thisBinding = baseCreate(Ctor.prototype),
            result = Ctor.apply(thisBinding, args);

        // Mimic the constructor's `return` behavior.
        // See https://es5.github.io/#x13.2.2 for more details.
        return isObject(result) ? result : thisBinding;
      };
    }

    /**
     * Creates a `_.curry` or `_.curryRight` function.
     *
     * @private
     * @param {boolean} flag The curry bit flag.
     * @returns {Function} Returns the new curry function.
     */
    function createCurry(flag) {
      function curryFunc(func, arity, guard) {
        if (guard && isIterateeCall(func, arity, guard)) {
          arity = undefined;
        }
        var result = createWrapper(func, flag, undefined, undefined, undefined, undefined, undefined, arity);
        result.placeholder = curryFunc.placeholder;
        return result;
      }
      return curryFunc;
    }

    /**
     * Creates a `_.defaults` or `_.defaultsDeep` function.
     *
     * @private
     * @param {Function} assigner The function to assign values.
     * @param {Function} customizer The function to customize assigned values.
     * @returns {Function} Returns the new defaults function.
     */
    function createDefaults(assigner, customizer) {
      return restParam(function(args) {
        var object = args[0];
        if (object == null) {
          return object;
        }
        args.push(customizer);
        return assigner.apply(undefined, args);
      });
    }

    /**
     * Creates a `_.max` or `_.min` function.
     *
     * @private
     * @param {Function} comparator The function used to compare values.
     * @param {*} exValue The initial extremum value.
     * @returns {Function} Returns the new extremum function.
     */
    function createExtremum(comparator, exValue) {
      return function(collection, iteratee, thisArg) {
        if (thisArg && isIterateeCall(collection, iteratee, thisArg)) {
          iteratee = undefined;
        }
        iteratee = getCallback(iteratee, thisArg, 3);
        if (iteratee.length == 1) {
          collection = isArray(collection) ? collection : toIterable(collection);
          var result = arrayExtremum(collection, iteratee, comparator, exValue);
          if (!(collection.length && result === exValue)) {
            return result;
          }
        }
        return baseExtremum(collection, iteratee, comparator, exValue);
      };
    }

    /**
     * Creates a `_.find` or `_.findLast` function.
     *
     * @private
     * @param {Function} eachFunc The function to iterate over a collection.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new find function.
     */
    function createFind(eachFunc, fromRight) {
      return function(collection, predicate, thisArg) {
        predicate = getCallback(predicate, thisArg, 3);
        if (isArray(collection)) {
          var index = baseFindIndex(collection, predicate, fromRight);
          return index > -1 ? collection[index] : undefined;
        }
        return baseFind(collection, predicate, eachFunc);
      };
    }

    /**
     * Creates a `_.findIndex` or `_.findLastIndex` function.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new find function.
     */
    function createFindIndex(fromRight) {
      return function(array, predicate, thisArg) {
        if (!(array && array.length)) {
          return -1;
        }
        predicate = getCallback(predicate, thisArg, 3);
        return baseFindIndex(array, predicate, fromRight);
      };
    }

    /**
     * Creates a `_.findKey` or `_.findLastKey` function.
     *
     * @private
     * @param {Function} objectFunc The function to iterate over an object.
     * @returns {Function} Returns the new find function.
     */
    function createFindKey(objectFunc) {
      return function(object, predicate, thisArg) {
        predicate = getCallback(predicate, thisArg, 3);
        return baseFind(object, predicate, objectFunc, true);
      };
    }

    /**
     * Creates a `_.flow` or `_.flowRight` function.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new flow function.
     */
    function createFlow(fromRight) {
      return function() {
        var wrapper,
            length = arguments.length,
            index = fromRight ? length : -1,
            leftIndex = 0,
            funcs = Array(length);

        while ((fromRight ? index-- : ++index < length)) {
          var func = funcs[leftIndex++] = arguments[index];
          if (typeof func != 'function') {
            throw new TypeError(FUNC_ERROR_TEXT);
          }
          if (!wrapper && LodashWrapper.prototype.thru && getFuncName(func) == 'wrapper') {
            wrapper = new LodashWrapper([], true);
          }
        }
        index = wrapper ? -1 : length;
        while (++index < length) {
          func = funcs[index];

          var funcName = getFuncName(func),
              data = funcName == 'wrapper' ? getData(func) : undefined;

          if (data && isLaziable(data[0]) && data[1] == (ARY_FLAG | CURRY_FLAG | PARTIAL_FLAG | REARG_FLAG) && !data[4].length && data[9] == 1) {
            wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
          } else {
            wrapper = (func.length == 1 && isLaziable(func)) ? wrapper[funcName]() : wrapper.thru(func);
          }
        }
        return function() {
          var args = arguments,
              value = args[0];

          if (wrapper && args.length == 1 && isArray(value) && value.length >= LARGE_ARRAY_SIZE) {
            return wrapper.plant(value).value();
          }
          var index = 0,
              result = length ? funcs[index].apply(this, args) : value;

          while (++index < length) {
            result = funcs[index].call(this, result);
          }
          return result;
        };
      };
    }

    /**
     * Creates a function for `_.forEach` or `_.forEachRight`.
     *
     * @private
     * @param {Function} arrayFunc The function to iterate over an array.
     * @param {Function} eachFunc The function to iterate over a collection.
     * @returns {Function} Returns the new each function.
     */
    function createForEach(arrayFunc, eachFunc) {
      return function(collection, iteratee, thisArg) {
        return (typeof iteratee == 'function' && thisArg === undefined && isArray(collection))
          ? arrayFunc(collection, iteratee)
          : eachFunc(collection, bindCallback(iteratee, thisArg, 3));
      };
    }

    /**
     * Creates a function for `_.forIn` or `_.forInRight`.
     *
     * @private
     * @param {Function} objectFunc The function to iterate over an object.
     * @returns {Function} Returns the new each function.
     */
    function createForIn(objectFunc) {
      return function(object, iteratee, thisArg) {
        if (typeof iteratee != 'function' || thisArg !== undefined) {
          iteratee = bindCallback(iteratee, thisArg, 3);
        }
        return objectFunc(object, iteratee, keysIn);
      };
    }

    /**
     * Creates a function for `_.forOwn` or `_.forOwnRight`.
     *
     * @private
     * @param {Function} objectFunc The function to iterate over an object.
     * @returns {Function} Returns the new each function.
     */
    function createForOwn(objectFunc) {
      return function(object, iteratee, thisArg) {
        if (typeof iteratee != 'function' || thisArg !== undefined) {
          iteratee = bindCallback(iteratee, thisArg, 3);
        }
        return objectFunc(object, iteratee);
      };
    }

    /**
     * Creates a function for `_.mapKeys` or `_.mapValues`.
     *
     * @private
     * @param {boolean} [isMapKeys] Specify mapping keys instead of values.
     * @returns {Function} Returns the new map function.
     */
    function createObjectMapper(isMapKeys) {
      return function(object, iteratee, thisArg) {
        var result = {};
        iteratee = getCallback(iteratee, thisArg, 3);

        baseForOwn(object, function(value, key, object) {
          var mapped = iteratee(value, key, object);
          key = isMapKeys ? mapped : key;
          value = isMapKeys ? value : mapped;
          result[key] = value;
        });
        return result;
      };
    }

    /**
     * Creates a function for `_.padLeft` or `_.padRight`.
     *
     * @private
     * @param {boolean} [fromRight] Specify padding from the right.
     * @returns {Function} Returns the new pad function.
     */
    function createPadDir(fromRight) {
      return function(string, length, chars) {
        string = baseToString(string);
        return (fromRight ? string : '') + createPadding(string, length, chars) + (fromRight ? '' : string);
      };
    }

    /**
     * Creates a `_.partial` or `_.partialRight` function.
     *
     * @private
     * @param {boolean} flag The partial bit flag.
     * @returns {Function} Returns the new partial function.
     */
    function createPartial(flag) {
      var partialFunc = restParam(function(func, partials) {
        var holders = replaceHolders(partials, partialFunc.placeholder);
        return createWrapper(func, flag, undefined, partials, holders);
      });
      return partialFunc;
    }

    /**
     * Creates a function for `_.reduce` or `_.reduceRight`.
     *
     * @private
     * @param {Function} arrayFunc The function to iterate over an array.
     * @param {Function} eachFunc The function to iterate over a collection.
     * @returns {Function} Returns the new each function.
     */
    function createReduce(arrayFunc, eachFunc) {
      return function(collection, iteratee, accumulator, thisArg) {
        var initFromArray = arguments.length < 3;
        return (typeof iteratee == 'function' && thisArg === undefined && isArray(collection))
          ? arrayFunc(collection, iteratee, accumulator, initFromArray)
          : baseReduce(collection, getCallback(iteratee, thisArg, 4), accumulator, initFromArray, eachFunc);
      };
    }

    /**
     * Creates a function that wraps `func` and invokes it with optional `this`
     * binding of, partial application, and currying.
     *
     * @private
     * @param {Function|string} func The function or method name to reference.
     * @param {number} bitmask The bitmask of flags. See `createWrapper` for more details.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {Array} [partials] The arguments to prepend to those provided to the new function.
     * @param {Array} [holders] The `partials` placeholder indexes.
     * @param {Array} [partialsRight] The arguments to append to those provided to the new function.
     * @param {Array} [holdersRight] The `partialsRight` placeholder indexes.
     * @param {Array} [argPos] The argument positions of the new function.
     * @param {number} [ary] The arity cap of `func`.
     * @param {number} [arity] The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createHybridWrapper(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity) {
      var isAry = bitmask & ARY_FLAG,
          isBind = bitmask & BIND_FLAG,
          isBindKey = bitmask & BIND_KEY_FLAG,
          isCurry = bitmask & CURRY_FLAG,
          isCurryBound = bitmask & CURRY_BOUND_FLAG,
          isCurryRight = bitmask & CURRY_RIGHT_FLAG,
          Ctor = isBindKey ? undefined : createCtorWrapper(func);

      function wrapper() {
        // Avoid `arguments` object use disqualifying optimizations by
        // converting it to an array before providing it to other functions.
        var length = arguments.length,
            index = length,
            args = Array(length);

        while (index--) {
          args[index] = arguments[index];
        }
        if (partials) {
          args = composeArgs(args, partials, holders);
        }
        if (partialsRight) {
          args = composeArgsRight(args, partialsRight, holdersRight);
        }
        if (isCurry || isCurryRight) {
          var placeholder = wrapper.placeholder,
              argsHolders = replaceHolders(args, placeholder);

          length -= argsHolders.length;
          if (length < arity) {
            var newArgPos = argPos ? arrayCopy(argPos) : undefined,
                newArity = nativeMax(arity - length, 0),
                newsHolders = isCurry ? argsHolders : undefined,
                newHoldersRight = isCurry ? undefined : argsHolders,
                newPartials = isCurry ? args : undefined,
                newPartialsRight = isCurry ? undefined : args;

            bitmask |= (isCurry ? PARTIAL_FLAG : PARTIAL_RIGHT_FLAG);
            bitmask &= ~(isCurry ? PARTIAL_RIGHT_FLAG : PARTIAL_FLAG);

            if (!isCurryBound) {
              bitmask &= ~(BIND_FLAG | BIND_KEY_FLAG);
            }
            var newData = [func, bitmask, thisArg, newPartials, newsHolders, newPartialsRight, newHoldersRight, newArgPos, ary, newArity],
                result = createHybridWrapper.apply(undefined, newData);

            if (isLaziable(func)) {
              setData(result, newData);
            }
            result.placeholder = placeholder;
            return result;
          }
        }
        var thisBinding = isBind ? thisArg : this,
            fn = isBindKey ? thisBinding[func] : func;

        if (argPos) {
          args = reorder(args, argPos);
        }
        if (isAry && ary < args.length) {
          args.length = ary;
        }
        if (this && this !== root && this instanceof wrapper) {
          fn = Ctor || createCtorWrapper(func);
        }
        return fn.apply(thisBinding, args);
      }
      return wrapper;
    }

    /**
     * Creates the padding required for `string` based on the given `length`.
     * The `chars` string is truncated if the number of characters exceeds `length`.
     *
     * @private
     * @param {string} string The string to create padding for.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the pad for `string`.
     */
    function createPadding(string, length, chars) {
      var strLength = string.length;
      length = +length;

      if (strLength >= length || !nativeIsFinite(length)) {
        return '';
      }
      var padLength = length - strLength;
      chars = chars == null ? ' ' : (chars + '');
      return repeat(chars, nativeCeil(padLength / chars.length)).slice(0, padLength);
    }

    /**
     * Creates a function that wraps `func` and invokes it with the optional `this`
     * binding of `thisArg` and the `partials` prepended to those provided to
     * the wrapper.
     *
     * @private
     * @param {Function} func The function to partially apply arguments to.
     * @param {number} bitmask The bitmask of flags. See `createWrapper` for more details.
     * @param {*} thisArg The `this` binding of `func`.
     * @param {Array} partials The arguments to prepend to those provided to the new function.
     * @returns {Function} Returns the new bound function.
     */
    function createPartialWrapper(func, bitmask, thisArg, partials) {
      var isBind = bitmask & BIND_FLAG,
          Ctor = createCtorWrapper(func);

      function wrapper() {
        // Avoid `arguments` object use disqualifying optimizations by
        // converting it to an array before providing it `func`.
        var argsIndex = -1,
            argsLength = arguments.length,
            leftIndex = -1,
            leftLength = partials.length,
            args = Array(leftLength + argsLength);

        while (++leftIndex < leftLength) {
          args[leftIndex] = partials[leftIndex];
        }
        while (argsLength--) {
          args[leftIndex++] = arguments[++argsIndex];
        }
        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
        return fn.apply(isBind ? thisArg : this, args);
      }
      return wrapper;
    }

    /**
     * Creates a `_.ceil`, `_.floor`, or `_.round` function.
     *
     * @private
     * @param {string} methodName The name of the `Math` method to use when rounding.
     * @returns {Function} Returns the new round function.
     */
    function createRound(methodName) {
      var func = Math[methodName];
      return function(number, precision) {
        precision = precision === undefined ? 0 : (+precision || 0);
        if (precision) {
          precision = pow(10, precision);
          return func(number * precision) / precision;
        }
        return func(number);
      };
    }

    /**
     * Creates a `_.sortedIndex` or `_.sortedLastIndex` function.
     *
     * @private
     * @param {boolean} [retHighest] Specify returning the highest qualified index.
     * @returns {Function} Returns the new index function.
     */
    function createSortedIndex(retHighest) {
      return function(array, value, iteratee, thisArg) {
        var callback = getCallback(iteratee);
        return (iteratee == null && callback === baseCallback)
          ? binaryIndex(array, value, retHighest)
          : binaryIndexBy(array, value, callback(iteratee, thisArg, 1), retHighest);
      };
    }

    /**
     * Creates a function that either curries or invokes `func` with optional
     * `this` binding and partially applied arguments.
     *
     * @private
     * @param {Function|string} func The function or method name to reference.
     * @param {number} bitmask The bitmask of flags.
     *  The bitmask may be composed of the following flags:
     *     1 - `_.bind`
     *     2 - `_.bindKey`
     *     4 - `_.curry` or `_.curryRight` of a bound function
     *     8 - `_.curry`
     *    16 - `_.curryRight`
     *    32 - `_.partial`
     *    64 - `_.partialRight`
     *   128 - `_.rearg`
     *   256 - `_.ary`
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {Array} [partials] The arguments to be partially applied.
     * @param {Array} [holders] The `partials` placeholder indexes.
     * @param {Array} [argPos] The argument positions of the new function.
     * @param {number} [ary] The arity cap of `func`.
     * @param {number} [arity] The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createWrapper(func, bitmask, thisArg, partials, holders, argPos, ary, arity) {
      var isBindKey = bitmask & BIND_KEY_FLAG;
      if (!isBindKey && typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var length = partials ? partials.length : 0;
      if (!length) {
        bitmask &= ~(PARTIAL_FLAG | PARTIAL_RIGHT_FLAG);
        partials = holders = undefined;
      }
      length -= (holders ? holders.length : 0);
      if (bitmask & PARTIAL_RIGHT_FLAG) {
        var partialsRight = partials,
            holdersRight = holders;

        partials = holders = undefined;
      }
      var data = isBindKey ? undefined : getData(func),
          newData = [func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity];

      if (data) {
        mergeData(newData, data);
        bitmask = newData[1];
        arity = newData[9];
      }
      newData[9] = arity == null
        ? (isBindKey ? 0 : func.length)
        : (nativeMax(arity - length, 0) || 0);

      if (bitmask == BIND_FLAG) {
        var result = createBindWrapper(newData[0], newData[2]);
      } else if ((bitmask == PARTIAL_FLAG || bitmask == (BIND_FLAG | PARTIAL_FLAG)) && !newData[4].length) {
        result = createPartialWrapper.apply(undefined, newData);
      } else {
        result = createHybridWrapper.apply(undefined, newData);
      }
      var setter = data ? baseSetData : setData;
      return setter(result, newData);
    }

    /**
     * A specialized version of `baseIsEqualDeep` for arrays with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Array} array The array to compare.
     * @param {Array} other The other array to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} [customizer] The function to customize comparing arrays.
     * @param {boolean} [isLoose] Specify performing partial comparisons.
     * @param {Array} [stackA] Tracks traversed `value` objects.
     * @param {Array} [stackB] Tracks traversed `other` objects.
     * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
     */
    function equalArrays(array, other, equalFunc, customizer, isLoose, stackA, stackB) {
      var index = -1,
          arrLength = array.length,
          othLength = other.length;

      if (arrLength != othLength && !(isLoose && othLength > arrLength)) {
        return false;
      }
      // Ignore non-index properties.
      while (++index < arrLength) {
        var arrValue = array[index],
            othValue = other[index],
            result = customizer ? customizer(isLoose ? othValue : arrValue, isLoose ? arrValue : othValue, index) : undefined;

        if (result !== undefined) {
          if (result) {
            continue;
          }
          return false;
        }
        // Recursively compare arrays (susceptible to call stack limits).
        if (isLoose) {
          if (!arraySome(other, function(othValue) {
                return arrValue === othValue || equalFunc(arrValue, othValue, customizer, isLoose, stackA, stackB);
              })) {
            return false;
          }
        } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, customizer, isLoose, stackA, stackB))) {
          return false;
        }
      }
      return true;
    }

    /**
     * A specialized version of `baseIsEqualDeep` for comparing objects of
     * the same `toStringTag`.
     *
     * **Note:** This function only supports comparing values with tags of
     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {string} tag The `toStringTag` of the objects to compare.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function equalByTag(object, other, tag) {
      switch (tag) {
        case boolTag:
        case dateTag:
          // Coerce dates and booleans to numbers, dates to milliseconds and booleans
          // to `1` or `0` treating invalid dates coerced to `NaN` as not equal.
          return +object == +other;

        case errorTag:
          return object.name == other.name && object.message == other.message;

        case numberTag:
          // Treat `NaN` vs. `NaN` as equal.
          return (object != +object)
            ? other != +other
            : object == +other;

        case regexpTag:
        case stringTag:
          // Coerce regexes to strings and treat strings primitives and string
          // objects as equal. See https://es5.github.io/#x15.10.6.4 for more details.
          return object == (other + '');
      }
      return false;
    }

    /**
     * A specialized version of `baseIsEqualDeep` for objects with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} [customizer] The function to customize comparing values.
     * @param {boolean} [isLoose] Specify performing partial comparisons.
     * @param {Array} [stackA] Tracks traversed `value` objects.
     * @param {Array} [stackB] Tracks traversed `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function equalObjects(object, other, equalFunc, customizer, isLoose, stackA, stackB) {
      var objProps = keys(object),
          objLength = objProps.length,
          othProps = keys(other),
          othLength = othProps.length;

      if (objLength != othLength && !isLoose) {
        return false;
      }
      var index = objLength;
      while (index--) {
        var key = objProps[index];
        if (!(isLoose ? key in other : hasOwnProperty.call(other, key))) {
          return false;
        }
      }
      var skipCtor = isLoose;
      while (++index < objLength) {
        key = objProps[index];
        var objValue = object[key],
            othValue = other[key],
            result = customizer ? customizer(isLoose ? othValue : objValue, isLoose? objValue : othValue, key) : undefined;

        // Recursively compare objects (susceptible to call stack limits).
        if (!(result === undefined ? equalFunc(objValue, othValue, customizer, isLoose, stackA, stackB) : result)) {
          return false;
        }
        skipCtor || (skipCtor = key == 'constructor');
      }
      if (!skipCtor) {
        var objCtor = object.constructor,
            othCtor = other.constructor;

        // Non `Object` object instances with different constructors are not equal.
        if (objCtor != othCtor &&
            ('constructor' in object && 'constructor' in other) &&
            !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
              typeof othCtor == 'function' && othCtor instanceof othCtor)) {
          return false;
        }
      }
      return true;
    }

    /**
     * Gets the appropriate "callback" function. If the `_.callback` method is
     * customized this function returns the custom method, otherwise it returns
     * the `baseCallback` function. If arguments are provided the chosen function
     * is invoked with them and its result is returned.
     *
     * @private
     * @returns {Function} Returns the chosen function or its result.
     */
    function getCallback(func, thisArg, argCount) {
      var result = lodash.callback || callback;
      result = result === callback ? baseCallback : result;
      return argCount ? result(func, thisArg, argCount) : result;
    }

    /**
     * Gets metadata for `func`.
     *
     * @private
     * @param {Function} func The function to query.
     * @returns {*} Returns the metadata for `func`.
     */
    var getData = !metaMap ? noop : function(func) {
      return metaMap.get(func);
    };

    /**
     * Gets the name of `func`.
     *
     * @private
     * @param {Function} func The function to query.
     * @returns {string} Returns the function name.
     */
    function getFuncName(func) {
      var result = func.name,
          array = realNames[result],
          length = array ? array.length : 0;

      while (length--) {
        var data = array[length],
            otherFunc = data.func;
        if (otherFunc == null || otherFunc == func) {
          return data.name;
        }
      }
      return result;
    }

    /**
     * Gets the appropriate "indexOf" function. If the `_.indexOf` method is
     * customized this function returns the custom method, otherwise it returns
     * the `baseIndexOf` function. If arguments are provided the chosen function
     * is invoked with them and its result is returned.
     *
     * @private
     * @returns {Function|number} Returns the chosen function or its result.
     */
    function getIndexOf(collection, target, fromIndex) {
      var result = lodash.indexOf || indexOf;
      result = result === indexOf ? baseIndexOf : result;
      return collection ? result(collection, target, fromIndex) : result;
    }

    /**
     * Gets the "length" property value of `object`.
     *
     * **Note:** This function is used to avoid a [JIT bug](https://bugs.webkit.org/show_bug.cgi?id=142792)
     * that affects Safari on at least iOS 8.1-8.3 ARM64.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {*} Returns the "length" value.
     */
    var getLength = baseProperty('length');

    /**
     * Gets the propery names, values, and compare flags of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the match data of `object`.
     */
    function getMatchData(object) {
      var result = pairs(object),
          length = result.length;

      while (length--) {
        result[length][2] = isStrictComparable(result[length][1]);
      }
      return result;
    }

    /**
     * Gets the native function at `key` of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {string} key The key of the method to get.
     * @returns {*} Returns the function if it's native, else `undefined`.
     */
    function getNative(object, key) {
      var value = object == null ? undefined : object[key];
      return isNative(value) ? value : undefined;
    }

    /**
     * Gets the view, applying any `transforms` to the `start` and `end` positions.
     *
     * @private
     * @param {number} start The start of the view.
     * @param {number} end The end of the view.
     * @param {Array} transforms The transformations to apply to the view.
     * @returns {Object} Returns an object containing the `start` and `end`
     *  positions of the view.
     */
    function getView(start, end, transforms) {
      var index = -1,
          length = transforms.length;

      while (++index < length) {
        var data = transforms[index],
            size = data.size;

        switch (data.type) {
          case 'drop':      start += size; break;
          case 'dropRight': end -= size; break;
          case 'take':      end = nativeMin(end, start + size); break;
          case 'takeRight': start = nativeMax(start, end - size); break;
        }
      }
      return { 'start': start, 'end': end };
    }

    /**
     * Initializes an array clone.
     *
     * @private
     * @param {Array} array The array to clone.
     * @returns {Array} Returns the initialized clone.
     */
    function initCloneArray(array) {
      var length = array.length,
          result = new array.constructor(length);

      // Add array properties assigned by `RegExp#exec`.
      if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
        result.index = array.index;
        result.input = array.input;
      }
      return result;
    }

    /**
     * Initializes an object clone.
     *
     * @private
     * @param {Object} object The object to clone.
     * @returns {Object} Returns the initialized clone.
     */
    function initCloneObject(object) {
      var Ctor = object.constructor;
      if (!(typeof Ctor == 'function' && Ctor instanceof Ctor)) {
        Ctor = Object;
      }
      return new Ctor;
    }

    /**
     * Initializes an object clone based on its `toStringTag`.
     *
     * **Note:** This function only supports cloning values with tags of
     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
     *
     * @private
     * @param {Object} object The object to clone.
     * @param {string} tag The `toStringTag` of the object to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the initialized clone.
     */
    function initCloneByTag(object, tag, isDeep) {
      var Ctor = object.constructor;
      switch (tag) {
        case arrayBufferTag:
          return bufferClone(object);

        case boolTag:
        case dateTag:
          return new Ctor(+object);

        case float32Tag: case float64Tag:
        case int8Tag: case int16Tag: case int32Tag:
        case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
          var buffer = object.buffer;
          return new Ctor(isDeep ? bufferClone(buffer) : buffer, object.byteOffset, object.length);

        case numberTag:
        case stringTag:
          return new Ctor(object);

        case regexpTag:
          var result = new Ctor(object.source, reFlags.exec(object));
          result.lastIndex = object.lastIndex;
      }
      return result;
    }

    /**
     * Invokes the method at `path` on `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the method to invoke.
     * @param {Array} args The arguments to invoke the method with.
     * @returns {*} Returns the result of the invoked method.
     */
    function invokePath(object, path, args) {
      if (object != null && !isKey(path, object)) {
        path = toPath(path);
        object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
        path = last(path);
      }
      var func = object == null ? object : object[path];
      return func == null ? undefined : func.apply(object, args);
    }

    /**
     * Checks if `value` is array-like.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
     */
    function isArrayLike(value) {
      return value != null && isLength(getLength(value));
    }

    /**
     * Checks if `value` is a valid array-like index.
     *
     * @private
     * @param {*} value The value to check.
     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
     */
    function isIndex(value, length) {
      value = (typeof value == 'number' || reIsUint.test(value)) ? +value : -1;
      length = length == null ? MAX_SAFE_INTEGER : length;
      return value > -1 && value % 1 == 0 && value < length;
    }

    /**
     * Checks if the provided arguments are from an iteratee call.
     *
     * @private
     * @param {*} value The potential iteratee value argument.
     * @param {*} index The potential iteratee index or key argument.
     * @param {*} object The potential iteratee object argument.
     * @returns {boolean} Returns `true` if the arguments are from an iteratee call, else `false`.
     */
    function isIterateeCall(value, index, object) {
      if (!isObject(object)) {
        return false;
      }
      var type = typeof index;
      if (type == 'number'
          ? (isArrayLike(object) && isIndex(index, object.length))
          : (type == 'string' && index in object)) {
        var other = object[index];
        return value === value ? (value === other) : (other !== other);
      }
      return false;
    }

    /**
     * Checks if `value` is a property name and not a property path.
     *
     * @private
     * @param {*} value The value to check.
     * @param {Object} [object] The object to query keys on.
     * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
     */
    function isKey(value, object) {
      var type = typeof value;
      if ((type == 'string' && reIsPlainProp.test(value)) || type == 'number') {
        return true;
      }
      if (isArray(value)) {
        return false;
      }
      var result = !reIsDeepProp.test(value);
      return result || (object != null && value in toObject(object));
    }

    /**
     * Checks if `func` has a lazy counterpart.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` has a lazy counterpart, else `false`.
     */
    function isLaziable(func) {
      var funcName = getFuncName(func);
      if (!(funcName in LazyWrapper.prototype)) {
        return false;
      }
      var other = lodash[funcName];
      if (func === other) {
        return true;
      }
      var data = getData(other);
      return !!data && func === data[0];
    }

    /**
     * Checks if `value` is a valid array-like length.
     *
     * **Note:** This function is based on [`ToLength`](http://ecma-international.org/ecma-262/6.0/#sec-tolength).
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
     */
    function isLength(value) {
      return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }

    /**
     * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` if suitable for strict
     *  equality comparisons, else `false`.
     */
    function isStrictComparable(value) {
      return value === value && !isObject(value);
    }

    /**
     * Merges the function metadata of `source` into `data`.
     *
     * Merging metadata reduces the number of wrappers required to invoke a function.
     * This is possible because methods like `_.bind`, `_.curry`, and `_.partial`
     * may be applied regardless of execution order. Methods like `_.ary` and `_.rearg`
     * augment function arguments, making the order in which they are executed important,
     * preventing the merging of metadata. However, we make an exception for a safe
     * common case where curried functions have `_.ary` and or `_.rearg` applied.
     *
     * @private
     * @param {Array} data The destination metadata.
     * @param {Array} source The source metadata.
     * @returns {Array} Returns `data`.
     */
    function mergeData(data, source) {
      var bitmask = data[1],
          srcBitmask = source[1],
          newBitmask = bitmask | srcBitmask,
          isCommon = newBitmask < ARY_FLAG;

      var isCombo =
        (srcBitmask == ARY_FLAG && bitmask == CURRY_FLAG) ||
        (srcBitmask == ARY_FLAG && bitmask == REARG_FLAG && data[7].length <= source[8]) ||
        (srcBitmask == (ARY_FLAG | REARG_FLAG) && bitmask == CURRY_FLAG);

      // Exit early if metadata can't be merged.
      if (!(isCommon || isCombo)) {
        return data;
      }
      // Use source `thisArg` if available.
      if (srcBitmask & BIND_FLAG) {
        data[2] = source[2];
        // Set when currying a bound function.
        newBitmask |= (bitmask & BIND_FLAG) ? 0 : CURRY_BOUND_FLAG;
      }
      // Compose partial arguments.
      var value = source[3];
      if (value) {
        var partials = data[3];
        data[3] = partials ? composeArgs(partials, value, source[4]) : arrayCopy(value);
        data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : arrayCopy(source[4]);
      }
      // Compose partial right arguments.
      value = source[5];
      if (value) {
        partials = data[5];
        data[5] = partials ? composeArgsRight(partials, value, source[6]) : arrayCopy(value);
        data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : arrayCopy(source[6]);
      }
      // Use source `argPos` if available.
      value = source[7];
      if (value) {
        data[7] = arrayCopy(value);
      }
      // Use source `ary` if it's smaller.
      if (srcBitmask & ARY_FLAG) {
        data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
      }
      // Use source `arity` if one is not provided.
      if (data[9] == null) {
        data[9] = source[9];
      }
      // Use source `func` and merge bitmasks.
      data[0] = source[0];
      data[1] = newBitmask;

      return data;
    }

    /**
     * Used by `_.defaultsDeep` to customize its `_.merge` use.
     *
     * @private
     * @param {*} objectValue The destination object property value.
     * @param {*} sourceValue The source object property value.
     * @returns {*} Returns the value to assign to the destination object.
     */
    function mergeDefaults(objectValue, sourceValue) {
      return objectValue === undefined ? sourceValue : merge(objectValue, sourceValue, mergeDefaults);
    }

    /**
     * A specialized version of `_.pick` which picks `object` properties specified
     * by `props`.
     *
     * @private
     * @param {Object} object The source object.
     * @param {string[]} props The property names to pick.
     * @returns {Object} Returns the new object.
     */
    function pickByArray(object, props) {
      object = toObject(object);

      var index = -1,
          length = props.length,
          result = {};

      while (++index < length) {
        var key = props[index];
        if (key in object) {
          result[key] = object[key];
        }
      }
      return result;
    }

    /**
     * A specialized version of `_.pick` which picks `object` properties `predicate`
     * returns truthy for.
     *
     * @private
     * @param {Object} object The source object.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Object} Returns the new object.
     */
    function pickByCallback(object, predicate) {
      var result = {};
      baseForIn(object, function(value, key, object) {
        if (predicate(value, key, object)) {
          result[key] = value;
        }
      });
      return result;
    }

    /**
     * Reorder `array` according to the specified indexes where the element at
     * the first index is assigned as the first element, the element at
     * the second index is assigned as the second element, and so on.
     *
     * @private
     * @param {Array} array The array to reorder.
     * @param {Array} indexes The arranged array indexes.
     * @returns {Array} Returns `array`.
     */
    function reorder(array, indexes) {
      var arrLength = array.length,
          length = nativeMin(indexes.length, arrLength),
          oldArray = arrayCopy(array);

      while (length--) {
        var index = indexes[length];
        array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined;
      }
      return array;
    }

    /**
     * Sets metadata for `func`.
     *
     * **Note:** If this function becomes hot, i.e. is invoked a lot in a short
     * period of time, it will trip its breaker and transition to an identity function
     * to avoid garbage collection pauses in V8. See [V8 issue 2070](https://code.google.com/p/v8/issues/detail?id=2070)
     * for more details.
     *
     * @private
     * @param {Function} func The function to associate metadata with.
     * @param {*} data The metadata.
     * @returns {Function} Returns `func`.
     */
    var setData = (function() {
      var count = 0,
          lastCalled = 0;

      return function(key, value) {
        var stamp = now(),
            remaining = HOT_SPAN - (stamp - lastCalled);

        lastCalled = stamp;
        if (remaining > 0) {
          if (++count >= HOT_COUNT) {
            return key;
          }
        } else {
          count = 0;
        }
        return baseSetData(key, value);
      };
    }());

    /**
     * A fallback implementation of `Object.keys` which creates an array of the
     * own enumerable property names of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */
    function shimKeys(object) {
      var props = keysIn(object),
          propsLength = props.length,
          length = propsLength && object.length;

      var allowIndexes = !!length && isLength(length) &&
        (isArray(object) || isArguments(object));

      var index = -1,
          result = [];

      while (++index < propsLength) {
        var key = props[index];
        if ((allowIndexes && isIndex(key, length)) || hasOwnProperty.call(object, key)) {
          result.push(key);
        }
      }
      return result;
    }

    /**
     * Converts `value` to an array-like object if it's not one.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {Array|Object} Returns the array-like object.
     */
    function toIterable(value) {
      if (value == null) {
        return [];
      }
      if (!isArrayLike(value)) {
        return values(value);
      }
      return isObject(value) ? value : Object(value);
    }

    /**
     * Converts `value` to an object if it's not one.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {Object} Returns the object.
     */
    function toObject(value) {
      return isObject(value) ? value : Object(value);
    }

    /**
     * Converts `value` to property path array if it's not one.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {Array} Returns the property path array.
     */
    function toPath(value) {
      if (isArray(value)) {
        return value;
      }
      var result = [];
      baseToString(value).replace(rePropName, function(match, number, quote, string) {
        result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
      });
      return result;
    }

    /**
     * Creates a clone of `wrapper`.
     *
     * @private
     * @param {Object} wrapper The wrapper to clone.
     * @returns {Object} Returns the cloned wrapper.
     */
    function wrapperClone(wrapper) {
      return wrapper instanceof LazyWrapper
        ? wrapper.clone()
        : new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__, arrayCopy(wrapper.__actions__));
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates an array of elements split into groups the length of `size`.
     * If `collection` can't be split evenly, the final chunk will be the remaining
     * elements.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to process.
     * @param {number} [size=1] The length of each chunk.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the new array containing chunks.
     * @example
     *
     * _.chunk(['a', 'b', 'c', 'd'], 2);
     * // => [['a', 'b'], ['c', 'd']]
     *
     * _.chunk(['a', 'b', 'c', 'd'], 3);
     * // => [['a', 'b', 'c'], ['d']]
     */
    function chunk(array, size, guard) {
      if (guard ? isIterateeCall(array, size, guard) : size == null) {
        size = 1;
      } else {
        size = nativeMax(nativeFloor(size) || 1, 1);
      }
      var index = 0,
          length = array ? array.length : 0,
          resIndex = -1,
          result = Array(nativeCeil(length / size));

      while (index < length) {
        result[++resIndex] = baseSlice(array, index, (index += size));
      }
      return result;
    }

    /**
     * Creates an array with all falsey values removed. The values `false`, `null`,
     * `0`, `""`, `undefined`, and `NaN` are falsey.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to compact.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.compact([0, 1, false, 2, '', 3]);
     * // => [1, 2, 3]
     */
    function compact(array) {
      var index = -1,
          length = array ? array.length : 0,
          resIndex = -1,
          result = [];

      while (++index < length) {
        var value = array[index];
        if (value) {
          result[++resIndex] = value;
        }
      }
      return result;
    }

    /**
     * Creates an array of unique `array` values not included in the other
     * provided arrays using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {...Array} [values] The arrays of values to exclude.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.difference([1, 2, 3], [4, 2]);
     * // => [1, 3]
     */
    var difference = restParam(function(array, values) {
      return (isObjectLike(array) && isArrayLike(array))
        ? baseDifference(array, baseFlatten(values, false, true))
        : [];
    });

    /**
     * Creates a slice of `array` with `n` elements dropped from the beginning.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to drop.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.drop([1, 2, 3]);
     * // => [2, 3]
     *
     * _.drop([1, 2, 3], 2);
     * // => [3]
     *
     * _.drop([1, 2, 3], 5);
     * // => []
     *
     * _.drop([1, 2, 3], 0);
     * // => [1, 2, 3]
     */
    function drop(array, n, guard) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (guard ? isIterateeCall(array, n, guard) : n == null) {
        n = 1;
      }
      return baseSlice(array, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` with `n` elements dropped from the end.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to drop.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.dropRight([1, 2, 3]);
     * // => [1, 2]
     *
     * _.dropRight([1, 2, 3], 2);
     * // => [1]
     *
     * _.dropRight([1, 2, 3], 5);
     * // => []
     *
     * _.dropRight([1, 2, 3], 0);
     * // => [1, 2, 3]
     */
    function dropRight(array, n, guard) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (guard ? isIterateeCall(array, n, guard) : n == null) {
        n = 1;
      }
      n = length - (+n || 0);
      return baseSlice(array, 0, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` excluding elements dropped from the end.
     * Elements are dropped until `predicate` returns falsey. The predicate is
     * bound to `thisArg` and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that match the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.dropRightWhile([1, 2, 3], function(n) {
     *   return n > 1;
     * });
     * // => [1]
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.dropRightWhile(users, { 'user': 'pebbles', 'active': false }), 'user');
     * // => ['barney', 'fred']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.dropRightWhile(users, 'active', false), 'user');
     * // => ['barney']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.dropRightWhile(users, 'active'), 'user');
     * // => ['barney', 'fred', 'pebbles']
     */
    function dropRightWhile(array, predicate, thisArg) {
      return (array && array.length)
        ? baseWhile(array, getCallback(predicate, thisArg, 3), true, true)
        : [];
    }

    /**
     * Creates a slice of `array` excluding elements dropped from the beginning.
     * Elements are dropped until `predicate` returns falsey. The predicate is
     * bound to `thisArg` and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.dropWhile([1, 2, 3], function(n) {
     *   return n < 3;
     * });
     * // => [3]
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.dropWhile(users, { 'user': 'barney', 'active': false }), 'user');
     * // => ['fred', 'pebbles']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.dropWhile(users, 'active', false), 'user');
     * // => ['pebbles']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.dropWhile(users, 'active'), 'user');
     * // => ['barney', 'fred', 'pebbles']
     */
    function dropWhile(array, predicate, thisArg) {
      return (array && array.length)
        ? baseWhile(array, getCallback(predicate, thisArg, 3), true)
        : [];
    }

    /**
     * Fills elements of `array` with `value` from `start` up to, but not
     * including, `end`.
     *
     * **Note:** This method mutates `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to fill.
     * @param {*} value The value to fill `array` with.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [1, 2, 3];
     *
     * _.fill(array, 'a');
     * console.log(array);
     * // => ['a', 'a', 'a']
     *
     * _.fill(Array(3), 2);
     * // => [2, 2, 2]
     *
     * _.fill([4, 6, 8], '*', 1, 2);
     * // => [4, '*', 8]
     */
    function fill(array, value, start, end) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (start && typeof start != 'number' && isIterateeCall(array, value, start)) {
        start = 0;
        end = length;
      }
      return baseFill(array, value, start, end);
    }

    /**
     * This method is like `_.find` except that it returns the index of the first
     * element `predicate` returns truthy for instead of the element itself.
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * _.findIndex(users, function(chr) {
     *   return chr.user == 'barney';
     * });
     * // => 0
     *
     * // using the `_.matches` callback shorthand
     * _.findIndex(users, { 'user': 'fred', 'active': false });
     * // => 1
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.findIndex(users, 'active', false);
     * // => 0
     *
     * // using the `_.property` callback shorthand
     * _.findIndex(users, 'active');
     * // => 2
     */
    var findIndex = createFindIndex();

    /**
     * This method is like `_.findIndex` except that it iterates over elements
     * of `collection` from right to left.
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * _.findLastIndex(users, function(chr) {
     *   return chr.user == 'pebbles';
     * });
     * // => 2
     *
     * // using the `_.matches` callback shorthand
     * _.findLastIndex(users, { 'user': 'barney', 'active': true });
     * // => 0
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.findLastIndex(users, 'active', false);
     * // => 2
     *
     * // using the `_.property` callback shorthand
     * _.findLastIndex(users, 'active');
     * // => 0
     */
    var findLastIndex = createFindIndex(true);

    /**
     * Gets the first element of `array`.
     *
     * @static
     * @memberOf _
     * @alias head
     * @category Array
     * @param {Array} array The array to query.
     * @returns {*} Returns the first element of `array`.
     * @example
     *
     * _.first([1, 2, 3]);
     * // => 1
     *
     * _.first([]);
     * // => undefined
     */
    function first(array) {
      return array ? array[0] : undefined;
    }

    /**
     * Flattens a nested array. If `isDeep` is `true` the array is recursively
     * flattened, otherwise it is only flattened a single level.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to flatten.
     * @param {boolean} [isDeep] Specify a deep flatten.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * _.flatten([1, [2, 3, [4]]]);
     * // => [1, 2, 3, [4]]
     *
     * // using `isDeep`
     * _.flatten([1, [2, 3, [4]]], true);
     * // => [1, 2, 3, 4]
     */
    function flatten(array, isDeep, guard) {
      var length = array ? array.length : 0;
      if (guard && isIterateeCall(array, isDeep, guard)) {
        isDeep = false;
      }
      return length ? baseFlatten(array, isDeep) : [];
    }

    /**
     * Recursively flattens a nested array.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to recursively flatten.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * _.flattenDeep([1, [2, 3, [4]]]);
     * // => [1, 2, 3, 4]
     */
    function flattenDeep(array) {
      var length = array ? array.length : 0;
      return length ? baseFlatten(array, true) : [];
    }

    /**
     * Gets the index at which the first occurrence of `value` is found in `array`
     * using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
     * for equality comparisons. If `fromIndex` is negative, it is used as the offset
     * from the end of `array`. If `array` is sorted providing `true` for `fromIndex`
     * performs a faster binary search.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to search.
     * @param {*} value The value to search for.
     * @param {boolean|number} [fromIndex=0] The index to search from or `true`
     *  to perform a binary search on a sorted array.
     * @returns {number} Returns the index of the matched value, else `-1`.
     * @example
     *
     * _.indexOf([1, 2, 1, 2], 2);
     * // => 1
     *
     * // using `fromIndex`
     * _.indexOf([1, 2, 1, 2], 2, 2);
     * // => 3
     *
     * // performing a binary search
     * _.indexOf([1, 1, 2, 2], 2, true);
     * // => 2
     */
    function indexOf(array, value, fromIndex) {
      var length = array ? array.length : 0;
      if (!length) {
        return -1;
      }
      if (typeof fromIndex == 'number') {
        fromIndex = fromIndex < 0 ? nativeMax(length + fromIndex, 0) : fromIndex;
      } else if (fromIndex) {
        var index = binaryIndex(array, value);
        if (index < length &&
            (value === value ? (value === array[index]) : (array[index] !== array[index]))) {
          return index;
        }
        return -1;
      }
      return baseIndexOf(array, value, fromIndex || 0);
    }

    /**
     * Gets all but the last element of `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.initial([1, 2, 3]);
     * // => [1, 2]
     */
    function initial(array) {
      return dropRight(array, 1);
    }

    /**
     * Creates an array of unique values that are included in all of the provided
     * arrays using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of shared values.
     * @example
     * _.intersection([1, 2], [4, 2], [2, 1]);
     * // => [2]
     */
    var intersection = restParam(function(arrays) {
      var othLength = arrays.length,
          othIndex = othLength,
          caches = Array(length),
          indexOf = getIndexOf(),
          isCommon = indexOf == baseIndexOf,
          result = [];

      while (othIndex--) {
        var value = arrays[othIndex] = isArrayLike(value = arrays[othIndex]) ? value : [];
        caches[othIndex] = (isCommon && value.length >= 120) ? createCache(othIndex && value) : null;
      }
      var array = arrays[0],
          index = -1,
          length = array ? array.length : 0,
          seen = caches[0];

      outer:
      while (++index < length) {
        value = array[index];
        if ((seen ? cacheIndexOf(seen, value) : indexOf(result, value, 0)) < 0) {
          var othIndex = othLength;
          while (--othIndex) {
            var cache = caches[othIndex];
            if ((cache ? cacheIndexOf(cache, value) : indexOf(arrays[othIndex], value, 0)) < 0) {
              continue outer;
            }
          }
          if (seen) {
            seen.push(value);
          }
          result.push(value);
        }
      }
      return result;
    });

    /**
     * Gets the last element of `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @returns {*} Returns the last element of `array`.
     * @example
     *
     * _.last([1, 2, 3]);
     * // => 3
     */
    function last(array) {
      var length = array ? array.length : 0;
      return length ? array[length - 1] : undefined;
    }

    /**
     * This method is like `_.indexOf` except that it iterates over elements of
     * `array` from right to left.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to search.
     * @param {*} value The value to search for.
     * @param {boolean|number} [fromIndex=array.length-1] The index to search from
     *  or `true` to perform a binary search on a sorted array.
     * @returns {number} Returns the index of the matched value, else `-1`.
     * @example
     *
     * _.lastIndexOf([1, 2, 1, 2], 2);
     * // => 3
     *
     * // using `fromIndex`
     * _.lastIndexOf([1, 2, 1, 2], 2, 2);
     * // => 1
     *
     * // performing a binary search
     * _.lastIndexOf([1, 1, 2, 2], 2, true);
     * // => 3
     */
    function lastIndexOf(array, value, fromIndex) {
      var length = array ? array.length : 0;
      if (!length) {
        return -1;
      }
      var index = length;
      if (typeof fromIndex == 'number') {
        index = (fromIndex < 0 ? nativeMax(length + fromIndex, 0) : nativeMin(fromIndex || 0, length - 1)) + 1;
      } else if (fromIndex) {
        index = binaryIndex(array, value, true) - 1;
        var other = array[index];
        if (value === value ? (value === other) : (other !== other)) {
          return index;
        }
        return -1;
      }
      if (value !== value) {
        return indexOfNaN(array, index, true);
      }
      while (index--) {
        if (array[index] === value) {
          return index;
        }
      }
      return -1;
    }

    /**
     * Removes all provided values from `array` using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * **Note:** Unlike `_.without`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to modify.
     * @param {...*} [values] The values to remove.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [1, 2, 3, 1, 2, 3];
     *
     * _.pull(array, 2, 3);
     * console.log(array);
     * // => [1, 1]
     */
    function pull() {
      var args = arguments,
          array = args[0];

      if (!(array && array.length)) {
        return array;
      }
      var index = 0,
          indexOf = getIndexOf(),
          length = args.length;

      while (++index < length) {
        var fromIndex = 0,
            value = args[index];

        while ((fromIndex = indexOf(array, value, fromIndex)) > -1) {
          splice.call(array, fromIndex, 1);
        }
      }
      return array;
    }

    /**
     * Removes elements from `array` corresponding to the given indexes and returns
     * an array of the removed elements. Indexes may be specified as an array of
     * indexes or as individual arguments.
     *
     * **Note:** Unlike `_.at`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to modify.
     * @param {...(number|number[])} [indexes] The indexes of elements to remove,
     *  specified as individual indexes or arrays of indexes.
     * @returns {Array} Returns the new array of removed elements.
     * @example
     *
     * var array = [5, 10, 15, 20];
     * var evens = _.pullAt(array, 1, 3);
     *
     * console.log(array);
     * // => [5, 15]
     *
     * console.log(evens);
     * // => [10, 20]
     */
    var pullAt = restParam(function(array, indexes) {
      indexes = baseFlatten(indexes);

      var result = baseAt(array, indexes);
      basePullAt(array, indexes.sort(baseCompareAscending));
      return result;
    });

    /**
     * Removes all elements from `array` that `predicate` returns truthy for
     * and returns an array of the removed elements. The predicate is bound to
     * `thisArg` and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * **Note:** Unlike `_.filter`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to modify.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the new array of removed elements.
     * @example
     *
     * var array = [1, 2, 3, 4];
     * var evens = _.remove(array, function(n) {
     *   return n % 2 == 0;
     * });
     *
     * console.log(array);
     * // => [1, 3]
     *
     * console.log(evens);
     * // => [2, 4]
     */
    function remove(array, predicate, thisArg) {
      var result = [];
      if (!(array && array.length)) {
        return result;
      }
      var index = -1,
          indexes = [],
          length = array.length;

      predicate = getCallback(predicate, thisArg, 3);
      while (++index < length) {
        var value = array[index];
        if (predicate(value, index, array)) {
          result.push(value);
          indexes.push(index);
        }
      }
      basePullAt(array, indexes);
      return result;
    }

    /**
     * Gets all but the first element of `array`.
     *
     * @static
     * @memberOf _
     * @alias tail
     * @category Array
     * @param {Array} array The array to query.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.rest([1, 2, 3]);
     * // => [2, 3]
     */
    function rest(array) {
      return drop(array, 1);
    }

    /**
     * Creates a slice of `array` from `start` up to, but not including, `end`.
     *
     * **Note:** This method is used instead of `Array#slice` to support node
     * lists in IE < 9 and to ensure dense arrays are returned.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to slice.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the slice of `array`.
     */
    function slice(array, start, end) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (end && typeof end != 'number' && isIterateeCall(array, start, end)) {
        start = 0;
        end = length;
      }
      return baseSlice(array, start, end);
    }

    /**
     * Uses a binary search to determine the lowest index at which `value` should
     * be inserted into `array` in order to maintain its sort order. If an iteratee
     * function is provided it is invoked for `value` and each element of `array`
     * to compute their sort ranking. The iteratee is bound to `thisArg` and
     * invoked with one argument; (value).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * _.sortedIndex([30, 50], 40);
     * // => 1
     *
     * _.sortedIndex([4, 4, 5, 5], 5);
     * // => 2
     *
     * var dict = { 'data': { 'thirty': 30, 'forty': 40, 'fifty': 50 } };
     *
     * // using an iteratee function
     * _.sortedIndex(['thirty', 'fifty'], 'forty', function(word) {
     *   return this.data[word];
     * }, dict);
     * // => 1
     *
     * // using the `_.property` callback shorthand
     * _.sortedIndex([{ 'x': 30 }, { 'x': 50 }], { 'x': 40 }, 'x');
     * // => 1
     */
    var sortedIndex = createSortedIndex();

    /**
     * This method is like `_.sortedIndex` except that it returns the highest
     * index at which `value` should be inserted into `array` in order to
     * maintain its sort order.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * _.sortedLastIndex([4, 4, 5, 5], 5);
     * // => 4
     */
    var sortedLastIndex = createSortedIndex(true);

    /**
     * Creates a slice of `array` with `n` elements taken from the beginning.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to take.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.take([1, 2, 3]);
     * // => [1]
     *
     * _.take([1, 2, 3], 2);
     * // => [1, 2]
     *
     * _.take([1, 2, 3], 5);
     * // => [1, 2, 3]
     *
     * _.take([1, 2, 3], 0);
     * // => []
     */
    function take(array, n, guard) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (guard ? isIterateeCall(array, n, guard) : n == null) {
        n = 1;
      }
      return baseSlice(array, 0, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` with `n` elements taken from the end.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to take.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.takeRight([1, 2, 3]);
     * // => [3]
     *
     * _.takeRight([1, 2, 3], 2);
     * // => [2, 3]
     *
     * _.takeRight([1, 2, 3], 5);
     * // => [1, 2, 3]
     *
     * _.takeRight([1, 2, 3], 0);
     * // => []
     */
    function takeRight(array, n, guard) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (guard ? isIterateeCall(array, n, guard) : n == null) {
        n = 1;
      }
      n = length - (+n || 0);
      return baseSlice(array, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` with elements taken from the end. Elements are
     * taken until `predicate` returns falsey. The predicate is bound to `thisArg`
     * and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.takeRightWhile([1, 2, 3], function(n) {
     *   return n > 1;
     * });
     * // => [2, 3]
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.takeRightWhile(users, { 'user': 'pebbles', 'active': false }), 'user');
     * // => ['pebbles']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.takeRightWhile(users, 'active', false), 'user');
     * // => ['fred', 'pebbles']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.takeRightWhile(users, 'active'), 'user');
     * // => []
     */
    function takeRightWhile(array, predicate, thisArg) {
      return (array && array.length)
        ? baseWhile(array, getCallback(predicate, thisArg, 3), false, true)
        : [];
    }

    /**
     * Creates a slice of `array` with elements taken from the beginning. Elements
     * are taken until `predicate` returns falsey. The predicate is bound to
     * `thisArg` and invoked with three arguments: (value, index, array).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.takeWhile([1, 2, 3], function(n) {
     *   return n < 3;
     * });
     * // => [1, 2]
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false},
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.takeWhile(users, { 'user': 'barney', 'active': false }), 'user');
     * // => ['barney']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.takeWhile(users, 'active', false), 'user');
     * // => ['barney', 'fred']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.takeWhile(users, 'active'), 'user');
     * // => []
     */
    function takeWhile(array, predicate, thisArg) {
      return (array && array.length)
        ? baseWhile(array, getCallback(predicate, thisArg, 3))
        : [];
    }

    /**
     * Creates an array of unique values, in order, from all of the provided arrays
     * using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of combined values.
     * @example
     *
     * _.union([1, 2], [4, 2], [2, 1]);
     * // => [1, 2, 4]
     */
    var union = restParam(function(arrays) {
      return baseUniq(baseFlatten(arrays, false, true));
    });

    /**
     * Creates a duplicate-free version of an array, using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
     * for equality comparisons, in which only the first occurence of each element
     * is kept. Providing `true` for `isSorted` performs a faster search algorithm
     * for sorted arrays. If an iteratee function is provided it is invoked for
     * each element in the array to generate the criterion by which uniqueness
     * is computed. The `iteratee` is bound to `thisArg` and invoked with three
     * arguments: (value, index, array).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @alias unique
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {boolean} [isSorted] Specify the array is sorted.
     * @param {Function|Object|string} [iteratee] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array} Returns the new duplicate-value-free array.
     * @example
     *
     * _.uniq([2, 1, 2]);
     * // => [2, 1]
     *
     * // using `isSorted`
     * _.uniq([1, 1, 2], true);
     * // => [1, 2]
     *
     * // using an iteratee function
     * _.uniq([1, 2.5, 1.5, 2], function(n) {
     *   return this.floor(n);
     * }, Math);
     * // => [1, 2.5]
     *
     * // using the `_.property` callback shorthand
     * _.uniq([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
     * // => [{ 'x': 1 }, { 'x': 2 }]
     */
    function uniq(array, isSorted, iteratee, thisArg) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      if (isSorted != null && typeof isSorted != 'boolean') {
        thisArg = iteratee;
        iteratee = isIterateeCall(array, isSorted, thisArg) ? undefined : isSorted;
        isSorted = false;
      }
      var callback = getCallback();
      if (!(iteratee == null && callback === baseCallback)) {
        iteratee = callback(iteratee, thisArg, 3);
      }
      return (isSorted && getIndexOf() == baseIndexOf)
        ? sortedUniq(array, iteratee)
        : baseUniq(array, iteratee);
    }

    /**
     * This method is like `_.zip` except that it accepts an array of grouped
     * elements and creates an array regrouping the elements to their pre-zip
     * configuration.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array of grouped elements to process.
     * @returns {Array} Returns the new array of regrouped elements.
     * @example
     *
     * var zipped = _.zip(['fred', 'barney'], [30, 40], [true, false]);
     * // => [['fred', 30, true], ['barney', 40, false]]
     *
     * _.unzip(zipped);
     * // => [['fred', 'barney'], [30, 40], [true, false]]
     */
    function unzip(array) {
      if (!(array && array.length)) {
        return [];
      }
      var index = -1,
          length = 0;

      array = arrayFilter(array, function(group) {
        if (isArrayLike(group)) {
          length = nativeMax(group.length, length);
          return true;
        }
      });
      var result = Array(length);
      while (++index < length) {
        result[index] = arrayMap(array, baseProperty(index));
      }
      return result;
    }

    /**
     * This method is like `_.unzip` except that it accepts an iteratee to specify
     * how regrouped values should be combined. The `iteratee` is bound to `thisArg`
     * and invoked with four arguments: (accumulator, value, index, group).
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array of grouped elements to process.
     * @param {Function} [iteratee] The function to combine regrouped values.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array} Returns the new array of regrouped elements.
     * @example
     *
     * var zipped = _.zip([1, 2], [10, 20], [100, 200]);
     * // => [[1, 10, 100], [2, 20, 200]]
     *
     * _.unzipWith(zipped, _.add);
     * // => [3, 30, 300]
     */
    function unzipWith(array, iteratee, thisArg) {
      var length = array ? array.length : 0;
      if (!length) {
        return [];
      }
      var result = unzip(array);
      if (iteratee == null) {
        return result;
      }
      iteratee = bindCallback(iteratee, thisArg, 4);
      return arrayMap(result, function(group) {
        return arrayReduce(group, iteratee, undefined, true);
      });
    }

    /**
     * Creates an array excluding all provided values using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {Array} array The array to filter.
     * @param {...*} [values] The values to exclude.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.without([1, 2, 1, 3], 1, 2);
     * // => [3]
     */
    var without = restParam(function(array, values) {
      return isArrayLike(array)
        ? baseDifference(array, values)
        : [];
    });

    /**
     * Creates an array of unique values that is the [symmetric difference](https://en.wikipedia.org/wiki/Symmetric_difference)
     * of the provided arrays.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of values.
     * @example
     *
     * _.xor([1, 2], [4, 2]);
     * // => [1, 4]
     */
    function xor() {
      var index = -1,
          length = arguments.length;

      while (++index < length) {
        var array = arguments[index];
        if (isArrayLike(array)) {
          var result = result
            ? arrayPush(baseDifference(result, array), baseDifference(array, result))
            : array;
        }
      }
      return result ? baseUniq(result) : [];
    }

    /**
     * Creates an array of grouped elements, the first of which contains the first
     * elements of the given arrays, the second of which contains the second elements
     * of the given arrays, and so on.
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to process.
     * @returns {Array} Returns the new array of grouped elements.
     * @example
     *
     * _.zip(['fred', 'barney'], [30, 40], [true, false]);
     * // => [['fred', 30, true], ['barney', 40, false]]
     */
    var zip = restParam(unzip);

    /**
     * The inverse of `_.pairs`; this method returns an object composed from arrays
     * of property names and values. Provide either a single two dimensional array,
     * e.g. `[[key1, value1], [key2, value2]]` or two arrays, one of property names
     * and one of corresponding values.
     *
     * @static
     * @memberOf _
     * @alias object
     * @category Array
     * @param {Array} props The property names.
     * @param {Array} [values=[]] The property values.
     * @returns {Object} Returns the new object.
     * @example
     *
     * _.zipObject([['fred', 30], ['barney', 40]]);
     * // => { 'fred': 30, 'barney': 40 }
     *
     * _.zipObject(['fred', 'barney'], [30, 40]);
     * // => { 'fred': 30, 'barney': 40 }
     */
    function zipObject(props, values) {
      var index = -1,
          length = props ? props.length : 0,
          result = {};

      if (length && !values && !isArray(props[0])) {
        values = [];
      }
      while (++index < length) {
        var key = props[index];
        if (values) {
          result[key] = values[index];
        } else if (key) {
          result[key[0]] = key[1];
        }
      }
      return result;
    }

    /**
     * This method is like `_.zip` except that it accepts an iteratee to specify
     * how grouped values should be combined. The `iteratee` is bound to `thisArg`
     * and invoked with four arguments: (accumulator, value, index, group).
     *
     * @static
     * @memberOf _
     * @category Array
     * @param {...Array} [arrays] The arrays to process.
     * @param {Function} [iteratee] The function to combine grouped values.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array} Returns the new array of grouped elements.
     * @example
     *
     * _.zipWith([1, 2], [10, 20], [100, 200], _.add);
     * // => [111, 222]
     */
    var zipWith = restParam(function(arrays) {
      var length = arrays.length,
          iteratee = length > 2 ? arrays[length - 2] : undefined,
          thisArg = length > 1 ? arrays[length - 1] : undefined;

      if (length > 2 && typeof iteratee == 'function') {
        length -= 2;
      } else {
        iteratee = (length > 1 && typeof thisArg == 'function') ? (--length, thisArg) : undefined;
        thisArg = undefined;
      }
      arrays.length = length;
      return unzipWith(arrays, iteratee, thisArg);
    });

    /*------------------------------------------------------------------------*/

    /**
     * Creates a `lodash` object that wraps `value` with explicit method
     * chaining enabled.
     *
     * @static
     * @memberOf _
     * @category Chain
     * @param {*} value The value to wrap.
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36 },
     *   { 'user': 'fred',    'age': 40 },
     *   { 'user': 'pebbles', 'age': 1 }
     * ];
     *
     * var youngest = _.chain(users)
     *   .sortBy('age')
     *   .map(function(chr) {
     *     return chr.user + ' is ' + chr.age;
     *   })
     *   .first()
     *   .value();
     * // => 'pebbles is 1'
     */
    function chain(value) {
      var result = lodash(value);
      result.__chain__ = true;
      return result;
    }

    /**
     * This method invokes `interceptor` and returns `value`. The interceptor is
     * bound to `thisArg` and invoked with one argument; (value). The purpose of
     * this method is to "tap into" a method chain in order to perform operations
     * on intermediate results within the chain.
     *
     * @static
     * @memberOf _
     * @category Chain
     * @param {*} value The value to provide to `interceptor`.
     * @param {Function} interceptor The function to invoke.
     * @param {*} [thisArg] The `this` binding of `interceptor`.
     * @returns {*} Returns `value`.
     * @example
     *
     * _([1, 2, 3])
     *  .tap(function(array) {
     *    array.pop();
     *  })
     *  .reverse()
     *  .value();
     * // => [2, 1]
     */
    function tap(value, interceptor, thisArg) {
      interceptor.call(thisArg, value);
      return value;
    }

    /**
     * This method is like `_.tap` except that it returns the result of `interceptor`.
     *
     * @static
     * @memberOf _
     * @category Chain
     * @param {*} value The value to provide to `interceptor`.
     * @param {Function} interceptor The function to invoke.
     * @param {*} [thisArg] The `this` binding of `interceptor`.
     * @returns {*} Returns the result of `interceptor`.
     * @example
     *
     * _('  abc  ')
     *  .chain()
     *  .trim()
     *  .thru(function(value) {
     *    return [value];
     *  })
     *  .value();
     * // => ['abc']
     */
    function thru(value, interceptor, thisArg) {
      return interceptor.call(thisArg, value);
    }

    /**
     * Enables explicit method chaining on the wrapper object.
     *
     * @name chain
     * @memberOf _
     * @category Chain
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36 },
     *   { 'user': 'fred',   'age': 40 }
     * ];
     *
     * // without explicit chaining
     * _(users).first();
     * // => { 'user': 'barney', 'age': 36 }
     *
     * // with explicit chaining
     * _(users).chain()
     *   .first()
     *   .pick('user')
     *   .value();
     * // => { 'user': 'barney' }
     */
    function wrapperChain() {
      return chain(this);
    }

    /**
     * Executes the chained sequence and returns the wrapped result.
     *
     * @name commit
     * @memberOf _
     * @category Chain
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var array = [1, 2];
     * var wrapped = _(array).push(3);
     *
     * console.log(array);
     * // => [1, 2]
     *
     * wrapped = wrapped.commit();
     * console.log(array);
     * // => [1, 2, 3]
     *
     * wrapped.last();
     * // => 3
     *
     * console.log(array);
     * // => [1, 2, 3]
     */
    function wrapperCommit() {
      return new LodashWrapper(this.value(), this.__chain__);
    }

    /**
     * Creates a new array joining a wrapped array with any additional arrays
     * and/or values.
     *
     * @name concat
     * @memberOf _
     * @category Chain
     * @param {...*} [values] The values to concatenate.
     * @returns {Array} Returns the new concatenated array.
     * @example
     *
     * var array = [1];
     * var wrapped = _(array).concat(2, [3], [[4]]);
     *
     * console.log(wrapped.value());
     * // => [1, 2, 3, [4]]
     *
     * console.log(array);
     * // => [1]
     */
    var wrapperConcat = restParam(function(values) {
      values = baseFlatten(values);
      return this.thru(function(array) {
        return arrayConcat(isArray(array) ? array : [toObject(array)], values);
      });
    });

    /**
     * Creates a clone of the chained sequence planting `value` as the wrapped value.
     *
     * @name plant
     * @memberOf _
     * @category Chain
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var array = [1, 2];
     * var wrapped = _(array).map(function(value) {
     *   return Math.pow(value, 2);
     * });
     *
     * var other = [3, 4];
     * var otherWrapped = wrapped.plant(other);
     *
     * otherWrapped.value();
     * // => [9, 16]
     *
     * wrapped.value();
     * // => [1, 4]
     */
    function wrapperPlant(value) {
      var result,
          parent = this;

      while (parent instanceof baseLodash) {
        var clone = wrapperClone(parent);
        if (result) {
          previous.__wrapped__ = clone;
        } else {
          result = clone;
        }
        var previous = clone;
        parent = parent.__wrapped__;
      }
      previous.__wrapped__ = value;
      return result;
    }

    /**
     * Reverses the wrapped array so the first element becomes the last, the
     * second element becomes the second to last, and so on.
     *
     * **Note:** This method mutates the wrapped array.
     *
     * @name reverse
     * @memberOf _
     * @category Chain
     * @returns {Object} Returns the new reversed `lodash` wrapper instance.
     * @example
     *
     * var array = [1, 2, 3];
     *
     * _(array).reverse().value()
     * // => [3, 2, 1]
     *
     * console.log(array);
     * // => [3, 2, 1]
     */
    function wrapperReverse() {
      var value = this.__wrapped__;

      var interceptor = function(value) {
        return (wrapped && wrapped.__dir__ < 0) ? value : value.reverse();
      };
      if (value instanceof LazyWrapper) {
        var wrapped = value;
        if (this.__actions__.length) {
          wrapped = new LazyWrapper(this);
        }
        wrapped = wrapped.reverse();
        wrapped.__actions__.push({ 'func': thru, 'args': [interceptor], 'thisArg': undefined });
        return new LodashWrapper(wrapped, this.__chain__);
      }
      return this.thru(interceptor);
    }

    /**
     * Produces the result of coercing the unwrapped value to a string.
     *
     * @name toString
     * @memberOf _
     * @category Chain
     * @returns {string} Returns the coerced string value.
     * @example
     *
     * _([1, 2, 3]).toString();
     * // => '1,2,3'
     */
    function wrapperToString() {
      return (this.value() + '');
    }

    /**
     * Executes the chained sequence to extract the unwrapped value.
     *
     * @name value
     * @memberOf _
     * @alias run, toJSON, valueOf
     * @category Chain
     * @returns {*} Returns the resolved unwrapped value.
     * @example
     *
     * _([1, 2, 3]).value();
     * // => [1, 2, 3]
     */
    function wrapperValue() {
      return baseWrapperValue(this.__wrapped__, this.__actions__);
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates an array of elements corresponding to the given keys, or indexes,
     * of `collection`. Keys may be specified as individual arguments or as arrays
     * of keys.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {...(number|number[]|string|string[])} [props] The property names
     *  or indexes of elements to pick, specified individually or in arrays.
     * @returns {Array} Returns the new array of picked elements.
     * @example
     *
     * _.at(['a', 'b', 'c'], [0, 2]);
     * // => ['a', 'c']
     *
     * _.at(['barney', 'fred', 'pebbles'], 0, 2);
     * // => ['barney', 'pebbles']
     */
    var at = restParam(function(collection, props) {
      return baseAt(collection, baseFlatten(props));
    });

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` through `iteratee`. The corresponding value
     * of each key is the number of times the key was returned by `iteratee`.
     * The `iteratee` is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * _.countBy([4.3, 6.1, 6.4], function(n) {
     *   return Math.floor(n);
     * });
     * // => { '4': 1, '6': 2 }
     *
     * _.countBy([4.3, 6.1, 6.4], function(n) {
     *   return this.floor(n);
     * }, Math);
     * // => { '4': 1, '6': 2 }
     *
     * _.countBy(['one', 'two', 'three'], 'length');
     * // => { '3': 2, '5': 1 }
     */
    var countBy = createAggregator(function(result, value, key) {
      hasOwnProperty.call(result, key) ? ++result[key] : (result[key] = 1);
    });

    /**
     * Checks if `predicate` returns truthy for **all** elements of `collection`.
     * The predicate is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @alias all
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {boolean} Returns `true` if all elements pass the predicate check,
     *  else `false`.
     * @example
     *
     * _.every([true, 1, null, 'yes'], Boolean);
     * // => false
     *
     * var users = [
     *   { 'user': 'barney', 'active': false },
     *   { 'user': 'fred',   'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.every(users, { 'user': 'barney', 'active': false });
     * // => false
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.every(users, 'active', false);
     * // => true
     *
     * // using the `_.property` callback shorthand
     * _.every(users, 'active');
     * // => false
     */
    function every(collection, predicate, thisArg) {
      var func = isArray(collection) ? arrayEvery : baseEvery;
      if (thisArg && isIterateeCall(collection, predicate, thisArg)) {
        predicate = undefined;
      }
      if (typeof predicate != 'function' || thisArg !== undefined) {
        predicate = getCallback(predicate, thisArg, 3);
      }
      return func(collection, predicate);
    }

    /**
     * Iterates over elements of `collection`, returning an array of all elements
     * `predicate` returns truthy for. The predicate is bound to `thisArg` and
     * invoked with three arguments: (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @alias select
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the new filtered array.
     * @example
     *
     * _.filter([4, 5, 6], function(n) {
     *   return n % 2 == 0;
     * });
     * // => [4, 6]
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': true },
     *   { 'user': 'fred',   'age': 40, 'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.filter(users, { 'age': 36, 'active': true }), 'user');
     * // => ['barney']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.filter(users, 'active', false), 'user');
     * // => ['fred']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.filter(users, 'active'), 'user');
     * // => ['barney']
     */
    function filter(collection, predicate, thisArg) {
      var func = isArray(collection) ? arrayFilter : baseFilter;
      predicate = getCallback(predicate, thisArg, 3);
      return func(collection, predicate);
    }

    /**
     * Iterates over elements of `collection`, returning the first element
     * `predicate` returns truthy for. The predicate is bound to `thisArg` and
     * invoked with three arguments: (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @alias detect
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36, 'active': true },
     *   { 'user': 'fred',    'age': 40, 'active': false },
     *   { 'user': 'pebbles', 'age': 1,  'active': true }
     * ];
     *
     * _.result(_.find(users, function(chr) {
     *   return chr.age < 40;
     * }), 'user');
     * // => 'barney'
     *
     * // using the `_.matches` callback shorthand
     * _.result(_.find(users, { 'age': 1, 'active': true }), 'user');
     * // => 'pebbles'
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.result(_.find(users, 'active', false), 'user');
     * // => 'fred'
     *
     * // using the `_.property` callback shorthand
     * _.result(_.find(users, 'active'), 'user');
     * // => 'barney'
     */
    var find = createFind(baseEach);

    /**
     * This method is like `_.find` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * _.findLast([1, 2, 3, 4], function(n) {
     *   return n % 2 == 1;
     * });
     * // => 3
     */
    var findLast = createFind(baseEachRight, true);

    /**
     * Performs a deep comparison between each element in `collection` and the
     * source object, returning the first element that has equivalent property
     * values.
     *
     * **Note:** This method supports comparing arrays, booleans, `Date` objects,
     * numbers, `Object` objects, regexes, and strings. Objects are compared by
     * their own, not inherited, enumerable properties. For comparing a single
     * own or inherited property value see `_.matchesProperty`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {Object} source The object of property values to match.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': true },
     *   { 'user': 'fred',   'age': 40, 'active': false }
     * ];
     *
     * _.result(_.findWhere(users, { 'age': 36, 'active': true }), 'user');
     * // => 'barney'
     *
     * _.result(_.findWhere(users, { 'age': 40, 'active': false }), 'user');
     * // => 'fred'
     */
    function findWhere(collection, source) {
      return find(collection, baseMatches(source));
    }

    /**
     * Iterates over elements of `collection` invoking `iteratee` for each element.
     * The `iteratee` is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection). Iteratee functions may exit iteration early
     * by explicitly returning `false`.
     *
     * **Note:** As with other "Collections" methods, objects with a "length" property
     * are iterated like arrays. To avoid this behavior `_.forIn` or `_.forOwn`
     * may be used for object iteration.
     *
     * @static
     * @memberOf _
     * @alias each
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array|Object|string} Returns `collection`.
     * @example
     *
     * _([1, 2]).forEach(function(n) {
     *   console.log(n);
     * }).value();
     * // => logs each value from left to right and returns the array
     *
     * _.forEach({ 'a': 1, 'b': 2 }, function(n, key) {
     *   console.log(n, key);
     * });
     * // => logs each value-key pair and returns the object (iteration order is not guaranteed)
     */
    var forEach = createForEach(arrayEach, baseEach);

    /**
     * This method is like `_.forEach` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @alias eachRight
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array|Object|string} Returns `collection`.
     * @example
     *
     * _([1, 2]).forEachRight(function(n) {
     *   console.log(n);
     * }).value();
     * // => logs each value from right to left and returns the array
     */
    var forEachRight = createForEach(arrayEachRight, baseEachRight);

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` through `iteratee`. The corresponding value
     * of each key is an array of the elements responsible for generating the key.
     * The `iteratee` is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * _.groupBy([4.2, 6.1, 6.4], function(n) {
     *   return Math.floor(n);
     * });
     * // => { '4': [4.2], '6': [6.1, 6.4] }
     *
     * _.groupBy([4.2, 6.1, 6.4], function(n) {
     *   return this.floor(n);
     * }, Math);
     * // => { '4': [4.2], '6': [6.1, 6.4] }
     *
     * // using the `_.property` callback shorthand
     * _.groupBy(['one', 'two', 'three'], 'length');
     * // => { '3': ['one', 'two'], '5': ['three'] }
     */
    var groupBy = createAggregator(function(result, value, key) {
      if (hasOwnProperty.call(result, key)) {
        result[key].push(value);
      } else {
        result[key] = [value];
      }
    });

    /**
     * Checks if `value` is in `collection` using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
     * for equality comparisons. If `fromIndex` is negative, it is used as the offset
     * from the end of `collection`.
     *
     * @static
     * @memberOf _
     * @alias contains, include
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {*} target The value to search for.
     * @param {number} [fromIndex=0] The index to search from.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.reduce`.
     * @returns {boolean} Returns `true` if a matching element is found, else `false`.
     * @example
     *
     * _.includes([1, 2, 3], 1);
     * // => true
     *
     * _.includes([1, 2, 3], 1, 2);
     * // => false
     *
     * _.includes({ 'user': 'fred', 'age': 40 }, 'fred');
     * // => true
     *
     * _.includes('pebbles', 'eb');
     * // => true
     */
    function includes(collection, target, fromIndex, guard) {
      var length = collection ? getLength(collection) : 0;
      if (!isLength(length)) {
        collection = values(collection);
        length = collection.length;
      }
      if (typeof fromIndex != 'number' || (guard && isIterateeCall(target, fromIndex, guard))) {
        fromIndex = 0;
      } else {
        fromIndex = fromIndex < 0 ? nativeMax(length + fromIndex, 0) : (fromIndex || 0);
      }
      return (typeof collection == 'string' || !isArray(collection) && isString(collection))
        ? (fromIndex <= length && collection.indexOf(target, fromIndex) > -1)
        : (!!length && getIndexOf(collection, target, fromIndex) > -1);
    }

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` through `iteratee`. The corresponding value
     * of each key is the last element responsible for generating the key. The
     * iteratee function is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * var keyData = [
     *   { 'dir': 'left', 'code': 97 },
     *   { 'dir': 'right', 'code': 100 }
     * ];
     *
     * _.indexBy(keyData, 'dir');
     * // => { 'left': { 'dir': 'left', 'code': 97 }, 'right': { 'dir': 'right', 'code': 100 } }
     *
     * _.indexBy(keyData, function(object) {
     *   return String.fromCharCode(object.code);
     * });
     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
     *
     * _.indexBy(keyData, function(object) {
     *   return this.fromCharCode(object.code);
     * }, String);
     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
     */
    var indexBy = createAggregator(function(result, value, key) {
      result[key] = value;
    });

    /**
     * Invokes the method at `path` of each element in `collection`, returning
     * an array of the results of each invoked method. Any additional arguments
     * are provided to each invoked method. If `methodName` is a function it is
     * invoked for, and `this` bound to, each element in `collection`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Array|Function|string} path The path of the method to invoke or
     *  the function invoked per iteration.
     * @param {...*} [args] The arguments to invoke the method with.
     * @returns {Array} Returns the array of results.
     * @example
     *
     * _.invoke([[5, 1, 7], [3, 2, 1]], 'sort');
     * // => [[1, 5, 7], [1, 2, 3]]
     *
     * _.invoke([123, 456], String.prototype.split, '');
     * // => [['1', '2', '3'], ['4', '5', '6']]
     */
    var invoke = restParam(function(collection, path, args) {
      var index = -1,
          isFunc = typeof path == 'function',
          isProp = isKey(path),
          result = isArrayLike(collection) ? Array(collection.length) : [];

      baseEach(collection, function(value) {
        var func = isFunc ? path : ((isProp && value != null) ? value[path] : undefined);
        result[++index] = func ? func.apply(value, args) : invokePath(value, path, args);
      });
      return result;
    });

    /**
     * Creates an array of values by running each element in `collection` through
     * `iteratee`. The `iteratee` is bound to `thisArg` and invoked with three
     * arguments: (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * Many lodash methods are guarded to work as iteratees for methods like
     * `_.every`, `_.filter`, `_.map`, `_.mapValues`, `_.reject`, and `_.some`.
     *
     * The guarded methods are:
     * `ary`, `callback`, `chunk`, `clone`, `create`, `curry`, `curryRight`,
     * `drop`, `dropRight`, `every`, `fill`, `flatten`, `invert`, `max`, `min`,
     * `parseInt`, `slice`, `sortBy`, `take`, `takeRight`, `template`, `trim`,
     * `trimLeft`, `trimRight`, `trunc`, `random`, `range`, `sample`, `some`,
     * `sum`, `uniq`, and `words`
     *
     * @static
     * @memberOf _
     * @alias collect
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array} Returns the new mapped array.
     * @example
     *
     * function timesThree(n) {
     *   return n * 3;
     * }
     *
     * _.map([1, 2], timesThree);
     * // => [3, 6]
     *
     * _.map({ 'a': 1, 'b': 2 }, timesThree);
     * // => [3, 6] (iteration order is not guaranteed)
     *
     * var users = [
     *   { 'user': 'barney' },
     *   { 'user': 'fred' }
     * ];
     *
     * // using the `_.property` callback shorthand
     * _.map(users, 'user');
     * // => ['barney', 'fred']
     */
    function map(collection, iteratee, thisArg) {
      var func = isArray(collection) ? arrayMap : baseMap;
      iteratee = getCallback(iteratee, thisArg, 3);
      return func(collection, iteratee);
    }

    /**
     * Creates an array of elements split into two groups, the first of which
     * contains elements `predicate` returns truthy for, while the second of which
     * contains elements `predicate` returns falsey for. The predicate is bound
     * to `thisArg` and invoked with three arguments: (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the array of grouped elements.
     * @example
     *
     * _.partition([1, 2, 3], function(n) {
     *   return n % 2;
     * });
     * // => [[1, 3], [2]]
     *
     * _.partition([1.2, 2.3, 3.4], function(n) {
     *   return this.floor(n) % 2;
     * }, Math);
     * // => [[1.2, 3.4], [2.3]]
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36, 'active': false },
     *   { 'user': 'fred',    'age': 40, 'active': true },
     *   { 'user': 'pebbles', 'age': 1,  'active': false }
     * ];
     *
     * var mapper = function(array) {
     *   return _.pluck(array, 'user');
     * };
     *
     * // using the `_.matches` callback shorthand
     * _.map(_.partition(users, { 'age': 1, 'active': false }), mapper);
     * // => [['pebbles'], ['barney', 'fred']]
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.map(_.partition(users, 'active', false), mapper);
     * // => [['barney', 'pebbles'], ['fred']]
     *
     * // using the `_.property` callback shorthand
     * _.map(_.partition(users, 'active'), mapper);
     * // => [['fred'], ['barney', 'pebbles']]
     */
    var partition = createAggregator(function(result, value, key) {
      result[key ? 0 : 1].push(value);
    }, function() { return [[], []]; });

    /**
     * Gets the property value of `path` from all elements in `collection`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Array|string} path The path of the property to pluck.
     * @returns {Array} Returns the property values.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36 },
     *   { 'user': 'fred',   'age': 40 }
     * ];
     *
     * _.pluck(users, 'user');
     * // => ['barney', 'fred']
     *
     * var userIndex = _.indexBy(users, 'user');
     * _.pluck(userIndex, 'age');
     * // => [36, 40] (iteration order is not guaranteed)
     */
    function pluck(collection, path) {
      return map(collection, property(path));
    }

    /**
     * Reduces `collection` to a value which is the accumulated result of running
     * each element in `collection` through `iteratee`, where each successive
     * invocation is supplied the return value of the previous. If `accumulator`
     * is not provided the first element of `collection` is used as the initial
     * value. The `iteratee` is bound to `thisArg` and invoked with four arguments:
     * (accumulator, value, index|key, collection).
     *
     * Many lodash methods are guarded to work as iteratees for methods like
     * `_.reduce`, `_.reduceRight`, and `_.transform`.
     *
     * The guarded methods are:
     * `assign`, `defaults`, `defaultsDeep`, `includes`, `merge`, `sortByAll`,
     * and `sortByOrder`
     *
     * @static
     * @memberOf _
     * @alias foldl, inject
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * _.reduce([1, 2], function(total, n) {
     *   return total + n;
     * });
     * // => 3
     *
     * _.reduce({ 'a': 1, 'b': 2 }, function(result, n, key) {
     *   result[key] = n * 3;
     *   return result;
     * }, {});
     * // => { 'a': 3, 'b': 6 } (iteration order is not guaranteed)
     */
    var reduce = createReduce(arrayReduce, baseEach);

    /**
     * This method is like `_.reduce` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @alias foldr
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * var array = [[0, 1], [2, 3], [4, 5]];
     *
     * _.reduceRight(array, function(flattened, other) {
     *   return flattened.concat(other);
     * }, []);
     * // => [4, 5, 2, 3, 0, 1]
     */
    var reduceRight = createReduce(arrayReduceRight, baseEachRight);

    /**
     * The opposite of `_.filter`; this method returns the elements of `collection`
     * that `predicate` does **not** return truthy for.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Array} Returns the new filtered array.
     * @example
     *
     * _.reject([1, 2, 3, 4], function(n) {
     *   return n % 2 == 0;
     * });
     * // => [1, 3]
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': false },
     *   { 'user': 'fred',   'age': 40, 'active': true }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.pluck(_.reject(users, { 'age': 40, 'active': true }), 'user');
     * // => ['barney']
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.pluck(_.reject(users, 'active', false), 'user');
     * // => ['fred']
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.reject(users, 'active'), 'user');
     * // => ['barney']
     */
    function reject(collection, predicate, thisArg) {
      var func = isArray(collection) ? arrayFilter : baseFilter;
      predicate = getCallback(predicate, thisArg, 3);
      return func(collection, function(value, index, collection) {
        return !predicate(value, index, collection);
      });
    }

    /**
     * Gets a random element or `n` random elements from a collection.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to sample.
     * @param {number} [n] The number of elements to sample.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {*} Returns the random sample(s).
     * @example
     *
     * _.sample([1, 2, 3, 4]);
     * // => 2
     *
     * _.sample([1, 2, 3, 4], 2);
     * // => [3, 1]
     */
    function sample(collection, n, guard) {
      if (guard ? isIterateeCall(collection, n, guard) : n == null) {
        collection = toIterable(collection);
        var length = collection.length;
        return length > 0 ? collection[baseRandom(0, length - 1)] : undefined;
      }
      var index = -1,
          result = toArray(collection),
          length = result.length,
          lastIndex = length - 1;

      n = nativeMin(n < 0 ? 0 : (+n || 0), length);
      while (++index < n) {
        var rand = baseRandom(index, lastIndex),
            value = result[rand];

        result[rand] = result[index];
        result[index] = value;
      }
      result.length = n;
      return result;
    }

    /**
     * Creates an array of shuffled values, using a version of the
     * [Fisher-Yates shuffle](https://en.wikipedia.org/wiki/Fisher-Yates_shuffle).
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to shuffle.
     * @returns {Array} Returns the new shuffled array.
     * @example
     *
     * _.shuffle([1, 2, 3, 4]);
     * // => [4, 1, 3, 2]
     */
    function shuffle(collection) {
      return sample(collection, POSITIVE_INFINITY);
    }

    /**
     * Gets the size of `collection` by returning its length for array-like
     * values or the number of own enumerable properties for objects.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to inspect.
     * @returns {number} Returns the size of `collection`.
     * @example
     *
     * _.size([1, 2, 3]);
     * // => 3
     *
     * _.size({ 'a': 1, 'b': 2 });
     * // => 2
     *
     * _.size('pebbles');
     * // => 7
     */
    function size(collection) {
      var length = collection ? getLength(collection) : 0;
      return isLength(length) ? length : keys(collection).length;
    }

    /**
     * Checks if `predicate` returns truthy for **any** element of `collection`.
     * The function returns as soon as it finds a passing value and does not iterate
     * over the entire collection. The predicate is bound to `thisArg` and invoked
     * with three arguments: (value, index|key, collection).
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @alias any
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     * @example
     *
     * _.some([null, 0, 'yes', false], Boolean);
     * // => true
     *
     * var users = [
     *   { 'user': 'barney', 'active': true },
     *   { 'user': 'fred',   'active': false }
     * ];
     *
     * // using the `_.matches` callback shorthand
     * _.some(users, { 'user': 'barney', 'active': false });
     * // => false
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.some(users, 'active', false);
     * // => true
     *
     * // using the `_.property` callback shorthand
     * _.some(users, 'active');
     * // => true
     */
    function some(collection, predicate, thisArg) {
      var func = isArray(collection) ? arraySome : baseSome;
      if (thisArg && isIterateeCall(collection, predicate, thisArg)) {
        predicate = undefined;
      }
      if (typeof predicate != 'function' || thisArg !== undefined) {
        predicate = getCallback(predicate, thisArg, 3);
      }
      return func(collection, predicate);
    }

    /**
     * Creates an array of elements, sorted in ascending order by the results of
     * running each element in a collection through `iteratee`. This method performs
     * a stable sort, that is, it preserves the original sort order of equal elements.
     * The `iteratee` is bound to `thisArg` and invoked with three arguments:
     * (value, index|key, collection).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Array} Returns the new sorted array.
     * @example
     *
     * _.sortBy([1, 2, 3], function(n) {
     *   return Math.sin(n);
     * });
     * // => [3, 1, 2]
     *
     * _.sortBy([1, 2, 3], function(n) {
     *   return this.sin(n);
     * }, Math);
     * // => [3, 1, 2]
     *
     * var users = [
     *   { 'user': 'fred' },
     *   { 'user': 'pebbles' },
     *   { 'user': 'barney' }
     * ];
     *
     * // using the `_.property` callback shorthand
     * _.pluck(_.sortBy(users, 'user'), 'user');
     * // => ['barney', 'fred', 'pebbles']
     */
    function sortBy(collection, iteratee, thisArg) {
      if (collection == null) {
        return [];
      }
      if (thisArg && isIterateeCall(collection, iteratee, thisArg)) {
        iteratee = undefined;
      }
      var index = -1;
      iteratee = getCallback(iteratee, thisArg, 3);

      var result = baseMap(collection, function(value, key, collection) {
        return { 'criteria': iteratee(value, key, collection), 'index': ++index, 'value': value };
      });
      return baseSortBy(result, compareAscending);
    }

    /**
     * This method is like `_.sortBy` except that it can sort by multiple iteratees
     * or property names.
     *
     * If a property name is provided for an iteratee the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If an object is provided for an iteratee the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {...(Function|Function[]|Object|Object[]|string|string[])} iteratees
     *  The iteratees to sort by, specified as individual values or arrays of values.
     * @returns {Array} Returns the new sorted array.
     * @example
     *
     * var users = [
     *   { 'user': 'fred',   'age': 48 },
     *   { 'user': 'barney', 'age': 36 },
     *   { 'user': 'fred',   'age': 42 },
     *   { 'user': 'barney', 'age': 34 }
     * ];
     *
     * _.map(_.sortByAll(users, ['user', 'age']), _.values);
     * // => [['barney', 34], ['barney', 36], ['fred', 42], ['fred', 48]]
     *
     * _.map(_.sortByAll(users, 'user', function(chr) {
     *   return Math.floor(chr.age / 10);
     * }), _.values);
     * // => [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 42]]
     */
    var sortByAll = restParam(function(collection, iteratees) {
      if (collection == null) {
        return [];
      }
      var guard = iteratees[2];
      if (guard && isIterateeCall(iteratees[0], iteratees[1], guard)) {
        iteratees.length = 1;
      }
      return baseSortByOrder(collection, baseFlatten(iteratees), []);
    });

    /**
     * This method is like `_.sortByAll` except that it allows specifying the
     * sort orders of the iteratees to sort by. If `orders` is unspecified, all
     * values are sorted in ascending order. Otherwise, a value is sorted in
     * ascending order if its corresponding order is "asc", and descending if "desc".
     *
     * If a property name is provided for an iteratee the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If an object is provided for an iteratee the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
     * @param {boolean[]} [orders] The sort orders of `iteratees`.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.reduce`.
     * @returns {Array} Returns the new sorted array.
     * @example
     *
     * var users = [
     *   { 'user': 'fred',   'age': 48 },
     *   { 'user': 'barney', 'age': 34 },
     *   { 'user': 'fred',   'age': 42 },
     *   { 'user': 'barney', 'age': 36 }
     * ];
     *
     * // sort by `user` in ascending order and by `age` in descending order
     * _.map(_.sortByOrder(users, ['user', 'age'], ['asc', 'desc']), _.values);
     * // => [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 42]]
     */
    function sortByOrder(collection, iteratees, orders, guard) {
      if (collection == null) {
        return [];
      }
      if (guard && isIterateeCall(iteratees, orders, guard)) {
        orders = undefined;
      }
      if (!isArray(iteratees)) {
        iteratees = iteratees == null ? [] : [iteratees];
      }
      if (!isArray(orders)) {
        orders = orders == null ? [] : [orders];
      }
      return baseSortByOrder(collection, iteratees, orders);
    }

    /**
     * Performs a deep comparison between each element in `collection` and the
     * source object, returning an array of all elements that have equivalent
     * property values.
     *
     * **Note:** This method supports comparing arrays, booleans, `Date` objects,
     * numbers, `Object` objects, regexes, and strings. Objects are compared by
     * their own, not inherited, enumerable properties. For comparing a single
     * own or inherited property value see `_.matchesProperty`.
     *
     * @static
     * @memberOf _
     * @category Collection
     * @param {Array|Object|string} collection The collection to search.
     * @param {Object} source The object of property values to match.
     * @returns {Array} Returns the new filtered array.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': false, 'pets': ['hoppy'] },
     *   { 'user': 'fred',   'age': 40, 'active': true, 'pets': ['baby puss', 'dino'] }
     * ];
     *
     * _.pluck(_.where(users, { 'age': 36, 'active': false }), 'user');
     * // => ['barney']
     *
     * _.pluck(_.where(users, { 'pets': ['dino'] }), 'user');
     * // => ['fred']
     */
    function where(collection, source) {
      return filter(collection, baseMatches(source));
    }

    /*------------------------------------------------------------------------*/

    /**
     * Gets the number of milliseconds that have elapsed since the Unix epoch
     * (1 January 1970 00:00:00 UTC).
     *
     * @static
     * @memberOf _
     * @category Date
     * @example
     *
     * _.defer(function(stamp) {
     *   console.log(_.now() - stamp);
     * }, _.now());
     * // => logs the number of milliseconds it took for the deferred function to be invoked
     */
    var now = nativeNow || function() {
      return new Date().getTime();
    };

    /*------------------------------------------------------------------------*/

    /**
     * The opposite of `_.before`; this method creates a function that invokes
     * `func` once it is called `n` or more times.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {number} n The number of calls before `func` is invoked.
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new restricted function.
     * @example
     *
     * var saves = ['profile', 'settings'];
     *
     * var done = _.after(saves.length, function() {
     *   console.log('done saving!');
     * });
     *
     * _.forEach(saves, function(type) {
     *   asyncSave({ 'type': type, 'complete': done });
     * });
     * // => logs 'done saving!' after the two async saves have completed
     */
    function after(n, func) {
      if (typeof func != 'function') {
        if (typeof n == 'function') {
          var temp = n;
          n = func;
          func = temp;
        } else {
          throw new TypeError(FUNC_ERROR_TEXT);
        }
      }
      n = nativeIsFinite(n = +n) ? n : 0;
      return function() {
        if (--n < 1) {
          return func.apply(this, arguments);
        }
      };
    }

    /**
     * Creates a function that accepts up to `n` arguments ignoring any
     * additional arguments.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to cap arguments for.
     * @param {number} [n=func.length] The arity cap.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Function} Returns the new function.
     * @example
     *
     * _.map(['6', '8', '10'], _.ary(parseInt, 1));
     * // => [6, 8, 10]
     */
    function ary(func, n, guard) {
      if (guard && isIterateeCall(func, n, guard)) {
        n = undefined;
      }
      n = (func && n == null) ? func.length : nativeMax(+n || 0, 0);
      return createWrapper(func, ARY_FLAG, undefined, undefined, undefined, undefined, n);
    }

    /**
     * Creates a function that invokes `func`, with the `this` binding and arguments
     * of the created function, while it is called less than `n` times. Subsequent
     * calls to the created function return the result of the last `func` invocation.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {number} n The number of calls at which `func` is no longer invoked.
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new restricted function.
     * @example
     *
     * jQuery('#add').on('click', _.before(5, addContactToList));
     * // => allows adding up to 4 contacts to the list
     */
    function before(n, func) {
      var result;
      if (typeof func != 'function') {
        if (typeof n == 'function') {
          var temp = n;
          n = func;
          func = temp;
        } else {
          throw new TypeError(FUNC_ERROR_TEXT);
        }
      }
      return function() {
        if (--n > 0) {
          result = func.apply(this, arguments);
        }
        if (n <= 1) {
          func = undefined;
        }
        return result;
      };
    }

    /**
     * Creates a function that invokes `func` with the `this` binding of `thisArg`
     * and prepends any additional `_.bind` arguments to those provided to the
     * bound function.
     *
     * The `_.bind.placeholder` value, which defaults to `_` in monolithic builds,
     * may be used as a placeholder for partially applied arguments.
     *
     * **Note:** Unlike native `Function#bind` this method does not set the "length"
     * property of bound functions.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to bind.
     * @param {*} thisArg The `this` binding of `func`.
     * @param {...*} [partials] The arguments to be partially applied.
     * @returns {Function} Returns the new bound function.
     * @example
     *
     * var greet = function(greeting, punctuation) {
     *   return greeting + ' ' + this.user + punctuation;
     * };
     *
     * var object = { 'user': 'fred' };
     *
     * var bound = _.bind(greet, object, 'hi');
     * bound('!');
     * // => 'hi fred!'
     *
     * // using placeholders
     * var bound = _.bind(greet, object, _, '!');
     * bound('hi');
     * // => 'hi fred!'
     */
    var bind = restParam(function(func, thisArg, partials) {
      var bitmask = BIND_FLAG;
      if (partials.length) {
        var holders = replaceHolders(partials, bind.placeholder);
        bitmask |= PARTIAL_FLAG;
      }
      return createWrapper(func, bitmask, thisArg, partials, holders);
    });

    /**
     * Binds methods of an object to the object itself, overwriting the existing
     * method. Method names may be specified as individual arguments or as arrays
     * of method names. If no method names are provided all enumerable function
     * properties, own and inherited, of `object` are bound.
     *
     * **Note:** This method does not set the "length" property of bound functions.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Object} object The object to bind and assign the bound methods to.
     * @param {...(string|string[])} [methodNames] The object method names to bind,
     *  specified as individual method names or arrays of method names.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var view = {
     *   'label': 'docs',
     *   'onClick': function() {
     *     console.log('clicked ' + this.label);
     *   }
     * };
     *
     * _.bindAll(view);
     * jQuery('#docs').on('click', view.onClick);
     * // => logs 'clicked docs' when the element is clicked
     */
    var bindAll = restParam(function(object, methodNames) {
      methodNames = methodNames.length ? baseFlatten(methodNames) : functions(object);

      var index = -1,
          length = methodNames.length;

      while (++index < length) {
        var key = methodNames[index];
        object[key] = createWrapper(object[key], BIND_FLAG, object);
      }
      return object;
    });

    /**
     * Creates a function that invokes the method at `object[key]` and prepends
     * any additional `_.bindKey` arguments to those provided to the bound function.
     *
     * This method differs from `_.bind` by allowing bound functions to reference
     * methods that may be redefined or don't yet exist.
     * See [Peter Michaux's article](http://peter.michaux.ca/articles/lazy-function-definition-pattern)
     * for more details.
     *
     * The `_.bindKey.placeholder` value, which defaults to `_` in monolithic
     * builds, may be used as a placeholder for partially applied arguments.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Object} object The object the method belongs to.
     * @param {string} key The key of the method.
     * @param {...*} [partials] The arguments to be partially applied.
     * @returns {Function} Returns the new bound function.
     * @example
     *
     * var object = {
     *   'user': 'fred',
     *   'greet': function(greeting, punctuation) {
     *     return greeting + ' ' + this.user + punctuation;
     *   }
     * };
     *
     * var bound = _.bindKey(object, 'greet', 'hi');
     * bound('!');
     * // => 'hi fred!'
     *
     * object.greet = function(greeting, punctuation) {
     *   return greeting + 'ya ' + this.user + punctuation;
     * };
     *
     * bound('!');
     * // => 'hiya fred!'
     *
     * // using placeholders
     * var bound = _.bindKey(object, 'greet', _, '!');
     * bound('hi');
     * // => 'hiya fred!'
     */
    var bindKey = restParam(function(object, key, partials) {
      var bitmask = BIND_FLAG | BIND_KEY_FLAG;
      if (partials.length) {
        var holders = replaceHolders(partials, bindKey.placeholder);
        bitmask |= PARTIAL_FLAG;
      }
      return createWrapper(key, bitmask, object, partials, holders);
    });

    /**
     * Creates a function that accepts one or more arguments of `func` that when
     * called either invokes `func` returning its result, if all `func` arguments
     * have been provided, or returns a function that accepts one or more of the
     * remaining `func` arguments, and so on. The arity of `func` may be specified
     * if `func.length` is not sufficient.
     *
     * The `_.curry.placeholder` value, which defaults to `_` in monolithic builds,
     * may be used as a placeholder for provided arguments.
     *
     * **Note:** This method does not set the "length" property of curried functions.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to curry.
     * @param {number} [arity=func.length] The arity of `func`.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Function} Returns the new curried function.
     * @example
     *
     * var abc = function(a, b, c) {
     *   return [a, b, c];
     * };
     *
     * var curried = _.curry(abc);
     *
     * curried(1)(2)(3);
     * // => [1, 2, 3]
     *
     * curried(1, 2)(3);
     * // => [1, 2, 3]
     *
     * curried(1, 2, 3);
     * // => [1, 2, 3]
     *
     * // using placeholders
     * curried(1)(_, 3)(2);
     * // => [1, 2, 3]
     */
    var curry = createCurry(CURRY_FLAG);

    /**
     * This method is like `_.curry` except that arguments are applied to `func`
     * in the manner of `_.partialRight` instead of `_.partial`.
     *
     * The `_.curryRight.placeholder` value, which defaults to `_` in monolithic
     * builds, may be used as a placeholder for provided arguments.
     *
     * **Note:** This method does not set the "length" property of curried functions.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to curry.
     * @param {number} [arity=func.length] The arity of `func`.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Function} Returns the new curried function.
     * @example
     *
     * var abc = function(a, b, c) {
     *   return [a, b, c];
     * };
     *
     * var curried = _.curryRight(abc);
     *
     * curried(3)(2)(1);
     * // => [1, 2, 3]
     *
     * curried(2, 3)(1);
     * // => [1, 2, 3]
     *
     * curried(1, 2, 3);
     * // => [1, 2, 3]
     *
     * // using placeholders
     * curried(3)(1, _)(2);
     * // => [1, 2, 3]
     */
    var curryRight = createCurry(CURRY_RIGHT_FLAG);

    /**
     * Creates a debounced function that delays invoking `func` until after `wait`
     * milliseconds have elapsed since the last time the debounced function was
     * invoked. The debounced function comes with a `cancel` method to cancel
     * delayed invocations. Provide an options object to indicate that `func`
     * should be invoked on the leading and/or trailing edge of the `wait` timeout.
     * Subsequent calls to the debounced function return the result of the last
     * `func` invocation.
     *
     * **Note:** If `leading` and `trailing` options are `true`, `func` is invoked
     * on the trailing edge of the timeout only if the the debounced function is
     * invoked more than once during the `wait` timeout.
     *
     * See [David Corbacho's article](http://drupalmotion.com/article/debounce-and-throttle-visual-explanation)
     * for details over the differences between `_.debounce` and `_.throttle`.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to debounce.
     * @param {number} [wait=0] The number of milliseconds to delay.
     * @param {Object} [options] The options object.
     * @param {boolean} [options.leading=false] Specify invoking on the leading
     *  edge of the timeout.
     * @param {number} [options.maxWait] The maximum time `func` is allowed to be
     *  delayed before it is invoked.
     * @param {boolean} [options.trailing=true] Specify invoking on the trailing
     *  edge of the timeout.
     * @returns {Function} Returns the new debounced function.
     * @example
     *
     * // avoid costly calculations while the window size is in flux
     * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
     *
     * // invoke `sendMail` when the click event is fired, debouncing subsequent calls
     * jQuery('#postbox').on('click', _.debounce(sendMail, 300, {
     *   'leading': true,
     *   'trailing': false
     * }));
     *
     * // ensure `batchLog` is invoked once after 1 second of debounced calls
     * var source = new EventSource('/stream');
     * jQuery(source).on('message', _.debounce(batchLog, 250, {
     *   'maxWait': 1000
     * }));
     *
     * // cancel a debounced call
     * var todoChanges = _.debounce(batchLog, 1000);
     * Object.observe(models.todo, todoChanges);
     *
     * Object.observe(models, function(changes) {
     *   if (_.find(changes, { 'user': 'todo', 'type': 'delete'})) {
     *     todoChanges.cancel();
     *   }
     * }, ['delete']);
     *
     * // ...at some point `models.todo` is changed
     * models.todo.completed = true;
     *
     * // ...before 1 second has passed `models.todo` is deleted
     * // which cancels the debounced `todoChanges` call
     * delete models.todo;
     */
    function debounce(func, wait, options) {
      var args,
          maxTimeoutId,
          result,
          stamp,
          thisArg,
          timeoutId,
          trailingCall,
          lastCalled = 0,
          maxWait = false,
          trailing = true;

      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      wait = wait < 0 ? 0 : (+wait || 0);
      if (options === true) {
        var leading = true;
        trailing = false;
      } else if (isObject(options)) {
        leading = !!options.leading;
        maxWait = 'maxWait' in options && nativeMax(+options.maxWait || 0, wait);
        trailing = 'trailing' in options ? !!options.trailing : trailing;
      }

      function cancel() {
        if (timeoutId) {
          clearTimeout(timeoutId);
        }
        if (maxTimeoutId) {
          clearTimeout(maxTimeoutId);
        }
        lastCalled = 0;
        maxTimeoutId = timeoutId = trailingCall = undefined;
      }

      function complete(isCalled, id) {
        if (id) {
          clearTimeout(id);
        }
        maxTimeoutId = timeoutId = trailingCall = undefined;
        if (isCalled) {
          lastCalled = now();
          result = func.apply(thisArg, args);
          if (!timeoutId && !maxTimeoutId) {
            args = thisArg = undefined;
          }
        }
      }

      function delayed() {
        var remaining = wait - (now() - stamp);
        if (remaining <= 0 || remaining > wait) {
          complete(trailingCall, maxTimeoutId);
        } else {
          timeoutId = setTimeout(delayed, remaining);
        }
      }

      function maxDelayed() {
        complete(trailing, timeoutId);
      }

      function debounced() {
        args = arguments;
        stamp = now();
        thisArg = this;
        trailingCall = trailing && (timeoutId || !leading);

        if (maxWait === false) {
          var leadingCall = leading && !timeoutId;
        } else {
          if (!maxTimeoutId && !leading) {
            lastCalled = stamp;
          }
          var remaining = maxWait - (stamp - lastCalled),
              isCalled = remaining <= 0 || remaining > maxWait;

          if (isCalled) {
            if (maxTimeoutId) {
              maxTimeoutId = clearTimeout(maxTimeoutId);
            }
            lastCalled = stamp;
            result = func.apply(thisArg, args);
          }
          else if (!maxTimeoutId) {
            maxTimeoutId = setTimeout(maxDelayed, remaining);
          }
        }
        if (isCalled && timeoutId) {
          timeoutId = clearTimeout(timeoutId);
        }
        else if (!timeoutId && wait !== maxWait) {
          timeoutId = setTimeout(delayed, wait);
        }
        if (leadingCall) {
          isCalled = true;
          result = func.apply(thisArg, args);
        }
        if (isCalled && !timeoutId && !maxTimeoutId) {
          args = thisArg = undefined;
        }
        return result;
      }
      debounced.cancel = cancel;
      return debounced;
    }

    /**
     * Defers invoking the `func` until the current call stack has cleared. Any
     * additional arguments are provided to `func` when it is invoked.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to defer.
     * @param {...*} [args] The arguments to invoke the function with.
     * @returns {number} Returns the timer id.
     * @example
     *
     * _.defer(function(text) {
     *   console.log(text);
     * }, 'deferred');
     * // logs 'deferred' after one or more milliseconds
     */
    var defer = restParam(function(func, args) {
      return baseDelay(func, 1, args);
    });

    /**
     * Invokes `func` after `wait` milliseconds. Any additional arguments are
     * provided to `func` when it is invoked.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay invocation.
     * @param {...*} [args] The arguments to invoke the function with.
     * @returns {number} Returns the timer id.
     * @example
     *
     * _.delay(function(text) {
     *   console.log(text);
     * }, 1000, 'later');
     * // => logs 'later' after one second
     */
    var delay = restParam(function(func, wait, args) {
      return baseDelay(func, wait, args);
    });

    /**
     * Creates a function that returns the result of invoking the provided
     * functions with the `this` binding of the created function, where each
     * successive invocation is supplied the return value of the previous.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {...Function} [funcs] Functions to invoke.
     * @returns {Function} Returns the new function.
     * @example
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * var addSquare = _.flow(_.add, square);
     * addSquare(1, 2);
     * // => 9
     */
    var flow = createFlow();

    /**
     * This method is like `_.flow` except that it creates a function that
     * invokes the provided functions from right to left.
     *
     * @static
     * @memberOf _
     * @alias backflow, compose
     * @category Function
     * @param {...Function} [funcs] Functions to invoke.
     * @returns {Function} Returns the new function.
     * @example
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * var addSquare = _.flowRight(square, _.add);
     * addSquare(1, 2);
     * // => 9
     */
    var flowRight = createFlow(true);

    /**
     * Creates a function that memoizes the result of `func`. If `resolver` is
     * provided it determines the cache key for storing the result based on the
     * arguments provided to the memoized function. By default, the first argument
     * provided to the memoized function is coerced to a string and used as the
     * cache key. The `func` is invoked with the `this` binding of the memoized
     * function.
     *
     * **Note:** The cache is exposed as the `cache` property on the memoized
     * function. Its creation may be customized by replacing the `_.memoize.Cache`
     * constructor with one whose instances implement the [`Map`](http://ecma-international.org/ecma-262/6.0/#sec-properties-of-the-map-prototype-object)
     * method interface of `get`, `has`, and `set`.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to have its output memoized.
     * @param {Function} [resolver] The function to resolve the cache key.
     * @returns {Function} Returns the new memoizing function.
     * @example
     *
     * var upperCase = _.memoize(function(string) {
     *   return string.toUpperCase();
     * });
     *
     * upperCase('fred');
     * // => 'FRED'
     *
     * // modifying the result cache
     * upperCase.cache.set('fred', 'BARNEY');
     * upperCase('fred');
     * // => 'BARNEY'
     *
     * // replacing `_.memoize.Cache`
     * var object = { 'user': 'fred' };
     * var other = { 'user': 'barney' };
     * var identity = _.memoize(_.identity);
     *
     * identity(object);
     * // => { 'user': 'fred' }
     * identity(other);
     * // => { 'user': 'fred' }
     *
     * _.memoize.Cache = WeakMap;
     * var identity = _.memoize(_.identity);
     *
     * identity(object);
     * // => { 'user': 'fred' }
     * identity(other);
     * // => { 'user': 'barney' }
     */
    function memoize(func, resolver) {
      if (typeof func != 'function' || (resolver && typeof resolver != 'function')) {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var memoized = function() {
        var args = arguments,
            key = resolver ? resolver.apply(this, args) : args[0],
            cache = memoized.cache;

        if (cache.has(key)) {
          return cache.get(key);
        }
        var result = func.apply(this, args);
        memoized.cache = cache.set(key, result);
        return result;
      };
      memoized.cache = new memoize.Cache;
      return memoized;
    }

    /**
     * Creates a function that runs each argument through a corresponding
     * transform function.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to wrap.
     * @param {...(Function|Function[])} [transforms] The functions to transform
     * arguments, specified as individual functions or arrays of functions.
     * @returns {Function} Returns the new function.
     * @example
     *
     * function doubled(n) {
     *   return n * 2;
     * }
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * var modded = _.modArgs(function(x, y) {
     *   return [x, y];
     * }, square, doubled);
     *
     * modded(1, 2);
     * // => [1, 4]
     *
     * modded(5, 10);
     * // => [25, 20]
     */
    var modArgs = restParam(function(func, transforms) {
      transforms = baseFlatten(transforms);
      if (typeof func != 'function' || !arrayEvery(transforms, baseIsFunction)) {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var length = transforms.length;
      return restParam(function(args) {
        var index = nativeMin(args.length, length);
        while (index--) {
          args[index] = transforms[index](args[index]);
        }
        return func.apply(this, args);
      });
    });

    /**
     * Creates a function that negates the result of the predicate `func`. The
     * `func` predicate is invoked with the `this` binding and arguments of the
     * created function.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} predicate The predicate to negate.
     * @returns {Function} Returns the new function.
     * @example
     *
     * function isEven(n) {
     *   return n % 2 == 0;
     * }
     *
     * _.filter([1, 2, 3, 4, 5, 6], _.negate(isEven));
     * // => [1, 3, 5]
     */
    function negate(predicate) {
      if (typeof predicate != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      return function() {
        return !predicate.apply(this, arguments);
      };
    }

    /**
     * Creates a function that is restricted to invoking `func` once. Repeat calls
     * to the function return the value of the first call. The `func` is invoked
     * with the `this` binding and arguments of the created function.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new restricted function.
     * @example
     *
     * var initialize = _.once(createApplication);
     * initialize();
     * initialize();
     * // `initialize` invokes `createApplication` once
     */
    function once(func) {
      return before(2, func);
    }

    /**
     * Creates a function that invokes `func` with `partial` arguments prepended
     * to those provided to the new function. This method is like `_.bind` except
     * it does **not** alter the `this` binding.
     *
     * The `_.partial.placeholder` value, which defaults to `_` in monolithic
     * builds, may be used as a placeholder for partially applied arguments.
     *
     * **Note:** This method does not set the "length" property of partially
     * applied functions.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to partially apply arguments to.
     * @param {...*} [partials] The arguments to be partially applied.
     * @returns {Function} Returns the new partially applied function.
     * @example
     *
     * var greet = function(greeting, name) {
     *   return greeting + ' ' + name;
     * };
     *
     * var sayHelloTo = _.partial(greet, 'hello');
     * sayHelloTo('fred');
     * // => 'hello fred'
     *
     * // using placeholders
     * var greetFred = _.partial(greet, _, 'fred');
     * greetFred('hi');
     * // => 'hi fred'
     */
    var partial = createPartial(PARTIAL_FLAG);

    /**
     * This method is like `_.partial` except that partially applied arguments
     * are appended to those provided to the new function.
     *
     * The `_.partialRight.placeholder` value, which defaults to `_` in monolithic
     * builds, may be used as a placeholder for partially applied arguments.
     *
     * **Note:** This method does not set the "length" property of partially
     * applied functions.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to partially apply arguments to.
     * @param {...*} [partials] The arguments to be partially applied.
     * @returns {Function} Returns the new partially applied function.
     * @example
     *
     * var greet = function(greeting, name) {
     *   return greeting + ' ' + name;
     * };
     *
     * var greetFred = _.partialRight(greet, 'fred');
     * greetFred('hi');
     * // => 'hi fred'
     *
     * // using placeholders
     * var sayHelloTo = _.partialRight(greet, 'hello', _);
     * sayHelloTo('fred');
     * // => 'hello fred'
     */
    var partialRight = createPartial(PARTIAL_RIGHT_FLAG);

    /**
     * Creates a function that invokes `func` with arguments arranged according
     * to the specified indexes where the argument value at the first index is
     * provided as the first argument, the argument value at the second index is
     * provided as the second argument, and so on.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to rearrange arguments for.
     * @param {...(number|number[])} indexes The arranged argument indexes,
     *  specified as individual indexes or arrays of indexes.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var rearged = _.rearg(function(a, b, c) {
     *   return [a, b, c];
     * }, 2, 0, 1);
     *
     * rearged('b', 'c', 'a')
     * // => ['a', 'b', 'c']
     *
     * var map = _.rearg(_.map, [1, 0]);
     * map(function(n) {
     *   return n * 3;
     * }, [1, 2, 3]);
     * // => [3, 6, 9]
     */
    var rearg = restParam(function(func, indexes) {
      return createWrapper(func, REARG_FLAG, undefined, undefined, undefined, baseFlatten(indexes));
    });

    /**
     * Creates a function that invokes `func` with the `this` binding of the
     * created function and arguments from `start` and beyond provided as an array.
     *
     * **Note:** This method is based on the [rest parameter](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/rest_parameters).
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to apply a rest parameter to.
     * @param {number} [start=func.length-1] The start position of the rest parameter.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var say = _.restParam(function(what, names) {
     *   return what + ' ' + _.initial(names).join(', ') +
     *     (_.size(names) > 1 ? ', & ' : '') + _.last(names);
     * });
     *
     * say('hello', 'fred', 'barney', 'pebbles');
     * // => 'hello fred, barney, & pebbles'
     */
    function restParam(func, start) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      start = nativeMax(start === undefined ? (func.length - 1) : (+start || 0), 0);
      return function() {
        var args = arguments,
            index = -1,
            length = nativeMax(args.length - start, 0),
            rest = Array(length);

        while (++index < length) {
          rest[index] = args[start + index];
        }
        switch (start) {
          case 0: return func.call(this, rest);
          case 1: return func.call(this, args[0], rest);
          case 2: return func.call(this, args[0], args[1], rest);
        }
        var otherArgs = Array(start + 1);
        index = -1;
        while (++index < start) {
          otherArgs[index] = args[index];
        }
        otherArgs[start] = rest;
        return func.apply(this, otherArgs);
      };
    }

    /**
     * Creates a function that invokes `func` with the `this` binding of the created
     * function and an array of arguments much like [`Function#apply`](https://es5.github.io/#x15.3.4.3).
     *
     * **Note:** This method is based on the [spread operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Spread_operator).
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to spread arguments over.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var say = _.spread(function(who, what) {
     *   return who + ' says ' + what;
     * });
     *
     * say(['fred', 'hello']);
     * // => 'fred says hello'
     *
     * // with a Promise
     * var numbers = Promise.all([
     *   Promise.resolve(40),
     *   Promise.resolve(36)
     * ]);
     *
     * numbers.then(_.spread(function(x, y) {
     *   return x + y;
     * }));
     * // => a Promise of 76
     */
    function spread(func) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      return function(array) {
        return func.apply(this, array);
      };
    }

    /**
     * Creates a throttled function that only invokes `func` at most once per
     * every `wait` milliseconds. The throttled function comes with a `cancel`
     * method to cancel delayed invocations. Provide an options object to indicate
     * that `func` should be invoked on the leading and/or trailing edge of the
     * `wait` timeout. Subsequent calls to the throttled function return the
     * result of the last `func` call.
     *
     * **Note:** If `leading` and `trailing` options are `true`, `func` is invoked
     * on the trailing edge of the timeout only if the the throttled function is
     * invoked more than once during the `wait` timeout.
     *
     * See [David Corbacho's article](http://drupalmotion.com/article/debounce-and-throttle-visual-explanation)
     * for details over the differences between `_.throttle` and `_.debounce`.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {Function} func The function to throttle.
     * @param {number} [wait=0] The number of milliseconds to throttle invocations to.
     * @param {Object} [options] The options object.
     * @param {boolean} [options.leading=true] Specify invoking on the leading
     *  edge of the timeout.
     * @param {boolean} [options.trailing=true] Specify invoking on the trailing
     *  edge of the timeout.
     * @returns {Function} Returns the new throttled function.
     * @example
     *
     * // avoid excessively updating the position while scrolling
     * jQuery(window).on('scroll', _.throttle(updatePosition, 100));
     *
     * // invoke `renewToken` when the click event is fired, but not more than once every 5 minutes
     * jQuery('.interactive').on('click', _.throttle(renewToken, 300000, {
     *   'trailing': false
     * }));
     *
     * // cancel a trailing throttled call
     * jQuery(window).on('popstate', throttled.cancel);
     */
    function throttle(func, wait, options) {
      var leading = true,
          trailing = true;

      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      if (options === false) {
        leading = false;
      } else if (isObject(options)) {
        leading = 'leading' in options ? !!options.leading : leading;
        trailing = 'trailing' in options ? !!options.trailing : trailing;
      }
      return debounce(func, wait, { 'leading': leading, 'maxWait': +wait, 'trailing': trailing });
    }

    /**
     * Creates a function that provides `value` to the wrapper function as its
     * first argument. Any additional arguments provided to the function are
     * appended to those provided to the wrapper function. The wrapper is invoked
     * with the `this` binding of the created function.
     *
     * @static
     * @memberOf _
     * @category Function
     * @param {*} value The value to wrap.
     * @param {Function} wrapper The wrapper function.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var p = _.wrap(_.escape, function(func, text) {
     *   return '<p>' + func(text) + '</p>';
     * });
     *
     * p('fred, barney, & pebbles');
     * // => '<p>fred, barney, &amp; pebbles</p>'
     */
    function wrap(value, wrapper) {
      wrapper = wrapper == null ? identity : wrapper;
      return createWrapper(wrapper, PARTIAL_FLAG, undefined, [value], []);
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates a clone of `value`. If `isDeep` is `true` nested objects are cloned,
     * otherwise they are assigned by reference. If `customizer` is provided it is
     * invoked to produce the cloned values. If `customizer` returns `undefined`
     * cloning is handled by the method instead. The `customizer` is bound to
     * `thisArg` and invoked with two argument; (value [, index|key, object]).
     *
     * **Note:** This method is loosely based on the
     * [structured clone algorithm](http://www.w3.org/TR/html5/infrastructure.html#internal-structured-cloning-algorithm).
     * The enumerable properties of `arguments` objects and objects created by
     * constructors other than `Object` are cloned to plain `Object` objects. An
     * empty object is returned for uncloneable values such as functions, DOM nodes,
     * Maps, Sets, and WeakMaps.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @param {Function} [customizer] The function to customize cloning values.
     * @param {*} [thisArg] The `this` binding of `customizer`.
     * @returns {*} Returns the cloned value.
     * @example
     *
     * var users = [
     *   { 'user': 'barney' },
     *   { 'user': 'fred' }
     * ];
     *
     * var shallow = _.clone(users);
     * shallow[0] === users[0];
     * // => true
     *
     * var deep = _.clone(users, true);
     * deep[0] === users[0];
     * // => false
     *
     * // using a customizer callback
     * var el = _.clone(document.body, function(value) {
     *   if (_.isElement(value)) {
     *     return value.cloneNode(false);
     *   }
     * });
     *
     * el === document.body
     * // => false
     * el.nodeName
     * // => BODY
     * el.childNodes.length;
     * // => 0
     */
    function clone(value, isDeep, customizer, thisArg) {
      if (isDeep && typeof isDeep != 'boolean' && isIterateeCall(value, isDeep, customizer)) {
        isDeep = false;
      }
      else if (typeof isDeep == 'function') {
        thisArg = customizer;
        customizer = isDeep;
        isDeep = false;
      }
      return typeof customizer == 'function'
        ? baseClone(value, isDeep, bindCallback(customizer, thisArg, 1))
        : baseClone(value, isDeep);
    }

    /**
     * Creates a deep clone of `value`. If `customizer` is provided it is invoked
     * to produce the cloned values. If `customizer` returns `undefined` cloning
     * is handled by the method instead. The `customizer` is bound to `thisArg`
     * and invoked with two argument; (value [, index|key, object]).
     *
     * **Note:** This method is loosely based on the
     * [structured clone algorithm](http://www.w3.org/TR/html5/infrastructure.html#internal-structured-cloning-algorithm).
     * The enumerable properties of `arguments` objects and objects created by
     * constructors other than `Object` are cloned to plain `Object` objects. An
     * empty object is returned for uncloneable values such as functions, DOM nodes,
     * Maps, Sets, and WeakMaps.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to deep clone.
     * @param {Function} [customizer] The function to customize cloning values.
     * @param {*} [thisArg] The `this` binding of `customizer`.
     * @returns {*} Returns the deep cloned value.
     * @example
     *
     * var users = [
     *   { 'user': 'barney' },
     *   { 'user': 'fred' }
     * ];
     *
     * var deep = _.cloneDeep(users);
     * deep[0] === users[0];
     * // => false
     *
     * // using a customizer callback
     * var el = _.cloneDeep(document.body, function(value) {
     *   if (_.isElement(value)) {
     *     return value.cloneNode(true);
     *   }
     * });
     *
     * el === document.body
     * // => false
     * el.nodeName
     * // => BODY
     * el.childNodes.length;
     * // => 20
     */
    function cloneDeep(value, customizer, thisArg) {
      return typeof customizer == 'function'
        ? baseClone(value, true, bindCallback(customizer, thisArg, 1))
        : baseClone(value, true);
    }

    /**
     * Checks if `value` is greater than `other`.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is greater than `other`, else `false`.
     * @example
     *
     * _.gt(3, 1);
     * // => true
     *
     * _.gt(3, 3);
     * // => false
     *
     * _.gt(1, 3);
     * // => false
     */
    function gt(value, other) {
      return value > other;
    }

    /**
     * Checks if `value` is greater than or equal to `other`.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is greater than or equal to `other`, else `false`.
     * @example
     *
     * _.gte(3, 1);
     * // => true
     *
     * _.gte(3, 3);
     * // => true
     *
     * _.gte(1, 3);
     * // => false
     */
    function gte(value, other) {
      return value >= other;
    }

    /**
     * Checks if `value` is classified as an `arguments` object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isArguments(function() { return arguments; }());
     * // => true
     *
     * _.isArguments([1, 2, 3]);
     * // => false
     */
    function isArguments(value) {
      return isObjectLike(value) && isArrayLike(value) &&
        hasOwnProperty.call(value, 'callee') && !propertyIsEnumerable.call(value, 'callee');
    }

    /**
     * Checks if `value` is classified as an `Array` object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isArray([1, 2, 3]);
     * // => true
     *
     * _.isArray(function() { return arguments; }());
     * // => false
     */
    var isArray = nativeIsArray || function(value) {
      return isObjectLike(value) && isLength(value.length) && objToString.call(value) == arrayTag;
    };

    /**
     * Checks if `value` is classified as a boolean primitive or object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isBoolean(false);
     * // => true
     *
     * _.isBoolean(null);
     * // => false
     */
    function isBoolean(value) {
      return value === true || value === false || (isObjectLike(value) && objToString.call(value) == boolTag);
    }

    /**
     * Checks if `value` is classified as a `Date` object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isDate(new Date);
     * // => true
     *
     * _.isDate('Mon April 23 2012');
     * // => false
     */
    function isDate(value) {
      return isObjectLike(value) && objToString.call(value) == dateTag;
    }

    /**
     * Checks if `value` is a DOM element.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a DOM element, else `false`.
     * @example
     *
     * _.isElement(document.body);
     * // => true
     *
     * _.isElement('<body>');
     * // => false
     */
    function isElement(value) {
      return !!value && value.nodeType === 1 && isObjectLike(value) && !isPlainObject(value);
    }

    /**
     * Checks if `value` is empty. A value is considered empty unless it is an
     * `arguments` object, array, string, or jQuery-like collection with a length
     * greater than `0` or an object with own enumerable properties.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {Array|Object|string} value The value to inspect.
     * @returns {boolean} Returns `true` if `value` is empty, else `false`.
     * @example
     *
     * _.isEmpty(null);
     * // => true
     *
     * _.isEmpty(true);
     * // => true
     *
     * _.isEmpty(1);
     * // => true
     *
     * _.isEmpty([1, 2, 3]);
     * // => false
     *
     * _.isEmpty({ 'a': 1 });
     * // => false
     */
    function isEmpty(value) {
      if (value == null) {
        return true;
      }
      if (isArrayLike(value) && (isArray(value) || isString(value) || isArguments(value) ||
          (isObjectLike(value) && isFunction(value.splice)))) {
        return !value.length;
      }
      return !keys(value).length;
    }

    /**
     * Performs a deep comparison between two values to determine if they are
     * equivalent. If `customizer` is provided it is invoked to compare values.
     * If `customizer` returns `undefined` comparisons are handled by the method
     * instead. The `customizer` is bound to `thisArg` and invoked with three
     * arguments: (value, other [, index|key]).
     *
     * **Note:** This method supports comparing arrays, booleans, `Date` objects,
     * numbers, `Object` objects, regexes, and strings. Objects are compared by
     * their own, not inherited, enumerable properties. Functions and DOM nodes
     * are **not** supported. Provide a customizer function to extend support
     * for comparing other values.
     *
     * @static
     * @memberOf _
     * @alias eq
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @param {Function} [customizer] The function to customize value comparisons.
     * @param {*} [thisArg] The `this` binding of `customizer`.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'user': 'fred' };
     * var other = { 'user': 'fred' };
     *
     * object == other;
     * // => false
     *
     * _.isEqual(object, other);
     * // => true
     *
     * // using a customizer callback
     * var array = ['hello', 'goodbye'];
     * var other = ['hi', 'goodbye'];
     *
     * _.isEqual(array, other, function(value, other) {
     *   if (_.every([value, other], RegExp.prototype.test, /^h(?:i|ello)$/)) {
     *     return true;
     *   }
     * });
     * // => true
     */
    function isEqual(value, other, customizer, thisArg) {
      customizer = typeof customizer == 'function' ? bindCallback(customizer, thisArg, 3) : undefined;
      var result = customizer ? customizer(value, other) : undefined;
      return  result === undefined ? baseIsEqual(value, other, customizer) : !!result;
    }

    /**
     * Checks if `value` is an `Error`, `EvalError`, `RangeError`, `ReferenceError`,
     * `SyntaxError`, `TypeError`, or `URIError` object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an error object, else `false`.
     * @example
     *
     * _.isError(new Error);
     * // => true
     *
     * _.isError(Error);
     * // => false
     */
    function isError(value) {
      return isObjectLike(value) && typeof value.message == 'string' && objToString.call(value) == errorTag;
    }

    /**
     * Checks if `value` is a finite primitive number.
     *
     * **Note:** This method is based on [`Number.isFinite`](http://ecma-international.org/ecma-262/6.0/#sec-number.isfinite).
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a finite number, else `false`.
     * @example
     *
     * _.isFinite(10);
     * // => true
     *
     * _.isFinite('10');
     * // => false
     *
     * _.isFinite(true);
     * // => false
     *
     * _.isFinite(Object(10));
     * // => false
     *
     * _.isFinite(Infinity);
     * // => false
     */
    function isFinite(value) {
      return typeof value == 'number' && nativeIsFinite(value);
    }

    /**
     * Checks if `value` is classified as a `Function` object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isFunction(_);
     * // => true
     *
     * _.isFunction(/abc/);
     * // => false
     */
    function isFunction(value) {
      // The use of `Object#toString` avoids issues with the `typeof` operator
      // in older versions of Chrome and Safari which return 'function' for regexes
      // and Safari 8 equivalents which return 'object' for typed array constructors.
      return isObject(value) && objToString.call(value) == funcTag;
    }

    /**
     * Checks if `value` is the [language type](https://es5.github.io/#x8) of `Object`.
     * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(1);
     * // => false
     */
    function isObject(value) {
      // Avoid a V8 JIT bug in Chrome 19-20.
      // See https://code.google.com/p/v8/issues/detail?id=2291 for more details.
      var type = typeof value;
      return !!value && (type == 'object' || type == 'function');
    }

    /**
     * Performs a deep comparison between `object` and `source` to determine if
     * `object` contains equivalent property values. If `customizer` is provided
     * it is invoked to compare values. If `customizer` returns `undefined`
     * comparisons are handled by the method instead. The `customizer` is bound
     * to `thisArg` and invoked with three arguments: (value, other, index|key).
     *
     * **Note:** This method supports comparing properties of arrays, booleans,
     * `Date` objects, numbers, `Object` objects, regexes, and strings. Functions
     * and DOM nodes are **not** supported. Provide a customizer function to extend
     * support for comparing other values.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {Object} object The object to inspect.
     * @param {Object} source The object of property values to match.
     * @param {Function} [customizer] The function to customize value comparisons.
     * @param {*} [thisArg] The `this` binding of `customizer`.
     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
     * @example
     *
     * var object = { 'user': 'fred', 'age': 40 };
     *
     * _.isMatch(object, { 'age': 40 });
     * // => true
     *
     * _.isMatch(object, { 'age': 36 });
     * // => false
     *
     * // using a customizer callback
     * var object = { 'greeting': 'hello' };
     * var source = { 'greeting': 'hi' };
     *
     * _.isMatch(object, source, function(value, other) {
     *   return _.every([value, other], RegExp.prototype.test, /^h(?:i|ello)$/) || undefined;
     * });
     * // => true
     */
    function isMatch(object, source, customizer, thisArg) {
      customizer = typeof customizer == 'function' ? bindCallback(customizer, thisArg, 3) : undefined;
      return baseIsMatch(object, getMatchData(source), customizer);
    }

    /**
     * Checks if `value` is `NaN`.
     *
     * **Note:** This method is not the same as [`isNaN`](https://es5.github.io/#x15.1.2.4)
     * which returns `true` for `undefined` and other non-numeric values.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
     * @example
     *
     * _.isNaN(NaN);
     * // => true
     *
     * _.isNaN(new Number(NaN));
     * // => true
     *
     * isNaN(undefined);
     * // => true
     *
     * _.isNaN(undefined);
     * // => false
     */
    function isNaN(value) {
      // An `NaN` primitive is the only value that is not equal to itself.
      // Perform the `toStringTag` check first to avoid errors with some host objects in IE.
      return isNumber(value) && value != +value;
    }

    /**
     * Checks if `value` is a native function.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a native function, else `false`.
     * @example
     *
     * _.isNative(Array.prototype.push);
     * // => true
     *
     * _.isNative(_);
     * // => false
     */
    function isNative(value) {
      if (value == null) {
        return false;
      }
      if (isFunction(value)) {
        return reIsNative.test(fnToString.call(value));
      }
      return isObjectLike(value) && reIsHostCtor.test(value);
    }

    /**
     * Checks if `value` is `null`.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `null`, else `false`.
     * @example
     *
     * _.isNull(null);
     * // => true
     *
     * _.isNull(void 0);
     * // => false
     */
    function isNull(value) {
      return value === null;
    }

    /**
     * Checks if `value` is classified as a `Number` primitive or object.
     *
     * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are classified
     * as numbers, use the `_.isFinite` method.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isNumber(8.4);
     * // => true
     *
     * _.isNumber(NaN);
     * // => true
     *
     * _.isNumber('8.4');
     * // => false
     */
    function isNumber(value) {
      return typeof value == 'number' || (isObjectLike(value) && objToString.call(value) == numberTag);
    }

    /**
     * Checks if `value` is a plain object, that is, an object created by the
     * `Object` constructor or one with a `[[Prototype]]` of `null`.
     *
     * **Note:** This method assumes objects created by the `Object` constructor
     * have no inherited enumerable properties.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     * }
     *
     * _.isPlainObject(new Foo);
     * // => false
     *
     * _.isPlainObject([1, 2, 3]);
     * // => false
     *
     * _.isPlainObject({ 'x': 0, 'y': 0 });
     * // => true
     *
     * _.isPlainObject(Object.create(null));
     * // => true
     */
    function isPlainObject(value) {
      var Ctor;

      // Exit early for non `Object` objects.
      if (!(isObjectLike(value) && objToString.call(value) == objectTag && !isArguments(value)) ||
          (!hasOwnProperty.call(value, 'constructor') && (Ctor = value.constructor, typeof Ctor == 'function' && !(Ctor instanceof Ctor)))) {
        return false;
      }
      // IE < 9 iterates inherited properties before own properties. If the first
      // iterated property is an object's own property then there are no inherited
      // enumerable properties.
      var result;
      // In most environments an object's own properties are iterated before
      // its inherited properties. If the last iterated property is an object's
      // own property then there are no inherited enumerable properties.
      baseForIn(value, function(subValue, key) {
        result = key;
      });
      return result === undefined || hasOwnProperty.call(value, result);
    }

    /**
     * Checks if `value` is classified as a `RegExp` object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isRegExp(/abc/);
     * // => true
     *
     * _.isRegExp('/abc/');
     * // => false
     */
    function isRegExp(value) {
      return isObject(value) && objToString.call(value) == regexpTag;
    }

    /**
     * Checks if `value` is classified as a `String` primitive or object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isString('abc');
     * // => true
     *
     * _.isString(1);
     * // => false
     */
    function isString(value) {
      return typeof value == 'string' || (isObjectLike(value) && objToString.call(value) == stringTag);
    }

    /**
     * Checks if `value` is classified as a typed array.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
     * @example
     *
     * _.isTypedArray(new Uint8Array);
     * // => true
     *
     * _.isTypedArray([]);
     * // => false
     */
    function isTypedArray(value) {
      return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[objToString.call(value)];
    }

    /**
     * Checks if `value` is `undefined`.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `undefined`, else `false`.
     * @example
     *
     * _.isUndefined(void 0);
     * // => true
     *
     * _.isUndefined(null);
     * // => false
     */
    function isUndefined(value) {
      return value === undefined;
    }

    /**
     * Checks if `value` is less than `other`.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is less than `other`, else `false`.
     * @example
     *
     * _.lt(1, 3);
     * // => true
     *
     * _.lt(3, 3);
     * // => false
     *
     * _.lt(3, 1);
     * // => false
     */
    function lt(value, other) {
      return value < other;
    }

    /**
     * Checks if `value` is less than or equal to `other`.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is less than or equal to `other`, else `false`.
     * @example
     *
     * _.lte(1, 3);
     * // => true
     *
     * _.lte(3, 3);
     * // => true
     *
     * _.lte(3, 1);
     * // => false
     */
    function lte(value, other) {
      return value <= other;
    }

    /**
     * Converts `value` to an array.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {Array} Returns the converted array.
     * @example
     *
     * (function() {
     *   return _.toArray(arguments).slice(1);
     * }(1, 2, 3));
     * // => [2, 3]
     */
    function toArray(value) {
      var length = value ? getLength(value) : 0;
      if (!isLength(length)) {
        return values(value);
      }
      if (!length) {
        return [];
      }
      return arrayCopy(value);
    }

    /**
     * Converts `value` to a plain object flattening inherited enumerable
     * properties of `value` to own properties of the plain object.
     *
     * @static
     * @memberOf _
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {Object} Returns the converted plain object.
     * @example
     *
     * function Foo() {
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.assign({ 'a': 1 }, new Foo);
     * // => { 'a': 1, 'b': 2 }
     *
     * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
     * // => { 'a': 1, 'b': 2, 'c': 3 }
     */
    function toPlainObject(value) {
      return baseCopy(value, keysIn(value));
    }

    /*------------------------------------------------------------------------*/

    /**
     * Recursively merges own enumerable properties of the source object(s), that
     * don't resolve to `undefined` into the destination object. Subsequent sources
     * overwrite property assignments of previous sources. If `customizer` is
     * provided it is invoked to produce the merged values of the destination and
     * source properties. If `customizer` returns `undefined` merging is handled
     * by the method instead. The `customizer` is bound to `thisArg` and invoked
     * with five arguments: (objectValue, sourceValue, key, object, source).
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @param {Function} [customizer] The function to customize assigned values.
     * @param {*} [thisArg] The `this` binding of `customizer`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var users = {
     *   'data': [{ 'user': 'barney' }, { 'user': 'fred' }]
     * };
     *
     * var ages = {
     *   'data': [{ 'age': 36 }, { 'age': 40 }]
     * };
     *
     * _.merge(users, ages);
     * // => { 'data': [{ 'user': 'barney', 'age': 36 }, { 'user': 'fred', 'age': 40 }] }
     *
     * // using a customizer callback
     * var object = {
     *   'fruits': ['apple'],
     *   'vegetables': ['beet']
     * };
     *
     * var other = {
     *   'fruits': ['banana'],
     *   'vegetables': ['carrot']
     * };
     *
     * _.merge(object, other, function(a, b) {
     *   if (_.isArray(a)) {
     *     return a.concat(b);
     *   }
     * });
     * // => { 'fruits': ['apple', 'banana'], 'vegetables': ['beet', 'carrot'] }
     */
    var merge = createAssigner(baseMerge);

    /**
     * Assigns own enumerable properties of source object(s) to the destination
     * object. Subsequent sources overwrite property assignments of previous sources.
     * If `customizer` is provided it is invoked to produce the assigned values.
     * The `customizer` is bound to `thisArg` and invoked with five arguments:
     * (objectValue, sourceValue, key, object, source).
     *
     * **Note:** This method mutates `object` and is based on
     * [`Object.assign`](http://ecma-international.org/ecma-262/6.0/#sec-object.assign).
     *
     * @static
     * @memberOf _
     * @alias extend
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @param {Function} [customizer] The function to customize assigned values.
     * @param {*} [thisArg] The `this` binding of `customizer`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * _.assign({ 'user': 'barney' }, { 'age': 40 }, { 'user': 'fred' });
     * // => { 'user': 'fred', 'age': 40 }
     *
     * // using a customizer callback
     * var defaults = _.partialRight(_.assign, function(value, other) {
     *   return _.isUndefined(value) ? other : value;
     * });
     *
     * defaults({ 'user': 'barney' }, { 'age': 36 }, { 'user': 'fred' });
     * // => { 'user': 'barney', 'age': 36 }
     */
    var assign = createAssigner(function(object, source, customizer) {
      return customizer
        ? assignWith(object, source, customizer)
        : baseAssign(object, source);
    });

    /**
     * Creates an object that inherits from the given `prototype` object. If a
     * `properties` object is provided its own enumerable properties are assigned
     * to the created object.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} prototype The object to inherit from.
     * @param {Object} [properties] The properties to assign to the object.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Object} Returns the new object.
     * @example
     *
     * function Shape() {
     *   this.x = 0;
     *   this.y = 0;
     * }
     *
     * function Circle() {
     *   Shape.call(this);
     * }
     *
     * Circle.prototype = _.create(Shape.prototype, {
     *   'constructor': Circle
     * });
     *
     * var circle = new Circle;
     * circle instanceof Circle;
     * // => true
     *
     * circle instanceof Shape;
     * // => true
     */
    function create(prototype, properties, guard) {
      var result = baseCreate(prototype);
      if (guard && isIterateeCall(prototype, properties, guard)) {
        properties = undefined;
      }
      return properties ? baseAssign(result, properties) : result;
    }

    /**
     * Assigns own enumerable properties of source object(s) to the destination
     * object for all destination properties that resolve to `undefined`. Once a
     * property is set, additional values of the same property are ignored.
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @returns {Object} Returns `object`.
     * @example
     *
     * _.defaults({ 'user': 'barney' }, { 'age': 36 }, { 'user': 'fred' });
     * // => { 'user': 'barney', 'age': 36 }
     */
    var defaults = createDefaults(assign, assignDefaults);

    /**
     * This method is like `_.defaults` except that it recursively assigns
     * default properties.
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @returns {Object} Returns `object`.
     * @example
     *
     * _.defaultsDeep({ 'user': { 'name': 'barney' } }, { 'user': { 'name': 'fred', 'age': 36 } });
     * // => { 'user': { 'name': 'barney', 'age': 36 } }
     *
     */
    var defaultsDeep = createDefaults(merge, mergeDefaults);

    /**
     * This method is like `_.find` except that it returns the key of the first
     * element `predicate` returns truthy for instead of the element itself.
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {string|undefined} Returns the key of the matched element, else `undefined`.
     * @example
     *
     * var users = {
     *   'barney':  { 'age': 36, 'active': true },
     *   'fred':    { 'age': 40, 'active': false },
     *   'pebbles': { 'age': 1,  'active': true }
     * };
     *
     * _.findKey(users, function(chr) {
     *   return chr.age < 40;
     * });
     * // => 'barney' (iteration order is not guaranteed)
     *
     * // using the `_.matches` callback shorthand
     * _.findKey(users, { 'age': 1, 'active': true });
     * // => 'pebbles'
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.findKey(users, 'active', false);
     * // => 'fred'
     *
     * // using the `_.property` callback shorthand
     * _.findKey(users, 'active');
     * // => 'barney'
     */
    var findKey = createFindKey(baseForOwn);

    /**
     * This method is like `_.findKey` except that it iterates over elements of
     * a collection in the opposite order.
     *
     * If a property name is provided for `predicate` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `predicate` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to search.
     * @param {Function|Object|string} [predicate=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {string|undefined} Returns the key of the matched element, else `undefined`.
     * @example
     *
     * var users = {
     *   'barney':  { 'age': 36, 'active': true },
     *   'fred':    { 'age': 40, 'active': false },
     *   'pebbles': { 'age': 1,  'active': true }
     * };
     *
     * _.findLastKey(users, function(chr) {
     *   return chr.age < 40;
     * });
     * // => returns `pebbles` assuming `_.findKey` returns `barney`
     *
     * // using the `_.matches` callback shorthand
     * _.findLastKey(users, { 'age': 36, 'active': true });
     * // => 'barney'
     *
     * // using the `_.matchesProperty` callback shorthand
     * _.findLastKey(users, 'active', false);
     * // => 'fred'
     *
     * // using the `_.property` callback shorthand
     * _.findLastKey(users, 'active');
     * // => 'pebbles'
     */
    var findLastKey = createFindKey(baseForOwnRight);

    /**
     * Iterates over own and inherited enumerable properties of an object invoking
     * `iteratee` for each property. The `iteratee` is bound to `thisArg` and invoked
     * with three arguments: (value, key, object). Iteratee functions may exit
     * iteration early by explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forIn(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => logs 'a', 'b', and 'c' (iteration order is not guaranteed)
     */
    var forIn = createForIn(baseFor);

    /**
     * This method is like `_.forIn` except that it iterates over properties of
     * `object` in the opposite order.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forInRight(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => logs 'c', 'b', and 'a' assuming `_.forIn ` logs 'a', 'b', and 'c'
     */
    var forInRight = createForIn(baseForRight);

    /**
     * Iterates over own enumerable properties of an object invoking `iteratee`
     * for each property. The `iteratee` is bound to `thisArg` and invoked with
     * three arguments: (value, key, object). Iteratee functions may exit iteration
     * early by explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forOwn(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => logs 'a' and 'b' (iteration order is not guaranteed)
     */
    var forOwn = createForOwn(baseForOwn);

    /**
     * This method is like `_.forOwn` except that it iterates over properties of
     * `object` in the opposite order.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forOwnRight(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => logs 'b' and 'a' assuming `_.forOwn` logs 'a' and 'b'
     */
    var forOwnRight = createForOwn(baseForOwnRight);

    /**
     * Creates an array of function property names from all enumerable properties,
     * own and inherited, of `object`.
     *
     * @static
     * @memberOf _
     * @alias methods
     * @category Object
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns the new array of property names.
     * @example
     *
     * _.functions(_);
     * // => ['after', 'ary', 'assign', ...]
     */
    function functions(object) {
      return baseFunctions(object, keysIn(object));
    }

    /**
     * Gets the property value at `path` of `object`. If the resolved value is
     * `undefined` the `defaultValue` is used in its place.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to get.
     * @param {*} [defaultValue] The value returned if the resolved value is `undefined`.
     * @returns {*} Returns the resolved value.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
     *
     * _.get(object, 'a[0].b.c');
     * // => 3
     *
     * _.get(object, ['a', '0', 'b', 'c']);
     * // => 3
     *
     * _.get(object, 'a.b.c', 'default');
     * // => 'default'
     */
    function get(object, path, defaultValue) {
      var result = object == null ? undefined : baseGet(object, toPath(path), path + '');
      return result === undefined ? defaultValue : result;
    }

    /**
     * Checks if `path` is a direct property.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path to check.
     * @returns {boolean} Returns `true` if `path` is a direct property, else `false`.
     * @example
     *
     * var object = { 'a': { 'b': { 'c': 3 } } };
     *
     * _.has(object, 'a');
     * // => true
     *
     * _.has(object, 'a.b.c');
     * // => true
     *
     * _.has(object, ['a', 'b', 'c']);
     * // => true
     */
    function has(object, path) {
      if (object == null) {
        return false;
      }
      var result = hasOwnProperty.call(object, path);
      if (!result && !isKey(path)) {
        path = toPath(path);
        object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
        if (object == null) {
          return false;
        }
        path = last(path);
        result = hasOwnProperty.call(object, path);
      }
      return result || (isLength(object.length) && isIndex(path, object.length) &&
        (isArray(object) || isArguments(object)));
    }

    /**
     * Creates an object composed of the inverted keys and values of `object`.
     * If `object` contains duplicate values, subsequent values overwrite property
     * assignments of previous values unless `multiValue` is `true`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to invert.
     * @param {boolean} [multiValue] Allow multiple values per key.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {Object} Returns the new inverted object.
     * @example
     *
     * var object = { 'a': 1, 'b': 2, 'c': 1 };
     *
     * _.invert(object);
     * // => { '1': 'c', '2': 'b' }
     *
     * // with `multiValue`
     * _.invert(object, true);
     * // => { '1': ['a', 'c'], '2': ['b'] }
     */
    function invert(object, multiValue, guard) {
      if (guard && isIterateeCall(object, multiValue, guard)) {
        multiValue = undefined;
      }
      var index = -1,
          props = keys(object),
          length = props.length,
          result = {};

      while (++index < length) {
        var key = props[index],
            value = object[key];

        if (multiValue) {
          if (hasOwnProperty.call(result, value)) {
            result[value].push(key);
          } else {
            result[value] = [key];
          }
        }
        else {
          result[value] = key;
        }
      }
      return result;
    }

    /**
     * Creates an array of the own enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects. See the
     * [ES spec](http://ecma-international.org/ecma-262/6.0/#sec-object.keys)
     * for more details.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keys(new Foo);
     * // => ['a', 'b'] (iteration order is not guaranteed)
     *
     * _.keys('hi');
     * // => ['0', '1']
     */
    var keys = !nativeKeys ? shimKeys : function(object) {
      var Ctor = object == null ? undefined : object.constructor;
      if ((typeof Ctor == 'function' && Ctor.prototype === object) ||
          (typeof object != 'function' && isArrayLike(object))) {
        return shimKeys(object);
      }
      return isObject(object) ? nativeKeys(object) : [];
    };

    /**
     * Creates an array of the own and inherited enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keysIn(new Foo);
     * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
     */
    function keysIn(object) {
      if (object == null) {
        return [];
      }
      if (!isObject(object)) {
        object = Object(object);
      }
      var length = object.length;
      length = (length && isLength(length) &&
        (isArray(object) || isArguments(object)) && length) || 0;

      var Ctor = object.constructor,
          index = -1,
          isProto = typeof Ctor == 'function' && Ctor.prototype === object,
          result = Array(length),
          skipIndexes = length > 0;

      while (++index < length) {
        result[index] = (index + '');
      }
      for (var key in object) {
        if (!(skipIndexes && isIndex(key, length)) &&
            !(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
          result.push(key);
        }
      }
      return result;
    }

    /**
     * The opposite of `_.mapValues`; this method creates an object with the
     * same values as `object` and keys generated by running each own enumerable
     * property of `object` through `iteratee`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns the new mapped object.
     * @example
     *
     * _.mapKeys({ 'a': 1, 'b': 2 }, function(value, key) {
     *   return key + value;
     * });
     * // => { 'a1': 1, 'b2': 2 }
     */
    var mapKeys = createObjectMapper(true);

    /**
     * Creates an object with the same keys as `object` and values generated by
     * running each own enumerable property of `object` through `iteratee`. The
     * iteratee function is bound to `thisArg` and invoked with three arguments:
     * (value, key, object).
     *
     * If a property name is provided for `iteratee` the created `_.property`
     * style callback returns the property value of the given element.
     *
     * If a value is also provided for `thisArg` the created `_.matchesProperty`
     * style callback returns `true` for elements that have a matching property
     * value, else `false`.
     *
     * If an object is provided for `iteratee` the created `_.matches` style
     * callback returns `true` for elements that have the properties of the given
     * object, else `false`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function|Object|string} [iteratee=_.identity] The function invoked
     *  per iteration.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {Object} Returns the new mapped object.
     * @example
     *
     * _.mapValues({ 'a': 1, 'b': 2 }, function(n) {
     *   return n * 3;
     * });
     * // => { 'a': 3, 'b': 6 }
     *
     * var users = {
     *   'fred':    { 'user': 'fred',    'age': 40 },
     *   'pebbles': { 'user': 'pebbles', 'age': 1 }
     * };
     *
     * // using the `_.property` callback shorthand
     * _.mapValues(users, 'age');
     * // => { 'fred': 40, 'pebbles': 1 } (iteration order is not guaranteed)
     */
    var mapValues = createObjectMapper();

    /**
     * The opposite of `_.pick`; this method creates an object composed of the
     * own and inherited enumerable properties of `object` that are not omitted.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The source object.
     * @param {Function|...(string|string[])} [predicate] The function invoked per
     *  iteration or property names to omit, specified as individual property
     *  names or arrays of property names.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Object} Returns the new object.
     * @example
     *
     * var object = { 'user': 'fred', 'age': 40 };
     *
     * _.omit(object, 'age');
     * // => { 'user': 'fred' }
     *
     * _.omit(object, _.isNumber);
     * // => { 'user': 'fred' }
     */
    var omit = restParam(function(object, props) {
      if (object == null) {
        return {};
      }
      if (typeof props[0] != 'function') {
        var props = arrayMap(baseFlatten(props), String);
        return pickByArray(object, baseDifference(keysIn(object), props));
      }
      var predicate = bindCallback(props[0], props[1], 3);
      return pickByCallback(object, function(value, key, object) {
        return !predicate(value, key, object);
      });
    });

    /**
     * Creates a two dimensional array of the key-value pairs for `object`,
     * e.g. `[[key1, value1], [key2, value2]]`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the new array of key-value pairs.
     * @example
     *
     * _.pairs({ 'barney': 36, 'fred': 40 });
     * // => [['barney', 36], ['fred', 40]] (iteration order is not guaranteed)
     */
    function pairs(object) {
      object = toObject(object);

      var index = -1,
          props = keys(object),
          length = props.length,
          result = Array(length);

      while (++index < length) {
        var key = props[index];
        result[index] = [key, object[key]];
      }
      return result;
    }

    /**
     * Creates an object composed of the picked `object` properties. Property
     * names may be specified as individual arguments or as arrays of property
     * names. If `predicate` is provided it is invoked for each property of `object`
     * picking the properties `predicate` returns truthy for. The predicate is
     * bound to `thisArg` and invoked with three arguments: (value, key, object).
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The source object.
     * @param {Function|...(string|string[])} [predicate] The function invoked per
     *  iteration or property names to pick, specified as individual property
     *  names or arrays of property names.
     * @param {*} [thisArg] The `this` binding of `predicate`.
     * @returns {Object} Returns the new object.
     * @example
     *
     * var object = { 'user': 'fred', 'age': 40 };
     *
     * _.pick(object, 'user');
     * // => { 'user': 'fred' }
     *
     * _.pick(object, _.isString);
     * // => { 'user': 'fred' }
     */
    var pick = restParam(function(object, props) {
      if (object == null) {
        return {};
      }
      return typeof props[0] == 'function'
        ? pickByCallback(object, bindCallback(props[0], props[1], 3))
        : pickByArray(object, baseFlatten(props));
    });

    /**
     * This method is like `_.get` except that if the resolved value is a function
     * it is invoked with the `this` binding of its parent object and its result
     * is returned.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to resolve.
     * @param {*} [defaultValue] The value returned if the resolved value is `undefined`.
     * @returns {*} Returns the resolved value.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c1': 3, 'c2': _.constant(4) } }] };
     *
     * _.result(object, 'a[0].b.c1');
     * // => 3
     *
     * _.result(object, 'a[0].b.c2');
     * // => 4
     *
     * _.result(object, 'a.b.c', 'default');
     * // => 'default'
     *
     * _.result(object, 'a.b.c', _.constant('default'));
     * // => 'default'
     */
    function result(object, path, defaultValue) {
      var result = object == null ? undefined : object[path];
      if (result === undefined) {
        if (object != null && !isKey(path, object)) {
          path = toPath(path);
          object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
          result = object == null ? undefined : object[last(path)];
        }
        result = result === undefined ? defaultValue : result;
      }
      return isFunction(result) ? result.call(object) : result;
    }

    /**
     * Sets the property value of `path` on `object`. If a portion of `path`
     * does not exist it is created.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to augment.
     * @param {Array|string} path The path of the property to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
     *
     * _.set(object, 'a[0].b.c', 4);
     * console.log(object.a[0].b.c);
     * // => 4
     *
     * _.set(object, 'x[0].y.z', 5);
     * console.log(object.x[0].y.z);
     * // => 5
     */
    function set(object, path, value) {
      if (object == null) {
        return object;
      }
      var pathKey = (path + '');
      path = (object[pathKey] != null || isKey(path, object)) ? [pathKey] : toPath(path);

      var index = -1,
          length = path.length,
          lastIndex = length - 1,
          nested = object;

      while (nested != null && ++index < length) {
        var key = path[index];
        if (isObject(nested)) {
          if (index == lastIndex) {
            nested[key] = value;
          } else if (nested[key] == null) {
            nested[key] = isIndex(path[index + 1]) ? [] : {};
          }
        }
        nested = nested[key];
      }
      return object;
    }

    /**
     * An alternative to `_.reduce`; this method transforms `object` to a new
     * `accumulator` object which is the result of running each of its own enumerable
     * properties through `iteratee`, with each invocation potentially mutating
     * the `accumulator` object. The `iteratee` is bound to `thisArg` and invoked
     * with four arguments: (accumulator, value, key, object). Iteratee functions
     * may exit iteration early by explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Array|Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The custom accumulator value.
     * @param {*} [thisArg] The `this` binding of `iteratee`.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * _.transform([2, 3, 4], function(result, n) {
     *   result.push(n *= n);
     *   return n % 2 == 0;
     * });
     * // => [4, 9]
     *
     * _.transform({ 'a': 1, 'b': 2 }, function(result, n, key) {
     *   result[key] = n * 3;
     * });
     * // => { 'a': 3, 'b': 6 }
     */
    function transform(object, iteratee, accumulator, thisArg) {
      var isArr = isArray(object) || isTypedArray(object);
      iteratee = getCallback(iteratee, thisArg, 4);

      if (accumulator == null) {
        if (isArr || isObject(object)) {
          var Ctor = object.constructor;
          if (isArr) {
            accumulator = isArray(object) ? new Ctor : [];
          } else {
            accumulator = baseCreate(isFunction(Ctor) ? Ctor.prototype : undefined);
          }
        } else {
          accumulator = {};
        }
      }
      (isArr ? arrayEach : baseForOwn)(object, function(value, index, object) {
        return iteratee(accumulator, value, index, object);
      });
      return accumulator;
    }

    /**
     * Creates an array of the own enumerable property values of `object`.
     *
     * **Note:** Non-object values are coerced to objects.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property values.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.values(new Foo);
     * // => [1, 2] (iteration order is not guaranteed)
     *
     * _.values('hi');
     * // => ['h', 'i']
     */
    function values(object) {
      return baseValues(object, keys(object));
    }

    /**
     * Creates an array of the own and inherited enumerable property values
     * of `object`.
     *
     * **Note:** Non-object values are coerced to objects.
     *
     * @static
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property values.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.valuesIn(new Foo);
     * // => [1, 2, 3] (iteration order is not guaranteed)
     */
    function valuesIn(object) {
      return baseValues(object, keysIn(object));
    }

    /*------------------------------------------------------------------------*/

    /**
     * Checks if `n` is between `start` and up to but not including, `end`. If
     * `end` is not specified it is set to `start` with `start` then set to `0`.
     *
     * @static
     * @memberOf _
     * @category Number
     * @param {number} n The number to check.
     * @param {number} [start=0] The start of the range.
     * @param {number} end The end of the range.
     * @returns {boolean} Returns `true` if `n` is in the range, else `false`.
     * @example
     *
     * _.inRange(3, 2, 4);
     * // => true
     *
     * _.inRange(4, 8);
     * // => true
     *
     * _.inRange(4, 2);
     * // => false
     *
     * _.inRange(2, 2);
     * // => false
     *
     * _.inRange(1.2, 2);
     * // => true
     *
     * _.inRange(5.2, 4);
     * // => false
     */
    function inRange(value, start, end) {
      start = +start || 0;
      if (end === undefined) {
        end = start;
        start = 0;
      } else {
        end = +end || 0;
      }
      return value >= nativeMin(start, end) && value < nativeMax(start, end);
    }

    /**
     * Produces a random number between `min` and `max` (inclusive). If only one
     * argument is provided a number between `0` and the given number is returned.
     * If `floating` is `true`, or either `min` or `max` are floats, a floating-point
     * number is returned instead of an integer.
     *
     * @static
     * @memberOf _
     * @category Number
     * @param {number} [min=0] The minimum possible value.
     * @param {number} [max=1] The maximum possible value.
     * @param {boolean} [floating] Specify returning a floating-point number.
     * @returns {number} Returns the random number.
     * @example
     *
     * _.random(0, 5);
     * // => an integer between 0 and 5
     *
     * _.random(5);
     * // => also an integer between 0 and 5
     *
     * _.random(5, true);
     * // => a floating-point number between 0 and 5
     *
     * _.random(1.2, 5.2);
     * // => a floating-point number between 1.2 and 5.2
     */
    function random(min, max, floating) {
      if (floating && isIterateeCall(min, max, floating)) {
        max = floating = undefined;
      }
      var noMin = min == null,
          noMax = max == null;

      if (floating == null) {
        if (noMax && typeof min == 'boolean') {
          floating = min;
          min = 1;
        }
        else if (typeof max == 'boolean') {
          floating = max;
          noMax = true;
        }
      }
      if (noMin && noMax) {
        max = 1;
        noMax = false;
      }
      min = +min || 0;
      if (noMax) {
        max = min;
        min = 0;
      } else {
        max = +max || 0;
      }
      if (floating || min % 1 || max % 1) {
        var rand = nativeRandom();
        return nativeMin(min + (rand * (max - min + parseFloat('1e-' + ((rand + '').length - 1)))), max);
      }
      return baseRandom(min, max);
    }

    /*------------------------------------------------------------------------*/

    /**
     * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the camel cased string.
     * @example
     *
     * _.camelCase('Foo Bar');
     * // => 'fooBar'
     *
     * _.camelCase('--foo-bar');
     * // => 'fooBar'
     *
     * _.camelCase('__foo_bar__');
     * // => 'fooBar'
     */
    var camelCase = createCompounder(function(result, word, index) {
      word = word.toLowerCase();
      return result + (index ? (word.charAt(0).toUpperCase() + word.slice(1)) : word);
    });

    /**
     * Capitalizes the first character of `string`.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to capitalize.
     * @returns {string} Returns the capitalized string.
     * @example
     *
     * _.capitalize('fred');
     * // => 'Fred'
     */
    function capitalize(string) {
      string = baseToString(string);
      return string && (string.charAt(0).toUpperCase() + string.slice(1));
    }

    /**
     * Deburrs `string` by converting [latin-1 supplementary letters](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block)#Character_table)
     * to basic latin letters and removing [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks).
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to deburr.
     * @returns {string} Returns the deburred string.
     * @example
     *
     * _.deburr('déjà vu');
     * // => 'deja vu'
     */
    function deburr(string) {
      string = baseToString(string);
      return string && string.replace(reLatin1, deburrLetter).replace(reComboMark, '');
    }

    /**
     * Checks if `string` ends with the given target string.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to search.
     * @param {string} [target] The string to search for.
     * @param {number} [position=string.length] The position to search from.
     * @returns {boolean} Returns `true` if `string` ends with `target`, else `false`.
     * @example
     *
     * _.endsWith('abc', 'c');
     * // => true
     *
     * _.endsWith('abc', 'b');
     * // => false
     *
     * _.endsWith('abc', 'b', 2);
     * // => true
     */
    function endsWith(string, target, position) {
      string = baseToString(string);
      target = (target + '');

      var length = string.length;
      position = position === undefined
        ? length
        : nativeMin(position < 0 ? 0 : (+position || 0), length);

      position -= target.length;
      return position >= 0 && string.indexOf(target, position) == position;
    }

    /**
     * Converts the characters "&", "<", ">", '"', "'", and "\`", in `string` to
     * their corresponding HTML entities.
     *
     * **Note:** No other characters are escaped. To escape additional characters
     * use a third-party library like [_he_](https://mths.be/he).
     *
     * Though the ">" character is escaped for symmetry, characters like
     * ">" and "/" don't need escaping in HTML and have no special meaning
     * unless they're part of a tag or unquoted attribute value.
     * See [Mathias Bynens's article](https://mathiasbynens.be/notes/ambiguous-ampersands)
     * (under "semi-related fun fact") for more details.
     *
     * Backticks are escaped because in Internet Explorer < 9, they can break out
     * of attribute values or HTML comments. See [#59](https://html5sec.org/#59),
     * [#102](https://html5sec.org/#102), [#108](https://html5sec.org/#108), and
     * [#133](https://html5sec.org/#133) of the [HTML5 Security Cheatsheet](https://html5sec.org/)
     * for more details.
     *
     * When working with HTML you should always [quote attribute values](http://wonko.com/post/html-escaping)
     * to reduce XSS vectors.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to escape.
     * @returns {string} Returns the escaped string.
     * @example
     *
     * _.escape('fred, barney, & pebbles');
     * // => 'fred, barney, &amp; pebbles'
     */
    function escape(string) {
      // Reset `lastIndex` because in IE < 9 `String#replace` does not.
      string = baseToString(string);
      return (string && reHasUnescapedHtml.test(string))
        ? string.replace(reUnescapedHtml, escapeHtmlChar)
        : string;
    }

    /**
     * Escapes the `RegExp` special characters "\", "/", "^", "$", ".", "|", "?",
     * "*", "+", "(", ")", "[", "]", "{" and "}" in `string`.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to escape.
     * @returns {string} Returns the escaped string.
     * @example
     *
     * _.escapeRegExp('[lodash](https://lodash.com/)');
     * // => '\[lodash\]\(https:\/\/lodash\.com\/\)'
     */
    function escapeRegExp(string) {
      string = baseToString(string);
      return (string && reHasRegExpChars.test(string))
        ? string.replace(reRegExpChars, escapeRegExpChar)
        : (string || '(?:)');
    }

    /**
     * Converts `string` to [kebab case](https://en.wikipedia.org/wiki/Letter_case#Special_case_styles).
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the kebab cased string.
     * @example
     *
     * _.kebabCase('Foo Bar');
     * // => 'foo-bar'
     *
     * _.kebabCase('fooBar');
     * // => 'foo-bar'
     *
     * _.kebabCase('__foo_bar__');
     * // => 'foo-bar'
     */
    var kebabCase = createCompounder(function(result, word, index) {
      return result + (index ? '-' : '') + word.toLowerCase();
    });

    /**
     * Pads `string` on the left and right sides if it's shorter than `length`.
     * Padding characters are truncated if they can't be evenly divided by `length`.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to pad.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padded string.
     * @example
     *
     * _.pad('abc', 8);
     * // => '  abc   '
     *
     * _.pad('abc', 8, '_-');
     * // => '_-abc_-_'
     *
     * _.pad('abc', 3);
     * // => 'abc'
     */
    function pad(string, length, chars) {
      string = baseToString(string);
      length = +length;

      var strLength = string.length;
      if (strLength >= length || !nativeIsFinite(length)) {
        return string;
      }
      var mid = (length - strLength) / 2,
          leftLength = nativeFloor(mid),
          rightLength = nativeCeil(mid);

      chars = createPadding('', rightLength, chars);
      return chars.slice(0, leftLength) + string + chars;
    }

    /**
     * Pads `string` on the left side if it's shorter than `length`. Padding
     * characters are truncated if they exceed `length`.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to pad.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padded string.
     * @example
     *
     * _.padLeft('abc', 6);
     * // => '   abc'
     *
     * _.padLeft('abc', 6, '_-');
     * // => '_-_abc'
     *
     * _.padLeft('abc', 3);
     * // => 'abc'
     */
    var padLeft = createPadDir();

    /**
     * Pads `string` on the right side if it's shorter than `length`. Padding
     * characters are truncated if they exceed `length`.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to pad.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padded string.
     * @example
     *
     * _.padRight('abc', 6);
     * // => 'abc   '
     *
     * _.padRight('abc', 6, '_-');
     * // => 'abc_-_'
     *
     * _.padRight('abc', 3);
     * // => 'abc'
     */
    var padRight = createPadDir(true);

    /**
     * Converts `string` to an integer of the specified radix. If `radix` is
     * `undefined` or `0`, a `radix` of `10` is used unless `value` is a hexadecimal,
     * in which case a `radix` of `16` is used.
     *
     * **Note:** This method aligns with the [ES5 implementation](https://es5.github.io/#E)
     * of `parseInt`.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} string The string to convert.
     * @param {number} [radix] The radix to interpret `value` by.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {number} Returns the converted integer.
     * @example
     *
     * _.parseInt('08');
     * // => 8
     *
     * _.map(['6', '08', '10'], _.parseInt);
     * // => [6, 8, 10]
     */
    function parseInt(string, radix, guard) {
      // Firefox < 21 and Opera < 15 follow ES3 for `parseInt`.
      // Chrome fails to trim leading <BOM> whitespace characters.
      // See https://code.google.com/p/v8/issues/detail?id=3109 for more details.
      if (guard ? isIterateeCall(string, radix, guard) : radix == null) {
        radix = 0;
      } else if (radix) {
        radix = +radix;
      }
      string = trim(string);
      return nativeParseInt(string, radix || (reHasHexPrefix.test(string) ? 16 : 10));
    }

    /**
     * Repeats the given string `n` times.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to repeat.
     * @param {number} [n=0] The number of times to repeat the string.
     * @returns {string} Returns the repeated string.
     * @example
     *
     * _.repeat('*', 3);
     * // => '***'
     *
     * _.repeat('abc', 2);
     * // => 'abcabc'
     *
     * _.repeat('abc', 0);
     * // => ''
     */
    function repeat(string, n) {
      var result = '';
      string = baseToString(string);
      n = +n;
      if (n < 1 || !string || !nativeIsFinite(n)) {
        return result;
      }
      // Leverage the exponentiation by squaring algorithm for a faster repeat.
      // See https://en.wikipedia.org/wiki/Exponentiation_by_squaring for more details.
      do {
        if (n % 2) {
          result += string;
        }
        n = nativeFloor(n / 2);
        string += string;
      } while (n);

      return result;
    }

    /**
     * Converts `string` to [snake case](https://en.wikipedia.org/wiki/Snake_case).
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the snake cased string.
     * @example
     *
     * _.snakeCase('Foo Bar');
     * // => 'foo_bar'
     *
     * _.snakeCase('fooBar');
     * // => 'foo_bar'
     *
     * _.snakeCase('--foo-bar');
     * // => 'foo_bar'
     */
    var snakeCase = createCompounder(function(result, word, index) {
      return result + (index ? '_' : '') + word.toLowerCase();
    });

    /**
     * Converts `string` to [start case](https://en.wikipedia.org/wiki/Letter_case#Stylistic_or_specialised_usage).
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the start cased string.
     * @example
     *
     * _.startCase('--foo-bar');
     * // => 'Foo Bar'
     *
     * _.startCase('fooBar');
     * // => 'Foo Bar'
     *
     * _.startCase('__foo_bar__');
     * // => 'Foo Bar'
     */
    var startCase = createCompounder(function(result, word, index) {
      return result + (index ? ' ' : '') + (word.charAt(0).toUpperCase() + word.slice(1));
    });

    /**
     * Checks if `string` starts with the given target string.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to search.
     * @param {string} [target] The string to search for.
     * @param {number} [position=0] The position to search from.
     * @returns {boolean} Returns `true` if `string` starts with `target`, else `false`.
     * @example
     *
     * _.startsWith('abc', 'a');
     * // => true
     *
     * _.startsWith('abc', 'b');
     * // => false
     *
     * _.startsWith('abc', 'b', 1);
     * // => true
     */
    function startsWith(string, target, position) {
      string = baseToString(string);
      position = position == null
        ? 0
        : nativeMin(position < 0 ? 0 : (+position || 0), string.length);

      return string.lastIndexOf(target, position) == position;
    }

    /**
     * Creates a compiled template function that can interpolate data properties
     * in "interpolate" delimiters, HTML-escape interpolated data properties in
     * "escape" delimiters, and execute JavaScript in "evaluate" delimiters. Data
     * properties may be accessed as free variables in the template. If a setting
     * object is provided it takes precedence over `_.templateSettings` values.
     *
     * **Note:** In the development build `_.template` utilizes
     * [sourceURLs](http://www.html5rocks.com/en/tutorials/developertools/sourcemaps/#toc-sourceurl)
     * for easier debugging.
     *
     * For more information on precompiling templates see
     * [lodash's custom builds documentation](https://lodash.com/custom-builds).
     *
     * For more information on Chrome extension sandboxes see
     * [Chrome's extensions documentation](https://developer.chrome.com/extensions/sandboxingEval).
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The template string.
     * @param {Object} [options] The options object.
     * @param {RegExp} [options.escape] The HTML "escape" delimiter.
     * @param {RegExp} [options.evaluate] The "evaluate" delimiter.
     * @param {Object} [options.imports] An object to import into the template as free variables.
     * @param {RegExp} [options.interpolate] The "interpolate" delimiter.
     * @param {string} [options.sourceURL] The sourceURL of the template's compiled source.
     * @param {string} [options.variable] The data object variable name.
     * @param- {Object} [otherOptions] Enables the legacy `options` param signature.
     * @returns {Function} Returns the compiled template function.
     * @example
     *
     * // using the "interpolate" delimiter to create a compiled template
     * var compiled = _.template('hello <%= user %>!');
     * compiled({ 'user': 'fred' });
     * // => 'hello fred!'
     *
     * // using the HTML "escape" delimiter to escape data property values
     * var compiled = _.template('<b><%- value %></b>');
     * compiled({ 'value': '<script>' });
     * // => '<b>&lt;script&gt;</b>'
     *
     * // using the "evaluate" delimiter to execute JavaScript and generate HTML
     * var compiled = _.template('<% _.forEach(users, function(user) { %><li><%- user %></li><% }); %>');
     * compiled({ 'users': ['fred', 'barney'] });
     * // => '<li>fred</li><li>barney</li>'
     *
     * // using the internal `print` function in "evaluate" delimiters
     * var compiled = _.template('<% print("hello " + user); %>!');
     * compiled({ 'user': 'barney' });
     * // => 'hello barney!'
     *
     * // using the ES delimiter as an alternative to the default "interpolate" delimiter
     * var compiled = _.template('hello ${ user }!');
     * compiled({ 'user': 'pebbles' });
     * // => 'hello pebbles!'
     *
     * // using custom template delimiters
     * _.templateSettings.interpolate = /{{([\s\S]+?)}}/g;
     * var compiled = _.template('hello {{ user }}!');
     * compiled({ 'user': 'mustache' });
     * // => 'hello mustache!'
     *
     * // using backslashes to treat delimiters as plain text
     * var compiled = _.template('<%= "\\<%- value %\\>" %>');
     * compiled({ 'value': 'ignored' });
     * // => '<%- value %>'
     *
     * // using the `imports` option to import `jQuery` as `jq`
     * var text = '<% jq.each(users, function(user) { %><li><%- user %></li><% }); %>';
     * var compiled = _.template(text, { 'imports': { 'jq': jQuery } });
     * compiled({ 'users': ['fred', 'barney'] });
     * // => '<li>fred</li><li>barney</li>'
     *
     * // using the `sourceURL` option to specify a custom sourceURL for the template
     * var compiled = _.template('hello <%= user %>!', { 'sourceURL': '/basic/greeting.jst' });
     * compiled(data);
     * // => find the source of "greeting.jst" under the Sources tab or Resources panel of the web inspector
     *
     * // using the `variable` option to ensure a with-statement isn't used in the compiled template
     * var compiled = _.template('hi <%= data.user %>!', { 'variable': 'data' });
     * compiled.source;
     * // => function(data) {
     * //   var __t, __p = '';
     * //   __p += 'hi ' + ((__t = ( data.user )) == null ? '' : __t) + '!';
     * //   return __p;
     * // }
     *
     * // using the `source` property to inline compiled templates for meaningful
     * // line numbers in error messages and a stack trace
     * fs.writeFileSync(path.join(cwd, 'jst.js'), '\
     *   var JST = {\
     *     "main": ' + _.template(mainText).source + '\
     *   };\
     * ');
     */
    function template(string, options, otherOptions) {
      // Based on John Resig's `tmpl` implementation (http://ejohn.org/blog/javascript-micro-templating/)
      // and Laura Doktorova's doT.js (https://github.com/olado/doT).
      var settings = lodash.templateSettings;

      if (otherOptions && isIterateeCall(string, options, otherOptions)) {
        options = otherOptions = undefined;
      }
      string = baseToString(string);
      options = assignWith(baseAssign({}, otherOptions || options), settings, assignOwnDefaults);

      var imports = assignWith(baseAssign({}, options.imports), settings.imports, assignOwnDefaults),
          importsKeys = keys(imports),
          importsValues = baseValues(imports, importsKeys);

      var isEscaping,
          isEvaluating,
          index = 0,
          interpolate = options.interpolate || reNoMatch,
          source = "__p += '";

      // Compile the regexp to match each delimiter.
      var reDelimiters = RegExp(
        (options.escape || reNoMatch).source + '|' +
        interpolate.source + '|' +
        (interpolate === reInterpolate ? reEsTemplate : reNoMatch).source + '|' +
        (options.evaluate || reNoMatch).source + '|$'
      , 'g');

      // Use a sourceURL for easier debugging.
      var sourceURL = '//# sourceURL=' +
        ('sourceURL' in options
          ? options.sourceURL
          : ('lodash.templateSources[' + (++templateCounter) + ']')
        ) + '\n';

      string.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
        interpolateValue || (interpolateValue = esTemplateValue);

        // Escape characters that can't be included in string literals.
        source += string.slice(index, offset).replace(reUnescapedString, escapeStringChar);

        // Replace delimiters with snippets.
        if (escapeValue) {
          isEscaping = true;
          source += "' +\n__e(" + escapeValue + ") +\n'";
        }
        if (evaluateValue) {
          isEvaluating = true;
          source += "';\n" + evaluateValue + ";\n__p += '";
        }
        if (interpolateValue) {
          source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
        }
        index = offset + match.length;

        // The JS engine embedded in Adobe products requires returning the `match`
        // string in order to produce the correct `offset` value.
        return match;
      });

      source += "';\n";

      // If `variable` is not specified wrap a with-statement around the generated
      // code to add the data object to the top of the scope chain.
      var variable = options.variable;
      if (!variable) {
        source = 'with (obj) {\n' + source + '\n}\n';
      }
      // Cleanup code by stripping empty strings.
      source = (isEvaluating ? source.replace(reEmptyStringLeading, '') : source)
        .replace(reEmptyStringMiddle, '$1')
        .replace(reEmptyStringTrailing, '$1;');

      // Frame code as the function body.
      source = 'function(' + (variable || 'obj') + ') {\n' +
        (variable
          ? ''
          : 'obj || (obj = {});\n'
        ) +
        "var __t, __p = ''" +
        (isEscaping
           ? ', __e = _.escape'
           : ''
        ) +
        (isEvaluating
          ? ', __j = Array.prototype.join;\n' +
            "function print() { __p += __j.call(arguments, '') }\n"
          : ';\n'
        ) +
        source +
        'return __p\n}';

      var result = attempt(function() {
        return Function(importsKeys, sourceURL + 'return ' + source).apply(undefined, importsValues);
      });

      // Provide the compiled function's source by its `toString` method or
      // the `source` property as a convenience for inlining compiled templates.
      result.source = source;
      if (isError(result)) {
        throw result;
      }
      return result;
    }

    /**
     * Removes leading and trailing whitespace or specified characters from `string`.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to trim.
     * @param {string} [chars=whitespace] The characters to trim.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {string} Returns the trimmed string.
     * @example
     *
     * _.trim('  abc  ');
     * // => 'abc'
     *
     * _.trim('-_-abc-_-', '_-');
     * // => 'abc'
     *
     * _.map(['  foo  ', '  bar  '], _.trim);
     * // => ['foo', 'bar']
     */
    function trim(string, chars, guard) {
      var value = string;
      string = baseToString(string);
      if (!string) {
        return string;
      }
      if (guard ? isIterateeCall(value, chars, guard) : chars == null) {
        return string.slice(trimmedLeftIndex(string), trimmedRightIndex(string) + 1);
      }
      chars = (chars + '');
      return string.slice(charsLeftIndex(string, chars), charsRightIndex(string, chars) + 1);
    }

    /**
     * Removes leading whitespace or specified characters from `string`.
     *
     * @static
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to trim.
     * @param {string} [chars=whitespace] The characters to trim.
     * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
     * @returns {string} Returns the trimmed string.
     * @example
     *
     * _.trimLeft('  abc  ');
     * // => 'abc  '
     *
     * _.trimLeft('-_-abc-_-', '_-');
     * // => 'abc-_-'
     */
    function trimLeft(string, chars, guard) {
      var value = string;
   