#!/bin/bash
#
# Sample script, to show the way to get plugin running within sample OOTB store.
#
#
# Prerequisites:
#
# Package of Hybris-2005-2205
# Installed Oracle JDK-11, 64-bit for 2005 to 2105 / JDK-17, 64-bit for 2205
# Configured JAVA_HOME
# Configured Ant-1.9.1+
#
# Make sure you don't have running Hybris.
#

function versionFromZip {
  unzip -p $HYBRIS_PACKAGE hybris/bin/platform/build.number>build_number.txt

  mapfile -t linesFromFile < build_number.txt

  SUB='version.api'

  for ix in ${!linesFromFile[*]}
  do
      if [[ "${linesFromFile[$ix]}" == *"$SUB"* ]]; then
      VERSION=$(echo ${linesFromFile[$ix]} | sed 's/[^0-9]*//g')
      fi
  done

  echo $VERSION

  rm build_number.txt
  return $(( VERSION))
}

jdk_version() {
  local result
  local java_cmd
  if [[ -n $(type -p java) ]]
  then
    java_cmd=java
  elif [[ (-n "$JAVA_HOME") && (-x "$JAVA_HOME/bin/java") ]]
  then
    java_cmd="$JAVA_HOME/bin/java"
  fi
  local IFS=$'\n'
  # remove \r for Cygwin
  local lines=$("$java_cmd" -Xms32M -Xmx32M -version 2>&1 | tr '\r' '\n')
  if [[ -z $java_cmd ]]
  then
    result=no_java
  else
    for line in $lines; do
      if [[ (-z $result) && ($line = *"version \""*) ]]
      then
        local ver=$(echo $line | sed -e 's/.*version "\(.*\)"\(.*\)/\1/; 1q')
        # on macOS, sed doesn't support '?'
        if [[ $ver = "1."* ]]
        then
          result=$(echo $ver | sed -e 's/1\.\([0-9]*\)\(.*\)/\1/; 1q')
        else
          result=$(echo $ver | sed -e 's/\([0-9]*\)\(.*\)/\1/; 1q')
        fi
      fi
    done
  fi
  echo "$result"
}

function chooseHybrisVersion {

  echo " your previous version was: $HYBRIS_VERSION "
  echo "Choose new Hybris version "
  options=("2005" "2011" "2105" "2205")
  select HYBRIS_VERSION in "${options[@]}"
  do
      case $HYBRIS_VERSION in
          "2005")
              break
              ;;
          "2011")
              break
              ;;
          "2105")
              break
              ;;
          "2205")
              break
              ;;
          *) echo "invalid option $REPLY";;
      esac
  done
   echo " you choose $HYBRIS_VERSION "

}

function enterZipAndFolder {
  echo "Enter path to Hybris package with name (start with '/' before path), use tab for completion: "
  read -e HYBRIS_PACKAGE

  echo "Enter output folder name [hybris]: "
  read -e HYBRIS_DIR
  HYBRIS_DIR=${HYBRIS_DIR:-hybris}

}


function enterZipForVersion {
  echo "Enter new HYBRIS.ZIP package path and name for version $HYBRIS_VERSION, use tab for completion: "
  read -e HYBRIS_PACKAGE
  echo "New package is: $HYBRIS_PACKAGE"
}

function enterOprion {
  options=("yes" "no")
  select OPTION in "${options[@]}"
  do
      case $OPTION in
          "yes")
              break
              ;;
          "no")
              break
              ;;
          *) echo "invalid option $REPLY";;
      esac
  done
}

function chooseAcceleretor {
  PS3='Choose Hybris accelerator '
  options=("b2c" "b2b")
  select HYBRIS_ACCELERATOR in "${options[@]}"
  do
      case $HYBRIS_ACCELERATOR in
          "b2c")
              break
              ;;
          "b2b")
              break
              ;;
          *) echo "invalid option $REPLY";;
      esac
  done
}

function chooseIfSpartacusShouldBeInstalled() {
  if [ "$HYBRIS_VERSION" -ge 2005 ]
  then
    echo 'Do you want to install Spartacus related extensions?'
    options=("yes" "no")
    select INSTALL_SPARTACUS in "${options[@]}"; do
      case $INSTALL_SPARTACUS in
        "yes")
          break
          ;;
        "no")
          break
          ;;
          *) echo "invalid option $REPLY" ;;
      esac
    done

    if [ "$INSTALL_SPARTACUS" == "yes" ]
    then
      INSTALL_SPARTACUS="-spa"
    else
      INSTALL_SPARTACUS=""
    fi

  else
    echo "This version does not support Spartacus storefront"
  fi
}

function installHybris {

  echo "starting installation $HYBRIS_VERSION-$HYBRIS_ACCELERATOR$INSTALL_SPARTACUS"

  echo Removing installation...
  rm -fr $HYBRIS_DIR

  echo Unzipping package...
  unzip -q $HYBRIS_PACKAGE -d $HYBRIS_DIR

  echo "======= Adding project sources to Hybris ======="
  rm -rf $HYBRIS_DIR/hybris/bin/custom-paypal-bt
  cp -R plugin/extensions $HYBRIS_DIR/hybris/bin/custom-paypal-bt

  echo "======= Run installer ======="
  cp -r plugin/samples/$HYBRIS_VERSION-$HYBRIS_ACCELERATOR$INSTALL_SPARTACUS/paypal_recipe/ $HYBRIS_DIR/installer/recipes/
  cd $HYBRIS_DIR/installer
  ./install.sh -r paypal_recipe
  cd -

  cd $HYBRIS_DIR/hybris/bin/platform
  
  . ./setantenv.sh

  ant clean all initialize

  ./hybrisserver.sh

}

enterZipAndFolder

echo "You selected $HYBRIS_PACKAGE as package "
echo "You selected $HYBRIS_DIR as output folder " 

HYBRIS_VERSION=$( versionFromZip)
java_version="$(jdk_version)"

if [ "$HYBRIS_VERSION" -le 2105 ] && [ "$java_version" -lt 11 ];
then
  echo "unsupported java version for  hybris v.$HYBRIS_VERSION. Install java 11 for hybris versions greater than 2005"
  exit -1

elif [ "$HYBRIS_VERSION" -ge 2205 ] && [ "$java_version" -lt 17 ];
then
  echo "unsupported java version for  hybris v.$HYBRIS_VERSION. Install java 17 for hybris versions greater than 2205"
  exit -1

else
  echo "success"
fi

echo "You selected hybris v.$HYBRIS_VERSION. CX recipes will be installed. Continue? yes/no"

enterOprion

if [ "$OPTION" == "yes" ]
then

  chooseAcceleretor
  chooseIfSpartacusShouldBeInstalled

  installHybris

else 
  chooseHybrisVersion
  chooseAcceleretor
  chooseIfSpartacusShouldBeInstalled

  enterZipForVersion
  check=$( versionFromZip)

  while [ "$check" != $HYBRIS_VERSION ]; do
     echo "entered zip not equals to choosed Hybris version, please enter right version"
     enterZipForVersion
     check=$( versionFromZip)
  done
  installHybris
fi
