/**
 *
 */
package com.paypal.hybris.validators;

import com.paypal.enums.PayPalPageType;
import org.apache.log4j.Logger;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import java.util.Locale;

public class PayPalButtonTypeValidator implements Validator {

    private static final String INCORRECT_BUTTON_TYPE = "Incorrect buttonType parameter";

    private static final Logger LOG = Logger.getLogger(PayPalButtonTypeValidator.class);

    @Override
    public boolean supports(Class<?> aClass) {
        return String.class.equals(aClass);
    }

    @Override
    public void validate(Object object, Errors errors) {
        final String buttonType = (String) object;
        try {
            PayPalPageType.valueOf(buttonType.toUpperCase(Locale.US));
        } catch (IllegalArgumentException exception) {
            errors.reject(buttonType, INCORRECT_BUTTON_TYPE);
            LOG.error(INCORRECT_BUTTON_TYPE, exception);
        }
    }
}
