/*

 */
package com.paypal.hybris.controllers;

import de.hybris.platform.commercefacades.customer.CustomerFacade;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.commercefacades.user.data.RegisterData;
import de.hybris.platform.commerceservices.customer.DuplicateUidException;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import de.hybris.platform.commercewebservicescommons.dto.user.UserSignUpWsDTO;
import de.hybris.platform.commercewebservicescommons.dto.user.UserWsDTO;
import de.hybris.platform.webservicescommons.cache.CacheControl;
import de.hybris.platform.webservicescommons.cache.CacheControlDirective;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdParam;
import de.hybris.platform.webservicescommons.swagger.ApiFieldsParam;
import de.hybris.platform.ycommercewebservices.constants.YcommercewebservicesConstants;
import de.hybris.platform.ycommercewebservices.v2.controller.BaseCommerceController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@Controller
@RequestMapping(value = "/{baseSiteId}/users")
@CacheControl(directive = CacheControlDirective.PRIVATE)
@Api(tags = "PayPal Users")
public class PayPalUsersController extends BaseCommerceController {

    private static final Logger LOG = LoggerFactory.getLogger(PayPalUsersController.class);

    @Resource(name = "userSignUpDTOValidator")
    private Validator userSignUpDTOValidator;

    @Resource(name = "wsCustomerFacade")
    private CustomerFacade customerFacade;

    @Secured({"ROLE_CLIENT", "ROLE_TRUSTED_CLIENT", "ROLE_CUSTOMERMANAGERGROUP"})
    @RequestMapping(method = RequestMethod.POST, consumes = {MediaType.APPLICATION_JSON_VALUE,
        MediaType.APPLICATION_XML_VALUE})
    @RequestMappingOverride
    @ResponseStatus(value = HttpStatus.CREATED)
    @ResponseBody
    @ApiOperation(nickname = "createUser", value = " Registers a customer", notes =
        "Registers a customer. Requires the following "
            + "parameters: login, password, firstName, lastName, titleCode.")
    @ApiBaseSiteIdParam
    public UserWsDTO createUser(
        @ApiParam(value = "User's object.", required = true) @RequestBody final UserSignUpWsDTO user,
        @ApiFieldsParam @RequestParam(defaultValue = DEFAULT_FIELD_SET) final String fields,
        final HttpServletRequest httpRequest, final HttpServletResponse httpResponse) throws DuplicateUidException {
        validate(user, "user", userSignUpDTOValidator);
        final RegisterData registerData = getDataMapper()
            .map(user, RegisterData.class, "login,password,titleCode,firstName,lastName");
        try {
            customerFacade.register(registerData);
        } catch (final DuplicateUidException ex) {
            LOG.debug("Duplicated UID", ex);
            throw ex;
        }
        final String userId = user.getUid().toLowerCase(Locale.ENGLISH);
        httpResponse.setHeader(YcommercewebservicesConstants.LOCATION, getAbsoluteLocationURL(httpRequest, userId));
        final CustomerData customerData = customerFacade.getUserForUID(userId);
        return getDataMapper().map(customerData, UserWsDTO.class, fields);
    }

    protected String getAbsoluteLocationURL(final HttpServletRequest httpRequest, final String uid) {
        final String requestURL = httpRequest.getRequestURL().toString();
        final String encodedUid = UriUtils.encodePathSegment(uid, StandardCharsets.UTF_8.name());
        return UriComponentsBuilder.fromHttpUrl(requestURL).pathSegment(encodedUid).build().toString();
    }

}
