/**
 *
 */
package com.paypal.hybris.controllers;


import com.paypal.hybris.data.PayPalCheckoutData;
import com.paypal.hybris.data.ws.PayPalCheckoutWsDTO;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalCheckoutFacade;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdAndUserIdParam;
import paypalhac.services.PayPalButtonConfigurationService;
import com.paypal.enums.PayPalPageType;
import com.paypal.hybris.data.ws.PayPalButtonStyleWsDTO;
import com.paypal.hybris.validators.PayPalButtonTypeValidator;
import de.hybris.platform.paypalhac.data.PayPalButtonStyleData;
import de.hybris.platform.ycommercewebservices.v2.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import java.util.Locale;

@Controller
@RequestMapping(value = "/{baseSiteId}")
@Api(tags = "PayPal Payment")
public class PayPalPaymentController extends BaseController {

    @Resource(name = "payPalButtonTypeValidator")
    private PayPalButtonTypeValidator buttonTypeValidator;

    @Resource(name = "payPalButtonConfigurationService")
    private PayPalButtonConfigurationService payPalButtonConfigurationService;

    @Resource(name = "payPalCheckoutFacade")
    private DefaultPayPalCheckoutFacade payPalCheckoutFacade;

    @GetMapping("/users/{userId}/paypal/payment")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdAndUserIdParam
    @ApiOperation(value = " Get the Paypal data for client-side payment initialization",
        notes = "Get a data for all payment methods")
    public PayPalCheckoutWsDTO getCheckoutData(
        @ApiParam(value = "Button type identifier.", allowableValues = "minicart, cart, mark",
            required = true) @RequestParam final String pageType) {
        final PayPalCheckoutData payPalCheckoutData = payPalCheckoutFacade.getPayPalCheckoutData(pageType.toUpperCase(Locale.US));
        return getDataMapper().map(payPalCheckoutData, PayPalCheckoutWsDTO.class);
    }


    @GetMapping("/users/{userId}/paypal/payment/button")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdAndUserIdParam
    @ApiOperation(value = " Get the PayPal Smart Button style data.")
    public PayPalButtonStyleWsDTO getButtonStyle(
        @ApiParam(value = "Button type identifier.", allowableValues = "minicart, cart, mark",
            required = true) @RequestParam final String buttonType) {
        validate(buttonType, buttonType, buttonTypeValidator);
        final PayPalButtonStyleData payPalButtonStyleData = payPalButtonConfigurationService.
            getPayPalButtonStyleByPageType(PayPalPageType.valueOf(buttonType.toUpperCase(Locale.US)));
        return getDataMapper().map(payPalButtonStyleData, PayPalButtonStyleWsDTO.class);
    }
}
