package de.hybris.platform.hac.controller;

import de.hybris.platform.paypalhac.data.PayPalButtonStyleData;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import paypalhac.services.PayPalButtonConfigurationService;
import paypalhac.services.PayPalCatalogSynchronizationService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@Controller
@RequestMapping("/paypalhac")
public class PayPalSmartButtonConfigurationController {

    private static final Logger LOG = Logger.getLogger(PayPalSmartButtonConfigurationController.class);

    private static final String REDIRECT_PREFIX = "redirect:";
    private static final String REDIRECTION_TO_CART_BUTTON_CONFIG_URL = "/paypalhac/button/config/cart";
    private static final String REDIRECTION_TO_MINI_CART_BUTTON_CONFIG_URL = "/paypalhac/button/config/minicart";
    private static final String REDIRECTION_TO_MARK_BUTTON_CONFIG_URL = "/paypalhac/button/config/mark";
    private static final String CART_BUTTON_CONFIG = "cart.button.config";
    private static final String MINI_CART_BUTTON_CONFIG = "mini.cart.button.config";
    private static final String MARK_BUTTON_CONFIG = "mark.button.config";
    private static final String PAYPAL_COMPONENT = "payPalComponent";
    private static final String BUTTON_CONFIG_PAGE = "payPalButtonConfig";
    private static final String PAGE_LABEL = "pageLabel";
    private static final String BUTTON_CONFIG = "buttonConfig";
    private static final String COLOR = "color";
    private static final String SHAPE = "shape";
    private static final String HEIGHT = "height";
    private static final String LABEL = "label";
    private static final String LAYOUT = "layout";

    @Resource(name = "payPalButtonConfigurationService")
    private PayPalButtonConfigurationService payPalButtonConfigurationService;

    @Resource(name = "payPalCatalogSynchronizationService")
    private PayPalCatalogSynchronizationService payPalCatalogSynchronizationService;

    @RequestMapping(value = "/button/config/cart", method = RequestMethod.GET)
    public String saveCartButtonConfig(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        final String buttonStyleConfig = payPalButtonConfigurationService.getProperty(CART_BUTTON_CONFIG);
        final PayPalButtonStyleData buttonStyleData = payPalButtonConfigurationService
            .parsingJsonStringIntoPayPalButtonConfigData(buttonStyleConfig);
        LOG.warn(buttonStyleData);

        setEscentialValues(model);
        model.addAttribute(PAYPAL_COMPONENT, buttonStyleData);
        model.addAttribute(PAGE_LABEL, "Cart Page Smart Button configuration");
        model.addAttribute(BUTTON_CONFIG, CART_BUTTON_CONFIG);

        return BUTTON_CONFIG_PAGE;
    }

    @RequestMapping(value = "/button/config/minicart", method = RequestMethod.GET)
    public String saveMiniCartButtonConfig(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        final String buttonStyleConfig = payPalButtonConfigurationService.getProperty(MINI_CART_BUTTON_CONFIG);
        final PayPalButtonStyleData buttonStyleData = payPalButtonConfigurationService
            .parsingJsonStringIntoPayPalButtonConfigData(buttonStyleConfig);
        LOG.warn(buttonStyleData);

        setEscentialValues(model);
        model.addAttribute(PAYPAL_COMPONENT, buttonStyleData);
        model.addAttribute(PAGE_LABEL, "Mini Cart Smart Button configuration");
        model.addAttribute(BUTTON_CONFIG, MINI_CART_BUTTON_CONFIG);

        return BUTTON_CONFIG_PAGE;
    }

    @RequestMapping(value = "/button/config/mark", method = RequestMethod.GET)
    public String saveMarkButtonConfig(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        final String buttonStyleConfig = payPalButtonConfigurationService.getProperty(MARK_BUTTON_CONFIG);
        final PayPalButtonStyleData buttonStyleData = payPalButtonConfigurationService
            .parsingJsonStringIntoPayPalButtonConfigData(buttonStyleConfig);
        LOG.warn(buttonStyleData);

        setEscentialValues(model);
        model.addAttribute(PAYPAL_COMPONENT, buttonStyleData);
        model.addAttribute(PAGE_LABEL, "Mark Smart Button configuration");
        model.addAttribute(BUTTON_CONFIG, MARK_BUTTON_CONFIG);

        return BUTTON_CONFIG_PAGE;
    }

    private void setEscentialValues(ModelMap model) {
        model.addAttribute(COLOR, payPalButtonConfigurationService.getSmartButtonColor());
        model.addAttribute(SHAPE, payPalButtonConfigurationService.getSmartButtonShape());
        model.addAttribute(HEIGHT, payPalButtonConfigurationService.getSmartButtonHeight());
        model.addAttribute(LABEL, payPalButtonConfigurationService.getSmartButtonLabel());
        model.addAttribute(LAYOUT, payPalButtonConfigurationService.getSmartButtonLayout());
    }

    @RequestMapping(value = "/button/config/saveAll", method = RequestMethod.GET)
    public String saveAllButtonsConfig(HttpServletRequest request, HttpServletResponse response, ModelMap model)
        throws Exception {
        final String buttonConfig = request.getParameter(BUTTON_CONFIG);
        payPalButtonConfigurationService.handleStyleDataUpdate(request, buttonConfig);

        return getRedirectUrl(buttonConfig);
    }

    private static String getRedirectUrl(String buttonConfig) {
        String redirectURL = REDIRECT_PREFIX;

        switch (buttonConfig) {
            case MARK_BUTTON_CONFIG:
                redirectURL = redirectURL.concat(REDIRECTION_TO_MARK_BUTTON_CONFIG_URL);
                break;

            case MINI_CART_BUTTON_CONFIG:
                redirectURL = redirectURL.concat(REDIRECTION_TO_MINI_CART_BUTTON_CONFIG_URL);
                break;

            case CART_BUTTON_CONFIG:
                redirectURL = redirectURL.concat(REDIRECTION_TO_CART_BUTTON_CONFIG_URL);
                break;

        }

        return redirectURL;
    }

    public PayPalCatalogSynchronizationService getPayPalCatalogSynchronizationService() {
        return payPalCatalogSynchronizationService;
    }

    public void setPayPalCatalogSynchronizationService(
        PayPalCatalogSynchronizationService payPalCatalogSynchronizationService) {
        this.payPalCatalogSynchronizationService = payPalCatalogSynchronizationService;
    }
}
