package de.hybris.platform.hac.controller;

import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import paypalhac.services.PayPalComponentConfigurationService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;


@Controller
@RequestMapping("/paypalhac")
public class PayPalCreditMessageConfigurationController {

    private static final String REDIRECT_PREFIX = "redirect:";
    private static final String PRODUCT_GRID_CREDIT_MESSAGE = "PayPalProductGridCreditMessageComponent";
    private static final String PRODUCT_GRID_CREDIT_MESSAGE_B2B = "PayPalProductGridCreditMessageComponentB2B";
    private static final String PRODUCT_LIST_CREDIT_MESSAGE = "PayPalProductListCreditMessageComponent";
    private static final String PRODUCT_LIST_CREDIT_MESSAGE_B2B = "PayPalProductListCreditMessageComponentB2B";
    private static final String PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE = "PayPalProductDetailsPageMessageComponent";
    private static final String PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE_B2B = "PayPalProductDetailsPageMessageComponentB2B";
    private static final String CART_PAGE_CREDIT_MESSAGE = "PayPalCartPageCreditMessageComponent";
    private static final String CART_PAGE_CREDIT_MESSAGE_B2B = "PayPalCartPageCreditMessageComponentB2B";
    private static final String REDIRECTION_TO_GRID_CREDIT_MESSAGE_URL = "/paypalhac/productGridCreditMessage/config";
    private static final String REDIRECTION_TO_LIST_CREDIT_MESSAGE_URL = "/paypalhac/productListCreditMessage/config";
    private static final String REDIRECTION_TO_PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE_URL = "/paypalhac/productDetailsPageCreditMessage/config";
    private static final String REDIRECTION_TO_CART_PAGE_CREDIT_MESSAGE_URL = "/paypalhac/cartPageCreditMessage/config";
    private static final String CREDIT_MESSAGE = "creditMessage";
    private static final String COMPONENT_UID = "componentUid";
    private static final String LABEL = "label";
    private static final String CREDIT_MESSAGE_CONFIG_PAGE = "creditMessageConfig";

    private static final String LAYOUT = "layout";
    private static final String LOGO_TYPE = "logoType";
    private static final String LOGO_POSITION = "logoPosition";
    private static final String TEXT_COLOR = "textColor";
    private static final String COLOR = "color";
    private static final String RATIO = "ratio";
    private static final String UID = "uid";

    @Resource(name = "payPalComponentConfigurationService")
    private PayPalComponentConfigurationService payPalComponentConfigurationService;


    @RequestMapping(value = "/productGridCreditMessage/config", method = RequestMethod.GET)
    public String configureProductGridCreditMessage(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalComponentConfigurationService.processNormalRequest();

        SimpleCMSComponentModel creditMessageComponent = payPalComponentConfigurationService
            .getComponentByUid(PRODUCT_GRID_CREDIT_MESSAGE);
        if (creditMessageComponent == null) {
            creditMessageComponent = payPalComponentConfigurationService
                .getComponentByUid(PRODUCT_GRID_CREDIT_MESSAGE_B2B);
        }

        model.addAttribute(CREDIT_MESSAGE, payPalComponentConfigurationService
            .getCreditMessageItemByUid(creditMessageComponent));
        model.addAttribute(COMPONENT_UID, PRODUCT_GRID_CREDIT_MESSAGE);
        model.addAttribute(LABEL, "Product List Credit Message configuration");
        setEscentialValues(model);

        return CREDIT_MESSAGE_CONFIG_PAGE;
    }

    @RequestMapping(value = "/productListCreditMessage/config", method = RequestMethod.GET)
    public String configureProductListCreditMessage(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalComponentConfigurationService.processNormalRequest();

        SimpleCMSComponentModel creditMessageComponent = payPalComponentConfigurationService
            .getComponentByUid(PRODUCT_LIST_CREDIT_MESSAGE);
        if (creditMessageComponent == null) {
            creditMessageComponent = payPalComponentConfigurationService
                .getComponentByUid(PRODUCT_LIST_CREDIT_MESSAGE_B2B);
        }
        model.addAttribute(COMPONENT_UID, PRODUCT_LIST_CREDIT_MESSAGE);
        model.addAttribute(CREDIT_MESSAGE, payPalComponentConfigurationService
            .getCreditMessageItemByUid(creditMessageComponent));
        model.addAttribute(LABEL, "Product List Credit Message configuration");
        setEscentialValues(model);

        return CREDIT_MESSAGE_CONFIG_PAGE;
    }

    @RequestMapping(value = "/productDetailsPageCreditMessage/config", method = RequestMethod.GET)
    public String configureProductDetailPageCreditMessage(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalComponentConfigurationService.processNormalRequest();

        SimpleCMSComponentModel creditMessageComponent = payPalComponentConfigurationService
            .getComponentByUid(PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE);
        if (creditMessageComponent == null) {
            creditMessageComponent = payPalComponentConfigurationService
                .getComponentByUid(PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE_B2B);
        }

        model.addAttribute(CREDIT_MESSAGE,
            payPalComponentConfigurationService.getCreditMessageItemByUid(creditMessageComponent));
        model.addAttribute(COMPONENT_UID, PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE);
        model.addAttribute(LABEL, "Product Details Page Credit Message configuration");
        setEscentialValues(model);

        return CREDIT_MESSAGE_CONFIG_PAGE;
    }

    @RequestMapping(value = "/cartPageCreditMessage/config", method = RequestMethod.GET)
    public String configureCartPageCreditMessage(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalComponentConfigurationService.processNormalRequest();

        SimpleCMSComponentModel creditMessageComponent = payPalComponentConfigurationService
            .getComponentByUid(CART_PAGE_CREDIT_MESSAGE);
        if (creditMessageComponent == null) {
            creditMessageComponent = payPalComponentConfigurationService
                .getComponentByUid(CART_PAGE_CREDIT_MESSAGE_B2B);
        }

        model.addAttribute(CREDIT_MESSAGE, payPalComponentConfigurationService
            .getCreditMessageItemByUid(creditMessageComponent));
        model.addAttribute(COMPONENT_UID, CART_PAGE_CREDIT_MESSAGE);
        model.addAttribute(LABEL, "Cart Page Credit Message configuration");
        setEscentialValues(model);

        return CREDIT_MESSAGE_CONFIG_PAGE;
    }

    private void setEscentialValues(ModelMap model) {
        model.addAttribute(LAYOUT, payPalComponentConfigurationService.getLayout());
        model.addAttribute(LOGO_TYPE, payPalComponentConfigurationService.getLogoType());
        model.addAttribute(LOGO_POSITION, payPalComponentConfigurationService.getLogoPosition());
        model.addAttribute(TEXT_COLOR, payPalComponentConfigurationService.getTextColor());
        model.addAttribute(COLOR, payPalComponentConfigurationService.getColor());
        model.addAttribute(RATIO, payPalComponentConfigurationService.getRatio());

    }

    @RequestMapping(value = "/saveConfigs", method = RequestMethod.GET)
    public String saveCreditMessageConfigs(HttpServletRequest request, HttpServletResponse response, ModelMap model)
        throws CMSItemNotFoundException {

        Map<String, String[]> refreshedParameters = new HashMap<>(request.getParameterMap());
        final String creditMessageComponentUid = Arrays.stream(refreshedParameters.get(UID)).findFirst().get();
        refreshedParameters.remove(UID);

        payPalComponentConfigurationService.processComponentUpdating(creditMessageComponentUid, refreshedParameters);

        return getRedirectUrl(creditMessageComponentUid);
    }

    private static String getRedirectUrl(final String creditMessageUid) {
        String redirectURL = REDIRECT_PREFIX;

        switch (creditMessageUid) {
            case PRODUCT_GRID_CREDIT_MESSAGE:
            case PRODUCT_GRID_CREDIT_MESSAGE_B2B:
                redirectURL = redirectURL.concat(REDIRECTION_TO_GRID_CREDIT_MESSAGE_URL);
                break;

            case PRODUCT_LIST_CREDIT_MESSAGE:
            case PRODUCT_LIST_CREDIT_MESSAGE_B2B:
                redirectURL = redirectURL.concat(REDIRECTION_TO_LIST_CREDIT_MESSAGE_URL);
                break;

            case PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE:
            case PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE_B2B:
                redirectURL = redirectURL.concat(REDIRECTION_TO_PRODUCT_DETAILS_PAGE_CREDIT_MESSAGE_URL);
                break;

            case CART_PAGE_CREDIT_MESSAGE:
            case CART_PAGE_CREDIT_MESSAGE_B2B:
                redirectURL = redirectURL.concat(REDIRECTION_TO_CART_PAGE_CREDIT_MESSAGE_URL);
                break;

        }

        return redirectURL;
    }

}
