/*

 */
package de.hybris.platform.hac.controller;

import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import paypalhac.services.PayPalConnectConfigurationService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;


@Controller
@RequestMapping("/paypalhac")
public class PayPalConnectButtonConfigurationController {

    private static final String REDIRECT_PREFIX = "redirect:";
    private static final String CONNECT_WITH_PAYPAL = "PayPalConnectButtonComponent";
    private static final String CONNECT_WITH_PAYPAL_B2B = "PayPalConnectButtonComponentB2B";
    private static final String REDIRECTION_TO_CONNECT_WITH_PAYPAL_URL = "/paypalhac/connectWithPayPalButton/config";
    private static final String PAYPAL_CONNECT = "payPalConnect";
    private static final String COMPONENT_UID = "componentUid";
    private static final String LABEL = "label";
    private static final String PAYPAL_CONNECT_CONFIG_PAGE = "payPalConnectConfig";

    private static final String BUTTON_TYPE = "buttonType";
    private static final String BUTTON_SHAPE = "buttonShape";
    private static final String BUTTON_SIZE = "buttonSize";
    private static final String BUTTON_THEME = "buttonTheme";
    private static final String UID = "uid";

    @Resource(name = "payPalConnectConfigurationService")
    private PayPalConnectConfigurationService payPalConnectConfigurationService;


    @RequestMapping(value = "/connectWithPayPalButton/config", method = RequestMethod.GET)
    public String configureConnectWithPayPal(HttpServletRequest request, HttpServletResponse response,
        ModelMap model) throws CMSItemNotFoundException {

        payPalConnectConfigurationService.processNormalRequest();

        SimpleCMSComponentModel payPalConnectComponent = payPalConnectConfigurationService
            .getComponentByUid(CONNECT_WITH_PAYPAL);
        if (payPalConnectComponent == null) {
            payPalConnectComponent = payPalConnectConfigurationService
                .getComponentByUid(CONNECT_WITH_PAYPAL_B2B);
        }

        model.addAttribute(PAYPAL_CONNECT, payPalConnectConfigurationService
            .getPayPalConnectItemByUid(payPalConnectComponent));
        model.addAttribute(COMPONENT_UID, CONNECT_WITH_PAYPAL);
        model.addAttribute(LABEL, "Connect With PayPal Button Configuration");
        setEscentialValues(model);

        return PAYPAL_CONNECT_CONFIG_PAGE;
    }

    private void setEscentialValues(ModelMap model) {
        model.addAttribute(BUTTON_TYPE, payPalConnectConfigurationService.getButtonType());
        model.addAttribute(BUTTON_SHAPE, payPalConnectConfigurationService.getButtonShape());
        model.addAttribute(BUTTON_SIZE, payPalConnectConfigurationService.getButtonSize());
        model.addAttribute(BUTTON_THEME, payPalConnectConfigurationService.getButtonTheme());

    }

    @RequestMapping(value = "/savePayPalConnectConfigs", method = RequestMethod.GET)
    public String savePayPalConnectConfigs(HttpServletRequest request, HttpServletResponse response, ModelMap model)
        throws CMSItemNotFoundException {

        Map<String, String[]> refreshedParameters = new HashMap<>(request.getParameterMap());
        final String payPalConnectComponentUid = Arrays.stream(refreshedParameters.get(UID)).findFirst().get();
        refreshedParameters.remove(UID);

        payPalConnectConfigurationService.processComponentUpdating(payPalConnectComponentUid, refreshedParameters);

        return getRedirectUrl();
    }

    private static String getRedirectUrl() {
        String redirectURL = REDIRECT_PREFIX;

        redirectURL = redirectURL.concat(REDIRECTION_TO_CONNECT_WITH_PAYPAL_URL);

        return redirectURL;
    }

}
