<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<% pageContext.setAttribute("newLineChar", "\n"); %>
<!DOCTYPE html>
<html lang="en" xml:lang="en">
<head>
    <title>Connect With PayPal Button Config</title>

</head>
<body>

<div class="marginLeft prepend-top span-17">

    <h2>${label}</h2>

    <div class="dataTable no-footer">
        <form action="/hac/paypalhac/savePayPalConnectConfigs/" method="GET">
            <div id="buttonTypeContainer">
                <label for="buttonType"> Choose a button type:</label>
                <select name="buttonType" id="buttonType">
                    <c:forEach var="item" items="${buttonType}">
                        <option value="${item}" ${item == payPalConnect.buttonType ? 'selected="selected"' : ''}>${item.toLowerCase()}</option>
                    </c:forEach>
                </select>
            </div>
            <div id="buttonShapeContainer">
                <label for="buttonShape"> Choose a button shape:</label>
                <select name="buttonShape" id="buttonShape">
                    <c:forEach var="item" items="${buttonShape}">
                        <option value="${item}" ${item == payPalConnect.buttonShape ? 'selected="selected"' : ''}>${item.toLowerCase()}</option>
                    </c:forEach>
                </select>
                <br/>
            </div>
            <div id="buttonSizeContainer">
                <label for="buttonSize"> Choose a button size:</label>
                <select name="buttonSize" id="buttonSize">
                    <c:forEach var="item" items="${buttonSize}">
                        <option value="${item}" ${item == payPalConnect.buttonSize ? 'selected="selected"' : ''}>${item.toLowerCase()}</option>
                    </c:forEach>
                </select>
            </div>
            <div id="buttonThemeContainer">
                <label for="buttonTheme"> Choose a button theme:</label>
                <select name="buttonTheme" id="buttonTheme">
                    <c:forEach var="item" items="${buttonTheme}">
                        <option value="${item}" ${item == payPalConnect.buttonTheme ? 'selected="selected"' : ''}>${item.toLowerCase()}</option>
                    </c:forEach>
                </select>
                <br/>
            </div>

            <input name="uid" value="${componentUid}" type="hidden"/>

            <div id="checkbox">
                <label>
                    <input id="hiddenEnabledPayPalConnect" name="enabled" type="hidden"/>
                    <input id="enabledPayPalConnect" name="enabled" type="checkbox" value="true" ${payPalConnect.enabled == true ? 'checked' : ''} />
                    Enable Connect With PayPal
                </label>
            </div>

            <br></br>
            <input type="submit" value="Save">
            <br></br>
        </form>
    </div>
</div>

<script>
  $(document).on('submit', 'form', function() {
    if($("#enabledPayPalConnect").is(':checked')){
      $("#hiddenEnabledPayPalConnect").prop('disabled', true);
    } else {
      $("#hiddenEnabledPayPalConnect").attr('value', 'false');
    }
  });
</script>

</body>
</html>
