/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.paypal.controller;

import com.paypal.service.PaypalfulfilmentprocessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;

import static com.paypal.constants.PaypalfulfilmentprocessConstants.PLATFORM_LOGO_CODE;


@Controller
public class PaypalfulfilmentprocessHelloController {

    private static final String LOGO_URL = "logoUrl";
    private static final String WELCOME = "welcome";
    @Autowired
    private PaypalfulfilmentprocessService paypalfulfilmentprocessService;

    @GetMapping(value = "/")
    public String printWelcome(final ModelMap model) {
        model.addAttribute(LOGO_URL, paypalfulfilmentprocessService.getHybrisLogoUrl(PLATFORM_LOGO_CODE));
        return WELCOME;
    }
}
