package com.paypal.action;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.orderprocessing.model.OrderProcessModel;
import de.hybris.platform.payment.PaymentService;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.yacceleratorfulfilmentprocess.actions.order.TakePaymentAction;
import org.apache.log4j.Logger;


public class PayPalTakePaymentAction extends TakePaymentAction {

    private static final Logger LOG = Logger.getLogger(PayPalTakePaymentAction.class);

    private PaymentService payPalPaymentService;

    @Override
    public Transition executeAction(final OrderProcessModel process) {
        final OrderModel order = process.getOrder();
        if (!(order.getPaymentInfo() instanceof PayPalCreditCardPaymentInfoModel)) {
            super.executeAction(process);
        }
        if (checkCaptureTransactionEntry(order)) {
            return Transition.OK;
        }

        return order.getPaymentTransactions().stream()
            .filter(txn -> txn.getInfo() instanceof PayPalCreditCardPaymentInfoModel)
            .map(txn -> {
                if (TransactionStatus.ACCEPTED.name()
                    .equals(getPayPalPaymentService().capture(txn).getTransactionStatus())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(
                            "The payment transaction has been captured. Order: " + order.getCode() + ". Txn: " + txn
                                .getCode());
                    }
                    setOrderStatus(order, OrderStatus.PAYMENT_CAPTURED);
                    return Transition.OK;
                } else {
                    LOG.error("The payment transaction capture has failed. Order: " + order.getCode() + ". Txn: " + txn
                        .getCode());
                    setOrderStatus(order, OrderStatus.PAYMENT_NOT_CAPTURED);
                    return Transition.NOK;
                }
            }).findFirst().orElse(Transition.OK);
    }

    private boolean checkCaptureTransactionEntry(final OrderModel order) {
        return order.getPaymentTransactions().stream()
            .anyMatch(transaction -> transaction.getEntries().stream()
                .anyMatch(entry -> PaymentTransactionType.CAPTURE.equals(entry.getType())
                    || PaymentTransactionType.PARTIAL_CAPTURE
                    .equals(entry.getType())));
    }


    public PaymentService getPayPalPaymentService() {
        return payPalPaymentService;
    }

    public void setPayPalPaymentService(PaymentService payPalPaymentService) {
        this.payPalPaymentService = payPalPaymentService;
    }
}
