/*
 * [y] hybris Platform
 *
 * Copyright (c) 2018 SAP SE or an SAP affiliate company. All rights reserved.
 *
 * This software is the confidential and proprietary information of SAP
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with SAP.
 */
package com.paypal.hybris.facade.controller;

import com.paypal.hybris.facade.service.PaypalfacadesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;

import static com.paypal.hybris.facade.constants.PaypalfacadesConstants.PLATFORM_LOGO_CODE;


@Controller
public class PaypalfacadesHelloController {

    private static final String LOGO_URL = "logoUrl";
    private static final String WELCOME = "welcome";
    @Autowired
    private PaypalfacadesService paypalfacadesService;

    @GetMapping(value = "/")
    public String printWelcome(final ModelMap model) {
        model.addAttribute(LOGO_URL, paypalfacadesService.getHybrisLogoUrl(PLATFORM_LOGO_CODE));
        return WELCOME;
    }
}
