/*
 * [y] hybris Platform
 *
 * Copyright (c) 2018 SAP SE or an SAP affiliate company. All rights reserved.
 *
 * This software is the confidential and proprietary information of SAP
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with SAP.
 */
package com.paypal.hybris.facade.service.impl;

import com.paypal.hybris.facade.service.PaypalfacadesService;
import de.hybris.bootstrap.annotations.IntegrationTest;
import de.hybris.platform.core.model.media.MediaModel;
import de.hybris.platform.servicelayer.ServicelayerBaseTest;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import org.junit.Before;
import org.junit.Test;

import javax.annotation.Resource;

import static com.paypal.hybris.facade.constants.PaypalfacadesConstants.PLATFORM_LOGO_CODE;
import static org.fest.assertions.Assertions.assertThat;


/**
 * This is an example of how the integration test should look like. {@link ServicelayerBaseTest} bootstraps platform so
 * you have an access to all Spring beans as well as database connection. It also ensures proper cleaning out of items
 * created during the test after it finishes. You can inject any Spring service using {@link Resource} annotation. Keep
 * in mind that by default it assumes that annotated field name matches the Spring Bean ID.
 */
@IntegrationTest
public class DefaultPaypalfacadesServiceIntegrationTest extends ServicelayerBaseTest {

    @Resource
    private PaypalfacadesService paypalfacadesService;
    @Resource
    private FlexibleSearchService flexibleSearchService;

    @Before
    public void setUp() throws Exception {
        paypalfacadesService.createLogo(PLATFORM_LOGO_CODE);
    }

    @Test
    public void shouldReturnProperUrlForLogo() throws Exception {
        // given
        final String logoCode = "paypalfacadesPlatformLogo";

        // when
        final String logoUrl = paypalfacadesService.getHybrisLogoUrl(logoCode);

        // then
        assertThat(logoUrl).isNotNull();
        assertThat(logoUrl).isEqualTo(findLogoMedia(logoCode).getURL());
    }

    private MediaModel findLogoMedia(final String logoCode) {
        final FlexibleSearchQuery fQuery = new FlexibleSearchQuery("SELECT {PK} FROM {Media} WHERE {code}=?code");
        fQuery.addQueryParameter("code", logoCode);

        return flexibleSearchService.searchUnique(fQuery);
    }

}
