/**
 *
 */
package com.paypal.hybris.facade.populator;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.core.PK;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class PayPalCreditCardPaymentInfoPopulatorTest {

    private static final String EMAIL = "email";
    private static final String PAYER_ID = "payer_id";
    private static final String PAYPAL_ORDER_ID = "paypal_order_id";

    @Mock
    private Populator<CreditCardPaymentInfoModel, CCPaymentInfoData> populator;

    @Mock
    private PayPalCreditCardPaymentInfoModel source;

    @Mock
    private CCPaymentInfoData target;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        populator = new PayPalCreditCardPaymentInfoPopulator();

        when(source.getPk()).thenReturn(PK.BIG_PK);
        when(source.getPayerEmail()).thenReturn(EMAIL);
        when(source.getPayerId()).thenReturn(PAYER_ID);
        when(source.getPayPalOrderId()).thenReturn(PAYPAL_ORDER_ID);

    }

    @Test
    public void emailIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setPayerEmail(EMAIL);
    }

    @Test
    public void payerIdIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setPayerId(PAYER_ID);
    }

    @Test
    public void payPalOrderIdIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setPayPalOrderId(PAYPAL_ORDER_ID);
    }

}
