/**
 *
 */
package com.paypal.hybris.facade.populator;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.RegionData;
import de.hybris.platform.converters.Populator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PayPalAddressDataReversePopulatorTest {

    private static final String FIRST_NAME = "first_name";
    private static final String LAST_NAME = "first_name";
    private static final String EMAIL = "email";
    private static final String COUNTRY_CODE = "country_code";
    private static final String REGION = "region";
    private static final String LINE_1 = "line_1";
    private static final String LINE_2 = "line_2";
    private static final String POSTAL_CODE = "postal_code";
    private static final String CITY = "city";


    @Mock
    private Populator<AddressData, PayPalAddressDetailsData> populator;

    @Mock
    private AddressData source;

    @Mock
    private PayPalAddressDetailsData target;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        populator = new PayPalAddressDataReversePopulator();

        final CountryData country = Mockito.mock(CountryData.class);
        final RegionData region = Mockito.mock(RegionData.class);

        when(source.getFirstName()).thenReturn(FIRST_NAME);
        when(source.getLastName()).thenReturn(LAST_NAME);
        when(source.getEmail()).thenReturn(EMAIL);
        when(source.getCountry()).thenReturn(country);
        when(country.getIsocode()).thenReturn(COUNTRY_CODE);
        when(source.getRegion()).thenReturn(region);
        when(region.getIsocodeShort()).thenReturn(REGION);
        when(source.getLine1()).thenReturn(LINE_1);
        when(source.getLine2()).thenReturn(LINE_2);
        when(source.getPostalCode()).thenReturn(POSTAL_CODE);
        when(source.getTown()).thenReturn(CITY);
    }

    @Test
    public void firstNameIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setFirstName(FIRST_NAME);
    }

    @Test
    public void lastNameIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setFirstName(LAST_NAME);
    }

    @Test
    public void emailIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setEmail(EMAIL);
    }

    @Test
    public void line1IsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setLine1(LINE_1);
    }

    @Test
    public void line2IsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setLine2(LINE_2);
    }

    @Test
    public void postalCodeIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setPostalCode(POSTAL_CODE);
    }

    @Test
    public void cityIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setCity(CITY);
    }

    @Test
    public void countryCodeIsNull() {
        populator.populate(source, target);
        when(source.getCountry()).thenReturn(null);
        Assert.assertNull(target.getCountryCode());
    }

    @Test
    public void regionIsNull() {
        populator.populate(source, target);
        when(source.getRegion()).thenReturn(null);
        Assert.assertNull(target.getRegion());
    }

    @Test
    public void countryIsNotNull() {
        populator.populate(source, target);
        verify(target).setCountryCode(COUNTRY_CODE);
    }

    @Test
    public void regionIsNotNull() {
        populator.populate(source, target);
        verify(target).setRegion(REGION);
    }

}
