/**
 *
 */
package com.paypal.hybris.facade.populator;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.converters.Populator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;


@UnitTest
public class PayPalAddressDataPopulatorTest {

    private static final String FIRST_NAME = "first_name";
    private static final String LAST_NAME = "first_name";
    private static final String EMAIL = "email";
    private static final String COUNTRY_CODE = "country_code";
    private static final String REGION = "region";
    private static final String LINE_1 = "line_1";
    private static final String LINE_2 = "line_2";
    private static final String POSTAL_CODE = "postal_code";
    private static final String CITY = "city";


    @Mock
    private Populator<PayPalAddressDetailsData, AddressData> populator;

    @Mock
    private PayPalAddressDetailsData source;

    @Mock
    private AddressData target;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        populator = new PayPalAddressDataPopulator();

        when(source.getFirstName()).thenReturn(FIRST_NAME);
        when(source.getLastName()).thenReturn(LAST_NAME);
        when(source.getEmail()).thenReturn(EMAIL);
        when(source.getCountryCode()).thenReturn(COUNTRY_CODE);
        when(source.getRegion()).thenReturn(REGION);
        when(source.getLine1()).thenReturn(LINE_1);
        when(source.getLine2()).thenReturn(LINE_2);
        when(source.getPostalCode()).thenReturn(POSTAL_CODE);
        when(source.getCity()).thenReturn(CITY);
    }

    @Test
    public void firstNameIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setFirstName(FIRST_NAME);
    }

    @Test
    public void lastNameIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setFirstName(LAST_NAME);
    }

    @Test
    public void emailIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setEmail(EMAIL);
    }

    @Test
    public void line1IsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setLine1(LINE_1);
    }

    @Test
    public void line2IsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setLine2(LINE_2);
    }

    @Test
    public void postalCodeIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setPostalCode(POSTAL_CODE);
    }

    @Test
    public void cityIsSetOnDataTarget() {
        populator.populate(source, target);
        verify(target).setTown(CITY);
    }

    @Test
    public void countryCodeIsNull() {
        populator.populate(source, target);
        when(source.getCountryCode()).thenReturn(null);
        Assert.assertNull(target.getCountry());
    }

    @Test
    public void regionIsNull() {
        populator.populate(source, target);
        when(source.getRegion()).thenReturn(null);
        Assert.assertNull(target.getRegion());
    }

}
