/**
 *
 */
package com.paypal.hybris.facade.impl;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalButtonRenderDecisionMakerFacade;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.user.UserFacade;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import de.hybris.platform.commercefacades.user.data.AddressData;


@UnitTest
public class DefaultPayPalButtonRenderDecisionMakerFacadeTest {

    private static final String PAYPAL = "paypal".intern();
    private static final String CREDIT = "credit".intern();

    @Mock
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;

    @Mock
    private UserFacade userFacade;

    @InjectMocks
    private DefaultPayPalButtonRenderDecisionMakerFacade unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void isExpressCheckoutStaticImageFlowTrue() {

        final CartData cartData = Mockito.mock(CartData.class);
        final CCPaymentInfoData infoData = Mockito.mock(CCPaymentInfoData.class);
        final AddressData addressData = Mockito.mock(AddressData.class);

        when(defaultPayPalConfigurationService.isBillingAgreementEnabled()).thenReturn(true);
        when(userFacade.isAnonymousUser()).thenReturn(false);

        when(cartData.getPaymentInfo()).thenReturn(infoData);
        when(cartData.getPaymentInfo().getCardType()).thenReturn(PAYPAL);

        when(userFacade.getDefaultAddress()).thenReturn(addressData);
        when(cartData.getDeliveryAddress()).thenReturn(addressData);

        Assert.assertTrue(unit.isExpressCheckoutStaticImageFlow(cartData));

    }

    @Test
    public void isExpressCheckoutStaticImageFlowBillingAgreementFalse() {

        final CartData cartData = Mockito.mock(CartData.class);

        when(defaultPayPalConfigurationService.isBillingAgreementEnabled()).thenReturn(false);
        when(userFacade.isAnonymousUser()).thenReturn(true);

        Assert.assertFalse(unit.isExpressCheckoutStaticImageFlow(cartData));

    }

    @Test
    public void isExpressCheckoutStaticImageFlowHasPaymentFalse() {

        final CartData cartData = Mockito.mock(CartData.class);
        final CCPaymentInfoData infoData = Mockito.mock(CCPaymentInfoData.class);
        final AddressData addressData = Mockito.mock(AddressData.class);

        when(defaultPayPalConfigurationService.isBillingAgreementEnabled()).thenReturn(true);
        when(userFacade.isAnonymousUser()).thenReturn(false);

        when(cartData.getPaymentInfo()).thenReturn(infoData);
        when(cartData.getPaymentInfo().getCardType()).thenReturn(CREDIT);

        when(userFacade.getDefaultAddress()).thenReturn(addressData);
        when(cartData.getDeliveryAddress()).thenReturn(addressData);

        Assert.assertFalse(unit.isExpressCheckoutStaticImageFlow(cartData));

    }

    @Test
    public void isExpressCheckoutStaticImageFlowHasShippingFalse() {

        final CartData cartData = Mockito.mock(CartData.class);
        final CCPaymentInfoData infoData = Mockito.mock(CCPaymentInfoData.class);

        when(defaultPayPalConfigurationService.isBillingAgreementEnabled()).thenReturn(true);
        when(userFacade.isAnonymousUser()).thenReturn(false);

        when(cartData.getPaymentInfo()).thenReturn(infoData);
        when(cartData.getPaymentInfo().getCardType()).thenReturn(PAYPAL);

        when(userFacade.getDefaultAddress()).thenReturn(null);
        when(cartData.getDeliveryAddress()).thenReturn(null);

        Assert.assertFalse(unit.isExpressCheckoutStaticImageFlow(cartData));

    }

    @Test
    public void isExpressCheckoutBillingAgreementFlowTrue() {

        when(defaultPayPalConfigurationService.isBillingAgreementEnabled()).thenReturn(true);
        when(userFacade.isAnonymousUser()).thenReturn(false);

        Assert.assertTrue(unit.isExpressCheckoutBillingAgreementFlow());

    }

    @Test
    public void isExpressCheckoutBillingAgreementFlowFalse() {

        when(defaultPayPalConfigurationService.isBillingAgreementEnabled()).thenReturn(false);
        when(userFacade.isAnonymousUser()).thenReturn(false);

        Assert.assertFalse(unit.isExpressCheckoutBillingAgreementFlow());

    }


}
