/*

 */
package com.paypal.hybris.facade.facades.impl;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import com.paypal.hybris.facade.facades.PayPalCheckoutFacade;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.customer.CustomerFacade;
import de.hybris.platform.commerceservices.customer.DuplicateUidException;
import de.hybris.platform.servicelayer.session.SessionService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalGuestCheckoutFacadeTest {

    private static final String ANONYMOUS_USER_UID = "anonymous";
    private static final String ANONYMOUS_CHECKOUT = "anonymous_checkout";
    private static final String NOT_ANONYMOUS_CHECKOUT = "not_anonymous_checkout";
    private static final String UID_PART = "|second_part";
    private static final String ANONYMOUS_CHECKOUT_GUID = "anonymous_checkout_guid";
    private static final String FIRST_NAME = "firstName";
    private static final String EMAIL = "email@gmail.com";

    @Mock
    private CustomerFacade customerFacade;

    @Mock
    private PayPalCheckoutFacade checkoutFacade;

    @Mock
    private SessionService sessionService;

    @InjectMocks
    private DefaultPayPalGuestCheckoutFacade unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void processCheckoutForAnonymousShouldCreateGuestUserWithExceptedEmailAndFirstName()
        throws DuplicateUidException {
        final PayPalAddressDetailsData payPalAddressDetailsData = Mockito.mock(PayPalAddressDetailsData.class);
        when(payPalAddressDetailsData.getEmail()).thenReturn(EMAIL);
        when(payPalAddressDetailsData.getFirstName()).thenReturn(FIRST_NAME);
        when(checkoutFacade.getCurrentSessionUserUid()).thenReturn(ANONYMOUS_USER_UID);
        unit.processCheckoutForAnonymous(payPalAddressDetailsData);
        verify(sessionService).setAttribute(ANONYMOUS_CHECKOUT, true);
        verify(customerFacade).createGuestUserForAnonymousCheckout(EMAIL, FIRST_NAME);
    }

    @Test
    public void processCheckoutForAnonymousShouldCreateGuestUserAndSetGuidForNotAnonymousUser()
        throws DuplicateUidException {
        final PayPalAddressDetailsData payPalAddressDetailsData = Mockito.mock(PayPalAddressDetailsData.class);
        when(payPalAddressDetailsData.getEmail()).thenReturn(EMAIL);
        when(payPalAddressDetailsData.getFirstName()).thenReturn(FIRST_NAME);
        when(checkoutFacade.getCurrentSessionUserUid()).thenReturn(NOT_ANONYMOUS_CHECKOUT + UID_PART);
        unit.processCheckoutForAnonymous(payPalAddressDetailsData);
        verify(sessionService).setAttribute(ANONYMOUS_CHECKOUT, true);
        verify(customerFacade).createGuestUserForAnonymousCheckout(EMAIL, FIRST_NAME);
        verify(sessionService).setAttribute(ANONYMOUS_CHECKOUT_GUID, NOT_ANONYMOUS_CHECKOUT);
    }
}
