/*

 */
package com.paypal.hybris.facade.facades.impl;

import static org.junit.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import com.paypal.hybris.data.PayPalOrderDetailsData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.address.AddressVerificationFacade;
import de.hybris.platform.commercefacades.address.data.AddressVerificationResult;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commerceservices.address.AddressVerificationDecision;
import de.hybris.platform.commerceservices.delivery.DeliveryService;
import de.hybris.platform.commerceservices.order.CommerceCheckoutService;
import de.hybris.platform.commerceservices.strategies.CheckoutCustomerStrategy;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.core.model.user.TitleModel;
import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.order.CartService;
import de.hybris.platform.servicelayer.model.ModelService;
import java.util.UUID;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

@UnitTest
public class DefaultPayPalCheckoutFacadeTest {

    private static final String PAYMENT_METHOD_TYPE = "paypal";
    private static final String NAME = "name";

    @Mock
    private AddressVerificationFacade addressVerificationFacade;

    @Mock
    private UserFacade userFacade;

    @Mock
    private CartFacade cartFacade;

    @Mock
    private CartService cartService;

    @Mock
    private DeliveryService deliveryService;

    @Mock
    private CommerceCheckoutService checkoutService;

    @Mock
    private ModelService modelService;

    @Mock
    private CheckoutCustomerStrategy customerStrategy;

    @Mock
    private Populator<PayPalAddressDetailsData, AddressData> payPalAddressDataPopulator;

    @Mock
    private Populator<AddressData, AddressModel> addressReversePopulator;

    @Spy
    @InjectMocks
    private DefaultPayPalCheckoutFacade unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldSuccessfullyProcessExpressCheckout() {
        final String code = UUID.randomUUID().toString();
        final String id = UUID.randomUUID().toString();
        final PayPalOrderDetailsData orderDetails = Mockito.mock(PayPalOrderDetailsData.class);
        final PayPalAddressDetailsData addressDetailsData = Mockito.mock(PayPalAddressDetailsData.class);
        final AddressData addressData = Mockito.mock(AddressData.class);
        final AddressModel addressModel = Mockito.mock(AddressModel.class);
        final CartData cartData = Mockito.mock(CartData.class);
        final CartModel cart = Mockito.mock(CartModel.class);
        final CustomerModel customer = Mockito.mock(CustomerModel.class);
        final UserModel user = Mockito.mock(UserModel.class);
        final TitleModel title = Mockito.mock(TitleModel.class);
        final AddressVerificationResult verificationResult = Mockito.mock(AddressVerificationResult.class);
        final CCPaymentInfoData payPalPaymentSubscription = Mockito.mock(CCPaymentInfoData.class);

        when(orderDetails.getShippingAddress()).thenReturn(addressDetailsData);
        when(customerStrategy.getCurrentUserForCheckout()).thenReturn(customer);
        when(customer.getTitle()).thenReturn(title);
        when(title.getName()).thenReturn(NAME);
        when(title.getCode()).thenReturn(code);
        when(userFacade.getDefaultAddress()).thenReturn(addressData);
        when(addressVerificationFacade.verifyAddressData(any())).thenReturn(verificationResult);
        when(verificationResult.getDecision()).thenReturn(AddressVerificationDecision.ACCEPT);
        when(cartFacade.getSessionCart()).thenReturn(cartData);
        when(cartFacade.hasSessionCart()).thenReturn(true);
        when(cartService.getSessionCart()).thenReturn(cart);
        when(cartData.getDeliveryAddress()).thenReturn(addressData);
        when(addressData.isVisibleInAddressBook()).thenReturn(true);
        when(orderDetails.getAmount()).thenReturn("10.0");
        when(cart.getTotalPrice()).thenReturn(10.0);
        when(modelService.create(AddressModel.class)).thenReturn(addressModel);
        doReturn(payPalPaymentSubscription).when(unit).createPayPalPaymentSubscriptionForExpressCheckout(orderDetails, PAYMENT_METHOD_TYPE);
        when(payPalPaymentSubscription.getId()).thenReturn(id);
        when(cart.getUser()).thenReturn(user);

        assertTrue(unit.processExpressCheckout(orderDetails, PAYMENT_METHOD_TYPE));
        verify(unit).setCheapestDeliveryModeForCheckout();
        verify(unit).createPayPalPaymentSubscriptionForExpressCheckout(orderDetails, PAYMENT_METHOD_TYPE);
        verify(unit).setPaymentDetails(id);
    }
}
