package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.commercefacades.order.converters.populator.CreditCardPaymentInfoPopulator;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;


public class PayPalCreditCardPaymentInfoPopulator extends CreditCardPaymentInfoPopulator {

    @Override
    public void populate(final CreditCardPaymentInfoModel source,
        final CCPaymentInfoData target) throws ConversionException {
        super.populate(source, target);
        if (source instanceof PayPalCreditCardPaymentInfoModel) {
            target.setPayerEmail(((PayPalCreditCardPaymentInfoModel) source).getPayerEmail());
            target.setPayerId(((PayPalCreditCardPaymentInfoModel) source).getPayerId());
            target.setPayPalOrderId(((PayPalCreditCardPaymentInfoModel) source).getPayPalOrderId());
        }
    }
}
