package com.paypal.hybris.facade.populator;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;


public class PayPalAddressDataReversePopulator implements Populator<AddressData, PayPalAddressDetailsData> {

    @Override
    public void populate(AddressData source, PayPalAddressDetailsData target)
        throws ConversionException {
        target.setFirstName(source.getFirstName());
        target.setLastName(source.getLastName());
        target.setEmail(source.getEmail());
        if (source.getCountry().getIsocode() != null) {
            final String countryCode = source.getCountry().getIsocode();
            target.setCountryCode(countryCode);
        }
        if (source.getRegion() != null) {
            final String region = source.getRegion().getIsocodeShort();
            target.setRegion(region);
        }
        target.setLine1(source.getLine1());
        target.setLine2(source.getLine2());
        target.setPostalCode(source.getPostalCode());
        target.setCity(source.getTown());
    }
}
