/*

 */
package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.service.PayPalConnectService;
import com.paypal.hybris.data.PayPalConnectUserData;
import com.paypal.hybris.facade.facades.PayPalRegistrationUserFacade;
import de.hybris.platform.commercefacades.customer.CustomerFacade;
import de.hybris.platform.commercefacades.user.data.RegisterData;
import de.hybris.platform.commerceservices.customer.DuplicateUidException;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.Arrays;
import java.util.List;

/**
 * This class is a default implementation of the PayPalRegistrationUserFacade interface
 */
public class DefaultPayPalRegistrationUserFacade implements PayPalRegistrationUserFacade {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalRegistrationUserFacade.class);
    private static final String EMPTY = "";
    private static final String SPACE = " ";

    private CustomerFacade customerFacade;
    private PayPalConnectService payPalConnectService;
    private ModelService modelService;
    private UserService userService;

    @Override
    public String registerPayPalUser(final String accessToken) throws DuplicateUidException {
        final PayPalConnectUserData userData = payPalConnectService.getUserDataByAccessToken(accessToken);
        final RegisterData data = createRegistrationForm(userData);
        String payerId = StringUtils.EMPTY;
        try {
            customerFacade.register(data);
            setPayerIdToUser(data.getLogin().toLowerCase(), userData.getPayer_id());
            payerId = userData.getPayer_id();
        } catch (DuplicateUidException e) {
            LOG.error("Id for this user already exists");
            throw e;
        } catch (Exception e) {
            LOG.error("Invalid credentials",e);
        }
        return payerId;
    }

    /**
     * This method is used to set payer id for user
     * @param id id
     * @param payerId payer id
     */
    public void setPayerIdToUser(final String id, final String payerId) {
        CustomerModel customer = (CustomerModel) userService.getUserForUID(id);
        customer.setPayPalPayerId(payerId);
        modelService.save(customer);
    }

    private RegisterData createRegistrationForm(final PayPalConnectUserData userData) {
        RegisterData registerData = new RegisterData();
        registerData.setLogin(userData.getEmails().stream().findFirst().get().getValue());
        registerData.setFirstName(getSplitName(userData.getName()));
        registerData.setLastName(getSplitSurname(userData.getName()));
        registerData.setPassword(EMPTY);
        return registerData;
    }

    private static String getSplitName(final String userName) {
        List<String> array = Arrays.asList(userName.split(SPACE));
        return array.stream().findFirst().orElse(EMPTY);
    }

    private static String getSplitSurname(final String userName) {
        List<String> array = Arrays.asList(userName.split(SPACE));
        return array.stream().reduce((first, second) -> second).orElse(EMPTY);
    }

    public CustomerFacade getCustomerFacade() {
        return customerFacade;
    }

    public void setCustomerFacade(CustomerFacade customerFacade) {
        this.customerFacade = customerFacade;
    }

    public PayPalConnectService getPayPalConnectService() {
        return payPalConnectService;
    }

    public void setPayPalConnectService(PayPalConnectService payPalConnectService) {
        this.payPalConnectService = payPalConnectService;
    }

    public ModelService getModelService() {
        return modelService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public UserService getUserService() {
        return userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}
