/*

 */
package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import com.paypal.hybris.facade.facades.PayPalButtonRenderDecisionMakerFacade;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.core.enums.CreditCardType;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;

import static com.paypal.hybris.core.constants.GeneratedPaypalcoreConstants.Enumerations.CreditCardType.CARD;
import static com.paypal.hybris.core.constants.GeneratedPaypalcoreConstants.Enumerations.CreditCardType.PAYPAL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_COMMA;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CREDIT_FUNDING;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_CART_PAGE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_MARK_PAGE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_MINI_CART;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_EMPTY_STRING;

/**
 * This method is a default implementation of PayPalButtonRenderDecisionMakerFacade interface
 */
public class DefaultPayPalButtonRenderDecisionMakerFacade implements PayPalButtonRenderDecisionMakerFacade {

    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;
    private UserFacade userFacade;

    /**
     * This method is used to get disable funding
     * @param page page
     * @return disable funding
     */
    public String getDisableFunding(final String page) {
        String result;
        if (PAYPAL_DISABLE_FUNDING_MARK_PAGE.equalsIgnoreCase(page)) {
            result = defaultPayPalConfigurationService.getDisableFundingMarkPage();
        } else if (PAYPAL_DISABLE_FUNDING_CART_PAGE.equalsIgnoreCase(page)) {
            result = defaultPayPalConfigurationService.getDisableFundingCartPage();
        } else if (PAYPAL_DISABLE_FUNDING_MINI_CART.equalsIgnoreCase(page)) {
            result = defaultPayPalConfigurationService.getDisableFundingMiniCart();
        } else {
            result = PAYPAL_EMPTY_STRING;
        }
        return String.format("%s%s", result, getCreditShouldBeDisable(result));
    }

    private String getCreditShouldBeDisable(final String disableFunding) {
        boolean isCreditShouldBeDisable = defaultPayPalConfigurationService.isBillingAgreementEnabled();
        if(isCreditShouldBeDisable) {
            return disableFunding.isEmpty() ? PAYPAL_CREDIT_FUNDING : PAYPAL_COMMA + PAYPAL_CREDIT_FUNDING;
        }
        return PAYPAL_EMPTY_STRING;
    }

    @Override
    public boolean isExpressCheckoutStaticImageFlow(final CartData cartData) {
        if (!isBillingAgreementFlowAvailable()) {
            return false;
        }
        final boolean hasPayment = hasPaymentForStaticImageFlow() || hasActivePayPalPaymentInTheSession(cartData);
        final boolean hasShipping = userFacade.getDefaultAddress() != null || cartData.getDeliveryAddress() != null;
        return hasPayment && hasShipping;
    }

    @Override
    public boolean isPaymentMethodSupportStaticImage(String type) {
        return PAYPAL.equalsIgnoreCase(type) || CARD.equalsIgnoreCase(type);
    }

    @Override
    public boolean isPaymentMethodSupportStaticImage(PaymentInfoModel model) {
        boolean result = false;
        if(model instanceof PayPalCreditCardPaymentInfoModel) {
            CreditCardType type = ((PayPalCreditCardPaymentInfoModel) model).getType();
            result = isPaymentMethodSupportStaticImage(type.getCode());
        }
        return result;
    }

    @Override
    public boolean isExpressCheckoutBillingAgreementFlow() {
        return isBillingAgreementFlowAvailable() && !hasPaymentForStaticImageFlow();
    }

    @Override
    public boolean isMarkCheckoutBillingAgreementFlow() {
        return isBillingAgreementFlowAvailable();
    }

    private boolean hasPaymentForStaticImageFlow() {
        return !userFacade.isAnonymousUser() &&
            userFacade.getCCPaymentInfos(true)
                .stream()
                .anyMatch(method -> isPaymentMethodSupportStaticImage(method.getCardType()));
    }

    private boolean hasActivePayPalPaymentInTheSession(final CartData cartData) {
        return cartData.getPaymentInfo() != null && PAYPAL.equals(cartData.getPaymentInfo().getCardType());
    }

    private boolean isBillingAgreementFlowAvailable() {
        return defaultPayPalConfigurationService.isBillingAgreementEnabled();
    }

    public DefaultPayPalConfigurationService getDefaultPayPalConfigurationService() {
        return defaultPayPalConfigurationService;
    }

    public void setDefaultPayPalConfigurationService(DefaultPayPalConfigurationService defaultPayPalConfigurationService) {
        this.defaultPayPalConfigurationService = defaultPayPalConfigurationService;
    }

    public UserFacade getUserFacade() {
        return userFacade;
    }

    public void setUserFacade(UserFacade userFacade) {
        this.userFacade = userFacade;
    }
}
