/*

 */
package com.paypal.hybris.facade.facades.impl;

import static com.paypal.hybris.core.constants.GeneratedPaypalcoreConstants.Enumerations.CreditCardType.PAYPAL;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.acceleratorfacades.order.impl.DefaultAcceleratorCheckoutFacade;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.core.model.order.CartModel;

public class DefaultPayPalAuthorizationCheckoutFacade extends DefaultAcceleratorCheckoutFacade {

    private static final String PAYPAL_ORDER_ID_PLACEHOLDER = "ORDER_ID_PLACEHOLDER";
    private static final String PAYPAL_CREDIT_CARD_PAYMENT_INFO = "PayPalCreditCardPaymentInfo";

    private UserFacade userFacade;

    @Override
    public ExpressCheckoutResult performExpressCheckout() {
        if (isExpressCheckoutEnabledForStore()) {
            final ExpressCheckoutResult expressCheckoutDeliveryResult = getExpressCheckoutDeliveryResult();
            if (expressCheckoutDeliveryResult != null) {
                return expressCheckoutDeliveryResult;
            }

            if (!setDefaultPaymentInfoForCheckout()) {
                return ExpressCheckoutResult.ERROR_PAYMENT_INFO;
            }
            final CartModel cartModel = getCart();
            if ((isPaymentMethodAndShippingAddressSaved(getCartFacade().getSessionCart())) && (cartModel.getPaymentInfo().getItemtype()
                .equals(PAYPAL_CREDIT_CARD_PAYMENT_INFO))) {
                ((PayPalCreditCardPaymentInfoModel) cartModel.getPaymentInfo()).setSubscriptionId(PAYPAL_ORDER_ID_PLACEHOLDER);
                getModelService().save(cartModel.getPaymentInfo());
                getModelService().refresh(cartModel);
            }
            return ExpressCheckoutResult.SUCCESS;
        }

        return ExpressCheckoutResult.ERROR_NOT_AVAILABLE;
    }

    private boolean isPaymentMethodAndShippingAddressSaved(final CartData cartData) {
        final boolean hasPayment = hasSavedPayPalPayment() || hasActivePayPalPaymentInTheSession(cartData);
        final boolean hasShipping = userFacade.getDefaultAddress() != null || cartData.getDeliveryAddress() != null;
        return hasPayment && hasShipping;
    }

    private boolean hasSavedPayPalPayment() {
        return !userFacade.isAnonymousUser() &&
            userFacade.getCCPaymentInfos(true).stream().anyMatch(a -> PAYPAL.equals(a.getCardType()));
    }

    private boolean hasActivePayPalPaymentInTheSession(final CartData cartData) {
        return cartData.getPaymentInfo() != null && PAYPAL.equals(cartData.getPaymentInfo().getCardType());
    }

    public UserFacade getUserFacade() {
        return userFacade;
    }

    public void setUserFacade(UserFacade userFacade) {
        this.userFacade = userFacade;
    }

}
