package com.paypal.hybris.facade.facades;


import com.paypal.hybris.data.PayPalBillingAgreementData;
import com.paypal.hybris.data.PayPalCheckoutData;
import com.paypal.hybris.data.PayPalConnectAddressData;
import com.paypal.hybris.data.PayPalOrderDetailsData;
import de.hybris.platform.acceleratorfacades.order.AcceleratorCheckoutFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.order.data.OrderData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.enums.CreditCardType;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.order.InvalidCartException;


public interface PayPalCheckoutFacade extends AcceleratorCheckoutFacade {

    boolean processExpressCheckout(final PayPalOrderDetailsData orderDetailsData, String paymentMethodType);

    CCPaymentInfoData createPayPalPaymentSubscriptionForExpressCheckout(final PayPalOrderDetailsData orderDetailsData,
        String paymentMethodType);

    CCPaymentInfoData createPayPalPaymentSubscriptionForMarkCheckout(final String orderId, CreditCardType paymentType);

    CCPaymentInfoData createPayPalPaymentSubscription(final PayPalBillingAgreementData billingAgreementData,
        final String payPalOrderId, boolean savePaymentInfo, final String paymentMethodType);

    CCPaymentInfoData createPayPalPaymentSubscriptionForNewUser(final PayPalBillingAgreementData billingAgreementDetails,
        final String payPalOrderId, final String paymentMethodType, final String payerId);

    void addAddressForNewUser(final PayPalConnectAddressData addressData, final String payerId);

    CCPaymentInfoData updatePayPalPaymentSubscription(PayPalOrderDetailsData orderDetailsData,
        CCPaymentInfoData paymentInfoData);

    PayPalOrderDetailsData getPayPalOrderDetails(final String orderId);

    String createBillingAgreementToken(final boolean skipShippingAddress);

    PayPalBillingAgreementData createBillingAgreement(final String billingAgreementToken);

    String getCurrentSessionUserUid();

    String createPayPalOrder();

    void updateCheckoutPaymentInfoOrderId(final String orderId);

    CCPaymentInfoData processBillingAgreementExpressCheckout();

    void setDeliveryAddressForCheckout(AddressData addressData);

    boolean isPickupInStore();

    boolean isLocalPaymentFlow();

    boolean authorizePayment(final CartModel cartModel);

    void prepareCartForCheckout(final CartModel cartModel);

    OrderData placeOrderByCart(final CartModel cartModel) throws InvalidCartException;

    PayPalCheckoutData getPayPalCheckoutData(final String pageType);

    CreditCardType setCreditCardType(final String fundingSource);

}
