/**
 *
 */
package com.paypal.hybris.core.validator;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.core.model.c2l.RegionModel;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class PayPalAddressDetailValidatorTest {

    public static final String COUNTY_ISO_CODE_TEST = "UA";
    public static final String REGION_ISO_CODE_TEST = "ZA";
    public static final String COUNTRY_REGION_ISO_CODE_TEST = "UA-ZA";

    @Mock
    private CommonI18NService commonI18NService;

    @InjectMocks
    private PayPalAddressDetailValidator unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void validatePayPalCountryCodeWithEmptyCodeShouldReturnFalse() {
        Assert.assertFalse(unit.validatePayPalCountryCode(""));
    }

    @Test
    public void validatePayPalCountryCodeWithExistingCountryCode() {
        CountryModel countryModel = Mockito.mock(CountryModel.class);
        when(countryModel.getIsocode()).thenReturn(COUNTY_ISO_CODE_TEST);
        List<CountryModel> countryModels = new ArrayList<>();
        countryModels.add(countryModel);
        when(commonI18NService.getAllCountries()).thenReturn(countryModels);

        Assert.assertTrue(unit.validatePayPalCountryCode(COUNTY_ISO_CODE_TEST));
        verify(commonI18NService).getAllCountries();
    }

    @Test
    public void validatePayPalRegionCodeWithEmptyCodeShouldReturnFalse() {
        Assert.assertFalse(unit.validatePayPalRegionCode("", ""));
    }

    @Test
    public void validatePayPalRegionCodeWithExistingRegionShouldReturnTrue() {
        RegionModel regionModel = Mockito.mock(RegionModel.class);
        when(regionModel.getIsocode()).thenReturn(COUNTRY_REGION_ISO_CODE_TEST);
        List<RegionModel> regionModels = new ArrayList<>();
        regionModels.add(regionModel);
        when(commonI18NService.getAllRegions()).thenReturn(regionModels);

        Assert.assertTrue(unit.validatePayPalRegionCode(COUNTY_ISO_CODE_TEST, REGION_ISO_CODE_TEST));
        verify(commonI18NService).getAllRegions();
    }
}

