/**
 *
 */
package com.paypal.hybris.core.strategy;

import static org.mockito.Mockito.when;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentService;
import com.paypal.hybris.core.strategy.impl.DefaultPayPalCommercePaymentAuthorizationStrategy;
import de.hybris.platform.commerceservices.service.data.CommerceCheckoutParameter;
import de.hybris.platform.commerceservices.strategies.GenerateMerchantTransactionCodeStrategy;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.payment.PaymentService;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.servicelayer.i18n.I18NService;
import de.hybris.platform.servicelayer.model.ModelService;
import java.math.BigDecimal;
import java.util.Currency;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultPayPalCommercePaymentAuthorizationStrategyTest {

    private static final String PROVIDER = "provider";
    private static final String USD = "USD";
    private static final String CODE = "code";
    private static final String ID = "id";
    private static final String BILLING_ID = "billing_id";

    @Mock
    private ModelService modelService;

    @Mock
    private GenerateMerchantTransactionCodeStrategy codeStrategy;

    @Mock
    private I18NService i18nService;

    @Mock
    private PayPalPaymentService payPalPaymentService;

    @Mock
    private PaymentService paymentService;

    @InjectMocks
    DefaultPayPalCommercePaymentAuthorizationStrategy unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void authorizePaymentAmountReturnNull() {

        final CommerceCheckoutParameter parameter = Mockito.mock(CommerceCheckoutParameter.class);
        final PaymentInfoModel infoModel = Mockito.mock(PaymentInfoModel.class);
        final CartModel cartModel = Mockito.mock(CartModel.class);
        final BigDecimal amount = Mockito.mock(BigDecimal.class);

        when(parameter.getCart()).thenReturn(cartModel);
        when(parameter.getAuthorizationAmount()).thenReturn(amount);
        when(cartModel.getPaymentInfo()).thenReturn(infoModel);

        Assert.assertNull(unit.authorizePaymentAmount(parameter));

    }

    @Test
    public void authorizePaymentAmountReturnNotNull() {

        final CommerceCheckoutParameter parameter = Mockito.mock(CommerceCheckoutParameter.class);
        final PaymentTransactionEntryModel entryModel = Mockito.mock(PaymentTransactionEntryModel.class);
        final PaymentTransactionModel transactionModel = Mockito.mock(PaymentTransactionModel.class);
        final PayPalCreditCardPaymentInfoModel paymentInfoModel = Mockito.mock(PayPalCreditCardPaymentInfoModel.class);
        final CartModel cartModel = Mockito.mock(CartModel.class);
        final CurrencyModel currencyModel = Mockito.mock(CurrencyModel.class);
        final Currency currency = Currency.getInstance(USD);

        when(parameter.getCart()).thenReturn(cartModel);
        when(parameter.getAuthorizationAmount()).thenReturn(BigDecimal.ONE);
        when(parameter.getPaymentProvider()).thenReturn(PROVIDER);
        when(cartModel.getPaymentInfo()).thenReturn(paymentInfoModel);

        when(paymentInfoModel.getSubscriptionId()).thenReturn(ID);
        when(paymentInfoModel.getBillingAgreementId()).thenReturn(BILLING_ID);

        when(cartModel.getCurrency()).thenReturn(currencyModel);
        when(i18nService.getBestMatchingJavaCurrency(cartModel.getCurrency().getIsocode())).thenReturn(currency);

        when(codeStrategy.generateCode(cartModel)).thenReturn(CODE);

        when(paymentService.authorize(CODE, BigDecimal.ONE, currency, cartModel.getDeliveryAddress(), ID, BILLING_ID, PROVIDER)).thenReturn(entryModel);

        when(entryModel.getPaymentTransaction()).thenReturn(transactionModel);

        Assert.assertNotNull(unit.authorizePaymentAmount(parameter));

    }

}
