/**
 *
 */
package com.paypal.hybris.core.service.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.model.CatalogUnawareMediaModel;
import de.hybris.platform.core.model.media.MediaModel;
import de.hybris.platform.servicelayer.media.MediaService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPaypalCoreServiceTest {

    public static final String TEST_HYBRIS_LOGO = "TEST_LOGO";

    @Mock
    private MediaService mediaService;

    @Mock
    private ModelService modelService;

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private DefaultPaypalCoreService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void testGetHybrisLogoUrl() {
        final MediaModel mediaModel = Mockito.mock(MediaModel.class);

        when(mediaService.getMedia(TEST_HYBRIS_LOGO)).thenReturn(mediaModel);
        unit.getHybrisLogoUrl(TEST_HYBRIS_LOGO);

        verify(mediaService).getMedia(TEST_HYBRIS_LOGO);
        verify(mediaModel).getURL();
    }

    @Test
    public void testCreateLogo() {
        final CatalogUnawareMediaModel model = Mockito.mock(CatalogUnawareMediaModel.class);
        when(flexibleSearchService.searchUnique(any(FlexibleSearchQuery.class))).thenReturn(model);

        unit.createLogo(TEST_HYBRIS_LOGO);

        verify(model).setCode(TEST_HYBRIS_LOGO);
        verify(modelService).save(model);
    }
}
