/**
 *
 */
package com.paypal.hybris.core.service.impl;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.dao.PayPalCartToOrderCronJobDao;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.servicelayer.model.ModelService;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalReplenishmentServiceTest {

    private static final String BILLING_AGREEMENT_ID = "BILLING_AGREEMENT_ID";

    @Mock
    private PayPalCartToOrderCronJobDao cartToOrderCronJobDao;

    @Mock
    private ModelService modelService;

    @InjectMocks
    private DefaultPayPalReplenishmentService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void disableReplenishmentCronJobByBillingAgreementIdShouldSetActiveFalseForFoundedCronJobs() {
        final CartToOrderCronJobModel cronJobModel = Mockito.mock(CartToOrderCronJobModel.class);
        when(cartToOrderCronJobDao.findCronJobsByBillingAgreement(BILLING_AGREEMENT_ID))
            .thenReturn(Collections.singletonList(cronJobModel));

        unit.disableReplenishmentCronJobByBillingAgreement(BILLING_AGREEMENT_ID);
        verify(cronJobModel).setActive(Boolean.FALSE);
        verify(modelService).save(cronJobModel);
    }

}
