/**
 *
 */
package com.paypal.hybris.core.service.impl;

import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.dao.impl.DefaultPayPalCustomerAccountDao;
import com.paypal.hybris.core.dao.impl.DefaultPayPalPaymentInfoDao;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentInfoService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.model.ModelService;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalPaymentInfoServiceTest {

    private static final String PAYER_ID = "PAYER_ID";

    private static final String BILLING_AGREEMENT_ID = "BILLING_AGREEMENT_ID";

    @Mock
    private DefaultPayPalPaymentInfoDao payPalPaymentInfoDao;

    @Mock
    private DefaultPayPalCustomerAccountDao payPalCustomerAccountDao;

    @Mock
    private ModelService modelService;

    @InjectMocks
    private final PayPalPaymentInfoService paymentInfoService = new DefaultPayPalPaymentInfoService();

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldNotDisable() {
        final PayPalCreditCardPaymentInfoModel paymentInfoModel = Mockito.mock(PayPalCreditCardPaymentInfoModel.class);
        final CustomerModel customerModel = Mockito.mock(CustomerModel.class);

        when(customerModel.getPaymentInfos()).thenReturn(Collections.emptyList());
        when(payPalPaymentInfoDao.find(PAYER_ID, BILLING_AGREEMENT_ID)).thenReturn(paymentInfoModel);
        when(payPalCustomerAccountDao.findCustomerByBillingAgreementId(BILLING_AGREEMENT_ID)).thenReturn(customerModel);

        paymentInfoService.disable(PAYER_ID, BILLING_AGREEMENT_ID);
        verify(payPalPaymentInfoDao).find(PAYER_ID, BILLING_AGREEMENT_ID);
        verify(payPalCustomerAccountDao).findCustomerByBillingAgreementId(BILLING_AGREEMENT_ID);
        verify(paymentInfoModel, never()).setDuplicate(Boolean.TRUE);
    }

    @Test
    public void shouldDisable() {
        final PayPalCreditCardPaymentInfoModel paymentInfoModel = Mockito.mock(PayPalCreditCardPaymentInfoModel.class);
        final CustomerModel customerModel = Mockito.mock(CustomerModel.class);

        when(customerModel.getPaymentInfos()).thenReturn(Collections.singletonList(paymentInfoModel));
        when(payPalPaymentInfoDao.find(PAYER_ID, BILLING_AGREEMENT_ID)).thenReturn(paymentInfoModel);
        when(payPalCustomerAccountDao.findCustomerByBillingAgreementId(BILLING_AGREEMENT_ID)).thenReturn(customerModel);

        paymentInfoService.disable(PAYER_ID, BILLING_AGREEMENT_ID);
        verify(payPalPaymentInfoDao).find(PAYER_ID, BILLING_AGREEMENT_ID);
        verify(payPalCustomerAccountDao).findCustomerByBillingAgreementId(BILLING_AGREEMENT_ID);
        verify(paymentInfoModel).setDuplicate(Boolean.TRUE);
        verify(modelService).save(paymentInfoModel);
        verify(modelService).refresh(customerModel);
    }

}
