/**
 *
 */
package com.paypal.hybris.core.service.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.payment.commands.result.CaptureResult;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.dto.TransactionStatusDetails;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.methods.CardPaymentService;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.servicelayer.i18n.I18NService;
import de.hybris.platform.servicelayer.model.ModelService;
import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalManualMultiCaptureServiceTest {

    public static final String CURRENCY_ISO_CODE = "USD";

    @Mock
    private ModelService modelService;

    @Mock
    private I18NService i18nService;

    @Mock
    private CardPaymentService cardPaymentService;

    @InjectMocks
    private DefaultPayPalManualMultiCaptureService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void doMultiCaptureWithCorrectDataShouldNotTrowExceptions() {
        final CaptureResult captureResult = Mockito.mock(CaptureResult.class);
        when(captureResult.getTransactionStatus()).thenReturn(TransactionStatus.ACCEPTED);
        when(captureResult.getTransactionStatusDetails()).thenReturn(TransactionStatusDetails.SUCCESFULL);
        when(cardPaymentService.capture(any())).thenReturn(captureResult);

        final BigDecimal amount = BigDecimal.TEN;
        final PaymentTransactionEntryModel paymentTransactionEntryModel = Mockito.mock(PaymentTransactionEntryModel.class);
        final PaymentTransactionModel paymentTransactionModel = Mockito.mock(PaymentTransactionModel.class);
        final CurrencyModel currencyModel = Mockito.mock(CurrencyModel.class);

        when(currencyModel.getIsocode()).thenReturn(CURRENCY_ISO_CODE);
        when(paymentTransactionEntryModel.getPaymentTransaction()).thenReturn(paymentTransactionModel);
        when(paymentTransactionEntryModel.getCurrency()).thenReturn(currencyModel);

        unit.doMultiCapture(amount, paymentTransactionEntryModel, PaymentTransactionType.AUTHORIZATION);
        verify(captureResult).getCurrency();
        verify(captureResult).getTransactionStatus();
        verify(captureResult).getTransactionStatusDetails();
    }
}

