/**
 *
 */
package com.paypal.hybris.core.service.impl;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_PROVIDER_NAME;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentService;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.payment.commands.SubscriptionAuthorizationCommand;
import de.hybris.platform.payment.commands.factory.CommandFactory;
import de.hybris.platform.payment.commands.factory.CommandFactoryRegistry;
import de.hybris.platform.payment.commands.factory.CommandNotSupportedException;
import de.hybris.platform.payment.commands.result.AuthorizationResult;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.dto.TransactionStatusDetails;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.servicelayer.i18n.I18NService;
import de.hybris.platform.servicelayer.model.ModelService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultPayPalManualAuthorizationServiceTest {

    public static final String CURRENCY_ISO_CODE_TEST = "USD";

    public static final String ORDER_ID_TEST = "testOrderId";

    @Mock
    private ModelService modelService;

    @Mock
    private CommandFactoryRegistry commandFactoryRegistry;

    @Mock
    private PayPalPaymentService payPalPaymentService;

    @Mock
    private I18NService i18nService;

    @InjectMocks
    private DefaultPayPalManualAuthorizationService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void testDoAuthorizationWithSuccessfulResult() throws CommandNotSupportedException {
        CommandFactory commandFactory = Mockito.mock(CommandFactory.class);
        SubscriptionAuthorizationCommand command = Mockito.mock(SubscriptionAuthorizationCommand.class);
        AuthorizationResult result = Mockito.mock(AuthorizationResult.class);

        when(commandFactoryRegistry.getFactory(PAYPAL_PROVIDER_NAME)).thenReturn(commandFactory);
        when(commandFactory.createCommand(SubscriptionAuthorizationCommand.class)).thenReturn(command);
        when(command.perform(any())).thenReturn(result);
        when(result.getTransactionStatus()).thenReturn(TransactionStatus.ACCEPTED);
        when(result.getTransactionStatusDetails()).thenReturn(TransactionStatusDetails.SUCCESFULL);

        BigDecimal amount = BigDecimal.TEN;
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        CurrencyModel currencyModel = Mockito.mock(CurrencyModel.class);
        UserModel userModel = Mockito.mock(UserModel.class);
        PayPalCreditCardPaymentInfoModel paymentInfoModel = Mockito.mock(PayPalCreditCardPaymentInfoModel.class);

        PaymentTransactionModel paymentTransactionModel = Mockito.mock(PaymentTransactionModel.class);
        List<PaymentTransactionModel> paymentTransactionModels = new ArrayList<>();
        paymentTransactionModels.add(paymentTransactionModel);

        when(orderModel.getPaymentTransactions()).thenReturn(paymentTransactionModels);
        when(currencyModel.getIsocode()).thenReturn(CURRENCY_ISO_CODE_TEST);
        when(orderModel.getCurrency()).thenReturn(currencyModel);
        when(orderModel.getUser()).thenReturn(userModel);
        when(orderModel.getPaymentInfo()).thenReturn(paymentInfoModel);
        when(payPalPaymentService.createOrder(CURRENCY_ISO_CODE_TEST, amount.toString(), null))
            .thenReturn(ORDER_ID_TEST);

        unit.doAuthorization(orderModel, amount);

        verify(paymentTransactionModel).setPlannedAmount(any());
        verify(modelService).save(paymentTransactionModel);
    }

    @Test
    public void testDoAuthorizationWhenThrowsCommandNotSupportedException() throws CommandNotSupportedException {
        CommandFactory commandFactory = Mockito.mock(CommandFactory.class);
        when(commandFactoryRegistry.getFactory(PAYPAL_PROVIDER_NAME)).thenReturn(commandFactory);
        when(commandFactory.createCommand(SubscriptionAuthorizationCommand.class))
            .thenThrow(CommandNotSupportedException.class);

        BigDecimal amount = BigDecimal.TEN;
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        CurrencyModel currencyModel = Mockito.mock(CurrencyModel.class);
        UserModel userModel = Mockito.mock(UserModel.class);
        PayPalCreditCardPaymentInfoModel paymentInfoModel = Mockito.mock(PayPalCreditCardPaymentInfoModel.class);

        PaymentTransactionModel paymentTransactionModel = Mockito.mock(PaymentTransactionModel.class);
        List<PaymentTransactionModel> paymentTransactionModels = new ArrayList<>();
        paymentTransactionModels.add(paymentTransactionModel);

        when(orderModel.getPaymentTransactions()).thenReturn(paymentTransactionModels);
        when(currencyModel.getIsocode()).thenReturn(CURRENCY_ISO_CODE_TEST);
        when(orderModel.getCurrency()).thenReturn(currencyModel);
        when(orderModel.getUser()).thenReturn(userModel);
        when(orderModel.getPaymentInfo()).thenReturn(paymentInfoModel);

        unit.doAuthorization(orderModel, amount);
        verify(modelService).refresh(paymentTransactionModel);
        verify(orderModel).getPaymentTransactions();
    }
}
