/*

 */
package com.paypal.hybris.core.service.impl;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_PROVIDER_NAME;
import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.commands.impl.DefaultPayPalConnectExchangeCodeToAccessTokenCommand;
import com.paypal.hybris.core.commands.impl.DefaultPayPalConnectGetUserInformationCommand;
import com.paypal.hybris.data.PayPalConnectAccessTokenData;
import com.paypal.hybris.data.PayPalConnectUserData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.payment.commands.factory.CommandFactory;
import de.hybris.platform.payment.commands.factory.CommandFactoryRegistry;
import de.hybris.platform.payment.commands.factory.CommandNotSupportedException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalConnectServiceTest {

    private static final String AUTHORIZATION_TOKEN = "authorizationToken";
    private static final String ACCESS_TOKEN = "accessToken";

    @Mock
    CommandFactoryRegistry commandFactoryRegistry;

    @InjectMocks
    private DefaultPayPalConnectService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void exchangeAuthorizationCodeToAccessTokenShouldReturnAccessToken() throws CommandNotSupportedException {

        final CommandFactory commandFactory = Mockito.mock(CommandFactory.class);
        final DefaultPayPalConnectExchangeCodeToAccessTokenCommand command = Mockito.mock(DefaultPayPalConnectExchangeCodeToAccessTokenCommand.class);
        final PayPalConnectAccessTokenData data = Mockito.mock(PayPalConnectAccessTokenData.class);

        when(commandFactoryRegistry.getFactory(PAYPAL_PROVIDER_NAME)).thenReturn(commandFactory);
        when(commandFactory.createCommand(DefaultPayPalConnectExchangeCodeToAccessTokenCommand.class)).thenReturn(command);
        when(command.perform(AUTHORIZATION_TOKEN)).thenReturn(data);
        when(data.getAccess_token()).thenReturn(ACCESS_TOKEN);

        assertEquals(ACCESS_TOKEN, unit.exchangeAuthorizationCodeToAccessToken(AUTHORIZATION_TOKEN));
        verify(command).perform(AUTHORIZATION_TOKEN);
    }

    @Test
    public void getUserDataByAccessTokenShouldReturnData() throws CommandNotSupportedException {

        final CommandFactory commandFactory = Mockito.mock(CommandFactory.class);
        final DefaultPayPalConnectGetUserInformationCommand command = Mockito.mock(DefaultPayPalConnectGetUserInformationCommand.class);
        final PayPalConnectUserData data = Mockito.mock(PayPalConnectUserData.class);

        when(commandFactoryRegistry.getFactory(PAYPAL_PROVIDER_NAME)).thenReturn(commandFactory);
        when(commandFactory.createCommand(DefaultPayPalConnectGetUserInformationCommand.class)).thenReturn(command);
        when(command.perform(ACCESS_TOKEN)).thenReturn(data);

        assertEquals(data, unit.getUserDataByAccessToken(ACCESS_TOKEN));
        verify(command).perform(ACCESS_TOKEN);
    }
}
