/*

 */
package com.paypal.hybris.core.service.impl;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.basecommerce.model.site.BaseSiteModel;
import de.hybris.platform.commerceservices.customer.DuplicateUidException;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.core.model.c2l.LanguageModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.event.EventService;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;
import de.hybris.platform.site.BaseSiteService;
import de.hybris.platform.store.BaseStoreModel;
import de.hybris.platform.store.services.BaseStoreService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalConnectCustomerAccountServiceTest {

    private static final String PASSWORD = "password";

    @Mock
    UserService userService;

    @Mock
    ModelService modelService;

    @Mock
    EventService eventService;

    @Mock
    BaseStoreService baseStoreService;

    @Mock
    BaseSiteService baseSiteService;

    @Mock
    CommonI18NService commonI18NService;

    @InjectMocks
    private DefaultPayPalConnectCustomerAccountService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldSaveCustomer() throws DuplicateUidException {
        final CustomerModel customer = Mockito.mock(CustomerModel.class);
        final BaseStoreModel baseStoreModel = Mockito.mock(BaseStoreModel.class);
        final BaseSiteModel baseSiteModel = Mockito.mock(BaseSiteModel.class);
        final LanguageModel languageModel = Mockito.mock(LanguageModel.class);
        final CurrencyModel currencyModel = Mockito.mock(CurrencyModel.class);

        when(baseStoreService.getCurrentBaseStore()).thenReturn(baseStoreModel);
        when(baseSiteService.getCurrentBaseSite()).thenReturn(baseSiteModel);
        when(commonI18NService.getCurrentLanguage()).thenReturn(languageModel);
        when(commonI18NService.getCurrentCurrency()).thenReturn(currencyModel);

        unit.register(customer, PASSWORD);
        verify(modelService).save(customer);
    }
}
