/**
 *
 */
package com.paypal.hybris.core.service.impl;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ACCEPTED_PAYMENT_METHODS;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_BILLING_AGREEMENT_ENABLED;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_EXPRESS_CHECKOUT_ENABLED;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_IMAGES_PREFIX;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_AUTHORIZE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_CAPTURE;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalConfigurationServiceTest {

    private static final String VISA_METHOD = "Visa";
    private static final String MASTERCARD_METHOD = "mastercard";
    private static final String VISA_IMAGE = "visaImage";
    private static final String MASTERCARD_IMAGE = "mastercardImage";
    private Configuration configuration;

    @Mock
    private ConfigurationService configurationService;

    @InjectMocks
    private DefaultPayPalConfigurationService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
        configuration = Mockito.mock(Configuration.class);
        when(configurationService.getConfiguration()).thenReturn(configuration);
    }

    @Test
    public void getAcceptedPaymentMethodImagesEmptyMap() {
        when(configuration.getString(PAYPAL_ACCEPTED_PAYMENT_METHODS)).thenReturn(StringUtils.EMPTY);

        final Map<String, String> result = unit.getAcceptedPaymentMethodImages();

        assertEquals(0, result.size());
    }

    @Test
    public void getAcceptedPaymentMethodImagesNotEmptyMap() {
        when(configuration.getString(PAYPAL_ACCEPTED_PAYMENT_METHODS)).thenReturn(VISA_METHOD + ";" + MASTERCARD_METHOD);
        when(configuration.getString(PAYPAL_IMAGES_PREFIX + VISA_METHOD)).thenReturn(VISA_IMAGE);
        when(configuration.getString(PAYPAL_IMAGES_PREFIX + MASTERCARD_METHOD)).thenReturn(MASTERCARD_IMAGE);

        final Map<String, String> result = unit.getAcceptedPaymentMethodImages();

        assertEquals(VISA_IMAGE, result.get(VISA_METHOD));
        assertEquals(MASTERCARD_IMAGE, result.get(MASTERCARD_METHOD));
    }

    @Test
    public void testIsExpressCheckoutEnabled() {
        when(configuration.getBoolean(PAYPAL_EXPRESS_CHECKOUT_ENABLED)).thenReturn(true);
        assertTrue(unit.isExpressCheckoutEnabled());
    }

    @Test
    public void testIsExpressCheckoutDisabled() {
        when(configuration.getBoolean(PAYPAL_EXPRESS_CHECKOUT_ENABLED)).thenReturn(false);
        assertFalse(unit.isExpressCheckoutEnabled());
    }

    @Test
    public void testIsBillingAgreementEnabled() {
        when(configuration.getBoolean(PAYPAL_BILLING_AGREEMENT_ENABLED)).thenReturn(true);
        assertTrue(unit.isBillingAgreementEnabled());
    }

    @Test
    public void testIsBillingAgreementDisabled() {
        when(configuration.getBoolean(PAYPAL_BILLING_AGREEMENT_ENABLED)).thenReturn(false);
        assertFalse(unit.isBillingAgreementEnabled());
    }

    @Test
    public void isCommitEnabled() {
        when(configuration.getBoolean(PAYPAL_BILLING_AGREEMENT_ENABLED)).thenReturn(false);
        when(configuration.getString(PAYPAL_INTENT, PAYPAL_INTENT_AUTHORIZE)).thenReturn(PAYPAL_INTENT_CAPTURE);

        assertTrue(unit.isCommitEnabled());
    }

    @Test
    public void isCommitDisabled() {
        when(configuration.getBoolean(PAYPAL_BILLING_AGREEMENT_ENABLED)).thenReturn(true);
        when(configuration.getString(PAYPAL_INTENT, PAYPAL_INTENT_AUTHORIZE)).thenReturn(PAYPAL_INTENT_AUTHORIZE);

        assertFalse(unit.isCommitEnabled());
    }
}
