/*

 */
package com.paypal.hybris.core.service.impl;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.dao.PayPalCartDao;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.CartModel;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalCartServiceTest {

    private static final String ORDER_ID = "orderId";

    @Mock
    private PayPalCartDao cartDao;

    @InjectMocks
    private DefaultPayPalCartService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getTransactionEntryByIdNotNull() {

        final CartModel entryModel = Mockito.mock(CartModel.class);

        when(cartDao.getCartForPayPalOrderId(ORDER_ID)).thenReturn(entryModel);

        assertNotNull(unit.getCartByPayPalOrderId(ORDER_ID));
    }

    @Test
    public void getTransactionEntryByIdIsNull() {

        when(cartDao.getCartForPayPalOrderId(ORDER_ID)).thenReturn(null);

        assertNull(unit.getCartByPayPalOrderId(ORDER_ID));
    }
}
