/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPaymentTransactionsDaoTest {

    private static final String TEST_ID = "testId";
    private PaymentTransactionEntryModel paymentTransactionEntryModel;

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private DefaultPaymentTransactionsDao paymentTransactionsDao;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        SearchResult searchResult = mock(SearchResult.class);

        List<PaymentTransactionEntryModel> paymentTransactionEntryModels = new ArrayList<>();
        paymentTransactionEntryModel = new PaymentTransactionEntryModel();
        paymentTransactionEntryModels.add(paymentTransactionEntryModel);

        when(searchResult.getResult()).thenReturn(paymentTransactionEntryModels);
        when(flexibleSearchService.search(any(FlexibleSearchQuery.class))).thenReturn(searchResult);
    }

    @Test
    public void getTransactionEntryByIdTest() {
        PaymentTransactionEntryModel result = paymentTransactionsDao.getTransactionEntryById(TEST_ID);
        Assert.assertEquals(paymentTransactionEntryModel, result);
    }
}
