/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import static junit.framework.Assert.assertNull;
import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.dao.PayPalPaymentInfoDao;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalPaymentInfoDaoTest {

    private static final String PAYER_ID = "PAYER_ID";

    private static final String BILLING_AGREEMENT_ID = "BILLING_AGREEMENT_ID";

    private static final String SEARCH_QUERY = "SELECT {pk} FROM {PayPalCreditCardPaymentInfo} WHERE {payerId}=?payerId "
        + "AND {billingAgreementId}=?billingAgreementId AND {duplicate}=?duplicate";

    public static final Boolean DUPLICATE = Boolean.FALSE;

    private static final int COUNT = 1;

    private static final int COUNT_ZERO = 0;

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private final PayPalPaymentInfoDao payPalPaymentInfoDao = new DefaultPayPalPaymentInfoDao();

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldFindPayPalPaymentInfo() {
        final PayPalCreditCardPaymentInfoModel expectedPayPalPaymentInfoModel = mock(PayPalCreditCardPaymentInfoModel.class);
        final SearchResult searchResult = mock(SearchResult.class);
        final Map queryParams = new HashMap();
        final List list = mock(List.class);
        queryParams.put("payerId", PAYER_ID);
        queryParams.put("billingAgreementId", BILLING_AGREEMENT_ID);
        queryParams.put("duplicate", DUPLICATE);
        when(flexibleSearchService.search(SEARCH_QUERY, queryParams)).thenReturn(searchResult);
        when(Integer.valueOf(searchResult.getCount())).thenReturn(Integer.valueOf(COUNT));
        when(searchResult.getResult()).thenReturn(list);
        when(list.get(0)).thenReturn(expectedPayPalPaymentInfoModel);

        final PayPalCreditCardPaymentInfoModel actualPayPalPaymentInfoModel = payPalPaymentInfoDao
            .find(PAYER_ID,
                BILLING_AGREEMENT_ID);

        assertEquals(expectedPayPalPaymentInfoModel, actualPayPalPaymentInfoModel);
    }

    @Test
    public void shouldNotFindPayPalPaymentInfo() {

        final SearchResult searchResult = mock(SearchResult.class);
        final Map queryParams = new HashMap();
        queryParams.put("payerId", PAYER_ID);
        queryParams.put("billingAgreementId", BILLING_AGREEMENT_ID);
        queryParams.put("duplicate", DUPLICATE);
        when(flexibleSearchService.search(SEARCH_QUERY, queryParams)).thenReturn(searchResult);
        when(Integer.valueOf(searchResult.getCount())).thenReturn(Integer.valueOf(COUNT_ZERO));

        final PayPalCreditCardPaymentInfoModel actualPayPalPaymentInfoModel = payPalPaymentInfoDao
            .find(PAYER_ID,
                BILLING_AGREEMENT_ID);

        assertNull(actualPayPalPaymentInfoModel);
    }

}
