/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalCustomerAccountDaoTest {

    private static final String BILLING_AGREEMENT_ID = "BILLING_AGREEMENT_ID";

    private static final int COUNT = 1;

    private static final int ZERO = 0;

    private static final String CUSTOMER_SEARCH_QUERY = "SELECT {customer:pk} FROM {Customer as customer JOIN PayPalCreditCardPaymentInfo"
        + " as paypalPaymentInfo ON {customer:pk} = {paypalPaymentInfo:user}} WHERE {paypalPaymentInfo:billingAgreementId} "
        + "= ?billingAgreementId AND {paypalPaymentInfo:duplicate} = ?duplicate";

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private final DefaultPayPalCustomerAccountDao payPalCustomerAccountDao = new DefaultPayPalCustomerAccountDao();

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldFindCustomerByBillingAgreementId() {
        final CustomerModel expectedCustomerModel = mock(CustomerModel.class);
        final SearchResult searchResult = mock(SearchResult.class);
        final List list = mock(List.class);
        final Map queryParams = new HashMap();
        queryParams.put("billingAgreementId", BILLING_AGREEMENT_ID);
        queryParams.put("duplicate", false);
        when(flexibleSearchService.search(CUSTOMER_SEARCH_QUERY, queryParams)).thenReturn(searchResult);
        when(Integer.valueOf(searchResult.getCount())).thenReturn(Integer.valueOf(COUNT));
        when(searchResult.getResult()).thenReturn(list);
        when(list.get(0)).thenReturn(expectedCustomerModel);

        final CustomerModel actualCustomerModel = payPalCustomerAccountDao
            .findCustomerByBillingAgreementId(BILLING_AGREEMENT_ID);

        assertEquals(expectedCustomerModel, actualCustomerModel);

    }

    @Test
    public void shouldNotFindCustomerByBillingAgreementId() {
        final SearchResult searchResult = mock(SearchResult.class);
        final Map queryParams = new HashMap();
        queryParams.put("billingAgreementId", BILLING_AGREEMENT_ID);
        queryParams.put("duplicate", false);
        when(flexibleSearchService.search(CUSTOMER_SEARCH_QUERY, queryParams)).thenReturn(searchResult);
        when(Integer.valueOf(searchResult.getCount())).thenReturn(Integer.valueOf(ZERO));

        final CustomerModel actualCustomerModel = payPalCustomerAccountDao
            .findCustomerByBillingAgreementId(BILLING_AGREEMENT_ID);

        assertNull( actualCustomerModel);

    }

}
