/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import static com.paypal.hybris.core.dao.impl.DefaultPayPalCartToOrderCronJobDao.GET_CRON_JOB_BY_BILLING_AGREEMENT;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalCartToOrderCronJobDaoTest {

    private static final String BILLING_AGREEMENT_ID = "BILLING_AGREEMENT_ID";

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private DefaultPayPalCartToOrderCronJobDao unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void findCronJobsByPaymentMethodTokenShouldReturnExceptedList() {
        List<CartToOrderCronJobModel> exceptedList = new ArrayList<>();
        final Map<String, Object> params = new HashMap<String, Object>();
        params.put("billingAgreement", BILLING_AGREEMENT_ID);
        params.put("duplicate", Boolean.FALSE);
        FlexibleSearchQuery flexibleSearchQuery = new FlexibleSearchQuery(GET_CRON_JOB_BY_BILLING_AGREEMENT);
        flexibleSearchQuery.addQueryParameters(params);
        flexibleSearchQuery.setResultClassList(Collections.singletonList(CartToOrderCronJobModel.class));
        SearchResult<CartToOrderCronJobModel> searchResult = Mockito.mock(SearchResult.class);
        when(flexibleSearchService.<CartToOrderCronJobModel>search(flexibleSearchQuery)).thenReturn(searchResult);
        when(searchResult.getResult()).thenReturn(exceptedList);

        List<CartToOrderCronJobModel> actualList = unit.findCronJobsByBillingAgreement(BILLING_AGREEMENT_ID);
        Assert.assertSame(exceptedList, actualList);
        verify(flexibleSearchService.search(flexibleSearchQuery));
    }

}
