/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalCartDaoTest {

    private static final String TEST_ID = "testId";

    private CartModel cartModel;

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private DefaultPayPalCartDao payPalCartDao;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        SearchResult searchResult = mock(SearchResult.class);

        List<CartModel> carts = new ArrayList<>();
        cartModel = new CartModel();
        carts.add(cartModel);

        when(flexibleSearchService.search(any(FlexibleSearchQuery.class))).thenReturn(searchResult);
        when(searchResult.getResult()).thenReturn(carts);
    }

    @Test
    public void getCartForPayPalOrderIdTest() {
        CartModel result = payPalCartDao.getCartForPayPalOrderId(TEST_ID);
        Assert.assertEquals(cartModel, result);
    }
}
