package com.paypal.hybris.core.strategy.impl;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentService;
import de.hybris.platform.commerceservices.order.CommercePaymentAuthorizationStrategy;
import de.hybris.platform.commerceservices.order.impl.DefaultCommercePaymentAuthorizationStrategy;
import de.hybris.platform.commerceservices.service.data.CommerceCheckoutParameter;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;

import java.math.BigDecimal;
import java.util.Currency;


public class DefaultPayPalBillingAgreementPaymentAuthorizationStrategy extends DefaultCommercePaymentAuthorizationStrategy
    implements CommercePaymentAuthorizationStrategy {

    private PayPalPaymentService payPalPaymentService;

    @Override
    public PaymentTransactionEntryModel authorizePaymentAmount(final CommerceCheckoutParameter parameter) {
        final CartModel cartModel = parameter.getCart();
        final BigDecimal amount = parameter.getAuthorizationAmount();
        final String paymentProvider = parameter.getPaymentProvider();

        PaymentTransactionEntryModel transactionEntryModel = null;
        try {
            beforeAuthorizePaymentAmount(parameter);
            final PaymentInfoModel paymentInfo = cartModel.getPaymentInfo();
            if (paymentInfo instanceof PayPalCreditCardPaymentInfoModel) {
                final Currency currency = getI18nService()
                    .getBestMatchingJavaCurrency(cartModel.getCurrency().getIsocode());
                final String merchantTransactionCode = getGenerateMerchantTransactionCodeStrategy()
                    .generateCode(cartModel);
                transactionEntryModel = getPayPalPaymentService()
                    .createStubAuthorize(merchantTransactionCode, amount, currency, paymentProvider,
                        (PayPalCreditCardPaymentInfoModel) paymentInfo);
                final PaymentTransactionModel paymentTransaction = transactionEntryModel.getPaymentTransaction();
                paymentTransaction.setOrder(cartModel);
                paymentTransaction.setInfo(paymentInfo);
                getModelService().saveAll(cartModel, paymentTransaction);
            }
            return transactionEntryModel;
        } finally {
            afterAuthorizePaymentAmount(parameter, transactionEntryModel);
        }
    }

    public PayPalPaymentService getPayPalPaymentService() {
        return payPalPaymentService;
    }

    public void setPayPalPaymentService(PayPalPaymentService payPalPaymentService) {
        this.payPalPaymentService = payPalPaymentService;
    }
}
