/**
 *
 */
package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PayPalCartToOrderCronJobDao;
import com.paypal.hybris.core.service.PayPalReplenishmentService;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.servicelayer.model.ModelService;
import java.util.List;

/**
 * This class is a default implementation of the PayPalReplenishmentService interface
 */
public class DefaultPayPalReplenishmentService implements PayPalReplenishmentService {

        private PayPalCartToOrderCronJobDao cartToOrderDao;
        private ModelService modelService;

        @Override
        public void disableReplenishmentCronJobByBillingAgreement(String billingAgreement) {
            List<CartToOrderCronJobModel> replenishmentCronJobs =
                cartToOrderDao.findCronJobsByBillingAgreement(billingAgreement);
            if (replenishmentCronJobs != null) {
                replenishmentCronJobs.forEach(cartToOrderCronJobModel -> {
                    cartToOrderCronJobModel.setActive(Boolean.FALSE);
                    modelService.save(cartToOrderCronJobModel);
                });
            }
        }

        public PayPalCartToOrderCronJobDao getCartToOrderDao() {
            return cartToOrderDao;
        }

        public void setCartToOrderDao(PayPalCartToOrderCronJobDao cartToOrderDao) {
            this.cartToOrderDao = cartToOrderDao;
        }

        public ModelService getModelService() {
            return modelService;
        }

        public void setModelService(ModelService modelService) {
            this.modelService = modelService;
        }

}
