/**
 *
 */
package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PayPalCustomerAccountDao;
import com.paypal.hybris.core.dao.PayPalPaymentInfoDao;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentInfoService;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import org.apache.log4j.Logger;

/**
 * This class is a default implementation of PayPalPaymentInfoService interface
 */
public class DefaultPayPalPaymentInfoService implements PayPalPaymentInfoService {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalPaymentInfoService.class);

    private PayPalPaymentInfoDao payPalPaymentInfoDao;
    private PayPalCustomerAccountDao payPalCustomerAccountDao;
    private ModelService modelService;
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;
    private FlexibleSearchService flexibleSearchService;

    @Override
    public void disable(final String payerId, final String billingAgreementId) {
        final PayPalCreditCardPaymentInfoModel paymentInfoModel = getPayPalPaymentInfoDao().find(payerId,
            billingAgreementId);
        final CustomerModel customerModel = getPayPalCustomerAccountDao().findCustomerByBillingAgreementId(billingAgreementId);
        if ((customerModel!=null && paymentInfoModel!=null) && customerModel.getPaymentInfos().contains(paymentInfoModel)) {
            paymentInfoModel.setDuplicate(true);
            getModelService().save(paymentInfoModel);
            getModelService().refresh(customerModel);
        } else {
            LOG.info("Payment Info " + paymentInfoModel
                + " does not belong to the customer " + customerModel + " and will not be removed.");
        }
    }

    public PayPalPaymentInfoDao getPayPalPaymentInfoDao() {
        return payPalPaymentInfoDao;
    }

    public void setPayPalPaymentInfoDao(final PayPalPaymentInfoDao payPalPaymentInfoDao) {
        this.payPalPaymentInfoDao = payPalPaymentInfoDao;
    }

    public ModelService getModelService() {
        return modelService;
    }

    public void setModelService(final ModelService modelService) {
        this.modelService = modelService;
    }

    public PayPalCustomerAccountDao getPayPalCustomerAccountDao() {
        return payPalCustomerAccountDao;
    }

    public void setPayPalCustomerAccountDao(final PayPalCustomerAccountDao payPalCustomerAccountDao) {
        this.payPalCustomerAccountDao = payPalCustomerAccountDao;
    }

    public DefaultPayPalConfigurationService getDefaultPayPalConfigurationService() {
        return defaultPayPalConfigurationService;
    }

    public void setDefaultPayPalConfigurationService(final DefaultPayPalConfigurationService defaultPayPalConfigurationService) {
        this.defaultPayPalConfigurationService = defaultPayPalConfigurationService;
    }

    public FlexibleSearchService getFlexibleSearchService() {
        return flexibleSearchService;
    }

    public void setFlexibleSearchService(FlexibleSearchService flexibleSearchService) {
        this.flexibleSearchService = flexibleSearchService;
    }

}
