/*

 */
package com.paypal.hybris.core.service.impl;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_PROVIDER_NAME;

import com.paypal.hybris.core.commands.impl.DefaultPayPalConnectExchangeCodeToAccessTokenCommand;
import com.paypal.hybris.core.commands.impl.DefaultPayPalConnectGetUserInformationCommand;
import com.paypal.hybris.core.exception.PayPalConnectException;
import com.paypal.hybris.core.service.PayPalConnectService;
import com.paypal.hybris.data.PayPalConnectUserData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.factory.CommandFactory;
import de.hybris.platform.payment.commands.factory.CommandFactoryRegistry;
import de.hybris.platform.payment.commands.factory.CommandNotSupportedException;
import org.apache.log4j.Logger;

/**
 * This class is a default implementation of the PayPalConnectService interface
 */
public class DefaultPayPalConnectService implements PayPalConnectService {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalConnectService.class);

    private CommandFactoryRegistry commandFactoryRegistry;

    @Override
    public String exchangeAuthorizationCodeToAccessToken(String authorizationToken) {
        try {
            CommandFactory commandFactory = getCommandFactoryRegistry().getFactory(PAYPAL_PROVIDER_NAME);
            DefaultPayPalConnectExchangeCodeToAccessTokenCommand command = commandFactory
                .createCommand(DefaultPayPalConnectExchangeCodeToAccessTokenCommand.class);
            return command.perform(authorizationToken).getAccess_token();
        } catch (CommandNotSupportedException | AdapterException e) {
            String message = "Exception, message : " + e.getMessage();
            LOG.error(message, e);
            throw new PayPalConnectException(e);
        }
    }

    @Override
    public PayPalConnectUserData getUserDataByAccessToken(String accessToken) {
        try {
            CommandFactory commandFactory = getCommandFactoryRegistry().getFactory(PAYPAL_PROVIDER_NAME);
            DefaultPayPalConnectGetUserInformationCommand command = commandFactory
                .createCommand(DefaultPayPalConnectGetUserInformationCommand.class);
            return command.perform(accessToken);
        } catch (CommandNotSupportedException e) {
            String message = "Exception, message : " + e.getMessage();
            LOG.error(message, e);
            throw new AdapterException(e);
        }
    }

    public CommandFactoryRegistry getCommandFactoryRegistry() {
        return commandFactoryRegistry;
    }

    public void setCommandFactoryRegistry(
        CommandFactoryRegistry commandFactoryRegistry) {
        this.commandFactoryRegistry = commandFactoryRegistry;
    }

}
