/*

 */
package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_CHECKOUT_RETURN_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_RESPONSE_TYPE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_RETURN_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_SCOPES;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_SCRIPT;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.LPM_FUNDING_LIST;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_COMMA;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_EMPTY_STRING;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_EXPRESS_CHECKOUT_ENABLED;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_BILLING_AGREEMENT_ENABLED;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_CAPTURE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.CLIENT_ID;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_PARTNER_ATTRIBUTION_ID;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_PAYLATER_FOR_NON_US_COUNTRIES;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_VENMO_ENABLED;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.SECRET_KEY;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ENV_CONFIGURATION;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_API_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_SDK_JS_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_AUTHORIZE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_CART_PAGE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_MINI_CART;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_DISABLE_FUNDING_MARK_PAGE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CUSTOM_BILLING_AGREEMENT_DESCRIPTION;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ACCEPTED_PAYMENT_METHODS;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ACCEPTED_PAYMENT_METHODS_DELIMETER;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_IMAGES_PREFIX;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_NONDECIMAL_CURRENCY;

/**
 * This class is a default implementation of the PayPalConfigurationService interface
 */
public class DefaultPayPalConfigurationService implements PayPalConfigurationService {

    private static final String BUYER_COUNTRY = "buyer.country";
    private static final String LPM_LOCALE = "lpm.locale";

    private ConfigurationService configurationService;

    @Override
    public Map<String, String> getAcceptedPaymentMethodImages() {
        final Map<String, String> acceptedPaymentMethodImages = new HashMap<>();
        final String acceptedPaymentMethods = getConfigurationService().getConfiguration()
            .getString(PAYPAL_ACCEPTED_PAYMENT_METHODS);
        if (StringUtils.isNotBlank(acceptedPaymentMethods)) {
            final String paymentMethods = StringUtils.deleteWhitespace(acceptedPaymentMethods);

            final String[] paymentMethodList = StringUtils
                .split(paymentMethods, PAYPAL_ACCEPTED_PAYMENT_METHODS_DELIMETER);

            for (final String paymentMethod : paymentMethodList) {
                final String imageLink = getConfigurationService().getConfiguration()
                    .getString(PAYPAL_IMAGES_PREFIX + paymentMethod);
                if (StringUtils.isNotBlank(imageLink)) {
                    acceptedPaymentMethodImages.put(paymentMethod, imageLink);
                }
            }
        }

        return acceptedPaymentMethodImages;
    }

    public boolean isExpressCheckoutEnabled() {
        return configurationService.getConfiguration().getBoolean(PAYPAL_EXPRESS_CHECKOUT_ENABLED);
    }

    public boolean isBillingAgreementEnabled() {
        return configurationService.getConfiguration().getBoolean(PAYPAL_BILLING_AGREEMENT_ENABLED);
    }

    public boolean isVenmoEnabled() {
        return configurationService.getConfiguration().getBoolean(PAYPAL_VENMO_ENABLED);
    }

    public boolean isPayLaterEnabledForNonUsCountries() {
        return configurationService.getConfiguration().getBoolean(PAYPAL_PAYLATER_FOR_NON_US_COUNTRIES);
    }

    public boolean isCommitEnabled() {
        return !isBillingAgreementEnabled() && getPayPalIntent().equalsIgnoreCase(PAYPAL_INTENT_CAPTURE);
    }

    public boolean isReplenishmentAvailable() {
        return isBillingAgreementEnabled();
    }

    public String getClientID() {
        return configurationService.getConfiguration().getString(CLIENT_ID);
    }

    public String getPayPalPartnerAttributionId() {
        return configurationService.getConfiguration().getString(PAYPAL_PARTNER_ATTRIBUTION_ID);
    }

    public String getSecretKey() {
        return getConfigurationService().getConfiguration().getString(SECRET_KEY);
    }

    public String getEnvironmentType() {
        return getConfigurationService().getConfiguration().getString(PAYPAL_ENV_CONFIGURATION);
    }

    public String getPayPalApiUrl() {
        return getConfigurationService().getConfiguration().getString(PAYPAL_API_URL);
    }

    public String getPayPalSdkJsUrl() {
        return getConfigurationService().getConfiguration().getString(PAYPAL_SDK_JS_URL);
    }

    public String getPayPalIntent() {
        return configurationService.getConfiguration().getString(PAYPAL_INTENT, PAYPAL_INTENT_AUTHORIZE);
    }

    public String getDisableFundingCartPage() {
        return String.format("%s%s%s", LPM_FUNDING_LIST, isSeparatorNeeded(PAYPAL_DISABLE_FUNDING_CART_PAGE),
            configurationService.getConfiguration().getString(PAYPAL_DISABLE_FUNDING_CART_PAGE));
    }

    public String getDisableFundingMiniCart() {
        return String.format("%s%s%s", LPM_FUNDING_LIST, isSeparatorNeeded(PAYPAL_DISABLE_FUNDING_MINI_CART),
            configurationService.getConfiguration().getString(PAYPAL_DISABLE_FUNDING_MINI_CART));
    }

    private String isSeparatorNeeded(final String key) {
        String string = configurationService.getConfiguration().getString(key);
        return string.isEmpty() ? PAYPAL_EMPTY_STRING : PAYPAL_COMMA;
    }

    public String getNonDecimalCurrency() {
        return configurationService.getConfiguration().getString(PAYPAL_NONDECIMAL_CURRENCY);
    }

    public String getDisableFundingMarkPage() {
        return configurationService.getConfiguration().getString(PAYPAL_DISABLE_FUNDING_MARK_PAGE);
    }

    public String getCustomBillingAgreementDescription() {
        return configurationService.getConfiguration().getString(PAYPAL_CUSTOM_BILLING_AGREEMENT_DESCRIPTION);
    }

    public String getPayPalConnectScript() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_SCRIPT);
    }

    public String getPayPalConnectScopes() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_SCOPES);
    }

    public String getPayPalConnectResponseType() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_RESPONSE_TYPE);
    }

    public String getPayPalConnectReturnUrl() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_RETURN_URL);
    }

    public String getPayPalConnectCheckoutReturnUrl() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_CHECKOUT_RETURN_URL);
    }

    public String getBuyerCountry() {
        return configurationService.getConfiguration().getString(BUYER_COUNTRY);
    }

    public String getLPMLocale() {
        return configurationService.getConfiguration().getString(LPM_LOCALE);
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ConfigurationService getConfigurationService() {
        return configurationService;
    }

}
