/*

 */
package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PayPalCartDao;
import com.paypal.hybris.core.service.PayPalCartService;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.order.impl.DefaultCartService;
import javax.annotation.Resource;

/**
 * This class is a default implementation of the PayPalCartService interface
 */
public class DefaultPayPalCartService extends DefaultCartService implements PayPalCartService {

    @Resource(name = "payPalCartDao")
    private PayPalCartDao cartDao;

    @Override
    public CartModel getCartByPayPalOrderId(String payPalOrderId) {
        return cartDao.getCartForPayPalOrderId(payPalOrderId);
    }
}
