package com.paypal.hybris.core.service;

import com.paypal.api.payments.Event;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.data.PayPalAddressDetailsData;
import com.paypal.hybris.data.PayPalBillingAgreementData;
import com.paypal.hybris.data.PayPalBillingAgreementTokenData;
import com.paypal.hybris.data.PayPalOrderDetailsData;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.PaymentService;
import de.hybris.platform.payment.commands.request.CaptureRequest;
import de.hybris.platform.payment.commands.request.SubscriptionAuthorizationRequest;
import de.hybris.platform.payment.commands.result.AuthorizationResult;
import de.hybris.platform.payment.commands.result.CaptureResult;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;

import java.math.BigDecimal;
import java.util.Currency;


public interface PayPalPaymentService extends PaymentService {

    PaymentTransactionEntryModel createStubAuthorize(final String merchantTransactionCode, final BigDecimal amount,
        final Currency currency, final String paymentProvider, PayPalCreditCardPaymentInfoModel paymentInfo);

    AuthorizationResult reauthorize(SubscriptionAuthorizationRequest request);

    void doCancel(OrderModel order);

    public Event getEventById(String eventId);

    PayPalOrderDetailsData getOrderDetails(final String payPalOrderId);

    Boolean updateOrderAmountDetails(final String orderId, final String currency, final String orderAmount);

    PayPalBillingAgreementTokenData createBillingAgreementToken(boolean skipShippingAddress);

    PayPalBillingAgreementData createBillingAgreement(final String billingAgreementToken);

    String createOrder(final String currency, final String orderAmount, PayPalAddressDetailsData addressDetailsData);

    CaptureResult doCaptureIntentRequest(CaptureRequest request);

    PaymentTransactionEntryModel refund(PaymentTransactionEntryModel selectedEntry, BigDecimal amount);

}
