package com.paypal.hybris.core.service;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.CustomerModel;


public interface PayPalCustomerAccountService {

    PayPalCreditCardPaymentInfoModel createPayPalPaymentSubscription(final CustomerModel customerModel,
        final CCPaymentInfoData ccPaymentInfoData, final AddressModel addressModel);

    PayPalCreditCardPaymentInfoModel updatePayPalPaymentSubscription(final CustomerModel customerModel,
        final CCPaymentInfoData ccPaymentInfoData, final AddressModel addressModel,
        PayPalCreditCardPaymentInfoModel paymentInfo);

    /**
     * This method is used to get customer data by payer id
     * @param payerId payer id
     * @return customer data
     */
    CustomerData getCustomerByPayerId(final String payerId);

    /**
     * This method checks if Customer Exist
     * @param payerId payerId
     * @return if customer exist
     */
    boolean isCustomerWithPayerIdExist(final String payerId);

    String setTempPassword(final String payerId);

    /**
     * This method clears temp password
     * @param payerId payerId
     */
    void clearTempPassword(final String payerId);
}
